<?php

namespace App\Services\Business;

use App\Http\Controllers\Api\Verify\MemberManage\VerifyMemberLabelController;
use App\Services\CommonService;
use App\Services\LoginUserService;
use App\Services\Point\PointService;
use App\Services\Shop\ShopService;
use BlueCity\Core\Service\Service;
use App\Http\Models\Api\Common;
use Illuminate\Support\Facades\DB;
use App\Models\Common as Comm;

// 会员等级
class MemberLabelService extends Service
{


    //获取列表信息
    public static function list($request)
    {
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;
        $list_data = DB::table('label')
            ->where('mela_cid', $user_info->adm_cid)
            ->where('mela_shop_id', $shop_id)
            ->where('mela_is_show', 1)
            ->orderBy('mela_id', 'desc')
            ->get()->toArray();
        if ($list_data) {
            return ['code' => 200, 'msg' => '成功', 'data' => $list_data];
        } else {
            return ['code' => 200, 'msg' => '暂无数据', 'data' => []];
        }
    }

    //获取列表全部信息
    public static function allIndex($request)
    {
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->adm_shop_id;
        $list_data = DB::table('label')
            ->where('mela_cid', $user_info->adm_cid)
            ->where('mela_shop_id', $shop_id)
            ->orderBy('mela_id', 'desc')
            ->get()->toArray();
        if ($list_data) {
            return ['code' => 200, 'msg' => '成功', 'data' => $list_data];
        } else {
            return ['code' => 200, 'msg' => '暂无数据', 'data' => []];
        }
    }

    //添加
    public static function add($user_info,$request)
    {
        // 验证数据
        $verify_data = new VerifyMemberLabelController;
        $error_message = $verify_data->addValidator($request);
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        $data = DB::table('label')
            ->where('mela_cid', $user_info->adm_cid)
            ->where('mela_shop_id', $user_info->adm_shop_id)
            ->where('mela_name', $request['mela_name'])
            ->count();
        if($data > 0){
            return ['code' => 500, 'msg' => '该标签已添加,请勿重复添加', 'data' => ''];
        }
        $add_data['mela_name'] = $request['mela_name'];//标签名称
        $add_data['mela_cid'] = $user_info->adm_cid;//
        $add_data['mela_shop_id'] = $user_info->adm_shop_id;//
        $ret_id =  DB::table('label')->insertGetId($add_data);
        if ($ret_id) {
            return ['code' => 200, 'msg' => '新增成功', 'data' =>''];
        } else {
            return ['code' => 500, 'msg' => '新增失败', 'data' => ''];
        }
    }

    //删除
    public static function editStatus($request)
    {
        // 验证数据
        $verify_data = new VerifyMemberLabelController;
        $error_message = $verify_data->delValidator($request); //验证编辑id是否存在
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        $del_res = DB::table('label')
            ->where('mela_id', $request['mela_id'])
            ->update(['mela_is_show'=>$request['mela_is_show']]);
        if ($del_res) {
            return ['code' => 200, 'msg' => '修改成功', 'data' =>''];
        } else {
            return ['code' => 500, 'msg' => '修改失败', 'data' => ''];
        }
    }

    //编辑
    public static function edit($user_info,$request)
    {
        // 验证数据
        $verify_data = new VerifyMemberLabelController;
        $error_message = $verify_data->editValidator($request); //验证编辑id是否存在
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        $cdata = DB::table('label')
            ->where('mela_cid', $user_info->adm_cid)
            ->where('mela_shop_id', $user_info->adm_shop_id)
            ->where('mela_name', $request['mela_name'])
            ->where('mela_id','<>', $request['mela_id'])
            ->count();
        if($cdata > 0){
            return ['code' => 500, 'msg' => '该标签已添加,请勿重复添加', 'data' => ''];
        }
        $update_data['mela_name'] = $request['mela_name'];
        if($request['mela_id'] && $update_data){
            $data = DB::table('label')
                ->where('mela_id', $request['mela_id'])
                ->update($update_data);
            return ['code' => 200, 'msg' => '编辑成功', 'data' =>''];
        }
        return ['code' => 500, 'msg' => '数据不存在', 'data' =>''];
    }

    //给会员添加标签
    public static function addLabelToMember($mem_id,$mem_label,$user_info)
    {
        $data = DB::table('member_label')
            ->where('melal_mem_id', $mem_id)
            ->delete();
        if($mem_label){
            foreach ($mem_label as $key => $value){
                if($value){
                    $add_data['melal_cid'] = $user_info->adm_cid;//
                    $add_data['melal_shop_id'] = $user_info->adm_shop_id;//
                    $add_data['melal_label_id'] = $value;//标签id
                    $add_data['melal_mem_id'] = $mem_id;
                    $ret_id =  DB::table('member_label')->insertGetId($add_data);
                }
            }
            return ['code' => 200, 'msg' => '成功', 'data' =>''];
        }
        return ['code' => 200, 'msg' => '无需添加', 'data' => ''];
    }


}