<?php

namespace App\Services\Business;

use App\Http\Controllers\Api\Verify\MemberManage\VerifyFestivalRemindController;
use App\Http\Controllers\Api\Verify\MemberManage\VerifyMemberListController;
use App\Models\Business\Reservation;
use App\Services\CommonService;
use App\Services\Shop\ShopService;
use BlueCity\Core\Service\Service;
use App\Http\Models\Api\Common;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Business\ReservationValidator;
use BlueCity\Core\Inc\ErrorInc;

// 节日提醒
class FestivalRemindService extends Service
{


    // 列表
    public static function index($request)
    {
        // 验证数据
        $verify_data = new VerifyFestivalRemindController;
        $error_message = $verify_data->indexValidator($request);
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $search_data = $request;
        $type = $search_data['type']??1;//默认显示节日列表
        $list_data = DB::table('festival_remind')
            ->where('fest_cid', $user_info->adm_cid)
            ->where('fest_superior_shop_id', $shop_id)
            ->where('fest_type', $type)
            ->where('fest_status', 1)
            ->orderBy('fest_id', 'desc')
            ->paginate(10);
        $list_items = $list_data->items();
        // 获取当前列表下的按钮
        $list_button = getListButton($search_data['api_token'], $search_data['pri_id']);
        //查找店铺会员标签
        $find_label = DB::table('label')
            ->where('mela_cid', $user_info->adm_cid)
            ->where('mela_shop_id', $shop_id)
            ->where('mela_is_show', 1)
            ->get()->toArray();
        if(!empty($find_label)){
            foreach ($find_label as $key_label => $value_label){
                $label[$value_label->mela_id] = $value_label->mela_name;
            }
        }
        if ($list_items) {
            foreach ($list_items as $key => $value) {
                if($value->fest_date == '0000-00-00'){
                    $list_items[$key]->fest_date = '';
                }
                if($value->fest_effective_start_date == '0000-00-00'){
                    $list_items[$key]->fest_effective_start_date = '';
                }
                if($value->fest_effective_end_date == '0000-00-00'){
                    $list_items[$key]->fest_effective_end_date = '';
                }
                $list_items[$key]->fest_label_name = '';
                if(!empty($value->fest_label)){
                    $label_arr = explode(',',$value->fest_label);
                    foreach ($label_arr as $ka => $va){
                        if(isset($label[$va])){
                            $label_name[] = $label[$va];
                        }
                    }
                    if(!empty($label_name)){
                        $fest_label_name = implode(',',$label_name);
                        $list_items[$key]->fest_label_name = $fest_label_name;
                    }
                }
                //按钮
                $buttonData[] = 'edite';
                if($value->fest_default == 2){
                    $buttonData[] = 'edit';
                }
                $buttonData[] = 'send';
                $button = CommonService::getListButton($buttonData,$list_button);
                $list_items[$key]->button_one = $button['button_one']??[];
                $list_items[$key]->button_two = $button['button_two']??[];
                $list_items[$key]->button_three = $button['button_three']??[];
                unset($buttonData);
            }
        }else{//如果没有节日列表，就去添加默认节日
            ShopService::addFestival($shop_id);
            $list_data = DB::table('festival_remind')
                ->where('fest_cid', $user_info->adm_cid)
                ->where('fest_superior_shop_id', $shop_id)
                ->where('fest_type', $type)
                ->where('fest_status', 1)
                ->orderBy('fest_id', 'desc')
                ->paginate(10);
            $list_items = $list_data->items();
            // 获取当前列表下的按钮
            $list_button = getListButton($search_data['api_token'], $search_data['pri_id']);
            if ($list_items) {
                foreach ($list_items as $key => $value) {
                    if($value->fest_date == '0000-00-00'){
                        $list_items[$key]->fest_date = '';
                    }
                    if($value->fest_effective_start_date == '0000-00-00'){
                        $list_items[$key]->fest_effective_start_date = '';
                    }
                    if($value->fest_effective_end_date == '0000-00-00'){
                        $list_items[$key]->fest_effective_end_date = '';
                    }
                    $list_items[$key]->fest_label_name = '';
                    if(!empty($value->fest_label)){
                        $label_arr = explode(',',$value->fest_label);
                        foreach ($label_arr as $ka => $va){
                            if(isset($label[$va])){
                                $label_name[] = $label[$va];
                            }
                        }
                        if(!empty($label_name)){
                            $fest_label_name = implode(',',$label_name);
                            $list_items[$key]->fest_label_name = $fest_label_name;
                        }
                    }
                    //按钮
                    $buttonData[] = 'edite';
                    if($value->fest_default == 2){
                        $buttonData[] = 'edit';
                    }
                    $buttonData[] = 'send';
                    $button = CommonService::getListButton($buttonData,$list_button);
                    $list_items[$key]->button_one = $button['button_one']??[];
                    $list_items[$key]->button_two = $button['button_two']??[];
                    $list_items[$key]->button_three = $button['button_three']??[];
                }
            }

        }
        $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
        $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data_info['total'] = $list_data->total();               //总数据个数
        $data_info['current_number'] = 10;       //一页显示多少个
        $data_info['data'] = $list_items;                //返回数据
        if ($list_data) {
            return ['code' => 200, 'msg' => 'success', 'data' => $data_info];
        } else {
            return ['code' => 500, 'msg' => '暂无数据', 'data' => '暂无数据'];
        }
    }

    // 编辑
    public static function edit($request)
    {
        // 验证数据
        $verify_data = new VerifyFestivalRemindController;
        $error_message = $verify_data->editValidator($request); //验证编辑id是否存在
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $data = DB::table('festival_remind')
            ->where('fest_cid', $user_info->adm_cid)
            ->where('fest_shop_id', $shop_id)
            ->where('fest_id', $request['fest_id'])
            ->first();

        if($request['type'] == 1){//获取节日内容
            if ($data) {
                if($data->fest_effective_start_date == '0000-00-00'){
                    $data->fest_effective_start_date = '';
                }
                if($data->fest_effective_end_date == '0000-00-00'){
                    $data->fest_effective_end_date = '';
                }
                return ['code' => 200, 'msg' => '获取节日成功', 'data' => $data];
            } else {
                return ['code' => 500, 'msg' => '获取节日失败', 'data' => '获取节日失败'];
            }
        }else{//修改节日内容
            if(isset($request['fest_name'])){
                $fest_edit_data['fest_name'] = $request['fest_name'];
            }
            if(isset($request['fest_date'])){
                $fest_edit_data['fest_date'] = $request['fest_date'];
            }
            if(isset($request['fest_days'])){
                $fest_edit_data['fest_days'] = $request['fest_days'];
            }
            if(isset($request['fest_content'])){
                $fest_edit_data['fest_content'] = $request['fest_content'];
            }
            if(isset($request['fest_start'])){
                $fest_edit_data['fest_start'] = $request['fest_start'];
            }
            if(isset($request['fest_is_send'])){
                $fest_edit_data['fest_is_send'] = $request['fest_is_send'];
            }
            if(isset($request['fest_name'])){
                $fest_edit_data['fest_name'] = $request['fest_name'];
            }
            if(isset($request['fest_status'])){
                $fest_edit_data['fest_status'] = $request['fest_status'];
            }
            if(isset($request['fest_label'])){
                $fest_edit_data['fest_label'] = $request['fest_label'];
            }
            if($request['type'] == 3){
                $fest_edit_data['fest_effective_start_date'] = $request['fest_effective_start_date']??'';
                $fest_edit_data['fest_effective_end_date'] = $request['fest_effective_end_date']??'';
                $fest_edit_data['fest_car_series'] = $request['fest_car_series']??'';
                $fest_edit_data['fest_sex'] = $request['fest_sex']??3;
            }
            $fest_edit_data['fest_update_time'] = date('Y-m-d H:i:s');
            $fest_res = DB::table('festival_remind')
                ->where('fest_id', $request['fest_id'])
                ->update($fest_edit_data);
            $notice = '编辑';
            if(isset($fest_edit_data['fest_status']) && $fest_edit_data['fest_status'] == 2){
                $notice = '删除';
            }
            if ($fest_res) {
                return ['code' => 200, 'msg' => $notice.'节日成功', 'data' => $notice.'节日成功'];
            } else {
                return ['code' => 500, 'msg' => $notice.'节日失败', 'data' => $notice.'节日失败'];
            }
        }
    }

    // 签名
    public static function signatureEdit($request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $type = $request['type']??1;
        $data = DB::table('shop_sign')
            ->where('shopsign_cid', $user_info->adm_cid)
            ->where('shopsign_shop_id', $shop_id)
            ->select('shopsign_name','shopsign_update_time')
            ->first();
        $data = json_decode(json_encode($data),true);
        if($type == 1){//获取内容
            if(empty($data)){
                $shop_name = DB::table('shop')
                    ->where('shop_id', $shop_id)
                    ->value('shop_store_name');
                $add_data['shopsign_cid'] = $user_info->adm_cid;
                $add_data['shopsign_superior_shop_id'] = $shop_id;
                $add_data['shopsign_shop_id'] = $user_info->adm_shop_id;
                $add_data['shopsign_name'] = $shop_name;
                $add_data['shopsign_create_time'] = date('Y-m-d H:i:s');
                $add_data['shopsign_create_name'] = $user_info->adm_name;
                $add_data['shopsign_create_id'] = $user_info->adm_id;
                $add_data['shopsign_update_time'] = date('Y-m-d H:i:s');
                $res =  DB::table('shop_sign')->insertGetId($add_data);
                $data['shopsign_name'] = $shop_name;
                $data['shopsign_update_time'] = $add_data['shopsign_update_time'];
            }
            $count = self::remainingTimes($user_info);
            $data['count'] = $count;
            return ['code' => 200, 'msg' => '成功', 'data' => $data];
        }else{
            if(!isset($request['shopsign_name']) || empty($request['shopsign_name'])){
                return ['code' => 500, 'msg' => '签名不能为空', 'data' => '签名不能为空'];
            }
            if($data){//有签名修改
                //剩余修改次数
                $count = self::remainingTimes($user_info);
                $data['count'] = $count;
                if($count == 0){
                    return ['code' => 500, 'msg' => '剩余修改次数为0', 'data' => $data];
                }
                $edit_data['shopsign_name'] = $request['shopsign_name'];
                $edit_data['shopsign_update_time'] = date('Y-m-d H:i:s');
                $res = DB::table('shop_sign')
                    ->where('shopsign_cid', $user_info->adm_cid)
                    ->where('shopsign_shop_id', $shop_id)
                    ->update($edit_data);
                self::signatureEditLog($user_info,['sslog_old_name'=>$data['shopsign_name'],'sslog_new_name'=>$request['shopsign_name']]);
            }else{//没有签名，添加
                $add_data['shopsign_cid'] = $user_info->adm_cid;
                $add_data['shopsign_superior_shop_id'] = $shop_id;
                $add_data['shopsign_shop_id'] = $user_info->adm_shop_id;
                $add_data['shopsign_name'] = $request['shopsign_name'];
                $add_data['shopsign_create_time'] = date('Y-m-d H:i:s');
                $add_data['shopsign_create_name'] = $user_info->adm_name;
                $add_data['shopsign_create_id'] = $user_info->adm_id;
                $add_data['shopsign_update_time'] = date('Y-m-d H:i:s');
                $res =  DB::table('shop_sign')->insertGetId($add_data);
                //self::signatureEditLog($user_info,['sslog_old_name'=>'','sslog_new_name'=>$request['shopsign_name']]);
            }
            if ($res) {
                return ['code' => 200, 'msg' => '编辑签名成功', 'data' => '编辑签名成功'];
            } else {
                return ['code' => 500, 'msg' => '编辑签名失败', 'data' => '编辑签名失败'];
            }
        }
    }

    //签名剩余次数
    public static function remainingTimes($user_info)
    {
        $data = DB::table('shop_sign_log')
            ->where('sslog_cid', $user_info->adm_cid)
            ->where('sslog_shop_id', $user_info->adm_shop_id)
            ->where('sslog_month', date('Y-m'))
            ->get()->toArray();
        $data = json_decode(json_encode($data,true));
        $count = 1 - count($data);
        if($count < 0){$count = 0;}
        return $count;
    }

    // 签名修改记录
    public static function signatureEditLog($user_info,$request)
    {
        if(!isset($request['sslog_new_name']) || empty($request['sslog_new_name'])){
            return ['code' => 500, 'msg' => '签名不能为空', 'data' => '编辑签名失败'];
        }
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $add_data['sslog_cid'] = $user_info->adm_cid;
        $add_data['sslog_superior_shop_id'] = $shop_id;
        $add_data['sslog_shop_id'] = $user_info->adm_shop_id;
        $add_data['sslog_old_name'] = $request['sslog_old_name']??'';
        $add_data['sslog_new_name'] = $request['sslog_new_name'];
        $add_data['sslog_create_time'] = date('Y-m-d H:i:s');
        $add_data['sslog_create_name'] = $user_info->adm_name;
        $add_data['sslog_create_id'] = $user_info->adm_id;
        $add_data['sslog_month'] = date('Y-m');
        $res =  DB::table('shop_sign_log')->insertGetId($add_data);
        if ($res) {
            return ['code' => 200, 'msg' => '编辑签名成功', 'data' => '编辑签名成功'];
        } else {
            return ['code' => 500, 'msg' => '编辑签名失败', 'data' => '编辑签名失败'];
        }
    }

    // 测试发送短信
    public static function sendContent($request)
    {
        // 验证数据
        $verify_data = new VerifyFestivalRemindController;
        $error_message = $verify_data->editValidator($request); //验证编辑id是否存在
        if ($error_message) {
            return response()->json(['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message]);
        }

        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $data = DB::table('festival_remind')
            ->where('fest_cid', $user_info->adm_cid)
            ->where('fest_shop_id', $shop_id)
            ->where('fest_id', $request['fest_id'])
            ->first();
        if($data){
            $content = $data->fest_content;
            $ret = [];
            //获取标签
            $label_data =  DB::table('sms_label')
                ->where('sms_label_type', $data->fest_type)//节日类型：1节日2生日
                ->get()->toArray();
            if($label_data){
                foreach ($label_data as $key => $value){
                    if(strpos($content,$value->sms_label_text) !== false){
                        $ret[] = ['type'=>$value->sms_label_key,'value'=>$value->sms_label_name,'text'=>$value->sms_label_text];
                    }
                }
            }
            return ['code' => 200, 'msg' => 'success', 'data' => $ret];
        }else{
            return ['code' => 500, 'msg' => '该节日不存在', 'data' => '该节日不存在'];
        }
    }

    // 发送短信
    public static function sendMes($request)
    {
        // 获取当前操作账号信息
        $user_info = Common::getUserInfo($request['api_token']);
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $data = DB::table('festival_remind')
            ->where('fest_cid', $user_info->adm_cid)
            ->where('fest_shop_id', $shop_id)
            ->where('fest_id', $request['fest_id'])
            ->first();
        $ret = self::sendContent($request);
        if($ret['code'] == 200){
            $content = $data->fest_content;
            //手机号必传
            if(isset($request['phone']) && !empty($request['phone'])){
                $phone = $request['phone'];
            }else{
                return ['code' => 500, 'msg' => '请输入手机号码', 'data' => ''];
            }
            //处理提交的参数
            if(isset($request['content']) && !empty($request['content'])){
                $params = $request['content'];
                foreach ($params as $p_key => $p_value){
                    foreach ($p_value as $k => $v){
                        $params_arr[$k] = $v;
                    }
                }
            }
            //替换提交的参数
            foreach ($ret['data'] as $key => $value){
                if(isset($params_arr[$value['type']]) && !empty($params_arr[$value['type']])){
                    $content = str_replace($value['text'],$params_arr[$value['type']],$content);
                }else{
                    return ['code' => 500, 'msg' => '请输入'.$value['value'], 'data' => ''];
                }
            }
            //获取签名
            $sign = '半径服务';
            $sign_data = DB::table('shop_sign')
                ->where('shopsign_cid', $user_info->adm_cid)
                ->where('shopsign_shop_id', $shop_id)
                ->select('shopsign_name','shopsign_update_time')
                ->first();
            if($sign_data){
                $sign = $sign_data->shopsign_name;
            }
            $use_count = ceil(mb_strlen($content) / 67);
            $count = DB::table('shop')->where('shop_id', $user_info->adm_shop_id)
                    ->value('shop_message_num');
            if ($count < $use_count) {
                $add_data['message_cid'] = $user_info->adm_cid;
                $add_data['message_superior_shop_id'] = $shop_id;
                $add_data['message_shop_id'] = $shop_id;
                $add_data['message_mem_id'] = 0;//会员id
                $add_data['message_mem_name'] = $params_arr['username']??'';//会员姓名
                $add_data['message_mem_phone'] = $request['phone'];//会员电话
                $add_data['message_type'] = $data->fest_type;//1节日提醒2生日提醒
                $add_data['message_send_time'] = date('Y-m-d H:i:s');//发送时间
                $add_data['message_count'] = $use_count;//发送条数
                $add_data['message_content'] = '【'.$sign.'】'.$content;//发送内容
                $add_data['message_status'] = 2;//1成功2失败3待发送
                $add_data['message_mem_type'] = 2;//1业务人员2会员
                $fest_id =  DB::table('festival_message')->insertGetId($add_data);
                $send_res = 0;
                return ['code' => 500, 'msg' => '短信余额不足，请充值', 'data' => '该节日不存在'];
            } else {
                $find_shop_data = DB::table('shop')
                    ->where('shop_id', $user_info->adm_shop_id)
                    ->first();
                $msg_remind_log = DB::table('msg_remind_log')
                    ->where('mrlo_shop_id', $user_info->adm_shop_id)
                    ->where('mrlo_state', 2)
                    ->first();
                if ($msg_remind_log) {//已提醒过
                    if ($find_shop_data->shop_message_num > $find_shop_data->shop_msg_remind) {
                        $update_remind['mrlo_state'] = 1;
                        $msg_remind_log = DB::table('msg_remind_log')
                            ->where('mrlo_shop_id', $user_info->adm_shop_id)
                            ->where('mrlo_state', 2)
                            ->update($update_remind);
                    }
                }
                
                $msg_remind_log = DB::table('msg_remind_log')
                    ->where('mrlo_shop_id', $user_info->adm_shop_id)
                    ->where('mrlo_state', 2)
                    ->first();

                if (($find_shop_data->shop_message_num-$use_count) <= $find_shop_data->shop_msg_remind && empty($msg_remind_log) && $find_shop_data->shop_msg_adm_id) {
                    $adm_data = DB::table('admin')->where('adm_id', $find_shop_data->shop_msg_adm_id)->first();
                    // $wechat_msg['pushtype'] = 5; //短信预警
                    // $wechat_msg['adm_id'] = $find_shop_data->shop_msg_adm_id; //推送人
                    // $wechat_msg['user_data'] = $adm_data->adm_name; //姓名
                    // $wechat_msg['tittle'] = '剩余短信不足'.$find_shop_data->shop_msg_remind.'条，请及时充值'; //提醒消息
                    // $wechat_msg['remark'] = '短信不足预警';
                    // $CashierDesk = new CashierDesk;
                    // $wechat_msg_res = $CashierDesk->inforPush($wechat_msg);
                    $remind_phone = $adm_data->adm_phone;
                    $remind_content = '【半径服务】 您的门店短信余额不足'.$find_shop_data->shop_msg_remind.'条，请及时充值';
                    $remind_send_res = sendSmsCode($remind_phone, $remind_content);
                    if ($remind_send_res > 0) {
                        $send_state = 1;
                        $add_remind['mrlo_shop_id'] = $user_info->adm_shop_id;
                        $add_remind['mrlo_state'] = 2;//未充值，
                        $add_remind['mrlo_adm_id'] = $find_shop_data->shop_msg_adm_id;
                        $add_remind['mrlo_num'] = $find_shop_data->shop_msg_remind;
                        $add_remind['mrlo_create_time'] = date('Y-m-d H:i:s');
                        $add_remind['mrlo_create_id'] = $user_info->adm_id;
                        $reming_res = DB::table('msg_remind_log')->insertGetId($add_remind);
                    } else {
                        $send_state = 2;
                    }
                    // 短信模块日志
                    $seme_data['seme_cid'] = $user_info->adm_cid; //公司id
                    $seme_data['seme_shop_id'] =$user_info->adm_shop_id; //门店id
                    $seme_data['seme_wor_id'] = 0; //订单id
                    $seme_data['seme_name'] = '短信不足预警'; //模板名称
                    $seme_data['seme_phone'] = $remind_phone; //手机号
                    $seme_data['seme_content'] = $remind_content; //内容
                    $seme_data['seme_row'] = 1; //条数
                    $seme_data['seme_status_code'] = $remind_send_res; //短信状态码
                    $seme_data['seme_state'] = $send_state; //状态：1成功2失败
                    $seme_data['seme_ip'] = $request['ip']; //ip地址
                    $seme_data['seme_adm_id'] = $user_info->adm_id; //创建人id
                    $seme_id = DB::table('send_message')->insert($seme_data);
                }
                //发送短信
                $send_res = sendSmsCode($phone, '【'.$sign.'】'.$content);
                //发送短信记录
                if($send_res > 0){
                    $message_status = 1;
                }else{
                    $message_status = 2;
                }
                $add_data['message_cid'] = $user_info->adm_cid;
                $add_data['message_superior_shop_id'] = $shop_id;
                $add_data['message_shop_id'] = $shop_id;
                $add_data['message_mem_id'] = 0;//会员id
                $add_data['message_mem_name'] = $params_arr['username']??'';//会员姓名
                $add_data['message_mem_phone'] = $request['phone'];//会员电话
                $add_data['message_type'] = $data->fest_type;//1节日提醒2生日提醒
                $add_data['message_send_time'] = date('Y-m-d H:i:s');//发送时间
                $add_data['message_count'] = $use_count;//发送条数
                $add_data['message_content'] = '【'.$sign.'】'.$content;//发送内容
                $add_data['message_status'] = $message_status;//1成功2失败3待发送
                $add_data['message_mem_type'] = 2;//1业务人员2会员
                $fest_id =  DB::table('festival_message')->insertGetId($add_data);
                $find_member = DB::table('member')
                    ->where('mem_shop_id', $shop_id)
                    ->where('mem_phone', $request['phone'])
                    ->first();
                if ($find_member) {
                    $add_log['smlo_mem_id'] = $find_member->mem_id;
                    $add_log['smlo_mem_name'] = $find_member->mem_name;
                    $add_log['smlo_mem_phone'] = $request['phone'];
                } else {
                    $add_log['smlo_mem_id'] = 0;
                    $add_log['smlo_mem_name'] = $params_arr['username'];
                    $add_log['smlo_mem_phone'] = $request['phone'];
                }
                $add_log['smlo_shop_id'] = $user_info->adm_shop_id;
                $add_log['smlo_mem_type'] = 2;//1业务人员2会员
                $add_log['smlo_type'] = 2;
                $add_log['smlo_create_time'] = date('Y-m-d H:i:s');
                $add_log['smlo_state'] = $message_status;
                $add_log['smlo_msg_type'] = $data->fest_type == 1 ? 2 : 3;
                $add_log['smlo_num'] = $use_count;
                $add_log['smlo_content'] = '【'.$sign.'】'.$content;//发送内容
                $add_log_res = DB::table('sms_log')->insertGetId($add_log);
            }
            if ($send_res > 0) {
                $update_shop = DB::table('shop')
                    ->where('shop_id', $user_info->adm_shop_id)
                    ->update(['shop_message_num'=>$count - $use_count]);
                return ['code' => 200, 'msg' => '发送成功', 'data' => '【'.$sign.'】'.$content];
            } else {
                return ['code' => 500, 'msg' => '发送失败', 'data' => '【'.$sign.'】'.$content];
            }
        }
        return ['code' => 500, 'msg' => '该节日不存在', 'data' => '该节日不存在'];

    }
}