<?php

namespace App\Services\Business;

use BlueCity\Core\Service\Service;
use App\Models\Business\EvaluatePart;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\Business\EvaluatePartValidator;

class EvaluatePartService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new EvaluatePart();
        $this->mainValidator = new EvaluatePartValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *按工单分类查询
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($request, $show_count = 10)
    {
        $list_data = DB::table('evaluate_goods as b')
            ->leftJoin('evaluate_part as a', 'evgo_evpa_id', '=', 'evpa_id')
            ->where('evpa_shop_id', $request['shop_id'])
            ->where(function ($query) use ($request) {
                if (!empty($request['pait_id'])) {
                    $query->where('evgo_goo_id', $request['pait_id'])
                        ->where('evgo_goo_type', 3);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['evpa_choice1'])) {
                    $query->where('evpa_choice1', $request['evpa_choice1']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['evpa_choice2'])) {
                    $query->where('evpa_choice2', $request['evpa_choice2']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['evpa_choice3'])) {
                    $query->where('evpa_choice3', $request['evpa_choice3']);
                }
            })
            ->where(function ($query) use ($request) {
                if (!empty($request['evpa_choice4'])) {
                    $query->where('evpa_choice4', $request['evpa_choice4']);
                }
            })
            ->select('evpa_id', 'evpa_cryptonym_state', 'evpa_adm_name', 'evpa_score1', 'evpa_score2', 'evpa_score3', 'evpa_choice1', 'evpa_choice2', 'evpa_choice3', 'evpa_choice4', 'evpa_desc', 'evpa_time', 'evpa_ord_id', 'evgo_goo_id')
            ->orderBy('evpa_id', 'desc')
            // ->groupBy('evpa_ord_id')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            foreach ($list_items as $key => $value) {
                $sepr_data = DB::table('order_goods as orgo')
                    ->where('orgo_ord_id', $value->evpa_ord_id)
                    ->where('orgo_goo_type', 2)
                    ->select('orgo_goo_name')
                    ->get()->toArray();
                $list_items[$key]->sepr_data = !empty($sepr_data) ? $sepr_data : '';
            }
        }

        // 查询评论总数，总分数
        $find_evaluate = DB::table('evaluate_goods')
            ->leftJoin('evaluate_part', 'evgo_evpa_id', '=', 'evpa_id')
            ->where('evpa_shop_id', $request['shop_id'])
            ->where(function ($query) use ($request) {
                if (!empty($request['pait_id'])) {
                    $query->where('evgo_goo_id', $request['pait_id'])
                        ->where('evgo_goo_type', 3);
                }
            })
            ->select(DB::raw('count(*) as count, sum(evpa_score1) as total_score1, sum(evpa_score2) as total_score2, sum(evpa_score3) as total_score3'))
            ->first();

        $other_data['score1'] = 5;
        $other_data['score2'] = 5;
        $other_data['score3'] = 5;
        if ($find_evaluate->count) {
            $other_data['score1'] = round($find_evaluate->total_score1 / $find_evaluate->count, 2);//店铺分数
            $other_data['score2'] = round($find_evaluate->total_score2 / $find_evaluate->count, 2);
            $other_data['score3'] = round($find_evaluate->total_score3 / $find_evaluate->count, 2);
        }
        $other_data['total_number'] = $find_evaluate->count;//评论总数
        
        $find_evaluate = DB::table('evaluate_goods')
            ->leftJoin('evaluate_part', 'evgo_evpa_id', '=', 'evpa_id')
            ->where('evpa_shop_id', $request['shop_id'])
            ->where('evpa_choice1', 1)
            ->where(function ($query) use ($request) {
                if (!empty($request['pait_id'])) {
                    $query->where('evgo_goo_id', $request['pait_id'])
                        ->where('evgo_goo_type', 3);
                }
            })
            ->select(DB::raw('count(*) as count'))
            ->first();
        $other_data['total_choice1'] = $find_evaluate->count;//评论总数

        $find_evaluate = DB::table('evaluate_goods')
            ->leftJoin('evaluate_part', 'evgo_evpa_id', '=', 'evpa_id')
            ->where('evpa_shop_id', $request['shop_id'])
            ->where('evpa_choice2', 1)
            ->where(function ($query) use ($request) {
                if (!empty($request['pait_id'])) {
                    $query->where('evgo_goo_id', $request['pait_id'])
                        ->where('evgo_goo_type', 3);
                }
            })
            ->select(DB::raw('count(*) as count'))
            ->first();
        $other_data['total_choice2'] = $find_evaluate->count;//评论总数
        $find_evaluate = DB::table('evaluate_goods')
            ->leftJoin('evaluate_part', 'evgo_evpa_id', '=', 'evpa_id')
            ->where('evpa_shop_id', $request['shop_id'])
            ->where('evpa_choice3', 1)
            ->where(function ($query) use ($request) {
                if (!empty($request['pait_id'])) {
                    $query->where('evgo_goo_id', $request['pait_id'])
                        ->where('evgo_goo_type', 3);
                }
            })
            ->select(DB::raw('count(*) as count'))
            ->first();
        $other_data['total_choice3'] = $find_evaluate->count;//评论总数
        $find_evaluate = DB::table('evaluate_goods')
            ->leftJoin('evaluate_part', 'evgo_evpa_id', '=', 'evpa_id')
            ->where('evpa_shop_id', $request['shop_id'])
            ->where('evpa_choice4', 1)
            ->where(function ($query) use ($request) {
                if (!empty($request['pait_id'])) {
                    $query->where('evgo_goo_id', $request['pait_id'])
                        ->where('evgo_goo_type', 3);
                }
            })
            ->select(DB::raw('count(*) as count'))
            ->first();
        $other_data['total_choice4'] = $find_evaluate->count;//评论总数

        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        $data['other_data'] = $other_data;
        return $data;
    }

    // 新增评价
    public static function add($request)
    {
        $evpa_data['evpa_weus_id'] = $request['weus_id'];
        $evpa_data['evpa_shop_id'] = $request['shop_id'];
        $evpa_data['evpa_ord_id'] = $request['ord_id'];
        $evpa_data['evpa_adm_name'] = $request['name'];
        $evpa_data['evpa_cryptonym_state'] = $request['evpa_cryptonym_state'];
        $evpa_data['evpa_score1'] = $request['evpa_score1'];
        $evpa_data['evpa_score2'] = $request['evpa_score2'];
        $evpa_data['evpa_score3'] = $request['evpa_score3'];
        $evpa_data['evpa_choice1'] = $request['evpa_choice1'];
        $evpa_data['evpa_choice2'] = $request['evpa_choice2'];
        $evpa_data['evpa_choice3'] = $request['evpa_choice3'];
        $evpa_data['evpa_choice4'] = $request['evpa_choice4'];
        $evpa_data['evpa_time'] = date('Y-m-d H:i:s');
        $evpa_data['evpa_update_time'] = date('Y-m-d H:i:s');
        if (!empty($request['evpa_desc'])) {
            $evpa_data['evpa_desc'] = $request['evpa_desc'];
        }
        $evpa_res = DB::table('evaluate_part')->insertGetid($evpa_data);
        
        // 更改订单状态,改为已评价状态
        $ord_data['ord_wor_state'] = 20;//已评价
        $ord_data['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_res = DB::table('order')
            ->where('ord_id', $request['ord_id'])
            ->update($ord_data);
        $find_orgo = DB::table('order_goods')
            ->where('orgo_ord_id', $request['ord_id'])
            ->select('orgo_goo_id', 'orgo_goo_type')
            ->get()->toArray();
        if (!empty($find_orgo)) {
            foreach ($find_orgo as $key => $value) {
                // 增加商品评价关联表
                $add_data[$key]['evgo_evpa_id'] = $evpa_res;
                $add_data[$key]['evgo_goo_id'] = $value->orgo_goo_id;
                $add_data[$key]['evgo_goo_type'] = $value->orgo_goo_type;
                $add_data[$key]['evgo_create_time'] = date('Y-m-d H:i:s');
                $add_data[$key]['evgo_ord_id'] = $request['ord_id'];
            }
            $add_res = DB::table('evaluate_goods')
                ->insert($add_data);
        }
        if ($evpa_res && $ord_res) {
            // 订单历史记录
            $data['wohi_primary_id'] = $request['ord_id'];
            $data['wohi_state_name'] = '已评价';
            $data['wohi_state'] = 5;
            $data['wohi_type'] = 1;
            addHistory($data);
            unset($data);
            return ['code'=>200, 'msg'=>'评价成功', 'data'=>''];
        } else {
            return ['code'=>500, 'msg'=>'评价失败', 'data'=>''];
        }
    }
}
