<?php

namespace App\Services\Business;

use App\Http\Controllers\Api\Verify\WarehouseManage\VerifyDeliveryController;
use App\Services\CommonService;
use App\Services\LoginUserService;
use App\Services\Point\PointService;
use App\Services\Shop\ShopService;
use BlueCity\Core\Service\Service;
use App\Http\Models\Api\Common;
use Illuminate\Support\Facades\DB;
use App\Models\Common as Comm;

// 导出权限
class DeliveryService extends Service
{

    //获取列表信息
    public static function list($user_info,$search_data)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        //$shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $list_data = DB::table('delivery')
            ->where('deli_shop_id', $user_info->adm_shop_id)
            ->where('deli_is_show', 1)//1显示2隐藏
            ->where(function ($query) use ($search_data) {
                if (!empty($search_data['deli_name'])) {
                    $query->where('deli_name','like', '%'.$search_data['deli_name'].'%');
                }
            })
            ->select('deli_id','deli_name')
            ->orderBy('deli_id', 'desc')
            ->get()->toArray();
        if ($list_data) {
            return ['code' => 200, 'msg' => '成功', 'data' => $list_data];
        } else {
            $delivery_arr = ['韵达快递','顺丰快递','圆通快递','中通快递','邮政','申通快递'];
            foreach ($delivery_arr as $key => $value){
                $add_data['deli_cid'] = $user_info->adm_cid;
                $add_data['deli_shop_id'] = $user_info->adm_shop_id;
                $add_data['deli_name'] = $value;//快递公司名称
                $ret_id =  DB::table('delivery')->insertGetId($add_data);
            }
            $list_data = DB::table('delivery')
                ->where('deli_shop_id', $user_info->adm_shop_id)
                ->where('deli_is_show', 1)//1显示2隐藏
                ->select('deli_id','deli_name')
                ->orderBy('deli_id', 'desc')
                ->get()->toArray();
            return ['code' => 200, 'msg' => '暂无数据', 'data' => $list_data];
        }
    }

    //添加
    public static function add($user_info,$request)
    {
        // 验证数据
        $verify_data = new VerifyDeliveryController;
        $error_message = $verify_data->addValidator($request);
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        $data = DB::table('delivery')
            ->where('deli_shop_id', $user_info->adm_shop_id)
            ->where('deli_name', $request['deli_name'])
            ->count();
        if($data > 0){
            return ['code' => 500, 'msg' => '该快递公司已添加,请勿重复添加', 'data' => ''];
        }
        $add_data['deli_cid'] = $user_info->adm_cid;
        $add_data['deli_shop_id'] = $user_info->adm_shop_id;
        $add_data['deli_name'] = $request['deli_name'];//快递公司名称
        $ret_id =  DB::table('delivery')->insertGetId($add_data);
        if ($ret_id) {
            return ['code' => 200, 'msg' => '新增成功', 'data' =>''];
        } else {
            return ['code' => 500, 'msg' => '新增失败', 'data' => ''];
        }
    }

    //编辑
    public static function edit($user_info,$request)
    {
        // 验证数据
        $verify_data = new VerifyDeliveryController;
        $error_message = $verify_data->editValidator($request); //验证编辑id是否存在
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        $update_data['deli_name'] = $request['deli_name'];
        $data = DB::table('delivery')
            ->where('deli_shop_id', $user_info->adm_shop_id)
            ->where('deli_name', $request['deli_name'])
            ->where('deli_id', '<>',$request['deli_id'])
            ->count();
        if($data > 0){
            return ['code' => 500, 'msg' => '该名称已添加,请勿重复添加', 'data' => ''];
        }
        if($request['deli_id'] && $update_data){
            $data = DB::table('delivery')
                ->where('deli_id', $request['deli_id'])
                ->update($update_data);

            return ['code' => 200, 'msg' => '编辑成功', 'data' =>''];
        }
        return ['code' => 500, 'msg' => '数据不存在', 'data' =>''];
    }

    //编辑
    public static function editStatus($request)
    {
        // 验证数据
        $verify_data = new VerifyDeliveryController;
        $error_message = $verify_data->editStatusValidator($request); //验证编辑id是否存在
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '参数错误', 'error_message' => $error_message];
        }
        $update_data['deli_is_show'] = $request['deli_is_show'];
        if($request['deli_id'] && $update_data){
            $data = DB::table('delivery')
                ->where('deli_id', $request['deli_id'])
                ->update($update_data);
            return ['code' => 200, 'msg' => '编辑成功', 'data' =>''];
        }
        return ['code' => 500, 'msg' => '数据不存在', 'data' =>''];
    }

    //获取列表信息
    public static function allIndex($user_info,$search_data)
    {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        //$shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $list_data = DB::table('delivery')
            ->where('deli_shop_id', $user_info->adm_shop_id)
            ->orderBy('deli_id', 'desc')
            ->get()->toArray();
        if ($list_data) {
            return ['code' => 200, 'msg' => '成功', 'data' => $list_data];
        } else {
            $delivery_arr = ['韵达快递','顺丰快递','圆通快递','中通快递','邮政','申通快递'];
            foreach ($delivery_arr as $key => $value){
                $add_data['deli_cid'] = $user_info->adm_cid;
                $add_data['deli_shop_id'] = $user_info->adm_shop_id;
                $add_data['deli_name'] = $value;//快递公司名称
                $ret_id =  DB::table('delivery')->insertGetId($add_data);
            }
            $list_data = DB::table('delivery')
                ->where('deli_shop_id', $user_info->adm_shop_id)
                ->where('deli_is_show', 1)//1显示2隐藏
                ->select('deli_id','deli_name')
                ->orderBy('deli_id', 'desc')
                ->get()->toArray();
            return ['code' => 200, 'msg' => '暂无数据', 'data' => $list_data];
        }
    }

    //给发货单添加快递信息
    public static function addDelivery($user_info,$search_data)
    {
        // 验证数据
        $verify_data = new VerifyDeliveryController;
        $error_message = $verify_data->addDeliveryValidator(json_decode(json_encode($search_data,true),true)); //验证编辑id是否存在
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '', 'error_message' => $error_message];
        }
        $count = DB::table('dispatch_delivery')
            ->where('delil_dego_id', $search_data['dego_id'])//发货单号
            ->count();
        if($count > 0){
            $update['delil_deli_id'] = $search_data['delil_deli_id']??0;//快递公司id
            $update['delil_number'] = $search_data['delil_number']??'';//快递单号
            $update['delil_img'] = isset($search_data['delil_img']) ? implode(',',$search_data['delil_img']) : '';//快递图片
            $data = DB::table('dispatch_delivery')
                ->where('delil_dego_id', $search_data['dego_id'])
                ->update($update);
            Common::addLog($user_info, '', '发货单修改快递信息', '修改', '发货单id：' . $search_data['dego_id'] . '快递单号：'.$update['delil_number'].'快递图片：'.$update['delil_img']);
            return ['code' => 200, 'msg' => '成功', 'data' => ''];
        }else{
            $add_data['delil_cid'] = $user_info->adm_cid;
            $add_data['delil_shop_id'] = $user_info->adm_shop_id;
            $add_data['delil_dego_id'] = $search_data['dego_id'];//发货id
            $add_data['delil_deli_id'] = $search_data['delil_deli_id']??0;//快递公司id
            $add_data['delil_number'] = $search_data['delil_number'];//快递单号
            $add_data['delil_img'] = isset($search_data['delil_img']) ? implode(',',$search_data['delil_img']) : '';//快递图片
            $ret_id =  DB::table('dispatch_delivery')->insertGetId($add_data);
            Common::addLog($user_info, '', '发货单添加快递信息', '添加', '发货单id：' . $add_data['delil_dego_id'] . '快递单号：'.$add_data['delil_number'].'快递图片：'.$add_data['delil_img']);
            return ['code' => 200, 'msg' => '成功', 'data' => ''];
        }

    }

    //给发货单修改快递信息
    public static function editDelivery($user_info,$request)
    {
        // 验证数据
        $verify_data = new VerifyDeliveryController;
        $error_message = $verify_data->editDeliveryValidator($request); //验证编辑id是否存在
        if ($error_message) {
            return ['code' => 500, 'msg' => '参数错误', 'data' => '', 'error_message' => $error_message];
        }
        $update['delil_deli_id'] = $request['delil_deli_id']??0;//快递公司id
        $update['delil_number'] = $request['delil_number']??'';//快递单号
        $update['delil_img'] = isset($request['delil_img']) ? implode(',',$request['delil_img']) : '';//快递图片
        if($request['delil_id'] && $update){
            $data = DB::table('dispatch_delivery')
                ->where('delil_id', $request['delil_id'])
                ->update($update);
            Common::addLog($user_info, '', '发货单修改快递信息', '修改', '发货单id：' . $request['delil_dego_id'] . '快递单号：'.$update['delil_number'].'快递图片：'.$update['delil_img']);
            return ['code' => 200, 'msg' => '编辑成功', 'data' =>''];
        }
        return ['code' => 500, 'msg' => '数据不存在', 'data' =>''];

    }

    //发货单的快递信息列表
    public static function deliveryList($user_info,$search_data)
    {
        $data = DB::table('dispatch_delivery as dd')
            ->leftJoin('delivery as d', 'd.deli_id', '=', 'dd.delil_deli_id')
            ->where('delil_dego_id', $search_data['dego_id'])//发货单号
            ->select('dd.*','d.deli_name')
            ->first();
        if($data){
            if(isset($data->delil_img) && !empty($data->delil_img)){
                $data->delil_img = explode(',',$data->delil_img);
            }else{
                $data->delil_img = [];
            }
            return ['code' => 200, 'msg' => '成功', 'data' => $data];
        }else{
            return ['code' => 200, 'msg' => '成功', 'data' => ''];
        }
    }


}



