<?php

namespace App\Services\BasicManagement;

use Illuminate\Database\Eloquent\Model;
use App\Models\BasicManagement\ShareTemplate;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\BasicManagement\ShareTemplateValidator;
use BlueCity\Core\Inc\ErrorInc;
use Illuminate\Support\Facades\Request;

class ShareTemplateService extends Service
{
    public static $instance;
    public $modelMain = null;
    public $mainValidator = null;

    public function __construct()
    {
        $this->modelMain = new ShareTemplate();
        $this->mainValidator = new ShareTemplateValidator();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function searchPage($user_info, $search_data, $show_count = 10, $field_columns = [])
    {
        // 判断是否传入查询字段
        if (empty($field_columns)) {
            $field_columns = ['shte_id', 'shte_type', 'shte_name', 'shte_shop_id', 'shte_adm_id', 'shte_content', 'shte_state', 'shte_delete', 'shte_create_time'];
        }

        // 分享模板管理表
        $list_data = DB::table('wash_share_template')
            ->where('shte_cid', $user_info->adm_cid)
            ->where('shte_shop_id', $user_info->adm_shop_id)
            ->where('shte_delete', 1)
            ->where(function($query) use($search_data) {
                if (!empty($search_data['shte_name'])) {
                    $query->where('shte_name', 'like', '%'.$search_data['shte_name'].'%' );
                }
            })
            ->where(function($query) use($search_data) {
                if (!empty($search_data['shte_state'])) {
                    $query->where('shte_state', $search_data['shte_state']);
                }
            })//状态1启用2停用
            ->where(function($query) use($search_data) {
                if (!empty($search_data['shte_type'])) {
                    $query->where('shte_type', $search_data['shte_type']);
                }
            })//分享模板形式1模板2自定义3施工前分享4施工中分享
            ->select($field_columns)
            ->orderBy('shte_id', 'desc')
            ->paginate($show_count);
        $list_items = $list_data->items();
        if ($list_items) {
            $adm_id = array_unique(array_column($list_items, 'shte_adm_id')) ;
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_name', 'adm_id')
                ->toArray();
            foreach ($list_items as $key => $value) {
                // 创建人信息
                if ($value->shte_adm_id) {
                    $list_items[$key]->adm_name = isset($find_admin[$value->shte_adm_id])?$find_admin[$value->shte_adm_id]:'';
                } else {
                    $list_items[$key]->adm_name = '';
                }
            }
        }
        $data['current_page'] = $list_data->currentPage();  //当前页面页码
        $data['last_page'] = $list_data->lastPage();        //表示最后一页的页码
        $data['total'] = $list_data->total();               //总数据个数
        $data['current_number'] = $show_count;        //一页显示多少个
        $data['data'] = $list_items;                        //返回数据
        return $data;
    }

    // 分享模板详情
    public static function info($user_info, $request)
    {
        $info = DB::table('wash_share_template')
            ->where('shte_shop_id', $user_info->adm_shop_id)
            ->where('shte_id', $request['shte_id'])
            ->select('shte_id', 'shte_type', 'shte_name', 'shte_shop_id', 'shte_adm_id', 'shte_content', 'shte_state', 'shte_delete', 'shte_create_time')
            ->first();
        if (empty($info)) {
            return ['code'=>ErrorInc::DATA_EMPTY, 'msg'=>'没查到模板信息', 'data'=>''];
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>$info];
    }

    /**
     * 检查是不是存在同名内容
     * @param $name 考核项名称
     * @param $type 类型：1施工部位2整车3其他
     * @param int $id 排除这个id
     * @return mixed
     */
    public static function nameExists($user_info, $name, $id = 0) {
        if ($id == 0) {
            return ShareTemplate::where('shte_name', $name)
                ->where('shte_shop_id', $user_info->adm_shop_id)
                ->where('shte_delete', 1)
                ->exists();
        } else {
            return ShareTemplate::where('shte_name', $name)
                ->where('shte_shop_id', $user_info->adm_shop_id)
                ->where('shte_delete', 1)
                ->where('shte_id', '<>', $id)
                ->exists();
        }
    }

    // 新增
    public static function add($user_info, $request) {
        $data['shte_cid'] = $user_info->adm_cid;
        $data['shte_adm_id'] = $user_info->adm_id;
        $data['shte_superior_shop_id'] = $user_info->adm_shop_id;
        $data['shte_shop_id'] = $user_info->adm_shop_id;
        $data['shte_type'] = $request['shte_type'];//分享模板形式1模板2自定义3施工前分享4施工中分享
        $data['shte_name'] = $request['shte_name'];//模板名称
        $data['shte_content'] = $request['shte_content'];//模板内容
        $data['shte_create_time'] = date('Y-m-d H:i:s');
        $data['shte_update_time'] = date('Y-m-d H:i:s');
        return ShareTemplate::insert($data);
    }

    // 编辑
    public static function edit($request) {
        $data['shte_type'] = $request['shte_type'];//分享模板形式1模板2自定义3施工前分享4施工中分享
        $data['shte_name'] = $request['shte_name'];//模板名称
        $data['shte_content'] = $request['shte_content'];//模板内容
        $data['shte_update_time'] = date('Y-m-d H:i:s');
        return ShareTemplate::where('shte_id', $request['shte_id'])
                ->update($data);
    }

    // 更改状态
    public static function editState($ids, $state) {
        $data['shte_state'] = $state;
        $data['shte_update_time'] = date('Y-m-d H:i:s');
        return ShareTemplate::where('shte_id', $ids)
                ->update($data);
    }

    // 更改删除状态
    public static function deleteState($ids) {
        $data['shte_delete'] = 2;
        $data['shte_update_time'] = date('Y-m-d H:i:s');
        return ShareTemplate::where('shte_id', $ids)
                ->update($data);
    }

    public static function getFieldsById($user_info, $id, $fields = '*'){
        $entity = ShareTemplate::where('shte_id', $id)
            ->select($fields)
            ->first();

        return $entity;
    }
}