<?php

namespace App\Services\BasicManagement;

use App\Services\CommonService;
use Illuminate\Database\Eloquent\Model;
use App\Models\BasicManagement\Admin;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Redis;
use App\Models\Common;
use Illuminate\Support\Facades\DB;
use App\Http\Requests\Validators\BasicManagement\AdminValidator;
use BlueCity\Core\Inc\ErrorInc;
use Pinyin;

class RoleSetService extends Service
{
   public static function getList ( $user_info , $request , $list_button ){
       $search_data = $request->all();
       $page_size = $search_data['show_count']??10;
       $list_data = DB::table('role')
           ->where('rol_cid', $user_info->adm_cid)
           ->where('rol_shop_id', $user_info->adm_shop_id)
           ->where(function ($query) use ($search_data) {
               if (!empty($search_data['rol_name'])) {
                   $query->where('rol_name', 'like', '%'.$search_data['rol_name'].'%');
               }
           })
           ->where(function ($query) use ($search_data) {
               if (!empty($search_data['rol_description'])) {
                   $query->where('rol_description', 'like', '%'.$search_data['rol_description'].'%');
               }
           })
           ->where(function ($query) use ($search_data) {
               if (!empty($search_data['rol_state'])) {
                   $query->where('rol_state', $search_data['rol_state']);
               }
           })
           ->where(function ($query) use ($search_data) {
               if (!empty($search_data['rol_category'])) {
                   $query->where('rol_category', $search_data['rol_category']);
               }
           })
           ->select('rol_id', 'rol_name', 'rol_state', 'rol_type', 'rol_description', 'rol_category')
           ->orderBy('rol_id', 'desc')
           ->paginate($page_size);
       $list = CommonService::dataToArray($list_data->items());
       if($list){
           $list = self::jointListData($user_info, $search_data, $list, $list_button);
           $data_info['data'] = $list;//返回列表数据
       }else{
           $data_info['data'] = [];//返回列表数据
       }
       $data_info['current_page'] = $list_data->currentPage();  //当前页面页码
       $data_info['last_page'] = $list_data->lastPage();        //表示最后一页的页码
       $data_info['total'] = $list_data->total();               //总数据个数
       $data_info['current_number'] = $page_size;       //一页显示多少个
       return $data_info;
   }
   /**|---------------------------------------------------------------------------------
    * 拼接列表数据
    * @param string $user_info 用户信息
    * @param array $search_data 请求数据
    * @param array $list 订单数据
    * @param array $list_button 按钮信息
    * @return /multitype:array
    * @author dou 2024/7/4 14:11
    * |---------------------------------------------------------------------------------
   */
    public static function jointListData ( $user_info , $search_data , $list , $list_button  ){
        foreach( $list as $k => $v ){
            if($user_info->adm_shop_id == 2 || $v['rol_type']>1){
                $buttonData = [];
                $buttonData[] = 'edit';
                if($v['rol_state'] == 1){
                    $buttonData[] = 'stop';
                }else{
                    $buttonData[] = 'start';
                }
                $button = CommonService::getListButton($buttonData,$list_button);
                $list[$k]['button_one'] = $button['button_one']??[];
                $list[$k]['button_two'] = $button['button_two']??[];
                $list[$k]['button_three'] = $button['button_three']??[];
            }else{
                $list[$k]['button_one'] = [];
                $list[$k]['button_two'] = [];
                $list[$k]['button_three'] = [];
            }
        }
        return $list;
    }
}
