<?php

/**
 * 车辆部位服务
 *
 * @author lixiaolin
 * @Date: 2021/8/17
 * @Time: 下午17:33
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Inc\CacheInc;
use App\Models\AutoParts;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;

class AutoPartsService extends Service
{
    public static $instance;
    public $modelMain = null;

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 查询部位分类
     *
     * @return mixed
     */
    public static function searchType() {
    	$data = AutoParts::where('enabled', 1)
            ->select('type')
            ->groupBy('type')
            ->get()->toArray();

    	return $data;
    }

    /**
     * 查询部位根据分类
     *
     * @return mixed
     */
    public static function searchByType($name) {
        $data = AutoParts::where('enabled', 1)
            ->where('type', $name)
            ->select('id', 'title', 'code', 'type')
            ->get()->toArray();

        return $data;
    }

    /**
     * 查询部位分类
     * @param string $name        查询关键字
     *
     * @return mixed
     */
    public static function searchTitle($name) {
        $data = AutoParts::where('title', 'like', '%' .$name.'%')
            ->where('enabled', 1)
            ->select(['id', 'title', 'code', 'type'])
            ->get();

        return $data;
    }
    /**
     * 查询部位
     *
     * @return mixed
     */
    public static function getData() {
    	$data = AutoParts::where('enabled', 1)
            ->select(['id', 'title', 'code', 'type'])
            ->get();

    	return $data;
    }

    /**
     * 获取全部level
     *
     * @param array $ids 从id数组中找
     * @param int $refresh 强制读数据库并更新redis缓存
     *
     * @return mixed
     */
    public static function getAll($ids = [], $refresh = 0) {
        $cacheKey = 'auto_parts';
        $data = [];
        if ($refresh == 1) {
            goto NOCACHE;
        }
        $cacheExist = Cache::has($cacheKey);
        if ($cacheExist) { //防止缓存穿透
            $itemList = Cache::get($cacheKey);
            if (!empty($ids)) {
                foreach ($ids as $val) {
                    $data[$val] = $itemList[$val];
                }
            }
        } else {
            NOCACHE:
            $itemList = [];
            $itemData = static::getData();
            foreach ($itemData as $k=>$val) {
                if ($ids && in_array($val['id'], $ids)) {
                    $data[$val['id']] = $val;
                }
                $itemList[$val['id']] = $val;
            }
            Cache::set($cacheKey, $itemList, CacheInc::CACHE_TIME+rand(0, 10)); //防止缓存雪崩
        }
        if(empty($ids)){
            $data = $itemList;
        }
        $return = [];
        foreach($data as $k => $v){
            $return[] = $v;
        }
        return $return;
    }

    /**
     * 获取某个职称
     *
     * @param int $ID       获取ID值
     * @param int $refresh  强制读库
     *
     * @return mixed
     */
    public static function getByID(int $ID, $refresh = 0) {
        $cacheKey = 'auto_parts';
        if ($refresh == 1) {
            goto NOCACHE;
        }
        $cacheExist = Cache::has($cacheKey);
        if ($cacheExist) { //防止缓存穿透
            $itemList = Cache::get($cacheKey);
            $data = $itemList[$ID];
        } else {
            NOCACHE:
            $itemList = [];
            $itemData =  static::getData();
            foreach ($itemData as $key=>$val) {
                $itemList[$val['id']] = $val;
            }
            Cache::set($cacheKey, $itemList, CacheInc::CACHE_TIME + rand(0, 10)); //防止缓存雪崩
            $data = $itemList[$ID];
        }

        return $data;
    }
}
