<?php

/**
 * 账户变更记录服务
 *
 * @author lixiaolin
 * @Date: 2021/9/6
 * @Time: 下午15:24
 * @Email: lixiaolin@bluearp.com
 * @version 1.0
 * @copyright BlueCity
 */

namespace App\Services;

use App\Models\AccountLog;
use BlueCity\Core\Service\Service;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Log;
use App\Models\MemberAccount;

class AccountLogService extends Service
{
    public static $instance;
    public $modelMain = null;

    public function __construct()
    {
        $this->modelMain = new AccountLog();
    }

    /**
     * @return mixed
     */
    public static function getInstance()
    {
        if (is_null(static::$instance)) {
            static::$instance = new static;
        }
        return static::$instance;
    }

    /**
     * 根据条件搜索数据内容
     *
     * @param array $param 条件
     * @param array $columns 内容
     * @param int $page 页码
     * @param int $pageSize 页容量
     * @return mixed
     */
    public function search($param, $columns = array('*'), $page = 1, $pageSize = 20)
    {
        $shopID = LoginUserService::getUserShopID();
        $where = [];
        $where[] = ['shop_id', '=', $shopID];

        if (!empty($param['member_id'])) {
            $where[] = ['member_id', '=', $param['member_id']];
        }
        if (!empty($param['log_type'])) {
            $where[] = ['log_type', '=', $param['log_type']];
        }
        if (!empty($param['start'])) {
            $where[] = ['created_at', '>=', $param['start']];
        }
        if (!empty($param['end'])) {
            $where[] = ['created_at', '=', $param['end']];
        }

        $count = $this->modelMain
            ->where($where)
            ->count();
        $totalPage = ceil($count / $pageSize);
        if ($pageSize > 0) {
            $offset = ($page - 1) * $pageSize;

            $list = $this->modelMain
                ->where($where)
                ->select($columns)
                ->orderBy('log_id', 'ASC')
                ->offset($offset)
                ->limit($pageSize)
                ->get();
        } else {
            $list = $this->modelMain
                ->where($where)
                ->select($columns)
                ->orderBy('log_id', 'ASC')
                ->get();
        }
        $result = [];
        $result['page'] = ['totalPage' => $totalPage, 'count' => $count, 'page' => $page, 'page_size' => $pageSize];
        $result['list'] = $list;

        return $result;
    }

    /**
     * 获取单行数据
     * @param int    $id       内容ID
     * @param mixed  $fields   字段
     * @param int    $shopID   门店编号
     *
     * @return mixed
     */
    public static function getFieldsById($id, $fields = '*', $shopID = 0){
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }
        return AccountLog::where('id', $id)
            ->where('mem_shop_id', $shopID)
            ->select($fields)
            ->first();
    }

    /**
     * 判断是否存在
     * @param array  $where    条件字段
     * @param int    $shopID   门店编号
     *
     * @return mixed
     */
    public static function getExists($where, $shopID = 0) {
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }
        return AccountLog::where('shop_id', $shopID)
            ->where($where)
            ->exist();
    }

    /**
     * 获取首条
     * @param array  $where    条件字段
     * @param int    $shopID   门店编号
     *
     * @return mixed
     */
    public static function getOne($where, $shopID = 0) {
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }
        return AccountLog::where('shop_id', $shopID)
            ->where($where)
            ->first();
    }

    /**
     * 获取确定行数据
     *
     * @param int $ID       获取ID值
     * @param int $shopID   门店ID
     *
     * @return mixed
     */
    public static function getByID(int $ID,  $shopID = 0) {
        if ($shopID == 0) {
            $shopID = LoginUserService::getUserShopID();
        }

        return AccountLog::where('log_id', $ID)
            ->where('shop_id', $shopID)
            ->where('enabled', 1)
            ->first();
    }

}
