<?php

namespace App\Http\Requests\Validators\WeChatApplet\Technician;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class AdminMessageValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            // 'type.required' => '参数类型错误',
            // 'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
