<?php

namespace App\Http\Requests\Validators\Business;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class EvaluatePartValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
    // 列表
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请选择门店',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请选择门店',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'ord_id.required' => '请选择订单',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'name.required' => '请选择用户名称',
            'evpa_cryptonym_state.required' => '请选择匿名状态',
            'evpa_cryptonym_state.integer' => '参数类型错误',
            'evpa_cryptonym_state.min' => '参数类型错误',
            'evpa_score1.required' => '请选择总体分数',
            'evpa_score1.integer' => '参数类型错误',
            'evpa_score1.min' => '参数类型错误',
            'evpa_score2.required' => '请选择店铺装修分数',
            'evpa_score2.integer' => '参数类型错误',
            'evpa_score2.min' => '参数类型错误',
            'evpa_score3.required' => '请选择服务技术分数',
            'evpa_score3.integer' => '参数类型错误',
            'evpa_score3.min' => '参数类型错误',
            'evpa_choice1.required' => '请选择设施齐全状态',
            'evpa_choice1.integer' => '参数类型错误',
            'evpa_choice1.min' => '参数类型错误',
            'evpa_choice2.required' => '请选择技术精湛状态',
            'evpa_choice2.integer' => '参数类型错误',
            'evpa_choice2.min' => '参数类型错误',
            'evpa_choice3.required' => '请选择员工形象状态',
            'evpa_choice3.integer' => '参数类型错误',
            'evpa_choice3.min' => '参数类型错误',
            'evpa_choice4.required' => '请选择服务态度状态',
            'evpa_choice4.integer' => '参数类型错误',
            'evpa_choice4.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
            'evpa_cryptonym_state' => 'required|integer|min:1',
            'evpa_score1' => 'required|integer|min:0',
            'evpa_score2' => 'required|integer|min:0',
            'evpa_score3' => 'required|integer|min:0',
            'evpa_choice1' => 'required|integer|min:0',
            'evpa_choice2' => 'required|integer|min:0',
            'evpa_choice3' => 'required|integer|min:0',
            'evpa_choice4' => 'required|integer|min:0',
            'name' => 'required|max:255',
            'evpa_desc' => 'sometimes|nullable|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
