<?php

namespace App\Http\Requests\Validators\BasicManagement;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class ShareTemplateValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 分享模板管理-列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
            'shte_name.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',//权限id
            'shte_name' => 'sometimes|nullable|max:20',//查询名称
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 删除
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shte_id.required' => '参数类型错误',
            'shte_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shte_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shte_type.required' => '参数类型错误',
            'shte_type.in' => '参数类型错误',
            'shte_name.required' => '请输入模板名称',
            'shte_name.max' => '参数类型错误',
            'shte_content.required' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shte_content' => 'sometimes|nullable|max:255',//备注
            'shte_name' => 'required|max:20',//名称
            'shte_content' => 'required',//内容
            'shte_type' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
            'shte_type.required' => '请选择分享模板形式',
            'shte_type.in' => '参数类型错误',
            'shte_id.required' => '参数类型错误',
            'shte_id.integer' => '参数类型错误',
            'shte_id.min' => '参数类型错误',
            'shte_name.required' => '请输入模板名称',
            'shte_name.max' => '参数类型错误',
            'shte_content.required' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shte_id' => 'required|integer|min:1',
            'shte_content' => 'required',//备注
            'shte_name' => 'required|max:30',//名称
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'shte_type' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
            'shte_id.required' => '参数类型错误',
            'shte_id.integer' => '参数类型错误',
            'shte_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shte_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 启用
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shte_id.required' => '参数类型错误',
            'shte_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shte_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 删除
    public function deleteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shte_id.required' => '参数类型错误',
            'shte_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shte_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
