<?php

namespace App\Http\Requests\Validators\BasicManagement;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 账号表
class AdminValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_name.required' => '请输入姓名',
            'adm_name.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_name' => 'required|max:50',//姓名名称
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
