<?php

namespace App\Repository\Order;

use Closure;
use App\Repository\Interfaces\OrderInterFace;
use App\Models\Orders;

abstract class Repository implements OrderInterFace
{
    private $orderModel = null;

    public function __construct()
    {
        $this->orderModel = new Orders();
    }

    /**
     * 获取订单列表
     * @param array $params
     * @return array|mixed
     */
    public function getOrders($params){

    }

    /**
     * Get the cache store implementation.
     * @param  int  $orderID 订单id
     * @param  mixed  $goods 订单商品
     * @param  Closure $callback
     * @return mixed
     */
    public function orderGoods($orderID, $goods , Closure $callback){

    }

    /**获取订单详细内容
     * @param int $orderId 订单ID
     * @return array|mixed
     */
    public function getOrderByID($orderId){
        return $this->orderModel->find($orderId);
    }

    /**获取订单详细内容
     * @param int $orderNO 订单NO
     * @return array|mixed
     */
    public function getOrderByNO($orderNO){
        return $this->orderModel->where('order_no', $orderNO)->find();
    }

    /**
     * 检查订单是否存在
     * @param int $orderNO 订单NO
     * @return array|mixed
     */
    public function exists($orderNO){
        return $this->orderModel->where('order_no', $orderNO)->find();
    }

    /**
     * 创建新订单
     * @param mixed $data 订单数据
     * @param Closure $callBack 钩子函数
     * @return array|mixed
     */
    public function create($data, Closure $callBack){
        $res = $this->orderModel->create($data);
        if ($res){
            $callBack();
        }

        return $res;
    }

    /**
     * 更新订单信息
     * @param int $orderID 订单id
     * @param array $data 订单数据
     * @param Closure $callBack 更新后钩子函数
     * @return bool
     */
    public function update($orderID, $data, Closure $callBack) {
        $this->orderModel->where('id', $orderID)
            ->save($data);
        return $callBack();
    }

    /**
     * 取消订单
     * @param int $orderID 订单id
     * @param Closure $callBack 订单取消后续操作
     * @return bool 是否成功
     */
    public function cancel($orderID, Closure $callBack) {

        return true;
    }

    /**
     * 检测订单是否处于允许编辑状态
     * @param int $orderID 订单id
     *
     * @return bool 是/否允许
     */
    public function editable($orderID)
    {
        return true;
    }

    /**
     * 静态调用方法
     * @param string $methodName 函数名
     * @param array $args 函数参数
     * @return mixed
     */
    public function __call($methodName, $args)
    {
        // TODO: Implement __call() method.
        $methodPrefix = $methodName;
        if ($methodPrefix == 'event') {
            return call_user_func_array([$this, $methodName], $args);
        }
    }

    /**
     * 静态调用方法
     * @param string $methodName 函数名
     * @param array $args 函数参数
     * @return mixed
     */
    public static function __callStatic($methodName, $args)
    {
        // 实例化当前类
        $instance = new static;
        // 调用当前实例的 $method 方法
        return call_user_func_array([$instance, $methodName], $args);
    }
}
