<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TechnicalLevel extends Model
{
    //

    /**
     * 关联到模型的数据表
     *
     * @var string
     */
    protected $table = 'wash_grade_level';
    protected $primaryKey = 'grle_id';
    protected $guarded = [];
    /**
     * 可以被批量赋值的属性.
     *
     * @var array
     */
//    protected $fillable = ['grle_name', 'grle_grpr_id', 'grle_remark', 'grle_state'];
    public $attributeNames = [
        'grle_id'=>'编号',
        'grle_name'=>'级别名称',
        'grle_grpr_id'=>'技师职称ID',
        'grle_remark'=>'备注',
        'grle_state'=>'状态值',
        'status_name'=>'状态',
        'grle_delete'=>'是否删除',
        'grle_create_time'=>'创建时间',
        'grle_update_time'=>'更新时间'
    ];
    /**
     * 表明模型是否应该被打上时间戳
     *
     * @var bool
     */
    //public $timestamps = false;
    /**
     * 模型日期列的存储格式
     *
     * @var string
     */
    //protected $dateFormat = 'U';
    const CREATED_AT = 'grle_create_time';
    const UPDATED_AT = 'grle_update_time';

    /**
     * The connection name for the models.
     *
     * @var integer $id
     * @var bool $includeSub
     *
     * @return mixed
     */
    //protected $connection = 'connection-name';
    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub

        static::addGlobalScope('grle_delete',function (Builder $builder){
            $builder->where('grle_delete','=',1);
        });
    }

    public function title() {
        return $this->belongsTo(TechnicalTitle::Class, 'grle_grpr_id', 'grpr_id');
    }

    public function scopeGrprId($query, $grpr_id) {
        return $query->where('grle_grpr_id', $grpr_id);
    }

    public function scopeName($query, $name) {
        return $query->where('grle_name', 'like', '%' . $name . '%');
    }

    public function scopeDelete($query, $delete = 1) {
        return $query->where('grle_delete', $delete);
    }

    public function scopeState($query, $state = 1) {
        return $query->where('grle_state', $state);
    }

    public function getStatusNameAttribute()
    {
        if ($this->getAttribute('grle_state') == 1) return '启用';
        if ($this->getAttribute('grle_state') == 2) return '停用';

        return '未知';
    }

    public function getDeleteNameAttribute()
    {
        if ($this->getAttribute('grle_delete') == 1) return '正常';
        if ($this->getAttribute('grle_delete') == 2) return '已删除';

        return '未知';
    }

    public function getCreateTimeAttribute()
    {
        $create_time = $this->getAttribute('grle_create_time');
        $dotExist = strpos($create_time, '.');
        if ($dotExist !== false)
        {
            $dateTime = explode('.', $create_time);

            return $dateTime[0];
        }

        return null;
    }

    public function getUpdateTimeAttribute()
    {
        $update_time = $this->getAttribute('grle_update_time');
        $dotExist = strpos($update_time, '.');
        if ($dotExist !== false)
        {
            $dateTime = explode('.', $update_time);

            return $dateTime[0];
        }

        return null;
    }


}
