<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

// 操作日志
class OperationLog extends Model
{
    protected $table = 'wash_validate_car_manage';
    protected $primaryKey = 'vacm_id';

    /**
     * [addLog 添加操作日志]
     * @param [type] $user_info [用户信息]
     * @param [type] $oplo_ip        [操作ip]
     * @param [type] $oplo_module    [操作模块]
     * @param [type] $oplo_action    [操作功能]
     * @param [type] $oplo_content   [操作内容]
     */
    public static function addLog(
        $user_info,
        $oplo_ip,
        $oplo_module,
        $oplo_action,
        $oplo_content
    ) {
        $add_data = [
            'oplo_cid'=>$user_info->adm_cid,
            'oplo_shop_id'=>$user_info->adm_shop_id,
            'oplo_adm_id'=>$user_info->adm_id,
            'oplo_adm_name'=>$user_info->adm_name,
            'oplo_module'=>$oplo_module,
            'oplo_action'=>$oplo_action,
            'oplo_content'=>$oplo_content,
            'oplo_ip'=>$oplo_ip
        ];
        return DB::table('operation_log')->insert($add_data);
    }
}
