<?php

namespace App\Models;

use App\Services\AutoPartsService;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MeritPayOptions extends Model
{
    use SoftDeletes;
    /**
     * 关联到模型的数据表
     *
     * @var string
     */
    protected $table = 'merit_pay_options';
    protected $guarded = [];
    /**
     * 可以被批量赋值的属性.
     *
     * @var array
     */

    /**
     * 表明模型是否应该被打上时间戳
     *
     * @var bool
     */
    public $timestamps = true;
    /**
     * 模型日期列的存储格式
     *
     * @var string
     */
    //protected $dateFormat = 'U';

    /**
     * The connection name for the models.
     *
     * @var integer $id
     * @var bool $includeSub
     *
     * @return mixed
     */
    //protected $connection = 'connection-name';
//    const CREATED_AT = '';
//    const UPDATED_AT = '';


    public function scopeName($query, $name) {
        return $query->where('merit_name', 'like', '%' . $name . '%');
    }

    public function scopeEnabled($query, $enabled) {
        return $query->where('enabled', '=', $enabled);
    }

    public function scopeMeritType($query, $type) {
        return $query->where('enabled', '=', $type);
    }


    public function getStatusNameAttribute()
    {
        $status = $this->getAttribute('enabled');
        if ($status == 1) {
            return '已启用';
        }
        if ($status == 2) {
            return '已禁用';
        }

        return '未知';
    }

    public function getMeritTypeNameAttribute()
    {
        $type = $this->getAttribute('merit_type');
        if ($type == 1) {
            return '按部位';
        }
        if ($type == 2) {
            return '按车型';
        }
        if ($type == 3) {
            return '其他';
        }

        return '未知';
    }

    public function getValueTypeNameAttribute()
    {
        $type = $this->getAttribute('value_type');
        if ($type == 1) {
            return '分值';
        }
        if ($type == 2) {
            return '金额';
        }

        return '未知';
    }


    public function getPartsNameAttribute()
    {
        $partsID = $this->getAttribute('parts_id');
        if ($partsID == 0) {
            return '无';
        }
        $parts = AutoPartsService::getByID($partsID);
        if($parts) {
            return $parts['title'];
        }

        return '未知';
    }
}
