<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Common extends Model
{
    /**
     * [numberRule 编号规则]
     * @param [type] $user_info     [用户信息]
     * @param [type] $type   		[类型：1订单编号规则2工单编号规则3采购编号规则4采购退货单编号5预约单编号]
     */
    public static function numberRule($user_info, $type)
    {
        // 查询当前门店有无生成订单编号
        $rule_data = DB::table('order_rule')
                ->where('orru_type', $type) //类型：1订单编号规则2工单编号规则3采购编号规则4采购退货单编号5预约单编号
                ->where('orru_cid', $user_info->adm_cid)
                ->where('orru_shop_id', $user_info->adm_shop_id)
                ->first(['orru_number','orru_date','orru_id']);
        if ($rule_data) {
            // 有此总店的数据 判断是不是今天的
            if ($rule_data->orru_date == date('Y-m-d')) {
                // 订单总量+1
                $order_rule = DB::table('order_rule')
                        ->where('orru_id', $rule_data->orru_id)
                        ->increment('orru_number');

                $today_order = $rule_data->orru_number + 1; //今天的订单总量
            } else {
                // 修改日期为今天 订单总量从1开始
                $orru_data['orru_date'] = date('Y-m-d');
                $orru_data['orru_number'] = 1;
                $orru_data['orru_update_time'] = date('Y-m-d H:i:s');
                $order_rule = DB::table('order_rule')
                        ->where('orru_id', $rule_data->orru_id)
                        ->update($orru_data);

                $today_order = 1; //今天的订单总量
            }
        } else {
            // 新增一条数据
            $orru_data['orru_cid'] = $user_info->adm_cid;
            $orru_data['orru_superior_id'] = $user_info->shop_superior_id;
            $orru_data['orru_shop_id'] = $user_info->adm_shop_id;
            $orru_data['orru_type'] = $type; //类型：1订单编号规则2工单编号规则3采购编号规则4采购退货单编号5预约单编号6售后单编号
            $orru_data['orru_date'] = date('Y-m-d');
            $orru_data['orru_number'] = 1;
            $orru_data['orru_update_time'] = date('Y-m-d H:i:s');
            $order_rule = DB::table('order_rule')->insert($orru_data);

            $today_order = 1; //今天的订单总量
        }

        if ($type == 1) {
            $initial_string = 'D';//首字母-订单编号
            $initial_length = 0;
        } elseif ($type == 2) {
            $initial_string = 'G';//首字母-工单编号
            $initial_length = 0;
        } elseif ($type == 3) {
            $initial_string = 'CG';//首字母-采购编号规则
            $initial_length = 1;
        } elseif ($type == 4) {
            $initial_string = 'TH';//首字母-采购退货单编号
            $initial_length = 1;
        } elseif ($type == 5) {
            $initial_string = 'YY';//首字母-预约单编号
            $initial_length = 1;
        } elseif ($type == 6) {
            $initial_string = 'SH';//首字母-售后单编号
            $initial_length = 1;
        }
        
        //门店id+随机数是6位或5位
        $random_length = 6 - $initial_length;//随机数补充长度
        $shop_length = $random_length - strlen($user_info->adm_shop_id);//门店id剩余补足位数
        $rand_start = str_pad(1, $shop_length, 1, STR_PAD_LEFT);//随机数开始
        $rand_end = str_pad(9, $shop_length, 9, STR_PAD_LEFT);//随机数结束
        // 首字母1位，年月日是8位 门店id+随机数是6位 订单编号共20位 编号补零的位数为5位
        // 首字母2位，年月日是8位 门店id+随机数是5位 采购编号共20位 编号补零的位数为5位
        $number = $initial_string.date('Ymd').str_pad($user_info->adm_shop_id, $random_length, rand($rand_start, $rand_end),STR_PAD_LEFT) . str_pad($today_order, 5, '0', STR_PAD_LEFT);
        return $number;
    }
}
