<?php

namespace App\Models\Business;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class WorkGood extends Model
{

    /**
     * 根据wogo_orgo_id获取数据
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function getDataByOrgoId($orgoId)
    {
        return DB::table("work_good")->where('wogo_orgo_id', $orgoId)->first();
    }

    /**
     * 更新数据
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function updateDataByworId($worId, $data)
    {
        return DB::table("work_good")->where('wogo_id', $worId)->update($data);
    }
}
