<?php

namespace App\Models\Business;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class WashOrder extends Model
{

    /**
     * 关联到模型的数据表
     *
     * @var string
     */
    protected $table = 'order';
    protected $primaryKey = 'ord_id';
    protected $guarded = [];

    /**
     * 表明模型是否应该被打上时间戳
     *
     * @var bool
     */
    public $timestamps = false;
    /**
     * 模型日期列的存储格式
     *
     * @var string
     */
    //protected $dateFormat = 'U';

    public function scopeType($query, $type) {
        return $query->where('vacm_type', $type);
    }
    
    public function scopeName($query, $name) {
        return $query->where('vacm_unusual_name', 'like', '%' . $name . '%');
    }

    public function scopeDelete($query, $delete = 1) {
        return $query->where('vacm_delete', $delete);
    }

    public function getStatusNameAttribute()
    {
        if ($this->getAttribute('vacm_state') == 1) return '启用';
        if ($this->getAttribute('vacm_state') == 2) return '停用';

        return '未知';
    }

    public function getDeleteNameAttribute()
    {
        if ($this->getAttribute('vacm_delete') == 1) return '正常';
        if ($this->getAttribute('vacm_delete') == 2) return '已删除';

        return '未知';
    }

    /**
     * 根据id更新数据
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function updateByOrdId($id, $data)
    {
        return DB::table("order")->where("ord_id", $id)->update($data);
    }

    /**
     * 根据id获取数据
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function getDataByOrdId($id)
    {
        return DB::table("order")->where("ord_id", $id)->first();
    }
}
