<?php

namespace App\Models\Business;

use App\Services\Business\WashOrderService;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class OrderSettlementDetails extends Model
{


    /**
     * 插入订单结算详情
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function insert($data)
    {
        return DB::table("order_settlement_details")->insert($data);
    }

    /**|---------------------------------------------------------------------------------
     * @name 添加订单支付明细
     * @param int $ord_id 订单id
     * @param array $request 请求参数
     * @param array $user_info 用户信息
     * @param array $ord_payment_money 实付金额
     * @param array $ord_banlance 余额
     * @param array $payway 支付类型
     * @retrun /multitype:array
     * @author dou 2023/11/27 17:15
     * |---------------------------------------------------------------------------------
     */
    public static function addOrderSettlementDetails ( $ord_id , $ord_type = 1 , $request , $user_info , $ord_payment_money , $ord_banlance , $payway = false ){
        $order_settlement_details['orsd_ord_id'] = $ord_id;
        $order_settlement_details['orsd_create_id'] = $user_info->adm_id;
        $order_settlement_details['orsd_create_time'] = date('Y-m-d H:i:s');
        $order_settlement_details['orsd_mem_type'] = $ord_type;
        $typeName = WashOrderService::getPaymentWayName(true);//获取支付方式名称
        if($payway){
            $order_settlement_details['orsd_payment_way'] = $payway;
            $order_settlement_details['orsd_pay_money'] = $ord_payment_money;
            $ord_payment_name = WashOrderService::getTypeData($payway, $typeName);
            $order_settlement_details['orsd_payment_way_name'] = $ord_payment_name;
            return DB::table('order_settlement_details')->insertGetId($order_settlement_details);
        }else {
            if (in_array($request['ord_payment_way'], [6, 7])) {
                $order_settlement_details['orsd_payment_way'] = $request['ord_other_payway'];
                $order_settlement_details['orsd_pay_money'] = $ord_payment_money;
                $ord_payment_name = WashOrderService::getTypeData($request['ord_other_payway'], $typeName);
                $order_settlement_details['orsd_payment_way_name'] = $ord_payment_name;
                $rea = DB::table('order_settlement_details')->insertGetId($order_settlement_details);

                $order_settlement_details['orsd_payment_way'] = $request['ord_payment_way'];
                $order_settlement_details['orsd_pay_money'] = $ord_banlance;
                $ord_payment_name = WashOrderService::getTypeData($order_settlement_details['orsd_payment_way'], $typeName);
                $order_settlement_details['orsd_payment_way_name'] = $ord_payment_name;
                $reb = DB::table('order_settlement_details')->insertGetId($order_settlement_details);
                if($rea && $reb){
                    return true;
                }else{
                    return false;
                }
            } else {
                if ($request['ord_payment_way'] == 9) {
                    $order_settlement_details['orsd_payment_way'] = $request['ord_other_payway'];
                } else {
                    $order_settlement_details['orsd_payment_way'] = $request['ord_payment_way'];
                }
                $order_settlement_details['orsd_pay_money'] = $ord_payment_money;
                $ord_payment_name = WashOrderService::getTypeData($order_settlement_details['orsd_payment_way'], $typeName);
                $order_settlement_details['orsd_payment_way_name'] = $ord_payment_name;
                return DB::table('order_settlement_details')->insertGetId($order_settlement_details);
            }
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>[]];
    }
}
