<?php

namespace App\Models\Business;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Support\Facades\DB;

class OrderGoods extends Model
{

    /**
     * 根据id更新数据
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function updateByorgoId($orgoId, $data)
    {
        return DB::table("order_goods")->where("orgo_id", $orgoId)->update($data);
    }

    /**
     * 根据id获取数据
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function getDataByorgoId($orgoId)
    {
        return DB::table("order_goods")->where("orgo_ord_id", $orgoId)->get()->all();
    }

    /**
     * 获取订单商品信息
     *
     * @param $id
     * @param $data
     * @return int
     *
     * @author huangyongqi
     *
     * @since 2023-10-24
     */
    public static function getDataByOrgoIds($orgoIds)
    {
        return DB::table("order_goods")->whereIn("orgo_id", $orgoIds)->get()->all();
    }
}
