<?php

namespace App\Http\Requests\Validators\WeChatApplet\User;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class MemberCarValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
    
    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'meca_id.required' => '请输入会员车辆id',
            'meca_id.integer' => '参数类型错误',
            'meca_id.min' => '参数类型错误',
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入微信用户id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'meca_id' => 'required|integer|min:1',
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
    
    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入微信用户id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'meca_car_num.required' => '请输入微信用户id',
            'meca_car_num.max' => '参数类型错误',
            'meca_car_series.max' => '参数类型错误',
            'meca_car_model.max' => '参数类型错误',
            'meca_car_frame.max' => '参数类型错误',
            'meca_car_brand_series.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'meca_car_num' => 'required|max:10',
            'meca_car_series' => 'sometimes|nullable|max:30',//车系
            'meca_car_model' => 'sometimes|nullable|max:30',//车型
            'meca_car_frame' => 'sometimes|nullable|max:30',//车架号
            'meca_car_brand_series' => 'sometimes|nullable|max:255',//品牌车系
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'meca_id.required' => '请输入会员车辆id',
            'meca_id.integer' => '参数类型错误',
            'meca_id.min' => '参数类型错误',
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'meca_car_num.required' => '请输入车牌号',
            'meca_car_num.max' => '参数类型错误',
            'meca_car_series.max' => '参数类型错误',
            'meca_car_model.max' => '参数类型错误',
            'meca_car_frame.max' => '参数类型错误',
            'meca_car_brand_series.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'meca_id' => 'required|integer|min:1',
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'meca_car_num' => 'required|max:10',
            // 'meca_car_series' => 'sometimes|nullable|max:30',//车系
            // 'meca_car_model' => 'sometimes|nullable|max:30',//车型
            'meca_car_frame' => 'sometimes|nullable|max:30',//车架号
            'meca_car_brand_series' => 'sometimes|nullable|max:255',//品牌车系
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 设置默认验证器
    public function carDefaultValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'meca_id.required' => '请输入会员车辆id',
            'meca_id.integer' => '参数类型错误',
            'meca_id.min' => '参数类型错误',
            'weus_id.required' => '请输入微信用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入微信用户id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'meca_id' => 'required|integer|min:1',
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
