<?php

namespace App\Http\Requests\Validators\WeChatApplet\Technician;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class MemberValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 列表验证器
    public function editMemberValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'mem_id.required' => '请输入会员id',
            'mem_id.integer' => '会员id参数类型错误',
            'mem_id.min' => '会员id参数类型错误',
            'mem_car_num.required' => '请输入车牌号',
            'mem_car_num.max' => '车牌号超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => 'required',
            'mem_id' => 'required|integer|min:1',
            'mem_car_num' => 'required|max:10',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
}
