<?php

namespace App\Http\Requests\Validators\WeChatApplet\Technician;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class ContactUsValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 列表验证器
    public function submitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'fee_pri_id.required' => '请输入模块id',
            'fee_pri_id.integer' => '参数类型错误',
            'fee_pri_id.min' => '参数类型错误',
            'fee_pri_name.required' => '请输入模块',
            'fee_title.required' => '请输入标题',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'fee_pri_id' => 'required|integer|min:1',
            'fee_pri_name' => 'required',
            // 'fee_title' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 列表验证器
    public function tryNowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'most_moudle_id.required' => '请输入模块id',
            'most_moudle.required' => '请输入模块',
            'most_moudle_id.integer' => '参数类型错误',
            'most_moudle_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'most_moudle_id' => 'required|integer|min:1',
            'most_moudle' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
}
