<?php

namespace App\Http\Requests\Validators\Shop;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 门店验证器
class ShopValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:posts|max:255',
            'body' => 'required',
        ];
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '请选择商品',
            'pait_id.integer' => '参数类型错误',
            'pait_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 列表验证器
    public function vipCardIndexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '请选择会员',
            'adm_id.integer' => '参数类型错误',
            'adm_id.min' => '参数类型错误',
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|integer|min:1',
            'pri_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增验证器
    public function addShopValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_name.required' => '请输入:联系人名称',
            'shop_name.max' => '联系人名称长度超过最大限制',
            'shop_phone.required' => '请输入:联系人手机号',
            'shop_phone.integer' => '手机号参数错误',
            'shop_store_name.required' => '请输入:门店名称',
            'shop_province.required' => '请选择所在区域',
            'shop_city.required' => '请选择所在区域',
            'shop_county.required' => '请选择所在区域',
            'shop_address.required' => '请输入:详细地址',
            // 'shop_config.required' => '请选择产品',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_name' => 'required|max:30', //联系人名称
            'shop_phone' => 'required|integer', //联系电话
            'shop_store_name' => 'required', //门店名称
            'shop_province' => 'required',
            'shop_city' => 'required',
            'shop_county' => 'required',
            'shop_address' => 'required',
            // 'shop_config' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 新增门店手机号验证
    public function verifyPhoneValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_phone.required' => '请输入手机号',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_phone' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 购买产品验证器
    public function addOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pro_id.required' => '请选择商品',
            'prog_pro_sell_number.required' => '请输入数量',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pro_id' => 'required',
            'prog_pro_sell_number' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 新增分类
    public function addClassificationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gocl_name.required' => '请输入:分类名称',
            'gocl_sort.required' => '请输入:排序',
            'gocl_name.max' => '分类名称长度超过最大限制',
            'gocl_state.required' => '开启状态错误',
            'gocl_state.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gocl_name' => 'required|max:6', //商品分类名称
            'gocl_sort' => 'required', //排序
            'gocl_state' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑分类验证器
    public function editClassificationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gocl_name.required' => '请输入:分类名称',
            'gocl_sort.required' => '请输入:排序',
            'gocl_name.max' => '分类名称长度超过最大限制',
            'gocl_state.required' => '开启状态错误',
            'gocl_state.in' => '参数错误',
            'gocl_id.required' => '请输入分类id',
            'gocl_id.integer' => '参数类型错误',
            'gocl_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gocl_name' => 'required|max:6', //商品分类名称
            'gocl_sort' => 'required', //排序
            'gocl_id' => 'required|integer|min:1',
            'gocl_state' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '请选择编辑的商品',
            'pait_id.integer' => '商品id参数错误',
            'pait_id.min' => '商品id参数错误',
            'pait_name.required' => '请输入:商品名称',
            'pait_name.max' => '商品名称长度超过最大限制',
            'pait_classify_id.required' => '请输入:分类',
            'pait_classify_id.integer' => '分类参数错误',
            'pait_saleable_quantity.required' => '请输入:可售数量',
            'pait_saleable_quantity.integer' => '可售数量参数错误',
            'pait_pic.required' => '请上传封面图片',
            'pait_shop_price.required' => '请输入:门市价',
            'pait_sell_price.required' => '请输入:零售价',
            'pait_ware_id.required' => '请选择仓库',
            'pait_ware_id.integer' => '仓库参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|integer|min:0', //商品id
            'pait_name' => 'required|max:30', //商品名称
            'pait_classify_id' => 'required|integer', //分类
            // 'pait_ware_id' => 'required|integer', //分类
            'pait_saleable_quantity' => 'required|integer', //可售数量
            'pait_pic' => 'required',
            'pait_shop_price' => 'required',
            'pait_sell_price' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '参数错误',
            'pait_id.integer' => '参数错误',
            'pait_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑验证器
    public function replenishmentValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '参数错误',
            'pait_id.integer' => '参数错误',
            'pait_id.min' => '参数错误',
            'number.required' => '请输入补货数量',
            'number.integer' => '参数错误',
            'number.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'number' => 'required|integer|min:1',
            'pait_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }


    // 开启分类
    public function claStartValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gocl_id.required' => '请输入会员卡id',
            'gocl_id.array' => '参数类型错误',
            'gocl_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gocl_id' => 'required|array|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 开启分类
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '请输入会员卡id',
            'pait_id.array' => '参数类型错误',
            'pait_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|array|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 删除分类验证器
    public function claDeleteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gocl_id.required' => '请输入会员卡id',
            'gocl_id.integer' => '参数类型错误',
            'gocl_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gocl_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 会员卡使用明细验证器
    public function detailIndexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mem_id.required' => '请输入会员id',
            'mem_id.integer' => '参数类型错误',
            'mem_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mem_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 更改二维码状态
    public function setQrStateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shqr_number.required' => '请重新扫码',
            'shqr_state.required' => '请重新扫码',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shqr_number' => 'required',
            'shqr_state' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 创建店铺-试用
    public function createShopValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_store_name.required' => '请输入公司名称',
            'service_scope.required' => '请选择服务范围',
            'shop_province.required' => '请选择省份',
            'shop_city.required' => '请选择市',
            'shop_county.required' => '请选择县',
            'shop_address.required' => '请输入详细地址',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_store_name' => 'required',
            'service_scope' => 'required',
            'shop_province' => 'required',
            'shop_city' => 'required',
            'shop_county' => 'required',
            'shop_address' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 购买店铺版本时长
    public function addShopOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shve_id.required' => '请选择版本',
            'shpr_id.required' => '请选择时长',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shve_id' => 'required',
            'shpr_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 短信充值
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-10
     * @param  [type]           $data [description]
     */
    public function addSmsOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mspa_type.required' => '请选择充值方式',
            'shor_pay_way.required' => '请选择支付方式',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mspa_type' => 'required',
            'shor_pay_way' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 短信套餐
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2023-10-10
     * @param  [type]           $data [description]
     */
    public function msgPackageValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mspa_type.required' => '请选择充值方式',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mspa_type' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 付款
    public function payShopOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shor_number.required' => '请选择付款订单',
            'shor_pay_account.required' => '请输入付款账号',
            'shor_pay_name.required' => '请输入付款户名',
            'shor_pay_time.required' => '请选择付款时间',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shor_number' => 'required',
            'shor_pay_account' => 'required',
            'shor_pay_name' => 'required',
            'shor_pay_time' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
    
    // 购买店铺版本补足差价
    public function getNeedPayValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请选择门店',
            'shpr_id.required' => '请选择时长',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required',
            'shpr_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 获取订单状态验证
    public function getOrderStateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shor_number.required' => '请输入订单号',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shor_number' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 审核订单
    public function checkShopValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shor_id.required' => '请选择审核订单',
            'checked.required' => '请审核订单',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shor_id' => 'required',
            'checked' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 短信设置
    public function msgSetValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_msg_remind.required' => '请输入预警条数',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_msg_remind' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 添加banner
    public function addBannerValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shba_pic.required' => '请上传图片',
            'shba_name.required' => '请输入标题',
            'shba_pait_id.required' => '请选择套餐',
            'shba_show.required' => '请选择是否显示',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shba_pic' => 'required',
            'shba_name' => 'required',
            'shba_pait_id' => 'required',
            'shba_show' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 添加banner
    public function delBannerValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shba_id.required' => '请选择banner',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shba_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 短信发送设置
    public function msgConfigValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'msco_is_send.required' => '请选择是否发送短信',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'msco_is_send' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 绑定分店
    public function bindShopValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_code.required' => '请输入门店编码',
            'bish_shop_type.required' => '请选择分店类型',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_code' => 'required',
            'bish_shop_type' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 绑定分店
    public function bindStateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'bish_id.required' => '请选择分店',
            'bish_state.required' => '请选择停启用',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'bish_id' => 'required',
            'bish_state' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 绑定分店列表
    public function bindIndexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 分店员工列表
    public function shopAdminValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'shop_id.required' => '请选择门店',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required',
            'shop_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 新增分店员工验证器
    public function addShopAdmValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'bish_id.required' => '请选择分店',
            'adm_name.required' => '请输入:员工姓名',
            'adm_name.max' => '员工姓名长度超过最大限制',
            'adm_phone.required' => '请输入:联系人电话',
            'adm_phone.regex' => '手机号格式不正确',
            'adm_account.required' => '请输入:用户名',
            'adm_account.min' => '用户名长度最少为15位',
            'adm_account.max' => '用户名长度超过最大限制',
            'adm_role.required' => '请选择角色',
            'adm_role.integer' => '参数类型错误',
            'adm_role.min' => '参数错误',
            'adm_leave.integer' => '参数错误',
            'adm_leave.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_name' => 'required|max:50',
            'bish_id' => 'required',
            'adm_phone' => ['required', 'regex:/^1[3456789]\d{9}$/'],
            'adm_role' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        // $validator->fails() 验证成功为 false ，验证失败为 true
        if ($validator->fails()) {
            // $validator->errors() 所有字段的错误消息
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 分店员工列表-编辑权限
    public function editShopRoleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请选择门店',
            'role_pc.required' => '请选择pc权限',
            'role_applet.required' => '请选择小程序权限',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required',
            'role_pc' => 'required',
            'role_applet' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 空间充值
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-12
     * @param  [type]           $data [description]
     */
    public function addSpaceOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_num.required' => '请输入数量',
            'shor_pay_way.required' => '请选择支付方式',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_num' => 'required',
            'shor_pay_way' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 获取空间金额
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-12
     * @param  [type]           $data [description]
     */
    public function getSpaPriceValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shpr_id.required' => '请选择时长',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shpr_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 取消
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-12
     * @param  [type]           $data [description]
     */
    public function cancelValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shor_id.required' => '请选择订单',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shor_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 编辑分店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-18
     * @param  [type]           $data [description]
     */
    public function editBindShopValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'bish_id.required' => '请选择要编辑的分店',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'bish_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 获取分店角色
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-20
     * @param  [type]           $data [description]
     */
    public function getShopRoleValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'bish_id.required' => '请选择分店',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'bish_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 在职离职
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-20
     * @param  [type]           $data [description]
     */
    public function editShopAdmValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'bish_id.required' => '请选择分店',
            'adm_id.required' => '请选择员工',
            'adm_state.required' => '请选择在职离职',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'bish_id' => 'required',
            'adm_id' => 'required',
            'adm_state' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 在职离职
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-20
     * @param  [type]           $data [description]
     */
    public function addmsgValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'bish_id.required' => '请选择分店',
            'bish_lshop_id.required' => '请选择分店',
            'payer_shop_id.required' => '请选择短信付出方',
            'payee_shop_id.required' => '请选择短信收受方',
            'message_num.required' => '请选择短信数量',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'bish_id' => 'required',
            'bish_lshop_id' => 'required',
            'payer_shop_id' => 'required',
            'payee_shop_id' => 'required',
            'message_num' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 购买分店
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-28
     * @param  [type]           $data [description]
     */
    public function buyShopValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'add_type.required' => '数据错误',
            // 'goo_num.required' => '请填写数量',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'add_type' => 'required',
            // 'goo_num' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 意见反馈
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-28
     * @param  [type]           $data [description]
     */
    public function feedBackValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '数据错误',
            // 'goo_num.required' => '请填写数量',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required',
            // 'goo_num' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 意见反馈确认
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-03-28
     * @param  [type]           $data [description]
     */
    public function confirmValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'fee_id.required' => '数据错误',
            // 'goo_num.required' => '请填写数量',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'fee_id' => 'required',
            // 'goo_num' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 空间划拨
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-09
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public function changeSpaceValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'bish_id.required' => '数据错误',
            'space_num.required' => '请填写数量',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'bish_id' => 'required',
            'space_num' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 培训视频列表
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-09
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public function videoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '数据错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 新增培训视频
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-09
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public function addVideoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'inv_type.required' => '请选择类型',
            'inv_name.required' => '请输入名称',
            'inv_url.required' => '请上传视频',
            'inv_time.required' => '请上传视频时长',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'inv_type' => 'required',
            'inv_name' => 'required',
            'inv_url' => 'required',
            'inv_time' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 编辑培训视频
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-09
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public function editVideoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'inv_id.required' => '请选择id',
            'inv_type.required' => '请选择类型',
            'inv_name.required' => '请输入名称',
            'inv_url.required' => '请上传视频',
            'inv_time.required' => '请上传视频',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'inv_id' => 'required',
            'inv_type' => 'required',
            'inv_name' => 'required',
            'inv_url' => 'required',
            'inv_time' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    /**
     * 修改店铺地址
     * @authors ldj
     * @email  909490343@qq.com
     * @date   2024-04-09
     * @param  [type]           $data [description]
     * @return [type]                 [description]
     */
    public function addAddressVideoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_province.required' => '请选择省',
            'shop_city.required' => '请选择市',
            'shop_county.required' => '请选择县',
            'shop_address.required' => '请填写地址',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_province' => 'required',
            'shop_city' => 'required',
            'shop_county' => 'required',
            'shop_address' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
}
