<?php

namespace App\Http\Requests\Validators\Shop;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 商品验证器
class ProPerformaceValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:posts|max:255',
            'body' => 'required',
        ];
    }
    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gppe_sale_id.required' => '请选择销售人员',
            'gppe_sale_id.integer' => '销售人员参数错误',
            'gppe_sale_name.required' => '请选择销售人员',
            'gppe_sale_name.max' => '销售人员名称长度超过最大限制',
            'gppe_type.required' => '请输入:分类',
            'gppe_type.integer' => '分类参数错误',
            'gppe_goo_id.required' => '请选择商品或服务',
            'gppe_goo_id.integer' => '参数错误',
            'gppe_goo_name.required' => '请选择商品或服务',
            'gppe_performance.required' => '请输入:绩效金额',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gppe_sale_id' => 'required|max:30', //商品名称
            'gppe_sale_name' => 'required|max:30', //商品名称
            'gppe_type' => 'required|integer', //类型
            'gppe_goo_id' => 'required|integer', //可售数量
            'gppe_goo_name' => 'required',
            'gppe_performance' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑绩效
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gppe_id.required' => '请选择绩效',
            'gppe_id.integer' => '参数错误',
            'gppe_performance.required' => '请输入:绩效',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gppe_id' => 'required|integer', //id
            'gppe_performance' => 'required', //绩效
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑分类验证器
    public function editClassificationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gocl_name.required' => '请输入:分类名称',
            'gocl_sort.required' => '请输入:排序',
            'gocl_name.max' => '分类名称长度超过最大限制',
            'gocl_state.required' => '开启状态错误',
            'gocl_state.in' => '参数错误',
            'gocl_id.required' => '请输入分类id',
            'gocl_id.integer' => '参数类型错误',
            'gocl_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gocl_name' => 'required|max:6', //商品分类名称
            'gocl_sort' => 'required', //排序
            'gocl_id' => 'required|integer|min:1',
            'gocl_state' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '参数错误',
            'pait_id.integer' => '参数错误',
            'pait_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 订单销售绩效验证器
    public function orderSalePerformanceValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '参数错误',
            'pri_id.integer' => '参数错误',
            'pri_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }


    // 开启
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gpt_sale_adm_id.required' => '请输入销售人员id',
            'gpt_sale_adm_id.integer' => '参数类型错误',
            'gpt_sale_adm_id.min' => '参数类型错误',
            'gpt_type.required' => '请选择类型',
            'gpt_type.integer' => '参数类型错误',
            'gpt_type.min' => '参数类型错误',
            'gpt_state.required' => '请选择状态',
            'gpt_state.integer' => '参数类型错误',
            'gpt_state.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gpt_sale_adm_id' => 'required|integer|min:1',
            'gpt_type' => 'required|integer|min:1',
            'gpt_state' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 获取类型
    public function getPerTypeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gpt_sale_adm_id.required' => '请输入销售人员id',
            'gpt_sale_adm_id.integer' => '参数类型错误',
            'gpt_sale_adm_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gpt_sale_adm_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 获取类型
    public function getOrderPerValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gppe_sale_id.required' => '请输入销售人员id',
            'gppe_sale_id.integer' => '参数类型错误',
            'gppe_sale_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gppe_sale_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }


    // 删除分类验证器
    public function claDeleteValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'gocl_id.required' => '请输入会员卡id',
            'gocl_id.integer' => '参数类型错误',
            'gocl_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'gocl_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 会员卡使用明细验证器
    public function detailIndexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mem_id.required' => '请输入会员id',
            'mem_id.integer' => '参数类型错误',
            'mem_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mem_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 关联套餐
    public function correlationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '请选择商品',
            'pait_id.integer' => '参数类型错误',
            'pait_id.min' => '参数类型错误',
            'copa_cpait_id.required' => '请选择商品',
            'copa_cpait_id.integer' => '参数类型错误',
            'copa_cpait_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|integer|min:1',
            'copa_cpait_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 关联套餐
    public function colistValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pait_id.required' => '请选择商品',
            'pait_id.integer' => '参数类型错误',
            'pait_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pait_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
}
