<?php

namespace App\Http\Requests\Validators\Point;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 积分验证器
class PointValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:posts|max:255',
            'body' => 'required',
        ];
    }

    // 新增积分商品
    public function addPointGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pogo_goo_type.required' => '请选择商品类型',
            'pogo_goo_type.integer' => '参数类型错误',
            'pogo_goo_type.min' => '参数类型错误',
            'pogo_goo_id.required' => '请选择商品',
            'pogo_goo_id.integer' => '参数类型错误',
            'pogo_goo_id.min' => '参数类型错误',
            'pogo_goo_point.required' => '请输入积分',
            'pogo_goo_point.integer' => '参数类型错误',
            'pogo_goo_point.min' => '参数类型错误',
            'pogo_enable.required' => '请选择是否开启',
            'pogo_enable.integer' => '参数类型错误',
            'pogo_enable.min' => '参数类型错误',
            'pogo_rule.required' => '请选择赠送规则',
            'pogo_rule.integer' => '参数类型错误',
            'pogo_rule.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pogo_goo_type' => 'required|integer|min:1',
            'pogo_goo_id' => 'required|integer|min:1',
            'pogo_goo_point' => 'required|integer|min:1',
            'pogo_rule' => 'required|integer|min:1',
            'pogo_enable' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑积分商品
    public function editPointGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pogo_id.required' => '请选择积分商品',
            'pogo_id.integer' => '参数类型错误',
            'pogo_id.min' => '参数类型错误',
            'pogo_goo_type.required' => '请选择商品类型',
            'pogo_goo_type.integer' => '参数类型错误',
            'pogo_goo_type.min' => '参数类型错误',
            'pogo_goo_id.required' => '请选择商品',
            'pogo_goo_id.integer' => '参数类型错误',
            'pogo_goo_id.min' => '参数类型错误',
            'pogo_goo_point.required' => '请输入积分',
            'pogo_goo_point.integer' => '参数类型错误',
            'pogo_goo_point.min' => '参数类型错误',
            'pogo_rule.required' => '请选择赠送规则',
            'pogo_rule.integer' => '参数类型错误',
            'pogo_rule.min' => '参数类型错误',
            'pogo_enable.required' => '请选择是否开启',
            'pogo_enable.integer' => '参数类型错误',
            'pogo_enable.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pogo_id' => 'required|integer|min:1',
            'pogo_goo_type' => 'required|integer|min:1',
            'pogo_goo_id' => 'required|integer|min:1',
            'pogo_goo_point' => 'required|integer|min:1',
            'pogo_rule' => 'required|integer|min:1',
            'pogo_enable' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 开启关闭
    public function editStateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pogo_id.required' => '请选择积分商品',
            'pogo_id.integer' => '参数类型错误',
            'pogo_id.min' => '参数类型错误',
            'pogo_enable.required' => '请选择开启关闭',
            'pogo_enable.integer' => '参数类型错误',
            'pogo_enable.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pogo_id' => 'required|integer|min:1',
            'pogo_enable' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 获取商品验证器
    public function getGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '请选择商品类型',
            'type.integer' => '参数类型错误',
            'type.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 新增签到礼品
    public function addSignGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sigo_goo_type.required' => '请选择商品类型',
            'sigo_goo_type.integer' => '参数类型错误',
            'sigo_goo_type.min' => '参数类型错误',
            'sigo_goo_id.required' => '请选择商品',
            'sigo_goo_id.integer' => '参数类型错误',
            'sigo_goo_id.min' => '参数类型错误',
            'sigo_sign_days.required' => '请输入签到天数',
            'sigo_sign_days.integer' => '参数类型错误',
            'sigo_sign_days.min' => '参数类型错误',
            'sigo_sign_num.required' => '请输入生效次数',
            'sigo_sign_num.integer' => '参数类型错误',
            'sigo_sign_num.min' => '参数类型错误',
            'sigo_sign_type.required' => '请选择签到方式',
            'sigo_sign_type.integer' => '参数类型错误',
            'sigo_sign_type.min' => '参数类型错误',
            'sigo_start_time.required' => '请输入开始日期',
            'sigo_end_time.required' => '请输入结束日期',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sigo_goo_type' => 'required|integer|min:1',
            'sigo_goo_id' => 'required|integer|min:1',
            'sigo_sign_days' => 'required|integer|min:1',
            'sigo_sign_type' => 'required|integer|min:1',
            'sigo_sign_num' => 'required|integer|min:1',
            'sigo_start_time' => 'required',
            'sigo_end_time' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑签到礼品
    public function editSignGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sigo_id.required' => '请选择商品',
            'sigo_id.integer' => '参数类型错误',
            'sigo_id.min' => '参数类型错误',
            'sigo_sign_days.required' => '请输入签到天数',
            'sigo_sign_days.integer' => '参数类型错误',
            'sigo_sign_days.min' => '参数类型错误',
            'sigo_sign_num.required' => '请输入生效次数',
            'sigo_sign_num.integer' => '参数类型错误',
            'sigo_sign_num.min' => '参数类型错误',
            'sigo_start_time.required' => '请输入开始日期',
            'sigo_end_time.required' => '请输入结束日期',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sigo_id' => 'required|integer|min:1',
            'sigo_sign_days' => 'required|integer|min:1',
            'sigo_sign_num' => 'required|integer|min:1',
            'sigo_start_time' => 'required',
            'sigo_end_time' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 终止
    public function signStateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'sigo_id.required' => '请选择商品',
            'sigo_id.integer' => '参数类型错误',
            'sigo_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'sigo_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 新增积分商品
    public function addPointGiftValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pogg_goo_type.required' => '请选择商品类型',
            'pogg_goo_type.integer' => '参数类型错误',
            'pogg_goo_type.min' => '参数类型错误',
            'pogg_goo_name.required' => '请选择商品',
            'pogg_exchange_person.required' => '签到限制每人次数',
            'pogg_exchange_person.integer' => '参数类型错误',
            'pogg_exchange_person.min' => '参数类型错误',
            'pogg_exchange_day.required' => '签到限制每天次数',
            'pogg_exchange_day.integer' => '参数类型错误',
            'pogg_exchange_day.min' => '参数类型错误',
            'pogg_goo_point.required' => '请输入积分',
            'pogg_goo_point.integer' => '参数类型错误',
            'pogg_goo_point.min' => '参数类型错误',
            'pogg_state.required' => '请选择开启状态',
            'pogg_state.integer' => '参数类型错误',
            'pogg_state.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pogg_goo_type' => 'required|integer|min:1',
            'pogg_goo_name' => 'required',
            'pogg_exchange_person' => 'required|integer|min:1',
            'pogg_exchange_day' => 'required|integer|min:1',
            'pogg_goo_point' => 'required|integer|min:1',
            'pogg_state' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 编辑积分商品
    public function editPointGiftValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pogg_id.required' => '请选择积分商品',
            'pogg_id.integer' => '参数类型错误',
            'pogg_id.min' => '参数类型错误',
            'pogg_goo_type.required' => '请选择商品类型',
            'pogg_goo_type.integer' => '参数类型错误',
            'pogg_goo_type.min' => '参数类型错误',
            'pogg_goo_name.required' => '请选择商品',
            'pogg_exchange_person.required' => '签到限制每人次数',
            'pogg_exchange_person.integer' => '参数类型错误',
            'pogg_exchange_person.min' => '参数类型错误',
            'pogg_exchange_day.required' => '签到限制每天次数',
            'pogg_exchange_day.integer' => '参数类型错误',
            'pogg_exchange_day.min' => '参数类型错误',
            'pogg_goo_point.required' => '请输入积分',
            'pogg_goo_point.integer' => '参数类型错误',
            'pogg_goo_point.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pogg_id' => 'required|integer|min:1',
            'pogg_goo_type' => 'required|integer|min:1',
            'pogg_goo_name' => 'required',
            'pogg_exchange_person' => 'required|integer|min:1',
            'pogg_exchange_day' => 'required|integer|min:1',
            'pogg_goo_point' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 开启关闭积分商品
    public function poggStateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pogg_id.required' => '请选择积分商品',
            'pogg_id.integer' => '参数类型错误',
            'pogg_id.min' => '参数类型错误',
            'pogg_state.required' => '请选择开启关闭',
            'pogg_state.integer' => '参数类型错误',
            'pogg_state.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pogg_id' => 'required|integer|min:1',
            'pogg_state' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }
}
