<?php

namespace App\Http\Requests\Validators\Business;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 工单列表验证器
class WashWorkValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 订单详情验证器
    public function orderInfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入工单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 签名验证器
    public function signatureSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'img_path.required' => '请传入签字图片路径',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'img_path' => 'required|max:300',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 审核查看验证器
    public function checkShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
    
    // 审核验证器
    public function checkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'remark.required' => '请输入备注',
            'remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 预约设置验证器，技师小程序预约设置使用
    public function appointmentSetValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'appoint_time.required' => '请选择时间',
            'appoint_time.date' => '参数类型错误',
            'appoint_remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'appoint_time' => 'required|date',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'appoint_remark' => 'sometimes|nullable|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单预约设置验证器，技师小程序预约设置使用
    public function appointmentOrderSetValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'appoint_time.required' => '请选择时间',
            'appoint_time.date' => '参数类型错误',
            'appoint_remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'appoint_time' => 'required|date',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'appoint_remark' => 'sometimes|nullable|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-首页
    public function homeValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'adm_id.required' => '请输入技师id',
            'adm_id.integer' => '参数类型错误',
            'adm_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'adm_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-首页派单
    public function dispatchListValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['0', '1', '2','3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-验车验证器
    public function validateCarValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '参数错误',
            'type.in' => '参数错误',
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ],
            'wor_id' => 'required|integer|min:1',
            // 'orvc_film_roll_number' => 'required_if:type,2|max:80',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    
    // 技师小程序-验车验证器
    public function checkCarValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 技师小程序-补充验车验证器
    public function addCheckCarValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '参数错误',
            'wor_id.integer' => '参数错误',
            'wor_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 技师小程序-验车取消选择验证器
    public function cancelSelectValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vaca_id.required' => '参数错误',
            'vaca_id.integer' => '参数错误',
            'vaca_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vaca_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 技师小程序-施工完成提交
    public function accomplishValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-施工提交
    public function submitConstructionValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'type.required' => '请输入类型',
            'type.integer' => '参数类型错误',
            'type.in' => '参数类型错误',
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'sub_work_data.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'sub_work_data' => 'required',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-质检
    public function qualityTestingValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'type.required' => '请输入类型',
            'type.integer' => '参数类型错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 技师小程序-接单提交
    public function receiveSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'receive_data.required' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            // 'receive_data' => 'required|',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 工单-重新派单
    public function assignValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'service_adm_id.required' => '请选择组长',
            'service_adm_id.integer' => '参数类型错误',
            'service_adm_id.min' => '参数类型错误',
            'service_adm_data.required' => '请选择技师',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            // 'service_adm_id' => 'required|integer|min:1',
            'service_adm_data' => 'required',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 工单-重新派单
    public function assignShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'service_adm_id.required' => '请选择组长',
            'service_adm_id.integer' => '参数类型错误',
            'service_adm_id.min' => '参数类型错误',
            'service_adm_data.required' => '请选择技师',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            // 'service_adm_id' => 'required|integer|min:1',
            // 'service_adm_data' => 'required',
            'type' => [
                    'required',
                    Rule::in(['1', '2']),
                ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 获取绩效基础金额
    public function getMeritPayValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'choose_type.required' => '请输入工单id',
            'choose_type.integer' => '参数类型错误',
            'choose_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'choose_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 绩效管理-获取车型验证器
    public function getMeritPayCarValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pema_type.required' => '参数类型错误',
            'pema_type.in' => '参数类型错误',
            'pema_name.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pema_name' => 'sometimes|nullable|max:20',//查询名称
            'pema_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 验证绩效金额
    public function checkMeritPay($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'choose_type.required' => '请输入车型',
            'choose_type.integer' => '参数类型错误',
            'choose_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'choose_type' => [
                'required',
                Rule::in(['2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 工单历史验证器
    public function getWorkHistoryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 修改技师验证器
    public function editTechnicianValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
            'adm_id.required' => '请输入技师id',
            'adm_id.integer' => '参数类型错误',
            'adm_id.min' => '参数类型错误',
            'adm_name.required' => '请输入技师名称',
            'adm_phone.required' => '请输入技师电话'
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
            'adm_id' => 'required|integer|min:1',
            // 'adm_name' => 'required',
            // 'adm_phone' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 撤回工单验证器
    public function withdrawValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请输入工单id',
            'wor_id.integer' => '参数类型错误',
            'wor_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 排班计划验证器
    public function planappIndexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wopl_date.required' => '请选择日期',
            'wopl_date.date' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wopl_date' => 'required|date',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 完工左侧列表
    public function getLeftValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请选择工单',
            'wor_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 完工信息添加
    public function completionInfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请选择工单',
            'wor_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 完工
    public function completionValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请选择工单',
            'wor_id.integer' => '参数类型错误',
            'coin_type.required' => '请选择上传类型',
            'coin_type.integer' => '参数类型错误',
            'adm_id.required' => '请选择技师',
            'adm_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer',
            'coin_type' => 'required|integer',
            'adm_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 完工删除
    public function cancelComValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'coin_id.required' => '请选择标签',
            'coin_id.integer' => '参数类型错误',
            'coin_type.required' => '请选择上传类型',
            'coin_type.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'coin_id' => 'required|integer',
            'coin_type' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 质检
    public function qualityValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请选择工单',
            'wor_id.integer' => '参数类型错误',
            'quda_type.required' => '请选择上传类型',
            'quda_type.integer' => '参数类型错误',
            'adm_id.required' => '请选择技师',
            'adm_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer',
            'quda_type' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 质检删除
    public function cancelQualityValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'quda_id.required' => '请选择标签',
            'quda_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'quda_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 余料废料存储
    public function materialsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请选择工单',
            'wor_id.integer' => '参数类型错误',
            'type.required' => '请选择上传类型',
            'type.integer' => '参数类型错误',
            'data.required' => '请填写数据',
            'data.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer',
            'type' => 'required|integer',
            'data' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 同步图片
    public function userPicStateValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请选择工单',
            'wor_id.integer' => '参数类型错误',
            'state.required' => '请选择状态',
            'state.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer',
            'state' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 同步图片
    public function cancelOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'wor_id.required' => '请选择工单',
            'wor_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'wor_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }
}
