<?php

namespace App\Http\Requests\Validators\Business;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 支付验证器
class WashPayValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:posts|max:255',
            'body' => 'required',
        ];
    }
    // 列表验证器
    public function wxpayValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pror_id.required' => '请选择支付订单',
            'pror_id.integer' => '参数类型错误',
            'pror_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pror_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
             // $validator->errors()->messages();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            'orcl_carowner_name.required' => '请输入:车主姓名',
            'orcl_carowner_name.max' => '姓名长度超过最大限制',
            'orcl_carowner_phone.required' => '请输入:车主电话',
            'orcl_carowner_phone.max' => '车主电话长度超过最大限制',
            'ord_payment_way.required' => '请选择结算方式',
            'ord_type.required' => '请选择买家类型',
            'ord_address.required' => '请选择施工门店',
            'ord_address_type.required' => '请选择施工门店',
            'ord_address_id.required' => '请选择施工门店',
            'ord_address.max' => '地址长度超过最大限制',
            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
            'reli_id.required' => '预约单id',
            'reli_id.integer' => '数据类型不正确',
            'reli_id.min' => '参数错误',
            'add_type.required' => '请输入新增类型',
            'add_type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_type' => [ //读取配置文件数据，买家类型：1会员零售2客户单位
                'required',
                Rule::in([1,2]),
            ],

            'orcl_name' => 'required|max:20', //客户姓名
            'orcl_phone' => ['required','regex:/^1[3456789]\d{9}$/'],// 客户手机号
            'orcl_carowner_name' => 'required|max:20', //车主姓名
            'orcl_carowner_phone' => 'required|max:11', //车主电话
            'ord_address' => 'required|max:255',
            'ord_address_type' => 'required',
            'ord_address_id' => 'required',
            'ord_client_id' => 'required|integer|min:0',
            'reli_id' => 'sometimes|nullable|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
        }
    }

    // 新增验证器
    public function addReservationValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请选择预约门店',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'sepr_id.required' => '请选择预约项目',
            'sepr_id.integer' => '参数类型错误',
            'sepr_id.min' => '参数类型错误',
            'appoint_time.required' => '请输入预约时间',
            'appoint_time.date' => '参数类型错误',
            // 'name.required' => '请输入联系人姓名',
            // 'name.max' => '参数类型错误',
            // 'phone.required' => '请输入电话',
            // 'phone.numeric' => '参数类型错误',
            // 'car_num.max' => '参数类型错误',
            // 'car_vin.max' => '参数类型错误',
            // 'car_brand_series.required' => '请选择品牌车系',
            // 'car_brand_series.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
            'sepr_id' => 'required|integer|min:1',
            'appoint_time' => 'required|date',
            // 'appoint_remark' => 'sometimes|nullable|max:255',
            // 'name' => 'required|max:20',//  姓名
            // 'phone' => 'required|numeric',//联系电话
            // 'car_num' => 'max:10',//车牌号
            // 'car_vin' => 'sometimes|nullable|max:100',//车架号车辆识别码
            // 'car_brand_series' => 'required|max:255',//品牌车系
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_type.required' => '请选择买家类型',
            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            'orcl_carowner_name.required' => '请输入:车主姓名',
            'orcl_carowner_name.max' => '姓名长度超过最大限制',
            'orcl_carowner_phone.required' => '请输入:车主电话',
            'orcl_carowner_phone.max' => '车主电话长度超过最大限制',
            'ord_address_type.required' => '请选择施工门店',
            'ord_address_id.required' => '请选择施工门店',
            'ord_address.required' => '请选择施工门店',
            'ord_address.max' => '地址长度超过最大限制',
            'orcl_channel_unit.required_if' => '请输入:客户单位',
            'orcl_channel_unit.max' => '客户单位长度超过最大限制',
            'orcl_check_car_state.required' => '请选择是否验车',
            'orcl_check_car_state.in' => '参数错误',
            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 'ord_payment_way' => [//结算方式1.账期 2.现结 3微信 4支付宝
            //         'required',
            //         Rule::in(config('apisystem.ORDER_PAYMENT_WAY')),
            //     ],
            'ord_type' => [ //读取配置文件数据，买家类型：1会员零售2客户单位
                'required',
                Rule::in(config('apisystem.ORDER_BUYER_TYPE')),
            ],
            'ord_remark' => 'sometimes|nullable|max:255',
            'ord_address' => 'required|max:255',
            'ord_address_type' => 'required',
            'ord_address_id' => 'required',
            'orcl_name' => 'required|max:20', //客户姓名
            'orcl_carowner_name' => 'required|max:20', //车主姓名
            'orcl_carowner_phone' => 'required|max:11', //车主电话
            'orcl_channel_unit' => 'sometimes|required_if:ord_type,2|max:50',
            'ord_client_id' => 'required|integer|min:0',
            // 'orcl_check_car_state' => [//是否验车：1是2否
            //         'required',
            //         Rule::in(['1', '2']),
            //     ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 编辑验证器
    public function editShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages = $validator->errors()->all();
            return $messages[0];
            // return $validator->errors()->messages();
        }
    }

    // 验车查询验证器
    public function validateCarShowValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
            'ord_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 验车验证器
    public function validateCarValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '参数错误',
            'ord_id.integer' => '参数错误',
            'ord_id.min' => '参数错误',
            'orvc_mileage.required' => '请输入进店里程数',
            'orvc_mileage.integer' => '参数错误',
            'orvc_mileage.min' => '参数错误',
            'orvc_film_roll_number.required' => '请输入膜卷号',
            'orvc_film_roll_number.max' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'orvc_mileage' => 'required|integer|min:0',
            // 'orvc_film_roll_number' => 'required|max:80',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 后台签字图片提交验证器
    public function pcsignatureSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'img_path.required' => '请传入签字图片路径',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
            'img_path' => 'required|max:300',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-列表验证器
    public function indexWashValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-列表验证器
    public function busreindexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'buac_id.required' => '请输入用户id',
            'buac_id.integer' => '参数类型错误',
            'buac_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'buac_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-详情验证器
    public function infoWashValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信小程序-合作商详情验证器
    public function infoBusValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'buac_id.required' => '请输入用户id',
            'buac_id.integer' => '参数类型错误',
            'buac_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'buac_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-详情验证器
    public function busreinfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'buac_id.required' => '请输入用户id',
            'buac_id.integer' => '参数类型错误',
            'buac_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'reli_id.required' => '请输入订单id',
            'reli_id.integer' => '参数类型错误',
            'reli_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'buac_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'reli_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-详情验证器
    public function withdrawValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'buac_id.required' => '请输入用户id',
            'buac_id.integer' => '参数类型错误',
            'buac_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'reli_id.required' => '请输入订单id',
            'reli_id.integer' => '参数类型错误',
            'reli_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'buac_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'reli_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-详情验证器
    public function reinfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'reli_id.required' => '请输入订单id',
            'reli_id.integer' => '参数类型错误',
            'reli_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'reli_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-签字图片提交验证器
    public function signatureSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'weus_id.required' => '请输入用户id',
            'weus_id.integer' => '参数类型错误',
            'weus_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'img_path.required' => '请传入签字图片路径',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'weus_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
            'img_path' => 'required|max:300',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 微信用户小程序-签字图片提交验证器
    public function busSignatureSubmitValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'buac_id.required' => '请输入用户id',
            'buac_id.integer' => '参数类型错误',
            'buac_id.min' => '参数类型错误',
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'img_path.required' => '请传入签字图片路径',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'buac_id' => 'required|integer|min:1',
            'shop_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
            'ord_id' => 'required|integer|min:1',
            'img_path' => 'required|max:300',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 备注验证器
    public function remarkValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'remark.required' => '请输入备注',
            'remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
            'remark' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 备注验证器
    public function buscancelValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 预约设置验证器
    public function appointmentSetValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'appoint_time.required' => '请选择时间',
            'appoint_time.date' => '参数类型错误',
            'appoint_remark.max' => '超过最大长度255字符',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
            'appoint_time' => 'required|date',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'appoint_remark' => 'nullable|max:255',
            // 'vacm_type' => [
            //     'required',
            //     Rule::in([1,2]),
            // ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 添加作品验证器
    public function addOrderWorksValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'orwo_title.required' => '请输入标题',
            'orwo_title.max' => '超过最大长度255字符',
            'orwo_type.required' => '请选择类型',
            'orwo_type.in' => '参数类型错误',
            'orwo_data.required' => '请上传作品',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
            'orwo_title' => 'required|max:255',
            'orwo_data' => 'required',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'appoint_remark' => 'sometimes|nullable|max:255',
            'orwo_type' => [
                'required',
                Rule::in([1,2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单作品列表验证器
    public function OrderWorksindexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单作品详情验证器
    public function OrderWorksinfoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orwo_id.required' => '请输入订单作品id',
            'orwo_id.integer' => '参数类型错误',
            'orwo_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'orwo_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑作品验证器
    public function OrderWorkseditValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orwo_id.required' => '请输入订单id',
            'orwo_id.integer' => '参数类型错误',
            'orwo_id.min' => '参数类型错误',
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'orwo_title.required' => '请输入标题',
            'orwo_title.max' => '超过最大长度255字符',
            'orwo_type.required' => '请选择类型',
            'orwo_type.in' => '参数类型错误',
            'orwo_data.required' => '请上传作品',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'orwo_id' => 'required|integer|min:0',
            'ord_id' => 'required|integer|min:0',
            'orwo_title' => 'required|max:255',
            'orwo_data' => 'required',
            // nullable 验证的字段可以为 null。例如可以包含空值的字符串和整数。
            'appoint_remark' => 'sometimes|nullable|max:255',
            'orwo_type' => [
                'required',
                Rule::in([1,2]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单作品删除验证器
    public function OrderWorksdelValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orwo_id.required' => '请输入作品id',
            'orwo_id.integer' => '参数类型错误',
            'orwo_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'orwo_id' => 'required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单审核修正验证器
    public function auditOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'ord_actual_price.required' => '请输入订单金额',
            'ord_actual_price.numeric' => '参数类型错误',
            'ord_actual_price.min' => '参数类型错误',
            // 'orit_service_price.required' => '请输入服务金额',
            // 'orit_service_price.numeric' => '参数类型错误',
            // 'orit_service_price.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
            'ord_actual_price' => 'required|numeric|min:0',
            // 'orit_service_price' => 'required|numeric|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单结算验证器
    public function settlementValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'ord_actual_price.required' => '请输入订单金额',
            'ord_actual_price.numeric' => '参数类型错误',
            'ord_actual_price.min' => '参数类型错误',
            'ord_payment_way.required' => '请选择结算方式',
            'ord_payment_way.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
            'ord_actual_price' => 'required|numeric|min:0',
            'ord_payment_way' => [
                'required',
                Rule::in([1,2,3,4,5]),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 取消订单结算验证器
    public function cancelSettlementValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'ord_cancel_reason.required' => '请输入取消结算原因',
            'ord_cancel_reason.max' => '参数超出长度',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
            'ord_cancel_reason' => 'required|max:255',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 订单历史验证器
    public function getOrderHistoryValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入工单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 搜索商品验证器
    public function searchGoodsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_bra_id.required' => '参数错误',
            'goo_bra_id.integer' => '数据类型不正确',
            'goo_bra_id.min' => '参数错误',
            'goo_cate_id.required' => '参数错误',
            'goo_cate_id.integer' => '数据类型不正确',
            'goo_cate_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_bra_id' => 'sometimes|required|integer|min:0',
            'goo_cate_id' => 'sometimes|required|integer|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 新增会员
    public function addMemberValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mem_name.required' => '请输入会员姓名',
            'mem_name.max' => '参数超出长度',
            'mem_phone.required' => '请输入手机号',
            'mem_car_num.required' => '请输入车牌号',
            'mem_car_series.required' => '请输入品牌车系',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mem_name' => 'required|max:80',
            'mem_phone' => 'required',
            'mem_car_num' => 'required',
            'mem_car_series' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增会员
    public function addBusinessAccValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'buac_name.required' => '请输入会员姓名',
            'buac_name.max' => '参数超出长度',
            'buac_phone.required' => '请输入手机号',
            'buac_password.required' => '请输入密码',
            'buac_bucl_id.required' => '请选择合作商',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'buac_name' => 'required|max:80',
            'buac_phone' => 'required',
            'buac_password' => 'required',
            'buac_bucl_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增洗车单验证器
    public function addWashCarOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'orcl_name.required' => '请输入:姓名',
            'orcl_name.max' => '姓名长度超过最大限制',
            'sepr_name.required' => '请输入:姓名',
            'sepr_name.max' => '姓名长度超过最大限制',
            'orcl_phone.required' => '请输入:电话',
            'orcl_phone.max' => '电话长度超过最大限制',
            'orcl_car_brand_series.required' => '请输入:品牌车系',
            'ord_payment_way.required' => '请选择结算方式',
            'ord_type.required' => '请选择买家类型',
            'orcl_car_num.required_if' => '请输入:车牌号',
            'orcl_car_num.max' => '车牌号长度超过最大限制',
            'ord_client_id.required' => '请选择客户信息',
            'ord_client_id.integer' => '数据类型不正确',
            'ord_client_id.min' => '参数错误',
            'sepr_id.required' => '请选择服务信息',
            'sepr_id.integer' => '数据类型不正确',
            'sepr_id.min' => '参数错误',
            'service_adm_id.required' => '请选择施工人员信息',
            'service_adm_id.integer' => '数据类型不正确',
            'service_adm_id.min' => '参数错误',
            'ord_order_price.required' => '请输入金额',
            'ord_order_price.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_payment_way' => [//结算方式1.账期 2.现结 3微信 4支付宝
                    'required',
                ],
            // 'orcl_name' => 'required|max:20', //客户姓名
            'sepr_name' => 'required|max:20', //客户姓名
            'ord_type' => 'required', //客户类型
            // 'orcl_car_brand_series' => 'required', //品牌车系
            // 'orcl_phone' => ['required','regex:/^1[3456789]\d{9}$/'],// 客户手机号
            // 'orcl_car_num' => 'sometimes|required_if:ord_type,1|max:10',//客户车牌号
            'ord_client_id' => 'required|integer|min:0',
            'sepr_id' => 'required|integer|min:0',
            'service_adm_id' => 'required|integer|min:0',
            'ord_order_price' => 'required|min:0',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $messages =  $validator->errors()->all();
            return $messages[0];
        }
    }

    // 扫码-二维码
    public function scanValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vico_id.required' => '请输入会员卡二维码',
            'vico_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vico_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 查询会员卡
    public function getmyVipValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'myvi_sepr_id.required' => '请选择服务项目',
            'myvi_sepr_id.integer' => '参数类型错误',
            'user_id.required' => '请选择客户',
            'user_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'myvi_sepr_id' => 'required|integer',
            'user_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 洗车接单
    public function receiveOrderValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请输入订单id',
            'ord_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 查询可用会员卡
    public function pcgetmyVipValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'mem_phone.required' => '请输入会员手机号',
            'mem_phone.integer' => '参数类型错误',
            'myvi_sepr_id.required' => '请输入服务id',
            'myvi_sepr_id.integer' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'mem_phone' => ['required','regex:/^1[3456789]\d{9}$/'],// 客户手机号
            'myvi_sepr_id' => 'required|integer',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->messages();
            return $msg[0];
        }
    }

    // 接单
    public function receiveValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ord_id.required' => '请选择订单id',
            'ord_id.integer' => '参数类型错误',
            'ord_id.min' => '参数类型错误',
            'ord_address.required' => '请输入:地址',
            'ord_address_type.required' => '请输入:地址',
            'ord_address_id.required' => '请输入:地址',
            'ord_address.max' => '地址长度超过最大限制',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ord_id' => 'required|integer|min:0',
            'ord_address' => 'required|max:255',
            'ord_address_type' => 'required',
            'ord_address_id' => 'required',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }
}
