<?php

namespace App\Http\Requests\Validators\Business;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 发货列表验证器
class WashDispatchValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'title' => 'required|unique:posts|max:255',
            'body' => 'required',
        ];
    }

    // 发货验证器
    public function shipmentsValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
            'dego_id.min' => '参数错误',
            'type.required' => '参数错误',
            'type.in' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dego_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 发货详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
            'dego_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'dego_id' => 'required|integer|min:1',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors();
        }
    }

    // 获取仓库
    public function getWareHousesValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '数据类型不正确',
            'goo_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'goo_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }

    // 更换仓库
    public function changeWareValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'ware_id.required' => '参数错误',
            'ware_id.integer' => '数据类型不正确',
            'ware_id.min' => '参数错误',
            'dego_id.required' => '参数错误',
            'dego_id.integer' => '数据类型不正确',
            'dego_id.min' => '参数错误',
            'goo_id.required' => '参数错误',
            'goo_id.integer' => '数据类型不正确',
            'goo_id.min' => '参数错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'ware_id' => 'required|integer|min:1',
            'dego_id' => 'required|integer|min:1',
            'goo_id' => 'required|integer|min:1'
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            $msg = $validator->errors()->all();
            return $msg[0];
        }
    }
}
