<?php

namespace App\Http\Requests\Validators\BasicManagement;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

class ValidateCarManageValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
            'vacm_type.required' => '参数类型错误',
            'vacm_type.in' => '参数类型错误',
            'vacm_unusual_name.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',//权限id
            'vacm_unusual_name' => 'sometimes|nullable|max:20',//查询名称
            'vacm_type' => [
                'required',
                Rule::in(['1', '2', '3']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 小程序查询-列表验证器
    public function WeChatIndexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vacm_type.required' => '参数类型错误',
            'vacm_type.in' => '参数类型错误',
            'vacm_unusual_name.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vacm_unusual_name' => 'sometimes|nullable|max:20',//查询名称
            'vacm_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
    
    // 新增
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vacm_type.required' => '参数类型错误',
            'vacm_type.in' => '参数类型错误',
            'vacm_unusual_name.required' => '请输入异常名称',
            'vacm_unusual_name.max' => '参数类型错误',
            'vacm_remark.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vacm_remark' => 'sometimes|nullable|max:255',//备注
            'vacm_unusual_name' => 'required|max:20',//名称
            'vacm_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vacm_type.required' => '参数类型错误',
            'vacm_type.in' => '参数类型错误',
            'vacm_id.required' => '参数类型错误',
            'vacm_id.integer' => '参数类型错误',
            'vacm_id.min' => '参数类型错误',
            'vacm_unusual_name.required' => '请输入异常名称',
            'vacm_unusual_name.max' => '参数类型错误',
            'vacm_remark.max' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vacm_id' => 'required|integer|min:1',
            'vacm_remark' => 'sometimes|nullable|max:255',//备注
            'vacm_unusual_name' => 'required|max:20',//名称
            'vacm_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 启用
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vacm_id.required' => '参数类型错误',
            'vacm_id.array' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vacm_id' => 'required|array',
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 搜索验车管理数据
    public function searchValidateCarValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'vacm_type.required' => '参数类型错误',
            'vacm_type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'vacm_type' => [
                'required',
                Rule::in(['1', '2']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
