<?php

namespace App\Http\Requests\Validators\BasicManagement;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;
use Validator;

// 基础管理-作品管理
class ProductionManageValidator extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    // 列表验证器
    public function indexValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'pri_id.required' => '请输入权限id',
            'pri_id.integer' => '参数类型错误',
            'pri_id.min' => '参数类型错误',
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'pri_id' => 'required|integer|min:1',
            'type' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
    
    // 用户查询列表验证器
    public function indexUserValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'shop_id.required' => '请输入门店id',
            'shop_id.integer' => '参数类型错误',
            'shop_id.min' => '参数类型错误',
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'shop_id' => 'required|integer|min:1',
            'type' => [
                'required',
                // Rule::in(['1', '2', '3', '4']),
                Rule::in(['2', '5']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 详情验证器
    public function infoValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'id.required' => '请输入详情id',
            'id.integer' => '参数类型错误',
            'id.min' => '参数类型错误',
            // 'type.required' => '参数类型错误',
            // 'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'id' => 'required|integer|min:1',
            // 'type' => [
            //     'required',
            //     Rule::in(['4']),
            // ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 新增验证器
    public function addValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'classify_prma_id.integer' => '参数类型错误',
            'classify_prma_id.min' => '参数类型错误',
            'module_prma_id.integer' => '参数类型错误',
            'module_prma_id.min' => '参数类型错误',
            'name.required' => '参数类型错误',
            'name.max' => '参数类型错误',
            'type.required' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            // 'classify_prma_id' => 'sometimes|nullable|integer|min:1',
            'module_prma_id' => 'sometimes|nullable|integer|min:1',
            'name' => 'required|max:10',//	名称
            'remark' => 'sometimes|nullable|max:255',//备注
            'type' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 编辑验证器
    public function editValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'id.required' => '参数类型错误',
            'id.integer' => '参数类型错误',
            'id.min' => '参数类型错误',
            'classify_prma_id.integer' => '参数类型错误',
            'classify_prma_id.min' => '参数类型错误',
            'module_prma_id.integer' => '参数类型错误',
            'module_prma_id.min' => '参数类型错误',
            'name.required' => '参数类型错误',
            'name.max' => '参数类型错误',
            'type.required' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'id' => 'required|integer|min:1',
            // 'classify_prma_id' => 'sometimes|nullable|integer|min:1',
            'module_prma_id' => 'sometimes|nullable|integer|min:1',
            'name' => 'required|max:10',//	名称
            'remark' => 'sometimes|nullable|max:255',//备注
            'type' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }

    // 启用、停用验证器
    public function startValidator($data)
    {
        // 自定义错误消息
        $messages = [
            'id.required' => '参数类型错误',
            'id.array' => '参数类型错误',
            'type.required' => '参数类型错误',
            'type.in' => '参数类型错误',
        ];

        // 数据验证
        $validator = Validator::make($data, [
            'id' => 'required|array',//	名称
            'type' => [
                'required',
                Rule::in(['1', '2', '3', '4']),
            ],
        ], $messages);

        // 判断数据验证是否成功
        if ($validator->fails()) {
            return $validator->errors()->messages();
        }
    }
}
