<?php
namespace App\Http\Models\Services\WarehouseManage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\OutinRecord;
use App\Http\Models\Api\WarehouseManage\Stocktake;
use App\Http\Models\Services\WarehouseManage\OutinStockLock;

class StocktakeOrder extends Model
{
    /**
     * [saveSubmitData 保存提交的数据]
     * @param  [type] $request      [提交的数据]
     * @param  [type] $goods_data   [提交的商品数据]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $type         [类型：1保存2提交]
     * @return [type]               [description]
     */
    public static function saveSubmitData(
        $request,
        $goods_data,
        $user_info,
        $type
    ) {
        $stocktake_number = 0;  //良品盘点数量
        $priority_stocktake_number = 0;  //优先盘点数量
        $unchecked_stocktake_number = 0;  //待检测盘点数量
        foreach ($goods_data as $key => $value) {
            // 只有旧货仓用到待检测
            if ($request['stoc_waon_class'] != '3') {
                $unchecked_stocktake_numbergoo = 0;
            } else {
                $unchecked_stocktake_numbergoo = $value['unchecked_stocktake_number'];
            }
            // 根据仓库id查询仓库类型：1固定仓2技师库3移动仓
            $ware_type = DB::table('warehouse')
                ->where('ware_id', $request['ware_id'])
                ->where('ware_shop_id', $user_info->adm_shop_id)
                ->value('ware_type');
            if ($ware_type == 1) {
                // 查询仓位商品库存数量
                $warehouse_goods = DB::table('warehouse_freight_goods')
                    ->where('wafg_wafr_id', $request['wafr_id'])
                    ->where('wafg_ware_id', $request['ware_id'])
                    ->where('wafg_class', $request['stoc_waon_class'])
                    ->where('wafg_goo_id', $value['goo_id'])
                    ->select('wafg_goo_id', 'wafg_stock_number as wago_freight_stock_number', 'wafg_lock_quantity as wago_freight_lock_quantity', 'wafg_priority_stock_number as wago_freight_priority_stock_number', 'wafg_priority_lock_quantity as wago_freight_priority_lock_quantity', 'wafg_unchecked_stock_number as wago_freight_unchecked_stock_number')
                    ->first();
            } elseif ($ware_type == 3) {
                // 查询仓库的仓位库存数量
                $warehouse_goods = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $request['ware_id'])
                    ->where('wago_goo_id', $value['goo_id'])
                    ->where('wago_class', $request['stoc_waon_class'])
                    ->select('wago_goo_id', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity', 'wago_freight_unchecked_stock_number', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                    ->first();
            }
            $warehouse_goods = json_decode(json_encode($warehouse_goods), true);
            if (!$warehouse_goods) {
                $wago_freight_stock_number = 0;
                $wago_freight_lock_quantity = 0;
                $wago_freight_priority_stock_number = 0;
                $wago_freight_priority_lock_quantity = 0;
                $wago_freight_unchecked_stock_number = 0;
            } else {
                if ($ware_type == 1) { //类型：固定仓
                    $wago_freight_stock_number = $warehouse_goods['wago_freight_stock_number'];
                    $wago_freight_lock_quantity = $warehouse_goods['wago_freight_lock_quantity'];
                    $wago_freight_priority_stock_number = $warehouse_goods['wago_freight_priority_stock_number'];
                    $wago_freight_priority_lock_quantity = $warehouse_goods['wago_freight_priority_lock_quantity'];
                    $wago_freight_unchecked_stock_number = $warehouse_goods['wago_freight_unchecked_stock_number'];
                } elseif ($ware_type == 3) { //类型：移动仓
                    $wago_freight_stock_number = $warehouse_goods['wago_stock_number'];
                    $wago_freight_lock_quantity = $warehouse_goods['wago_lock_quantity'];
                    $wago_freight_priority_stock_number = $warehouse_goods['wago_priority_stock_number'];
                    $wago_freight_priority_lock_quantity = $warehouse_goods['wago_priority_lock_quantity'];
                    $wago_freight_unchecked_stock_number = $warehouse_goods['wago_unchecked_stock_number'];
                }
            }
            if ($value['stocktake_number'] < '0') {
                $stocktake_numbers = abs($value['stocktake_number']);
                if ($stocktake_numbers > $wago_freight_stock_number) {
                    return ['code'=>400, 'msg'=>'error', 'data'=>'盘亏不能低于锁定数量', 'return_data'=>$goods_data];
                }
            }
            if ($value['priority_stocktake_number'] < '0') {
                $priority_stocktake_numbers = abs($value['priority_stocktake_number']);
                if ($priority_stocktake_numbers > $wago_freight_priority_stock_number) {
                    return ['code'=>400, 'msg'=>'error', 'data'=>'盘亏不能低于锁定数量', 'return_data'=>$goods_data];
                }
            }
            $stgo_data[$key]['stgo_goo_id'] = $value['goo_id']; //商品id
            $stgo_data[$key]['stgo_stock_number'] = $wago_freight_stock_number; //良品库存数量
            $stgo_data[$key]['stgo_priority_stock_number'] = $wago_freight_priority_stock_number; //优先库存数量
            $stgo_data[$key]['stgo_unchecked_stock_number'] = $wago_freight_unchecked_stock_number; //待检测数量
            $stgo_data[$key]['stgo_lock_number'] = $wago_freight_lock_quantity; //良品锁定数量
            $stgo_data[$key]['stgo_priority_lock_number'] = $wago_freight_priority_lock_quantity; //优先锁定数量
            $stgo_data[$key]['stgo_stocktake_number'] = $value['stocktake_number']; //良品盘点数量
            $stgo_data[$key]['stgo_priority_stocktake_number'] = $value['priority_stocktake_number']; //优先盘点数量
            $stgo_data[$key]['stgo_unchecked_stocktake_number'] = $unchecked_stocktake_numbergoo; //待检测盘点数量
            $stocktake_number += $value['stocktake_number']; //良品盘点数量
            $priority_stocktake_number += $value['priority_stocktake_number']; //优先盘点数量
            $unchecked_stocktake_number += $value['unchecked_stocktake_number']; //待检测盘点数量
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $stoc_differ_number = $stocktake_number + $priority_stocktake_number + $unchecked_stocktake_number; //损益数量
        if ($stoc_differ_number > 0) {
            // 类型：1盘盈2盘亏3盘平
            $stoc_type = 1;
        } elseif ($stoc_differ_number < 0) {
            $stoc_type = 2;
        } else {
            $stoc_type = 3;
        }

        // 1 新增一个盘库单数据
        $stoc_data['stoc_cid'] = $user_info->adm_cid;
        $stoc_data['stoc_shop_id'] = $user_info->adm_shop_id;
        $stoc_data['stoc_superior_shop_id'] = $shop_id;
        $stoc_data['stoc_adm_id'] = $user_info->adm_id;
        $stoc_data['stoc_storage_number'] = 'P' . truncateFill($user_info->adm_shop_id, 2) . date('mdHis') . truncateFill($user_info->adm_id, 2) . rand(10000, 99999);
        $stoc_data['stoc_type'] = $stoc_type;
        $stoc_data['stoc_differ_number'] = abs($stoc_differ_number);
        if ($type == 1) {
            $stoc_data['stoc_state'] = 1; //状态1保存/待提交2提交/待审核3通过4驳回
        } else {
            $stoc_data['stoc_state'] = 2; //状态1保存/待提交2提交/待审核3通过4驳回
        }
        $stoc_data['stoc_remark'] = $request['stoc_remark'] ? $request['stoc_remark'] : '';
        $stoc_data['stoc_ware_id'] = $request['ware_id'];
        $stoc_data['stoc_wafr_id'] = $request['wafr_id'] ? $request['wafr_id'] : 0;
        $stoc_data['stoc_make_time'] = $request['stoc_make_time'];
        $stoc_data['stoc_waon_class'] = $request['stoc_waon_class'];
        $stoc_data['stoc_manner'] = $request['stoc_manner'];

        // 新增盘库单
        $stoc_res =  DB::table('stocktake')->insertGetId($stoc_data);

        // 2. 新增盘点商品数据
        foreach ($stgo_data as $key => $value) {
            $stgo_data[$key]['stgo_stoc_id'] = $stoc_res;
            $stgo_res =  DB::table('stocktake_goods')->insert($stgo_data[$key]);
        }

        if ($stoc_res && $stgo_res) {
            $return_data['stoc_storage_number'] = $stoc_data['stoc_storage_number'];
            return ['code'=>200, 'msg'=>'success', 'data'=>'新增盘库单：成功', 'return_data'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'新增盘库单：失败'];
        }
    }

    // 编辑
    public static function editStocktake(
        $request,
        $find_stoc,
        $goods_data,
        $user_info
    ) {
        $stocktake_number = 0;  //良品盘点数量
        $priority_stocktake_number = 0;  //优先盘点数量
        $unchecked_stocktake_number = 0;  //待检测盘点数量
        foreach ($goods_data as $key => $value) {
            // 只有旧货仓用到待检测
            if ($request['stoc_waon_class'] != '3') {
                $unchecked_stocktake_numbergoo = 0;
            } else {
                $unchecked_stocktake_numbergoo = $value['unchecked_stocktake_number'];
            }
            // 根据仓库id查询仓库类型：1固定仓2技师库3移动仓
            $ware_type = DB::table('warehouse')
                ->where('ware_id', $request['ware_id'])
                ->where('ware_shop_id', $user_info->adm_shop_id)
                ->value('ware_type');
            if ($ware_type == 1) {
                // 查询仓位商品库存数量
                $warehouse_goods = DB::table('warehouse_freight_goods')
                    ->where('wafg_wafr_id', $request['wafr_id'])
                    ->where('wafg_ware_id', $request['ware_id'])
                    ->where('wafg_class', $request['stoc_waon_class'])
                    ->where('wafg_goo_id', $value['goo_id'])
                    ->select('wafg_goo_id', 'wafg_stock_number as wago_freight_stock_number', 'wafg_lock_quantity as wago_freight_lock_quantity', 'wafg_priority_stock_number as wago_freight_priority_stock_number', 'wafg_priority_lock_quantity as wago_freight_priority_lock_quantity', 'wafg_unchecked_stock_number as wago_freight_unchecked_stock_number')
                    ->first();
            } else {
                // 查询仓库的仓位库存数量
                $warehouse_goods = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $request['ware_id'])
                    ->where('wago_goo_id', $value['goo_id'])
                    ->where('wago_class', $request['stoc_waon_class'])
                    ->select('wago_goo_id', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity', 'wago_freight_unchecked_stock_number', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                    ->first();
            }
            $warehouse_goods = json_decode(json_encode($warehouse_goods), true);

            if (!$warehouse_goods) {
                $wago_freight_stock_number = 0;
                $wago_freight_lock_quantity = 0;
                $wago_freight_priority_stock_number = 0;
                $wago_freight_priority_lock_quantity = 0;
                $wago_freight_unchecked_stock_number = 0;
            } else {
                if ($ware_type == 1) { //类型：1固定仓
                    $wago_freight_stock_number = $warehouse_goods['wago_freight_stock_number'];
                    $wago_freight_lock_quantity = $warehouse_goods['wago_freight_lock_quantity'];
                    $wago_freight_priority_stock_number = $warehouse_goods['wago_freight_priority_stock_number'];
                    $wago_freight_priority_lock_quantity = $warehouse_goods['wago_freight_priority_lock_quantity'];
                    $wago_freight_unchecked_stock_number = $warehouse_goods['wago_freight_unchecked_stock_number'];
                } elseif ($ware_type == 3) { //类型：3移动仓
                    $wago_freight_stock_number = $warehouse_goods['wago_stock_number'];
                    $wago_freight_lock_quantity = $warehouse_goods['wago_lock_quantity'];
                    $wago_freight_priority_stock_number = $warehouse_goods['wago_priority_stock_number'];
                    $wago_freight_priority_lock_quantity = $warehouse_goods['wago_priority_lock_quantity'];
                    $wago_freight_unchecked_stock_number = $warehouse_goods['wago_unchecked_stock_number'];
                }
            }
            if ($value['stocktake_number'] < '0') {
                $stocktake_numbers = abs($value['stocktake_number']);
                if ($stocktake_numbers > $wago_freight_stock_number) {
                    return ['code'=>400, 'msg'=>'error', 'data'=>'盘亏不能低于锁定数量', 'return_data'=>$goods_data];
                }
            }
            if ($value['priority_stocktake_number'] < '0') {
                $priority_stocktake_numbers = abs($value['priority_stocktake_number']);
                if ($priority_stocktake_numbers > $wago_freight_priority_stock_number) {
                    return ['code'=>400, 'msg'=>'error', 'data'=>'盘亏不能低于锁定数量', 'return_data'=>$goods_data];
                }
            }
            $stgo_data[$key]['stgo_stoc_id'] = $request['stoc_id'];
            $stgo_data[$key]['stgo_goo_id'] = $value['goo_id']; //商品id
            $stgo_data[$key]['stgo_stock_number'] = $wago_freight_stock_number; //良品库存数量
            $stgo_data[$key]['stgo_priority_stock_number'] = $wago_freight_priority_stock_number; //优先库存数量
            $stgo_data[$key]['stgo_unchecked_stock_number'] = $wago_freight_unchecked_stock_number; //待检测数量
            $stgo_data[$key]['stgo_lock_number'] = $wago_freight_lock_quantity; //良品锁定数量
            $stgo_data[$key]['stgo_priority_lock_number'] = $wago_freight_priority_lock_quantity; //优先锁定数量
            $stgo_data[$key]['stgo_stocktake_number'] = $value['stocktake_number']; //良品盘点数量
            $stgo_data[$key]['stgo_priority_stocktake_number'] = $value['priority_stocktake_number']; //优先盘点数量
            $stgo_data[$key]['stgo_unchecked_stocktake_number'] = $unchecked_stocktake_numbergoo; //待检测盘点数量
            $stocktake_number += $value['stocktake_number']; //良品盘点数量
            $priority_stocktake_number += $value['priority_stocktake_number']; //优先盘点数量
            $unchecked_stocktake_number += $value['unchecked_stocktake_number']; //待检测盘点数量
        }

        // 1. 更改盘点表的数据
        $stoc_differ_number = $stocktake_number + $priority_stocktake_number + $unchecked_stocktake_number; //  损益数量
        if ($stoc_differ_number > 0) {
            // 类型：1盘盈2盘亏3盘平
            $stoc_type = 1;
        } elseif ($stoc_differ_number < 0) {
            $stoc_type = 2;
        } else {
            $stoc_type = 3;
        }

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        $stoc_data['stoc_cid'] = $user_info->adm_cid;
        $stoc_data['stoc_shop_id'] = $user_info->adm_shop_id;
        $stoc_data['stoc_superior_shop_id'] = $shop_id;
        $stoc_data['stoc_adm_id'] = $user_info->adm_id;
        $stoc_data['stoc_type'] = $stoc_type;
        $stoc_data['stoc_differ_number'] = abs($stoc_differ_number);
        $stoc_data['stoc_remark'] = $request['stoc_remark'] ? $request['stoc_remark'] : '';
        $stoc_data['stoc_ware_id'] = $request['ware_id'];
        $stoc_data['stoc_wafr_id'] = $request['wafr_id'] ? $request['wafr_id'] : 0;
        $stoc_data['stoc_make_time'] = $request['stoc_make_time'];
        $stoc_data['stoc_waon_class'] = $request['stoc_waon_class'];
        $stoc_data['stoc_manner'] = $request['stoc_manner'];
        $stoc_data['stoc_update_time'] = date('Y-m-d H:i:s');
        $stoc_res = DB::table('stocktake')
            ->where('stoc_id', $request['stoc_id'])
            ->update($stoc_data);

        // 2. 更改盘点商品表的数据
        // 2.1 删除原来盘点id对应的盘点商品数据
        $stgo_del_res = DB::table('stocktake_goods')
            ->where('stgo_stoc_id', $request['stoc_id'])
            ->delete();
        // 2.2 重新添加提交的盘点商品数据
        $stgo_res =  DB::table('stocktake_goods')->insert($stgo_data);

        if ($stoc_res && $stgo_del_res && $stgo_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'编辑盘库单：成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'编辑盘库单：失败'];
        }
    }

    // 通过
    public static function passStocktake(
        $user_info,
        $request,
        $find_stoc,
        $surplus
    ) {
        // 1. 将盘点单状态改为通过
        $update_data['stoc_state'] = 3; //状态1保存/待提交2提交/待审核3通过4驳回
        $update_data['stoc_update_time'] = date('Y-m-d H:i:s');
        $stoc_res = DB::table('stocktake')
            ->where('stoc_id', $request['stoc_id'])
            ->update($update_data);

        // 2. 查询要盘点的商品数量
        $stocktake_goods = DB::table('stocktake_goods')
            ->where('stgo_stoc_id', $find_stoc->stoc_id)
            ->select('stgo_id', 'stgo_goo_id', 'stgo_stock_number', 'stgo_stocktake_number', 'stgo_priority_stock_number', 'stgo_unchecked_stock_number', 'stgo_priority_stocktake_number', 'stgo_unchecked_stocktake_number')
            ->get()->toArray();
        $goods_id = array_column($stocktake_goods, 'stgo_goo_id'); //商品id
        // 3. 查询盘点仓库表的库存总数
        $find_waon_data = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $find_stoc->stoc_ware_id)
            ->where('waon_class', $find_stoc->stoc_waon_class)
            ->select('waon_id', 'waon_stock_fine_amount', 'waon_stock_priority_amount', 'waon_stock_unchecked_amount')
            ->first();
        
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 4. 盘库单商品盘点数量，与仓库商品数量比较
        $diff_ware_all_stock = 0; //良品库存盘点盈亏数量
        $diff_ware_priority_all_stock = 0; //优先库存盘点盈亏数量
        $diff_ware_unchecked_all_stock = 0; //待检测库存盘点盈亏数量
        $diff_ware_amount = 0; //仓库总的损益数量
        $goodsamout['stock_goodsuamout'] = 0; //良品盘盈总数
        $goodsamout['stock_goodsdamout'] = 0; //良品盘亏总数
        $goodsamout['priority_goodsuamout'] = 0; //优先盘盈总数
        $goodsamout['priority_goodsdamout'] = 0; //优先盘亏总数
        $goodsamout['unchecked_goodsuamout'] = 0; //待检测盘盈总数
        $goodsamout['unchecked_goodsdamout'] = 0; //待检测盘亏总数
        foreach ($stocktake_goods as $key => $value) {
            $goo_id[] = $value->stgo_goo_id; //盘点商品id
            // 商品良品盘点数量
            $diff_stock_number = $value->stgo_stocktake_number;
            $goo_stock_number[$value->stgo_goo_id] = $diff_stock_number;
            $goo_freight_stock_number[$value->stgo_goo_id] = $diff_stock_number;
            $diff_ware_all_stock += $diff_stock_number;
            $diff_ware_amount += $diff_stock_number;
            // 商品流水
            if ($value->stgo_stocktake_number > 0) {
                $goodsout['stock_stgo_id'][] = $value->stgo_id; //主键id
                $goodsout['stock_goodsuid'][] = $value->stgo_goo_id; //良品盘盈id
                $goodsout['stock_goodsunum'][] = $diff_stock_number; //良品盘盈数量
                $goodsout['stock_goodsuinv'][] = 1; //良品盘盈
                $goodsamout['stock_goodsuamout'] += $diff_stock_number;
            } elseif ($value->stgo_stocktake_number < 0) {
                $goodsout['stock_stgo_id'][] = $value->stgo_id; //主键id
                $goodsout['stock_goodsdid'][] = $value->stgo_goo_id; //良品盘亏id
                $goodsout['stock_goodsdnum'][] = abs($diff_stock_number); //良品盘亏数量
                $goodsout['stock_goodsdinv'][] = 1; //良品盘亏
                $goodsamout['stock_goodsdamout'] += abs($diff_stock_number);
            }
            // 商品优先盘点数量
            $diff_priority_number = $value->stgo_priority_stocktake_number;
            $goo_priority_number[$value->stgo_goo_id] = $diff_priority_number;
            $goo_freight_priority_number[$value->stgo_goo_id] = $diff_priority_number;
            $diff_ware_priority_all_stock += $diff_priority_number;
            $diff_ware_amount += $diff_priority_number;
            // 商品流水
            if ($value->stgo_priority_stocktake_number > 0) {
                $goodsout['priority_stgo_id'][] = $value->stgo_id; //主键id
                $goodsout['priority_goodsuid'][] = $value->stgo_goo_id; //优先盘盈id
                $goodsout['priority_goodsunum'][] = $diff_priority_number; //优先盘盈数量
                $goodsout['priority_goodsuinv'][] = 2; //优先盘盈
                $goodsamout['priority_goodsuamout'] += $diff_priority_number;
            } elseif ($value->stgo_priority_stocktake_number < 0) {
                $goodsout['priority_stgo_id'][] = $value->stgo_id; //主键id
                $goodsout['priority_goodsdid'][] = $value->stgo_goo_id; //优先盘亏id
                $goodsout['priority_goodsdnum'][] = abs($diff_priority_number); //优先盘亏数量
                $goodsout['priority_goodsdinv'][] = 2; //优先盘亏
                $goodsamout['priority_goodsdamout'] += abs($diff_priority_number);
            }
            // 商品待检测盘点数量
            $diff_unchecked_number = $value->stgo_unchecked_stocktake_number;
            $goo_unchecked_number[$value->stgo_goo_id] = $diff_unchecked_number;
            $goo_freight_unchecked_number[$value->stgo_goo_id] = $diff_unchecked_number;
            $diff_ware_unchecked_all_stock += $diff_unchecked_number;
            $diff_ware_amount += $diff_unchecked_number;
            // 商品流水
            if ($value->stgo_unchecked_stocktake_number > 0) {
                $goodsout['unchecked_stgo_id'][] = $value->stgo_id; //主键id
                $goodsout['unchecked_goodsuid'][] = $value->stgo_goo_id; //待检测盘盈id
                $goodsout['unchecked_goodsunum'][] = $diff_unchecked_number; //待检测盘盈数量
                $goodsout['unchecked_goodsuinv'][] = 3; //待检测盘盈
                $goodsamout['unchecked_goodsuamout'] += $diff_unchecked_number;
            } elseif ($value->stgo_unchecked_stocktake_number < 0) {
                $goodsout['unchecked_stgo_id'][] = $value->stgo_id; //主键id
                $goodsout['unchecked_goodsdid'][] = $value->stgo_goo_id; //待检测盘亏id
                $goodsout['unchecked_goodsdnum'][] = abs($diff_unchecked_number); //待检测盘亏数量
                $goodsout['unchecked_goodsdinv'][] = 3; //待检测盘亏
                $goodsamout['unchecked_goodsdamout'] += abs($diff_unchecked_number);
            }
        }
        foreach ($goodsamout as $k => $v) {
            if ($v > 0) {
                if ($k == 'stock_goodsuamout') { //良品盘盈
                    $outware = 0;
                    $inware = $find_stoc->stoc_ware_id;
                    $outtype = 3;
                    $intype = 2;
                    $surplus->ware_all_stock = $surplus->ware_all_stock + $v;
                    $stgo_idarr = $goodsout['stock_stgo_id']; //数组，主键id
                    $goo_idarr = $goodsout['stock_goodsuid']; //数组，商品id
                    $goo_number = $goodsout['stock_goodsunum']; //数组，商品数量
                    $inventory = $goodsout['stock_goodsuinv']; //数组，出库类型1良品2优先3待检测
                } elseif ($k == 'priority_goodsuamout') { //优先盘盈
                    $outware = 0;
                    $inware = $find_stoc->stoc_ware_id;
                    $outtype = 3;
                    $intype = 2;
                    $surplus->ware_priority_all_stock = $surplus->ware_priority_all_stock + $v;
                    $stgo_idarr = $goodsout['priority_stgo_id']; //数组，主键id
                    $goo_idarr = $goodsout['priority_goodsuid']; //数组，商品id
                    $goo_number = $goodsout['priority_goodsunum']; //数组，商品数量
                    $inventory = $goodsout['priority_goodsuinv']; //数组，出库类型1良品2优先3待检测
                } elseif ($k == 'unchecked_goodsuamout') { //待检测盘盈
                    $outware = 0;
                    $inware = $find_stoc->stoc_ware_id;
                    $outtype = 3;
                    $intype = 2;
                    $surplus->ware_unchecked_all_stock = $surplus->ware_unchecked_all_stock + $v;
                    $stgo_idarr = $goodsout['unchecked_stgo_id']; //数组，主键id
                    $goo_idarr = $goodsout['unchecked_goodsuid']; //数组，商品id
                    $goo_number = $goodsout['unchecked_goodsunum']; //数组，商品数量
                    $inventory = $goodsout['unchecked_goodsuinv']; //数组，出库类型1良品2优先3待检测
                } elseif ($k == 'stock_goodsdamout') { //良品盘亏
                    $inware = 0;
                    $outware = $find_stoc->stoc_ware_id;
                    $outtype = 2;
                    $intype = 1;
                    $surplus->ware_all_stock = $surplus->ware_all_stock - $v;
                    $stgo_idarr = $goodsout['stock_stgo_id']; //数组，主键id
                    $goo_idarr = $goodsout['stock_goodsdid']; //数组，商品id
                    $goo_number = $goodsout['stock_goodsdnum']; //数组，商品数量
                    $inventory = $goodsout['stock_goodsdinv']; //数组，出库类型1良品2优先3待检测
                } elseif ($k == 'priority_goodsdamout') { //优先盘亏
                    $inware = 0;
                    $outware = $find_stoc->stoc_ware_id;
                    $outtype = 2;
                    $intype = 1;
                    $surplus->ware_priority_all_stock = $surplus->ware_priority_all_stock - $v;
                    $stgo_idarr = $goodsout['priority_stgo_id']; //数组，主键id
                    $goo_idarr = $goodsout['priority_goodsdid']; //数组，商品id
                    $goo_number = $goodsout['priority_goodsdnum']; //数组，商品数量
                    $inventory = $goodsout['priority_goodsdinv']; //数组，出库类型1良品2优先3待检测
                } elseif ($k == 'unchecked_goodsdamout') { //待检测盘亏
                    $inware = 0;
                    $outware = $find_stoc->stoc_ware_id;
                    $outtype = 2;
                    $intype = 1;
                    $surplus->ware_unchecked_all_stock = $surplus->ware_unchecked_all_stock - $v;
                    $stgo_idarr = $goodsout['unchecked_stgo_id']; //数组，主键id
                    $goo_idarr = $goodsout['unchecked_goodsdid']; //数组，商品id
                    $goo_number = $goodsout['unchecked_goodsdnum']; //数组，商品数量
                    $inventory = $goodsout['unchecked_goodsdinv']; //数组，出库类型1良品2优先3待检测
                }
                // 3.生成出出库记录
                $oure_data = OutinRecord::addition(
                    $user_info, //用户信息
                    $find_stoc->stoc_id, //原始单的关联id
                    $find_stoc->stoc_storage_number, //原始单的关联单号
                    8, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后8盘库单
                    5, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单5盘库单
                    0, //选择的客户id,会员id/单位id
                    $find_stoc->stoc_storage_number, //原始单号
                    $inware, //入库仓库id
                    $outware, //出库仓库id
                    $v, //出库的商品总量
                    15, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单15盘库单
                    $outtype, //操作类型：1锁定库存2出库3入库4调货5发货
                    $surplus->ware_all_stock, //良品总库存
                    $surplus->ware_lock_quantity, //良品锁定数量
                    $surplus->ware_priority_all_stock, //优先总库存
                    $surplus->ware_priority_lock_quantity, //优先锁定数量
                    $surplus->ware_unchecked_all_stock, //待检测总库存
                    $intype, //出入库类型：1出库，2入库
                    $find_stoc->stoc_waon_class, //[仓库类别]
                    $goo_idarr, //数组，商品id
                    $goo_number, //数组，商品数量
                    $inventory //数组，出库类型1良品2优先3待检测
                );
                if ($surplus->ware_type == 1) { //固定仓
                    // 仓位商品出入库
                    $stgo_retruns = Stocktake::addition(
                        $user_info,
                        $find_stoc->stoc_ware_id,
                        $find_stoc->stoc_waon_class,
                        $find_stoc->stoc_wafr_id,
                        7,
                        $find_stoc->stoc_id, //原始单的关联id
                        $find_stoc->stoc_storage_number, //原始单的关联单号
                        $stgo_idarr,
                        $goo_idarr,
                        $intype,
                        $goo_number,
                        $inventory //数组，出库类型1良品2优先3待检测
                    );
                }
            }
        }
        $cost_price = 0;
        foreach ($stocktake_goods as $key => $value) {
            // 获取当前月份的成本价
            $find_ense_data = DB::table('enters_sells_saves')
                ->where('ense_goo_id', $value->stgo_goo_id)
                ->where('ense_goo_warehouse', $find_stoc->stoc_ware_id)
                ->where('ense_goo_waretype', $find_stoc->stoc_waon_class)
                ->where('ense_order_number', $find_stoc->stoc_storage_number)
                ->orderBy('ense_id', 'desc')
                ->select('ense_new_price', 'ense_out_in', 'ense_in_num', 'ense_out_num')
                ->first();
            if ($find_ense_data) {
                if ($find_ense_data->ense_new_price) {
                    $find_ense_new_price = sprintf('%.2f', $find_ense_data->ense_new_price);
                } else {
                    $find_ense_new_price = 0;
                }
                if ($find_ense_data->ense_out_in == 1) { //出库
                    $cost_price += $find_ense_new_price * $find_ense_data->ense_out_num * (-1);
                } elseif ($find_ense_data->ense_out_in == 2) { //入库
                    $cost_price += $find_ense_new_price * $find_ense_data->ense_in_num;
                }
            } else {
                $cost_price = 0;
            }
        }
        // 查询仓库类型：1固定仓2技师库3移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_cid', $user_info->adm_cid)
            ->where('ware_shop_id', $user_info->adm_shop_id)
            ->where('ware_id', $find_stoc->stoc_ware_id)
            ->value('ware_type');
        if ($ware_type == 1) { //固定仓
            // 更改仓库商品的仓位数量
            $stgo_retrun = Stocktake::stocktakeWarehouseAddition(
                $find_stoc->stoc_ware_id,
                $find_stoc->stoc_waon_class,
                $goo_id,
                $goo_stock_number,
                $goo_priority_number,
                $goo_unchecked_number
            );
            if ($stgo_retrun['code'] == 500) {
                return $stgo_retrun;
            }
            // 更改仓位数量
            $stgo_freight_retrun = Stocktake::stocktakeWarehouseFreight(
                $find_stoc->stoc_ware_id,
                $find_stoc->stoc_waon_class,
                $goo_id,
                $goo_freight_stock_number,
                $goo_freight_priority_number,
                $goo_freight_unchecked_number,
                $find_stoc->stoc_wafr_id //仓位id
            );
            if ($stgo_freight_retrun['code'] == 500) {
                return $stgo_freight_retrun;
            }
        } elseif ($ware_type == 3) { //移动仓
            // 4.2 查询商品库存数量
            $warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $find_stoc->stoc_ware_id)
                ->where('wago_class', $find_stoc->stoc_waon_class)
                ->whereIn('wago_goo_id', $goo_id)
                ->select('wago_id', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_unchecked_stock_number', 'wago_stock_amount', 'wago_priority_stock_amount', 'wago_unchecked_stock_amount')
                ->get()->toArray();
            $warehouse_goods = json_decode(json_encode($warehouse_goods), true);
            // 4.3 处理要盘点的商品库存数量
            if (empty($warehouse_goods)) {
                $ware_edit_res = true;
            } else {
                // 4.4 仓库商品表中已存在的商品，更改库存数量，整理更改SQL语句
                $sql = 'UPDATE `faster_warehouse_goods` SET ';
                $stock_number_sql = ''; //良品库存数量（仓库+仓位）
                $priority_stock_number_sql = ''; //优先库存数量（仓库+仓位）
                $unchecked_stock_number_sql = ''; //待检测数量（仓库+仓位）
                $update_time_sql = '';
                $ids = '';

                foreach ($warehouse_goods as $key => $value) {
                    // 要更改的商品库存数量
                    $stock_number = $value['wago_stock_number'] + $goo_stock_number[$value['wago_goo_id']];
                    $priority_stock_number = $value['wago_priority_stock_number'] + $goo_priority_number[$value['wago_goo_id']];
                    $unchecked_stock_number = $value['wago_unchecked_stock_number'] + $goo_unchecked_number[$value['wago_goo_id']];

                    if ($stock_number < 0) {
                        $stock_number = 0;
                    }
                    if ($priority_stock_number < 0) {
                        $priority_stock_number = 0;
                    }
                    if ($unchecked_stock_number < 0) {
                        $unchecked_stock_number = 0;
                    }
                    // 更改良品库存数量（仓库+仓位）
                    $stock_number_sql = $stock_number_sql . ' WHEN ' . $value['wago_id'] . ' THEN ' . $stock_number;
                    // 更改优先库存数量（仓库+仓位）
                    $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $value['wago_id'] . ' THEN ' . $priority_stock_number;
                    // 更改待检测数量（仓库+仓位）
                    $unchecked_stock_number_sql = $unchecked_stock_number_sql . ' WHEN ' . $value['wago_id'] . ' THEN ' . $unchecked_stock_number;

                    // 更改时间
                    $update_time_sql = $update_time_sql . ' WHEN ' . $value['wago_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    $ids = $ids . $value['wago_id'] . ',';
                    // 删除已更改的商品数据
                    unset($goo_stock_number[$value['wago_goo_id']]);
                }
                $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_number_sql . ' END,';
                $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $priority_stock_number_sql . ' END,';
                $sql = $sql . ' `wago_unchecked_stock_number`=  CASE `wago_id` ' . $unchecked_stock_number_sql . ' END,';
                $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $update_time_sql . ' END';
                $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
                $ware_edit_res = DB::update($sql);
            }

            if (empty($goo_stock_number)) {
                $ware_add_res = true;
            } else {
                // 4.5 仓库商品表中没有的商品，新增仓库商品
                foreach ($goo_stock_number as $key => $value) {
                    $find_goods_encode = DB::table('goods')
                        ->where('goo_id', $key)
                        ->where('goo_state', 1)
                        ->where('goo_delete', 1)
                        ->value('goo_goods_encode');
                    return ['code'=>500, 'msg'=>'error', 'data'=>'检索编码：（' . $find_goods_encode . '）不在我的仓库--库存列表，只能进行采购或调拨！！！'];
                }
            }
        }

        // 仓库类别表总库存数量加上 差值数量
        $warehouse_onhand_sql = 'UPDATE `faster_warehouse_onhand` SET  `waon_all_amount`= `waon_all_amount`+' . $diff_ware_amount . ', `waon_stock_fine_amount`= `waon_stock_fine_amount`+' . $diff_ware_all_stock . ' , `waon_stock_priority_amount`= `waon_stock_priority_amount` + ' . $diff_ware_priority_all_stock . ', `waon_stock_unchecked_amount`= `waon_stock_unchecked_amount` + ' . $diff_ware_unchecked_all_stock . ', `waon_update_time`= "' . date('Y-m-d H:i:s') . '"  WHERE  `waon_id` = ' . $find_waon_data->waon_id;
        $waon_res = DB::update($warehouse_onhand_sql);

        // 库存锁定-出入库记录
        $oslr_res = self::publicOutin(
            $user_info,
            $request
        );
        if (!$oslr_res) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'通过失败'];
        }

        if ($stoc_res && $waon_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'通过成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'通过失败'];
        }
    }

    // 凭证和库存锁定-出入库记录的公共代码
    public static function publicOutin(
        $user_info,
        $request
    ) {
        // 查询信息
        $find_stoc = DB::table('stocktake')
            ->where('stoc_id', $request['stoc_id'])
            ->select('stoc_id', 'stoc_storage_number', 'stoc_state', 'stoc_ware_id', 'stoc_waon_class', 'stoc_type', 'stoc_adm_id', 'stoc_create_time', 'stoc_differ_number')
            ->first();
        // 2. 查询要盘点的商品数量
        $stocktake_goods = DB::table('stocktake_goods')
            ->where('stgo_stoc_id', $find_stoc->stoc_id)
            ->select('stgo_goo_id', 'stgo_stock_number', 'stgo_stocktake_number', 'stgo_priority_stock_number', 'stgo_unchecked_stock_number', 'stgo_priority_stocktake_number', 'stgo_unchecked_stocktake_number')
            ->get();
        // 3. 查询盘点仓库表的库存总数
        $find_waon_data = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $find_stoc->stoc_ware_id)
            ->where('waon_class', $find_stoc->stoc_waon_class)
            ->select('waon_id', 'waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount', 'waon_stock_unchecked_amount')
            ->first();
        
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 4. 盘库单商品盘点数量，与仓库商品数量比较
        $diff_ware_all_stock = 0; //良品库存盘点盈亏数量
        $diff_ware_priority_all_stock = 0; //优先库存盘点盈亏数量
        $diff_ware_unchecked_all_stock = 0; //待检测库存盘点盈亏数量
        foreach ($stocktake_goods as $key => $value) {
            // 商品良品盘点数量
            $diff_ware_all_stock += $value->stgo_stocktake_number;
            // 商品优先盘点数量
            $diff_ware_priority_all_stock += $value->stgo_priority_stocktake_number;
            // 商品待检测盘点数量
            $diff_ware_unchecked_all_stock += $value->stgo_unchecked_stocktake_number;
        }
        
        $cost_price = 0;
        $osld_out_key = 0;
        foreach ($stocktake_goods as $key => $value) {
            // 获取当前月份的成本价
            $find_ense_data = DB::table('enters_sells_saves')
                ->where('ense_goo_id', $value->stgo_goo_id)
                ->where('ense_goo_warehouse', $find_stoc->stoc_ware_id)
                ->where('ense_goo_waretype', $find_stoc->stoc_waon_class)
                ->where('ense_order_number', $find_stoc->stoc_storage_number)
                ->orderBy('ense_id', 'desc')
                ->select('ense_new_price', 'ense_out_in', 'ense_in_num', 'ense_out_num')
                ->first();
            if ($find_ense_data) {
                if ($find_ense_data->ense_new_price) {
                    $find_ense_new_price = sprintf('%.2f', $find_ense_data->ense_new_price);
                } else {
                    $find_ense_new_price = 0;
                }
                if ($find_ense_data->ense_out_in == 1) { //出库
                    $cost_price += $find_ense_new_price * $find_ense_data->ense_out_num * (-1);
                } elseif ($find_ense_data->ense_out_in == 2) { //入库
                    $cost_price += $find_ense_new_price * $find_ense_data->ense_in_num;
                }
            } else {
                $cost_price = 0;
            }
            // 库存锁定-出入库记录表
            $osld_goo_data[$osld_out_key]['goo_waon_class'] = $find_stoc->stoc_waon_class; //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
            $osld_goo_data[$osld_out_key]['goo_id'] = $value->stgo_goo_id; //商品id
            $osld_goo_data[$osld_out_key]['goo_number'] = $value->stgo_stocktake_number; //商品数量
            $osld_goo_data[$osld_out_key]['goo_out_in_type'] = 2; //出入库类型：1出库2入库3锁定4取消锁定
            $osld_goo_data[$osld_out_key]['goo_inventory'] = 1; //类型1良品2优先3待检测
            // 查询仓库商品库存数量
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $find_stoc->stoc_ware_id)
                ->where('wago_class', $find_stoc->stoc_waon_class)
                ->where('wago_goo_id', $value->stgo_goo_id)
                ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                ->first();
            if ($value->stgo_stocktake_number >= 0) { //良品盘盈
                $osld_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number - $value->stgo_stocktake_number; //旧的商品良品库存数量
                $osld_goo_data[$osld_out_key]['old_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //旧的商品良品库存锁定数量
                $osld_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number - $value->stgo_priority_stocktake_number; //旧的商品优先库存数量
                $osld_goo_data[$osld_out_key]['old_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //旧的商品优先库存锁定数量
                $osld_goo_data[$osld_out_key]['old_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //旧的商品待检测库存数量
                $osld_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                $osld_goo_data[$osld_out_key]['new_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //新的商品良品库存锁定数量
                $osld_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
                $osld_goo_data[$osld_out_key]['new_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //新的商品优先库存锁定数量
                $osld_goo_data[$osld_out_key]['new_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //新的商品待检测库存数量
            } elseif ($value->stgo_stocktake_number < 0) { //良品盘亏
                $osld_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number + $value->stgo_stocktake_number; //旧的商品良品库存数量
                $osld_goo_data[$osld_out_key]['old_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //旧的商品良品库存锁定数量
                $osld_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number + $value->stgo_priority_stocktake_number; //旧的商品优先库存数量
                $osld_goo_data[$osld_out_key]['old_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //旧的商品优先库存锁定数量
                $osld_goo_data[$osld_out_key]['old_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //旧的商品待检测库存数量
                $osld_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                $osld_goo_data[$osld_out_key]['new_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //新的商品良品库存锁定数量
                $osld_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
                $osld_goo_data[$osld_out_key]['new_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //新的商品优先库存锁定数量
                $osld_goo_data[$osld_out_key]['new_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //新的商品待检测库存数量
            }
            if ($value->stgo_priority_stocktake_number >= 0) { //优先盘盈
                $osld_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number - $value->stgo_stocktake_number; //旧的商品良品库存数量
                $osld_goo_data[$osld_out_key]['old_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //旧的商品良品库存锁定数量
                $osld_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number - $value->stgo_priority_stocktake_number; //旧的商品优先库存数量
                $osld_goo_data[$osld_out_key]['old_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //旧的商品优先库存锁定数量
                $osld_goo_data[$osld_out_key]['old_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //旧的商品待检测库存数量
                $osld_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                $osld_goo_data[$osld_out_key]['new_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //新的商品良品库存锁定数量
                $osld_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
                $osld_goo_data[$osld_out_key]['new_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //新的商品优先库存锁定数量
                $osld_goo_data[$osld_out_key]['new_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //新的商品待检测库存数量
            } elseif ($value->stgo_priority_stocktake_number < 0) { //优先盘亏
                $osld_goo_data[$osld_out_key]['old_stock_number'] = $find_wago_data->wago_stock_number + $value->stgo_stocktake_number; //旧的商品良品库存数量
                $osld_goo_data[$osld_out_key]['old_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //旧的商品良品库存锁定数量
                $osld_goo_data[$osld_out_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number + $value->stgo_priority_stocktake_number; //旧的商品优先库存数量
                $osld_goo_data[$osld_out_key]['old_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //旧的商品优先库存锁定数量
                $osld_goo_data[$osld_out_key]['old_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //旧的商品待检测库存数量
                $osld_goo_data[$osld_out_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                $osld_goo_data[$osld_out_key]['new_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //新的商品良品库存锁定数量
                $osld_goo_data[$osld_out_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
                $osld_goo_data[$osld_out_key]['new_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //新的商品优先库存锁定数量
                $osld_goo_data[$osld_out_key]['new_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //新的商品待检测库存数量
            }
            $osld_goo_data[$osld_out_key]['osld_update_time'] = date('Y-m-d H:i:s'); //更新时间
            $osld_goo_data[$osld_out_key] = (object)$osld_goo_data[$osld_out_key];
            $osld_out_key++;
        }
        // 库存锁定-出入库记录
        $oslr_res = OutinStockLock::addition(
            $user_info, //用户信息
            $find_stoc->stoc_id, //原始单的关联id
            $find_stoc->stoc_storage_number, //原始单的关联单号
            8, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
            0, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
            0, //选择的客户id,会员id/单位id
            $find_stoc->stoc_storage_number, //原始单号
            $find_stoc->stoc_ware_id, //出库/入库的仓库id
            $find_stoc->stoc_differ_number, //出库/入库总数量
            15, //类型：1锁定库存2取消锁定3调拨单4旧货回收单5退换回收单6订单出库7部分入库8部分出库9发货单10移动仓出库11换货出库12换货入库13退货入库14退货出库15盘库单
            $find_waon_data->waon_stock_fine_amount, //良品总库存
            $find_waon_data->waon_lock_fine_amount, //良品锁定数量
            $find_waon_data->waon_stock_priority_amount, //优先总库存
            $find_waon_data->waon_lock_priority_amount, //优先锁定数量
            $find_waon_data->waon_stock_unchecked_amount, //待检测总库存
            2, //出入库类型：1出库，2入库
            $osld_goo_data
        );
        unset($osld_goo_data);
        if (!$oslr_res) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'仓库商品不存在，通过失败'];
        }

        // 凭证单据报表
        // 判断凭证单据是否存在
        $vore_id = DB::table('voucher_receipts')
            ->where('vore_cid', $user_info->adm_cid)
            ->where('vore_shop_id', $user_info->adm_shop_id)
            ->where('vore_ord_id', $request['stoc_id'])
            ->where('vore_ord_number', $find_stoc->stoc_storage_number)
            ->where('vore_order_type', 6)
            ->where('vore_state', 1)
            ->select('vore_id', 'vore_wor_id', 'vore_wor_number')
            ->first();
        if ($find_stoc->stoc_waon_class != 4) {
            if ($cost_price != 0) {
                $vore_data['vore_cid'] = $user_info->adm_cid; //公司id
                $vore_data['vore_superior_shop_id'] = $shop_id; //总店id
                $vore_data['vore_shop_id'] = $user_info->adm_shop_id; //门店id
                $vore_data['vore_create_id'] = $user_info->adm_id; //创建人
                $vore_data['vore_order_type'] = 6; //单号类型1.订单2.工单3.采购单4.销售单5.采购退货单6.盘库单
                $vore_data['vore_wor_id'] = ''; //工单id
                $vore_data['vore_wor_number'] = ''; //工单单号
                $vore_data['vore_ord_id'] = $find_stoc->stoc_id; //订单id
                $vore_data['vore_ord_number'] = $find_stoc->stoc_storage_number; //订单单号
                $vore_data['vore_plus_minus'] = 1; //金额正负1正值2负值
                $vore_data['vore_actual_price'] = abs($cost_price); //结算金额
                $vore_data['vore_collection_price'] = 0; //代收金额
                $vore_data['vore_recycle_price'] = 0; //回收金额
                $vore_data['vore_early_costing'] = 0; //成本
                $vore_data['vore_type'] = ''; //单位类型1会员零售2客户单位3速电派单
                $vore_data['vore_client_id'] = ''; //客户单位/客户id
                $vore_data['vore_channel_unit'] = '';
                $vore_data['vore_create_time'] = $find_stoc->stoc_create_time;
                $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
            }

            if ($cost_price > 0) { //金额盘盈
                $volo_data[0]['volo_shop_id'] = $user_info->adm_shop_id;
                $volo_data[0]['volo_vore_id'] = $vore_id;
                $volo_data[0]['volo_type'] = 1; //类型1借方2贷方
                $volo_data[0]['volo_borrow_subject'] = '140501'; //借方科目
                $volo_data[0]['volo_borrow_subject_name'] = '库存商品'; //借方科目名称
                $volo_data[0]['volo_borrow_price'] = abs($cost_price); //借方金额
                $volo_data[0]['volo_loan_subject'] = '190101'; //贷方科目
                $volo_data[0]['volo_loan_subject_name'] = '待处理财产损溢'; //贷方科目名称
                $volo_data[0]['volo_loan_price'] = abs($cost_price); //贷方金额
                $volo_data[0]['volo_update_time'] = $find_stoc->stoc_create_time; //更新时间
                $volo_id = DB::table('voucher_loan')->insert($volo_data);
            } elseif ($cost_price < 0) { // 金额盘亏
                $volo_data[0]['volo_shop_id'] = $user_info->adm_shop_id;
                $volo_data[0]['volo_vore_id'] = $vore_id;
                $volo_data[0]['volo_type'] = 1; //类型1借方2贷方
                $volo_data[0]['volo_borrow_subject'] = '190101'; //借方科目
                $volo_data[0]['volo_borrow_subject_name'] = '待处理财产损溢'; //借方科目名称
                $volo_data[0]['volo_borrow_price'] = abs($cost_price); //借方金额
                $volo_data[0]['volo_loan_subject'] = '140501'; //贷方科目
                $volo_data[0]['volo_loan_subject_name'] = '库存商品'; //贷方科目名称
                $volo_data[0]['volo_loan_price'] = abs($cost_price); //贷方金额
                $volo_data[0]['volo_update_time'] = $find_stoc->stoc_create_time; //更新时间
                $volo_id = DB::table('voucher_loan')->insert($volo_data);
            }
        } else {
            $vore_id = true;
            $volo_id = true;
        }
        if ($vore_id && $volo_id) {
            // 获取当前操作账号信息
            return ['code'=>200, 'msg'=>'success', 'data'=>'通过成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'通过失败'];
        }
    }
}
