<?php
namespace App\Http\Models\Services\WarehouseManage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\OutinRecord;
use App\Http\Models\Services\WarehouseManage\OutinStockLock;
use App\Http\Models\Api\WarehouseManage\Stocktake;

class JunkRecycling extends Model
{
    /**
     * junkRecycle 旧货回收
     *
     * @param [type] $user_info     用户信息
     * @param [type] $request       提交的数据
     * @param [type] $find_junk     旧货回收数据
     * @param [type] $ware_type     类型：1固定仓2技师库3移动仓
     * @return void
     */
    public static function junkRecycle(
        $user_info,
        $request,
        $find_junk,
        $ware_type
    ) {
        $goods_number_sum = 0; //实际回收商品总数量
        $all_price = 0;
        $wor_goo = [];
        $ord_goo = [];
        $new_wor_goo_id = [];
        $num = 0;
        // 2. 回收单商品表
        $request['goo_data'] = json_decode($request['goo_data'], true);
        foreach ($request['goo_data'] as $key => $value) {
            if (!is_numeric($value['goo_id']) || $value['goo_id'] <= 0 || !is_numeric($value['goo_ampere_hour']) || $value['goo_ampere_hour'] < 0  || !is_numeric($value['goo_recycle_amount']) || $value['goo_recycle_amount'] <= 0 || !is_numeric($value['goo_wafr_id']) || $value['goo_wafr_id'] < 0) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'参数类型错误']);
            }
            // 根据商品id查询商品名称
            $find_goods_data = DB::table('goods')
                ->where('goo_id', $value['goo_id'])
                ->select('goo_name', 'goo_class')
                ->first();
            if ($find_goods_data->goo_class == 1) { //类型：1自营商品2系统商品
                // 查询商品附属表
                $goaf_another_name = DB::table('goods_affiliate')
                    ->where('goaf_goo_id', $value['goo_id'])
                    ->where('goaf_shop_id', $user_info->adm_shop_id)
                    ->value('goaf_another_name');
                if (!empty($goaf_another_name)) {
                    $find_goods_data->goo_name = $goaf_another_name;
                }
            } else {
                // 查询系统商品属性表
                $gosa_another_name = DB::table('goods_system_affiliate')
                    ->where('gosa_goo_id', $value)
                    ->where('gosa_shop_id', $user_info->adm_shop_id)
                    ->value('gosa_another_name');
                if (!empty($gosa_another_name)) {
                    $find_goods_data->goo_name = $gosa_another_name;
                }
            }

            //  jur_source = 2 订单回收 ord_wor_state！=5有工单
            if ($request['jur_source'] == 2 && $request['ord_wor_state'] != 5) {
                // 判断是移动端添加 还是 pc端添加 1.移动端 2.pc
                if ($request['jur_is_mobile'] == 1) {
                    // 工单商品表新增回收的商品
                    if (in_array($value['goo_id'], $new_wor_goo_id)) {
                        $old_num = array_search($value['goo_id'], $new_wor_goo_id); //已有商品 数组的key
                        $wor_goo[$old_num]['wogo_goo_amount'] += $value['goo_recycle_amount']; //可派单商品数量，商品数量
                        $wor_goo[$old_num]['wogo_recycle_quantity'] += $value['goo_recycle_amount']; //回收数量
                        $wor_goo[$old_num]['wogo_actual_recycle_number'] += $value['goo_recycle_amount']; //实际回收数量
                        $jugo_data[$old_num]['jugo_recycle_number'] += $value['goo_recycle_amount'];

                        $ord_goo[$old_num]['orgo_recycle_quantity'] += $value['goo_recycle_amount']; //商品回收数量
                        $ord_goo[$old_num]['orgo_goo_quantity'] += $value['goo_recycle_amount']; //商品回收数量

                        $ord_wafr_data[$old_num][] = $value['goo_wafr_id']; //仓位id
                    } else {
                        $wor_goo[$num]['wogo_wor_id'] = $request['wor_id']; //工单id
                        $wor_goo[$num]['wogo_ware_id'] = $request['jur_ware_id']; //仓库id
                        // $wor_goo[$num]['wogo_wafr_id'] = $value['goo_wafr_id']; //仓位id
                        $wor_goo[$num]['wogo_waon_class'] = $request['jur_waon_class']; //仓库类别
                        $wor_goo[$num]['wogo_goo_id'] = $value['goo_id']; //商品id
                        $wor_goo[$num]['wogo_is_recycle'] = 1; //1.回收2.不回收
                        $wor_goo[$num]['wogo_goo_name'] = $find_goods_data->goo_name; //商品名称
                        $wor_goo[$num]['wogo_goo_goods_encode'] = isset($value['goo_goods_encode']) ? $value['goo_goods_encode'] : ''; //商品编号
                        $wor_goo[$num]['wogo_goo_type'] = 4; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
                        $wor_goo[$num]['wogo_state'] = 3; //商品状态1.正常 2.删除3回收的商品
                        $wor_goo[$num]['wogo_goo_amount'] = $value['goo_recycle_amount']; //可派单商品数量，商品数量
                        $wor_goo[$num]['wogo_goo_inventory'] = 1; //库存扣除方式1.良品 2.优先
                        $wor_goo[$num]['wogo_recycle_quantity'] = $value['goo_recycle_amount']; //回收数量
                        $wor_goo[$num]['wogo_actual_recycle_number'] = $value['goo_recycle_amount']; //实际回收数量
                        $wor_goo[$num]['wogo_remark'] = isset($value['goo_remark']) ? $value['goo_remark'] : ''; //备注

                        $ord_wafr_data[$num][] = $value['goo_wafr_id']; //仓位id
                        // 订单商品表新增回收的商品
                        $ord_goo[$num]['orgo_ord_id'] = $request['jur_ord_id']; //订单id
                        $ord_goo[$num]['orgo_order_number'] = $request['jur_ord_order_number']; //订单号
                        $ord_goo[$num]['orgo_ware_id'] = $request['jur_ware_id']; //仓库id
                        // $ord_goo[$num]['orgo_wafr_id'] = $value['goo_wafr_id']; //仓位id

                        $ord_goo[$num]['orgo_waon_class'] = $request['jur_waon_class']; //仓库类别
                        $ord_goo[$num]['orgo_goo_id'] = $value['goo_id']; //商品id
                        $ord_goo[$num]['orgo_goo_name'] = $find_goods_data->goo_name; //商品名称
                        $ord_goo[$num]['orgo_goo_goods_encode'] = isset($value['goo_goods_encode']) ? $value['goo_goods_encode'] : ''; //商品编号
                        $ord_goo[$num]['orgo_goo_ampere_hour'] = $value['goo_ampere_hour']; //商品安时数
                        $ord_goo[$num]['orgo_goo_type'] = 4; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
                        $ord_goo[$num]['orgo_goo_price'] = 0; //商品售价（单位：分）
                        $ord_goo[$num]['orgo_collection_price'] =  0; //代收金额（单位：分）
                        $ord_goo[$num]['orgo_goo_quantity'] = $value['goo_recycle_amount']; //订单商品数量
                        $ord_goo[$num]['orgo_goo_inventory'] = 1; //库存扣除方式1.良品 2.优先
                        $ord_goo[$num]['orgo_state'] = 3; //商品状态1.正常 2.删除3回收的商品
                        $ord_goo[$num]['orgo_is_recycle'] = 2; //回收状态：1回收2不回收
                        $ord_goo[$num]['orgo_recycle_quantity'] = $value['goo_recycle_amount']; //商品回收数量
                        $ord_goo[$num]['orgo_can_assign_quantity'] = 0; //剩余可以派工单的商品数量
                        $ord_goo[$num]['orgo_goo_quantity'] = $value['goo_recycle_amount']; //商品回收数量
                        // 回收单商品表重新添加的商品数据
                        $jugo_data[$num]['jugo_jur_id'] = $request['jur_id'];
                        $jugo_data[$num]['jugo_goo_id'] = $value['goo_id'];
                        $jugo_data[$num]['jugo_goo_name'] = $find_goods_data->goo_name;
                        $jugo_data[$num]['jugo_goo_goods_encode'] = isset($value['goo_goods_encode']) ? $value['goo_goods_encode'] : '';
                        $jugo_data[$num]['jugo_goo_price'] = 0;
                        $jugo_data[$num]['jugo_goo_ampere_hour'] = $value['goo_ampere_hour'];
                        $jugo_data[$num]['jugo_sell_number'] = 0;
                        $jugo_data[$num]['jugo_remark'] = $value['goo_remark'] ? $value['goo_remark'] : '';
                        $jugo_data[$num]['jugo_recycle_number'] = $value['goo_recycle_amount'];
                        $jugo_data[$num]['jugo_update_time'] = date('Y-m-d H:i:s');
                        $new_wor_goo_id[$num] = $value['goo_id'];
                        $num++;
                    }
                }
            }
        }
        // 订单商品表添加数据
        if (!empty($ord_goo)) {
            $wafr_orgo_id = [];
            foreach ($ord_goo as $key => $value) {
                $add_orgo_id = DB::table('order_goods')->insertGetId($value);
                foreach ($ord_wafr_data[$key] as $wafr_key => $wafr_value) {
                    $wafr_orgo_id[$value['orgo_goo_id']][$wafr_value] = $add_orgo_id;
                }
                $wor_goo[$key]['wogo_orgo_id'] = $add_orgo_id; //订单商品表主键id

                $add_wogo_id = DB::table('work_good')->insertGetId($wor_goo[$key]);
                // 旧货回收商品表新增回收商品数据
                $jugo_data[$key]['jugo_wogo_id'] = $add_wogo_id;
                $jugo_data[$key]['jugo_orgo_id'] = $add_orgo_id;
                $jugo_res = DB::table('junk_goods')->insertGetId($jugo_data[$key]);
                if (!$add_orgo_id || !$add_wogo_id || !$jugo_res) {
                    DB::rollBack();
                    return response()->json(['code'=>5002, 'msg'=>'error', 'data'=>'回收：失败']);
                }
            }

            foreach ($jugo_data as $key => $value) {
                // 出入库记录需要的的商品数租
                $oure_goods_data[$value['jugo_goo_id']]['goo_quantity'] = $value['jugo_recycle_number']; //出入库商品数量
                $oure_goods_data[$value['jugo_goo_id']]['goo_inventory'] = 1; //出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1

                // 出入库记录需要
                $oure_goods_id[$value['jugo_goo_id']] = $value['jugo_goo_id']; //出入库商品id
                $oure_goods_quantity[$value['jugo_goo_id']] = $value['jugo_recycle_number']; //出入库商品数量

                // 临时仓的默认到待还回(良品库存)
                // 旧货仓的默认到废旧品(优先库存)
                if ($request['jur_waon_class'] == 3) {
                    // 旧货仓
                    $oure_goods_inventory[$value['jugo_goo_id']] = 2; //出入库商品类型，类型1良品2优先
                } else {
                    // 临时仓
                    $oure_goods_inventory[$value['jugo_goo_id']] = 1; //出入库商品类型，类型1良品2优先
                }

                // 记录仓库商品表 所有要做修改的商品id 及其对应的数量
                $goods_data[$value['jugo_goo_id']] = $value['jugo_recycle_number'];
                // 记录仓位商品表 所有要做修改的商品id 及其对应的数量
                $goods_wafr_data[$value['jugo_goo_id']]['num'] = $value['jugo_recycle_number'];
                // $goods_wafr_data[$value['goo_id']]['wafg_wafr_id'] = $value['goo_wafr_id'];
                // 记录总入库商品数量
                $goods_number_sum =  $goods_number_sum + $value['jugo_recycle_number'];
            }
        }
        // 3 回收单表 修改 回收仓库/备注/回收数量/金额/回收状态
        $update_recycle['jur_price'] = 0; //回收总金额（单位：分）
        $update_recycle['jur_amount'] = $goods_number_sum; //实际回收商品总数量
        $update_recycle['jur_ware_id'] = $request['jur_ware_id']; //仓库id
        $update_recycle['jur_waon_class'] = $request['jur_waon_class']; //仓库类别
        $update_recycle['jur_remark'] = isset($request['jur_remark']) ? $request['jur_remark'] : ''; //备注
        $update_recycle['jur_state'] = 2; //回收状态 1.未回收 2.已回收 3不回收
        $update_recycle['jur_add_type'] = 3; //新增回收状态1回收入库2审核3已审核
        $update_recycle['jur_update_time'] = date("Y-m-d H:i:s"); //更新时间
        $junk_recycle = DB::table('junk_recycle')
            ->where('jur_id', $request['jur_id'])
            ->update($update_recycle);

        foreach ($request['goo_data'] as $key => $value) { //前端传过来的商品数据
            // 订单商品仓位表
            $orgf_data['orgf_shop_id'] = $user_info->adm_shop_id; //门店id
            $orgf_data['orgf_ord_id'] = $request['jur_ord_id']; //订单id
            $orgf_data['orgf_order_number'] = $request['jur_ord_order_number']; //订单号
            $orgf_data['orgf_orgo_id'] = $wafr_orgo_id[$value['goo_id']][$value['goo_wafr_id']]; //订单商品id
            $orgf_data['orgf_ware_id'] = $request['jur_ware_id']; //仓库id
            $orgf_data['orgf_wafr_id'] = $value['goo_wafr_id']; //仓位id
            $orgf_data['orgf_wafg_id'] = 0; //仓位商品主键id
            $orgf_data['orgf_goo_id'] = $value['goo_id']; //商品id
            $orgf_data['orgf_goo_quantity'] = $value['goo_recycle_amount']; //商品数量
            if ($request['jur_waon_class'] == 3) { //仓库类别：1货物仓2非货物仓3旧货仓4临时仓 仓库类别3旧货仓,回收商品到优先
                $orgf_data['orgf_goo_inventory'] = 2; //出库类型1良品2优先
            } else {
                $orgf_data['orgf_goo_inventory'] = 1; //出库类型1良品2优先
            }
            $orgf_data['orgf_original_id'] = $request['jur_id']; //旧货单id
            $orgf_data['orgf_outin_type'] = 2; //出入库类型：1出库2入库
            // 添加订单商品仓位数据
            $orgf_id = DB::table('order_goods_freight')->insertGetId($orgf_data);
            unset($orgf_data);
            // 4. 仓库商品表
            // 4.1 查询旧货仓库类表的商品库存数量
            $warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $request['jur_ware_id'])
                ->where('wago_class', $request['jur_waon_class'])
                ->where('wago_goo_id', $value['goo_id'])
                ->select('wago_id', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_freight_priority_stock_number', 'wago_freight_stock_number')
                ->first();

            if (empty($warehouse_goods)) {
                $ware_add_data['wago_ware_id'] = $request['jur_ware_id'];
                $ware_add_data['wago_class'] = $request['jur_waon_class'];
                $ware_add_data['wago_goo_id'] = $value['goo_id'];
                // 临时仓的默认到待还回(良品库存)
                // 旧货仓的默认到废旧品(优先库存)
                if ($request['jur_waon_class'] == 3) {
                    // 旧货仓
                    $ware_add_data['wago_priority_stock_number'] = $value['goo_recycle_amount'];
                    if ($ware_type == 1) {
                        $ware_add_data['wago_freight_priority_stock_number'] = $value['goo_recycle_amount'];
                    }
                } else {
                    // 临时仓
                    $ware_add_data['wago_stock_number'] = $value['goo_recycle_amount'];
                    if ($ware_type == 1) {
                        $ware_add_data['wago_freight_stock_number'] = $value['goo_recycle_amount'];
                    }
                }
                $ware_add_res = DB::table('warehouse_goods')->insert($ware_add_data);
                $update_wago_res = true;
            } else {
                if ($request['jur_waon_class'] == 3) {
                    $update_wago_data['wago_priority_stock_number'] = $warehouse_goods->wago_priority_stock_number + $value['goo_recycle_amount'];
                    if ($ware_type == 1) {
                        $update_wago_data['wago_freight_priority_stock_number'] = $warehouse_goods->wago_freight_priority_stock_number + $value['goo_recycle_amount'];
                    }
                } else {
                    $update_wago_data['wago_stock_number'] = $warehouse_goods->wago_stock_number + $value['goo_recycle_amount'];
                    if ($ware_type == 1) {
                        $update_wago_data['wago_freight_stock_number'] = $warehouse_goods->wago_freight_stock_number + $value['goo_recycle_amount'];
                    }
                }
                $update_wago_data['wago_update_time'] = date("Y-m-d H:i:s");
                $update_wago_res = DB::table('warehouse_goods')
                    ->where('wago_id', $warehouse_goods->wago_id)
                    ->update($update_wago_data);
                $ware_add_res = true;
            }
            if (!$update_wago_res && !$ware_add_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'回收：失败'];
            }
            if ($ware_type == 1) {
                // 4.1.1 查询仓位商品表的商品库存数量
                $warehouse_freight_goods = DB::table('warehouse_freight_goods')
                    // ->where('wafg_ware_id', $request['jur_ware_id'])
                    ->where('wafg_wafr_id', $value['goo_wafr_id'])
                    ->where('wafg_class', $request['jur_waon_class'])
                    ->where('wafg_goo_id', $value['goo_id'])
                    ->select('wafg_id', 'wafg_wafr_id', 'wafg_goo_id', 'wafg_stock_number', 'wafg_priority_stock_number')
                    ->first();
                if (empty($warehouse_freight_goods)) {
                    $wogo_id = DB::table('warehouse_goods')
                        ->where('wago_ware_id', $request['jur_ware_id'])
                        ->where('wago_class', $request['jur_waon_class'])
                        ->where('wago_goo_id', $value['goo_id'])
                        ->value('wago_id');
                    $wafg_add_data['wafg_ware_id'] = $request['jur_ware_id'];
                    $wafg_add_data['wafg_wafr_id'] = $value['goo_wafr_id'];
                    $wafg_add_data['wafg_wago_id'] = $wogo_id;
                    $wafg_add_data['wafg_class'] = $request['jur_waon_class'];
                    $wafg_add_data['wafg_goo_id'] = $value['goo_id'];
                    // 临时仓的默认到待还回(良品库存)
                    // 旧货仓的默认到废旧品(优先库存)
                    if ($request['jur_waon_class'] == 3) {
                        // 旧货仓
                        $wafg_add_data['wafg_priority_stock_number'] = $value['goo_recycle_amount'];
                    } else { // 临时仓
                        $wafg_add_data['wafg_stock_number'] = $value['goo_recycle_amount'];
                    }
                    $wafg_add_res = DB::table('warehouse_freight_goods')->insertGetId($wafg_add_data);
                    $wafg_id = $wafg_add_res;
                    $update_wafg_res = true;
                } else {
                    if ($request['jur_waon_class'] == 3) { //旧货仓
                        $update_wafg_data['wafg_priority_stock_number'] = $warehouse_freight_goods->wafg_priority_stock_number + $value['goo_recycle_amount'];
                    } else {
                        $update_wafg_data['wafg_stock_number'] = $warehouse_freight_goods->wafg_stock_number + $value['goo_recycle_amount'];
                    }
                    $update_wafg_data['wafg_update_time'] = date("Y-m-d H:i:s");
                    $update_wafg_res = DB::table('warehouse_freight_goods')
                        ->where('wafg_id', $warehouse_freight_goods->wafg_id)
                        ->update($update_wafg_data);
                    $wafg_add_res = $warehouse_freight_goods->wafg_id;
                    $wafg_add_res = true;
                }
                if ($request['jur_waon_class'] == 3) {
                    $increment_wafr_res = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['goo_wafr_id'])
                        ->increment('wafr_priority_all_stock', $value['goo_recycle_amount']);
                } else {
                    $increment_wafr_res = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['goo_wafr_id'])
                        ->increment('wafr_all_stock', $value['goo_recycle_amount']);
                }
                if (!$increment_wafr_res) {
                    DB::rollBack();
                    return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'回收：失败']);
                }
                $primary_id = DB::table('junk_goods')
                    ->where('jugo_jur_id', $request['jur_id'])
                    ->where('jugo_goo_id', $value['goo_id'])
                    ->value('jugo_id');
                // 仓位出入库记录
                $outin_recore_res = Stocktake::junkaddition(
                    $user_info,
                    $request['jur_ware_id'], //仓库id
                    $request['jur_waon_class'], //仓库类型
                    $value['goo_wafr_id'], //仓位id
                    5, //旧货回收
                    $request['jur_id'], //原始单id
                    $request['jur_number'], //原始单单号
                    $primary_id, //关联商品表主键id
                    $value['goo_id'], //商品表主键id
                    2, //出入库类型：1出库2入库
                    $value['goo_recycle_amount'], //商品数量
                    $inventory = $request['jur_waon_class'] == 3 ? 2 : 1 //出库类型1良品2优先3待检测
                );
                if ($outin_recore_res['code'] == 200) {
                    $outin_recore_res = true;
                }
            } else {
                $update_wafg_res = true;
                $wafg_add_res = true;
                $outin_recore_res = true;
                $increment_wafr_res = true;
            }

            if (!$wafg_add_res || !$update_wafg_res || !$increment_wafr_res || !$outin_recore_res || !$orgf_id) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'回收：失败'];
            }
        }

        // 5.修改仓库表 总库存量
        if ($request['jur_waon_class'] == 3) { //优先
            $stock_amount_res = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $request['jur_ware_id'])
                ->where('waon_class', $request['jur_waon_class'])
                ->increment('waon_stock_priority_amount', $goods_number_sum);
        } else { //良品
            $stock_amount_res = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $request['jur_ware_id'])
                ->where('waon_class', $request['jur_waon_class'])
                ->increment('waon_stock_fine_amount', $goods_number_sum);
        }
        $all_amount_res = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $request['jur_ware_id'])
            ->where('waon_class', $request['jur_waon_class'])
            ->increment('waon_all_amount', $goods_number_sum);
        // 出入库记录相关数据
        $find_ware = DB::table('warehouse_onhand')
            ->where('waon_ware_id', $request['jur_ware_id'])
            ->where('waon_class', $request['jur_waon_class'])
            ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
            ->first();
        // 1. 新增一条入库记录
        $find_junk = DB::table('junk_recycle as jure')
            ->leftJoin('junk_client as jucl', 'jucl.jucl_jur_id', '=', 'jure.jur_id')
            ->where('jur_id', $request['jur_id'])
            ->select('jur_id', 'jur_number', 'jur_type', 'jucl_client_id')
            ->first();
        $oure_res = OutinRecord::addition(
            $user_info, //用户信息
            $request['jur_ord_id'], //原始单的关联id
            $request['jur_ord_order_number'], //原始单的关联单号
            1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
            $find_junk->jur_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
            $find_junk->jucl_client_id, //选择的客户id,会员id/单位id
            $request['jur_number'], //原始单号，旧货回收单单号
            $request['jur_ware_id'], //入库仓库id
            0, //出库仓库id
            $goods_number_sum, //出库的商品总数量
            4, //类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
            3, //操作类型：1锁定库存2出库3入库4调货5发货
            $find_ware->waon_stock_fine_amount, //良品总库存
            $find_ware->waon_lock_fine_amount, //良品锁定数量
            $find_ware->waon_stock_priority_amount, //优先总库存
            $find_ware->waon_lock_priority_amount, //优先锁定数量
            $find_ware->waon_stock_unchecked_amount, //待检测总库存
            2, //出入库类型：1出库，2入库
            $request['jur_waon_class'], //仓库类别
            $oure_goods_id, //商品id
            $oure_goods_quantity, //商品数量
            $oure_goods_inventory //出库类型1良品2优先
        );
        $osld_in_key = 0;
        foreach ($jugo_data as $key => $value) {
            // 临时仓的默认到待还回(良品库存)
            // 旧货仓的默认到废旧品(优先库存)
            if ($request['jur_waon_class'] == 3) {
                // 旧货仓
                $oure_goods_inventory[$value['jugo_goo_id']] = 2; //出入库商品类型，类型1良品2优先
            } else {
                // 临时仓
                $oure_goods_inventory[$value['jugo_goo_id']] = 1; //出入库商品类型，类型1良品2优先
            }

            // 库存锁定-出入库记录表
            $osld_goo_data[$osld_in_key]['goo_waon_class'] = $request['jur_waon_class']; //仓库类别：1货物仓2非货物仓3旧货仓4临时仓
            $osld_goo_data[$osld_in_key]['goo_id'] = $value['jugo_goo_id']; //商品id
            $osld_goo_data[$osld_in_key]['goo_number'] = $value['jugo_recycle_number']; //商品数量
            $osld_goo_data[$osld_in_key]['goo_out_in_type'] = 2; //出入库类型：1出库2入库3锁定4取消锁定
            $osld_goo_data[$osld_in_key]['goo_inventory'] = $oure_goods_inventory[$value['jugo_goo_id']]; //类型1良品2优先3待检测
            // 查询仓库商品库存数量
            $find_wago_data = DB::table('warehouse_goods')
                ->where('wago_ware_id', $request['jur_ware_id'])
                ->where('wago_class', $request['jur_waon_class'])
                ->where('wago_goo_id', $value['jugo_goo_id'])
                ->select('wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_unchecked_stock_number')
                ->first();
            if ($oure_goods_inventory[$value['jugo_goo_id']] == 1) { //良品
                $osld_goo_data[$osld_in_key]['old_stock_number'] = $find_wago_data->wago_stock_number - $value['jugo_recycle_number']; //旧的商品良品库存数量
                $osld_goo_data[$osld_in_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number; //旧的商品优先库存数量
                $osld_goo_data[$osld_in_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                $osld_goo_data[$osld_in_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
            } else { //优先
                $osld_goo_data[$osld_in_key]['old_stock_number'] = $find_wago_data->wago_stock_number; //旧的商品良品库存数量
                $osld_goo_data[$osld_in_key]['old_priority_number'] = $find_wago_data->wago_priority_stock_number - $value['jugo_recycle_number']; //旧的商品优先库存数量
                $osld_goo_data[$osld_in_key]['new_stock_number'] = $find_wago_data->wago_stock_number; //新的商品良品库存数量
                $osld_goo_data[$osld_in_key]['new_priority_number'] = $find_wago_data->wago_priority_stock_number; //新的商品优先库存数量
            }
            $osld_goo_data[$osld_in_key]['old_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //旧的商品良品库存锁定数量
            $osld_goo_data[$osld_in_key]['old_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //旧的商品优先库存锁定数量
            $osld_goo_data[$osld_in_key]['old_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //旧的商品待检测库存数量
            $osld_goo_data[$osld_in_key]['new_stock_lock_number'] = $find_wago_data->wago_lock_quantity; //新的商品良品库存锁定数量
            $osld_goo_data[$osld_in_key]['new_priority_lock_number'] = $find_wago_data->wago_priority_lock_quantity; //新的商品优先库存锁定数量
            $osld_goo_data[$osld_in_key]['new_unchecked_number'] = $find_wago_data->wago_unchecked_stock_number; //新的商品待检测库存数量
            $osld_goo_data[$osld_in_key]['osld_update_time'] = date('Y-m-d H:i:s'); //更新时间
            $osld_goo_data[$osld_in_key] = (object)$osld_goo_data[$osld_in_key];
            $osld_in_key++;
        }
        // 库存锁定-出入库记录
        $oslr_res = OutinStockLock::addition(
            $user_info, //用户信息
            $request['jur_ord_id'], //原始单的关联id
            $request['jur_ord_order_number'], //原始单的关联单号
            1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
            $find_junk->jur_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
            $find_junk->jucl_client_id, //选择的客户id,会员id/单位id
            $request['jur_number'], //原始单号
            $request['jur_ware_id'], //出库/入库的仓库id
            $goods_number_sum, //出库/入库总数量
            4, //类型：1锁定库存2取消锁定3调拨单4旧货回收单5退换回收单6订单出库7部分入库8部分出库9发货单10移动仓出库11换货出库12换货入库13退货入库14退货出库15盘库单
            $find_ware->waon_stock_fine_amount, //良品总库存
            $find_ware->waon_lock_fine_amount, //良品锁定数量
            $find_ware->waon_stock_priority_amount, //优先总库存
            $find_ware->waon_lock_priority_amount, //优先锁定数量
            $find_ware->waon_stock_unchecked_amount, //待检测总库存
            2, //出入库类型：1出库，2入库
            $osld_goo_data
        );
        unset($osld_goo_data);
        if ($junk_recycle && $ware_add_res && $stock_amount_res && $all_amount_res && $oure_res && $oslr_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'回收：成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'回收：失败'];
        }
    }
}
