<?php
namespace App\Http\Models\Services\ProductManage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

// 基础管理 -- 易损件列表
class WearingPart extends Model
{
    // 新增易损件
    public static function addwearingPart(
        $request,
        $user_info
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 1. 判断商品名称是否存在
        $find_goo = DB::table('goods')
            ->where('goo_delete', 1)
            ->where(function ($query) use ($user_info) {
                $query->where('goo_shop_id', 0)
                    ->orwhere('goo_shop_id', $user_info->adm_shop_id);
            })
            ->where('goo_name', $request['goo_name'])
            ->select('goo_id')
            ->first();
        if ($find_goo) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'商品名称已存在'];
        }

        // 判断检索编码是否存在
        if (!empty($request['goo_goods_encode'])) {
            if ($request['goo_goods_encode'][0] == 'X' || $request['goo_goods_encode'][0] == 'x') {
                return ['code'=>500, 'msg'=>'error', 'data'=>'检索编码不能以X或x开头'];
            }
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_goods_encode', $request['goo_goods_encode'])
                ->select('goo_id')
                ->first();
            if ($find_goo) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'检索编码已存在'];
            }
        }

        // 判断商品编号是否存在
        if (!empty($request['goo_goods_code'])) {
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_goods_code', $request['goo_goods_code'])
                ->select('goo_id')
                ->first();
            if ($find_goo) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'商品编号已存在'];
            }
        }

        // 2 新增一个商品数据 
        $goo_add_data['goo_cid'] = $user_info->adm_cid;
        $goo_add_data['goo_shop_id'] = $user_info->adm_shop_id;
        $goo_add_data['goo_superior_shop_id'] = $shop_id;
        $goo_add_data['goo_class'] = 1;//类型：1自营商品2系统商品
        $goo_add_data['goo_state'] = 1;//状态1启用2停用
        $goo_add_data['goo_name'] = $request['goo_name'];  //商品名称
        $goo_add_data['goo_type'] = 5;   //1正常商品2赠品商品3活动商品4旧货商品5易损件
        $goo_add_data['goo_goods_code'] = $request['goo_goods_code'] ? $request['goo_goods_code'] : '';   //商品编号
        $goo_add_data['goo_goods_encode'] = $request['goo_goods_encode'] ? $request['goo_goods_encode'] : '';   //检索编码
        $goo_add_data['goo_cate_id'] = $request['goo_cate_id']; //所属品类id
        $goo_add_data['goo_cate_name'] = $request['goo_cate_name']; //品类名称
        $goo_add_data['goo_price'] = $request['goo_price'] * 100;   //商品零售价格
        $goo_add_data['goo_wholesale_price'] = $request['goo_wholesale_price'] * 100;   //批发价
        $goo_add_data['goo_purchase_price'] = $request['goo_purchase_price'] * 100; //采购价 / 进货价
        $goo_add_data['goo_channel_price'] = $request['goo_channel_price'] * 100; //渠道价
        $goo_add_data['goo_shop_price'] = $request['goo_shop_price'] * 100; //分店价
        $goo_add_data['goo_vip_price'] = $request['goo_vip_price'] * 100; //会员价
        $goo_add_data['goo_system_code'] = str_pad($user_info->adm_cid, '4', '0', STR_PAD_RIGHT) . str_pad($user_info->adm_shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
        $goo_add_data['goo_unit'] = $request['goo_unit'] ? $request['goo_unit'] : ''; //商品单位
        $goo_add_data['goo_bra_id'] = $request['goo_bra_id'];
        $goo_add_data['goo_bra_name'] = $request['goo_bra_name'];
        // 新增商品
        $goo_id =  DB::table('goods')->insertGetId($goo_add_data);

        // 商品附属表新增数据
        $goaf_add_data['goaf_goo_id'] = $goo_id; //商品id
        $goaf_add_data['goaf_shop_id'] = $user_info->adm_shop_id; //门店id
        $goaf_add_data['goaf_goods_bar_code'] = $request['goaf_goods_bar_code'] ? $request['goaf_goods_bar_code'] : ''; //商品条码
        $goaf_add_data['goaf_goods_material_code'] = $request['goaf_goods_material_code'] ? $request['goaf_goods_material_code'] : ''; //商品料号
        $goaf_add_data['goaf_min_order_quantity'] = $request['goaf_min_order_quantity'] ? $request['goaf_min_order_quantity'] : ''; //最小下单量
        $goaf_add_data['goaf_arrival_period'] = $request['goaf_arrival_period'] ? $request['goaf_arrival_period'] : ''; //到货周期
        $goaf_add_data['goaf_case_number'] = $request['goaf_case_number'] ? $request['goaf_case_number'] : ''; //装箱数
        $goaf_add_data['goaf_length'] = $request['goaf_length'] ? $request['goaf_length'] : ''; //长
        $goaf_add_data['goaf_width'] = $request['goaf_width'] ? $request['goaf_width'] : ''; //宽
        $goaf_add_data['goaf_height'] = $request['goaf_height'] ? $request['goaf_height'] : ''; //高
        $goaf_add_data['goaf_weight'] = $request['goaf_weight']; //重量 
        $goaf_add_data['goaf_description'] = $request['goaf_description'] ? $request['goaf_description'] : ''; //详细介绍
        $goaf_add_data['goaf_clause'] = $request['goaf_clause'] ? $request['goaf_clause'] : ''; //售后条款
        $goaf_add_data['goaf_car_part'] = $request['goaf_car_part'] ? $request['goaf_car_part'] : ''; //车辆部位
        $goaf_add_data['goaf_update_time'] = date('Y-m-d H:i:s'); //添加时间
        $goaf_res =  DB::table('goods_affiliate')->insert($goaf_add_data);

        // 品牌品类商品统计表
        $gobc_res = DB::table('goods_bra_cate')
            ->where('gobc_bra_id', $request['goo_bra_id'])
            ->where('gobc_cate_id', $request['goo_cate_id'])
            ->value('gobc_number');
        if ($gobc_res) {// 此品类下有商品就增加1
            $gobc_update = DB::table('goods_bra_cate')
                ->where('gobc_bra_id', $request['goo_bra_id'])
                ->where('gobc_cate_id', $request['goo_cate_id'])
                ->increment('gobc_number', 1);
        } else {// 统计表中没有此品类，新增一个
            $add_gobc_data['gobc_shop_id'] = $user_info->adm_shop_id;
            $add_gobc_data['gobc_bra_id'] = $request['goo_bra_id'];
            $add_gobc_data['gobc_bra_name'] = $request['goo_bra_name'];
            $add_gobc_data['gobc_cate_id'] = $request['goo_cate_id'];
            $add_gobc_data['gobc_cate_name'] = $request['goo_cate_name'];
            $add_gobc_data['gobc_number'] = 1; //商品数量
            $add_gobc_data['gobc_attribute'] = 2; //商品属性1蓄电池2易损件
            $add_gobc_data['gobc_update_time'] = date('Y-m-d H:i:s');
            $gobc_update = DB::table('goods_bra_cate')->insert($add_gobc_data);
        }
        // 4.商品所属品类数量更改
        $find_caco_id = DB::table('category_correlation')
            ->where('caco_cate_id', $request['goo_cate_id'])
            ->where('caco_shop_id', $user_info->adm_shop_id)
            ->value('caco_id');
        if ($find_caco_id) {
            $res_cate = DB::table('category_correlation')
                ->where('caco_cate_id', $request['goo_cate_id'])
                ->where('caco_shop_id', $user_info->adm_shop_id)
                ->increment('caco_goods_number', 2);
        } else {
            // 没有数据，新增数据
            $add_caco_data['caco_shop_id'] = $user_info->adm_shop_id;
            $add_caco_data['caco_cate_id'] = $request['goo_cate_id'];
            $add_caco_data['caco_goods_number'] = 2;
            $add_caco_data['caco_update_time'] = date('Y-m-d H:i:s');
            $res_cate = DB::table('category_correlation')->insert($add_caco_data);
        }

        // 5.商品所属品牌数量更改
        if ($request['goo_bra_id']) {
            // 查询关联表是否有数据
            $find_brco_id = DB::table('brand_correlation')
                ->where('brco_bra_id', $request['goo_bra_id'])
                ->where('brco_shop_id', $user_info->adm_shop_id)
                ->value('brco_id');
            if ($find_brco_id) {
                // 有数据增加数量
                $res_brand = DB::table('brand_correlation')
                    ->where('brco_bra_id', $request['goo_bra_id'])
                    ->where('brco_shop_id', $user_info->adm_shop_id)
                    ->increment('brco_goods_number', 2);
            } else {
                // 没有数据，新增数据
                $add_brco_data['brco_shop_id'] = $user_info->adm_shop_id;
                $add_brco_data['brco_bra_id'] = $request['goo_bra_id'];
                $add_brco_data['brco_goods_number'] = 2;
                $add_brco_data['brco_update_time'] = date('Y-m-d H:i:s');
                $res_brand = DB::table('brand_correlation')->insert($add_brco_data);
            }
        } else {
            $res_brand = true;
        }

        if (!empty($request['ware_id']) ) {
            // 新增仓库商品
            $ware_add_data['wago_ware_id'] = $request['ware_id'];//仓库id
            $ware_add_data['wago_goo_id'] = $goo_id;
            if (!empty($request['wafr_id'])) {
                $ware_add_data['wago_freight_stock_number'] = $request['number'] ? $request['number'] : 0;
            } else {
                $ware_add_data['wago_stock_amount'] = $request['number'] ? $request['number'] : 0;
            }
            $ware_add_data['wago_stock_number'] = $request['number'] ? $request['number'] : 0;
            $ware_add_res = DB::table('warehouse_goods')->insertGetId($ware_add_data);
            if (!empty($request['wafr_id'])) {
                // 新增仓位商品
                $wafg_data['wafg_wafr_id'] = $request['wafr_id'];
                $wafg_data['wafg_wago_id'] = $ware_add_res;
                $wafg_data['wafg_ware_id'] = $request['ware_id'];
                $wafg_data['wafg_class'] = 1;
                $wafg_data['wafg_goo_id'] = $goo_id;
                $wafg_data['wafg_stock_number'] = $request['number'] ? $request['number'] : 0;
                $wafg_add_res = DB::table('warehouse_freight_goods')->insertGetId($wafg_data);
            } else {
                $wafg_add_res = true;
            }
        } else {
            $wafg_add_res = true;
            $ware_add_res = true;
        }

        if ($request['number'] > 0) {//新增商品数量大于0
            $waon_inc_res1 = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $request['ware_id'])
                ->where('waon_class', 1)
                ->increment('waon_all_amount', $request['number']); //仓库类别所有商品的总库存
            $waon_inc_res2 = DB::table('warehouse_onhand')
                ->where('waon_ware_id', $request['ware_id'])
                ->where('waon_class', 1)
                ->increment('waon_stock_fine_amount', $request['number']); //良品总库存数量
            // 新增商品库存-添加进销存期初库存
            $enss_data['ense_shop_id'] = $user_info->adm_shop_id;
            $enss_data['ense_goo_id'] = $goo_id;
            $enss_data['ense_goo_name'] = $request['goo_name'];
            $enss_data['ense_goo_number'] = $request['goo_goods_code'];
            $enss_data['ense_goo_waretype'] = 1;
            $enss_data['ense_goo_warehouse'] = $request['ware_id'];
            $enss_data['ense_new_inventory'] = $request['number'];
            $enss_data['ense_end_inventory'] = $request['number'];
            $enss_data['ense_new_price'] = sprintf("%.4f", $request['goo_purchase_price']); //期初平均价;
            $enss_data['ense_end_price'] = sprintf("%.4f", $request['goo_purchase_price']); //期末平均价
            $enss_data['ense_new_amount'] = $request['goo_purchase_price']*$request['number'];
            $enss_data['ense_end_amount'] = $request['goo_purchase_price']*$request['number'];
            $enss_add_res = DB::table('enters_sells_saves')->insertGetId($enss_data);
            if (!$waon_inc_res1 || !$waon_inc_res2 || !$enss_add_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'新增商品：失败3'];
            }
        }
        // 匹配车型
        if (!empty($request['car_id'])) {
            foreach ($request['car_id'] as $key => $value) {
                $gocc_data['gocc_shop_id'] = $user_info->adm_shop_id;
                $gocc_data['gocc_goo_id'] = $goo_id;
                $gocc_data['gocc_car_id'] = $value;
                $gocc_res = DB::table('goods_car_correlation')->insert($gocc_data);
                if (!$gocc_res) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'新增商品：失败1'];
                }
            }
        }

        if ($goo_id && $goaf_res && $res_cate && $res_brand && $ware_add_res && $wafg_add_res && $gobc_update) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'新增商品：成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'新增商品：失败2'];
        }
    }

    // 编辑易损件
    public static function edit(
        $request,
        $user_info
    ){
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 1. 判断商品名称是否存在
        $goo_info = DB::table('goods')
            ->where('goo_id', $request['goo_id'])
            ->first(['goo_type', 'goo_class']);
        if ($goo_info->goo_class == 2) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'系统商品不允许修改'];
        }

        // 判断商品编号是否存在
        if (!empty($request['goo_goods_code'])) {
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where('goo_type', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_id', '!=', $request['goo_id'])
                ->where('goo_goods_code', $request['goo_goods_code'])
                ->select('goo_id')
                ->first();
            if ($find_goo) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'商品编号已存在'];
            }
        }
        // 查询出商品未编辑前的商品品类/商品所属品牌数量更改
        $goods_info = DB::table('goods')
            ->where('goo_id', $request['goo_id'])
            ->select('goo_bra_id', 'goo_brse_id', 'goo_cate_id')
            ->first();

        // 2 编辑一个商品数据
        $goo_edit_data['goo_cid'] = $user_info->adm_cid;
        $goo_edit_data['goo_shop_id'] = $user_info->adm_shop_id;
        $goo_edit_data['goo_superior_shop_id'] = $shop_id;
        $goo_edit_data['goo_class'] = 1;//类型：1自营商品2系统商品
        $goo_edit_data['goo_state'] = 1;//状态1启用2停用
        $goo_edit_data['goo_name'] = $request['goo_name'];  //商品名称
        $goo_edit_data['goo_type'] = 1;   //1正常商品2赠品商品3活动商品4旧货商品
        $goo_edit_data['goo_goods_code'] = $request['goo_goods_code'] ? $request['goo_goods_code'] : '';   //商品编号
        $goo_edit_data['goo_goods_encode'] = $request['goo_goods_encode'] ? $request['goo_goods_encode'] : '';   //检索编码
        $goo_edit_data['goo_cate_id'] = $request['goo_cate_id']; //所属品类id
        $goo_edit_data['goo_cate_name'] = $request['goo_cate_name']; //品类名称
        $goo_edit_data['goo_price'] = $request['goo_price'] * 100;   //商品零售价格
        $goo_edit_data['goo_wholesale_price'] = $request['goo_wholesale_price'] * 100;   //批发价
        $goo_edit_data['goo_purchase_price'] = $request['goo_purchase_price'] * 100; //采购价 / 进货价
        $goo_edit_data['goo_channel_price'] = $request['goo_channel_price'] * 100; //渠道价
        $goo_edit_data['goo_shop_price'] = $request['goo_shop_price'] * 100; //分店价
        $goo_edit_data['goo_vip_price'] = $request['goo_vip_price'] * 100; //会员价
        $goo_edit_data['goo_unit'] = $request['goo_unit'] ? $request['goo_unit'] : ''; //商品单位
        $goo_edit_data['goo_bra_id'] = $request['goo_bra_id'];
        $goo_edit_data['goo_bra_name'] = $request['goo_bra_name'];
        // 编辑商品
        $goo_res =  DB::table('goods')
            ->where('goo_id', $request['goo_id'])
            ->update($goo_edit_data);

        $goaf_edit_data['goaf_goo_id'] = $request['goo_id']; //商品id
        $goaf_edit_data['goaf_shop_id'] = $user_info->adm_shop_id; //门店id
        $goaf_edit_data['goaf_goods_bar_code'] = $request['goaf_goods_bar_code'] ? $request['goaf_goods_bar_code'] : ''; //商品条码
        $goaf_edit_data['goaf_goods_material_code'] = $request['goaf_goods_material_code'] ? $request['goaf_goods_material_code'] : ''; //商品料号
        $goaf_edit_data['goaf_min_order_quantity'] = $request['goaf_min_order_quantity'] ? $request['goaf_min_order_quantity'] : ''; //最小下单量
        $goaf_edit_data['goaf_arrival_period'] = $request['goaf_arrival_period'] ? $request['goaf_arrival_period'] : ''; //到货周期
        $goaf_edit_data['goaf_case_number'] = $request['goaf_case_number'] ? $request['goaf_case_number'] : ''; //装箱数
        $goaf_edit_data['goaf_length'] = $request['goaf_length'] ? $request['goaf_length'] : ''; //长
        $goaf_edit_data['goaf_width'] = $request['goaf_width'] ? $request['goaf_width'] : ''; //宽
        $goaf_edit_data['goaf_height'] = $request['goaf_height'] ? $request['goaf_height'] : ''; //高
        $goaf_edit_data['goaf_weight'] = $request['goaf_weight']; //重量 
        $goaf_edit_data['goaf_description'] = $request['goaf_description'] ? $request['goaf_description'] : ''; //详细介绍
        $goaf_edit_data['goaf_clause'] = $request['goaf_clause'] ? $request['goaf_clause'] : ''; //售后条款
        $goaf_edit_data['goaf_car_part'] = $request['goaf_car_part'] ? $request['goaf_car_part'] : ''; //车辆部位
        $goaf_edit_data['goaf_update_time'] = date('Y-m-d H:i:s'); //添加时间

        $goaf_res =  DB::table('goods_affiliate')
                ->where('goaf_goo_id', $request['goo_id'])
                ->update($goaf_edit_data);


        // 4.判断是否更改商品所属品类
        if ($request['goo_cate_id'] != $goods_info->goo_cate_id) {
            // 更改商品所属品类
            $find_cc = DB::table('category_correlation')
                ->where('caco_cate_id', $request['goo_cate_id'])
                ->where('caco_shop_id', $user_info->adm_shop_id)
                ->select('caco_id')
                ->first();
            if (empty($find_cc)) {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请先创建品类']);
            }
            $save_cate_add = DB::table('category_correlation')
                ->where('caco_cate_id', $request['goo_cate_id'])
                ->where('caco_shop_id', $user_info->adm_shop_id)
                ->increment('caco_goods_number', $num); //商品所属品类+1

            $save_cate_subtract = DB::table('category_correlation')
                ->where('caco_cate_id', $goods_info->goo_cate_id)
                ->where('caco_shop_id', $user_info->adm_shop_id)
                ->decrement('caco_goods_number', $num); //商品所属品类-1
            if ($save_cate_add && $save_cate_subtract) {
                $save_cate = true;
            } else {
                $save_cate = false;
            }
        } else {
            $save_cate = true;
        }

        // 5.判断是否更改商品所属品牌
        if ($request['goo_bra_id'] != $goods_info->goo_bra_id) {
            // 更改商品所属品牌
            $find_bc = DB::table('brand_correlation')
                ->where('brco_bra_id', $request['goo_bra_id'])
                ->where('brco_shop_id', $user_info->adm_shop_id)
                ->select('brco_id')
                ->first();
            if ($find_bc) {
                if ($request['goo_bra_id']) {
                    $save_bra_add = DB::table('brand_correlation')
                        ->where('brco_bra_id', $request['goo_bra_id'])
                        ->where('brco_shop_id', $user_info->adm_shop_id)
                        ->increment('brco_goods_number', $num); //商品所属品类+1
                } else {
                    $save_bra_add = true;
                }
            } else {
                DB::rollBack();
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请先创建品牌']);
            }


            if ($goods_info->goo_bra_id) {
                $save_bra_subtract = DB::table('brand_correlation')
                    ->where('brco_bra_id', $goods_info->goo_bra_id)
                    ->where('brco_shop_id', $user_info->adm_shop_id)
                    ->decrement('brco_goods_number', $num); //商品所属品类-1
            } else {
                $save_bra_subtract = true;
            }
            if ($save_bra_add && $save_bra_subtract) {
                $save_bra = true;
            } else {
                $save_bra = false;
            }
        } else {
            $save_bra = true;
        }

        if ($goo_res && $goaf_res && $save_cate && $save_bra) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'编辑商品：成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'编辑商品：失败'];
        }
    }

    // 价格维护
    public static function editPrice(
        $request
    ){
        $goo_edit_data['goo_price'] = $request['goo_price'] * 100;   //商品零售价格
        $goo_edit_data['goo_wholesale_price'] = $request['goo_wholesale_price'] * 100;   //批发价
        $goo_edit_data['goo_purchase_price'] = $request['goo_purchase_price'] * 100; //采购价 / 进货价
        $goo_edit_data['goo_channel_price'] = $request['goo_channel_price'] * 100; //渠道价
        $goo_edit_data['goo_shop_price'] = $request['goo_shop_price'] * 100; //分店价
        $goo_edit_data['goo_vip_price'] = $request['goo_vip_price'] * 100; //会员价
        $goo_edit_data['goo_update_time'] = date('Y-m-d H:i:s'); //会员价
        // 修改价格
        $goo_res =  DB::table('goods')
            ->where('goo_id', $request['goo_id'])
            ->update($goo_edit_data);
        if ($goo_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'价格维护：成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'价格维护：失败'];
        }
    }

    // 匹配车型
    public static function matchModel(
        $request,
        $user_info
    ){
        // 匹配车型
        if (empty($request['car_id'])) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'请选择要匹配的车型'];
        }
        foreach ($request['car_id'] as $key => $value) {
            $find_goods_car = DB::table('goods_car_correlation')
                ->where('gocc_shop_id', $user_info->adm_shop_id)
                ->where('gocc_goo_id', $request['goo_id'])
                ->where('gocc_car_id', $value)
                ->value('gocc_goo_id');
            if ($find_goods_car) {
                continue;
            }
            $gocc_data['gocc_shop_id'] = $user_info->adm_shop_id;
            $gocc_data['gocc_goo_id'] = $request['goo_id'];
            $gocc_data['gocc_car_id'] = $value;
            $gocc_res = DB::table('goods_car_correlation')->insert($gocc_data);
            if (!$gocc_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'新增商品：失败1'];
            }
        }
        return ['code'=>200, 'msg'=>'success', 'data'=>'价格维护：成功'];
    }
}
