<?php
namespace App\Http\Models\Services\ProductManage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

// 基础管理 -- 产品列表，洗美
class GoodsList extends Model
{
    // 新增
    public static function create(
        $user_info,
        $request
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 1. 判断商品名称是否存在
        $find_goo = DB::table('goods')
            ->where('goo_delete', 1)
            ->where(function ($query) use ($user_info) {
                $query->where('goo_shop_id', 0)
                    ->orwhere('goo_shop_id', $user_info->adm_shop_id);
            })
            ->where('goo_name', $request['goo_name'])
            ->select('goo_id')
            ->first();
        if ($find_goo) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'商品名称已存在'];
        }

        // 判断检索编码是否存在
        if (!empty($request['goo_goods_encode'])) {
            if ($request['goo_goods_encode'][0] == 'X' || $request['goo_goods_encode'][0] == 'x') {
                return ['code'=>500, 'msg'=>'error', 'data'=>'检索编码不能以X或x开头'];
            }
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_goods_encode', $request['goo_goods_encode'])
                ->select('goo_id')
                ->first();
            if ($find_goo) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'检索编码已存在'];
            }
        }

        // 判断商品编号是否存在
        if (!empty($request['goo_goods_code'])) {
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_goods_code', $request['goo_goods_code'])
                ->select('goo_id')
                ->first();
            if ($find_goo) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'商品编号已存在'];
            }
        }

        // 2 新增一个商品数据 
        $goo_add_data['goo_cid'] = $user_info->adm_cid;
        $goo_add_data['goo_shop_id'] = $user_info->adm_shop_id;
        $goo_add_data['goo_superior_shop_id'] = $shop_id;
        $goo_add_data['goo_class'] = 1;//类型：1自营商品2系统商品
        $goo_add_data['goo_state'] = 1;//状态1启用2停用
        $goo_add_data['goo_name'] = $request['goo_name'];  //商品名称
        $goo_add_data['goo_type'] = 5;   //1正常商品2赠品商品3活动商品4旧货商品5无库存商品6易损件
        if (!empty($request['goo_goods_code'])) {
            $goo_add_data['goo_goods_code'] = $request['goo_goods_code'];   //商品编号
        }
        if (!empty($request['goo_goods_encode'])) {
            $goo_add_data['goo_goods_encode'] = $request['goo_goods_encode'];   //检索编码
        }
        $goo_add_data['goo_price'] = $request['goo_price'] * 100;   //商品零售价格
        $goo_add_data['goo_wholesale_price'] = $request['goo_price'] * 100;   //商品批发价格
        $goo_add_data['goo_system_code'] = str_pad($user_info->adm_cid, '4', '0', STR_PAD_RIGHT) . str_pad($user_info->adm_shop_id, '5', '0', STR_PAD_RIGHT) . rand(10, 99) . rand(100000000, 999999999); //系统编码
        $goo_add_data['goo_bra_id'] = $request['goo_bra_id'];
        $goo_add_data['goo_bra_name'] = $request['goo_bra_name'];
        $goo_add_data['goo_guarantee'] = $request['goo_guarantee'];
        if (!empty($request['goo_attribute'])) {
            $goo_add_data['goo_attribute'] = $request['goo_attribute'];
        }
        // 新增商品
        $goo_id =  DB::table('goods')->insertGetId($goo_add_data);

        // 5.商品所属品牌数量更改
        if ($request['goo_bra_id']) {
            // 查询关联表是否有数据
            $find_brco_id = DB::table('brand_correlation')
                ->where('brco_bra_id', $request['goo_bra_id'])
                ->where('brco_shop_id', $user_info->adm_shop_id)
                ->value('brco_id');
            if ($find_brco_id) {
                // 有数据增加数量
                $res_brand = DB::table('brand_correlation')
                    ->where('brco_bra_id', $request['goo_bra_id'])
                    ->where('brco_shop_id', $user_info->adm_shop_id)
                    ->increment('brco_goods_number', 1);
            } else {
                // 没有数据，新增数据
                $add_brco_data['brco_shop_id'] = $user_info->adm_shop_id;
                $add_brco_data['brco_bra_id'] = $request['goo_bra_id'];
                $add_brco_data['brco_goods_number'] = 1;
                $add_brco_data['brco_update_time'] = date('Y-m-d H:i:s');
                $res_brand = DB::table('brand_correlation')->insert($add_brco_data);
            }
        } else {
            $res_brand = true;
        }

        if ($goo_id && $res_brand) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'新增商品：成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'新增商品：失败2'];
        }
    }

    // 编辑
    public static function edit(
        $user_info,
        $request
    ){
        if ($request['type'] == 1) {
            // 查询商品数据
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_id', $request['goo_id'])
                ->select('goo_id', 'goo_name', 'goo_bra_name', 'goo_bra_id', 'goo_goods_encode', 'goo_wholesale_price as goo_price', 'goo_guarantee', 'goo_attribute','goo_class')
                ->first();
            if ($find_goo) {
                return ['code'=>200, 'msg'=>'succsss', 'data'=>$find_goo];
            }
        }

        // 1. 判断商品名称是否存在
        $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_id', '!=', $request['goo_id'])
                ->where('goo_name', $request['goo_name'])
                ->select('goo_id')
                ->first();
        if ($find_goo) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'商品名称已存在'];
        }

        // 判断商品编号是否存在
        if (!empty($request['goo_goods_code'])) {
            $find_goo = DB::table('goods')
                ->where('goo_delete', 1)
                ->where(function ($query) use ($user_info) {
                    $query->where('goo_shop_id', 0)
                        ->orwhere('goo_shop_id', $user_info->adm_shop_id);
                })
                ->where('goo_id', '!=', $request['goo_id'])
                ->where('goo_goods_code', $request['goo_goods_code'])
                ->select('goo_id')
                ->first();
            if ($find_goo) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'商品编号已存在'];
            }
        }
        // 查询出商品未编辑前的商品品类/商品所属品牌数量更改
        $goods_info = DB::table('goods')
            ->where('goo_id', $request['goo_id'])
            ->select('goo_bra_id', 'goo_brse_id', 'goo_cate_id')
            ->first();

        // 2 编辑一个商品数据
        $goo_edit_data['goo_name'] = $request['goo_name'];  //商品名称
        if (!empty($request['goo_goods_code'])) {
            $goo_edit_data['goo_goods_code'] = $request['goo_goods_code'];   //商品编号
        }
        if (!empty($request['goo_goods_encode'])) {
            $goo_edit_data['goo_goods_encode'] = $request['goo_goods_encode'];   //检索编码
        }
        $goo_edit_data['goo_price'] = $request['goo_price'] * 100;   //商品零售价格
        $goo_edit_data['goo_wholesale_price'] = $request['goo_price'] * 100;   //商品批发价格
        $goo_edit_data['goo_bra_id'] = $request['goo_bra_id'];
        $goo_edit_data['goo_bra_name'] = $request['goo_bra_name'];
        $goo_edit_data['goo_guarantee'] = $request['goo_guarantee'];
        $goo_edit_data['goo_update_time'] = date('Y-m-d H:i:s');
        if (!empty($request['goo_attribute'])) {
            $goo_edit_data['goo_attribute'] = $request['goo_attribute'];
        }

        // 编辑商品
        $goo_res =  DB::table('goods')
            ->where('goo_id', $request['goo_id'])
            ->update($goo_edit_data);

        // 5.判断是否更改商品所属品牌
        if ($request['goo_bra_id'] != $goods_info->goo_bra_id) {
            $num = 1;
            // 更改商品所属品牌
            $find_bc = DB::table('brand_correlation')
                ->where('brco_bra_id', $request['goo_bra_id'])
                ->where('brco_shop_id', $user_info->adm_shop_id)
                ->select('brco_id')
                ->first();
            if ($find_bc) {
                if ($request['goo_bra_id']) {
                    $save_bra_add = DB::table('brand_correlation')
                        ->where('brco_bra_id', $request['goo_bra_id'])
                        ->where('brco_shop_id', $user_info->adm_shop_id)
                        ->increment('brco_goods_number', $num); //商品所属品牌+1
                } else {
                    $save_bra_add = true;
                }
            } else {
                return ['code'=>500, 'msg'=>'error', 'data'=>'请先创建品牌'];
            }

            if ($goods_info->goo_bra_id) {
                $save_bra_subtract = DB::table('brand_correlation')
                    ->where('brco_bra_id', $goods_info->goo_bra_id)
                    ->where('brco_shop_id', $user_info->adm_shop_id)
                    ->decrement('brco_goods_number', $num); //商品所属品牌-1
            } else {
                $save_bra_subtract = true;
            }
            if ($save_bra_add && $save_bra_subtract) {
                $save_bra = true;
            } else {
                $save_bra = false;
            }
        } else {
            $save_bra = true;
        }

        if ($goo_res && $save_bra) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'编辑商品：成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'编辑商品：失败'];
        }
    }
}
