<?php
namespace App\Http\Models\Services;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Api\ReceivableCredit;

class Prints extends Model
{
    public static function print(
        $user_info,
        $request
    ) {
        // 查询门店打印模板
        $shpt_template_set = DB::table('shop_print_template')
            ->where('shpt_shop_id', $user_info->adm_shop_id)
            ->where('shpt_print_type', $request['shpt_print_type'])
            ->where('shpt_delete', 1)
            ->value('shpt_template_set');

        if (empty($shpt_template_set)) { //门店没有模板查询系统打印模板
            $shpt_template_set = DB::table('shop_print_template')
                ->where('shpt_shop_id', 0)
                ->where('shpt_print_type', $request['shpt_print_type'])
                ->where('shpt_delete', 1)
                ->value('shpt_template_set');
        }
        if (empty($shpt_template_set)) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'没有打印模板'];
        }
        if ($request['shpt_print_type'] == 1) { //发货单
            $dego_client_type = DB::table('dispatch_bill')
                ->where('dego_id', $request['print_id'])
                ->value('dego_client_type'); //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
            if ($dego_client_type == 1) { //会员零售
                // 查询打印自定义的组件所需字段
                $print_data = DB::table('dispatch_bill as db')
                    ->leftJoin('member as m', 'm.mem_id', '=', 'db.dego_client_id')
                    ->leftJoin('warehouse as w', 'w.ware_id', '=', 'db.dego_out_ware_id')
                    ->leftJoin('admin as a', 'a.adm_id', '=', 'db.dego_create_adm_id')
                    ->leftJoin('shop as s', 's.shop_id', '=', 'db.dego_service_shop_id')
                    ->where('dego_id', $request['print_id'])
                    ->select('dego_number', 'dego_count', 'mem_name as chun_unit_name', 'mem_phone as chun_phone', 'mem_address as chun_address', 'adm_name', 'shop_store_name', 'ware_freight_space', 'dego_order_type', 'dego_wor_id', 'dego_out_ware_id')
                    ->first();
            } elseif ($dego_client_type == 2) { //客户单位
                // 查询打印自定义的组件所需字段
                $print_data = DB::table('dispatch_bill as db')
                    ->leftJoin('channel_unit as cu', 'cu.chun_id', '=', 'db.dego_client_id')
                    ->leftJoin('warehouse as w', 'w.ware_id', '=', 'db.dego_out_ware_id')
                    ->leftJoin('admin as a', 'a.adm_id', '=', 'db.dego_create_adm_id')
                    ->leftJoin('shop as s', 's.shop_id', '=', 'db.dego_service_shop_id')
                    ->where('dego_id', $request['print_id'])
                    ->select('dego_number', 'dego_count', 'chun_unit_name', 'chun_phone', 'chun_address', 'adm_name', 'shop_store_name', 'ware_freight_space', 'dego_order_type', 'dego_wor_id', 'dego_out_ware_id')
                    ->first();
            } elseif ($dego_client_type == 3) { //3速电派单
                // 查询打印自定义的组件所需字段
                $print_data = DB::table('dispatch_bill as db')
                    ->where('dego_id', $request['print_id'])
                    ->select('dego_number', 'dego_count', 'dego_order_type', 'dego_wor_id', 'dego_out_ware_id', 'dego_create_adm_id', 'dego_service_shop_id')
                    ->first();
                if ($print_data->dego_order_type == 1) { //类型：1.订单发货
                    $order_client = DB::table('order as ord')
                        ->leftjoin('order_client as orcl', 'orcl.orcl_ord_id', '=', 'ord.ord_id')
                        ->where('orcl_ord_id', $print_data->dego_wor_id)
                        ->select('orcl_channel_unit', 'orcl_name', 'orcl_phone', 'orcl_province', 'orcl_city', 'orcl_county', 'orcl_address')
                        ->first();
                    $print_data->chun_unit_name = config('apisystem.sd_chan_info')['name'];
                    $print_data->chun_phone = $order_client->orcl_phone;
                    $print_data->chun_address = $order_client->orcl_province.$order_client->orcl_city.$order_client->orcl_county.$order_client->orcl_address;
                } elseif ($print_data->dego_order_type == 2) { //类型：2.工单发货
                    $order_client = DB::table('work_order as wor')
                        ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                        ->where('wocl_wor_id', $print_data->dego_wor_id)
                        ->select('wocl_channel_unit', 'wocl_name', 'wocl_phone', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_address')
                        ->first();
                    $print_data->chun_unit_name = config('apisystem.sd_chan_info')['name'];
                    $print_data->chun_phone = $order_client->wocl_phone;
                    $print_data->chun_address = $order_client->wocl_province.$order_client->wocl_city.$order_client->wocl_county.$order_client->wocl_address;
                }
                $print_data->adm_name = DB::table('admin')
                    ->where('adm_id', $print_data->dego_create_adm_id)
                    ->value('adm_name');
                unset($print_data->dego_create_adm_id);
                // 门店名称
                $print_data->shop_store_name = DB::table('shop')
                    ->where('shop_id', $print_data->dego_service_shop_id)
                    ->value('shop_store_name');
                unset($print_data->dego_create_adm_id);
                // 仓库编码
                $print_data->ware_freight_space = DB::table('warehouse')
                    ->where('ware_id', $print_data->dego_out_ware_id)
                    ->value('ware_freight_space');
            }
            if (empty($print_data)) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'暂无数据'];
            }
            // 查询打印模板商品明细表格所需数据
            $goo_datas = DB::table('dispatch_goods as dg')
                ->leftJoin('goods as g', 'g.goo_id', '=', 'dg.digo_goo_id')
                ->where('digo_dego_id', $request['print_id'])
                ->select('digo_goo_id', 'digo_goo_name', 'digo_goo_goods_encode', 'digo_goo_price', 'digo_goo_quantity', 'goo_unit', 'digo_wago_id', 'digo_goo_inventory')
                ->get()->toArray();
            $goo_data = array_column($goo_datas, null, 'digo_wago_id');

            if ($print_data->dego_order_type == 1) { //类型：1.订单发货
                $ord_id = $print_data->dego_wor_id;
            } elseif ($print_data->dego_order_type == 2) { //类型：2.工单发货
                $ord_id = DB::table('work_order')
                    ->where('wor_id', $print_data->dego_wor_id)
                    ->where('wor_shop_id', $user_info->adm_shop_id)
                    ->value('wor_order_id');
            }
            $ware_name = DB::table('warehouse')
                ->where('ware_id', $print_data->dego_out_ware_id)
                ->value('ware_name');
            // 查询仓位商品库存锁定 仓位表
            $wafr_data = DB::table('warehouse_freight_goods_lock as wf')
                ->leftJoin('warehouse_freight as w', 'w.wafr_id', '=', 'wf.wfgl_wafr_id')
                ->where('wfgl_original_id', $ord_id)
                ->where('wfgl_type', 1) //关联类型：1订单2发货单3调拨单
                ->where('wfgl_shop_id', $user_info->adm_shop_id)
                ->select('wafr_name', 'wfgl_wago_id', 'wfgl_lock_quantity', 'wfgl_lock_type')
                ->get()->toArray();
            $new_goo_data = [];
            $sort_num = 1;
            if ($wafr_data) {
                foreach ($wafr_data as $key => $value) {
                    if (isset($goo_data[$value->wfgl_wago_id])) {
                        $temp_goo_data['digo_goo_id'] = $goo_data[$value->wfgl_wago_id]->digo_goo_id; //商品id
                        $temp_goo_data['digo_goo_name'] = $goo_data[$value->wfgl_wago_id]->digo_goo_name; //商品名称
                        $temp_goo_data['digo_goo_goods_encode'] = $goo_data[$value->wfgl_wago_id]->digo_goo_goods_encode; //商品编码
                        $temp_goo_data['goo_unit'] = $goo_data[$value->wfgl_wago_id]->goo_unit ?: '--'; //单位
                        if (empty($value->wafr_name)) {
                            $temp_goo_data['digo_wafr_id'] = ''; //仓库名称
                        } else {
                            $temp_goo_data['digo_wafr_id'] = $value->wafr_name; //仓位名称
                        }
                        if ($value->wfgl_lock_type == 1) {
                            $value->wfgl_lock_type = '良品';
                        } elseif ($value->wfgl_lock_type == 2) {
                            $value->wfgl_lock_type = '优先';
                        }
                        $temp_goo_data['digo_goo_inventory'] = $value->wfgl_lock_type;
                        $temp_goo_data['digo_goo_quantity'] = $value->wfgl_lock_quantity;
                        $temp_goo_data['ware_freight_space'] = $print_data->ware_freight_space;
                        $temp_goo_data['NO'] = $sort_num;
                        $new_goo_data[] = $temp_goo_data;
                        unset($temp_goo_data);
                        $sort_num++;
                    }
                }
            } else {
                foreach ($goo_datas as $key => $value) {
                    $temp_goo_data['digo_goo_id'] = $value->digo_goo_id; //商品id
                    $temp_goo_data['digo_goo_name'] = $value->digo_goo_name; //商品名称
                    $temp_goo_data['digo_goo_goods_encode'] = $value->digo_goo_goods_encode; //商品编码
                    $temp_goo_data['goo_unit'] = $value->goo_unit ?: '--'; //单位
                    // $temp_goo_data['digo_wafr_id'] = '';//仓位名称
                    if (empty($value->wafr_name)) {
                        $temp_goo_data['digo_wafr_id'] = $ware_name; //仓库名称
                    } else {
                        $temp_goo_data['digo_wafr_id'] = $value->wafr_name; //仓位名称
                    }
                    if ($value->digo_goo_inventory == 1) {
                        $value->digo_goo_inventory = '良品';
                    } elseif ($value->digo_goo_inventory == 2) {
                        $value->digo_goo_inventory = '优先';
                    }
                    $temp_goo_data['digo_goo_inventory'] = $value->digo_goo_inventory;
                    $temp_goo_data['digo_goo_quantity'] = $value->digo_goo_quantity;
                    $temp_goo_data['ware_freight_space'] = $print_data->ware_freight_space;
                    $temp_goo_data['NO'] = $sort_num;
                    $new_goo_data[] = $temp_goo_data;
                    unset($temp_goo_data);
                    $sort_num++;
                }
            }

            $shpt_template_set = json_decode($shpt_template_set, true);
            $print_data = json_decode(json_encode($print_data, true), true);
            $goo_data = json_decode(json_encode($goo_data, true), true);

            $return_data[0] = $print_data;
            $return_data[0]['shpt_print_type_name'] = config('apisystem.PRINT_TYPE')[$request['shpt_print_type']]; //打印模板名称类型
            foreach ($new_goo_data as $goo_key => $goo_value) { //遍历商品明细
                $return_data[0]['details'][$goo_key] = $goo_value;
            }
        } elseif ($request['shpt_print_type'] == 2) { //旧货回收
            // 获取回收单数据
            $find_junk = DB::table('junk_recycle as jur')
                ->leftJoin('admin as adm', 'adm.adm_id', '=', 'jur.jur_create_adm_id')
                ->leftJoin('print_number as prnu', 'prnu.prnu_original_id', 'jur.jur_id')
                ->where('jur_id', $request['jur_id'])
                ->select('adm_name as jur_create_adm_name', 'jur_number', 'jur_date', 'jur_source', 'jur_amount', 'jur_price', 'jur_wor_id', 'jur_create_adm_id', 'jur_ware_id', 'jur_remark', 'jur_state', 'jur_is_mobile', 'jur_wor_number', 'jur_ord_order_number', 'jur_service_adm_id', 'prnu_print_num')
                ->first();
            if (empty($find_junk)) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'当前回收单不存在'];
            }
            // 查询出客户单位名称 客户姓名 联系电话
            $client = DB::table('junk_client')
                ->where('jucl_jur_id', $request['jur_id'])
                ->select('jucl_channel_unit', 'jucl_name', 'jucl_phone', 'jucl_client_id')
                ->first();
            // 查询客户单位名称
            $find_junk->jucl_channel_unit = DB::table('channel_unit')
                ->where('chun_id', $client->jucl_client_id)
                ->value('chun_unit_name');
            unset($find_junk->jucl_client_id);
            $find_junk->jucl_name = $client->jucl_name;
            $find_junk->jucl_phone = $client->jucl_phone;
            // 查询出仓库编码
            $find_junk->ware_freight_space = DB::table('warehouse')
                ->where('ware_id', $find_junk->jur_ware_id)
                ->value('ware_freight_space');

            // 获取商品数据
            $find_goods = DB::table('junk_goods as jugo')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'jugo.jugo_goo_id')
                ->where('jugo_jur_id', $request['jur_id'])
                ->select('jugo_goo_id as goo_id', 'jugo_goo_name as goo_name', 'jugo_goo_goods_encode as goo_goods_encode', 'jugo_goo_price as goo_price', 'jugo_sell_number as goo_amount', 'jugo_recycle_number as goo_recycle_amount', 'jugo_remark', 'goo_bra_name', 'goo_brse_id', 'goo_class')
                ->get()->toArray();
            // 查询系列数据
            $goo_brse_id = array_column($find_goods, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            foreach ($find_goods as $key => $value) {
                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($value->goo_brse_id)) {
                        if ($value->goo_class == 2) {
                            $find_goods[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $find_goods[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $find_goods[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_goods[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                        }
                    }
                }
                unset($find_goods[$key]->goo_class);
                unset($find_goods[$key]->goo_brse_id);
            }

            // 查询业务负责人
            $find_junk->chun_adm_name = DB::table('channel_unit')
                ->where('chun_id', $client->jucl_client_id)
                ->value('chun_adm_id');
            // 获取采购商(仓库负责人)/创建人
            $adm_id = [$find_junk->chun_adm_name];
            $adm_id = array_filter($adm_id);
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->select('adm_id', 'adm_name', 'adm_phone')
                ->get()->toArray();
            $adm_name = array_column($find_admin, null, 'adm_id');
            if (isset($adm_name[$find_junk->chun_adm_name]->adm_phone)) {
                $find_junk->chun_adm_phone = $find_junk->chun_adm_name ? $adm_name[$find_junk->chun_adm_name]->adm_phone : ''; //业务员联系电话
                $find_junk->chun_adm_name = $find_junk->chun_adm_name ? $adm_name[$find_junk->chun_adm_name]->adm_name : ''; //业务员
            } else {
                $find_junk->chun_adm_phone = ''; //业务员联系电话
                $find_junk->chun_adm_name = '';
            }

            $data['junk_data'] = $find_junk;
            $data['goods_data'] = $find_goods;

            $shpt_template_set = json_decode($shpt_template_set, true);
            $find_junk = json_decode(json_encode($find_junk, true), true);
            $find_goods = json_decode(json_encode($find_goods, true), true);

            $return_data[0] = $find_junk;
            $return_data[0]['shpt_print_type_name'] = config('apisystem.PRINT_TYPE')[$request['shpt_print_type']]; //打印模板名称类型
            $num = 1;
            foreach ($find_goods as $goo_key => $goo_value) { //遍历商品明细
                $return_data[0]['details'][$goo_key] = $goo_value;
                $return_data[0]['details'][$goo_key]['NO'] = $num;
                $num++;
            }
        } elseif ($request['shpt_print_type'] == 3) { //旧货回收标签
            // 获取打印数据
            $find_junk = DB::table('junk_recycle as a')
                ->leftjoin('admin as b', 'b.adm_id', '=', 'a.jur_service_adm_id')
                ->leftjoin('warehouse as c', 'c.ware_id', '=', 'a.jur_ware_id')
                ->leftjoin('junk_client as d', 'd.jucl_jur_id', '=', 'a.jur_id')
                ->where('jur_id', $request['jur_id'])
                ->select('jur_wor_number', 'jur_ord_order_number', 'jur_wor_id', 'jucl_channel_unit', 'jucl_car_num', 'jur_remark', 'ware_freight_space', 'adm_name', 'jucl_client_id')
                ->first();
            if (empty($find_junk)) {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'当前回收单不存在']);
            }
            $find_junk->jucl_channel_unit = DB::table('channel_unit')
                ->where('chun_id', $find_junk->jucl_client_id)
                ->value('chun_unit_name');
            unset($find_junk->jucl_client_id);
            // 获取工单商品的最后一个数据
            $find_goods = DB::table('work_good')
                ->where('wogo_wor_id', $find_junk->jur_wor_id)
                ->where('wogo_state', 1)
                ->select('wogo_goo_name', 'wogo_goo_goods_encode')
                ->orderBy('wogo_id', 'desc')
                ->first();

            // 查询旧货回收商品的数量、属性
            $junk_goods = DB::table('junk_goods as jugo')
                ->leftJoin('goods as goo', 'goo.goo_id', '=', 'jugo.jugo_goo_id')
                ->where('jugo_jur_id', $request['jur_id'])
                ->select('goo_name', 'goo_goods_encode', 'goo_attribute', 'jugo_recycle_number', 'jugo_print_state', 'jugo_id', 'goo_ampere_hour', 'goo_id', 'goo_class')
                ->get()->toArray();
            $junk_goods = json_decode(json_encode($junk_goods), true);

            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);

            $goo_id = array_column($junk_goods, 'goo_id');
            // 查询商品附属表信息
            $goaf_data = DB::table('goods_affiliate')
                ->where('goaf_shop_id', $user_info->adm_shop_id)
                ->whereIn('goaf_goo_id', $goo_id)
                ->pluck('goaf_another_name', 'goaf_goo_id')
                ->toArray();
            // 查询系统商品属性表信息
            $gosa_data = DB::table('goods_system_affiliate')
                ->where('gosa_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosa_goo_id', $goo_id)
                ->pluck('gosa_another_name', 'gosa_goo_id')
                ->toArray();
            foreach ($junk_goods as $key => $value) {
                if ($value['goo_class'] == 2 && isset($gosa_data[$value['goo_id']]) && !empty($gosa_data[$value['goo_id']])) {
                    $junk_goods[$key]['goo_name'] = $gosa_data[$value['goo_id']];
                }
                if (isset($goaf_data[$value['goo_id']]) && !empty($goaf_data[$value['goo_id']])) { // 商品别名
                    $junk_goods[$key]['goo_name'] = $goaf_data[$value['goo_id']];
                }
                $junk_goods[$key]['jugo_recycle_number'] = $value['jugo_recycle_number']; //旧货回收的数量
                $junk_goods[$key]['specification'] = $value['goo_ampere_hour'] . 'AH'; //安时数
            }
            $data['adm_name'] = pinyin1($find_junk->adm_name);
            $data['junk_data'] = $find_junk;
            $data['goods_data'] = $find_goods;
            $data['junk_goods'] = $junk_goods;

            $shpt_template_set = json_decode($shpt_template_set, true);
            $find_junk = json_decode(json_encode($find_junk, true), true);
            $find_goods = json_decode(json_encode($find_goods, true), true);

            $return_data[0] = $find_junk;
            $return_data[0]['shpt_print_type_name'] = config('apisystem.PRINT_TYPE')[$request['shpt_print_type']]; //打印模板名称类型
            $num = 1;
            foreach ($find_goods as $goo_key => $goo_value) { //遍历商品明细
                $return_data[0]['details'][$goo_key] = $goo_value;
                $return_data[0]['details'][$goo_key]['NO'] = $num;
                $num++;
            }
        } elseif ($request['shpt_print_type'] == 4) { //4订单-销售单
            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);
            // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
            $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
            $info = DB::table('order as ord')
                ->leftJoin('warehouse as ware', 'ord.ord_ware_id', '=', 'ware.ware_id')
                ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
                ->leftJoin('print_number as prnu', 'prnu.prnu_original_id', 'ord.ord_id')
                ->where('ord_id', $request['ord_id'])
                ->where('ord_cid', $user_info->adm_cid)
                ->where('ord_shop_id', $shop_id)
                ->select('ord_order_number', 'ord_create_time', 'ord_order_price', 'ord_wor_state', 'ord_wor_quantity', 'ord_actual_price', 'ord_payment_way', 'ord_goods_quantity', 'ord_type', 'ord_state', 'ord_orcl_id', 'ord_remark', 'ord_create_id', 'ord_service_type', 'ware_name', 'ware_leader_id', 'orcl_name', 'orcl_phone', 'orcl_address', 'orcl_channel_unit', 'orcl_car_num', 'ord_client_id', 'ware_freight_space', 'ord_collection_price', 'prnu_print_num', 'ord_service_sepr_id', 'orcl_province', 'orcl_city', 'orcl_county', 'ord_service_shop_id', 'orcl_rescue_service_price', 'orcl_rescue_collection_price', 'orcl_assign_price', 'orcl_plus_minus', 'ord_plus_minus', 'ord_service_adm_id', 'orcl_car_vehicle_type', 'ord_order_plus_minus', 'orcl_shipment_party', 'orcl_adm_id', 'orcl_client_id', 'orcl_order_type')
                ->first();
            if ($info->ord_type == 1) {
                $total_client_price = 0;
            } else {
                $total_client_price = ReceivableCredit::queryClientPrice( //查询客户的金额
                    $user_info,
                    1, //打印类型：1订单打印2工单打印
                    $info->ord_type, //客户类型
                    $info->ord_client_id, //客户id
                    $info->orcl_order_type, //单据类型：1系统工单2外派工单3速电派单4虚拟加盟店
                    $info->ord_service_shop_id //服务门店id，实体加盟店id/虚拟加盟店id
                );
            }
            $data['ord_actual_price'] = num_to_rmb($info->ord_actual_price / 100);
            // 查询服务门店名称
            $info->ord_service_shop_name = DB::table('shop')->where('shop_id', $info->ord_service_shop_id)->value('shop_store_name');
            $info->prnu_print_num = empty($info->prnu_print_num) ? 0 : $info->prnu_print_num;

            // 订单类型如果是和客户单位的话 追加客户等级
            if ($info->ord_type == 2) {
                $info->chin_level = DB::table('channel_info')
                    ->where('chin_chun_id', $info->ord_client_id)
                    ->value('chin_level');

                $chun_data = DB::table('channel_unit')
                    ->where('chun_id', $info->ord_client_id)
                    ->select('chun_adm_id', 'chun_province', 'chun_city', 'chun_county', 'chun_address', 'chun_name', 'chun_phone')
                    ->first();
                // $info->chun_adm_name = $chun_data->chun_adm_id;
                $info->chun_adm_name = $info->orcl_adm_id;
                $info->orcl_channel_unit = DB::table('channel_unit')
                    ->where('chun_id', $info->ord_client_id)
                    ->value('chun_unit_name');
            } elseif ($info->ord_type == 3) {
                $info->orcl_channel_unit = '速电快保';
                $info->chun_adm_name = "";
                $info->chin_level = "";
                $chun_data = [];
            } else {
                $info->chin_level = "";
                $info->chun_adm_name = "";
                $chun_data = [];
            }
            // 查询服务项目名称
            if ($info->ord_service_sepr_id != '0') {
                $sepr_data = DB::table('service_project')
                    ->where('sepr_id', $info->ord_service_sepr_id)
                    ->select('sepr_name', 'sepr_order_money')
                    ->first();
                $info->ord_service_sepr_name = $sepr_data->sepr_name;
                $info->sepr_order_money = $info->orcl_rescue_service_price;
            }

            // 获取采购商(仓库负责人)/创建人
            $adm_id = [
                $info->ord_create_id,
                $info->ware_leader_id,
                $info->chun_adm_name,
                $info->ord_service_adm_id,
            ];
            $adm_id = array_filter($adm_id);
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->select('adm_id', 'adm_name', 'adm_phone')
                ->get()->toArray();
            $adm_name = array_column($find_admin, null, 'adm_id');

            if ($info->ord_create_id != '0') {
                $info->create_name = $adm_name[$info->ord_create_id]->adm_name; //创建人
            }
            if ($info->ord_service_adm_id != '0') {
                $info->ord_service_adm_name = $adm_name[$info->ord_service_adm_id]->adm_name; //服务技师
            } else {
                $info->ord_service_adm_name = ''; //服务技师
            }

            $adm_ids = DB::table('admin')
                ->where('adm_id', $info->chun_adm_name)
                ->value('adm_id');
            if (empty($adm_ids)) {
                $info->ware_leader_name = ''; //仓库负责人
                $info->chun_adm_phone = ''; //业务员联系电话
                $info->chun_adm_name = ''; //业务员
            } else {
                $info->ware_leader_name = $info->ware_leader_id ? $adm_name[$info->ware_leader_id]->adm_name : ''; //仓库负责人
                $info->chun_adm_phone = $info->chun_adm_name ? $adm_name[$info->chun_adm_name]->adm_phone : ''; //业务员联系电话
                $info->chun_adm_name = $info->chun_adm_name ? $adm_name[$info->chun_adm_name]->adm_name : ''; //业务员
                // $info->ord_service_adm_name = $adm_name[$info->ord_service_adm_id]->adm_name;//技师
            }

            // 速电派单,门店没有接单时,客户信息隐藏
            if ($info->ord_wor_state == '7') {
                $info->orcl_name = substituteCharacter($info->orcl_name);
                $info->orcl_phone = substr_replace($info->orcl_phone, '****', 3, 8);
                $info->orcl_city = '***';
                $info->orcl_county = '***';
                $info->orcl_address = '***';
            }

            // 获取该订单下的商品信息
            $goods_data = DB::table('order_goods as orgo')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'orgo.orgo_goo_id')
                ->where('orgo_ord_id', $request['ord_id'])
                ->where('orgo_state', '!=', 2)
                ->select('orgo_goo_name', 'orgo_goo_goods_encode', 'orgo_goo_quantity', 'orgo_goo_price', 'orgo_is_recycle', 'orgo_can_assign_quantity', 'orgo_collection_price', 'orgo_state', 'orgo_recycle_price', 'orgo_recycle_quantity', 'orgo_tem_goo_name as tem_goo_name', 'orgo_assign_price', 'orgo_ware_id', 'goo_unit', 'goo_class', 'goo_bra_name', 'goo_brse_id', 'orgo_wafr_id', 'orgo_id', 'goo_id')
                ->get()->toArray();
            $goods_data = json_decode(json_encode($goods_data), true);
            $goods_datas = array_column($goods_data, null, 'orgo_id');
            // 查询系列数据
            $goo_brse_id = array_column($goods_data, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            // 查询仓位数据
            $orgo_wafr_id = array_column($goods_data, 'orgo_wafr_id');
            $wafr_data = DB::table('warehouse_freight')
                ->whereIn('wafr_id', $orgo_wafr_id)
                ->pluck('wafr_name', 'wafr_id')
                ->toArray();
            // 查询订单商品仓位数据
            $orgo_id = array_column($goods_data, 'orgo_id');
            $find_orgf_data = DB::table('order_goods_freight as orgf')
                ->leftjoin('warehouse_freight as wafr', 'wafr.wafr_id', 'orgf.orgf_wafr_id')
                ->where('orgf_shop_id', $user_info->adm_shop_id)
                ->where('orgf_ord_id', $request['ord_id'])
                ->whereIn('orgf_orgo_id', $orgo_id)
                ->where('orgf_order_number', $info->ord_order_number)
                ->where('orgf_delete', 1)
                ->select('orgf_id', 'orgf_ord_id', 'orgf_order_number', 'orgf_orgo_id', 'orgf_wago_id', 'orgf_ware_id', 'orgf_wafr_id', 'orgf_goo_id', 'orgf_goo_quantity', 'orgf_goo_inventory', 'wafr_name')
                ->get()->toArray();
            $wor_id = DB::table('work_order')
                ->where('wor_order_id', $request['ord_id'])
                ->where('wor_delete', 1)
                ->where('wor_state', '!=', 11)
                ->select('wor_id', 'wor_number')
                ->orderBy('wor_id', 'desc')
                ->first();
            $find_rego_data = DB::table('recede_recycle')
                ->where(function ($query) use ($wor_id, $info) {
                    if ($wor_id) {
                        $query->where('rec_ord_order_number', $info->ord_order_number)
                            ->orwhere('rec_ord_order_number', $wor_id->wor_number);
                    } else {
                        $query->where('rec_ord_order_number', $info->ord_order_number);
                    }
                })
                ->where(function ($query) use ($wor_id, $request) {
                    if ($wor_id) {
                        $query->where('rec_ord_id', $request['ord_id'])
                            ->orwhere('rec_ord_id', $wor_id->wor_id);
                    } else {
                        $query->where('rec_ord_id', $request['ord_id']);
                    }
                })
                ->select('rec_id', 'rec_amount', 'rec_source_type')
                ->orderBy('rec_id', 'desc')
                ->first();
            if (!empty($find_rego_data)) {
                $find_rego_data_res = false;
            } else {
                $find_rego_data_res = true;
            }
            $new_new_goo_datas = [];
            if ($find_orgf_data && $find_rego_data_res) {
                $new_find_orgf_data = [];
                foreach ($find_orgf_data as $key => $value) {
                    $orgf_goods_data = $goods_datas[$value->orgf_orgo_id];
                    if (isset($orgf_goods_data)) {
                        // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                            if (!empty($orgf_goods_data['goo_brse_id'])) {
                                if ($orgf_goods_data['goo_class'] == 2) {
                                    $orgf_goods_data['orgo_goo_name'] = $brse_data[$orgf_goods_data['goo_brse_id']] . ' ' . $orgf_goods_data['orgo_goo_name'];
                                } else {
                                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                        $orgf_goods_data['orgo_goo_name'] = $brse_data[$orgf_goods_data['goo_brse_id']] . ' ' . $orgf_goods_data['orgo_goo_name'];
                                    }
                                }
                            }
                        }
                        // 显示品牌名称
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                            if ($orgf_goods_data['goo_class'] == 2) {
                                $orgf_goods_data['orgo_goo_name'] = $orgf_goods_data['goo_bra_name'] . ' ' .  $orgf_goods_data['orgo_goo_name'];
                            } else {
                                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $orgf_goods_data['orgo_goo_name'] = $orgf_goods_data['goo_bra_name'] . ' ' .  $orgf_goods_data['orgo_goo_name'];
                                }
                            }
                        }
                        $new_find_orgf_data[] = $orgf_goods_data['goo_id'];
                        $new_goo_data['orgo_goo_name'] = $orgf_goods_data['orgo_goo_name']; //商品名称
                        $new_goo_data['orgo_goo_goods_encode'] = $orgf_goods_data['orgo_goo_goods_encode']; //检索编码
                        $new_goo_data['orgo_goo_quantity'] = $value->orgf_goo_quantity; //商品数量
                        $new_goo_data['orgo_goo_price'] = $orgf_goods_data['orgo_goo_price']; //商品售价（单位：分）
                        $new_goo_data['orgo_is_recycle'] = $orgf_goods_data['orgo_is_recycle']; //回收状态：1回收2不回收
                        $new_goo_data['orgo_can_assign_quantity'] = $orgf_goods_data['orgo_can_assign_quantity']; //剩余可以派工单的商品数量
                        $new_goo_data['orgo_collection_price'] = $orgf_goods_data['orgo_collection_price']; //代收金额（单位：分）
                        $new_goo_data['orgo_state'] = $orgf_goods_data['orgo_state']; //商品状态1.正常 2.删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
                        $new_goo_data['orgo_recycle_price'] = $orgf_goods_data['orgo_recycle_price']; //回收金额（单位：分）
                        $new_goo_data['orgo_recycle_quantity'] = $orgf_goods_data['orgo_recycle_quantity']; //商品回收数量
                        $new_goo_data['tem_goo_name'] = $orgf_goods_data['tem_goo_name']; //临时商品名称
                        $new_goo_data['orgo_assign_price'] = $orgf_goods_data['orgo_assign_price']; //派单金额
                        $new_goo_data['goo_unit'] = $orgf_goods_data['goo_unit']; //单位
                        $new_goo_data['orgo_wafr_name'] = $value->wafr_name; //仓位
                        $new_goo_data['orgo_freight_space'] = DB::table('warehouse')
                            ->where('ware_id', $orgf_goods_data['orgo_ware_id'])
                            ->value('ware_freight_space'); //仓库编码
                        $new_new_goo_datas[] = $new_goo_data;
                        unset($new_goo_data);
                    }
                }
            } else {
                foreach ($goods_data as $key => $value) {
                    // 查询仓库简称
                    $goods_data[$key]['orgo_freight_space'] = DB::table('warehouse')
                        ->where('ware_id', $value['orgo_ware_id'])
                        ->value('ware_freight_space');
                    $goods_data[$key]['unit'] = $value['goo_unit'];
                    // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                        if (!empty($value['goo_brse_id'])) {
                            if ($value['goo_class'] == 2) {
                                $goods_data[$key]['orgo_goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['orgo_goo_name'];
                            } else {
                                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $goods_data[$key]['orgo_goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['orgo_goo_name'];
                                }
                            }
                        }
                    }

                    // 显示品牌名称
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                        if ($value['goo_class'] == 2) {
                            $goods_data[$key]['orgo_goo_name'] = $value['goo_bra_name'] . ' ' .  $goods_data[$key]['orgo_goo_name'];
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $goods_data[$key]['orgo_goo_name'] = $value['goo_bra_name'] . ' ' .  $goods_data[$key]['orgo_goo_name'];
                            }
                        }
                    }
                    // 判断商品是否是从仓位出库
                    if (!empty($value['orgo_wafr_id'])) {
                        // 仓位出库显示商品所在仓位
                        $goods_data[$key]['orgo_wafr_name'] = $wafr_data[$value['orgo_wafr_id']];
                    } else {
                        $goods_data[$key]['orgo_wafr_name'] = '';
                    }
                    unset($goods_data[$key]['orgo_ware_id']);
                    unset($goods_data[$key]['goo_class']);
                    unset($goods_data[$key]['goo_brse_id']);
                    unset($goods_data[$key]['orgo_wafr_id']);
                }
                $new_new_goo_datas = $goods_data;
            }

            // 获取打印缓存数据
            $cache_data = DB::table('print_cache')
                ->where('prca_create_adm_id', $user_info->adm_id) //创建人id
                ->where('prca_type', 1) //类型1.订单 2.工单
                ->select('prca_com_name', 'prca_serve_provider', 'prca_serve_order')
                ->first();
            if (empty($cache_data)) {
                $cache_data['prca_com_name'] = '';
                $cache_data['prca_serve_provider'] = '';
                $cache_data['prca_serve_order'] = '';
            }
            $info = json_decode(json_encode($info, true), true);
            $chun_data = json_decode(json_encode($chun_data, true), true);
            $cache_data = json_decode(json_encode($cache_data), true);
            $data = array_merge($info, $cache_data, $chun_data);
            $data['total_client_price'] = $total_client_price;

            $shpt_template_set = json_decode($shpt_template_set, true);
            $data = json_decode(json_encode($data, true), true);
            $new_new_goo_datas = json_decode(json_encode($new_new_goo_datas, true), true);

            $return_data[0] = $data;
            $return_data[0]['shpt_print_type_name'] = config('apisystem.PRINT_TYPE')[$request['shpt_print_type']]; //打印模板名称类型
            $num = 1;
            foreach ($new_new_goo_datas as $goo_key => $goo_value) { //遍历商品明细
                $return_data[0]['details'][$goo_key] = $goo_value;
                $return_data[0]['details'][$goo_key]['NO'] = $num;
                $num++;
            }
        } elseif ($request['shpt_print_type'] == 8) { //工单-销售单
            // 工单数据
            $work_data = DB::table('work_order as a')
                ->leftJoin('work_client as b', 'b.wocl_wor_id', '=', 'a.wor_id')
                ->leftJoin('warehouse as c', 'c.ware_id', '=', 'a.wor_ware_id')
                ->leftJoin('order as d', 'd.ord_id', '=', 'a.wor_order_id')
                ->leftJoin('print_number as prnu', 'prnu.prnu_original_id', '=', 'a.wor_id')
                ->where('wor_id', $request['wor_id'])
                ->select('wor_id', 'wor_number', 'wor_service_sepr_id', 'wor_service_adm_id', 'wor_code', 'wor_img', 'wor_create_id', 'wor_service_type', 'wor_service_state', 'wor_state', 'wor_type', 'wor_goo_amount', 'wor_remark', 'wor_pass', 'wor_create_time', 'wocl_channel_unit', 'wocl_name', 'wocl_phone', 'wocl_car_num', 'wocl_address', 'ware_name', 'wor_shop_id', 'wor_service_shop_id', 'ord_payment_way', 'ord_state', 'ord_client_id', 'ord_type', 'wor_actual_price', 'wor_collection_price', 'prnu_print_num', 'ware_freight_space', 'wocl_province', 'wocl_city', 'wocl_county', 'wocl_rescue_service_price', 'wocl_rescue_collection_price', 'wocl_assign_price', 'wocl_plus_minus', 'wor_plus_minus', 'wocl_car_vehicle_type', 'wocl_wor_type', 'wor_order_id', 'wor_order_number')
                ->first();

            $data['wor_actual_prices'] = num_to_rmb($work_data->wor_actual_price / 100);
            $work_data->prnu_print_num = empty($work_data->prnu_print_num) ? 0 : $work_data->prnu_print_num;

            // 订单类型如果是客户单位的话 追加客户等级
            if ($work_data->ord_type == 2) { //客户单位
                $work_data->chin_level = DB::table('channel_info')
                    ->where('chin_chun_id', $work_data->ord_client_id)
                    ->value('chin_level');
                $chun_data = DB::table('channel_unit')
                    ->where('chun_id', $work_data->ord_client_id)
                    ->select('chun_adm_id', 'chun_province', 'chun_city', 'chun_county', 'chun_address', 'chun_name', 'chun_phone', 'chun_unit_name')
                    ->first();
                $work_data->chun_adm_id = $chun_data->chun_adm_id;
                // 查询客户单位名称
                $work_data->wocl_channel_unit = $chun_data->chun_unit_name;
            } elseif ($work_data->ord_type == 3) { //速电派单
                $work_data->wocl_channel_unit = '速电快保';
                $work_data->chin_level = "";
                $work_data->chun_adm_id = "";
                $chun_data = [];
            } else {
                $work_data->chin_level = "";
                $work_data->chun_adm_id = "";
                $chun_data = [];
            }

            // 获取采购商(仓库负责人)/创建人
            $adm_id = [
                $work_data->wor_create_id,
                $work_data->wor_service_adm_id,
                $work_data->chun_adm_id
            ];
            $find_admin = DB::table('admin')->whereIn('adm_id', $adm_id)->get(['adm_id', 'adm_name', 'adm_phone']);
            foreach ($find_admin as $key => $value) {
                if ($work_data->wor_create_id == $value->adm_id) {
                    $work_data->wor_create_name = $value->adm_name;
                }
                if ($work_data->wor_service_adm_id == $value->adm_id) {
                    $work_data->wor_service_adm_name = $value->adm_name;
                }
                if ($work_data->chun_adm_id == $value->adm_id) {
                    $work_data->chun_adm_name = $value->adm_name;
                    $work_data->chun_adm_phone = $value->adm_phone;
                }
            }
            // 查询服务项目名称
            $sepr_data = DB::table('service_project')
                ->where('sepr_id', $work_data->wor_service_sepr_id)
                ->select('sepr_name', 'sepr_order_money')
                ->first();
            $work_data->wor_service_sepr_name = $sepr_data->sepr_name;
            $work_data->sepr_order_money = $sepr_data->sepr_order_money;

            $work_data->vish_service_shop_name = ''; //虚拟加盟店名称
            // 查询虚拟加盟店服务门店名称
            if ($work_data->wocl_wor_type == 4) {
                $work_data->vish_service_shop_name = DB::table('virtual_shop')
                    ->where('vish_id', $work_data->wor_service_shop_id)
                    ->value('vish_store_name');
            }

            // 获取当前操作账号信息
            $user_info = Common::getUserInfo($request['api_token']);

            // 获取工单商品数据
            $work_goods = DB::table('work_good as wogo')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'wogo.wogo_goo_id')
                ->where('wogo_wor_id', $request['wor_id'])
                ->where('wogo_state', '!=', 2)
                ->select('wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_price', 'wogo_state', 'wogo_goo_amount', 'wogo_is_recycle', 'wogo_actual_recycle_number', 'wogo_remark', 'wogo_id', 'wogo_collection_price', 'wogo_recycle_price', 'wogo_recycle_quantity', 'wogo_tem_goo_name as tem_goo_name', 'wogo_assign_price', 'wogo_ware_id', 'goo_unit', 'goo_brse_id', 'goo_bra_name', 'goo_class', 'wogo_orgo_id')
                ->get()->toArray();
            $work_goods = json_decode(json_encode($work_goods), true);
            $work_goods_data = array_column($work_goods, null, 'wogo_orgo_id');
            // 查询系列数据
            $goo_brse_id = array_column($work_goods, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            // 查询订单商品仓位数据
            $orgo_id = array_column($work_goods, 'wogo_orgo_id');
            $find_orgf_data = DB::table('order_goods_freight as orgf')
                ->leftjoin('warehouse_freight as wafr', 'wafr.wafr_id', 'orgf.orgf_wafr_id')
                ->where('orgf_delete', 1)
                ->where('orgf_shop_id', $user_info->adm_shop_id)
                ->where('orgf_ord_id', $work_data->wor_order_id)
                ->whereIn('orgf_orgo_id', $orgo_id)
                ->where('orgf_order_number', $work_data->wor_order_number)
                ->select('orgf_id', 'orgf_ord_id', 'orgf_order_number', 'orgf_orgo_id', 'orgf_wago_id', 'orgf_ware_id', 'orgf_wafr_id', 'orgf_goo_id', 'orgf_goo_quantity', 'orgf_goo_inventory', 'wafr_name')
                ->get()->toArray();
            $new_new_goo_datas = [];
            $find_rego_data = DB::table('recede_recycle')
                ->where(function ($query) use ($work_data) {
                    $query->where('rec_ord_order_number', $work_data->wor_order_number)
                        ->orwhere('rec_ord_order_number', $work_data->wor_number);
                })
                ->where(function ($query) use ($work_data) {
                    $query->where('rec_ord_id', $work_data->wor_order_id)
                        ->orwhere('rec_ord_id', $work_data->wor_id);
                })
                ->select('rec_id', 'rec_amount', 'rec_source_type')
                ->orderBy('rec_id', 'desc')
                ->first();

            if (!empty($find_rego_data)) {
                if ($find_rego_data->rec_source_type == 5) { //技师退回
                    $find_rego_data_res = false;
                } else {
                    $find_rego_data_res = true;
                }
            } else {
                $find_rego_data_res = true;
            }
            if ($find_orgf_data && $find_rego_data_res) {
                foreach ($find_orgf_data as $key => $value) {
                    if (isset($work_goods_data[$value->orgf_orgo_id])) {
                        $wogo_orgf = $work_goods_data[$value->orgf_orgo_id];
                        // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                            if (!empty($wogo_orgf['goo_brse_id'])) {
                                if ($wogo_orgf['goo_class'] == 2) {
                                    $wogo_orgf['wogo_goo_name'] = $brse_data[$wogo_orgf['goo_brse_id']] . ' ' . $wogo_orgf['wogo_goo_name'];
                                    unset($wogo_orgf['goo_brse_id']);
                                } else {
                                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                        $wogo_orgf['wogo_goo_name'] = $brse_data[$wogo_orgf['goo_brse_id']] . ' ' . $wogo_orgf['wogo_goo_name'];
                                        unset($wogo_orgf['goo_brse_id']);
                                    }
                                }
                            }
                        }
                        // 显示品牌名称
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                            if ($wogo_orgf['goo_class'] == 2) {
                                $wogo_orgf['wogo_goo_name'] = $wogo_orgf['goo_bra_name'] . ' ' . $wogo_orgf['wogo_goo_name'];
                            } else {
                                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $wogo_orgf['wogo_goo_name'] = $wogo_orgf['goo_bra_name'] . ' ' . $wogo_orgf['wogo_goo_name'];
                                }
                            }
                        }
                        $new_goo_data['wogo_goo_id'] = $wogo_orgf['wogo_goo_id'];
                        $new_goo_data['wogo_goo_name'] = $wogo_orgf['wogo_goo_name']; //商品名称
                        $new_goo_data['wogo_goo_goods_encode'] = $wogo_orgf['wogo_goo_goods_encode']; //检索编码
                        $new_goo_data['wogo_goo_price'] = $wogo_orgf['wogo_goo_price']; //商品数量
                        $new_goo_data['wogo_state'] = $wogo_orgf['wogo_state'];
                        $new_goo_data['wogo_goo_amount'] = $value->orgf_goo_quantity;
                        $new_goo_data['wogo_is_recycle'] = $wogo_orgf['wogo_is_recycle'];
                        $new_goo_data['wogo_actual_recycle_number'] = $wogo_orgf['wogo_actual_recycle_number'];
                        $new_goo_data['wogo_remark'] = $wogo_orgf['wogo_remark'];
                        $new_goo_data['wogo_id'] = $wogo_orgf['wogo_id'];
                        $new_goo_data['wogo_collection_price'] = $wogo_orgf['wogo_collection_price'];
                        $new_goo_data['wogo_recycle_price'] = $wogo_orgf['wogo_recycle_price'];
                        $new_goo_data['wogo_recycle_quantity'] = $wogo_orgf['wogo_recycle_quantity'];
                        $new_goo_data['tem_goo_name'] = $wogo_orgf['tem_goo_name'];
                        $new_goo_data['wogo_assign_price'] = $wogo_orgf['wogo_assign_price'];
                        $new_goo_data['goo_unit'] = $wogo_orgf['goo_unit'];
                        $new_goo_data['wogo_wafr_name'] = $value->wafr_name; //仓位
                        $new_goo_data['wogo_freight_space'] = DB::table('warehouse')
                            ->where('ware_id', $wogo_orgf['wogo_ware_id'])
                            ->value('ware_freight_space');
                        $new_new_goo_datas[] = $new_goo_data;
                        unset($new_goo_data);
                    }
                }
            } else {
                foreach ($work_goods as $key => $value) {
                    $work_goods[$key]['wogo_freight_space'] = DB::table('warehouse')
                        ->where('ware_id', $value['wogo_ware_id'])
                        ->value('ware_freight_space');
                    $work_goods[$key]['unit'] = $value['goo_unit'];
                    // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                        if (!empty($value['goo_brse_id'])) {
                            if ($value['goo_class'] == 2) {
                                $work_goods[$key]['wogo_goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['wogo_goo_name'];
                            } else {
                                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $work_goods[$key]['wogo_goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['wogo_goo_name'];
                                }
                            }
                        }
                    }
                    // 显示品牌名称
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                        if ($value['goo_class'] == 2) {
                            $work_goods[$key]['wogo_goo_name'] = $value['goo_bra_name'] . ' ' . $work_goods[$key]['wogo_goo_name'];
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $work_goods[$key]['wogo_goo_name'] = $value['goo_bra_name'] . ' ' . $work_goods[$key]['wogo_goo_name'];
                            }
                        }
                    }
                    unset($work_goods[$key]['goo_class']);
                    unset($work_goods[$key]['wogo_ware_id']);
                    unset($work_goods[$key]['goo_brse_id']);
                }
                $new_new_goo_datas = $work_goods;
            }

            // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
            $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

            if ($work_data->ord_type == 1) {
                $total_client_price = 0; //会员零售金额为0，不统计应收应付
            } else {
                $total_client_price = ReceivableCredit::queryClientPrice(
                    $user_info,
                    2, //打印类型：1订单打印2工单打印
                    $work_data->wor_type, //客户类型
                    $work_data->ord_client_id, //客户id
                    $work_data->wocl_wor_type, //单据类型：1系统工单2外派工单3速电派单4虚拟加盟店
                    $work_data->wor_service_shop_id //服务门店id，实体加盟店id/虚拟加盟店id
                );
            }

            // 获取公司缓存数据
            $cache_data = DB::table('print_cache')
                ->where('prca_create_adm_id', $user_info->adm_id)
                ->where('prca_superior_shop_id', $shop_id)
                ->where('prca_type', 2)
                ->first(['prca_com_name', 'prca_serve_provider', 'prca_serve_order']);

            $data['wor_data'] = $work_data;
            $data['work_goods'] = $new_new_goo_datas;
            $data['chun_data'] = $chun_data;

            $work_data = json_decode(json_encode($work_data, true), true);
            $chun_data = json_decode(json_encode($chun_data, true), true);
            $cache_data = json_decode(json_encode($cache_data), true);
            $data = array_merge($work_data, $chun_data);
            $data['total_client_price'] = $total_client_price;

            $shpt_template_set = json_decode($shpt_template_set, true);
            $data = json_decode(json_encode($data, true), true);
            $new_new_goo_datas = json_decode(json_encode($new_new_goo_datas, true), true);

            $return_data[0] = $data;
            $return_data[0]['shpt_print_type_name'] = config('apisystem.PRINT_TYPE')[$request['shpt_print_type']]; //打印模板名称类型
            $num = 1;
            foreach ($new_new_goo_datas as $goo_key => $goo_value) { //遍历商品明细
                $return_data[0]['details'][$goo_key] = $goo_value;
                $return_data[0]['details'][$goo_key]['NO'] = $num;
                $num++;
            }
        } elseif ($request['shpt_print_type'] == 11) { //调拨单
            $find_tror = DB::table('transferring_order')
                ->where('tror_id', $request['tror_id'])
                ->select('tror_id', 'tror_number', 'tror_out_ware_id', 'tror_in_ware_id', 'tror_out_wafr_id')
                ->first();

            // 仓库名称
            $ware_name = DB::table('warehouse')
                ->whereIn('ware_id', [$find_tror->tror_out_ware_id, $find_tror->tror_in_ware_id])
                ->select('ware_id', 'ware_name')
                ->get();
            $find_tror->out_ware_name = DB::table('warehouse')
                ->where('ware_id', $find_tror->tror_out_ware_id)
                ->value('ware_name');
            $find_tror->in_ware_name = DB::table('warehouse')
                ->where('ware_id', $find_tror->tror_in_ware_id)
                ->value('ware_name');
            // 调出仓位名称
            $find_tror->wafr_name = DB::table('warehouse_freight')
                ->where('wafr_shop_id', $user_info->adm_shop_id)
                ->where('wafr_id', $find_tror->tror_out_wafr_id)
                ->value('wafr_name');
            unset($find_tror->tror_out_wafr_id);

            // 调拨单商品信息
            $find_trog = DB::table('transferring_order_goods as trog')
                ->leftJoin('goods as goo', 'goo.goo_id', '=', 'trog.trog_goo_id')
                ->where('trog_tror_id', $request['tror_id'])
                ->select('goo_name', 'goo_goods_encode', 'trog_stock_number', 'trog_priority_stock_number', 'goo_bra_name', 'goo_brse_id', 'goo_class', 'goo_id', 'trog_id')
                ->get()->toArray();
            // 查询系列数据
            $goo_brse_id = array_column($find_trog, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            $goo_id = array_column($find_trog, 'goo_id');
            // 查询商品附属表信息
            $goaf_data = DB::table('goods_affiliate')
                ->where('goaf_shop_id', $user_info->adm_shop_id)
                ->whereIn('goaf_goo_id', $goo_id)
                ->pluck('goaf_another_name', 'goaf_goo_id')
                ->toArray();
            // 查询系统商品属性表信息
            $gosa_data = DB::table('goods_system_affiliate')
                ->where('gosa_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosa_goo_id', $goo_id)
                ->pluck('gosa_another_name', 'gosa_goo_id')
                ->toArray();
            foreach ($find_trog as $key => $value) {
                // 查询仓位商品出入库表
                $find_wfog_data = DB::table('warehouse_freight_outin_goods as wfog')
                    ->leftJoin('warehouse_freight as wafr', 'wfog.wfog_wafr_id', '=', 'wafr.wafr_id')
                    ->where('wfog_shop_id', $user_info->adm_shop_id)
                    ->where('wfog_type', 3)
                    ->where('wfog_original_id', $request['tror_id'])
                    ->where('wfog_original_number', $find_tror->tror_number)
                    ->where('wfog_primary_id', $value->trog_id)
                    ->where('wfog_outin_type', 2)
                    ->select('wfog_wafr_id', 'wfog_stock_amount', 'wafr_name', 'wfog_stock_type')
                    ->get()->toArray();
                $find_wfog_data = json_decode(json_encode($find_wfog_data, true), true);
                if ($find_wfog_data) {
                    $find_trog[$key]->wafr_data = $find_wfog_data;
                    $find_trog[$key]->wafr_name = $find_wfog_data[0]['wafr_name'];
                } else {
                    $find_trog[$key]->wafr_data = [];
                    $find_trog[$key]->wafr_name = '';
                }
                if ($value->goo_class == 2 && isset($gosa_data[$value->goo_id]) && !empty($gosa_data[$value->goo_id])) {
                    $find_trog[$key]->goo_name = $gosa_data[$value->goo_id];
                }
                if (isset($goaf_data[$value->goo_id]) && !empty($goaf_data[$value->goo_id])) { // 商品别名
                    $find_trog[$key]->goo_name = $goaf_data[$value->goo_id];
                }
                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($value->goo_brse_id)) {
                        if ($value->goo_class == 2) {
                            $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                            unset($find_trog[$key]->goo_brse_id);
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $find_trog[$key]->goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->goo_name;
                                unset($find_trog[$key]->goo_brse_id);
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_trog[$key]->goo_name = $value->goo_bra_name . ' ' . $value->goo_name;
                        }
                    }
                }
                unset($find_trog[$key]->goo_class);
            }
            $shpt_template_set = json_decode($shpt_template_set, true);
            $find_tror = json_decode(json_encode($find_tror, true), true);
            $find_trog = json_decode(json_encode($find_trog, true), true);

            $return_data[0] = $find_tror;
            $return_data[0]['shpt_print_type_name'] = config('apisystem.PRINT_TYPE')[$request['shpt_print_type']]; //打印模板名称类型
            $num = 1;
            foreach ($find_trog as $goo_key => $goo_value) { //遍历商品明细
                $return_data[0]['details'][$goo_key] = $goo_value;
                $return_data[0]['details'][$goo_key]['NO'] = $num;
                $num++;
            }
        } elseif ($request['shpt_print_type'] == 12) { //盘库单
            // 盘库单数据
            $find_stoc = DB::table('stocktake as a')
                ->leftJoin('admin as b', 'b.adm_id', '=', 'a.stoc_adm_id')
                ->leftJoin('warehouse as c', 'c.ware_id', '=', 'a.stoc_ware_id')
                ->where('stoc_id', $request['stoc_id'])
                ->select('adm_name', 'ware_name', 'stoc_make_time', 'stoc_state', 'stoc_type', 'stoc_storage_number', 'stoc_differ_number', 'stoc_waon_class', 'stoc_manner', 'stoc_wafr_id')
                ->first();
            // 查询仓位名称
            $find_stoc->stoc_wafr_name = DB::table('warehouse_freight')
                ->where('wafr_id', $find_stoc->stoc_wafr_id)
                ->where('wafr_shop_id', $user_info->adm_shop_id)
                ->where('wafr_delete', 1)
                ->value('wafr_name');
            unset($find_stoc->stoc_wafr_id);
            // 获取盘库商品数据
            $find_goods = DB::table('stocktake_goods as a')
                ->leftJoin('goods as b', 'a.stgo_goo_id', '=', 'b.goo_id')
                ->where('stgo_stoc_id', $request['stoc_id'])
                ->select('stgo_stock_number', 'stgo_lock_number', 'stgo_stocktake_number', 'goo_class', 'goo_bra_name', 'goo_brse_id', 'goo_name', 'goo_type', 'goo_goods_encode', 'stgo_priority_stock_number', 'stgo_priority_lock_number', 'stgo_unchecked_stock_number', 'stgo_priority_stocktake_number', 'stgo_unchecked_stocktake_number', 'goo_id')
                ->get();
            $data['stoc_data'] = $find_stoc;
            $find_goods = json_decode(json_encode($find_goods), true);
            // 查询系列数据
            $goo_brse_id = array_column($find_goods, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            $goo_id = array_column($find_goods, 'goo_id');
            // 查询商品附属表信息
            $goaf_data = DB::table('goods_affiliate')
                ->where('goaf_shop_id', $user_info->adm_shop_id)
                ->whereIn('goaf_goo_id', $goo_id)
                ->pluck('goaf_another_name', 'goaf_goo_id')
                ->toArray();
            // 查询系统商品属性表信息
            $gosa_data = DB::table('goods_system_affiliate')
                ->where('gosa_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosa_goo_id', $goo_id)
                ->pluck('gosa_another_name', 'gosa_goo_id')
                ->toArray();
            foreach ($find_goods as $k => $v) {
                if ($v['goo_class'] == 2 && isset($gosa_data[$v['goo_id']]) && !empty($gosa_data[$v['goo_id']])) {
                    $find_goods[$k]['goo_name'] = $gosa_data[$v['goo_id']];
                }
                if (isset($goaf_data[$v['goo_id']]) && !empty($goaf_data[$v['goo_id']])) { // 商品别名
                    $find_goods[$k]['goo_name'] = $goaf_data[$v['goo_id']];
                }
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($v['goo_brse_id'])) {
                        if ($v['goo_class'] == 2) {
                            $find_goods[$k]['goo_name'] = $brse_data[$v['goo_brse_id']] . ' ' . $find_goods[$k]['goo_name'];
                            unset($find_goods[$k]['goo_brse_id']);
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $find_goods[$k]['goo_name'] = $brse_data[$v['goo_brse_id']] . ' ' . $find_goods[$k]['goo_name'];
                                unset($find_goods[$k]['goo_brse_id']);
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($v['goo_class'] == 2) {
                        $find_goods[$k]['goo_name'] = $v['goo_bra_name'] . ' ' . $find_goods[$k]['goo_name'];
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $find_goods[$k]['goo_name'] = $v['goo_bra_name'] . ' ' . $find_goods[$k]['goo_name'];
                        }
                    }
                }
                unset($find_goods[$k]['goo_class']);
                //盘前数量
                $find_goods[$k]['stgo_stock_number'] = $v['stgo_stock_number'] + $v['stgo_lock_number'];
                $find_goods[$k]['stgo_priority_stock_number'] = $v['stgo_priority_stock_number'] + $v['stgo_priority_lock_number'];
                $find_goods[$k]['stgo_unchecked_stock_number'] = $v['stgo_unchecked_stock_number'];
                //盘后数量
                $find_goods[$k]['stgo_stocktake_number'] = $v['stgo_stock_number'] + $v['stgo_lock_number'] + $v['stgo_stocktake_number'];
                $find_goods[$k]['stgo_priority_stocktake_number'] = $v['stgo_priority_stocktake_number'] + $v['stgo_priority_stock_number'] + $v['stgo_priority_lock_number'];
                $find_goods[$k]['stgo_unchecked_stocktake_number'] = $v['stgo_unchecked_stocktake_number'] + $v['stgo_unchecked_stock_number'];
            }
            $data['goods_data'] = $find_goods;

            $shpt_template_set = json_decode($shpt_template_set, true);
            $find_stoc = json_decode(json_encode($find_stoc, true), true);
            $find_goods = json_decode(json_encode($find_goods, true), true);

            $return_data[0] = $find_stoc;
            $return_data[0]['shpt_print_type_name'] = config('apisystem.PRINT_TYPE')[$request['shpt_print_type']]; //打印模板名称类型
            $num = 1;
            foreach ($find_goods as $goo_key => $goo_value) { //遍历商品明细
                $return_data[0]['details'][$goo_key] = $goo_value;
                $return_data[0]['details'][$goo_key]['NO'] = $num;
                $num++;
            }
        } elseif ($request['shpt_print_type'] == 13) { //结款明细
            $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
            $search_data = $request->all();
            if (!empty($search_data['start_time']) || !empty($search_data['end_time']) || !empty($search_data['acset_original_number']) || !empty($search_data['acset_client_id']) || !empty($search_data['acset_adm_id']) || !empty($search_data['acti_course_title']) || !empty($search_data['acset_remark']) || !empty($search_data['start_affirm_time']) || !empty($search_data['end_affirm_time']) || !empty($search_data['max_price']) || !empty($search_data['min_price']) || !empty($search_data['acset_number']) || !empty($search_data['acset_sync_state'])) {
                // 实际金额最小钱数
                if (!empty($search_data['min_price'])) {
                    $search_data['min_price'] = $search_data['min_price'] * 100;
                }
                // 实际金额最大钱数
                if (!empty($search_data['max_price'])) {
                    $search_data['max_price'] = $search_data['max_price'] * 100;
                }

                $list_data = DB::table('accounting_settlement as acset')
                    ->leftjoin('admin as adm', 'adm.adm_id', '=', 'acset.acset_adm_id')
                    ->leftjoin('account_title as acti', 'acti.acti_id', '=', 'acset.acset_acti_id')
                    ->where('acset_adm_cid', $user_info->adm_cid)
                    ->where('acset_superior_shop_id', $shop_id)
                    ->where(function ($query) use ($search_data) { //结款时间
                        // 如果选择开始时间并且选择结束时间
                        if (!empty($search_data['start_time']) && !empty($search_data['end_time'])) {
                            $query->whereBetween('acset_with_time', [$search_data['start_time'], $search_data['end_time']]);
                        } else {
                            // 如果选择开始时间
                            if (!empty($search_data['start_time'])) {
                                $query->where('acset_with_time', '>=', $search_data['start_time']);
                            } else {
                                // 如果选择结束时间
                                if (!empty($search_data['end_time'])) {
                                    $query->where('acset_with_time', '<=', $search_data['end_time']);
                                }
                            }
                        }
                    })
                    ->where(function ($query) use ($search_data) { //确认时间
                        // 如果选择开始时间并且选择结束时间
                        if (!empty($search_data['start_affirm_time']) && !empty($search_data['end_affirm_time'])) {
                            $query->whereBetween('acset_affirm_time', [$search_data['start_affirm_time'], $search_data['end_affirm_time']]);
                        } else {
                            // 如果选择开始时间
                            if (!empty($search_data['start_affirm_time'])) {
                                $query->where('acset_affirm_time', '>=', $search_data['start_affirm_time']);
                            } else {
                                // 如果选择结束时间
                                if (!empty($search_data['end_affirm_time'])) {
                                    $query->where('acset_affirm_time', '<=', $search_data['end_affirm_time']);
                                }
                            }
                        }
                    })
                    ->where(function ($query) use ($search_data) { //实际金额区间搜索
                        // 如果选择最小钱数并且选择最大钱数
                        if (!empty($search_data['min_price']) && !empty($search_data['max_price'])) {
                            $query->whereBetween('acset_price', [$search_data['min_price'], $search_data['max_price']]);
                        } else {
                            // 如果选择最小钱数
                            if (!empty($search_data['min_price'])) {
                                $query->where('acset_price', '>=', $search_data['min_price']);
                            } else {
                                // 如果选择最大钱数
                                if (!empty($search_data['max_price'])) {
                                    $query->where('acset_price', '<=', $search_data['max_price']);
                                }
                            }
                        }
                    })
                    ->where(function ($query) use ($search_data) { //结款人
                        if (!empty($search_data['acset_inex_type'])) {
                            $query->where('acset_inex_type', $search_data['acset_inex_type']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //单号
                        if (!empty($search_data['acset_original_number'])) {
                            $query->where('acset_original_number', 'like', '%' . $search_data['acset_original_number'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //流水号
                        if (!empty($search_data['acset_number'])) {
                            $query->where('acset_number', 'like', '%' . $search_data['acset_number'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //客户单位
                        if (!empty($search_data['acset_client_name'])) {
                            $query->where('acset_client_name', 'like', '%' . $search_data['acset_client_name'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //结款人
                        if (!empty($search_data['acset_adm_id'])) {
                            $query->where('acset_adm_id', $search_data['acset_adm_id']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //银行卡名称
                        if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 1) {
                            $query->where('acset_acti_id', $search_data['acti_course_title'])
                                ->where('acset_payment_type', '!=', '3');
                        }
                        if (!empty($search_data['acti_course_title']) && $search_data['pay_type'] == 2) {
                            $query->where('acset_acti_id', $search_data['acti_course_title'])
                                ->where('acset_payment_type', '3');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //备注
                        if (!empty($search_data['acset_remark'])) {
                            $query->where('acset_remark', 'like', '%' . $search_data['acset_remark'] . '%');
                        }
                    })
                    ->where(function ($query) use ($search_data) { //单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)25批量结算26期初账单
                        if (!empty($search_data['acset_type'])) {
                            $query->where('acset_type', $search_data['acset_type']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //状态：1未确认2已确认3部分确认
                        if (!empty($search_data['acset_state'])) {
                            $query->where('acset_state', $search_data['acset_state']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //U8状态1.未同步2.已同步
                        if (!empty($search_data['acset_sync_state'])) {
                            $query->where('acset_sync_state', $search_data['acset_sync_state']);
                        }
                    })
                    ->where(function ($query) use ($search_data) { //客户id
                        if (!empty($search_data['acset_client_id'])) {
                            $query->where('acset_client_id', $search_data['acset_client_id']);
                        }
                    })
                    ->select(['acset_id', 'acset_original_number', 'acset_owe_price', 'acset_zero_price', 'acset_client_name', 'acset_price', 'acset_with_time', 'adm_name', 'acset_remark', 'acti_course_title', 'acset_inex_type', 'acset_actual_price', 'acset_client_id'])
                    ->orderBy('acset_id', 'desc')
                    ->get()->toArray();
                $acset_client_id = array_unique(array_column($list_data, 'acset_client_id')); //选择的客户id，会员id/单位id
                // 查询客户单位
                $channel_name = DB::table('channel_unit')
                    ->whereIn('chun_id', $acset_client_id)
                    ->where('chun_shop_id', $shop_id)
                    ->where('chun_state', '1')
                    ->pluck('chun_unit_name', 'chun_id')
                    ->toArray();
                foreach ($list_data as $key => $value) {
                    // 客户单位名称
                    if (isset($channel_name[$value->acset_client_id])) {
                        $list_data[$key]->acset_client_name = $channel_name[$value->acset_client_id];
                    } else {
                        $list_data[$key]->acset_client_name = $value->acset_client_name;
                    }
                    unset($list_data[$key]->acset_client_id);
                }

                $shpt_template_set = json_decode($shpt_template_set, true);
                $list_data = json_decode(json_encode($list_data, true), true);

                $return_data[0]['shpt_print_type_name'] = config('apisystem.PRINT_TYPE')[$request['shpt_print_type']]; //打印模板名称类型
                $num = 1;
                foreach ($list_data as $goo_key => $goo_value) { //遍历商品明细
                    $return_data[0]['details'][$goo_key] = $goo_value;
                    $return_data[0]['details'][$goo_key]['NO'] = $num;
                    $num++;
                }
            } else {
                return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'请输入搜索条件']);
            }
        } elseif ($request['shpt_print_type'] == 14) { //对单-对单
            // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
            $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

            $search_data = $request->all();

            $orderby_type = 'desc'; //排序类型，默认倒序查询
            // 当查询待接单状态订单时，按正序查询
            if (!empty($request['ord_wor_state']) && $request['ord_wor_state'] == 7) {
                $orderby_type = 'asc'; //默认排序类型
            }

            $data = DB::table('order as a')
                ->leftJoin('order_client as b', 'b.orcl_ord_id', '=', 'a.ord_id')
                ->leftJoin('admin as as', 'as.adm_id', '=', 'a.ord_create_id')
                ->where('ord_cid', $user_info->adm_cid)
                ->where('ord_superior_shop_id', $shop_id)
                ->where('ord_delete', 1)
                ->where('ord_collection_bill', 1) //是否代收账单：1正常订单2代收账单
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_order_number'])) {
                        $query->where('ord_order_number', 'like', '%' . $search_data['ord_order_number'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['orcl_channel_unit'])) {
                        $query->where('orcl_channel_unit', 'like', '%' . $search_data['orcl_channel_unit'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['orcl_name'])) {
                        $query->where('orcl_name', 'like', '%' . $search_data['orcl_name'] . '%');
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_type'])) {
                        $query->where('ord_type', $search_data['ord_type']);
                    }
                }) //买家类型：1会员零售2客户单位3速电网单
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_service_type'])) {
                        $query->where('ord_service_type', $search_data['ord_service_type']);
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_create_id'])) {
                        $query->where('a.ord_create_id', $search_data['ord_create_id']);
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_state'])) {
                        $query->where('ord_state', $search_data['ord_state']);
                    }
                })
                ->where(function ($query) use ($search_data) {
                    // 订单完成状态4已完成，其他值是未完成
                    if (!empty($search_data['ord_wor_state'])) {
                        if ($search_data['ord_wor_state'] == 4) {
                            $query->where('ord_wor_state', $search_data['ord_wor_state']);
                        } else {
                            $query->where('ord_wor_state', '<>', 4);
                        }
                    }
                })
                ->where(function ($query) use ($search_data) {
                    //如果选择开始时间并且选择结束时间
                    if (!empty($search_data['create_time_start']) && !empty($search_data['create_time_end'])) {
                        $query->whereBetween('ord_create_time', [$search_data['create_time_start'], $search_data['create_time_end'] . ' 23:59:59']);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['create_time_start'])) {
                            $query->where('ord_create_time', '>=', $search_data['create_time_start']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['create_time_end'])) {
                                $query->where('ord_create_time', '<=', $search_data['create_time_end'] . ' 23:59:59');
                            }
                        }
                    }
                }) //创建时间
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_form_type'])) {
                        $query->where('ord_form_type', $search_data['ord_form_type']);
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['orcl_shipment_party'])) {
                        $query->where('orcl_shipment_party', $search_data['orcl_shipment_party']);
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_service_shop_id'])) {
                        $query->where('ord_service_shop_id', $search_data['ord_service_shop_id']);
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_client_id'])) {
                        $query->where('ord_client_id', $search_data['ord_client_id']);
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['orcl_match_type'])) {
                        $query->where('orcl_match_type', $search_data['orcl_match_type']);
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ware_id'])) {
                        $query->where('ord_ware_id', $search_data['ware_id']);
                    }
                })
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['ord_payment_way'])) {
                        $query->where('ord_payment_way', $search_data['ord_payment_way']);
                    }
                }) //结算方式：1账期2现结
                ->where(function ($query) use ($search_data) {
                    if (!empty($search_data['orcl_match_adm_id'])) {
                        $query->where('orcl_match_adm_id', $search_data['orcl_match_adm_id']);
                    }
                }) //对单人
                ->where(function ($query) use ($search_data) {
                    //如果选择开始时间并且选择结束时间
                    if (!empty($search_data['match_time_start']) && !empty($search_data['match_time_end'])) {
                        $query->whereBetween('orcl_match_time', [$search_data['match_time_start'], $search_data['match_time_end'] . ' 23:59:59']);
                    } else {
                        // 如果选择开始时间
                        if (!empty($search_data['match_time_start'])) {
                            $query->where('orcl_match_time', '>=', $search_data['match_time_start']);
                        } else {
                            // 如果选择结束时间
                            if (!empty($search_data['match_time_end'])) {
                                $query->where('orcl_match_time', '<=', $search_data['match_time_end'] . ' 23:59:59');
                            }
                        }
                    }
                }) //对单时间
                ->select('ord_id', 'ord_order_number', 'adm_name', 'ord_client_id', 'ord_actual_price', 'ord_ware_id', 'ord_create_time', 'ord_service_type', 'orcl_match_type', 'orcl_shipment_party', 'ord_type', 'orcl_name', 'ord_payment_way')
                ->orderBy('ord_id', $orderby_type)
                ->limit(1000)
                ->get()->toArray();
            if (!empty($data)) {
                // 将对象转化为数组
                $data = json_decode(json_encode($data), true);
                $ord_client_id = array_column($data, 'ord_client_id');
                // 会员零售
                $mem = DB::table('member')
                    ->whereIn('mem_id', $ord_client_id)
                    ->pluck('mem_name', 'mem_id');
                // 查询客户单位
                $channel = DB::table('channel_unit')
                    ->whereIn('chun_id', $ord_client_id)
                    ->pluck('chun_unit_name', 'chun_id');
                // 虚拟加盟店
                $virtual = DB::table('virtual_shop')
                    ->whereIn('vish_id', $ord_client_id)
                    ->pluck('vish_name', 'vish_id');
                $ware_id = array_column($data, 'ord_ware_id');
                // 仓库
                $ware = DB::table('warehouse')
                    ->whereIn('ware_id', $ware_id)
                    ->pluck('ware_name', 'ware_id');
                foreach ($data as $key => $value) {
                    $dataInfo[$key]['ord_order_number'] = $value['ord_order_number'];
                    $dataInfo[$key]['adm_name'] = $value['adm_name'];
                    if ($value['ord_type'] == 1) {
                        if (empty($mem[$value['ord_client_id']])) {
                            $dataInfo[$key]['chun_unit_name'] = $value['orcl_name'];
                        } else {
                            $dataInfo[$key]['chun_unit_name'] = $mem[$value['ord_client_id']];
                        }
                    } elseif ($value['ord_type'] == 2) {
                        $dataInfo[$key]['chun_unit_name'] = $channel[$value['ord_client_id']];
                    } elseif ($value['ord_type'] == 3) {
                        $dataInfo[$key]['chun_unit_name'] = config('apisystem.sd_chan_info')['name'];
                    } elseif ($value['orcl_shipment_party'] == 4) {
                        $dataInfo[$key]['chun_unit_name'] = $virtual[$value['ord_client_id']];
                    }
                    $dataInfo[$key]['ord_actual_price'] = $value['ord_actual_price'] / 100; //结算金额
                    if (isset($ware[$value['ord_ware_id']])) {
                        $dataInfo[$key]['ware_name'] = $ware[$value['ord_ware_id']];
                    } else {
                        $dataInfo[$key]['ware_name'] = '';
                    }
                    $dataInfo[$key]['ord_create_time'] = $value['ord_create_time'];
                    // 订单类型
                    if ($value['ord_service_type'] == '1') {
                        $dataInfo[$key]['ord_service_type'] = '服务单';
                    } elseif ($value['ord_service_type'] == '2') {
                        $dataInfo[$key]['ord_service_type'] = '销售单';
                    } elseif ($value['ord_service_type'] == '3') {
                        $dataInfo[$key]['ord_service_type'] = '换货单';
                    } elseif ($value['ord_service_type'] == '4') {
                        $dataInfo[$key]['ord_service_type'] = '退货单';
                    } elseif ($value['ord_service_type'] == '5') {
                        $dataInfo[$key]['ord_service_type'] = '发货单';
                    } elseif ($value['ord_service_type'] == '6') {
                        $dataInfo[$key]['ord_service_type'] = '结清单';
                    } elseif ($value['ord_service_type'] == '7') {
                        $dataInfo[$key]['ord_service_type'] = '救援单';
                    }
                    // 对单状态
                    if ($value['orcl_match_type'] == '1') {
                        $dataInfo[$key]['orcl_match_type'] = '未确认';
                    } elseif ($value['orcl_match_type'] == '2') {
                        $dataInfo[$key]['orcl_match_type'] = '已确认';
                    }
                    // 结算方式
                    if ($value['ord_payment_way'] == '1') {
                        $dataInfo[$key]['ord_payment_way'] = '账期';
                    } elseif ($value['ord_payment_way'] == '2') {
                        $dataInfo[$key]['ord_payment_way'] = '现结';
                    } elseif ($value['ord_payment_way'] == '3') {
                        $dataInfo[$key]['ord_payment_way'] = '微信';
                    } elseif ($value['ord_payment_way'] == '4') {
                        $dataInfo[$key]['ord_payment_way'] = '支付宝';
                    }
                }
                $shpt_template_set = json_decode($shpt_template_set, true);
                $dataInfo = json_decode(json_encode($dataInfo, true), true);

                $return_data[0]['shpt_print_type_name'] = config('apisystem.PRINT_TYPE')[$request['shpt_print_type']]; //打印模板名称类型
                $num = 1;
                foreach ($dataInfo as $goo_key => $goo_value) { //遍历商品明细
                    $return_data[0]['details'][$goo_key] = $goo_value;
                    $return_data[0]['details'][$goo_key]['NO'] = $num;
                    $num++;
                }
            } else {
                return ['code'=>500, 'msg'=>'error', 'data'=>'没有符合条件的数据'];
            }
        }
        if (!empty($return_data)) {
            return ['code'=>200, 'msg'=>'success', 'data'=>$shpt_template_set, 'data_info'=>$return_data];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'暂无数据'];
        }
    }
}
