<?php
namespace App\Http\Models\Services\OrderManage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\Common;
use App\Http\Models\Services\Order;
use App\Http\Models\Api\OutinRecord;

class WorkOrders extends Model
{
    /**
     * info 工单详情
     *
     * @param [type] $user_info     用户信息
     * @param [type] $request       提交信息
     * @param [type] $type          1详情调用2工单审核调用
     * @param [type] $select_field  [查询字段，字符串多个字段用,分开]
     * @return void
     */
    public static function info(
        $user_info,
        $request,
        $type,
        $select_field
    ) {
        $work_data = DB::table('work_order as a')
            ->leftJoin('work_client as b', 'b.wocl_wor_id', '=', 'a.wor_id')
            ->leftJoin('warehouse as c', 'c.ware_id', '=', 'a.wor_ware_id')
            ->where('wor_id', $request['wor_id'])
            ->where('wor_shop_id', $user_info->adm_shop_id)
            ->select(DB::raw($select_field))
            ->first();
        if (empty($work_data)) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'当前工单不存在！'];
        }
        // 账号id
        $adm_id = [$work_data->wor_create_id, $work_data->wor_service_adm_id];
        $adm_id = array_unique($adm_id);
        // 查询账号id对应的名称
        $find_admin = DB::table('admin')
            ->whereIn('adm_id', $adm_id)
            ->pluck('adm_name', 'adm_id')
            ->toArray();
        $work_data->wor_create_name = $find_admin[$work_data->wor_create_id];
        $work_data->wor_service_adm_name = isset($find_admin[$work_data->wor_service_adm_id]) ? $find_admin[$work_data->wor_service_adm_id] : '';

        // 查询服务项目名称
        $sepr_data = DB::table('service_project')
            ->where('sepr_id', $work_data->wor_service_sepr_id)
            ->select('sepr_name', 'sepr_order_money')
            ->first();
        $work_data->wor_service_sepr_name = $sepr_data->sepr_name;
        $work_data->sepr_order_money = $work_data->wocl_rescue_service_price;
        $shop_wor_data = DB::table('work_order as a')
            ->leftJoin('work_client as b', 'b.wocl_wor_id', '=', 'a.wor_id')
            ->where('wor_order_id', $work_data->wocl_join_ord_id)
            ->select('wor_id', 'wocl_shit_id')
            ->first();
        // 获取上传图片
        if ($work_data->wocl_join_ord_id != 0 && $shop_wor_data) {
            $find_image_path = DB::table('image_upload')
                ->where('imup_wor_id', $shop_wor_data->wor_id)
                ->where('imup_delete', 1)
                ->pluck('imup_path', 'imup_image_name')->toArray();
            $shit_template_set = DB::table('shop_image_template')
                ->where('shit_id', $shop_wor_data->wocl_shit_id)
                ->select('shit_template_set')
                ->first();
        } else {
            $find_image_path = DB::table('image_upload')
                ->where('imup_wor_id', $request['wor_id'])
                ->where('imup_delete', 1)
                ->pluck('imup_path', 'imup_image_name')->toArray();
            $shit_template_set = DB::table('shop_image_template')
                ->where('shit_id', $work_data->wocl_shit_id)
                ->select('shit_template_set')
                ->first();
        }

        $shit_template_set = json_decode($shit_template_set->shit_template_set, true);
        // 按照图片模板排序
        foreach ($shit_template_set as $key => $value) {
            $find_image_upload[$key]['imup_path'] = '';
            if (isset($find_image_path[$value['show_word']])) {
                $find_image_upload[$key]['imup_path'] = $find_image_path[$value['show_word']];
            }
            $find_image_upload[$key]['imup_image_name'] = $value['show_word'];
            $find_image_upload[$key]['must_state'] = (string)$value['must_state'];
        }
        // 查询服务门店名称
        if ($work_data->wocl_wor_type == 4) {
            $work_data->wor_service_shop_name = DB::table('virtual_shop')
                ->where('vish_id', $work_data->wor_service_shop_id)
                ->value('vish_store_name as shop_store_name');
            if (empty($find_image_upload)) {
                $shit_template_set = DB::table('shop_image_template')
                    ->where('shit_id', $work_data->wocl_shit_id)
                    ->select('shit_template_set')
                    ->first();
                $shit_template_set = json_decode($shit_template_set->shit_template_set, true);
                foreach ($shit_template_set as $key => $value) {
                    $find_image_upload[$key]['imup_path'] = '';
                    $find_image_upload[$key]['imup_image_name'] = $value['show_word'];
                    $find_image_upload[$key]['must_state'] = (string)$value['must_state'];
                }
            }
        } else {
            $work_data->wor_service_shop_name = DB::table('shop')
                ->where('shop_id', $work_data->wor_service_shop_id)
                ->value('shop_store_name');
        }
        if ($work_data->wor_type == 3) {
            $work_data->wocl_channel_unit = '速电快保';
        } elseif ($work_data->wor_type == 2) {
            // 查询客户单位名称
            $work_data->wocl_channel_unit = DB::table('channel_unit')
                ->where('chun_id', $work_data->wocl_client_id)
                ->value('chun_unit_name');
        } else {
            $work_data->wocl_channel_unit = '';
        }
        unset($work_data->wocl_client_id);

        // 获取工单商品数据
        $work_goods = DB::table('work_good as wogo')
            ->leftjoin('goods as goo', 'goo.goo_id', '=', 'wogo.wogo_goo_id')
            ->where('wogo_wor_id', $request['wor_id'])
            ->where('wogo_state', '<>', 2)
            ->select('wogo_goo_id', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_goo_price', 'wogo_goo_amount', 'wogo_is_recycle', 'wogo_actual_recycle_number', 'wogo_remark', 'wogo_id', 'wogo_collection_price', 'wogo_goo_inventory', 'wogo_state', 'wogo_recycle_price', 'wogo_goo_type', 'wogo_recycle_quantity', 'wogo_tem_goo_name as tem_goo_name', 'wogo_assign_price', 'wogo_id', 'wogo_orgo_id', 'goo_brse_id', 'goo_bra_name', 'goo_class')
            ->get()->toArray();
        $work_goods_datas = array_column($work_goods, null, 'wogo_orgo_id');
        // 查询系列数据
        $goo_brse_id = array_column($work_goods, 'goo_brse_id');
        $brse_data = DB::table('brand_serie')
            ->whereIn('brse_id', $goo_brse_id)
            ->pluck('brse_name', 'brse_id')
            ->toArray();

        // 查询订单商品仓位数据
        $orgo_id = array_column($work_goods, 'wogo_orgo_id');
        $find_orgf_data = DB::table('order_goods_freight as orgf')
            ->leftjoin('warehouse_freight as wafr', 'wafr.wafr_id', 'orgf.orgf_wafr_id')
            ->where('orgf_delete', 1)
            ->where('orgf_shop_id', $user_info->adm_shop_id)
            ->where('orgf_ord_id', $work_data->wor_order_id)
            ->where('orgf_order_number', $work_data->wor_order_number)
            ->whereIn('orgf_orgo_id', $orgo_id)
            ->select('orgf_id', 'orgf_ord_id', 'orgf_order_number', 'orgf_orgo_id', 'orgf_wago_id', 'orgf_ware_id', 'orgf_wafr_id', 'orgf_goo_id', 'orgf_goo_quantity', 'orgf_goo_inventory', 'wafr_name')
            ->get()->toArray();

        $new_new_goo_datas = [];
        $find_rego_data_res = DB::table('recede_recycle')
            ->where('rec_ord_order_number', $work_data->wor_number)
            ->where('rec_ord_id', $work_data->wor_id)
            ->select('rec_id', 'rec_amount', 'rec_source_type')
            ->orderBy('rec_id', 'desc')
            ->first();
        if ($find_orgf_data && $type == 1 && !$find_rego_data_res && $user_info->shop_versions == 2) {
            $new_find_orgf_data = [];
            foreach ($find_orgf_data as $key => $value) {
                if (isset($work_goods_datas[$value->orgf_orgo_id])) {
                    $wogo_orgf = $work_goods_datas[$value->orgf_orgo_id];
                    if (!in_array($wogo_orgf->wogo_goo_id, $new_find_orgf_data)) {
                        // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                            if (!empty($wogo_orgf->goo_brse_id)) {
                                if ($wogo_orgf->goo_class == 2) {
                                    $wogo_orgf->wogo_goo_name = $brse_data[$wogo_orgf->goo_brse_id] . ' ' . $wogo_orgf->wogo_goo_name;
                                } else {
                                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                        $wogo_orgf->wogo_goo_name = $brse_data[$wogo_orgf->goo_brse_id] . ' ' . $wogo_orgf->wogo_goo_name;
                                    }
                                }
                            }
                        }
                        // 显示品牌名称
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                            if ($wogo_orgf->goo_class == 2) {
                                $wogo_orgf->wogo_goo_name = $wogo_orgf->goo_bra_name . ' ' . $wogo_orgf->wogo_goo_name;
                            } else {
                                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $wogo_orgf->wogo_goo_name = $wogo_orgf->goo_bra_name . ' ' . $wogo_orgf->wogo_goo_name;
                                }
                            }
                        }
                        $new_find_orgf_data[] = $wogo_orgf->wogo_goo_id;
                    }
                    $new_goo_data['wogo_goo_id'] = $wogo_orgf->wogo_goo_id; //商品id
                    $new_goo_data['wogo_goo_name'] = $wogo_orgf->wogo_goo_name; //商品名称
                    $new_goo_data['wogo_goo_goods_encode'] = $wogo_orgf->wogo_goo_goods_encode; //检索编码
                    $new_goo_data['wogo_goo_price'] = $wogo_orgf->wogo_goo_price; //商品售价（单位：分）
                    $new_goo_data['wogo_goo_amount'] = $value->orgf_goo_quantity; //商品数量
                    $new_goo_data['wogo_is_recycle'] = $wogo_orgf->wogo_is_recycle;
                    $new_goo_data['wogo_actual_recycle_number'] = $wogo_orgf->wogo_actual_recycle_number;
                    $new_goo_data['wogo_remark'] = $wogo_orgf->wogo_remark;
                    $new_goo_data['wogo_id'] = $wogo_orgf->wogo_id;
                    $new_goo_data['wogo_collection_price'] = $wogo_orgf->wogo_collection_price; //代收金额（单位：分）
                    $new_goo_data['wogo_goo_inventory'] = $wogo_orgf->wogo_goo_inventory; //库存扣除方式1.良品 2.优先
                    $new_goo_data['wogo_state'] = $wogo_orgf->wogo_state;
                    $new_goo_data['wogo_recycle_price'] = $wogo_orgf->wogo_recycle_price;
                    $new_goo_data['wogo_goo_type'] = $wogo_orgf->wogo_goo_type;
                    $new_goo_data['wogo_recycle_quantity'] = $wogo_orgf->wogo_recycle_quantity;
                    $new_goo_data['tem_goo_name'] = $wogo_orgf->tem_goo_name;
                    $new_goo_data['wogo_assign_price'] = $wogo_orgf->wogo_assign_price;
                    $new_goo_data['wogo_orgo_id'] = $wogo_orgf->wogo_orgo_id;
                    $new_goo_data['wogo_wafr_name'] = $value->wafr_name; //仓位
                    $new_new_goo_datas[] = $new_goo_data;
                    unset($new_goo_data);
                }
            }
        } else {
            $work_goods = json_decode(json_encode($work_goods), true);
            foreach ($work_goods as $key => $value) {
                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($value['goo_brse_id'])) {
                        if ($value['goo_class'] == 2) {
                            $work_goods[$key]['wogo_goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['wogo_goo_name'];
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $work_goods[$key]['wogo_goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['wogo_goo_name'];
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value['goo_class'] == 2) {
                        $work_goods[$key]['wogo_goo_name'] = $value['goo_bra_name'] . ' ' . $value['wogo_goo_name'];
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $work_goods[$key]['wogo_goo_name'] = $value['goo_bra_name'] . ' ' . $value['wogo_goo_name'];
                        }
                    }
                }
                unset($work_goods[$key]['goo_class']);
                unset($work_goods[$key]['goo_brse_id']);
            }
            $new_new_goo_datas = $work_goods;
        }
        // 获取到当前工单的订单信息
        $ord_info = DB::table('order_client')
            ->where('orcl_ord_id', $work_data->wor_order_id)
            ->first(['orcl_rescue_service_price']);

        // 获取工单商品数据
        $order_goods = DB::table('order_goods')
            ->where('orgo_ord_id', $work_data->wor_order_id)
            ->where('orgo_state', '<>', 2)
            ->select('orgo_goo_id', 'orgo_goo_price', 'orgo_id')
            ->get();

        // 门店版 查询门店版本
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        $shop_versions = DB::table('shop')
            ->where('shop_id', $shop_id)
            ->value('shop_versions');
        if ($shop_versions == 1) {
            // 获取工单旧货回收单id
            $old_goods_jur_id = DB::table('junk_recycle')
                ->where('jur_wor_number', $work_data->wor_number)
                ->value('jur_id');
            $data['junk_data'] = (object)[];
            $data['junk_goods_data'] = [];
            $data['warehouse_data'] = [];
            if ($old_goods_jur_id && $work_data->wor_audit_times == 0) {
                // 获取旧货回收单数据
                $find_junk = DB::table('junk_recycle as a')
                    ->leftJoin('admin as b', 'b.adm_id', '=', 'a.jur_create_adm_id')
                    ->where('jur_id', $old_goods_jur_id)
                    ->select('adm_name as jur_create_adm_name', 'jur_id', 'jur_number', 'jur_date', 'jur_source', 'jur_amount', 'jur_price', 'jur_wor_id', 'jur_create_adm_id', 'jur_ware_id', 'jur_remark', 'jur_state', 'jur_is_mobile', 'jur_ord_id', 'jur_ord_order_number', 'jur_wor_number', 'jur_service_adm_id', 'jur_type', 'jur_waon_class')
                    ->first();

                // 查询出仓库名称
                $find_junk->ware_name = DB::table('warehouse')
                    ->where('ware_id', $find_junk->jur_ware_id)
                    ->value('ware_name');

                // 获取旧货商品数据
                $find_old_goods = DB::table('junk_goods as jugo')
                    ->leftjoin('goods as goo', 'goo.goo_id', '=', 'jugo.jugo_goo_id')
                    ->where('jugo_jur_id', $old_goods_jur_id)
                    ->select('jugo_goo_id as goo_id', 'jugo_goo_name as goo_name', 'jugo_goo_goods_encode as goo_goods_encode', 'jugo_goo_price as goo_price', 'jugo_sell_number as goo_amount', 'jugo_recycle_number as goo_recycle_amount', 'jugo_remark as goo_remark', 'jugo_goo_ampere_hour', 'goo_class', 'goo_brse_id', 'goo_bra_name')
                    ->get()->toArray();
                $find_old_goods = json_decode(json_encode($find_old_goods), true);
                // 查询系列数据
                $goo_brse_id = array_column($find_old_goods, 'goo_brse_id');
                $brse_data = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->pluck('brse_name', 'brse_id')
                    ->toArray();
                foreach ($find_old_goods as $key => $value) {
                    // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                        if (!empty($value['goo_brse_id'])) {
                            if ($value['goo_class'] == 2) {
                                $find_old_goods[$key]['goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['goo_name'];
                            } else {
                                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $find_old_goods[$key]['goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['goo_name'];
                                }
                            }
                        }
                    }
                    // 显示品牌名称
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                        if ($value['goo_class'] == 2) {
                            $find_old_goods[$key]['goo_name'] = $value['goo_bra_name'] . ' ' . $find_old_goods[$key]['goo_name'];
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $find_old_goods[$key]['goo_name'] = $value['goo_bra_name'] . ' ' . $find_old_goods[$key]['goo_name'];
                            }
                        }
                    }
                    unset($find_old_goods[$key]['goo_class']);
                    unset($find_old_goods[$key]['goo_brse_id']);
                }
                // 查询当前账号所拥有的仓库权限
                $adms_ware_id = DB::table('admin_set')
                    ->where('adms_adm_id', $user_info->adm_id)
                    ->where('adms_shop_id', $user_info->adm_shop_id)
                    ->value('adms_ware_id');
                $adms_ware_id = explode(',', $adms_ware_id);

                // 搜索仓库
                $find_ware = DB::table('warehouse')
                    ->where('ware_cid', $user_info->adm_cid)
                    ->where('ware_superior_shop_id', $shop_id)
                    ->where('ware_state', 1)
                    ->whereIn('ware_id', $adms_ware_id)
                    ->get(['ware_id', 'ware_name']);

                $data['junk_data'] = $find_junk;
                $data['junk_goods_data'] = $find_old_goods;
                $data['warehouse_data'] = $find_ware;
            }

            // 获取退换回收单id
            $change_goods_rec_id = DB::table('recede_recycle')
                ->where('rec_ord_order_number', $work_data->wor_number)
                ->where('rec_state', 1)
                ->value('rec_id');
            if ($change_goods_rec_id) {
                // 获取退换回收单数据
                $find_recede = DB::table('recede_recycle as re')
                    ->leftjoin('admin as a', 'a.adm_id', '=', 're.rec_create_adm_id')
                    ->leftjoin('recede_client as recl', 'recl.recl_rec_id', '=', 're.rec_id')
                    ->where('rec_id', $change_goods_rec_id)
                    ->first(['rec_number', 'rec_ord_id', 'rec_ord_order_number', 'rec_create_time', 'rec_state', 'rec_amount', 'rec_remark', 'rec_date', 'rec_price', 'rec_mobile_ware_id', 'rec_source_type', 'rec_ware_id', 'adm_name as rec_create_adm_name', 'rec_waon_class', 'rec_id', 'rec_type', 'recl_client_id', 'recl_channel_unit', 'recl_name']);

                // 查询出仓库名称
                $find_recede->ware_name = DB::table('warehouse')
                    ->where('ware_id', $find_recede->rec_ware_id)
                    ->value('ware_name');

                // 获取退换商品数据
                $find_change_goods = DB::table('recede_goods as rego')
                    ->leftjoin('goods as goo', 'goo.goo_id', '=', 'rego.rego_goo_id')
                    ->where('rego_rec_id', $change_goods_rec_id)
                    ->select('rego_goo_id as goo_id', 'rego_goo_name as goo_name', 'rego_goo_goods_encode as goo_goods_encode', 'rego_goo_price as goo_price', 'rego_sell_number as goo_amount', 'rego_recycle_number as goo_recycle_amount', 'rego_fine_quantity', 'rego_priority_quantity', 'rego_unchecked_quantity', 'rego_ware_id', 'rego_waon_class', 'rego_wago_id', 'goo_type', 'goo_class', 'goo_brse_id', 'goo_bra_name')
                    ->get()->toArray();
                $find_change_goods = json_decode(json_encode($find_change_goods), true);
                // 查询系列数据
                $goo_brse_id = array_column($find_change_goods, 'goo_brse_id');
                $brse_data = DB::table('brand_serie')
                    ->whereIn('brse_id', $goo_brse_id)
                    ->pluck('brse_name', 'brse_id')
                    ->toArray();
                foreach ($find_change_goods as $key => $value) {
                    // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                        if (!empty($value['goo_brse_id'])) {
                            if ($value['goo_class'] == 2) {
                                $find_change_goods[$key]['goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['goo_name'];
                            } else {
                                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                    $find_change_goods[$key]['goo_name'] = $brse_data[$value['goo_brse_id']] . ' ' . $value['goo_name'];
                                }
                            }
                        }
                    }
                    // 显示品牌名称
                    if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                        if ($value['goo_class'] == 2) {
                            $find_change_goods[$key]['goo_name'] = $value['goo_bra_name'] . ' ' . $find_change_goods[$key]['goo_name'];
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $find_change_goods[$key]['goo_name'] = $value['goo_bra_name'] . ' ' . $find_change_goods[$key]['goo_name'];
                            }
                        }
                    }
                    unset($find_change_goods[$key]['goo_class']);
                    unset($find_change_goods[$key]['goo_brse_id']);
                }
                $data['recede_data'] = $find_recede;
                $data['recede_goods_data'] = $find_change_goods;
            } else {
                $data['recede_data'] = (object)[];
                $data['recede_goods_data'] = [];
            }
        }

        if ($new_new_goo_datas) {
            foreach ($new_new_goo_datas as $key => $value) {
                foreach ($order_goods as $k => $v) {
                    if ($value['wogo_orgo_id'] == $v->orgo_id) {
                        $new_new_goo_datas[$key]['orgo_goo_price'] = $v->orgo_goo_price;
                    }
                }
            }
        }
        $work_data->orcl_rescue_service_price = $ord_info->orcl_rescue_service_price ?? 0;
        // 查询备注信息
        $wor_reamrks = DB::table('order_remarks')
            ->where('orre_wor_id', $request['wor_id'])
            ->select('orre_create_adm_name', 'orre_content', 'orre_time', 'orre_module')
            ->orderby('orre_id', 'desc')
            ->get()->toArray();
        $data['image_upload'] = $find_image_upload;
        $data['wor_data'] = $work_data;
        $data['work_goods'] = $new_new_goo_datas;
        $data['wor_reamrks'] = $wor_reamrks;
        return ['code'=>200, 'msg'=>'success', 'data'=>$data];
    }

    /**
     * sendAssing 派单
     *
     * @param [type] $user_info     用户信息
     * @param [type] $request       提交信息
     * @param [type] $type          1派单2改派技师
     * @param [type] $select_field  [查询字段，字符串多个字段用,分开]
     * @return void
     */
    public function sendAssing(
        $user_info,
        $request,
        $type,
        $find_wor
    ) {
        // 如果是虚拟加盟店
        if ($find_wor->wocl_wor_type == 4) {
            if (empty($request['service_shop_id'])) {
                return ['code'=>500, 'msg'=>'参数错误', 'data'=>'参数错误'];
            }
        }
        if ($type == 1) {
            $type = '派单';
        } else {
            $type = '改派技师';
        }

        // 查询APP拒单、终止生成的退换回收单是否入库
        $find_rec_data = DB::table('recede_recycle')
            ->where('rec_ord_id', $request['wor_id'])
            ->whereIn('rec_source_type', [6, 7])
            ->select('rec_state', 'rec_number')
            ->orderBy('rec_id', 'desc')
            ->first();
        if ($find_rec_data && $find_rec_data->rec_state == 1) {
            return ['code'=>500, 'msg'=>'当前工单已拒单商品未入库，无法派单！', 'data'=>'当前工单已拒单商品未入库，无法派单！'];
        }

        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 查询出原工单的仓库类型是固定仓 还是 移动仓 ware_type 1固定仓2技师库3移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $find_wor->wor_ware_id)
            ->value('ware_type');
        if (($ware_type == 2) && ($find_wor->wocl_wor_type != 4)) {
            // 查询派单技师的移动仓库id
            $ware_id = DB::table('warehouse')
                ->where('ware_leader_id', $request['wor_service_adm_id'])
                ->where('ware_type', 2)
                ->value('ware_id');
            // 把工单表中仓库id改成现在选择的技师的仓库id
            $wor_data['wor_ware_id'] = $ware_id; //仓库id
            // 查询每个商品要减的库存
            $work_good = DB::table('work_good')
                ->where('wogo_wor_id', $request['wor_id'])
                ->whereIn('wogo_state', [1, 5, 6, 7, 8]) //商品状态1.正常 2.删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
                ->select('wogo_goo_id', 'wogo_waon_class', 'wogo_goo_inventory', 'wogo_goo_amount')
                ->get()->toArray();
            // 救援单类型的可能没有商品，有商品的判断库存
            if (!empty($work_good)) {
                // 查询出仓库这些商品数量是否够减
                $wogo_goo_id = array_column($work_good, 'wogo_goo_id');
                $wogo_waon_class = array_unique(array_column($work_good, 'wogo_waon_class'));
                $warehouse_goods = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $ware_id)
                    ->whereIn('wago_class', $wogo_waon_class)
                    ->whereIn('wago_goo_id', $wogo_goo_id)
                    ->select('wago_goo_id', 'wago_class', 'wago_stock_number', 'wago_priority_stock_number')
                    ->get()->toArray();

                // 将查询的数据循环遍历为二维数组
                foreach ($work_good as $key => $value) {
                    // data[仓库类别][商品id]
                    if (isset($goo_class_data[$value->wogo_waon_class][$value->wogo_goo_id]['wago_stock_number'])) {
                        $goo_class_data[$value->wogo_waon_class][$value->wogo_goo_id]['wago_stock_number'] = $goo_class_data[$value->wogo_waon_class][$value->wogo_goo_id]['wago_stock_number'] + $value['wago_stock_number'];
                    } else {
                        $goo_class_data[$value->wogo_waon_class][$value->wogo_goo_id] = (array)$value;
                    }
                }
                foreach ($warehouse_goods as $key => $value) {
                    $wago_class_data[$value->wago_class][$value->wago_goo_id] = (array)$value;
                }
                // 判断仓库商品库存数量是否足够
                foreach ($goo_class_data as $waon_class_key => $goods_data) {
                    foreach ($goods_data as $goo_id_key => $value) {
                        // 判断商品出库类型
                        if ($value['wogo_goo_inventory'] == 1) { //良品出库
                            // 仓库内商品剩余库存数量
                            $surplus_quantity = $wago_class_data[$waon_class_key][$goo_id_key]['wago_stock_number'] - $value['wogo_goo_amount'];
                        } else { //优先出库
                            $surplus_quantity = $wago_class_data[$waon_class_key][$goo_id_key]['wago_priority_stock_number'] - $value['wogo_goo_amount'];
                        }
                        if ($surplus_quantity < 0) {
                            return ['code'=>500, 'msg'=>'仓库内商品数量不足', 'data'=>'仓库内商品数量不足'];
                        }
                    }
                }
            }
            $wago_res = true;
            $waon_fine_res = true;
            $waon_priority_res = true;
        } elseif ($find_wor->wocl_wor_type == 4) { //虚拟加盟店
            $wago_res = true;
            $waon_priority_res = true;
            $waon_fine_res = true;
        } else {
            // 判断是否有商品数据
            $wogo_id = DB::table('work_good')
                ->where('wogo_wor_id', $request['wor_id'])
                ->where('wogo_goo_type', 1)
                ->value('wogo_id');
            // 如果不是退货单,生成发货单,减库存
            if ($find_wor->wor_service_type != 4 && !empty($wogo_id) && empty($find_wor->wor_service_adm_id)) {
                // 固定仓 生成发货单
                // 1. 发货单表添加数据
                $dego_number = 'FH' . time() . rand(100, 999);
                $bill_data['dego_cid'] = $user_info->adm_cid; //公司id
                $bill_data['dego_shop_id'] = $user_info->adm_shop_id; //门店id
                $bill_data['dego_superior_shop_id'] = $shop_id; //所属总店id
                $bill_data['dego_number'] = $dego_number; //发货单号
                $bill_data['dego_wor_id'] = $request['wor_id']; //发货单关联的工单id
                $bill_data['dego_original_number'] = $find_wor->wor_number; //原始单号,发货单的关联单号(工单号)
                $bill_data['dego_client_type'] = $find_wor->wor_type; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $bill_data['dego_client_id'] = $find_wor->wocl_client_id; //选择的客户id,会员id/单位id
                $wor_goo_amount = DB::table('work_good')
                    ->leftjoin('order_goods', 'orgo_id', '=', 'wogo_orgo_id')
                    ->where('orgo_goo_is_send', '!=', 2)
                    ->where('wogo_wor_id', $request['wor_id'])
                    ->sum('wogo_goo_amount');
                $bill_data['dego_count'] = $wor_goo_amount; //发货总数量
                $bill_data['dego_out_ware_id'] = $find_wor->wor_ware_id; //出库仓库id
                $bill_data['dego_service_shop_id'] = $find_wor->wor_service_shop_id; //服务门店id
                $bill_data['dego_service_adm_id'] = $request['wor_service_adm_id']; //服务技师id
                $bill_data['dego_type'] = 1; //类型：1未出库2已出库
                $bill_data['dego_order_type'] = 2; //类型：1.订单发货 2.工单发货
                $bill_data['dego_create_adm_id'] = $user_info->adm_id; //创建人id
                $bill_data['dego_remark'] = $find_wor->wor_remark; //备注
                $dispatch_bill = DB::table('dispatch_bill')->insertGetId($bill_data);

                DB::table('warehouse_goods_lock')
                    ->where('wagl_original_id', $find_wor->wor_order_id)
                    ->where('wagl_original_number', $find_wor->wor_order_number)
                    ->update(['wagl_original_correlation_id' => $dispatch_bill]);

                // 查询出工单下的商品
                $goods = DB::table('work_good')
                    ->where('wogo_wor_id', $request['wor_id'])
                    ->where('wogo_goo_type', 1)
                    ->whereIn('wogo_state', [1, 5, 6, 7, 8]) //商品状态1.正常 2.删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品
                    ->select('wogo_goo_id', 'wogo_waon_class', 'wogo_goo_amount', 'wogo_goo_inventory', 'wogo_goo_name', 'wogo_goo_price', 'wogo_goo_type', 'wogo_is_recycle', 'wogo_goo_goods_encode', 'wogo_state', 'wogo_wago_id', 'wogo_wafr_id', 'wogo_wafg_id', 'wogo_orgo_id', 'wogo_goo_unit', 'wogo_goo_unta_id')
                    ->get()->toArray();
                $goods = json_decode(json_encode($goods), true);
                // 2. 发货单商品表添加数据
                $goo_all_quantity = 0;
                $goo_all_fine = 0;
                $goo_all_priority = 0;
                $wago_class = [];
                foreach ($goods as $key => $value) {
                    // 发货商品表数据
                    $digo_data[$key]['digo_dego_id'] = $dispatch_bill;
                    $digo_data[$key]['digo_wago_id'] = $value['wogo_wago_id']; //仓库商品id
                    $digo_data[$key]['digo_orgo_id'] = $value['wogo_orgo_id']; //仓库商品id
                    $digo_data[$key]['digo_wafr_id'] = $value['wogo_wafr_id']; //仓位id
                    $digo_data[$key]['digo_wafg_id'] = $value['wogo_wafg_id']; //仓位商品id
                    $digo_data[$key]['digo_wago_class'] = $value['wogo_waon_class']; //仓库类别
                    $digo_data[$key]['digo_goo_id'] = $value['wogo_goo_id']; //商品id
                    $digo_data[$key]['digo_goo_type'] = $value['wogo_goo_type']; //商品类型 1正常商品2赠品商品3活动商品4旧货商品
                    $digo_data[$key]['digo_goo_name'] = $value['wogo_goo_name']; //商品名称
                    $digo_data[$key]['digo_goo_price'] = $value['wogo_goo_price']; //商品金额
                    $digo_data[$key]['digo_goo_quantity'] = $value['wogo_goo_amount']; //商品数量
                    $digo_data[$key]['digo_goo_goods_encode'] = $value['wogo_goo_goods_encode']; //检索编码
                    $digo_data[$key]['digo_goo_inventory'] = $value['wogo_goo_inventory']; //出库方式1.良品 2.优先
                    $digo_data[$key]['digo_is_recycle'] = $value['wogo_goo_inventory']; //是否回收1.回收2.不回收
                    $digo_data[$key]['digo_state'] = $value['wogo_state']; //是否回收1.回收2.不回收
                    if ($value['wogo_goo_type'] == 1) {
                        if (empty($value['wogo_goo_unit']) || empty($value['wogo_goo_unta_id'])) {
                            return ['code'=>500,'msg'=>'请选择单位','data'=>'请选择单位'];
                        }
                    }
                    $digo_data[$key]['digo_goo_unit'] = empty($value['wogo_goo_unit']) ? '' : $value['wogo_goo_unit'];
                    $digo_data[$key]['digo_goo_unta_id'] = empty($value['wogo_goo_unta_id']) ? '' : $value['wogo_goo_unta_id'];
                    // 商品id
                    $goo_id[$key] = $value['wogo_goo_id'];
                    $number[$key] = $value['wogo_goo_amount'];
                    $inventory[$key] = $value['wogo_goo_inventory'];
                    // 商品id和所对应的商品数量
                    $subtract[$value['wogo_goo_id']] = $value['wogo_goo_amount'];
                    $wago_class[$key] = $value['wogo_waon_class']; //仓库类别
                    // 每个商品对应的出库方式
                    $goo_repertory[$value['wogo_goo_id']] = $value['wogo_goo_inventory'];
                    // 商品总数量
                    $goo_all_quantity += $value['wogo_goo_amount'];

                    if ($value['wogo_goo_inventory'] == 1) {
                        $goo_all_fine += $value['wogo_goo_amount']; //1.良品
                    } else {
                        $goo_all_priority += $value['wogo_goo_amount']; //2.优先
                    }

                    $wago_class_goods[$value['wogo_waon_class']][$value['wogo_goo_id']] = (array) $value; //仓库类型对应的商品，进销存计算
                }
                $dispatch_goods = DB::table('dispatch_goods')->insert($digo_data);
                $wago_res = true;
                $waon_priority_res = true;
                $waon_fine_res = true;
            } elseif ($find_wor->wor_service_type != 4 && !empty($wogo_id) && !empty($find_wor->wor_service_adm_id)) {
                $waon_priority_res = true;
                $waon_fine_res = true;

                $wago_res = DB::table('dispatch_bill')
                    ->where('dego_wor_id', $request['wor_id'])
                    ->where('dego_service_adm_id', $find_wor->wor_service_adm_id)
                    ->where('dego_type', 1)
                    ->update(['dego_service_adm_id' => $request['wor_service_adm_id'], 'dego_update_time' => date('Y-m-d H:i:s')]);
            } else {
                $wago_res = true;
                $waon_priority_res = true;
                $waon_fine_res = true;
            }
        }
        $service_adm_data = json_decode($request['service_adm_data'], true);
        $request['service_adm_id'] = $service_adm_data[0]['adm_id'];
        // 更改工单表数据
        $wor_data['wor_create_id'] = $user_info->adm_id; //派单人
        $wor_data['wor_service_adm_id'] = $request['service_adm_id'];
        $wor_data['wor_explain'] = isset($request['wor_explain']) ? $request['wor_explain'] : '';
        $wor_data['wor_appoint_time'] = isset($request['orcl_appoint_time']) ? $request['orcl_appoint_time'] :$find_wor->wor_appoint_time;
        $wor_data['wor_address'] = isset($request['wor_address']) ? $request['wor_address'] : '';
        $wor_data['wor_address_id'] = isset($request['wor_address_id']) ? $request['wor_address_id'] : '';
        $wor_data['wor_address_type'] = isset($request['wor_address_type']) ? $request['wor_address_type'] : '';
        $wor_data['wor_service_state'] = 1; //服务状态：1待接单2已接单
        $wor_data['wor_state'] =  3; //1.新订单 2未派单 3待接单/已派单 4.未出发/已接单
        $wor_data['wor_update_time'] =  date('Y-m-d H:i:s');
        if (!empty($request['service_shop_id'])) {
            $wor_data['wor_service_shop_id'] =  $request['service_shop_id'];
            $ord_res = DB::table('order')
                ->where('ord_id', $find_wor->wor_order_id)
                ->update(['ord_service_shop_id' => $request['service_shop_id'], 'ord_update_time' => date('Y-m-d H:i:s')]);
        } else {
            $ord_res = true;
        }
        $wor_id = DB::table('work_order')->where('wor_id', $request['wor_id'])->update($wor_data);

        // 生成操作记录
        $assign_record = orderLog($user_info, 0, $request['wor_id'], $type);
        if ($wor_id && $assign_record && $waon_priority_res && $waon_fine_res && $wago_res && $ord_res) {
            // 添加新增订单信息的提示
            $inhi_data['inhi_original_adm_id'] = $find_wor->wor_create_id; //原始单号创建人
            $inhi_data['inhi_original_id'] = $request['wor_id']; //原始单id
            $inhi_data['inhi_original_number'] = $find_wor->wor_number; //原始单号
            $inhi_data['inhi_original_state'] = $wor_data['wor_state']; //原始单状态
            $inhi_data['inhi_original_operation'] = '工单派单'; //操作
            $inhi_data['inhi_operation_state'] = 14; //操作状态：14工单派单
            addInformationHint($user_info, $inhi_data, 2);
            return ['code'=>200, 'msg'=>'派单成功', 'data'=>'派单成功'];
        } else {
            return ['code'=>500, 'msg'=>'派单失败', 'data'=>'派单失败'];
        }
    }

    /**
     * deletes 取消工单
     *
     * @param [type] $user_info     用户信息
     * @param [type] $request       提交信息
     * @param [type] $find_order    订单信息
     * @param [type] $type          1、小程序2、PC端
     * @return void
     */
    public function deletes(
        $user_info,
        $request,
        $find_wor
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 查询APP拒单、终止生成的退换回收单是否入库
        $find_rec_data = DB::table('recede_recycle')
            ->where('rec_ord_id', $request['wor_id'])
            ->whereIn('rec_source_type', [6, 7])
            ->select('rec_state', 'rec_number')
            ->orderBy('rec_id', 'desc')
            ->first();
        if ($find_rec_data && $find_rec_data->rec_state == 1) {
            return ['code'=>500, 'msg'=>'当前工单已拒单商品未入库，无法取消工单！', 'data'=>'当前工单已拒单商品未入库，无法取消工单！'];
        }

        // 获取工单相关的数据
        $work_goods = DB::table('work_good')
            ->where('wogo_wor_id', $request['wor_id'])
            ->select('wogo_goo_id', 'wogo_goo_amount', 'wogo_goo_price', 'wogo_goo_name', 'wogo_goo_goods_encode', 'wogo_ware_id', 'wogo_waon_class', 'wogo_wago_id')
            ->get()->toARray();
        foreach ($work_goods as $key => $value) {
            $goo_id[] = $value->wogo_goo_id;
            $goo_amount[$value->wogo_goo_id] = $value->wogo_goo_amount;

            // 组合退换回收商品表数据
            $rego_data[$key]['rego_ware_id'] = $value->wogo_ware_id; //仓库id
            $rego_data[$key]['rego_waon_class'] = $value->wogo_waon_class; //仓库类别
            $rego_data[$key]['rego_wago_id'] = $value->wogo_wago_id; //仓库商品id
            $rego_data[$key]['rego_goo_id'] = $value->wogo_goo_id; //商品id
            $rego_data[$key]['rego_goo_name'] = $value->wogo_goo_name; //商品名称
            $rego_data[$key]['rego_goo_goods_encode'] = $value->wogo_goo_goods_encode; //检索编码
            $rego_data[$key]['rego_goo_price'] = $value->wogo_goo_price; //回收价格（单位：分）
            $rego_data[$key]['rego_sell_number'] =  $value->wogo_goo_amount; //销售数量
            $rego_data[$key]['rego_recycle_number'] =  $value->wogo_goo_amount; //回收数量
        }

        // ware_type 类型：1固定仓2技师库3移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $find_wor->wor_ware_id)
            ->value('ware_type');
        // 速电派单的情况，需要取消锁定库存
        if (($find_wor->wor_type == 3 && $find_wor->wocl_sd_virtual_type == 2 && $ware_type != 2) || $find_wor->wor_type == 5) {
            // 查询工单商品信息
            $find_work_goods = DB::table('work_good')
                ->where('wogo_wor_id', $request['wor_id'])
                ->whereNotIn('wogo_state', [2, 3, 4])
                ->select('wogo_ware_id', 'wogo_waon_class', 'wogo_wago_id', 'wogo_actual_goo_id', 'wogo_goo_id', 'wogo_goo_amount', 'wogo_goo_inventory')
                ->get()->toArray();
            foreach ($find_work_goods as $key => $value) {
                // 订单锁定库存是后面加的，之前有一些订单商品的商品id、实际出库商品id、库存商品id数据不正确，所以需要查询库存商品表数据，确保数据不出错；之前的数据修正后，可以不用查询库存商品表
                $find_wago_data = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $find_wor->wor_ware_id)
                    ->where('wago_class', $value->wogo_waon_class)
                    ->where('wago_goo_id', $value->wogo_goo_id)
                    ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id')
                    ->first();

                $ware_id[$find_wago_data->wago_id] = $find_wago_data->wago_ware_id;
                $wago_goo_id[$find_wago_data->wago_id] = $find_wago_data->wago_goo_id;
                if (isset($wago_goo_quantity[$find_wago_data->wago_id])) {
                    $wago_goo_quantity[$find_wago_data->wago_id] = $wago_goo_quantity[$find_wago_data->wago_id] + $value->wogo_goo_amount;
                } else {
                    $wago_goo_quantity[$find_wago_data->wago_id] = $value->wogo_goo_amount;
                }

                $wago_goo_inventory[$find_wago_data->wago_id] = $value->wogo_goo_inventory;
                $wago_goo_class[$find_wago_data->wago_id] = $value->wogo_waon_class;
                $wago_id[] = $find_wago_data->wago_id;
            }
            $find_order = DB::table('order as o')
                ->leftJoin('order_client as oc', 'oc.orcl_ord_id', '=', 'o.ord_id')
                ->where('ord_id', $find_wor->wor_order_id)
                ->select('ord_order_number', 'ord_state', 'ord_delete', 'ord_wor_quantity', 'ord_wor_state', 'ord_service_type', 'ord_type', 'ord_client_id', 'ord_goods_quantity', 'ord_actual_price', 'ord_service_shop_id', 'ord_create_id', 'orcl_shipment_party', 'ord_ware_id', 'ord_create_time')
                ->first();
            // 查询订单商品信息
            $find_order_goods = DB::table('order_goods')
                ->where('orgo_ord_id', $find_wor->wor_order_id)
                ->whereNotIn('orgo_state', [2, 3, 4])
                ->select('orgo_ware_id', 'orgo_waon_class', 'orgo_wago_id', 'orgo_goo_id', 'orgo_goo_quantity', 'orgo_goo_inventory', 'orgo_wafr_id', 'orgo_wafg_id')
                ->get()->toArray();
            $request['ord_id'] = $find_wor->wor_order_id;
            // ware_type 类型：1固定仓2技师库3移动仓
            $ware_type = DB::table('warehouse')
                ->where('ware_id', $find_order->ord_ware_id)
                ->value('ware_type');
            $request['orcl_shipment_party'] = $find_order->orcl_shipment_party;
            // 取消仓库库存锁定
            $order_lock_retrun = Order::cancelOrderChangeWafgstock(
                $user_info,
                $ware_type,
                $request,
                $find_order_goods,
                $find_order
            );
            $ord_update_data['ord_ware_id'] = 0;
            $ord_update_data['ord_update_time'] = date('Y-m-d H:i:s');
            $ord_del_res = DB::table('order')
                ->where('ord_id', $find_wor->wor_order_id)
                ->where('ord_shop_id', $user_info->adm_shop_id)
                ->update($ord_update_data);
            if (!$order_lock_retrun || !$ord_del_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'取消工单失败01！'];
            }
            if ($find_wor->wor_service_type != 4) {
                $wagl_res = DB::table('warehouse_goods_lock')
                    ->where('wagl_original_id', $find_wor->wor_order_id)
                    ->where('wagl_original_number', $find_wor->wor_order_number)
                    ->delete();
            } else {
                $wagl_res = true;
            }
        } elseif ($find_wor->wocl_sd_virtual_type == 2 && $find_wor->wor_type != 3 && $find_wor->wocl_wor_type != 4 && $find_wor->wocl_wor_type != 2 && $find_wor->wor_service_type != 4) {
            $wagl_res = DB::table('warehouse_goods_lock')
                ->where('wagl_original_id', $find_wor->wor_order_id)
                ->where('wagl_original_number', $find_wor->wor_order_number)
                ->update(['wagl_original_correlation_id' => $find_wor->wor_order_id, 'wagl_correlation_type' => 1]);
        } else {
            $wagl_res = true;
        }
        // 查询工单所属的订单信息
        $order_data = DB::table('order')
            ->where('ord_id', $find_wor->wor_order_id)
            ->first(['ord_goods_quantity', 'ord_wor_quantity', 'ord_wor_state']);

        $ord_edit_data['ord_wor_quantity'] = $order_data->ord_wor_quantity - 1; //工单数量
        if ($ord_edit_data['ord_wor_quantity'] <= 0) {
            $ord_edit_data['ord_wor_state'] = 1; //订单的工单状态1未派工单2服务中
        } else {
            $ord_edit_data['ord_wor_state'] = 2; //订单的工单状态1未派工单2服务中
        }
        $ord_edit_data['ord_update_time'] = date('Y-m-d H:i:s');
        // 1. 取消工单相关数据 ord_wor_state 9速电撤销回收
        if ($find_wor->wor_type == 3 && $find_wor->wocl_sd_virtual_type == 2 && $ware_type != 2 && $order_data->ord_wor_state == 9) { //查询是否是速电的单子并且是撤销状态
            $update_data['wor_state'] = 13; //工单状态：13已撤回
            $update_data['wor_service_state'] = 11; //服务状态：11已撤回
            $ord_edit_res = true;
        } else {
            $update_data['wor_delete'] = 2;
            // 2. 更改订单信息
            $ord_edit_res = DB::table('order')
                ->where('ord_id', $find_wor->wor_order_id)
                ->update($ord_edit_data);
        }
        $update_data['wor_remark'] = $request['remark'];
        $update_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_del_res = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->update($update_data);

        if (!empty($work_goods)) {
            // 3.将工单的商品还回到订单
            $order_goods_data = DB::table('order_goods')
                ->where('orgo_ord_id', $find_wor->wor_order_id)
                ->whereIn('orgo_goo_id', $goo_id)
                ->select('orgo_id', 'orgo_goo_id', 'orgo_can_assign_quantity')
                ->get();
            // 4.1.2 更新销售出库单商品的实际出库数量
            $sql = 'UPDATE `faster_order_goods` SET ';
            $actual_number_sql = '';
            $update_time_sql = '';
            $ids = '';
            foreach ($order_goods_data as $key => $value) {
                // 商品实际出库数量
                // 更改商品库存数量
                $actual_number_sql = $actual_number_sql . ' WHEN ' . $value->orgo_id;
                $actual_number_sql = $actual_number_sql . ' THEN ' . ($value->orgo_can_assign_quantity + $goo_amount[$value->orgo_goo_id]);
                // 更改时间
                $update_time_sql = $update_time_sql . ' WHEN ' . $value->orgo_id;
                $update_time_sql = $update_time_sql . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $value->orgo_id . ',';
            }
            $sql = $sql . ' `orgo_can_assign_quantity`=  CASE `orgo_id` ' . $actual_number_sql . ' END,';
            $sql = $sql . ' `orgo_update_time`=  CASE `orgo_id` ' . $update_time_sql . ' END';
            $sql = $sql . ' WHERE `orgo_id` IN (' . trim($ids, ',') . ')';
            $orgo_res = DB::update($sql);
            if (!$orgo_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'取消订单失败！'];
            }

            // 5.判断该订单是否有未发货的 发货单 有则作废
            $dego_data = DB::table('dispatch_bill')
                ->where('dego_shop_id', $user_info->adm_shop_id)
                ->where('dego_order_type', 2)
                ->where('dego_wor_id', $request['wor_id'])
                ->where('dego_type', 1)
                ->first(['dego_id', 'dego_out_ware_id', 'dego_count', 'dego_number']);
            // 根据仓库id,判断仓库是移动仓还是固定仓
            $ware_type =  DB::table('warehouse')
                ->where('ware_id', $find_wor->wor_ware_id)
                ->value('ware_type');
            if (!empty($dego_data->dego_id) && $ware_type == '1') {
                // 作废原来的发货单
                $update_type['dego_type'] = 3;
                $update_type['dego_update_time'] = date('Y-m-d H:i:s');
                $dego_type = DB::table('dispatch_bill')
                    ->where('dego_id', $dego_data->dego_id)
                    ->update($update_type);

                // 查询出原来发货单的商品
                $dis_goods = DB::table('dispatch_goods')
                    ->where('digo_dego_id', $dego_data->dego_id)
                    ->get(['digo_goo_id', 'digo_goo_quantity', 'digo_goo_inventory'])
                    ->toArray();
                $goo_all_fine = 0;
                $goo_all_priority = 0;
                $goo_all_quantity = 0;
                foreach ($dis_goods as $key => $value) {
                    // 商品id
                    $goo_id[$key] = $value->digo_goo_id;
                    $goo_number[$key] = $value->digo_goo_quantity;
                    $inventory[$key] = $value->digo_goo_inventory;

                    // 商品id所对应的商品数量
                    $subtract[$value->digo_goo_id] = $value->digo_goo_quantity;
                    // 商品id所对应的出库方式
                    $goo_repertory[$value->digo_goo_id] = $value->digo_goo_inventory;
                    // 商品总数量
                    $goo_all_quantity += $value->digo_goo_quantity;

                    if ($value->digo_goo_inventory == 1) {
                        $goo_all_fine += $value->digo_goo_quantity; //1.良品
                    } else {
                        $goo_all_priority += $value->digo_goo_quantity; //2.优先
                    }
                }

                // 仓库商品表 减锁定库存 加原来的库存
                $sql = 'UPDATE `faster_warehouse_goods` SET ';
                $stock_fine_sql = '';
                $lock_fine_sql = '';
                $stock_priority_sql = '';
                $lock_priority_sql = '';
                $time_sql = '';
                $ids = '';

                foreach ($goo_id as $key => $value) {
                    if ($goo_repertory[$value->digo_goo_id] == 1) { //良品
                        $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $value . ' THEN `wago_stock_number` + ' . $subtract[$key];
                        $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $value . ' THEN `wago_lock_quantity` - ' . $subtract[$key];
                    } else { //优先
                        $stock_priority_sql = $stock_priority_sql . ' WHEN ' . $value . ' THEN `wago_priority_stock_number` + ' . $subtract[$key];
                        $lock_priority_sql = $lock_priority_sql . ' WHEN ' . $value . ' THEN `wago_priority_lock_quantity` - ' . $subtract[$key];
                    }

                    // 更改时间
                    $time_sql = $time_sql . ' WHEN ' . $value . ' THEN "' . date('Y-m-d H:i:s') . '"';
                    $ids = $ids . $value . ',';
                }
                $sql = $sql . ' `wago_stock_number`=  CASE `wago_goo_id` ' . $stock_fine_sql . ' END,';
                $sql = $sql . ' `wago_lock_quantity`=  CASE `wago_goo_id` ' . $lock_fine_sql . ' END,';
                $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_goo_id` ' . $stock_priority_sql . ' END,';
                $sql = $sql . ' `wago_priority_lock_quantity`=  CASE `wago_goo_id` ' . $lock_priority_sql . ' END,';
                $sql = $sql . ' `wago_update_time`=  CASE `wago_goo_id` ' . $time_sql . ' END';
                $sql = $sql . ' WHERE `wago_ware_id` = ' . $dego_data->dego_out_ware_id . ' AND `wago_goo_id` IN (' . trim($ids, ',') . ')';
                $update_ware_goo = DB::update($sql);

                // 仓库表加原来的库存 减锁定库存
                $warehouse_sql = 'UPDATE `faster_warehouse` SET  `ware_all_stock`= `ware_all_stock`+' . $goo_all_fine . ' , `ware_lock_quantity`= `ware_lock_quantity` - ' . $goo_all_fine . ', `wago_priority_stock_number`= `wago_priority_stock_number` + ' . $goo_all_priority . ', `wago_priority_lock_quantity`= `wago_priority_lock_quantity` - ' . $goo_all_priority . '  WHERE  `ware_id` =' . $dego_data->dego_out_ware_id;
                $update_ware = DB::update($warehouse_sql);

                $surplus = DB::table('warehouse')
                    ->where('ware_id', $dego_data->dego_out_ware_id)
                    ->select('ware_all_stock', 'ware_lock_quantity', 'ware_priority_all_stock', 'ware_priority_lock_quantity', 'ware_unchecked_all_stock')
                    ->first();
                $surplus = DB::table('warehouse_onhand')
                    ->where('waon_id', $dego_data->dego_out_ware_id)
                    ->select('waon_all_amount', 'waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount', 'waon_stock_unchecked_amount')
                    ->first();

                // 3.生成出出库记录
                $oure_data = OutinRecord::addition(
                    $user_info, //用户信息
                    $find_wor->wor_order_id, //原始单的关联id
                    $find_wor->wor_order_number, //原始单的关联单号
                    1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    $find_wor->wor_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $find_wor->wocl_client_id, //选择的客户id,会员id/单位id
                    $dego_data->dego_number, //原始单号
                    0, //入库仓库id
                    $dego_data->dego_out_ware_id, //出库仓库id
                    $goo_all_quantity, //出库的商品总量
                    9, //类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
                    1, //操作类型：1锁定库存2出库3入库4调货5发货
                    $surplus->waon_stock_fine_amount, //良品总库存
                    $surplus->ware_lock_quantity, //良品锁定数量
                    $surplus->ware_priority_all_stock, //优先总库存
                    $surplus->ware_priority_lock_quantity, //优先锁定数量
                    $surplus->ware_unchecked_all_stock, //待检测总库存
                    1, //出入库类型：1出库，2入库
                    $inventory, //数组，出库类型1良品2优先
                    $goo_id, //数组，商品id
                    $goo_number, //数组，商品数量
                    $inventory //数组，出库类型1良品2优先
                );
                if (!$dego_type || !$update_ware_goo || !$update_ware || !$oure_data) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'取消工单失败02！'];
                }
                // 6. 判断工单的仓库是否是固定仓或移动仓 固定仓/移动仓：生成退换回收单
                if ($ware_type == 1 || $ware_type == 3) {
                    // 6.1退换回收单表添加数据
                    $rec_number = 'TH' . rand(100, 999) . date('mdHis') . rand(100000, 999999); // 回收单号

                    $add_recycle['rec_cid'] = $user_info->adm_cid; //公司id
                    $add_recycle['rec_shop_id'] = $user_info->adm_shop_id; //门店id
                    $add_recycle['rec_superior_shop_id'] = $shop_id; //所属总店id
                    $add_recycle['rec_date'] = date('Y-m-d'); //日期
                    $add_recycle['rec_number'] = $rec_number; //回收单号
                    $add_recycle['rec_ord_id'] = $request['wor_id']; //工单id
                    $add_recycle['rec_ord_order_number'] = $find_wor->wor_number; //工单号
                    $add_recycle['rec_source_type'] = 2; //类型
                    $add_recycle['rec_price'] = $find_wor->wor_actual_price; //回收总金额（单位：分）
                    $add_recycle['rec_amount'] = $find_wor->wor_goo_amount; //回收总数量
                    $add_recycle['rec_state'] = 1; //回收状态 1.未回收 2.已回收
                    $add_recycle['rec_type'] = $find_wor->wor_type; //买家类型 1.门店零售 2.来往单位
                    $add_recycle['rec_ware_id'] = $find_wor->wor_ware_id; //仓库id
                    $add_recycle['rec_create_adm_id'] = $user_info->adm_id; //创建人id
                    $add_recycle['rec_remark'] = $find_wor->wor_remark; //备注
                    $recycle_id = DB::table('recede_recycle')->insertGetId($add_recycle);

                    // 6.2退换回收商品表添加数据
                    foreach ($rego_data as $key => $value) {
                        $rego_data[$key]['rego_rec_id'] = $recycle_id;
                    }
                    $add_goods =  DB::table('recede_goods')->insert($rego_data);

                    // 查询出工单客户的数据
                    $work_client = DB::table('work_client')
                        ->where('wocl_wor_id', $request['wor_id'])
                        ->first(['wocl_client_id', 'wocl_name', 'wocl_phone', 'wocl_channel_unit']);

                    // 6.3 退换回收客户表添加数据
                    $jucl_data['recl_rec_id'] = $recycle_id; //回收单id
                    $jucl_data['recl_client_id'] = $work_client->wocl_client_id; //来往单位id/客户id
                    $jucl_data['recl_name'] = $work_client->wocl_name; //客户姓名
                    $jucl_data['recl_phone'] = $work_client->wocl_phone; //联系电话
                    if ($find_wor->wor_type == 2) {
                        $jucl_data['recl_channel_unit'] = $work_client->wocl_channel_unit; //渠道单位
                        $mem_res = true;
                    } else {
                        // 零售类型，会员对应的退货数量加1
                        $mem_res =  DB::table('member')
                            ->where('mem_id', $work_client->wocl_client_id)
                            ->increment('mem_retreat_trade');
                    }
                    $add_client =  DB::table('recede_client')->insert($jucl_data);
                    if (!$recycle_id || !$add_goods || !$mem_res || !$add_client) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'取消工单失败03！'];
                    }
                }
            } else {
                // 没有发货单  不做改变
                $wagl_res = true;
            }
        } else {
            $wagl_res = true;
        }
        // 生成操作记录
        $cancel_record = orderLog($user_info, $find_wor->wor_order_id, 0, '取消工单');

        // 取消工单-》填写备注
        orderRemark($user_info, $find_wor->wor_order_id, $request['wor_id'], $request['remark'], '取消工单');
        if ($wor_del_res && $ord_edit_res && $cancel_record && $wagl_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'取消工单成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'取消工单失败04'];
        }
    }
}
