<?php
namespace App\Http\Models\Services;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use App\Http\Models\Api\OutinRecord;
use App\Http\Models\Services\WarehouseManage\OutinStockLock;
use App\Services\Business\WashOrderService;
use App\Services\Business\WashOrderBasicService;
use App\Services\Business\DeliveryService;

class Dispatch extends Model
{
    /**
     * shipments 发货单发货
     *
     * @param [type] $user_info    用户信息
     * @param [type] $request    提交的数据
     * @param [type] $request_goods_data    提交的商品数据
     * @param [type] $dis_data  发货单数据
     * @param [type] $ware_type     发货仓库类型
     * @param [type] $find_ord_id   订单id
     * @param [type] $find_order_number   订单单号
     * @param [type] $service_ware_id   技师库id
     * @return void
     */
    public static function shipments(
        $user_info,
        $request,
        $request_goods_data,
        $dis_data,
        $ware_type,
        $find_ord_id,
        $find_order_number
    ) {
        if ($dis_data->dego_order_type == '2') {
            $find_order_work = DB::table('work_order as wor')
                ->leftJoin('order as ord', 'ord.ord_id', '=', 'wor.wor_order_id')
                ->leftJoin('dispatch_bill as dis', 'dis.dego_wor_id', '=', 'wor.wor_id')
                ->where('dego_id', $request['dego_id'])
                ->select('ord_id', 'wor_id')
                ->first();
        } elseif ($dis_data->dego_order_type == '1') {
            $find_order_work = DB::table('order as ord')
                ->leftJoin('dispatch_bill as dis', 'dis.dego_wor_id', '=', 'ord.ord_id')
                ->where('dego_id', $request['dego_id'])
                ->select('ord_id')
                ->first();
        }
        // 查询出该发货单的商品
        $find_goods_data = DB::table('dispatch_goods')
            ->where('digo_dego_id', $request['dego_id'])
            ->select('digo_id', 'digo_wago_id', 'digo_goo_id', 'digo_goo_name', 'digo_goo_goods_encode', 'digo_wago_class', 'digo_goo_quantity', 'digo_goo_inventory', 'digo_goo_type', 'digo_state')
            ->get()->toArray();
        
        $digo_goo_quantity = array_sum(array_column($find_goods_data, 'digo_goo_quantity')); //发货单商品发货总数量

        $request_goo_amount = 0; //提交商品出库总数量
        $goo_all_fine = 0; //总的良品出库商品数量
        $goo_all_priority = 0; //总的优先出库商品数量
        $neaten_goods_data = []; //仓库商品数据
        $neaten_wago_id = []; //仓库商品id
        $freight_goods_data = []; //仓位商品数据
        $new_digo_goo_quantity = 0;
        $new_digo_goo_quantitys = 0;
        // 判断提交的商品出库数据是否更改
        foreach ($request_goods_data as $key => $value) {
            $goo_unit_conversion = DB::table('goods')
                ->where('goo_id', $value['digo_goo_id'])
                ->value('goo_unit_conversion');
            $new_digo_goo_quantity = $value['digo_goo_quantity'];
            $new_digo_goo_quantitys += $value['digo_goo_quantity'];
            // if ($value['digo_goo_unta_id'] == 1) {
            //     if (empty($goo_unit_conversion)) {
            //         return ['code'=>500, 'msg'=>'商品单位数据错误,请联系管理员！', 'data'=>'商品单位数据错误,请联系管理员！'];
            //     }
            //     // $value['digo_goo_quantity'] = $value['digo_goo_quantity'] * $goo_unit_conversion;
            //     // $request_goods_data[$key]['digo_goo_quantity'] = $value['digo_goo_quantity'] * $goo_unit_conversion;
            //     // $digo_goo_quantity = $digo_goo_quantity*$goo_unit_conversion;
            //     // unset($goo_unit_conversion);
            // }
            $request_goo_amount += $value['digo_goo_quantity'];
            // 有仓位id的相关库存数据，处理仓位商品表的库存锁定数量
            if (!empty($value['digo_wafr_id'])) {
                // [仓位id][仓库商品id][出库类型：良品/优先]，用于判断仓位是否有库存
                if (isset($freight_goods_data[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_inventory']])) {
                    $freight_goods_data[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_inventory']]['digo_goo_quantity'] += $value['digo_goo_quantity'];
                } else {
                    $freight_goods_data[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_inventory']] = (array)$value;
                }
                $freight_wafr_id[] = $value['digo_wafr_id']; //仓位商品id
            }

            // 仓库商品表库存数据处理
            // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
            if (isset($neaten_goods_data[$value['digo_wago_id']][$value['digo_goo_inventory']])) {
                // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                if ($value['digo_wafr_id']) {
                    $neaten_goods_data[$value['digo_wago_id']][$value['digo_goo_inventory']]['wafr_goo_quantity'] += $value['digo_goo_quantity']; //从仓位商品出库的商品数量
                } else {
                    $neaten_goods_data[$value['digo_wago_id']][$value['digo_goo_inventory']]['wago_goo_quantity'] += $value['digo_goo_quantity']; //从仓位商品出库的商品数量
                }
                // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                $neaten_goods_data[$value['digo_wago_id']][$value['digo_goo_inventory']]['digo_goo_quantity'] += $value['digo_goo_quantity'];
            } else {
                $temp_data = $value;
                // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                if ($value['digo_wafr_id']) {
                    $temp_data['wafr_goo_quantity'] = $value['digo_goo_quantity']; //从仓位商品出库的商品数量
                    $temp_data['wago_goo_quantity'] = 0; //从仓库商品出库的商品数量
                } else {
                    $temp_data['wafr_goo_quantity'] = 0; //从仓位商品出库的商品数量
                    $temp_data['wago_goo_quantity'] = $value['digo_goo_quantity']; //从仓库商品出库的商品数量
                }
                $neaten_goods_data[$value['digo_wago_id']][$value['digo_goo_inventory']] = $temp_data;
            }
            $neaten_wago_id[] = $value['digo_wago_id']; //仓库商品id

            // digo_goo_inventory 库存扣除方式1良品2优先
            if ($value['digo_goo_inventory'] == 1) {
                $goo_all_fine += $value['digo_goo_quantity'];
            } else {
                $goo_all_priority += $value['digo_goo_quantity'];
            }
            $digo_goo_id[] = $value['digo_goo_id'];
            $digo_wago_class[] = $value['digo_wago_class'];

            if (isset($wago_class_goods[$value['digo_wago_class']][$value['digo_goo_id']])) {
                // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                $wago_class_goods[$value['digo_wago_class']][$value['digo_goo_id']]['digo_goo_quantity'] = $wago_class_goods[$value['digo_wago_class']][$value['digo_goo_id']]['digo_goo_quantity'] + $value['digo_goo_quantity']; //仓库类型对应的商品，出入库记录
            } else {
                $temp_data = $value;
                // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                if ($value['digo_wafr_id']) {
                    $temp_data['wafr_goo_quantity'] = $value['digo_goo_quantity']; //从仓位商品出库的商品数量
                    $temp_data['wago_goo_quantity'] = 0; //从仓库商品出库的商品数量
                } else {
                    $temp_data['wafr_goo_quantity'] = 0; //从仓位商品出库的商品数量
                    $temp_data['wago_goo_quantity'] = $value['digo_goo_quantity']; //从仓库商品出库的商品数量
                }
                $wago_class_goods[$value['digo_wago_class']][$value['digo_goo_id']] = $temp_data; //仓库类型对应的商品，出入库记录
                unset($temp_data);
            }
            if ($dis_data->dego_order_type == '1' || $dis_data->dego_order_type == '2') {
                $digo_data['digo_goo_quantity'] = $new_digo_goo_quantity;
                $digo_data['digo_goo_unit'] = $value['digo_goo_unit'];
                $digo_data['digo_goo_unta_id'] = $value['digo_goo_unta_id'];
                $digo_data['digo_update_time'] = date('Y-m-d H:i:s');
                $digo_res = DB::table('dispatch_goods')
                    ->where('digo_dego_id', $request['dego_id'])
                    ->where('digo_goo_id', $value['digo_goo_id'])
                    ->where('digo_orgo_id', $value['digo_orgo_id'])
                    ->update($digo_data);
                $orgo_data['orgo_goo_quantity'] = $new_digo_goo_quantity;
                $orgo_data['orgo_new_goo_quantity'] = $new_digo_goo_quantity;
                $orgo_data['orgo_goo_unit'] = $value['digo_goo_unit'];
                $orgo_data['orgo_goo_unta_id'] = $value['digo_goo_unta_id'];
                $orgo_data['orgo_update_time'] = date('Y-m-d H:i:s');
                $orgo_res = DB::table('order_goods')
                    ->where('orgo_id', $value['digo_orgo_id'])
                    ->update($orgo_data);
                if ($dis_data->dego_order_type == '2') { //类型1订单发货2工单发货
                    $wogo_data['wogo_goo_amount'] = $new_digo_goo_quantity;
                    $wogo_data['wogo_new_goo_amount'] = $value['digo_goo_quantity'];
                    $wogo_data['wogo_goo_unit'] = $value['digo_goo_unit'];
                    $wogo_data['wogo_goo_unta_id'] = $value['digo_goo_unta_id'];
                    $wogo_data['wogo_update_time'] = date('Y-m-d H:i:s');
                    $wogo_res = DB::table('work_good')
                        ->where('wogo_wor_id', $find_order_work->wor_id)
                        ->where('wogo_orgo_id', $value['digo_orgo_id'])
                        ->update($wogo_data);
                } else {
                    $wogo_res = true;
                }
            }
            if ($dis_data->dego_order_type == '3') {
                $orgo_res = true;
                $wogo_res = true;
                $digo_data['digo_goo_quantity'] = $new_digo_goo_quantity;
                $digo_data['digo_goo_unit'] = $value['digo_goo_unit'];
                $digo_data['digo_goo_unta_id'] = $value['digo_goo_unta_id'];
                $digo_data['digo_update_time'] = date('Y-m-d H:i:s');
                $digo_res = DB::table('dispatch_goods')
                    ->where('digo_dego_id', $request['dego_id'])
                    ->where('digo_goo_id', $value['digo_goo_id'])
                    ->where('digo_orgo_id', $value['digo_orgo_id'])
                    ->update($digo_data);
            }
            if (!$orgo_res || !$wogo_res || !$digo_res) {
                return ['code'=>500, 'msg'=>'发货失败！', 'data'=>'发货失败！'.$value['digo_id']];
            }
        }

        $neaten_wago_id = array_unique($neaten_wago_id); //仓库商品id
        if ($dis_data->dego_order_type == '1') { //类型1订单发货
            $find_order_data = DB::table('order')
                ->where('ord_id', $dis_data->dego_wor_id)
                ->select('ord_type', 'ord_client_id')
                ->first();
            $oure_original_correlation_id = $find_ord_id;
            $oure_original_correlation_number = $find_order_number;
            $oure_original_correlation_type = 1;
            $oure_client_type = $find_order_data->ord_type;
            $oure_client_id = $find_order_data->ord_client_id;
        } elseif ($dis_data->dego_order_type == '2') { //2工单发货
            $find_order_data = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $dis_data->dego_wor_id)
                ->select('wor_type', 'wocl_client_id', 'wor_order_id', 'wor_order_number')
                ->first();
            $oure_original_correlation_id = $find_order_data->wor_order_id;
            $oure_original_correlation_number = $find_order_data->wor_order_number;
            $oure_client_type = $find_order_data->wor_type;
            $oure_client_id = $find_order_data->wocl_client_id;
        } elseif ($dis_data->dego_order_type == '3') { //3售后单发货
            $find_order_data = DB::table('wash_after_sale_list as afsl')
                ->leftjoin('wash_after_sale_client as afsc', 'afsc.afsc_afsl_id', '=', 'afsl.afsl_id')
                ->where('afsl_id', $dis_data->dego_wor_id)
                ->first();
            $oure_original_correlation_id = $find_order_data->afsl_id;
            $oure_original_correlation_number = $find_order_data->afsl_after_number;
            $oure_client_type = $find_order_data->afsl_client_type;
            $oure_client_id = $find_order_data->afsl_client_id;
        }

        // 仓库库存数量调整
        if (!empty($neaten_goods_data)) {
            // 2.选中的固定仓减库存
            $warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $dis_data->dego_out_ware_id)
                ->whereIn('wago_id', $neaten_wago_id)
                ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_freight_stock_number', 'wago_freight_priority_stock_number', 'wago_stock_amount', 'wago_priority_stock_amount')
                ->get()->toArray();
            $warehouse_goods = array_column($warehouse_goods, null, 'wago_id');
            foreach ($neaten_goods_data as $wago_id => $wago_value) {
                foreach ($wago_value as $goo_inventory => $goo_value) {
                    if (isset($warehouse_goods[$wago_id])) {
                        // 良品库存
                        if ($goo_inventory == 1) {
                            $find_waon_data = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->select('waon_id', 'waon_stock_fine_amount', 'waon_all_amount')
                                ->first();
                            $waon_all_amount = $find_waon_data->waon_all_amount - $goo_value['digo_goo_quantity'];
                            $waon_fine_amount = $find_waon_data->waon_stock_fine_amount - $goo_value['digo_goo_quantity']; //仓库良品总数量
                            $waon_edit_data['waon_stock_fine_amount'] = $waon_fine_amount;

                            $surplus_quantity = $warehouse_goods[$wago_id]->wago_stock_number - $goo_value['digo_goo_quantity']; //总的库存(仓库+仓位)
                            $wago_quantity = $warehouse_goods[$wago_id]->wago_stock_amount - $goo_value['wago_goo_quantity']; //仓库库存
                            $wafr_quantity = $warehouse_goods[$wago_id]->wago_freight_stock_number - $goo_value['wafr_goo_quantity']; //仓位库存

                            $wago_edit_data['wago_stock_number'] = $surplus_quantity;
                            $wago_edit_data['wago_stock_amount'] = $wago_quantity;
                            $wago_edit_data['wago_freight_stock_number'] = $wafr_quantity;
                            if ($surplus_quantity < 0 || $wago_quantity < 0 || $waon_fine_amount < 0 || $waon_all_amount < 0 || $wafr_quantity < 0) {
                                return ['code'=>500, 'msg'=>'商品库存数量不足！01', 'data'=>'商品库存数量不足！01'];
                            }
                            $wago_edit_res = DB::table('warehouse_goods')
                                ->where('wago_id', $wago_id)
                                ->update($wago_edit_data);

                            // 更改仓库的总库存数量
                            $waon_edit_data['waon_all_amount'] = $waon_all_amount;
                            $waon_res = DB::table('warehouse_onhand')
                                ->where('waon_id', $find_waon_data->waon_id)
                                ->update($waon_edit_data);
                            unset($waon_edit_data);
                            unset($wago_edit_data);
                            if (!$wago_edit_res || !$waon_res) {
                                return ['code'=>500, 'msg'=>'商品库存数量不足！02', 'data'=>'商品库存数量不足！02'];
                            }
                        } else {
                            // 优先库存
                            $find_waon_data = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->select('waon_id', 'waon_stock_priority_amount', 'waon_all_amount')
                                ->first();
                            $waon_all_amount = $find_waon_data->waon_all_amount - $goo_value['digo_goo_quantity'];

                            $waon_priority_amount = $find_waon_data->waon_stock_priority_amount - $goo_value['digo_goo_quantity'];
                            $waon_edit_data['waon_stock_priority_amount'] = $waon_priority_amount;

                            $surplus_quantity = $warehouse_goods[$wago_id]->wago_priority_stock_number - $goo_value['digo_goo_quantity']; //总的库存
                            $wago_quantity = $warehouse_goods[$wago_id]->wago_priority_stock_amount - $goo_value['wago_goo_quantity']; //仓库库存
                            $wafr_quantity = $warehouse_goods[$wago_id]->wago_freight_priority_stock_number - $goo_value['wafr_goo_quantity']; //仓位库存

                            $wago_edit_data['wago_priority_stock_number'] = $surplus_quantity; //总的库存(仓库+仓位)
                            $wago_edit_data['wago_priority_stock_amount'] = $wago_quantity; //仓库库存
                            $wago_edit_data['wago_freight_priority_stock_number'] = $wafr_quantity; //仓位库存
                            if ($surplus_quantity < 0 || $wago_quantity < 0 || $waon_priority_amount < 0 || $waon_all_amount < 0 || $wafr_quantity < 0) {
                                return ['code'=>500, 'msg'=>'商品库存数量不足！03', 'data'=>'商品库存数量不足！03'];
                            }
                            // 更改商品库存数量
                            $wago_edit_res = DB::table('warehouse_goods')
                                ->where('wago_id', $wago_id)
                                ->update($wago_edit_data);
                            unset($wago_edit_data);

                            // 更改仓库的总库存数量
                            $waon_edit_data['waon_all_amount'] = $waon_all_amount;
                            $waon_res = DB::table('warehouse_onhand')
                                ->where('waon_id', $find_waon_data->waon_id)
                                ->update($waon_edit_data);
                            unset($waon_edit_data);
                            if (!$wago_edit_res || !$waon_res) {
                                return ['code'=>500, 'msg'=>'商品库存数量不足！04', 'data'=>'商品库存数量不足！04'];
                            }
                        }
                    } else {
                        return ['code'=>500, 'msg'=>'仓库商品数量不足！', 'data'=>'仓库商品数量不足！'];
                    }
                }
            }
        }
        // 仓位库存数量调整
        if (!empty($freight_goods_data)) {
            $freight_wafr_id = array_unique($freight_wafr_id); //仓位id
            // 2.选中的固定仓减库存
            $warehouse_freight_goods = DB::table('warehouse_freight_goods')
                ->where('wafg_ware_id', $dis_data->dego_out_ware_id)
                ->whereIn('wafg_wafr_id', $freight_wafr_id)
                ->whereIn('wafg_wago_id', $neaten_wago_id)
                ->select('wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_class', 'wafg_goo_id', 'wafg_stock_number', 'wafg_priority_stock_number')
                ->get()->toArray();
            foreach ($warehouse_freight_goods as $key => $value) {
                $warehouse_class_goods[$value->wafg_wafr_id][$value->wafg_wago_id] = (array)$value;
            }
            // 仓位商品表锁定数量处理
            foreach ($freight_goods_data as $wafg_id => $wafg_value) {
                foreach ($wafg_value as $wago_id => $wago_value) {
                    foreach ($wago_value as $goo_inventory => $goo_value) {
                        if (isset($warehouse_class_goods[$wafg_id][$wago_id])) {
                            if ($goo_inventory == 1) { // 良品库存
                                // 判断商品出库数据是否更改
                                // 商品发货数据有更改的情况，已经把原来的锁定库存数量还回去了，但没有把新的仓位锁定库存数量加上，这里直接扣减库存数量
                                $surplus_quantity = $warehouse_class_goods[$wafg_id][$wago_id]['wafg_stock_number'] - $goo_value['digo_goo_quantity'];
                                $wafg_edit_data['wafg_stock_number'] = $surplus_quantity;
                                $wafr_decrement_field = 'wafr_all_stock'; //仓位表良品总数量字段
                                if ($surplus_quantity < 0) {
                                    return ['code'=>500, 'msg'=>'仓位商品数量不足！11', 'data'=>'仓位商品数量不足！11'];
                                }
                                // 仓位商品表锁定库存调整
                                $wafg_edit_res = DB::table('warehouse_freight_goods')
                                    ->where('wafg_id', $warehouse_class_goods[$wafg_id][$wago_id]['wafg_id']) //仓位商品id
                                    ->update($wafg_edit_data);

                                // 仓位表-仓位良品库存调整
                                $wafr_lock_res = DB::table('warehouse_freight')
                                    ->where('wafr_id', $warehouse_class_goods[$wafg_id][$wago_id]['wafg_wafr_id']) //仓位id
                                    ->where('wafr_ware_id', $dis_data->dego_out_ware_id)
                                    ->decrement($wafr_decrement_field, $goo_value['digo_goo_quantity']);
                                if (!$wafg_edit_res || !$wafr_lock_res) {
                                    return ['code'=>500, 'msg'=>'仓位商品数量不足！12', 'data'=>'仓位商品数量不足！12'];
                                }
                            } else {
                                // 优先库存
                                // 判断商品出库数据是否更改
                                // 商品发货数据有更改的情况，已经把原来的锁定库存数量还回去了，但没有把新的仓位锁定库存数量加上，这里直接扣减库存数量
                                $surplus_quantity = $warehouse_class_goods[$wafg_id][$wago_id]['wafg_priority_stock_number'] - $goo_value['digo_goo_quantity'];
                                $wafg_edit_data['wafg_priority_stock_number'] = $surplus_quantity;
                                $wafr_decrement_field = 'wafr_priority_all_stock'; //仓位表优先总数量字段
                                if ($surplus_quantity < 0) {
                                    return ['code'=>500, 'msg'=>'仓位商品数量不足！13', 'data'=>'仓位商品数量不足！13'];
                                }
                                // 更改仓位商品表商品库存数量
                                $wafg_edit_res = DB::table('warehouse_freight_goods')
                                    ->where('wafg_id', $warehouse_class_goods[$wafg_id][$wago_id]['wafg_id'])
                                    ->update($wafg_edit_data);
                                // 仓位良品锁定库存调整
                                $wafr_lock_res = DB::table('warehouse_freight')
                                    ->where('wafr_id', $warehouse_class_goods[$wafg_id][$wago_id]['wafg_wafr_id'])
                                    ->where('wafr_ware_id', $dis_data->dego_out_ware_id)
                                    ->decrement($wafr_decrement_field, $goo_value['digo_goo_quantity']);
                                if (!$wafg_edit_res || !$wafr_lock_res) {
                                    return ['code'=>500, 'msg'=>'仓位商品数量不足！13', 'data'=>'仓位商品数量不足！13'];
                                }
                            }
                            unset($wafg_edit_data);
                        } else {
                            return ['code'=>500, 'msg'=>'仓位商品数量不足！101', 'data'=>'仓位商品数量不足！101'];
                        }
                    }
                }
            }
        }

        // 遍历仓库类型数据，处理固定仓库对应仓库类型的出入库记录
        $oure_out_key = 0;
        foreach ($wago_class_goods as $waon_class_key => $class_goods_data) {
            // 查询仓库类别的进销存计算方式
            $goo_all_amount = 0;
            foreach ($class_goods_data as $goo_id_key => $value) {
                // 出入库记录需要的的商品数组
                $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['digo_goo_quantity']; //出入库商品数量
                $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_inventory'] = $value['digo_goo_inventory']; //出入库商品类型，类型1良品2优先
                $goo_all_amount += $value['digo_goo_quantity'];

                // 出入库记录需要
                $oure_goods_id[$goo_id_key] = $value['digo_goo_id']; //出入库商品id
                $oure_goods_quantity[$goo_id_key] = $value['digo_goo_quantity']; //出入库商品数量
                $oure_goods_inventory[$goo_id_key] = $value['digo_goo_inventory']; //出入库商品类型，类型1良品2优先
            }
            
            $find_ware = DB::table('warehouse_onhand')
                ->where('waon_ware_id', '=', $dis_data->dego_out_ware_id)
                ->where('waon_class', $waon_class_key)
                ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                ->first();
            $oure_goods_data = $oure_goods_dataarray[$waon_class_key];
            $oure_class_goo_id = array_keys($oure_goods_data);
            $oure_res = OutinRecord::addition(
                $user_info, //用户信息
                $oure_original_correlation_id, //原始单的关联id
                $oure_original_correlation_number, //原始单的关联单号
                1, //原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                $oure_client_type, //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $oure_client_id, //选择的客户id,会员id/单位id
                $dis_data->dego_number, //原始单号，旧货回收单单号
                0, //入库仓库id
                $dis_data->dego_out_ware_id, //出库仓库id
                $goo_all_amount, //出库的商品总数量
                9, //类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
                2, //操作类型：1锁定库存2出库3入库4调货5发货
                $find_ware->waon_stock_fine_amount, //良品总库存
                $find_ware->waon_lock_fine_amount, //良品锁定数量
                $find_ware->waon_stock_priority_amount, //优先总库存
                $find_ware->waon_lock_priority_amount, //优先锁定数量
                $find_ware->waon_stock_unchecked_amount, //待检测总库存
                1, //出入库类型：1出库，2入库
                $waon_class_key, //仓库类别
                $oure_goods_id, //商品id
                $oure_goods_quantity, //商品数量
                $oure_goods_inventory, //出库类型1良品2优先
                [], //仓位id
                $oure_class_goo_id //仓库类别下的商品id
            );
            if (!$oure_res) {
                return ['code'=>500, 'msg'=>'发货失败！01', 'data'=>'发货失败！01'];
            }
        }

        if ($dis_data->dego_order_type == 1) {
            $find_order = DB::table('order')
                ->where('ord_id', $find_ord_id)
                ->select('ord_type', 'ord_client_id')
                ->first();
            // 订单发货单 将订单状态改为完成待评价
            $order_data['ord_wor_state'] = 4;
            $order_data['ord_update_time'] = date('Y-m-d H:i:s');
            if (empty($find_order->ord_client_id)) {//散户
                $order_data['ord_wor_state'] = 20;//完成
            }
        }
        // 发货单数据修改
        $new_dis_data['dego_count'] = $new_digo_goo_quantitys;
        $new_dis_data['dego_update_time'] = date('Y-m-d H:i:s');
        $dis_update_res = DB::table('dispatch_bill')
            ->where('dego_id', $request['dego_id'])
            ->update($new_dis_data);
        if ($dis_data->dego_order_type == '1' || $dis_data->dego_order_type == '2') {
            // 订单数据
            $order_data['ord_goods_quantity'] = $new_digo_goo_quantitys;
            $order_data['ord_new_goods_quantity'] = $new_digo_goo_quantitys;
            $order_data['ord_update_time'] = date('Y-m-d H:i:s');
            $ord_update_res = DB::table('order')
                ->where('ord_id', $find_order_work->ord_id)
                ->update($order_data);
        }
        if ($dis_data->dego_order_type == 1) {
            $ord_data = DB::table('order')
                ->where('ord_id', $find_ord_id)
                ->select('ord_state', 'ord_wor_state', 'ord_type', 'ord_client_id', 'ord_payment_way')
                ->first();
            if ($ord_data->ord_state == 2 && ($ord_data->ord_wor_state == 4 || $ord_data->ord_wor_state == 20) && $ord_data->ord_type == 1 && $ord_data->ord_payment_way != 5) {//已结算 待评价或已完成 个人会员 添加积分
                $add_point = WashOrderBasicService::addPoint($user_info,$ord_data->ord_client_id,$find_ord_id);
            }
        }
        if ($dis_data->dego_order_type == '2') {
            // 工单数据
            $wor_data['wor_goo_amount'] = $new_digo_goo_quantitys;
            $wor_data['wor_new_goo_amount'] = $new_digo_goo_quantitys;
            $wor_data['wor_update_time'] = date('Y-m-d H:i:s');
            $wor_update_res = DB::table('work_order')
                ->where('wor_id', $find_order_work->wor_id)
                ->update($wor_data);
        } else {
            $wor_update_res = true;
        }
        if ($dis_data->dego_order_type == '3') {
            $wor_update_res = true;
            $ord_update_res = true;
        }
        foreach ($request_goods_data as $key => $value) {
            $new_goods_data[$key]['goo_id'] = $value['digo_goo_id'];
        }

        $post_data['ware_id'] = $dis_data->dego_out_ware_id;
        $post_data['new_goods_data'] = $new_goods_data;
        $res = WashOrderBasicService::addGoodPlan($user_info, $post_data);
        if ($ord_update_res && $wor_update_res) {
            return ['code'=>200, 'msg'=>'发货成功', 'data'=>'发货成功'];
        } else {
            return ['code'=>500, 'msg'=>'发货失败', 'data'=>'发货失败'];
        }
    }

    /**
     * delivery 调拨单出库
     *
     * @param [type] $user_info             用户信息
     * @param [type] $request               提交的数据
     * @param [type] $request_goods_data    提交的商品数据
     * @param [type] $find_tror             调拨单数据
     * @param [type] $ware_type             发货仓库类型
     * @param [type] $tror_id               调拨单id
     * @param [type] $tror_number           调拨单号
     * @return void
     */
    public static function delivery(
        $user_info,
        $request,
        $request_goods_data,
        $find_tror,
        $ware_type,
        $tror_id,
        $tror_number
    ) {
        // 调拨单商品信息
        $find_trog = DB::table('transferring_order_goods as trog')
            ->leftJoin('goods as goo', 'goo.goo_id', '=', 'trog.trog_goo_id')
            ->where('trog_tror_id', $request['tror_id'])
            ->select('goo_name', 'goo_goods_encode', 'goo_bra_name', 'goo_cate_name', 'trog_stock_number', 'trog_priority_stock_number', 'goo_type', 'goo_class', 'goo_brse_id', 'goo_id', 'trog_wago_id', 'trog_waon_class', 'trog_goo_id')
            ->get()->toArray();
        // 查询仓位商品锁定表
        $find_wfgl_goods = DB::table('warehouse_freight_goods_lock')
            ->where('wfgl_shop_id', $user_info->adm_shop_id)
            ->where('wfgl_type', 2) //原始单类型：1订单2调拨单
            ->where('wfgl_state', 1) //锁定状态：1下单锁定2出库解锁
            ->where('wfgl_original_id', $tror_id)
            ->where('wfgl_original_number', $tror_number)
            ->select('wfgl_id', 'wfgl_ware_id', 'wfgl_wago_id', 'wfgl_wafr_id', 'wfgl_wafg_id', 'wfgl_lock_quantity', 'wfgl_lock_type')
            ->get()->toArray();

        if (empty($find_wfgl_goods)) {
            $find_wagl_goods = DB::table('warehouse_goods_lock')
                ->where('wagl_shop_id', $user_info->adm_shop_id)
                ->where('wagl_type', 2) //原始单类型：1订单2调拨单
                ->where('wagl_state', 1) //锁定状态：1下单锁定2出库解锁
                ->where('wagl_original_id', $find_tror->tror_id)
                ->where('wagl_original_number', $find_tror->tror_number)
                ->select('wagl_id', 'wagl_ware_id', 'wagl_wago_id', 'wagl_wafr_id', 'wagl_wafg_id', 'wagl_lock_quantity')
                ->get()->toArray();
            if (!empty($find_wagl_goods)) {
                $wfgl_key = 0;
                foreach ($find_trog as $key => $value) {
                    if ($value->trog_stock_number > 0) { //良品数量
                        // 仓位商品锁定表
                        $wfgl_freight_data[$wfgl_key]['wfgl_shop_id'] = $user_info->adm_shop_id; //门店id
                        $wfgl_freight_data[$wfgl_key]['wfgl_ware_id'] = $find_tror->tror_out_ware_id; //仓库id
                        $wfgl_freight_data[$wfgl_key]['wfgl_waon_class'] = $value->trog_waon_class; //仓库类别
                        $wfgl_freight_data[$wfgl_key]['wfgl_wago_id'] = $value->trog_wago_id; //仓库商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafr_id'] = 0; //仓位id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafg_id'] = 0; //仓位商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_correlation_id'] = $tror_id; //关联id：订单id/发货单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_id'] = $tror_id; //原始id：订单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_number'] = $tror_number; //原始单号：订单号/调拨单号
                        $wfgl_freight_data[$wfgl_key]['wfgl_type'] = 2; //原始单类型：1订单2调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_quantity'] = $value->trog_stock_number;
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_type'] = 1; //商品锁定类型：1良品2优先
                        $wfgl_key++;
                    }
                    if ($value->trog_priority_stock_number > 0) { //良品数量
                        // 仓位商品锁定表
                        $wfgl_freight_data[$wfgl_key]['wfgl_shop_id'] = $user_info->adm_shop_id; //门店id
                        $wfgl_freight_data[$wfgl_key]['wfgl_ware_id'] = $find_tror->tror_out_ware_id; //仓库id
                        $wfgl_freight_data[$wfgl_key]['wfgl_waon_class'] = $value->trog_waon_class; //仓库类别
                        $wfgl_freight_data[$wfgl_key]['wfgl_wago_id'] = $value->trog_wago_id; //仓库商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafr_id'] = 0; //仓位id
                        $wfgl_freight_data[$wfgl_key]['wfgl_wafg_id'] = 0; //仓位商品主键id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_correlation_id'] = $tror_id; //关联id：订单id/发货单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_id'] = $tror_id; //原始id：订单id/调拨单id
                        $wfgl_freight_data[$wfgl_key]['wfgl_original_number'] = $tror_number; //原始单号：订单号/调拨单号
                        $wfgl_freight_data[$wfgl_key]['wfgl_type'] = 2; //原始单类型：1订单2调拨单
                        $wfgl_freight_data[$wfgl_key]['wfgl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_quantity'] = $value->trog_priority_stock_number;
                        $wfgl_freight_data[$wfgl_key]['wfgl_lock_type'] = 2; //商品锁定类型：1良品2优先
                        $wfgl_key++;
                    }
                }
                $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_freight_data);
            }
        }

        // 对前端提交的出库商品数组重新排序,方便与下面查询仓位商品数据匹配
        // 首先按照仓库商品id排序
        $request_goo_wago_id = array_column($request_goods_data, 'goo_wago_id');
        array_multisort($request_goods_data, SORT_ASC, $request_goo_wago_id);
        // 其次按照商品数量排序
        $request_goo_quantity = array_column($request_goods_data, 'goo_quantity');
        array_multisort($request_goods_data, SORT_ASC, $request_goo_quantity);

        // 查询仓位商品锁定表
        $find_wfgl_goods = DB::table('warehouse_freight_goods_lock')
            ->where('wfgl_shop_id', $user_info->adm_shop_id)
            ->where('wfgl_type', 2) //原始单类型：1订单2调拨单
            ->where('wfgl_state', 1) //锁定状态：1下单锁定2出库解锁
            ->where('wfgl_original_id', $tror_id)
            ->where('wfgl_original_number', $tror_number)
            ->select('wfgl_id', 'wfgl_ware_id', 'wfgl_wago_id', 'wfgl_wafr_id', 'wfgl_wafg_id', 'wfgl_lock_quantity', 'wfgl_lock_type')
            ->orderby('wfgl_wago_id', 'asc')
            ->orderby('wfgl_lock_quantity', 'asc')
            ->get()->toArray();
        $goods_change_sate = false; //商品变化状态
        $request_goo_amount = 0; //提交商品出库总数量
        $goo_all_fine = 0; //总的良品出库商品数量
        $goo_all_priority = 0; //总的优先出库商品数量
        $neaten_goods_data = []; //仓库商品数据
        $neaten_wago_id = []; //仓库商品id
        $freight_goods_data = []; //仓位商品数据

        $wfgl_lock_key = 0; //仓位商品锁定数组键值
        $wagl_key = 0; //仓库商品锁定数组键值
        $orgf_wfgl_key = 0; //订单商品仓位数组键值
        $wagl_wago_id = [];
        $wagl_data = [];
        // 判断提交的商品出库数据是否更改
        foreach ($request_goods_data as $key => $value) {
            $request_goo_amount += $value['goo_quantity'];
            if (!empty($find_wfgl_goods)) {
                // 仓位id
                if (isset($find_wfgl_goods[$key])) {
                    //仓位id
                    if ($value['goo_wafr_id'] != $find_wfgl_goods[$key]->wfgl_wafr_id) {
                        $goods_change_sate = true;
                    }
                    // 仓库商品id
                    if ($value['goo_wago_id'] != $find_wfgl_goods[$key]->wfgl_wago_id) {
                        $goods_change_sate = true;
                    }
                    // 出库类型1良品2优先
                    if ($value['goo_inventory'] != $find_wfgl_goods[$key]->wfgl_lock_type) {
                        $goods_change_sate = true;
                    }
                    // 出库数量
                    if ($value['goo_quantity'] != $find_wfgl_goods[$key]->wfgl_lock_quantity) {
                        $goods_change_sate = true;
                    }
                } else {
                    $goods_change_sate = true;
                }
            } else {
                $goods_change_sate = true;
            }

            // 有仓位id的相关库存数据，处理仓位商品表的库存锁定数量
            if (!empty($value['goo_wafr_id'])) {
                // [仓位id][仓库商品id][出库类型：良品/优先]，用于判断仓位是否有库存
                if (isset($freight_goods_data[$value['goo_wafr_id']][$value['goo_wago_id']][$value['goo_inventory']])) {
                    $freight_goods_data[$value['goo_wafr_id']][$value['goo_wago_id']][$value['goo_inventory']]['goo_quantity'] += $value['goo_quantity'];
                } else {
                    $freight_goods_data[$value['goo_wafr_id']][$value['goo_wago_id']][$value['goo_inventory']] = (array)$value;
                }
                $freight_wafr_id[] = $value['goo_wafr_id']; //仓位商品id
            }

            // 仓库商品表库存数据处理
            // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
            if (isset($neaten_goods_data[$value['goo_wago_id']][$value['goo_inventory']])) {
                // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                if ($value['goo_wafr_id']) {
                    $neaten_goods_data[$value['goo_wago_id']][$value['goo_inventory']]['wafr_goo_quantity'] += $value['goo_quantity']; //从仓位商品出库的商品数量
                } else {
                    $neaten_goods_data[$value['goo_wago_id']][$value['goo_inventory']]['wago_goo_quantity'] += $value['goo_quantity']; //从仓位商品出库的商品数量
                }
                $neaten_goods_data[$value['goo_wago_id']][$value['goo_inventory']]['goo_quantity'] += $value['goo_quantity'];
            } else {
                $temp_data = $value;
                // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                if ($value['goo_wafr_id']) {
                    $temp_data['wafr_goo_quantity'] = $value['goo_quantity']; //从仓位商品出库的商品数量
                    $temp_data['wago_goo_quantity'] = 0; //从仓库商品出库的商品数量
                } else {
                    $temp_data['wafr_goo_quantity'] = 0; //从仓位商品出库的商品数量
                    $temp_data['wago_goo_quantity'] = $value['goo_quantity']; //从仓库商品出库的商品数量
                }
                $neaten_goods_data[$value['goo_wago_id']][$value['goo_inventory']] = $temp_data;
            }
            $neaten_wago_id[] = $value['goo_wago_id']; //仓库商品id

            // goo_inventory 库存扣除方式1良品2优先
            if ($value['goo_inventory'] == 1) {
                $goo_all_fine += $value['goo_quantity'];
            } else {
                $goo_all_priority += $value['goo_quantity'];
            }
            $goo_id[] = $value['goo_id'];
            $goo_waon_class[] = $value['goo_waon_class'];

            if (isset($wago_class_goods[$value['goo_waon_class']][$value['goo_id']])) {
                // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                if ($value['goo_wafr_id']) {
                    $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wafr_goo_quantity'] = $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wafr_goo_quantity'] + $value['goo_quantity']; //仓库类型对应的商品，出入库记录
                } else {
                    $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wago_goo_quantity'] = $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['wago_goo_quantity'] + $value['goo_quantity']; //从仓库商品出库的商品数量
                }
                $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['goo_quantity'] = $wago_class_goods[$value['goo_waon_class']][$value['goo_id']]['goo_quantity'] + $value['goo_quantity']; //仓库类型对应的商品，出入库记录
            } else {
                $temp_data = $value;
                // 判断是否有仓位id，如果有仓位id，说明从仓位出库，如果没有说明从仓库出库
                if ($value['goo_wafr_id']) {
                    $temp_data['wafr_goo_quantity'] = $value['goo_quantity']; //从仓位商品出库的商品数量
                    $temp_data['wago_goo_quantity'] = 0; //从仓库商品出库的商品数量
                } else {
                    $temp_data['wafr_goo_quantity'] = 0; //从仓位商品出库的商品数量
                    $temp_data['wago_goo_quantity'] = $value['goo_quantity']; //从仓库商品出库的商品数量
                }
                $wago_class_goods[$value['goo_waon_class']][$value['goo_id']] = $temp_data; //仓库类型对应的商品，出入库记录
                unset($temp_data);
            }
            // 仓位商品锁定表
            $wfgl_data[$wfgl_lock_key]['wfgl_shop_id'] = $user_info->adm_shop_id; //门店id
            $wfgl_data[$wfgl_lock_key]['wfgl_ware_id'] = $find_tror->tror_out_ware_id; //仓库id
            $wfgl_data[$wfgl_lock_key]['wfgl_waon_class'] = $value['goo_waon_class']; //仓库类别
            $wfgl_data[$wfgl_lock_key]['wfgl_wago_id'] = $value['goo_wago_id']; //仓库商品主键id
            $wfgl_data[$wfgl_lock_key]['wfgl_wafr_id'] = $value['goo_wafr_id']; //仓位id
            $wfgl_data[$wfgl_lock_key]['wfgl_wafg_id'] = 0; //仓位商品主键id
            $wfgl_data[$wfgl_lock_key]['wfgl_original_correlation_id'] = $find_tror->tror_id; //关联id：订单id/发货单id/调拨单id
            $wfgl_data[$wfgl_lock_key]['wfgl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
            $wfgl_data[$wfgl_lock_key]['wfgl_original_id'] = $find_tror->tror_id; //原始id：订单id/调拨单id
            $wfgl_data[$wfgl_lock_key]['wfgl_original_number'] = $find_tror->tror_number; //原始单号：订单号/调拨单号
            $wfgl_data[$wfgl_lock_key]['wfgl_type'] = 2; //原始单类型：1订单2调拨单
            $wfgl_data[$wfgl_lock_key]['wfgl_state'] = 1; //锁定状态：1下单锁定2出库解锁
            $wfgl_data[$wfgl_lock_key]['wfgl_lock_quantity'] = $value['goo_quantity']; //商品锁定数量
            $wfgl_data[$wfgl_lock_key]['wfgl_lock_type'] = $value['goo_inventory']; //商品锁定类型：1良品2优先
            $wfgl_lock_key++;
            // 仓库商品锁定表数据
            if (in_array($value['goo_wago_id'], $wagl_wago_id)) {
                $array_key = array_search($value['goo_wago_id'], $wagl_wago_id);
                $wagl_data[$array_key]['wagl_lock_quantity'] += $value['goo_quantity']; //商品锁定库存数量
            } else {
                // 仓库商品锁定表
                $wagl_data[$wagl_key]['wagl_shop_id'] = $user_info->adm_shop_id;
                $wagl_data[$wagl_key]['wagl_ware_id'] = $find_tror->tror_out_ware_id;
                $wagl_data[$wagl_key]['wagl_wago_id'] = $value['goo_wago_id']; //仓库商品id
                $wagl_data[$wagl_key]['wagl_original_id'] = $find_tror->tror_id;
                $wagl_data[$wagl_key]['wagl_original_number'] = $find_tror->tror_number; //原始单号：订单号/调拨单号
                $wagl_data[$wagl_key]['wagl_original_correlation_id'] = $find_tror->tror_id; //关联id：订单id/发货单id/调拨单id
                $wagl_data[$wagl_key]['wagl_correlation_type'] = 3; //关联类型：1订单2发货单3调拨单
                $wagl_data[$wagl_key]['wagl_type'] = 2; //  原始单类型：1订单2调拨单
                $wagl_data[$wagl_key]['wagl_state'] = 1; //锁定状态：1下单锁定2出库解锁
                $wagl_data[$wagl_key]['wagl_lock_quantity'] = $value['goo_quantity']; //商品锁定库存数量

                $wagl_wago_id[$wagl_key] = $value['goo_wago_id']; //仓库商品id
                $wagl_key++;
            }
        }

        // 提交的商品数据有变化，更改发货商品的锁定库存;提交的商品数据没有变化不需要更改锁定库存
        if ($goods_change_sate) {
            // 把原来仓库锁定库存还回去
            $type = 2; //单据类型1订单2调拨单
            $change_lock_return = self::shipmentsChangeLock(
                $user_info, //用户信息
                $find_tror, //调拨单数据
                $ware_type, //出库仓库类型
                $find_tror->tror_id, //调拨单id
                $find_tror->tror_number, //调拨单单号
                $find_trog, //查询调拨单商品数据
                $find_wfgl_goods, //查询仓位锁定数据
                $type
            );
            if ($change_lock_return['code'] == 500) {
                return $change_lock_return;
            }
            // 添加新的锁定库存记录
            $wfgl_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_data);
            unset($wfgl_data);
            $wagl_res = DB::table('warehouse_goods_lock')->insert($wagl_data);
            unset($wfgl_data);
            if (!$wagl_res || !$wfgl_res) {
                return ['code'=>500, 'msg'=>'调拨失败', 'data'=>'调拨失败'];
            }

            // 仓库库存数量调整
            if (!empty($neaten_goods_data)) {
                // 2.选中的固定仓加锁定库存
                $warehouse_goods = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $find_tror->tror_out_ware_id)
                    ->whereIn('wago_id', $neaten_wago_id)
                    ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity', 'wago_stock_amount', 'wago_lock_amount', 'wago_priority_stock_amount', 'wago_priority_lock_amount')
                    ->get()->toArray();
                $warehouse_goods = array_column($warehouse_goods, null, 'wago_id');
                foreach ($neaten_goods_data as $wago_id => $wago_value) {
                    foreach ($wago_value as $goo_inventory => $goo_value) {
                        if (isset($warehouse_goods[$wago_id])) {
                            // 良品库存
                            if ($goo_inventory == 1) {
                                $surplus_quantity = $warehouse_goods[$wago_id]->wago_stock_number - $goo_value['goo_quantity']; //总的库存(仓库+仓位)
                                $wago_quantity = $warehouse_goods[$wago_id]->wago_stock_amount - $goo_value['wago_goo_quantity']; //仓库库存
                                $wafr_quantity = $warehouse_goods[$wago_id]->wago_freight_stock_number - $goo_value['wafr_goo_quantity']; //仓位库存

                                $surplus_lock_quantity = $warehouse_goods[$wago_id]->wago_lock_quantity + $goo_value['goo_quantity']; //总锁定的库存(仓库+仓位)
                                $wago_lock_quantity = $warehouse_goods[$wago_id]->wago_lock_amount + $goo_value['wago_goo_quantity']; //仓库锁定库存
                                $wafr_lock_quantity = $warehouse_goods[$wago_id]->wago_freight_lock_quantity + $goo_value['wafr_goo_quantity']; //仓位锁定库存
                                $wago_edit_data['wago_stock_number'] = $surplus_quantity;
                                $wago_edit_data['wago_stock_amount'] = $wago_quantity;
                                $wago_edit_data['wago_freight_stock_number'] = $wafr_quantity;
                                $wago_edit_data['wago_lock_quantity'] = $surplus_lock_quantity;
                                $wago_edit_data['wago_lock_amount'] = $wago_lock_quantity;
                                $wago_edit_data['wago_freight_lock_quantity'] = $wafr_lock_quantity;

                                if ($surplus_quantity < 0 || $wago_quantity < 0 || $wafr_quantity < 0) {
                                    return ['code'=>500, 'msg'=>'error', 'data'=>'商品库存锁定数量不足！01-1'];
                                }
                                $wago_edit_res = DB::table('warehouse_goods')
                                    ->where('wago_id', $wago_id)
                                    ->update($wago_edit_data);
                                unset($wago_edit_data);
                                if (!$wago_edit_res) {
                                    return ['code'=>500, 'msg'=>'error', 'data'=>'商品库存锁定数量不足！02'];
                                }
                                // 查询良品总库存数量
                                $find_waon_data = DB::table('warehouse_onhand')
                                    ->where('waon_ware_id', $find_tror->tror_out_ware_id)
                                    ->where('waon_class', $warehouse_goods[$wago_id]->wago_class)
                                    ->select('waon_id', 'waon_stock_fine_amount', 'waon_lock_fine_amount')
                                    ->first();
                                $waon_edit_data['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount - $goo_value['goo_quantity'];
                                if ($waon_edit_data['waon_stock_fine_amount'] < 0) {
                                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓位锁定库存数量不足！L110'];
                                }
                                $waon_edit_data['waon_lock_fine_amount'] = $find_waon_data->waon_lock_fine_amount + $goo_value['goo_quantity'];
                                // 调整仓库总的良品库存数量
                                $waon_res = DB::table('warehouse_onhand')
                                    ->where('waon_id', $find_waon_data->waon_id)
                                    ->update($waon_edit_data);
                            } else { //优先库存
                                $surplus_quantity = $warehouse_goods[$wago_id]->wago_priority_stock_number - $goo_value['goo_quantity']; //总的库存
                                $wago_quantity = $warehouse_goods[$wago_id]->wago_priority_stock_amount - $goo_value['wago_goo_quantity']; //仓库库存
                                $wafr_quantity = $warehouse_goods[$wago_id]->wago_freight_priority_stock_number - $goo_value['wafr_goo_quantity']; //仓位库存

                                $surplus_priority_lock_quantity = $warehouse_goods[$wago_id]->wago_priority_lock_quantity + $goo_value['goo_quantity']; //总锁定的库存
                                $wago_priority_lock_amount = $warehouse_goods[$wago_id]->wago_priority_lock_amount + $goo_value['wago_goo_quantity']; //仓库库存
                                $wago_freight_priority_lock_quantity = $warehouse_goods[$wago_id]->wago_freight_priority_lock_quantity + $goo_value['wafr_goo_quantity']; //仓位库存

                                $wago_edit_data['wago_priority_stock_number'] = $surplus_quantity; //总的库存(仓库+仓位)
                                $wago_edit_data['wago_priority_stock_amount'] = $wago_quantity; //仓库库存
                                $wago_edit_data['wago_freight_priority_stock_number'] = $wafr_quantity; //仓位库存
                                //锁定库存
                                $wago_edit_data['wago_priority_lock_quantity'] = $surplus_priority_lock_quantity; //总的库存(仓库+仓位)
                                $wago_edit_data['wago_priority_lock_amount'] = $wago_priority_lock_amount; //仓库库存
                                $wago_edit_data['wago_freight_priority_lock_quantity'] = $wago_freight_priority_lock_quantity; //仓位库存
                                if ($surplus_quantity < 0 || $wago_quantity < 0 || $wafr_quantity < 0) {
                                    return ['code'=>500, 'msg'=>'error', 'data'=>'商品库存锁定数量不足！031'];
                                }
                                // 更改商品库存数量
                                $wago_edit_res = DB::table('warehouse_goods')
                                    ->where('wago_id', $wago_id)
                                    ->update($wago_edit_data);
                                unset($wago_edit_data);
                                if (!$wago_edit_res) {
                                    return ['code'=>500, 'msg'=>'error', 'data'=>'商品库存锁定数量不足！041'];
                                }
                                // 查询优先总库存数量
                                $find_waon_data = DB::table('warehouse_onhand')
                                    ->where('waon_ware_id', $find_tror->tror_out_ware_id)
                                    ->where('waon_class', $warehouse_goods[$wago_id]->wago_class)
                                    ->select('waon_id', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                                    ->first();
                                $waon_edit_data['waon_stock_priority_amount'] = $find_waon_data->waon_stock_priority_amount - $goo_value['goo_quantity'];
                                if ($waon_edit_data['waon_stock_priority_amount'] < 0) {
                                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓位锁定库存数量不足！L120'];
                                }
                                $waon_edit_data['waon_lock_priority_amount'] = $find_waon_data->waon_lock_priority_amount + $goo_value['goo_quantity'];
                                // 调整仓库总的优先库存数量
                                $waon_res = DB::table('warehouse_onhand')
                                    ->where('waon_id', $find_waon_data->waon_id)
                                    ->update($waon_edit_data);
                            }
                        } else {
                            return ['code'=>500, 'msg'=>'error', 'data'=>'仓库商品锁定数量不足！'];
                        }
                    }
                }
            }

            // 仓位锁定库存数量调整
            if (!empty($freight_goods_data)) {
                $freight_wafr_id = array_unique($freight_wafr_id); //仓位id
                // 2.选中的固定仓减锁定库存
                $warehouse_freight_goods = DB::table('warehouse_freight_goods')
                    ->where('wafg_ware_id', $find_tror->tror_out_ware_id)
                    ->whereIn('wafg_wafr_id', $freight_wafr_id)
                    ->whereIn('wafg_wago_id', $neaten_wago_id)
                    ->select('wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_class', 'wafg_goo_id', 'wafg_stock_number', 'wafg_lock_quantity', 'wafg_priority_stock_number', 'wafg_priority_lock_quantity')
                    ->get()->toArray();
                foreach ($warehouse_freight_goods as $key => $value) {
                    $warehouse_class_goods[$value->wafg_wafr_id][$value->wafg_wago_id] = (array)$value;
                }
                // 仓位商品表锁定数量处理
                foreach ($freight_goods_data as $wafg_id => $wafg_value) {
                    foreach ($wafg_value as $wago_id => $wago_value) {
                        foreach ($wago_value as $goo_inventory => $goo_value) {
                            if (isset($warehouse_class_goods[$wafg_id][$wago_id])) {
                                if ($goo_inventory == 1) { // 良品库存
                                    // 商品发货数据有更改的情况，已经把原来的锁定库存数量还回去了
                                    $surplus_quantity = $warehouse_class_goods[$wafg_id][$wago_id]['wafg_stock_number'] - $goo_value['goo_quantity'];
                                    $wafg_lock_quantity = $warehouse_class_goods[$wafg_id][$wago_id]['wafg_lock_quantity'] + $goo_value['goo_quantity'];
                                    $wafg_edit_data['wafg_stock_number'] = $surplus_quantity;
                                    $wafg_edit_data['wafg_lock_quantity'] = $wafg_lock_quantity;
                                    $wafr_decrement_field = 'wafr_all_stock'; //仓位表良品总数量字段

                                    if ($surplus_quantity < 0) {
                                        return ['code'=>500, 'msg'=>'仓位商品锁定数量不足！', 'data'=>'仓位商品锁定数量不足！11'];
                                    }
                                    // 仓位商品表锁定库存调整
                                    $wafg_edit_res = DB::table('warehouse_freight_goods')
                                        ->where('wafg_id', $warehouse_class_goods[$wafg_id][$wago_id]['wafg_id']) //仓位商品id
                                        ->update($wafg_edit_data);

                                    // 仓位表-仓位良品库存调整
                                    $wafr_unlock_res = DB::table('warehouse_freight')
                                        ->where('wafr_id', $warehouse_class_goods[$wafg_id][$wago_id]['wafg_wafr_id']) //仓位id
                                        ->where('wafr_ware_id', $find_tror->tror_out_ware_id)
                                        ->decrement($wafr_decrement_field, $goo_value['goo_quantity']);
                                    // 仓位表-仓位良品锁定库存调整
                                    $wafr_lock_res = DB::table('warehouse_freight')
                                        ->where('wafr_id', $warehouse_class_goods[$wafg_id][$wago_id]['wafg_wafr_id']) //仓位id
                                        ->where('wafr_ware_id', $find_tror->tror_out_ware_id)
                                        ->increment('wafr_lock_quantity', $goo_value['goo_quantity']);
                                    if (!$wafg_edit_res || !$wafr_lock_res || !$wafr_unlock_res) {
                                        return ['code'=>500, 'msg'=>'仓位商品锁定数量不足！', 'data'=>'仓位商品锁定数量不足！12'];
                                    }
                                } else {
                                    // 优先库存
                                    // 商品发货数据有更改的情况
                                    $surplus_quantity = $warehouse_class_goods[$wafg_id][$wago_id]['wafg_priority_stock_number'] - $goo_value['goo_quantity'];
                                    $wafg_priority_lock_quantity = $warehouse_class_goods[$wafg_id][$wago_id]['wafg_priority_lock_quantity'] + $goo_value['goo_quantity'];
                                    $wafg_edit_data['wafg_priority_stock_number'] = $surplus_quantity;
                                    $wafg_edit_data['wafg_priority_lock_quantity'] = $wafg_priority_lock_quantity;
                                    $wafr_decrement_field = 'wafr_priority_all_stock'; //仓位表优先总数量字段
                                    if ($surplus_quantity < 0) {
                                        return ['code'=>500, 'msg'=>'仓位商品锁定数量不足！', 'data'=>'仓位商品锁定数量不足！13'];
                                    }
                                    // 更改仓位商品表商品库存数量
                                    $wafg_edit_res = DB::table('warehouse_freight_goods')
                                        ->where('wafg_id', $warehouse_class_goods[$wafg_id][$wago_id]['wafg_id'])
                                        ->update($wafg_edit_data);
                                    // 仓位良品库存调整
                                    $wafr_unlock_res = DB::table('warehouse_freight')
                                        ->where('wafr_id', $warehouse_class_goods[$wafg_id][$wago_id]['wafg_wafr_id'])
                                        ->where('wafr_ware_id', $find_tror->tror_out_ware_id)
                                        ->decrement($wafr_decrement_field, $goo_value['goo_quantity']);
                                    // 仓位良品锁定库存调整
                                    $wafr_lock_res = DB::table('warehouse_freight')
                                        ->where('wafr_id', $warehouse_class_goods[$wafg_id][$wago_id]['wafg_wafr_id'])
                                        ->where('wafr_ware_id', $find_tror->tror_out_ware_id)
                                        ->increment('wafr_priority_lock_quantity', $goo_value['goo_quantity']);
                                    if (!$wafg_edit_res || !$wafr_lock_res || !$wafr_unlock_res) {
                                        return ['code'=>500, 'msg'=>'仓位商品锁定数量不足！', 'data'=>'仓位商品锁定数量不足！13'];
                                    }
                                }
                                unset($wafg_edit_data);
                                // 更新仓位商品锁定表的数据
                                $res = DB::table('warehouse_freight_goods_lock')
                                    ->where('wfgl_shop_id', $user_info->adm_shop_id)
                                    ->where('wfgl_ware_id', $find_tror->tror_out_ware_id)
                                    ->where('wfgl_wago_id', $wago_id)
                                    ->where('wfgl_wafr_id', $warehouse_class_goods[$wafg_id][$wago_id]['wafg_wafr_id'])
                                    ->where('wfgl_original_number', $find_tror->tror_number)
                                    ->where('wfgl_original_id', $find_tror->tror_id)
                                    ->where('wfgl_type', 2)
                                    ->update(['wfgl_wafg_id' => $warehouse_class_goods[$wafg_id][$wago_id]['wafg_id']]);
                            } else {
                                return ['code'=>500, 'msg'=>'仓位商品锁定数量不足！', 'data'=>'仓位商品锁定数量不足！10'];
                            }
                        }
                    }
                }
            }
        }

        return ['code'=>200, 'msg'=>'success', 'data'=>'调拨成功'];
    }

    /**
     * [shipmentsChangeLock 发货单更换仓位锁定库存]
     * @param  [type] $user_info          [用户信息]
     * @param  [type] $dis_data           [发货单数据]
     * @param  [type] $ware_type           [发货仓库类型]
     * @param  [type] $find_ord_id        [订单id]
     * @param  [type] $find_order_number  [订单单号]
     * @param  [type] $find_goods_data    [查询发货单商品数据]
     * @param  [type] $find_wfgl_data     [查询仓位锁定数据]
     * @return [type]                     [description]
     */
    public static function shipmentsChangeLock(
        $user_info,
        $dis_data,
        $ware_type,
        $find_ord_id,
        $find_order_number,
        $find_goods_data,
        $find_wfgl_goods,
        $type = 1
    ) {
        if ($type == 1) { //发货单
            $wago_ware_id = $dis_data->dego_out_ware_id;
        } elseif ($type == 2) { //调拨单
            $wago_ware_id = $dis_data->tror_out_ware_id;
        } elseif ($type == 3) { //销售单
            $wago_ware_id = $dis_data->sell_ware_id;
        }
        // 仓位商品数据处理
        if (!empty($find_wfgl_goods)) {
            foreach ($find_wfgl_goods as $key => $value) {
                // 判断是否有仓位id，没有仓位id的说明不是仓位锁定数据，不需要处理
                if (empty($value->wfgl_wafr_id)) {
                    continue;
                }
                // 仓位商品id不为空
                $find_wafg_data = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $value->wfgl_wafg_id)
                    ->select('wafg_id', 'wafg_stock_number', 'wafg_priority_stock_number', 'wafg_lock_quantity', 'wafg_priority_lock_quantity')
                    ->first();
                $find_wago_data = DB::table('warehouse_goods')
                    ->where('wago_id', $value->wfgl_wago_id)
                    ->select('wago_class', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity', 'wago_stock_amount', 'wago_lock_amount', 'wago_priority_stock_amount', 'wago_priority_lock_amount')
                    ->first();

                // 仓位库存锁定数量，处理仓库库存数量使用
                if (isset($freight_goods_data[$value->wfgl_wago_id][$value->wfgl_lock_type])) {
                    $freight_goods_data[$value->wfgl_wago_id][$value->wfgl_lock_type]['goo_quantity'] += $value->wfgl_lock_quantity;
                } else {
                    $freight_goods_data[$value->wfgl_wago_id][$value->wfgl_lock_type]['goo_quantity'] = $value->wfgl_lock_quantity;
                }

                // 判断良品优先
                if ($value->wfgl_lock_type == 1) {
                    // 良品库存数量处理,库存数量增加，锁定数量减少
                    $wafg_edit_data['wafg_stock_number'] = $find_wafg_data->wafg_stock_number + $value->wfgl_lock_quantity; //仓位商品表的良品库存数量
                    $wafg_edit_data['wafg_lock_quantity'] = $find_wafg_data->wafg_lock_quantity - $value->wfgl_lock_quantity; //仓位商品表的良品锁定数量

                    // 仓库商品表仓位库存数量
                    $wago_edit_data['wago_freight_stock_number'] = $find_wago_data->wago_freight_stock_number + $value->wfgl_lock_quantity;
                    $wago_edit_data['wago_freight_lock_quantity'] = $find_wago_data->wago_freight_lock_quantity - $value->wfgl_lock_quantity; //仓位良品锁定库存数量
                    // 仓库商品表(仓库+仓位)总库存数量
                    $wago_edit_data['wago_stock_number'] = $find_wago_data->wago_stock_number + $value->wfgl_lock_quantity;
                    $wago_edit_data['wago_lock_quantity'] = $find_wago_data->wago_lock_quantity - $value->wfgl_lock_quantity; //良品锁定数量（仓库+仓位）

                    $wago_lock_quantity = $wago_edit_data['wago_lock_quantity']; //良品锁定数量（仓库+仓位）
                    $wago_freight_lock_quantity = $wago_edit_data['wago_freight_lock_quantity']; //仓位良品锁定库存数量
                    $wafg_lock_quantity = $wafg_edit_data['wafg_lock_quantity']; //仓位商品表的良品锁定数量
                    if ($wago_lock_quantity < 0 || $wago_freight_lock_quantity < 0 || $wafg_lock_quantity < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓位锁定库存数量不足！L01-1'];
                    }
                } else {
                    // 优先库存数量处理
                    $wafg_edit_data['wafg_priority_stock_number'] = $find_wafg_data->wafg_priority_stock_number + $value->wfgl_lock_quantity;
                    $wafg_edit_data['wafg_priority_lock_quantity'] = $find_wafg_data->wafg_priority_lock_quantity - $value->wfgl_lock_quantity;

                    // 仓库商品表仓位库存数量
                    $wago_edit_data['wago_freight_priority_stock_number'] = $find_wago_data->wago_freight_priority_stock_number + $value->wfgl_lock_quantity;
                    $wago_edit_data['wago_freight_priority_lock_quantity'] = $find_wago_data->wago_freight_priority_lock_quantity - $value->wfgl_lock_quantity;

                    // 仓库商品表仓库库存数量
                    $wago_edit_data['wago_priority_stock_number'] = $find_wago_data->wago_priority_stock_number + $value->wfgl_lock_quantity;
                    $wago_edit_data['wago_priority_lock_quantity'] = $find_wago_data->wago_priority_lock_quantity - $value->wfgl_lock_quantity;

                    if ($wago_edit_data['wago_priority_lock_quantity'] < 0 || $wago_edit_data['wago_freight_priority_lock_quantity'] < 0 || $wafg_edit_data['wafg_priority_lock_quantity'] < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓位锁定库存数量不足！L02'];
                    }
                }

                //查询仓位总库存数量
                $find_wafr_data = DB::table('warehouse_freight')
                    ->where('wafr_id', $value->wfgl_wafr_id)
                    ->select('wafr_all_stock', 'wafr_priority_all_stock', 'wafr_lock_quantity', 'wafr_priority_lock_quantity')
                    ->first();
                // 判断良品优先1良品2优先
                if ($value->wfgl_lock_type == 1) {
                    // 良品库存数量处理,库存数量增加，锁定数量减少
                    $wafr_edit_data['wafr_all_stock'] = $find_wafr_data->wafr_all_stock + $value->wfgl_lock_quantity;
                    $wafr_edit_data['wafr_lock_quantity'] = $find_wafr_data->wafr_lock_quantity - $value->wfgl_lock_quantity;
                    if ($wafr_edit_data['wafr_lock_quantity'] < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓位锁定库存数量不足！L11'];
                    }

                    // 查询良品总库存数量
                    $find_waon_data = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $wago_ware_id)
                        ->where('waon_class', $find_wago_data->wago_class)
                        ->select('waon_id', 'waon_stock_fine_amount', 'waon_lock_fine_amount')
                        ->first();
                    $waon_lock_fine_amount = $find_waon_data->waon_lock_fine_amount - $value->wfgl_lock_quantity;
                    if ($waon_lock_fine_amount < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓位锁定库存数量不足！L110'];
                    }
                    $waon_edit_data['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + $value->wfgl_lock_quantity;
                    $waon_edit_data['waon_lock_fine_amount'] = $waon_lock_fine_amount;
                    // 调整仓库总的良品库存数量
                    $waon_res = DB::table('warehouse_onhand')
                        ->where('waon_id', $find_waon_data->waon_id)
                        ->update($waon_edit_data);
                } else {
                    // 优先库存数量处理
                    $wafr_edit_data['wafr_priority_all_stock'] = $find_wafr_data->wafr_priority_all_stock + $value->wfgl_lock_quantity;
                    $wafr_edit_data['wafr_priority_lock_quantity'] = $find_wafr_data->wafr_priority_lock_quantity - $value->wfgl_lock_quantity;
                    if ($wafr_edit_data['wafr_priority_lock_quantity'] < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓位锁定库存数量不足！L12'];
                    }

                    // 查询优先总库存数量
                    $find_waon_data = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $wago_ware_id)
                        ->where('waon_class', $find_wago_data->wago_class)
                        ->select('waon_id', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                        ->first();
                    $waon_lock_priority_amount = $find_waon_data->waon_lock_priority_amount - $value->wfgl_lock_quantity;
                    if ($waon_lock_priority_amount < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓位锁定库存数量不足！L120'];
                    }
                    $waon_edit_data['waon_stock_priority_amount'] = $find_waon_data->waon_stock_priority_amount + $value->wfgl_lock_quantity;
                    $waon_edit_data['waon_lock_priority_amount'] = $waon_lock_priority_amount;
                    // 调整仓库总的优先库存数量
                    $waon_res = DB::table('warehouse_onhand')
                        ->where('waon_id', $find_waon_data->waon_id)
                        ->update($waon_edit_data);
                }
                unset($waon_edit_data);
                $wafr_edit_data['wafr_update_time'] = date('Y-m-d H:i:s');
                //更新仓位库存数量
                $wafr_update_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value->wfgl_wafr_id)
                    ->update($wafr_edit_data);

                $wafg_edit_data['wafg_update_time'] = date('Y-m-d H:i:s');
                // 更新仓位商品表库存数据
                $wafg_update_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $value->wfgl_wafg_id)
                    ->update($wafg_edit_data);
                // 更新仓库商品表库存数据
                $wago_update_res = DB::table('warehouse_goods')
                    ->where('wago_id', $value->wfgl_wago_id)
                    ->update($wago_edit_data);
                unset($wafr_edit_data);
                unset($wafg_edit_data);
                unset($wago_edit_data);
                if (!$wafr_update_res || !$wafg_update_res || !$wago_update_res || !$waon_res) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓位锁定库存数量不足！L03'];
                }
            }
            // warehouse_freight_lock 删除锁定表相关数据
            $wfgl_delete_res = DB::table('warehouse_freight_goods_lock')
                ->where('wfgl_shop_id', $user_info->adm_shop_id)
                ->where('wfgl_type', $type)
                ->where('wfgl_original_id', $find_ord_id)
                ->where('wfgl_original_number', $find_order_number)
                ->delete();
            if (!$wfgl_delete_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'仓位锁定库存数量不足！L09'];
            }
        }

        if ($type == 1) {
            // 发货单商品数据
            $find_wago_id = array_column($find_goods_data, 'digo_wago_id');
            $neaten_goods_data = []; //整理后的仓库商品库存数据
            foreach ($find_goods_data as $key => $value) {
                // 仓位商品id不为空
                // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
                if (isset($neaten_goods_data[$value->digo_wago_id][$value->digo_goo_inventory])) {
                    $neaten_goods_data[$value->digo_wago_id][$value->digo_goo_inventory]['goo_quantity'] += $value->digo_goo_quantity;
                } else {
                    $neaten_goods_data[$value->digo_wago_id][$value->digo_goo_inventory]['goo_quantity'] = $value->digo_goo_quantity;
                }
            }
        } elseif ($type == 2) { //调拨单商品数据
            $find_wago_id = array_column($find_goods_data, 'trog_wago_id');
            $neaten_goods_data = []; //整理后的仓库商品库存数据
            foreach ($find_goods_data as $key => $value) {
                // 仓位商品id不为空
                if (!empty($value->trog_stock_number)) {
                    $goo_inventory = 1; //良品
                    // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
                    if (isset($neaten_goods_data[$value->trog_wago_id][$goo_inventory])) {
                        $neaten_goods_data[$value->trog_wago_id][$goo_inventory]['goo_quantity'] += $value->trog_stock_number;
                    } else {
                        $neaten_goods_data[$value->trog_wago_id][$goo_inventory]['goo_quantity'] = $value->trog_stock_number;
                    }
                }
                if (!empty($value->trog_priority_stock_number)) {
                    $goo_inventory = 2; //优先
                    // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
                    if (isset($neaten_goods_data[$value->trog_wago_id][$goo_inventory])) {
                        $neaten_goods_data[$value->trog_wago_id][$goo_inventory]['goo_quantity'] += $value->trog_priority_stock_number;
                    } else {
                        $neaten_goods_data[$value->trog_wago_id][$goo_inventory]['goo_quantity'] = $value->trog_priority_stock_number;
                    }
                }
            }
        } elseif ($type == 3) { //销售单商品数据
            $find_wago_id = array_column($find_goods_data, 'goo_wago_id');
            $neaten_goods_data = []; //整理后的仓库商品库存数据
            foreach ($find_goods_data as $key => $value) {
                // 仓位商品id不为空
                // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
                if (isset($neaten_goods_data[$value->goo_wago_id][$value->goo_inventory])) {
                    $neaten_goods_data[$value->goo_wago_id][$value->goo_inventory]['goo_quantity'] += $value->goo_quantity;
                } else {
                    $neaten_goods_data[$value->goo_wago_id][$value->goo_inventory]['goo_quantity'] = $value->goo_quantity;
                }
            }
        }
        foreach ($neaten_goods_data as $wago_id => $wago_value) {
            foreach ($wago_value as $goo_inventory => $goo_value) {
                if (isset($freight_goods_data[$wago_id][$goo_inventory])) {
                    // 仓库商品库存出库数量=发货商品的出库数量-仓位商品的库存数量
                    $neaten_goods_data[$wago_id][$goo_inventory]['goo_quantity'] -= $freight_goods_data[$wago_id][$goo_inventory]['goo_quantity'];
                    // 仓库商品库存数量没有的，就是不需要处理的，把为空的从数组中删除
                    if (empty($neaten_goods_data[$wago_id][$goo_inventory]['goo_quantity'])) {
                        unset($neaten_goods_data[$wago_id][$goo_inventory]);
                    }
                }
            }
            if (empty($neaten_goods_data[$wago_id])) {
                unset($neaten_goods_data[$wago_id]);
            }
        }
        // 如果仓库商品存在需要带还的数据，仓库的商品库存数量处理
        if (!empty($neaten_goods_data)) {
            // 查询仓库库存商品信息
            if ($type == 1) { //发货单
                $wago_ware_id = $dis_data->dego_out_ware_id;
            } elseif ($type == 2) { //调拨单
                $wago_ware_id = $dis_data->tror_out_ware_id;
            } elseif ($type == 3) { //销售单
                $wago_ware_id = $dis_data->sell_ware_id;
            }
            $find_warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $wago_ware_id)
                ->whereIn('wago_id', $find_wago_id)
                ->select('wago_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_lock_quantity', 'wago_priority_lock_quantity', 'wago_lock_amount', 'wago_stock_amount', 'wago_priority_lock_amount', 'wago_priority_stock_amount')
                ->get()->toArray();
            $warehouse_goods = array_column($find_warehouse_goods, null, 'wago_id');
            foreach ($neaten_goods_data as $wago_id => $wago_value) {
                foreach ($wago_value as $goo_inventory => $goo_value) {
                    // 良品库存
                    if ($goo_inventory == 1) {
                        // 仓库商品锁定数量减少，正常库存数量增加
                        $surplus_quantity = $warehouse_goods[$wago_id]->wago_lock_quantity - $goo_value['goo_quantity']; //(仓位+仓库)
                        if ($surplus_quantity < 0) {
                            return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足！L04'];
                        }
                        // 仓库商品良品锁定数量减少，正常库存数量增加
                        $lock_wago_edit['wago_lock_quantity'] = $surplus_quantity; //良品锁定数量(仓库+仓位)
                        $lock_wago_edit['wago_stock_number'] = $warehouse_goods[$wago_id]->wago_stock_number + $goo_value['goo_quantity']; //良品库存数量(仓库+仓位)

                        // 移动仓库没有仓库库存
                        if ($ware_type == 1) {
                            $surplus_amount = $warehouse_goods[$wago_id]->wago_lock_amount - $goo_value['goo_quantity']; //仓库的
                            if ($surplus_amount < 0) {
                                return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足！L05'];
                            }
                            // 良品总库存数量增加
                            $lock_wago_edit['wago_lock_amount'] = $surplus_amount; //仓库良品锁定库存数量
                            $lock_wago_edit['wago_stock_amount'] = $warehouse_goods[$wago_id]->wago_stock_amount + $goo_value['goo_quantity'];
                        }

                        // 查询良品总库存数量
                        $find_waon_data = DB::table('warehouse_onhand')
                            ->where('waon_ware_id', $wago_ware_id)
                            ->where('waon_class', $warehouse_goods[$wago_id]->wago_class)
                            ->select('waon_id', 'waon_stock_fine_amount', 'waon_lock_fine_amount')
                            ->first();
                        $waon_lock_fine_amount = $find_waon_data->waon_lock_fine_amount - $goo_value['goo_quantity'];
                        if ($waon_lock_fine_amount < 0) {
                            return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足！L050'];
                        }
                        $waon_edit_data['waon_stock_fine_amount'] = $find_waon_data->waon_stock_fine_amount + $goo_value['goo_quantity'];
                        $waon_edit_data['waon_lock_fine_amount'] = $waon_lock_fine_amount;
                        // 调整仓库总的良品库存数量
                        $waon_res = DB::table('warehouse_onhand')
                            ->where('waon_id', $find_waon_data->waon_id)
                            ->update($waon_edit_data);
                    } else {
                        // 优先库存
                        $surplus_amount = $warehouse_goods[$wago_id]->wago_priority_lock_quantity - $goo_value['goo_quantity']; //(仓库+仓位)
                        if ($surplus_amount < 0) {
                            return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足！L06'];
                        }
                        // 固定仓库商品优先锁定数量减少
                        $lock_wago_edit['wago_priority_lock_quantity'] = $surplus_amount; //优先锁定数量(仓库+仓位)
                        $lock_wago_edit['wago_priority_stock_number'] = $warehouse_goods[$wago_id]->wago_priority_stock_number + $goo_value['goo_quantity']; //优先库存数量(仓库+仓位)

                        if ($ware_type == 1) {
                            $surplus_quantity = $warehouse_goods[$wago_id]->wago_priority_lock_amount - $goo_value['goo_quantity']; //仓库优先
                            if ($surplus_quantity < 0) {
                                return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足！L07'];
                            }
                            $lock_wago_edit['wago_priority_lock_amount'] = $surplus_quantity;
                            $lock_wago_edit['wago_priority_stock_amount'] = $warehouse_goods[$wago_id]->wago_priority_stock_amount + $goo_value['goo_quantity'];
                        }

                        // 查询优先总库存数量
                        $find_waon_data = DB::table('warehouse_onhand')
                            ->where('waon_ware_id', $wago_ware_id)
                            ->where('waon_class', $warehouse_goods[$wago_id]->wago_class)
                            ->select('waon_id', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                            ->first();
                        $waon_lock_priority_amount = $find_waon_data->waon_lock_priority_amount - $goo_value['goo_quantity'];
                        if ($waon_lock_priority_amount < 0) {
                            return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足！L070'];
                        }
                        $waon_edit_data['waon_stock_priority_amount'] = $find_waon_data->waon_stock_priority_amount + $goo_value['goo_quantity'];
                        $waon_edit_data['waon_lock_priority_amount'] = $waon_lock_priority_amount;
                        // 调整仓库总的优先库存数量
                        $waon_res = DB::table('warehouse_onhand')
                            ->where('waon_id', $find_waon_data->waon_id)
                            ->update($waon_edit_data);
                    }

                    $lock_wago_edit['wago_update_time'] = date('Y-m-d H:i:s');
                    $lock_edit_res = DB::table('warehouse_goods')
                        ->where('wago_id', $wago_id)
                        ->update($lock_wago_edit);
                    unset($lock_wago_edit);
                    if (!$lock_edit_res || !$waon_res) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足！L08'];
                    }
                }
            }
        }
        $wagl_res = DB::table('warehouse_goods_lock')
            ->where('wagl_shop_id', $user_info->adm_shop_id)
            ->where('wagl_type', $type)
            ->where('wagl_original_id', $find_ord_id)
            ->where('wagl_original_number', $find_order_number)
            ->delete();
        if (!$wagl_res) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'仓位锁定库存数量不足！L10'];
        }

        return ['code'=>200, 'msg'=>'success', 'data'=>'锁定库存处理成功'];
    }

    /**
     * [info 发货单详情]
     * @param  [type] $user_info    [用户信息]
     * @param  [type] $request      [提交的数据]
     * @param  [type] $select_field [查询字段，字符串多个字段用,分开]
     */
    public static function info(
        $user_info,
        $request,
        $select_field
    ) {
        $find_dibi_data = DB::table('dispatch_bill')
            ->where('dego_id', $request['dego_id'])
            ->where('dego_shop_id', $user_info->adm_shop_id)
            ->select(DB::raw($select_field))
            ->first();
        if (empty($find_dibi_data)) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'当前发货单不存在！'];
        }
        if (!empty($find_dibi_data->dego_pic)) {
            $pic = json_decode($find_dibi_data->dego_pic);
            $new_pic = [];
            foreach ($pic as $key => $value) {
                $new_pic[] = addHttpurl($value);
            }
            $find_dibi_data->dego_pic = json_encode($new_pic, true);
        }
        if ($find_dibi_data->dego_order_type == 1) { // 订单详情
            $order_data = DB::table('order as ord')
                ->leftJoin('order_client as orcl', 'ord.ord_orcl_id', '=', 'orcl.orcl_id')
                ->where('ord_id', $find_dibi_data->dego_wor_id)
                ->select('ord_order_number', 'ord_wor_state', 'ord_payment_way', 'ord_state', 'ord_remark', 'ord_create_id', 'ord_service_type', 'orcl_name', 'orcl_phone', 'orcl_address', 'orcl_channel_unit', 'orcl_car_num', 'ord_id', 'ord_ware_id', 'ord_create_time', 'ord_type', 'ord_client_id', 'orcl_province', 'orcl_city', 'orcl_county', 'ord_address')
                ->first();
            if ($order_data->ord_type == 1) {//0散户1会员2企业会员
                $order_data->orcl_channel_unit = $order_data->orcl_name;
            }
            if ($order_data->ord_type == 2) {
                $order_data->orcl_channel_unit = DB::table('business_account')
                    ->leftjoin('business_client', 'bucl_id', '=', 'buac_bucl_id')
                    ->where('buac_id', $order_data->ord_client_id)
                    ->value('bucl_name');
            }
            if ($order_data->ord_type == 0) {
                $order_data->orcl_channel_unit = '散户';
            }
            $ord_Explainpic = [];
            $Explainpic = WashOrderService::getExplainpic($user_info, $order_data->ord_id);
            if (!empty($Explainpic['data'])) {
                $ord_Explainpic = $Explainpic['data'];
            }
            $order_data->ord_explain_pic = $ord_Explainpic;
            $order_data->dego_count = $find_dibi_data->dego_count;
            $order_data->dego_pic = $find_dibi_data->dego_pic;
            $order_data->dego_remark = $find_dibi_data->dego_remark;
            $order_data->ord_service_shop_name = $order_data->ord_address;
            // 获取账号id对应的姓名
            $adm_id[] = $order_data->ord_create_id;
            $adm_id = array_filter($adm_id); //如果没有回调函数，默认就是删除数组中值为false的元素
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_name', 'adm_id')->toArray();
            $order_data->create_name = isset($find_admin[$order_data->ord_create_id]) ? $find_admin[$order_data->ord_create_id] : '';
            // 获取仓库名称
            $order_data->ware_name = DB::table('warehouse')
                ->where('ware_id', $order_data->ord_ware_id)
                ->value('ware_name');

            // 获取发货单的商品数据
            $order_goods = DB::table('dispatch_goods as digo')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'digo.digo_goo_id')
                ->where('digo_dego_id', $request['dego_id'])
                ->select('digo_goo_name', 'digo_goo_type', 'digo_goo_goods_encode', 'digo_goo_price', 'digo_goo_quantity', 'digo_is_recycle', 'digo_goo_inventory', 'digo_state', 'digo_tem_goo_name', 'goo_bra_name', 'goo_brse_id', 'goo_class', 'goo_id', 'digo_id', 'digo_goo_material_pic', 'digo_goo_unit', 'digo_goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();
            // 查询系列数据
            $goo_brse_id = array_column($order_goods, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            $goo_id = array_column($order_goods, 'goo_id');
            // 查询商品附属表信息
            $goaf_data = DB::table('goods_affiliate')
                ->where('goaf_shop_id', $user_info->adm_shop_id)
                ->whereIn('goaf_goo_id', $goo_id)
                ->pluck('goaf_another_name', 'goaf_goo_id')
                ->toArray();
            // 查询系统商品属性表信息
            $gosa_data = DB::table('goods_system_affiliate')
                ->where('gosa_shop_id', $user_info->adm_shop_id)
                ->whereIn('gosa_goo_id', $goo_id)
                ->pluck('gosa_another_name', 'gosa_goo_id')
                ->toArray();
            foreach ($order_goods as $key => $value) {
                // 仓位数据
                $find_wfog_data = DB::table('warehouse_freight_outin_goods as w')
                    ->leftJoin('warehouse_freight as wf', 'w.wfog_wafr_id', '=', 'wf.wafr_id')
                    ->where('wfog_shop_id', $user_info->adm_shop_id)
                    ->where('wfog_outin_type', 1)
                    ->where('wfog_goo_id', $value->goo_id)
                    ->where('wfog_stock_type', $value->digo_goo_inventory)
                    ->where('wfog_primary_id', $value->digo_id)
                    ->select('wfog_stock_amount', 'wafr_name', 'wfog_stock_type', 'wfog_wafr_id')
                    ->get()->toArray();
                $wfog_stock_amount = array_sum(array_column($find_wfog_data, 'wfog_stock_amount'));
                $find_wfog_data = json_decode(json_encode($find_wfog_data, true), true);

                if ($wfog_stock_amount == $value->digo_goo_quantity) {
                    if ($find_wfog_data) {
                        foreach ($find_wfog_data as $wfog_key => $wfog_value) {
                            if (empty($wfog_value['wfog_wafr_id'])) {
                                $ware_name = DB::table('warehouse')
                                    ->where('ware_id', $find_dibi_data->dego_out_ware_id)
                                    ->value('ware_name');
                                $find_wfog_data[$wfog_key]['wafr_name'] = $ware_name;
                            }
                        }
                        $order_goods[$key]->wafr_data = $find_wfog_data;
                    } else {
                        $order_goods[$key]->wafr_data = [];
                    }
                } else {
                    $ware_name = DB::table('warehouse')
                        ->where('ware_id', $find_dibi_data->dego_out_ware_id)
                        ->value('ware_name');
                    if ($find_wfog_data) {
                        $order_goods[$key]->wafr_data[] = $find_wfog_data;
                    }
                    $new_data['wfog_stock_amount'] = $value->digo_goo_quantity - $wfog_stock_amount;
                    $new_data['wfog_stock_type'] = $value->digo_goo_inventory;
                    $new_data['wafr_name'] = $ware_name;
                    $order_goods[$key]->wafr_data[] = $new_data;
                }

                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($value->goo_brse_id)) {
                        if ($value->goo_class == 2) {
                            $order_goods[$key]->digo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->digo_goo_name;
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $order_goods[$key]->digo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->digo_goo_name;
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $order_goods[$key]->digo_goo_name = $value->goo_bra_name . ' ' . $value->digo_goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $order_goods[$key]->digo_goo_name = $value->goo_bra_name . ' ' . $value->digo_goo_name;
                        }
                    }
                }
                unset($order_goods[$key]->goo_brse_id);
                unset($order_goods[$key]->goo_class);
            }
            $order_data = json_decode(json_encode($order_data,true),true);

            $wor_data['ware_name'] = $order_data['ware_name'];
            $wor_data['wor_number'] = $order_data['ord_order_number'];
            $wor_data['wor_create_time'] = $order_data['ord_create_time'];
            $data['wor_data'] = $wor_data;
            $data['order_data'] = $order_data;
            $data['order_goods'] = $order_goods;
            $data['dego_type'] = $find_dibi_data->dego_type;
            $data['dego_order_type'] = $find_dibi_data->dego_order_type;
            $data['delivedry'] = DeliveryService::deliveryList($user_info,$request)['data'];//快递信息
            return ['code'=>200, 'msg'=>'success', 'data'=>$data, 'type'=>1];
        } elseif ($find_dibi_data->dego_order_type == 2) { // 发货单-工单详情数据
            $work_data = DB::table('work_order as wor')
                ->leftJoin('order as o', 'o.ord_id', '=', 'wor_order_id')
                ->leftJoin('warehouse as ware', 'ware.ware_id', '=', 'wor.wor_ware_id')
                ->where('wor_id', $find_dibi_data->dego_wor_id)
                ->select('wor_id', 'wor_number', 'wor_service_sepr_id', 'wor_service_adm_id', 'wor_create_id', 'wor_service_type', 'wor_service_state', 'wor_state', 'wor_type', 'wor_remark', 'wor_pass', 'wor_create_time', 'ware_name', 'wor_shop_id', 'wor_service_shop_id', 'wor_order_id', 'wor_order_number', 'ord_id', 'wor_address')
                ->first();

            $work_data->dego_count = $find_dibi_data->dego_count;
            $work_data->dego_pic = $find_dibi_data->dego_pic;
            $work_data->dego_remark = $find_dibi_data->dego_remark;
            $work_data->wor_service_shop_name = $work_data->wor_address;
            $ord_Explainpic = [];
            $Explainpic = WashOrderService::getExplainpic($user_info, $work_data->ord_id);
            if (!empty($Explainpic['data'])) {
                $ord_Explainpic = $Explainpic['data'];
            }
            $work_data->ord_explain_pic = $ord_Explainpic;
            // 获取账号id对应的姓名
            $adm_id[] = $work_data->wor_create_id;
            $adm_id[] = $work_data->wor_service_adm_id;
            $adm_id = array_filter($adm_id); //如果没有回调函数，默认就是删除数组中值为false的元素
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_name', 'adm_id')->toArray();
            $find_admin_phone = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_phone', 'adm_id')->toArray();
            $work_data->wor_create_name = isset($find_admin[$work_data->wor_create_id]) ? $find_admin[$work_data->wor_create_id] : '';
            $work_data->wor_service_adm_name = isset($find_admin[$work_data->wor_service_adm_id]) ? $find_admin[$work_data->wor_service_adm_id] : '';
            $work_data->wor_service_adm_phone = isset($find_admin_phone[$work_data->wor_service_adm_id]) ? $find_admin_phone[$work_data->wor_service_adm_id] : '';

            // 查询服务项目名称
            $work_data->wor_service_sepr_name = DB::table('service_project')
                ->where('sepr_id', $work_data->wor_service_sepr_id)
                ->value('sepr_name');
            // 查询服务门店名称
            if(!isset($work_data->wor_service_shop_name)){
                $work_data->wor_service_shop_name = DB::table('shop')
                    ->where('shop_id', $work_data->wor_service_shop_id)
                    ->value('shop_store_name');
            }

            // 获取发货单的商品数据
            $work_goods = DB::table('dispatch_goods as digo')
                ->leftjoin('goods as goo', 'goo.goo_id', '=', 'digo.digo_goo_id')
                ->where('digo_dego_id', $request['dego_id'])
                ->select('digo_goo_name', 'digo_goo_type', 'digo_goo_goods_encode', 'digo_goo_quantity', 'digo_is_recycle', 'digo_goo_inventory', 'digo_state', 'digo_tem_goo_name', 'goo_bra_name', 'goo_brse_id', 'goo_class', 'goo_id', 'digo_id', 'digo_goo_material_pic', 'digo_goo_unit', 'digo_goo_unta_id', 'goo_unit_conversion')
                ->get()->toArray();
            // 查询系列数据
            $goo_brse_id = array_column($work_goods, 'goo_brse_id');
            $brse_data = DB::table('brand_serie')
                ->whereIn('brse_id', $goo_brse_id)
                ->pluck('brse_name', 'brse_id')
                ->toArray();
            $goo_id = array_column($work_goods, 'goo_id');
            foreach ($work_goods as $key => $value) {
                // 判断系列id,是否为空,不为空,将系列名称跟商品名称拼接在一起
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRSND_SERIE_SHOP'))) {
                    if (!empty($value->goo_brse_id)) {
                        if ($value->goo_class == 2) {
                            $work_goods[$key]->digo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->digo_goo_name;
                        } else {
                            if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                                $work_goods[$key]->digo_goo_name = $brse_data[$value->goo_brse_id] . ' ' . $value->digo_goo_name;
                            }
                        }
                    }
                }
                // 显示品牌名称
                if (!in_array($user_info->adm_shop_id, config('apisystem.NO_BRAND_SHOP'))) {
                    if ($value->goo_class == 2) {
                        $work_goods[$key]->digo_goo_name = $value->goo_bra_name . ' ' . $value->digo_goo_name;
                    } else {
                        if (!in_array($user_info->adm_shop_id, config('apisystem.NO_SELF_GOODS_SHOP'))) {
                            $work_goods[$key]->digo_goo_name = $value->goo_bra_name . ' ' . $value->digo_goo_name;
                        }
                    }
                }
                unset($work_goods[$key]->goo_brse_id);
                unset($work_goods[$key]->goo_class);
            }
            // 工单发货
            if ($find_dibi_data->dego_order_type == 2) {
                // 查找工单客户信息
                $work_client = DB::table('work_order as wor')
                    ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                    ->where('wocl_wor_id', $find_dibi_data->dego_wor_id)
                    ->select('wocl_wor_id', 'wocl_channel_unit', 'wocl_name', 'wor_type', 'wocl_standby_battery_type', 'wocl_client_id', 'wocl_bus_name', 'wocl_bus_id', 'wor_order_id','wocl_province','wocl_city','wocl_county','wocl_address', 'wocl_carowner_phone')
                    ->first();
                if ($work_client->wor_type == 2) {
                    $work_client->wocl_channel_unit = $work_client->wocl_bus_name;
                } else {
                    $work_client->wocl_channel_unit = '';
                }
                $ord_id = $work_client->wor_order_id;
            } else {
                $work_client = [];
            }
            $data['wor_data'] = $work_data;
            $data['work_goods'] = $work_goods;
            $data['dego_type'] = $find_dibi_data->dego_type;
            $data['dego_order_type'] = $find_dibi_data->dego_order_type;
            $data['work_client'] = $work_client;
            $data['delivedry'] = DeliveryService::deliveryList($user_info,$request)['data'];//快递信息
            return ['code'=>200, 'msg'=>'success', 'data'=>$data, 'type'=>2];
        } elseif ($find_dibi_data->dego_order_type == 3) { // 发货单-售后单详情数据
            $after_data = DB::table('wash_after_sale_list as afsl')
                ->leftjoin('warehouse as ware', 'ware.ware_id', '=', 'afsl.afsl_ware_id')
                ->where('afsl_id', $find_dibi_data->dego_wor_id)
                ->select('afsl_id', 'afsl_after_number', 'afsl_create_id', 'afsl_type', 'afsl_create_time', 'ware_name', 'afsl_shop_id', 'afsl_client_type')
                ->first();
            $after_data->dego_count = $find_dibi_data->dego_count;
            // 获取账号id对应的姓名
            $adm_id[] = $after_data->afsl_create_id;
            $adm_id = array_filter($adm_id); //如果没有回调函数，默认就是删除数组中值为false的元素
            $find_admin = DB::table('admin')
                ->whereIn('adm_id', $adm_id)
                ->pluck('adm_name', 'adm_id')
                ->toArray();
            $after_data->oraf_create_name = $find_admin[$after_data->afsl_create_id];

            // 查询服务门店名称
            $after_data->oraf_service_shop_name = DB::table('shop')
                ->where('shop_id', $after_data->afsl_shop_id)
                ->value('shop_store_name');

            // 获取发货单的商品数据
            $after_goods = DB::table('dispatch_goods')
                ->where('digo_dego_id', $request['dego_id'])
                ->select('digo_goo_name', 'digo_goo_type', 'digo_goo_goods_encode', 'digo_goo_price', 'digo_goo_quantity', 'digo_is_recycle', 'digo_goo_inventory', 'digo_state', 'digo_goo_material_pic')
                ->get()->toArray();

            $data['after_data'] = $after_data;
            $data['after_goods'] = $after_goods;
            $data['delivedry'] = DeliveryService::deliveryList($user_info,$request)['data'];//快递信息
            return ['code'=>200, 'msg'=>'success', 'data'=>$data, 'type'=>3];
        }
    }
}
