<?php
namespace App\Http\Models\Services\ChannelManage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

// 仓储系统 -- 供货商列表
class ChannelUnit extends Model
{

    /**
     * @name 获取结算方式name
     * @param int $show 1全部结算方式  2部分结算方式
     * @param false $type
     * @return array
     */
    public static function getPaymentWayName($show = 2,$type){
        if($show == 1){
            $data = [['id'=>1,'name'=>'账期'],['id'=>2,'name'=>'现结'],['id'=>3,'name'=>'款到发货'],['id'=>4,'name'=>'货到付款'],['id'=>5,'name'=>'月结15天'],['id'=>6,'name'=>'月结30天'],['id'=>7,'name'=>'月结60天'],['id'=>8,'name'=>'免费'],];
        }else{
            $data = [['id'=>3,'name'=>'款到发货'],['id'=>4,'name'=>'货到付款'],['id'=>5,'name'=>'月结15天'],['id'=>6,'name'=>'月结30天'],['id'=>7,'name'=>'月结60天'],['id'=>8,'name'=>'免费'],];
        }
        if($type){
            $data = array_column($data, 'name','id');
        }
        return $data;
    }

    /**
     * @name 获取交货方式name
     * @param false $type
     * @return array
     */
    public static function getDeliverTypeName($type){
        $data = [['id'=>1,'name'=>'送货上门'],['id'=>2,'name'=>'自提']];

        if($type){
            $data = array_column($data, 'name','id');
        }
        return $data;
    }
    
    /**
     * @name 获取票据类型name
     * @param false $type
     * @return array
     */
    public static function getInvoiceTypeName($type){
        $data = [['id'=>0,'name'=>'不开票'],['id'=>1,'name'=>'普通发票'],['id'=>2,'name'=>'专用发票']];

        if($type){
            $data = array_column($data, 'name','id');
        }
        return $data;
    }
}
