<?php
namespace App\Http\Models\Services\AccountControl;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

// 结款明细
class AccountSettlement extends Model
{
	// 确认
	public function check($user_info, $settlement_data, $request)
	{
		// 结款明细表 acset_type 单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)25批量结算26期初账单
		// 应收应付表 recr_type 类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 6.销售账单 7.销售出库单 8非实物开单 9.账单冲红 10订单冲单 11.加盟店订单收款 12.加盟店订单代收13.旧货回收14售后单15采购单16采购退货单17采购款到发货(预付款)18期初账单
		if ($settlement_data->acset_type == 2) { //订单账单
			// 订单账单类型结款确认
			// 查询账单的应收应付数据
			$recr_type = 3; //3.订单账单
			$find_recr_data = DB::table('receivable_credit')
				->where('recr_type', $recr_type)
				->where('recr_original_number', $settlement_data->acset_original_number)
				->orderBy('recr_id', 'desc')
				->select('recr_yet_receipt', 'recr_zero_price', 'recr_settle_price', 'recr_account_type', 'recr_id', 'recr_paid_price')
				->first();
			$acset_actual_price = 0; //实际结款金额
			$zero_price = 0; //抹零金额

			// acset_inex_type 类型1收入(正)2支出(负)
			if ($settlement_data->acset_inex_type == 1) {
				// 类型：收入
				// 账单是收入类型，向客户收钱，多抹零，就是向客户多收钱，多抹零存正数
				// 计算应结金额时，用实际结算金额减去抹零金额
				// 向客户收钱，少抹零，就是向客户少收钱，少抹零存负数
				// 计算应结金额时，用实际结算金额加上抹零金额
				// acset_zero_plus_minus 抹零金额正负1正值2负值
				if ($settlement_data->acset_zero_plus_minus == 1) {
					$zero_price = '-' . $settlement_data->acset_zero_price;
				} else {
					$zero_price = $settlement_data->acset_zero_price;
				}
			} else {
				// 类型：支出
				// 账单是支出类型，
				// 向客户付钱，少抹零，就是少给客户付钱，少抹零存正数
				// 计算应结金额时，用实际结算金额加上抹零金额
				// 向客户付钱，多抹零，就是多给客户付钱，多抹零存负数
				// 计算应结金额时，用实际结算金额减去抹零金额
				if ($settlement_data->acset_zero_plus_minus == 1) {
					$zero_price = $settlement_data->acset_zero_price;
				} else {
					$zero_price = '-' . $settlement_data->acset_zero_price;
				}
			}

			// 查询账单已经确认金额
			$sere_actual_settle_price = DB::table('settlement_receivable')
				->where('sere_shop_id', $user_info->adm_shop_id)
				->where('sere_acset_type', $settlement_data->acset_type)
				->where('sere_original_id', $settlement_data->acset_original_id)
				->where('sere_original_number', $settlement_data->acset_original_number)
				->sum('sere_actual_settle_price');
			// 计算应结金额，实际结算金额 +/- 抹零金额得出实际应结金额
			$settle_price = $settlement_data->acset_actual_price + $zero_price; //当前确认应该结算的金额
			$count_settle_price = $sere_actual_settle_price + $settle_price; //总的已结金额

			// 判断账单金额是否全部结完，与应收应付的结算金额比较
			if ($count_settle_price == $find_recr_data->recr_settle_price) {
				// 订单账单全部结款确认完，更改应收应付的状态
				$recr_update['recr_state'] = 2; //状态：1未确认2已确认3已收款4已付款
				$recr_update['recr_settle_time'] = $request['acset_with_time']; //结款时间
				$recr_update['recr_paid_price'] = $find_recr_data->recr_settle_price; //已结金额，这个是账单结款时用
				$recr_update['recr_update_time'] = date('Y-m-d H:i:s');
				$recr_res = DB::table('receivable_credit')
					->where(function ($query) use ($recr_type, $settlement_data) { //账单相关的应收账款
						$query->where('recr_type', $recr_type)
							->where('recr_original_id', $settlement_data->acset_original_id)
							->where('recr_original_number', $settlement_data->acset_original_number);
					})
					->orwhere(function ($query) use ($recr_type, $settlement_data) { //所属账单的订单应收账款
						$query->where('recr_type', $recr_type)
							->where('recr_belongs_id', $settlement_data->acset_original_id);
					})
					->update($recr_update);

				// 更改订单账单下的订单结算状态
				// ord_state 结算状态1未结算2结算中3已结算4已代收
				$ord_data['ord_state'] = 3;
				$ord_data['ord_update_time'] = date('Y-m-d H:i:s');
				$order_bill_res = DB::table('order')
					->where('ord_orbi_id', $settlement_data->acset_original_id)
					->update($ord_data);
			} else {
				$recr_res = true;
				$order_bill_res = true;
			}
			// 新增账单确认金额数据
			$sere_data['sere_adm_cid'] = $user_info->adm_cid;
			$sere_data['sere_shop_id'] = $user_info->adm_shop_id;
			$sere_data['sere_adm_id'] = $user_info->adm_id;
			$sere_data['sere_acset_id'] = $settlement_data->acset_id;
			$sere_data['sere_acset_number'] = $settlement_data->acset_number;
			$sere_data['sere_acset_type'] = $settlement_data->acset_type;
			$sere_data['sere_original_id'] = $settlement_data->acset_original_id;
			$sere_data['sere_original_number'] = $settlement_data->acset_original_number;
			$sere_data['sere_actual_settle_price'] = $settle_price; //当前确认已结金额
			$sere_res = DB::table('settlement_receivable')->insert($sere_data);

			if ($recr_res && $order_bill_res && $sere_res) {
				return ['code'=>200, 'msg'=>'success', 'data'=>'确认成功'];
			} else {
				return ['code'=>500, 'msg'=>'error', 'data'=>'确认失败 M201'];
			}
		} elseif ($settlement_data->acset_type == 3) { //工单账单
			// 工单账单类型结款确认
			// 查询账单的应收应付数据
			$recr_type = 4; //4.工单账单
			$find_recr_data = DB::table('receivable_credit')
				->where('recr_cid', $user_info->adm_cid)
				->where('recr_shop_id', $user_info->adm_shop_id)
				->where('recr_type', $recr_type)
				->where('recr_account_type', 6)
				->where('recr_original_id', $settlement_data->acset_original_id)
				->where('recr_original_number', $settlement_data->acset_original_number)
				->orderBy('recr_id', 'desc')
				->select('recr_yet_receipt', 'recr_zero_price', 'recr_settle_price', 'recr_account_type', 'recr_id', 'recr_paid_price')
				->first();
			$acset_actual_price = 0; //实际结款金额
			$zero_price = 0; //抹零金额
			// dump($settlement_data->acset_inex_type);
			// exit;
			// acset_inex_type 类型1收入(正)2支出(负)
			if ($settlement_data->acset_inex_type == 1) {
				// 类型：收入
				// 账单是收入类型，向客户收钱，多抹零，就是向客户多收钱，多抹零存正数
				// 计算应结金额时，用实际结算金额减去抹零金额
				// 向客户收钱，少抹零，就是向客户少收钱，少抹零存负数
				// 计算应结金额时，用实际结算金额加上抹零金额
				// acset_zero_plus_minus 抹零金额正负1正值2负值
				if ($settlement_data->acset_zero_plus_minus == 1) {
					$zero_price = '-' . $settlement_data->acset_zero_price;
				} else {
					$zero_price = $settlement_data->acset_zero_price;
				}
			} else {
				// 类型：支出
				// 账单是支出类型，
				// 向客户付钱，少抹零，就是少给客户付钱，少抹零存正数
				// 计算应结金额时，用实际结算金额加上抹零金额
				// 向客户付钱，多抹零，就是多给客户付钱，多抹零存负数
				// 计算应结金额时，用实际结算金额减去抹零金额
				if ($settlement_data->acset_zero_plus_minus == 1) {
					$zero_price = $settlement_data->acset_zero_price;
				} else {
					$zero_price = '-' . $settlement_data->acset_zero_price;
				}
			}

			// 查询账单已经确认金额
			$sere_actual_settle_price = DB::table('settlement_receivable')
				->where('sere_shop_id', $user_info->adm_shop_id)
				->where('sere_acset_type', $settlement_data->acset_type)
				->where('sere_original_id', $settlement_data->acset_original_id)
				->where('sere_original_number', $settlement_data->acset_original_number)
				->sum('sere_actual_settle_price');
			// 计算应结金额，实际结算金额 +/- 抹零金额得出实际应结金额
			$settle_price = $settlement_data->acset_actual_price + $zero_price; //当前确认应该结算的金额
			$count_settle_price = $sere_actual_settle_price + $settle_price; //总的已结金额
			// dump($count_settle_price);
			// dump($find_recr_data->recr_settle_price);
			// exit;
			// 判断账单金额是否全部结完，与应收应付的结算金额比较
			if ($count_settle_price == $find_recr_data->recr_settle_price) {
				// 工单账单全部结款确认完，更改应收应付的状态
				$recr_update['recr_state'] = 2; //状态：1未确认2已确认3已收款4已付款
				$recr_update['recr_settle_time'] = $request['acset_with_time']; //结款时间
				$recr_update['recr_paid_price'] = $find_recr_data->recr_settle_price; //已结金额，这个是账单结款时用
				$recr_update['recr_update_time'] = date('Y-m-d H:i:s');
				$recr_res = DB::table('receivable_credit')
					->where(function ($query) use ($recr_type, $settlement_data) { //账单相关的应收账款
						$query->where('recr_type', $recr_type)
							->where('recr_original_id', $settlement_data->acset_original_id)
							->where('recr_original_number', $settlement_data->acset_original_number);
					})
					->orwhere(function ($query) use ($recr_type, $settlement_data) { //所属账单的订单应收账款
						$query->where('recr_type', $recr_type)
							->where('recr_belongs_id', $settlement_data->acset_original_id);
					})
					->update($recr_update);
			} else {
				$recr_res = true;
			}
			// 新增账单确认金额数据
			$sere_data['sere_adm_cid'] = $user_info->adm_cid;
			$sere_data['sere_shop_id'] = $user_info->adm_shop_id;
			$sere_data['sere_adm_id'] = $user_info->adm_id;
			$sere_data['sere_acset_id'] = $settlement_data->acset_id;
			$sere_data['sere_acset_number'] = $settlement_data->acset_number;
			$sere_data['sere_acset_type'] = $settlement_data->acset_type;
			$sere_data['sere_original_id'] = $settlement_data->acset_original_id;
			$sere_data['sere_original_number'] = $settlement_data->acset_original_number;
			$sere_data['sere_actual_settle_price'] = $settle_price; //当前确认已结金额
			$sere_res = DB::table('settlement_receivable')->insert($sere_data);
			// dump($recr_res);
			// dump($sere_res);
			if ($recr_res && $sere_res) {
				return ['code'=>200, 'msg'=>'success', 'data'=>'确认成功'];
			} else {
				return ['code'=>500, 'msg'=>'error', 'data'=>'确认失败 M201'];
			}
		} elseif ($settlement_data->acset_type == 4) { //采购账单
			// 查询账单的应收应付数据
			$recr_type = 15; //15采购单
			$find_recr_data = DB::table('receivable_credit')
				->where('recr_type', $recr_type)
				->where('recr_original_number', $settlement_data->acset_original_number)
				->orderBy('recr_id', 'desc')
				->select('recr_settle_price')
				->first();
			$acset_actual_price = 0; //实际结款金额
			$zero_price = 0; //抹零金额

			// acset_inex_type 类型1收入(正)2支出(负)
			if ($settlement_data->acset_inex_type == 1) {
				// 类型：收入
				// 账单是收入类型，向客户收钱，多抹零，就是向客户多收钱，多抹零存正数
				// 计算应结金额时，用实际结算金额减去抹零金额
				// 向客户收钱，少抹零，就是向客户少收钱，少抹零存负数
				// 计算应结金额时，用实际结算金额加上抹零金额
				// acset_zero_plus_minus 抹零金额正负1正值2负值
				if ($settlement_data->acset_zero_plus_minus == 1) {
					$zero_price = '-' . $settlement_data->acset_zero_price;
				} else {
					$zero_price = $settlement_data->acset_zero_price;
				}
			} else {
				// 类型：支出
				// 账单是支出类型，
				// 向客户付钱，少抹零，就是少给客户付钱，少抹零存正数
				// 计算应结金额时，用实际结算金额加上抹零金额
				// 向客户付钱，多抹零，就是多给客户付钱，多抹零存负数
				// 计算应结金额时，用实际结算金额减去抹零金额
				if ($settlement_data->acset_zero_plus_minus == 1) {
					$zero_price = $settlement_data->acset_zero_price;
				} else {
					$zero_price = '-' . $settlement_data->acset_zero_price;
				}
			}

			// 查询账单已经确认金额
			$sere_actual_settle_price = DB::table('settlement_receivable')
				->where('sere_shop_id', $user_info->adm_shop_id)
				->where('sere_acset_type', $settlement_data->acset_type)
				->where('sere_original_id', $settlement_data->acset_original_id)
				->where('sere_original_number', $settlement_data->acset_original_number)
				->sum('sere_actual_settle_price');
			// 计算应结金额，实际结算金额 +/- 抹零金额得出实际应结金额
			$settle_price = $settlement_data->acset_actual_price + $zero_price; //当前确认应该结算的金额
			$count_settle_price = $sere_actual_settle_price + $settle_price; //总的已结金额
			// dump($value);
			// dump($recr_type);
			// dump($find_recr_data);
			// $price = $sere_actual_settle_price.'=='.$zero_price.'=='.$settle_price.'=='.$count_settle_price;
			// dump($price);die;

			// 判断账单金额是否全部结完，与应收应付的结算金额比较
			if ($count_settle_price == $find_recr_data->recr_settle_price) {
				// 订单账单全部结款确认完，更改应收应付的状态
				$recr_update['recr_state'] = 2; //状态：1未确认2已确认3已收款4已付款
				$recr_update['recr_settle_time'] = $request['acset_with_time']; //结款时间
				$recr_update['recr_paid_price'] = $find_recr_data->recr_settle_price; //已结金额，这个是账单结款时用
				$recr_update['recr_update_time'] = date('Y-m-d H:i:s');
				$recr_res = DB::table('receivable_credit')
					->where(function ($query) use ($recr_type, $settlement_data) { //账单相关的应收账款
						$query->where('recr_type', $recr_type)
							->where('recr_original_id', $settlement_data->acset_original_id)
							->where('recr_original_number', $settlement_data->acset_original_number);
					})
					->orwhere(function ($query) use ($recr_type, $settlement_data) { //所属账单的订单应收账款
						$query->where('recr_type', $recr_type)
							->where('recr_belongs_id', $settlement_data->acset_original_id);
					})
					->update($recr_update);
			} else {
				$recr_res = true;
			}
			// 新增账单确认金额数据
			$sere_data['sere_adm_cid'] = $user_info->adm_cid;
			$sere_data['sere_shop_id'] = $user_info->adm_shop_id;
			$sere_data['sere_adm_id'] = $user_info->adm_id;
			$sere_data['sere_acset_id'] = $settlement_data->acset_id;
			$sere_data['sere_acset_number'] = $settlement_data->acset_number;
			$sere_data['sere_acset_type'] = $settlement_data->acset_type;
			$sere_data['sere_original_id'] = $settlement_data->acset_original_id;
			$sere_data['sere_original_number'] = $settlement_data->acset_original_number;
			$sere_data['sere_actual_settle_price'] = $settle_price; //当前确认已结金额
			$sere_res = DB::table('settlement_receivable')->insert($sere_data);

			if ($recr_res && $sere_res) {
				return ['code'=>200, 'msg'=>'success', 'data'=>'确认成功'];
			} else {
				return ['code'=>500, 'msg'=>'error', 'data'=>'确认失败 M401'];
			}
		} elseif ($settlement_data->acset_type == 25) { //批量结算
			// 查询账单批量结款数据
			$find_data = DB::table('money_record as mr')
				->leftjoin('order_bill as ob', 'ob.orbi_id', '=', 'mr.more_orbi_id')
				->where('more_acset_id', $request['acset_id'])
				->select('orbi_id', 'orbi_number', 'orbi_create_type', 'more_this_settle_price', 'more_this_plus_minus', 'more_zero_price', 'more_zero_plus_minus')
				->get()->toArray();
			// 判断账单是否全部结款
			foreach ($find_data as $key=>$value) {
				// orbi_create_type 账单生成类型1订单账单2速电同步生成3工单账单4期初账单5采购账单
				if ($value->orbi_create_type == 1 || $value->orbi_create_type == 2) {
					$recr_type = 3; //3.订单账单
					$acset_type = 2; //订单账单
				} else if ($value->orbi_create_type == 3) {
					$recr_type = 4; //4.工单账单
					$acset_type = 3; //工单账单
				} else if ($value->orbi_create_type == 4) {
					$recr_type = 18; //18期初账单
					$acset_type = 26; //期初账单
				} else if ($value->orbi_create_type == 5) {
					$recr_type = 15; //15采购单,采购账单
					$acset_type = 4; //采购账单
				} else {
					return ['code'=>500, 'msg'=>'error', 'data'=>'确认失败 M2501'];
				}

				$zero_price = 0; //抹零金额
				// more_this_plus_minus 结款金额正负1正值2负值
				if ($value->more_this_plus_minus == 1) {
					if ($value->more_zero_plus_minus == 1) {
						$zero_price = $value->more_zero_price;
					} else {
						$zero_price = '-' . $value->more_zero_price;
					}
				} else {
					if ($value->more_zero_plus_minus == 1) {
						$zero_price = $value->more_zero_price;
					} else {
						$zero_price = '-' . $value->more_zero_price;
					}
				}
				$find_recr_data = DB::table('receivable_credit')
					->where('recr_type', $recr_type)
					->where('recr_original_id', $value->orbi_id)
					->where('recr_original_number', $value->orbi_number)
					->orderBy('recr_id', 'desc')
					->select('recr_settle_price')
					->first();
				// 查询账单已经确认金额
				$sere_actual_settle_price = DB::table('settlement_receivable')
					->where('sere_shop_id', $user_info->adm_shop_id)
					->where('sere_acset_type', $acset_type)
					->where('sere_original_id', $value->orbi_id)
					->where('sere_original_number', $value->orbi_number)
					->sum('sere_actual_settle_price');
				// 计算已结金额
				$settle_price = $value->more_this_settle_price + $zero_price; //当前确认已结金额
				$count_settle_price = $sere_actual_settle_price + $settle_price; //总的已结金额
				// dump($value);
				// dump($recr_type);
				// dump($find_recr_data);
				// $price = $sere_actual_settle_price.'=='.$zero_price.'=='.$settle_price.'=='.$count_settle_price;
				// dump($price);

				// 判断账单金额是否全部结完
				if ($count_settle_price == $find_recr_data->recr_settle_price) {
					// 订单账单全部结款确认完，更改应收应付的状态
					$recr_update['recr_state'] = 2; //状态：1未确认2已确认3已收款4已付款
					$recr_update['recr_settle_time'] = $request['acset_with_time']; //结款时间
					$recr_update['recr_paid_price'] = $find_recr_data->recr_settle_price; //已结金额
					$recr_update['recr_update_time'] = date('Y-m-d H:i:s');
					$recr_res = DB::table('receivable_credit')
						->where(function ($query) use ($recr_type, $value) { //账单相关的应收账款
							$query->where('recr_type', $recr_type)
								->where('recr_original_id', $value->orbi_id)
								->where('recr_original_number', $value->orbi_number);
						})
						->orwhere(function ($query) use ($recr_type, $value) { //所属账单的订单应收账款
							$query->where('recr_type', $recr_type)
								->where('recr_belongs_id', $value->orbi_id);
						})
						->update($recr_update);

					// 更改订单账单下的订单结算状态
					// ord_state 结算状态1未结算2结算中3已结算4已代收
					$ord_data['ord_state'] = 3;
					$ord_data['ord_update_time'] = date('Y-m-d H:i:s');
					$order_bill_res = DB::table('order')
						->where('ord_orbi_id', $value->orbi_id)
						->update($ord_data);
					unset($recr_update);
					unset($ord_data);
				} else {
					$recr_res = true;
					// $order_bill_res = true;
				}

				// 新增账单确认金额数据
				$sere_data['sere_adm_cid'] = $user_info->adm_cid;
				$sere_data['sere_shop_id'] = $user_info->adm_shop_id;
				$sere_data['sere_adm_id'] = $user_info->adm_id;
				$sere_data['sere_acset_id'] = $settlement_data->acset_id;
				$sere_data['sere_acset_number'] = $settlement_data->acset_number;
				$sere_data['sere_acset_type'] = $acset_type;
				$sere_data['sere_original_id'] = $value->orbi_id;
				$sere_data['sere_original_number'] = $value->orbi_number;
				$sere_data['sere_actual_settle_price'] = $settle_price; //当前确认已结金额
				$sere_res = DB::table('settlement_receivable')->insert($sere_data);
				if ($recr_res && $sere_res) {
				} else {
					return ['code'=>500, 'msg'=>'error', 'data'=>'确认失败 M2502'];
				}
			}
			// dump($find_data);die;
			return ['code'=>200, 'msg'=>'success', 'data'=>'确认成功'];
		} elseif ($settlement_data->acset_type == 26) { //期初账单
			// 查询账单的应收应付数据
			$recr_type = 18; //18期初账单
			$find_recr_data = DB::table('receivable_credit')
				->where('recr_type', $recr_type)
				->where('recr_original_number', $settlement_data->acset_original_number)
				->orderBy('recr_id', 'desc')
				->select('recr_settle_price')
				->first();
			$acset_actual_price = 0; //实际结款金额
			$zero_price = 0; //抹零金额

			// acset_inex_type 类型1收入(正)2支出(负)
			if ($settlement_data->acset_inex_type == 1) {
				// 类型：收入
				// 账单是收入类型，向客户收钱，多抹零，就是向客户多收钱，多抹零存正数
				// 计算应结金额时，用实际结算金额减去抹零金额
				// 向客户收钱，少抹零，就是向客户少收钱，少抹零存负数
				// 计算应结金额时，用实际结算金额加上抹零金额
				// acset_zero_plus_minus 抹零金额正负1正值2负值
				if ($settlement_data->acset_zero_plus_minus == 1) {
					$zero_price = '-' . $settlement_data->acset_zero_price;
				} else {
					$zero_price = $settlement_data->acset_zero_price;
				}
			} else {
				// 类型：支出
				// 账单是支出类型，
				// 向客户付钱，少抹零，就是少给客户付钱，少抹零存正数
				// 计算应结金额时，用实际结算金额加上抹零金额
				// 向客户付钱，多抹零，就是多给客户付钱，多抹零存负数
				// 计算应结金额时，用实际结算金额减去抹零金额
				if ($settlement_data->acset_zero_plus_minus == 1) {
					$zero_price = $settlement_data->acset_zero_price;
				} else {
					$zero_price = '-' . $settlement_data->acset_zero_price;
				}
			}

			// 查询账单已经确认金额
			$sere_actual_settle_price = DB::table('settlement_receivable')
				->where('sere_shop_id', $user_info->adm_shop_id)
				->where('sere_acset_type', $settlement_data->acset_type)
				->where('sere_original_id', $settlement_data->acset_original_id)
				->where('sere_original_number', $settlement_data->acset_original_number)
				->sum('sere_actual_settle_price');
			// 计算应结金额，实际结算金额 +/- 抹零金额得出实际应结金额
			$settle_price = $settlement_data->acset_actual_price + $zero_price; //当前确认应该结算的金额
			$count_settle_price = $sere_actual_settle_price + $settle_price; //总的已结金额

			// 判断账单金额是否全部结完，与应收应付的结算金额比较
			if ($count_settle_price == $find_recr_data->recr_settle_price) {
				// 订单账单全部结款确认完，更改应收应付的状态
				$recr_update['recr_state'] = 2; //状态：1未确认2已确认3已收款4已付款
				$recr_update['recr_settle_time'] = $request['acset_with_time']; //结款时间
				$recr_update['recr_paid_price'] = $find_recr_data->recr_settle_price; //已结金额，这个是账单结款时用
				$recr_update['recr_update_time'] = date('Y-m-d H:i:s');
				$recr_res = DB::table('receivable_credit')
					->where(function ($query) use ($recr_type, $settlement_data) { //账单相关的应收账款
						$query->where('recr_type', $recr_type)
							->where('recr_original_id', $settlement_data->acset_original_id)
							->where('recr_original_number', $settlement_data->acset_original_number);
					})
					->orwhere(function ($query) use ($recr_type, $settlement_data) { //所属账单的订单应收账款
						$query->where('recr_type', $recr_type)
							->where('recr_belongs_id', $settlement_data->acset_original_id);
					})
					->update($recr_update);
			} else {
				$recr_res = true;
			}
			// 新增账单确认金额数据
			$sere_data['sere_adm_cid'] = $user_info->adm_cid;
			$sere_data['sere_shop_id'] = $user_info->adm_shop_id;
			$sere_data['sere_adm_id'] = $user_info->adm_id;
			$sere_data['sere_acset_id'] = $settlement_data->acset_id;
			$sere_data['sere_acset_number'] = $settlement_data->acset_number;
			$sere_data['sere_acset_type'] = $settlement_data->acset_type;
			$sere_data['sere_original_id'] = $settlement_data->acset_original_id;
			$sere_data['sere_original_number'] = $settlement_data->acset_original_number;
			$sere_data['sere_actual_settle_price'] = $settle_price; //当前确认已结金额
			$sere_res = DB::table('settlement_receivable')->insert($sere_data);

			if ($recr_res && $sere_res) {
				return ['code'=>200, 'msg'=>'success', 'data'=>'确认成功'];
			} else {
				return ['code'=>500, 'msg'=>'error', 'data'=>'确认失败 M2601'];
			}
		}
		return ['code'=>500, 'msg'=>'error', 'data'=>'确认失败 M000'];
	}
}
