<?php
namespace App\Http\Models\BackEnd;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class BackEnd extends Model
{
    /**
     * [dispatch 查询发货单锁定]
     * @param [type] $adm_cid             [用户信息]
     * @param [type] $shop_id             [用户信息]
     */
    public static  function dispatch($adm_cid, $shop_id)
    {
		// 查询仓库商品锁定数据
        $find_wagl_data = DB::table('warehouse_goods_lock')
            ->where('wagl_shop_id', $shop_id)
            ->where('wagl_correlation_type', 2)
            ->where('wagl_state', 1)
            ->select('wagl_id', 'wagl_ware_id', 'wagl_original_id', 'wagl_original_number', 'wagl_original_correlation_id', 'wagl_correlation_type')
            ->get()->toArray();
        // dump($find_wagl_data);
        // exit;
        foreach ($find_wagl_data as $key => $value) {
            // 查询发货单已发货的数据
            $find_dis_data = DB::table('dispatch_bill')
                ->where('dego_id', $value->wagl_original_correlation_id)
                ->where('dego_cid', $adm_cid)
                ->where('dego_shop_id', $shop_id)
                ->where('dego_type', 2)
                ->value('dego_id');
            if ($find_dis_data) {
                // dump($find_dis_data);
                $edit_data['wagl_state'] = 2;
                $edit_res = DB::table('warehouse_goods_lock')
                    ->where('wagl_correlation_type', 2)
                    ->where('wagl_original_correlation_id', $find_dis_data)
                    ->update($edit_data);
                unset($edit_data);
                unset($edit_res);
            }
            unset($find_dis_data);
        }
        unset($find_wagl_data);
    }

    /**
     * [order 查询订单锁定]
     * @param [type] $adm_cid             [用户信息]
     * @param [type] $shop_id             [用户信息]
     */
    public static  function order($adm_cid, $shop_id)
    {
		// 查询仓库商品锁定数据
        $find_wagl_data = DB::table('warehouse_goods_lock')
            ->where('wagl_shop_id', $shop_id)
            ->where('wagl_type', 1)
            ->where('wagl_state', 1)
            ->select('wagl_id', 'wagl_ware_id', 'wagl_original_id', 'wagl_original_number', 'wagl_original_correlation_id', 'wagl_correlation_type', 'wagl_type')
            ->get()->toArray();
        // dump($find_wagl_data);
        // exit;
        foreach ($find_wagl_data as $key => $value) {
            // 查询订单数据
            $find_ord_data = DB::table('order as ord')
                ->leftjoin('work_order as wor', 'wor.wor_order_id', '=', 'ord.ord_id')
                ->where('ord_id', $value->wagl_original_id)
                ->where('ord_cid', $adm_cid)
                ->where('ord_shop_id', $shop_id)
                ->whereIn('ord_wor_state', [1, 2, 4, 11])
                ->select('ord_id', 'wor_id', 'ord_wor_state', 'ord_goods_quantity')
                ->first();
            // dump($find_ord_data);
            if ($find_ord_data) {
                // dump($find_ord_data);
                if ($find_ord_data->ord_wor_state == 2) {
                    // 查询发货单是否发货
                    $find_dis_data = DB::table('dispatch_bill')
                        ->where('dego_cid', $adm_cid)
                        ->where('dego_shop_id', $shop_id)
                        ->where('dego_order_type', 2)
                        ->where('dego_wor_id', $find_ord_data->wor_id)
                        ->where('dego_type', 2)
                        ->value('dego_id');
                    if ($find_dis_data) {
                        $edit_data['wagl_state'] = 2;
                        $edit_res = DB::table('warehouse_goods_lock')
                            ->where('wagl_type', 1)
                            ->where('wagl_original_id', $find_ord_data->ord_id)
                            ->update($edit_data);
                        unset($edit_data);
                        unset($edit_res);
                    }
                } elseif ($find_ord_data->ord_wor_state == 1) {
                    if ($find_ord_data->ord_goods_quantity == '0') {
                        $edit_data['wagl_state'] = 2;
                        $edit_res = DB::table('warehouse_goods_lock')
                            ->where('wagl_type', 1)
                            ->where('wagl_original_id', $find_ord_data->ord_id)
                            ->update($edit_data);
                        unset($edit_data);
                        unset($edit_res);
                    }
                } else {
                    $edit_data['wagl_state'] = 2;
                    $edit_res = DB::table('warehouse_goods_lock')
                        ->where('wagl_type', 1)
                        ->where('wagl_original_id', $find_ord_data->ord_id)
                        ->update($edit_data);
                    unset($edit_data);
                    unset($edit_res);
                }
            }
            unset($find_ord_data);
        }
        unset($find_wagl_data);
    }

    /**
     * [transferringOrder 查询调拨单锁定]
     * @param [type] $adm_cid             [用户信息]
     * @param [type] $shop_id             [用户信息]
     */
    public static  function transferringOrder($adm_cid, $shop_id)
    {
		// 查询仓库商品锁定数据
        $find_wagl_data = DB::table('warehouse_goods_lock')
            ->where('wagl_shop_id', $shop_id)
            ->where('wagl_correlation_type', 3)
            ->where('wagl_state', 1)
            ->select('wagl_id', 'wagl_ware_id', 'wagl_original_id', 'wagl_original_number', 'wagl_original_correlation_id', 'wagl_correlation_type')
            ->get()->toArray();
        // dump($find_wagl_data);
        // exit;
        foreach ($find_wagl_data as $key => $value) {
            // 查询调拨单已入库的数据
            $find_tror_data = DB::table('transferring_order')
                ->where('tror_id', $value->wagl_original_correlation_id)
                ->where('tror_cid', $adm_cid)
                ->where('tror_shop_id', $shop_id)
                ->where('tror_state', 4)
                ->where('tror_delete', 1)
                ->value('tror_id');
            if ($find_tror_data) {
                dump($find_tror_data);
                /* $edit_data['wagl_state'] = 2;
                $edit_res = DB::table('warehouse_goods_lock')
                    ->where('wagl_correlation_type', 2)
                    ->where('wagl_original_correlation_id', $value->wagl_original_correlation_id)
                    ->update($edit_data);
                unset($edit_data);
                unset($edit_res); */
            }
            unset($find_dis_data);
        }
        unset($find_wagl_data);
    }
}
