<?php

namespace App\Http\Models\Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Models\Api\Warehouse;
use App\Http\Models\Api\StockingSelling;
use App\Http\Models\Api\SellDetail;

class WorkOrder extends Model
{
    /**
     * [commonPass 审核通过共有部分的代码]
     * @param  [array] $request    [前端提交的数据]
     * @param  [array] $user_info  [用户信息]
     * @param  [array] $find_wor   [工单信息]
     * @param  [int]   $wor_coll_price  [结算金额(代收金额)]
     * @param  [int]   $wor_price  [结算金额]
     * @param  [array] $subtract   [商品id所对应的商品数量]
     * @param  [array] $goo_info   [商品id所对应的商品数量]
     * @param  [int]   $wor_plus_minus  [金额正负值1正数  2负数]
     * @return [type]             [description]
     */
    public static function joinReceivable(
        $request,
        $user_info,
        $find_wor,
        $wor_coll_price,
        $wor_price,
        $subtract,
        $goo_info,
        $wor_plus_minus
    ) {

        //如果订单类型是退货单金额为负数，金额类型为负数的
        $plus_minus = 1;
        if ($request['wor_service_type'] == 4 || $find_wor->wor_plus_minus == 2) {
            $plus_minus = 2;
        }
        // 查询加盟店工单信息
        $find_wor = DB::table('work_order as wor')
            ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
            ->where('wor_order_id', $find_wor->wocl_join_ord_id)
            ->select('wor_id', 'wor_number', 'wor_service_state', 'wor_order_id', 'wocl_client_id', 'wor_collection_price', 'wor_order_number', 'wor_service_shop_id', 'wor_is_recycle', 'wor_service_type', 'wor_plus_minus', 'wor_collection_bill', 'wocl_collect_state', 'wocl_name', 'wocl_channel_unit', 'wocl_acti_id', 'wor_service_sepr_id', 'wocl_wor_type', 'wor_shop_id', 'wocl_join_audit_adm_id', 'wor_superior_shop_id', 'wor_cid', 'wor_actual_price', 'wocl_plus_minus')
            ->first();
        if (empty($find_wor)) {
            return false;
        }
        $shop_data = DB::table('shop')
            ->where('shop_id', $user_info->adm_shop_id)
            ->first(['shop_store_name','shop_id','shop_type']);
        $adm_name = DB::table('admin')
            ->where('adm_id', $find_wor->wocl_join_audit_adm_id)
            ->value('adm_name');
        $user_info = (object)[];
        $user_info->shop_superior_id = $find_wor->wor_superior_shop_id;
        $user_info->adm_shop_id = $find_wor->wor_shop_id;
        $user_info->adm_id = $find_wor->wocl_join_audit_adm_id;
        $user_info->adm_cid = $find_wor->wor_cid;
        $user_info->adm_name = $adm_name;

        $wocl_client_name = $find_wor->wocl_channel_unit ? $find_wor->wocl_channel_unit : $find_wor->wocl_name;

        $cli_info = DB::table('order_client')
            ->where('orcl_ord_id', $find_wor->wor_order_id)
            ->first(['orcl_acc_subject_id', 'orcl_channel_unit', 'orcl_name', 'orcl_collect_state']);

        // 获取到当前工单的订单信息
        $ord_info = DB::table('order')
            ->where('ord_id', $find_wor->wor_order_id)
            ->select('ord_type', 'ord_client_id', 'ord_state', 'ord_remark', 'ord_actual_price', 'ord_payment_way', 'ord_order_price', 'ord_collection_price', 'ord_plus_minus', 'ord_create_time')
            ->first();


        //技师代收  代收金额为0   结算方式为现结
        if ($find_wor->wocl_collect_state == 1 && $find_wor->wor_collection_price == 0 && $ord_info->ord_payment_way == 2) {
            // 生成结款明细
            $acset_id = AccountingSettlement::add(
                $user_info, // [用户信息]
                1, // [单据类型1订单结算2订单账单3工单账单11订单退款12工单代收]
                $find_wor->wor_order_id, // [与单据类型对应的id]
                $find_wor->wor_order_number, // [与单据类型对应的单号]
                5, // [买家类型1门店零售2来往单位]
                $shop_data->shop_id, // [派单门店id]
                $shop_data->shop_store_name, // [派单门店名称]
                $find_wor->wocl_acti_id, // [会计科目id]
                1, // [类型1收入2支出]
                $request['wor_actual_price'] * 100, // [实际金额](此次的实收金额)
                $request['wor_actual_price'] * 100, // [合计金额](此次的应收金额)
                0, // [欠收金额](此次结款后还应收金额)
                0, // [抹零金额]
                $request['remark'] ? $request['remark'] : '' //[备注]
            );

            // 3.订单应收
            $ord_bill = ReceivableBill::create(
                $user_info, //用户信息
                3, //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
                0, //应收账款id
                $find_wor->wor_order_id, //原始id(订单id)
                $find_wor->wor_order_number, //应收账款单号/原始号(订单编号)
                5, //客户类型：1.门店零售 2.来往单位
                $shop_data->shop_id, //派单门店id
                $shop_data->shop_store_name, //派单门店名称
                $request['wor_actual_price'] * 100, //结算金额(应收金额)
                '', //结款时间
                $cli_info->orcl_acc_subject_id, //会计科目id
                $ord_info->ord_state == 1 ? 0 : $request['wor_actual_price'] * 100, //实际金额(应收金额)
                0, //抹零金额
                1,  //状态：1.未核销 2.已核销
                1,  //应收账单id是否是自己 1.不是 2.是
                $ord_info->ord_remark,  //备注
                $ord_info->ord_state == 1 ? 0 : $request['wor_actual_price'] * 100,  //已收金额
                '', //截止时间
                $wor_plus_minus, //金额正负1正   2负值
                1, //显示类型：1订单收款
                $ord_info->ord_create_time,
                1 //是否合并代收：1是2否
            );
            // 生成操作记录
            $edit_record = orderLog($user_info, 0, $request['wor_id'], '审核通过工单');
            if ($acset_id && $ord_bill) {
                return true;
            } else {
                return false;
            }
        }

        if ($find_wor->wocl_collect_state == 1 || $wor_coll_price > 0) {
            // ord_payment_way 2现结，订单结算方式为现结的，可以生成代收的应收账款
            // 计算出订单 代收金额/应收金额
            $ord_coll_price = 0;
            foreach ($subtract as $key => $value) {
                $ord_coll_price += $goo_info[$key]->orgo_collection_price * $value; //代收金额
            }

            // 让技师收款，就要在生成结款明细 wocl_collect_state 技师收钱：0未选择1是2否

            // 1. 订单代收
            $ord_coll_bill = ReceivableBill::create(
                $user_info, //用户信息
                3, //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
                0, //应收账款id
                $find_wor->wor_order_id, //原始id(订单id)
                $find_wor->wor_order_number, //应收账款单号/原始号(订单编号)
                5, //客户类型：1.会员零售 2.来往单位 3.加盟店 4会员零售(工单代收）
                $shop_data->shop_id, //派单门店id
                $shop_data->shop_store_name, //派单门店名称
                $ord_coll_price, //结算金额(代收金额)
                '', //结款时间
                $cli_info->orcl_acc_subject_id, //会计科目id
                $find_wor->wocl_collect_state == 1 ? $ord_coll_price : 0, //实际金额(未结算:0，已结算：代收金额)
                0, //抹零金额
                1,  //状态：1.未核销 2.已核销
                1,  //应收账单id是否是自己 1.不是 2.是
                $ord_info->ord_remark,  //备注
                $find_wor->wocl_collect_state == 1 ? $ord_coll_price : 0,  //已收金额
                '', //截止时间
                2, //金额正负1正   2负值
                2, //显示类型：1订单收款 2受托代收（订单代收）3委托代收（工单代收）4工单费用（工单收款）5订单账单 6工单账单 7销售账单 8预收款 9销售出库单
                $ord_info->ord_create_time,
                1 //是否合并代收：1是2否
            );

            // 2 工单代收，生成工单代收应收账款，判断是否让技师收款
            $recr_id = ReceivableBill::create(
                $user_info, //用户信息
                4, //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
                0, //应收账款id
                $find_wor->wor_id, //原始id(工单id)
                $find_wor->wor_number, //应收账款单号/原始号(工单编号)
                5, //客户类型：1.门店零售 2.来往单位 3.加盟店 4会员零售(工单代收）
                $shop_data->shop_id, //派单门店id
                $shop_data->shop_store_name, //派单门店名称
                $wor_coll_price, //结算金额
                '', //结款时间
                $find_wor->wocl_acti_id, //会计科目id
                $find_wor->wocl_collect_state == 1 ? $wor_coll_price : 0, //实际金额
                0, //抹零金额
                1,  //状态：1.未核销 2.已核销
                1,  //应收账单id是否是自己 1.不是 2.是
                $request['remark'] ? $request['remark'] : '',  //备注
                $find_wor->wocl_collect_state == 1 ? $wor_coll_price : 0,  //已收金额
                '', //截止时间
                1, //金额正负:1正2负值
                3, //显示类型：1订单收款 2受托代收（订单代收）3委托代收（工单代收）4工单费用（工单收款）5订单账单 6工单账单 7销售账单 8预收款 9销售出库单
                2, //是否合并代收：1是2否
                $ord_info->ord_create_time,
                $find_wor->wocl_collect_state //技师是否收钱：0未选择1是2否
            );

            // 判断是否生成结款明细，让技师收款，就生成结款明细
            if ($find_wor->wocl_collect_state == 1) {
                // 生成结款明细
                $acset_id = AccountingSettlement::add(
                    $user_info, // [用户信息]
                    12, // [单据类型1订单结算2订单账单3工单账单11订单退款12工单代收]
                    $find_wor->wor_id, // [与单据类型对应的id]
                    $find_wor->wor_number, // [与单据类型对应的单号]
                    5, // [买家类型1门店零售2来往单位]
                    $shop_data->shop_id, // [派单门店id]
                    $shop_data->shop_store_name, // [派单门店名称]
                    $find_wor->wocl_acti_id, // [会计科目id]
                    1, // [类型1收入2支出]
                    $wor_coll_price, // [实际金额](此次的实收金额)
                    $wor_coll_price, // [合计金额](此次的应收金额)
                    0, // [欠收金额](此次结款后还应收金额)
                    0, // [抹零金额]
                    $request['remark'] ? $request['remark'] : '' //[备注]
                );
            } else {
                $acset_id = true;
            }
        } else {
            $ord_coll_bill = true;
            $recr_id = true;
            $acset_id = true;
        }

        // 判断是否应该生成应收账款、结款明细
        // 订单状态为未结算时，可以生成应收账款、结款明细
        if ($ord_info->ord_state == 1) {
            // 3.订单应收
            $ord_bill = ReceivableBill::create(
                $user_info, //用户信息
                3, //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
                0, //应收账款id
                $find_wor->wor_order_id, //原始id(订单id)
                $find_wor->wor_order_number, //应收账款单号/原始号(订单编号)
                5, //客户类型：1.门店零售 2.来往单位
                $shop_data->shop_id, //派单门店id
                $shop_data->shop_store_name, //派单门店名称
                $wor_price, //结算金额(应收金额)
                '', //结款时间
                $cli_info->orcl_acc_subject_id, //会计科目id
                $ord_info->ord_state == 1 ? 0 : $wor_price, //实际金额(应收金额)
                0, //抹零金额
                1,  //状态：1.未核销 2.已核销
                1,  //应收账单id是否是自己 1.不是 2.是
                $ord_info->ord_remark,  //备注
                $ord_info->ord_state == 1 ? 0 : $wor_price,  //已收金额
                '', //截止时间
                $wor_plus_minus, //金额正负1正   2负值
                $find_wor->wor_service_type == 4 ? 10 : 1, //显示类型：1订单收款 10订单退款
                $ord_info->ord_create_time,
                1 //是否合并代收：1是2否
            );

            // 4.工单应收  工单的销售金额不生成应收账款，加盟店的生成
            if (isset($shop_data->shop_type) && $shop_data->shop_type == 3) {
                $wor_bill = ReceivableBill::create(
                    $user_info, //用户信息
                    4, //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
                    0, //应收账款id
                    $find_wor->wor_id, //原始id(工单id)
                    $find_wor->wor_number, //应收账款单号/原始号(工单编号)
                    5, //客户类型：1.门店零售 2.来往单位
                    $shop_data->shop_id, //派单门店id
                    $shop_data->shop_store_name, //派单门店名称
                    // $wor_price, //结算金额
                    $wor_price, //结算金额
                    '', //结款时间
                    $cli_info->orcl_acc_subject_id, //会计科目id
                    $ord_info->ord_state == 1 ? 0 : $wor_price, //实际金额
                    0,  //抹零金额
                    1,  //状态：1.未核销 2.已核销
                    1,  //应收账单id是否是自己 1.不是 2.是
                    $request['remark'] ? $request['remark'] : '',  //备注
                    $ord_info->ord_state == 1 ? 0 : $wor_price,  //已收金额
                    '', //截止时间
                    $plus_minus, //金额正负1正   2负值
                    4, //显示类型：1订单收款 2受托代收（订单代收）3委托代收（工单代收）4工单费用（工单收款）5订单账单 6工单账单 7销售账单 8预收款 9销售出库单
                    $ord_info->ord_create_time,
                    1 //是否合并代收：1是2否
                );
            } else {
                $wor_bill = true;
            }
        } else {
            // 订单状态为已结算状态，不生成应收账款
            $wor_bill = true;
            $ord_bill = true;
        }
        if ($ord_coll_bill && $recr_id && $acset_id && $wor_bill && $ord_bill) {
            return true;
        } else {
            return false;
        }
    }

    // 加盟店结算
    public static function settlement($request, $find_wor, $user_info)
    {
        // 1. 订单表修改状态
        $wor_data['wor_account_state'] = 2;//结算状态1未结算2已结算
        $wor_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_res = DB::table('work_order')
                ->where('wor_id', $request['wor_id'])
                ->update($wor_data);
        // 判断是否有图片需要上传
        if (!empty($request['orcl_img'])) {
            foreach ($request['orcl_img'] as $key => $value) {
                // 调用全局函数 上传图片
                $image[] = uploadBase64Img($value);
            }
            $image = implode(",", $image);
        } else {
            $image = '';
        }

        // 2.订单客户表修改结算凭证 会计科目
        $wocl_data['wocl_acc_subject_id'] = $request['orcl_acc_subject_id']; //会计科目id
        $wocl_data['wocl_img'] = $image; //结算凭证图片
        $wocl_data['wocl_update_time'] = date('Y-m-d H:i:s');
        $wocl_res = DB::table('work_client')
                ->where('wocl_wor_id', $request['wor_id'])
                ->update($wocl_data);

        $service_shop_type = 3;//服务门店类型 3加盟店
        // 加盟店的门店名称
        $client_name =  DB::table('shop')
                ->where('shop_id', $find_wor->wor_service_shop_id)
                ->value('shop_store_name');
        // $find_wor->ord_client_id = $find_wor->ord_service_shop_id;//加盟店id

        //如果订单类型是发货单不合并代收(发货单没有代收)
        if ($find_wor->wor_service_type == 5) {
            $request->offsetSet('merge_collection', 2);
        }
        // 需要把已经生成的应收账款的，已收金额添加上
        if ($find_wor->wor_service_type == 4) {
            // 订单类型为退货单的情况
            $acset_type = 11;
        } else {
            // 其他订单类型的情况
            $acset_type = 16;//结款明细单据类型：16加盟店订单收款17加盟店订单代收
        }
        // 1合并代收   2不合并代收
        if ($request['merge_collection'] == 1 && $find_wor->wor_collection_price > 0) {
            // 将订单金额与代收金额进行合并
            $find_wor->wocl_assign_price = $find_wor->wor_collection_price - $find_wor->wocl_assign_price;

            if ($find_wor->wocl_assign_price < 0) {
                $find_wor->wocl_plus_minus = 2;
            } else {
                $find_wor->wocl_plus_minus = 1;
            }
            $find_wor->wocl_assign_price = abs($find_wor->wocl_assign_price);
            $merge_collection = 2;

            $find_recr_data = DB::table('receivable_credit')
                ->where('recr_type', 4)
                ->where('recr_account_type', 3)
                ->where('recr_original_id', $request['wor_id'])
                ->where('recr_original_number', $find_wor->wor_number)
                ->select('recr_id', 'recr_settle_price')
                ->first();
            $recr_edit_data['recr_yet_receipt'] = $find_recr_data->recr_settle_price;
            $recr_edit_data['recr_leisurely_type'] = 1;//1收款待核对
            $recr_edit_data['recr_settle_time'] = date('Y-m-d H:i:s');//结款时间
            $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
            $wor_bill =  DB::table('receivable_credit')
                ->where('recr_id', $find_recr_data->recr_id)
                ->update($recr_edit_data);
        } else {
            if ($find_wor->wocl_plus_minus == 1) {
                $find_wor->wocl_plus_minus = 2;//应收账款的加盟店金额应该为负值
            } else {
                $find_wor->wocl_plus_minus = 1;//应收账款的加盟店金额应该为正值
            }
            $merge_collection = 1;
            $wor_bill = true;
        }
        
        $find_recr_data = DB::table('receivable_credit')
            ->where('recr_type', 4)
            ->where('recr_account_type', 4)
            ->where('recr_original_id', $request['wor_id'])
            ->where('recr_original_number', $find_wor->wor_number)
            ->select('recr_id', 'recr_settle_price')
            ->first();
        $recr_edit_data['recr_yet_receipt'] = $find_recr_data->recr_settle_price;
        $recr_edit_data['recr_settle_time'] = date('Y-m-d H:i:s');//结款时间
        $recr_edit_data['recr_update_time'] = date('Y-m-d H:i:s');
        $wor_bill_two =  DB::table('receivable_credit')
            ->where('recr_id', $find_recr_data->recr_id)
            ->update($recr_edit_data);
            
        // 添加结款明细
        $acset_res = AccountingSettlement::add(
            $user_info,                         // [用户信息]
            18,                                 // 18工单结算
            $request['wor_id'],                 // [与单据类型对应的id]
            $find_wor->wor_number,              // [与单据类型对应的单号]
            3,                                  // [买家类型1门店零售2来往单位]
            $find_wor->wor_service_shop_id,     // [加盟店shopid]
            $client_name,                       // [加盟店名称]
            $request['orcl_acc_subject_id'],    // [会计科目id]
            $find_wor->wocl_plus_minus,          // [类型1收入2支出]
            $find_wor->wocl_assign_price,        // [实际金额](此次的实收金额)
            $find_wor->wocl_assign_price,        // [合计金额](此次的应收金额)
            0,                                  // [欠收金额](此次结款后还应收金额)
            0,                                  // [抹零金额]
            '',                                 // [备注]
            0,                                  // [结款类型]
            date('Y-m-d H:i:s'),                // [结款时间]
            $merge_collection                   // 是否合并代收1不合并 2合并
        );
        if ($acset_res && $wor_bill_two && $wor_bill) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * [editDispatchBill 改单，发货单数据更改]
     * @param  [type] $user_info            [用户信息]
     * @param  [type] $shop_id              [总店id]
     * @param  [type] $wor_id               [工单id]
     * @param  [type] $wor_data             [工单数据]
     * @param  [type] $wor_service_adm_id   [改单的服务技师id]
     * @param  [type] $goo_all_quantity     [改单的商品总数量]
     * @param  [type] $dego_goo_data        [改单的发货单商品数据]
     * @param  [type] $ware_goo_id          [改单的商品id]
     * @param  [type] $ware_goo_number      [改单的商品数量：商品id=>商品数量]
     * @param  [type] $ware_goo_inventory   [改单的出库类型：商品id=>出库类型]
     * @param  [type] $ware_goo_wago_class  [改单的仓库类别：商品id=>仓库类别]
     * @param  [type] $add_goo_id           [改单添加的商品]
     * @param  [type] $add_goo_is_recycle   [改单添加的商品回收类型]
     * @param  [type] $add_goo_price        [改单添加的商品售价]
     * @param  [type] $add_goo_amount       [改单添加的商品数量]
     * @param  [type] $add_goo_inventory    [改单添加的商品出库类型]
     * @param  [type] $add_goo_name         [改单添加的商品名称]
     * @param  [type] $add_goo_goods_encode [改单添加的商品检索编码]
     * @param  [type] $new_ware_id          [新仓库id]
     * @return [type]                       [description]
     */
    public function editDispatchBill(
        $user_info,
        $shop_id,
        $wor_id,
        $wor_data,
        $wor_service_adm_id,
        $goo_all_quantity,
        $dego_goo_data,
        $ware_goo_id,
        $ware_goo_number,
        $ware_goo_inventory,
        $ware_goo_wago_class,
        $add_goo_id,
        $add_goo_is_recycle,
        $add_goo_price,
        $add_goo_amount,
        $add_goo_inventory,
        $add_goo_name,
        $add_goo_goods_encode
    ) {
        // 1 改派技师的情况，判断原来技师的发货单是否发货
        // 1.2 原来的发货单没有发货，原来的发货单作废，发货单的商品锁定库存改成正常库存，生成新的发货单
        // 2 没有改派技师，用下面的流程
        // 发货单，未发货之前，如果改动商品，原来发货单作废，重新生成发货单；发货之后，暂时不管发货单。
        // 查询当前工单未出库的发货单
        $find_dego_data = DB::table('dispatch_bill')
            ->where('dego_order_type', 2)
            ->where('dego_type', 4) //类型：1未出库2已出库3作废4锁定
            ->where('dego_wor_id', $wor_id)
            ->orderBy('dego_id', 'desc')
            ->first(['dego_id', 'dego_type', 'dego_out_ware_id', 'dego_count', 'dego_number']);
        //1固定仓2移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $wor_data->wor_ware_id)
            ->value('ware_type');
        // 查询客户id
        $wocl_client_id = DB::table('work_client')
            ->where('wocl_wor_id', $wor_id)
            ->value('wocl_client_id');
        if (!empty($find_dego_data) || $wor_data->wor_service_adm_id != $wor_service_adm_id) {
            if (!empty($find_dego_data)) {
                // 当前发货单未发货
                // 1.作废原来的发货单，原来发货单商品的锁定库存要还回去
                $update_type['dego_type'] = 3;
                $update_type['dego_update_time'] = date('Y-m-d H:i:s');
                $dego_update_res = DB::table('dispatch_bill')
                    ->where('dego_id', $find_dego_data->dego_id)
                    ->update($update_type);

                // 查询出原来发货单的商品
                $find_digo_data = DB::table('dispatch_goods')
                    ->where('digo_dego_id', $find_dego_data->dego_id)
                    ->get(['digo_goo_id', 'digo_wago_class', 'digo_goo_quantity', 'digo_goo_inventory'])
                    ->toArray();
                $digo_goo_id = array_column($find_digo_data, 'digo_goo_id');
                $digo_wago_class = array_column($find_digo_data, 'digo_wago_class', 'digo_goo_id');
                $digo_goo_quantity = array_column($find_digo_data, 'digo_goo_quantity', 'digo_goo_id');
                $digo_goo_inventory = array_column($find_digo_data, 'digo_goo_inventory', 'digo_goo_id');

                // 将原来发货单的商品，锁定库存转正常库存
                $lock_turn_normal = Warehouse::lockTurnNormal(
                    $user_info, //用户信息
                    $find_dego_data->dego_out_ware_id, //仓库id
                    $digo_goo_id, //商品id
                    $digo_goo_quantity, //商品id=>商品数量
                    $digo_goo_inventory, //商品id=>出库类型
                    $digo_wago_class //商品id=>仓库类别
                );
            }
            
            //如果是固定仓
            if ($ware_type == 1) {
                $new_dispatch = $this->createNewDispatchBill(
                    $user_info, //用户信息
                    $shop_id, //总店id
                    $wor_id, //工单id
                    $wor_data, //工单数据
                    $wor_service_adm_id, //改单的服务技师id
                    $wocl_client_id, //客户id
                    $goo_all_quantity, //发货单的商品总数量
                    $dego_goo_data, //发货单商品数据
                    $ware_goo_id, //发货单的商品id
                    $ware_goo_number, //发货单的商品数量：商品id=>商品数量
                    $ware_goo_inventory, //发货单商品的出库类型：商品id=>库存扣除方式
                    $ware_goo_wago_class //发货单商品的仓库类别：商品id=>仓库类别
                );
            } else {
                // // 如果是移动仓，正常库存转锁定库存
                // $new_dispatch = Warehouse::normalTurnLock(
                //     $user_info, //用户信息
                //     $wor_data->wor_ware_id, //仓库id
                //     $ware_goo_id, //商品id
                //     $ware_goo_number, //商品id=>商品数量
                //     $ware_goo_inventory, //商品id=>库存扣除方式
                //     $ware_goo_wago_class //商品id=>仓库类别
                // );
                $new_dispatch = ['code'=>200, 'msg'=>'success', 'data'=>'发货单数据更改成功'];
            }
            // 生成新的发货单
            return $new_dispatch;
        } else {
            // 当前工单的发货单已经发货，改单的时候有新添加的商品，新增发货单
            if ($add_goo_id && $wor_data->wor_service_adm_id == $wor_service_adm_id) {
                foreach ($add_goo_id as $key => $value) {
                    $dego_add_goo_data[$key]['digo_goo_id'] = $value;
                    $dego_add_goo_data[$key]['digo_goo_name'] = $add_goo_name[$key];
                    $dego_add_goo_data[$key]['digo_goo_goods_encode'] = $add_goo_goods_encode[$key];
                    $dego_add_goo_data[$key]['digo_goo_price'] = $add_goo_price[$key];
                    $dego_add_goo_data[$key]['digo_goo_quantity'] = $add_goo_amount[$key];
                    $dego_add_goo_data[$key]['digo_is_recycle'] = $add_goo_is_recycle[$key];
                    $dego_add_goo_data[$key]['digo_goo_inventory'] = $add_goo_inventory[$key];

                    $dego_goo_quantity[$value] = $add_goo_amount[$key];
                    $dego_goo_inventory[$value] = $add_goo_inventory[$key];
                }
                // 如果是固定仓
                if ($ware_type == 1) {
                    // 生成新的发货单
                    $new_dispatch = $this->createNewDispatchBill(
                        $user_info,
                        $shop_id,
                        $wor_id,
                        $wor_data,
                        $wor_service_adm_id,
                        $wocl_client_id,
                        count($add_goo_id),
                        $dego_add_goo_data,
                        $add_goo_id,
                        $dego_goo_quantity,
                        $dego_goo_inventory,
                        $ware_goo_wago_class
                    );
                } else {
                    // // 如果是移动仓，正常库存转锁定库存
                    // $new_dispatch = Warehouse::normalTurnLock(
                    //     $user_info, //用户信息
                    //     $wor_data->wor_ware_id, //仓库id
                    //     $ware_goo_id, //商品id
                    //     $ware_goo_number, //商品id=>商品数量
                    //     $ware_goo_inventory, //商品id=>库存扣除方式
                    //     $ware_goo_wago_class //商品id=>仓库类别
                    // );
                    $new_dispatch = ['code'=>200, 'msg'=>'success', 'data'=>'发货单数据更改成功'];
                }
                return $new_dispatch;
            } else {
                return ['code'=>200, 'msg'=>'success', 'data'=>'发货单数据更改成功'];
            }
        }
    }

    /**
     * [editWorkData 改单，工单数据更改]
     * @param  [array] $user_info                [用户信息]
     * @param  [array] $request                  [改单提交数据]
     * @param  [array] $wor_data                 [工单查询数据]
     * @param  [array] $ord_info                 [订单查询数据]
     * @param  [array] $ord_client               [订单客户数据]
     * @param  [array] $del_wogo_id              [删除的工单商品id]
     * @param  [array] $del_goo_id               [删除的商品id]
     * @param  [array] $del_goo_price            [删除的商品价格]
     * @param  [array] $del_goo_amount           [删除的商品数量：'商品id'=>商品退货数量]
     * @param  [array] $add_goo_id               [新增的商品id]
     * @param  [array] $add_goo_is_recycle       [新增的商品回收类型]
     * @param  [array] $add_goo_price            [新增的商品售价]
     * @param  [array] $add_goo_amount           [新增的商品数量]
     * @param  [array] $add_goo_collection_price [新增的商品的代收金额]
     * @param  [array] $add_goo_inventory        [新增的商品的出库类型]
     * @param  [int] $recycle_number           [工单回收的总数量]
     * @param  [int] $wor_is_recycle           [工单是否回收]
     * @param  [int] $goo_all_quantity         [工单总的商品数量]
     * @param  [int] $goo_all_collection       [工单总的代收金额]
     * @param  [array] $add_goo_data       [工单的改单商品数据，数组]
     * @return [type]                           [description]
     */
    public function editWorkData(
        $user_info,
        $request,
        $wor_data,
        $ord_info,
        $ord_client,
        $del_wogo_id,
        $del_goo_id,
        $del_goo_price,
        $del_goo_amount,
        $add_goo_id,
        $add_goo_is_recycle,
        $add_goo_price,
        $add_goo_amount,
        $add_goo_collection_price,
        $add_goo_inventory,
        $goo_all_price,
        $recycle_number,
        $wor_is_recycle,
        $goo_all_quantity,
        $goo_all_collection,
        $add_goo_data
    ) {
        if (!empty($del_wogo_id) || $request['wor_service_adm_id'] != $wor_data->wor_service_adm_id) {
            if (!empty($del_wogo_id)) {
                // 2.1 存在工单商品被删除的情况，需要把删除的商品生成退换回收单，回收到仓库
                // 1 将工单商品表删除的商品,直接删除
                $update_wogo_del = DB::table('work_good')
                    ->where('wogo_wor_id', $request['wor_id'])
                    ->whereIn('wogo_id', $del_wogo_id)
                    ->delete();
            } else {
                $update_wogo_del = true;
            }

            // 查询工单对应的已出库发货单的数据
            $find_dego_data = DB::table('dispatch_bill')
                ->where('dego_order_type', 2)
                ->where('dego_type', 2) //类型：1未出库2已出库3作废
                ->where('dego_exchange_state', 1)
                ->where('dego_wor_id', $request['wor_id'])
                ->orderBy('dego_id', 'desc')
                ->first(['dego_id', 'dego_type']);
            if (!empty($find_dego_data) && $find_dego_data->dego_type == 2) {
                if ($request['wor_service_adm_id'] != $wor_data->wor_service_adm_id) {
                    // 2.2 改换技师的情况，需要把原来已经给技师发货的商品，生成退换回收单，回收到仓库
                    // 查询出原来发货单的商品
                    $find_digo_data = DB::table('dispatch_goods')
                        ->where('digo_dego_id', $find_dego_data->dego_id)
                        ->get(['digo_goo_id', 'digo_goo_quantity', 'digo_goo_inventory'])
                        ->toArray();
                    $del_goo_id = array_column($find_digo_data, 'digo_goo_id');
                    $del_goo_amount = array_column($find_digo_data, 'digo_goo_quantity', 'digo_goo_id');
                    // 查询发货单商品对应的销售金额
                    $find_work_good = DB::table('work_good')
                        ->where('wogo_wor_id', $request['wor_id'])
                        ->where('wogo_state', 1)
                        ->whereIn('wogo_goo_id', $del_goo_id)
                        ->pluck('wogo_goo_price', 'wogo_goo_id')
                        ->toArray();
                    foreach ($find_work_good as $key => $value) {
                        $del_goo_price[$key] = $value / 100;
                    }
                    $dibi_edit_data['dego_exchange_state'] = 2;
                    $dibi_edit_data['dego_update_time'] = date('Y-m-d H:i:s');
                    $update_dibi_res = DB::table('dispatch_bill')
                        ->where('dego_id', $find_dego_data->dego_id)
                        ->update($dibi_edit_data);
                }

                // 查询出技师的移动仓
                $service_ware_id = DB::table('warehouse')
                    ->where('ware_type', 2)
                    ->where('ware_leader_id', $wor_data->wor_service_adm_id)
                    ->value('ware_id');

                // 发货单已经发货出库的需要生成退换回收单
                // 3. 删除的商品需要退回到仓库，生成退换回收单
                // 或者是改单的已经发货的商品，生成退换回收单
                // $rec_res = RecedeRecycle::add(
                //     $user_info, //用户信息
                //     $wor_data->wor_type, //买家类型 1.门店零售 2.来往单位
                //     $ord_info->ord_client_id,//来往单位id/客户id
                //     $wor_data->wor_number,//工单号
                //     $request['wor_id'],//工单id
                //     2,//1. 售后退货 2. 工单退货 3 页面新增 4 退货单
                //     $del_goo_id,//商品id
                //     $del_goo_price,//商品金额没有乘以100 ['商品id'=>商品金额]
                //     $wor_data->wor_ware_id, //仓库id
                //     $del_goo_amount,//商品数量 ['商品id'=>商品退货数量]
                //     $ord_client->orcl_channel_unit,//渠道单位
                //     $ord_client->orcl_name,//姓名
                //     $ord_client->orcl_phone,//电话
                //     '',//备注
                //     $service_ware_id//移动仓库id
                // );
            }

            if (!$update_wogo_del) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'改单失败'];
            }
        }

        // 2.2 有新添加的工单商品，工单商品表新增商品
        if (!empty($add_goo_id)) {
            foreach ($add_goo_id as $key => $value) {
                $wogo_data[$key]['wogo_wor_id'] = $request['wor_id']; //工单id
                $wogo_data[$key]['wogo_waon_class'] = $add_goo_data['waon_class'][$value]; //仓库类别
                $wogo_data[$key]['wogo_goo_id'] = $value; //商品id
                $wogo_data[$key]['wogo_is_recycle'] = $add_goo_data['goo_is_recycle'][$value]; //是否回收：1回收2不回收
                $wogo_data[$key]['wogo_goo_price'] = $add_goo_data['goo_price'][$value] * 100; //商品售价
                $wogo_data[$key]['wogo_goo_amount'] = $add_goo_data['goo_amount'][$value]; //商品数量
                $wogo_data[$key]['wogo_collection_price'] = $add_goo_data['goo_collection_price'][$value] * 100; //商品代收金额
                $wogo_data[$key]['wogo_recycle_price'] = $add_goo_data['recycle_price'][$value] * 100; //回收金额
                $wogo_data[$key]['wogo_recycle_quantity'] = $add_goo_data['recycle_quantity'][$value]; //回收数量
                $wogo_data[$key]['wogo_state'] = $add_goo_data['goo_state'][$value]; //商品状态
                $wogo_data[$key]['wogo_update_time'] = date('Y-m-d H:i:s');
                $wogo_data[$key]['wogo_goo_name'] = $add_goo_data['goo_name'][$value]; //商品名称
                if (!empty($add_goo_data['tem_goo_name'][$value])) {
                    $tem_goo_name = $add_goo_data['tem_goo_name'][$value];
                } else {
                    $tem_goo_name = '';
                }
                $wogo_data[$key]['wogo_tem_goo_name'] = $tem_goo_name; //商品别名
                $wogo_data[$key]['wogo_goo_goods_encode'] = $add_goo_data['goo_goods_encode'][$value]; //检索编码
                $wogo_data[$key]['wogo_goo_type'] = $add_goo_data['goo_type'][$value]; //商品类型
                $wogo_data[$key]['wogo_goo_inventory'] = $add_goo_data['goo_inventory'][$value]; //商品出库方式1.良品 2优先

                // 获取当前月份商品成本价
                $cost_price = StockingSelling::costPrice($wor_data->wor_ware_id, $value);
                // 3.添加商品销售明细
                $sell_detail_res = SellDetail::add(
                    $user_info, //用户信息
                    $wor_data->wor_order_number, //原始s单号
                    $wor_data->wor_service_type,
                    $wor_data->wor_orla_id, //订单标签id
                    $wor_data->wor_ware_id, //仓库id
                    $wor_data->wor_type, //[客户类型：1.门店零售 2.来往单位]
                    $ord_info->ord_client_id,
                    $user_info->adm_shop_id, //服务门店id
                    $value, //商品id
                    $add_goo_price[$key], //商品价格
                    $add_goo_amount[$key], //商品数量
                    $cost_price, //成本单价
                    $add_goo_inventory[$key],
                    1 //商品状态1.正常 2.删除3回收的商品4换货商品
                );
                if (empty($sell_detail_res)) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'改单失败'];
                }
            }
            $wogo_res = DB::table('work_good')->insert($wogo_data);
        } else {
            $wogo_res = true;
        }
        // 2.3 工单表数据做修改
        $wor_update_data['wor_service_sepr_id'] = $request['wor_service_sepr_id']; // 服务项目id
        // 新订单,未派单,待接单/已派单的状态下,服务技师可以更改
        // if (in_array($wor_data->wor_state, [1, 2, 3])) {
            $wor_update_data['wor_service_adm_id'] = $request['wor_service_adm_id'];    //服务技师id
        // }
        $wor_update_data['wor_service_state'] = 1; //服务状态：1待接单2已接单3预约4出发5抵达6完成待审核
        $wor_update_data['wor_state'] = 3; //1.新订单 2未派单 3待接单/已派单
        $wor_update_data['wor_actual_price'] = $goo_all_price * 100; // 工单结算金额（单位：分）
        $wor_update_data['wor_recycle_number'] = $recycle_number; // 工单计划总的旧货回收数量
        $wor_update_data['wor_is_recycle'] = $wor_is_recycle; // 1.回收2.不回收
        $wor_update_data['wor_goo_amount'] = $goo_all_quantity; //总的商品数量
        $wor_update_data['wor_collection_price'] = $goo_all_collection * 100; //总的代收金额
        $wor_update_data['wor_pass'] = 1; //审核：1.待审核 2.合格 3.不合格 4锁定
        $wor_update_data['wor_update_time'] = date('Y-m-d H:i:s');
        $wor_res = DB::table('work_order')
            ->where('wor_id', $request['wor_id'])
            ->update($wor_update_data);

        $wocl_update_data['wocl_collect_state'] = $request['wocl_collect_state'];
        $wocl_update_data['wocl_standby_battery_type'] = isset($request['wocl_standby_battery_type']) ? $request['wocl_standby_battery_type'] : 2;
        $wocl_update_data['wocl_update_time'] = date('Y-m-d H:i:s');
        $wocl_res = DB::table('work_client')
            ->where('wocl_wor_id', $request['wor_id'])
            ->update($wocl_update_data);

        if ($wor_res && $wogo_res && $wocl_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'工单数据更改成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'改单失败'];
        }
    }

    /**
     * [createNewDispatchBill 生成新的发货单]
     * @param  [type] $user_info          [用户信息]
     * @param  [type] $shop_id            [总店id]
     * @param  [type] $wor_id             [工单id]
     * @param  [type] $wor_data           [工单数据]
     * @param  [type] $wor_service_adm_id [改单的服务技师id]
     * @param  [type] $goo_all_quantity   [发货单的商品总数量]
     * @param  [type] $digo_data          [发货单商品数据]
     * @param  [type] $digo_goo_id        [发货单的商品id]
     * @param  [type] $digo_goo_number    [发货单的商品数量：商品id=>商品数量]
     * @param  [type] $digo_goo_inventory [发货单的出库类型：商品id=>库存扣除方式]
     * @param  [type] $digo_wago_class [发货单的仓库类别：商品id=>仓库类别]
     * @return [type]                     [description]
     */
    private function createNewDispatchBill(
        $user_info,
        $shop_id,
        $wor_id,
        $wor_data,
        $wor_service_adm_id,
        $dego_client_id,
        $goo_all_quantity,
        $digo_data,
        $digo_goo_id,
        $digo_goo_number,
        $digo_goo_inventory,
        $digo_wago_class
    ) {
        // 2.生成新的发货单
        $dego_number = 'FH' . time() . rand(100, 999);
        $bill_data['dego_cid'] = $user_info->adm_cid; //公司id
        $bill_data['dego_shop_id'] = $user_info->adm_shop_id; //门店id
        $bill_data['dego_superior_shop_id'] = $shop_id; //所属总店id
        $bill_data['dego_number'] = $dego_number; //发货单号
        $bill_data['dego_order_type'] = 2; //类型：1.订单发货 2.工单发货
        $bill_data['dego_wor_id'] = $wor_id; //发货单关联的工单id
        $bill_data['dego_original_number'] = $wor_data->wor_number; //原始单号,发货单的关联单号(工单号)
        $bill_data['dego_client_type'] = $wor_data->wor_type; //买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
        $bill_data['dego_client_id'] = $dego_client_id; //选择的客户id,会员id/单位id
        $bill_data['dego_count'] = $goo_all_quantity; //发货总数量
        $bill_data['dego_out_ware_id'] = $wor_data->wor_ware_id; //出库仓库id
        $bill_data['dego_service_shop_id'] = $wor_data->wor_service_shop_id; //服务门店id
        // if ($wor_data->wor_service_state > 1) {
        //     // 技师接单之后，不允许再改技师
        //     $bill_data['dego_service_adm_id'] = $wor_data->wor_service_adm_id; //服务技师id
        // } else {
            $bill_data['dego_service_adm_id'] = $wor_service_adm_id; //服务技师id
        // }
        $bill_data['dego_type'] = 1; //类型：1未出库2已出库
        $bill_data['dego_create_adm_id'] = $user_info->adm_id; //创建人id
        $bill_data['dego_remark'] = $wor_data->wor_remark; //备注
        $dispatch_bill = DB::table('dispatch_bill')->insertGetId($bill_data); // 发货单表添加数据

        foreach ($digo_data as $key => $value) {
            $digo_data[$key]['digo_dego_id'] = $dispatch_bill;
        }
        $dego_res = DB::table('dispatch_goods')->insert($digo_data); // 发货单商品表添加数据
        // 新的发货单商品，正常库存转锁定库存
        $normal_turn_lock = Warehouse::normalTurnLock(
            $user_info, //用户信息
            $wor_data->wor_ware_id, //仓库id
            $digo_goo_id, //商品id
            $digo_goo_number, //商品id=>商品数量
            $digo_goo_inventory, //商品id=>库存扣除方式
            $digo_wago_class //商品id=>仓库类别
        );
        if ($dispatch_bill && $normal_turn_lock && $dego_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'发货单数据更改成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'改单失败'];
        }
    }

    // 改单，订单数据更改
    public function editOrderData(
        $wor_data,
        $del_goo_id,
        $del_is_recycle,
        $del_goo_amount,
        $add_goo_id,
        $add_goo_price,
        $add_goo_amount,
        $add_goo_is_recycle,
        $add_goo_collection_price,
        $add_goo_data
    ) {
        // 3.1 订单商品表中减去删除的商品数量
        $del_sql = 'UPDATE `faster_order_goods` SET ';
        $goo_quantity = '';
        $recycle_quantity = '';
        $update_time = '';
        $goo_id = '';
        if (!empty($del_goo_id)) {
            foreach ($del_goo_id as $key => $value) {
                // 减去商品数量
                $goo_quantity = $goo_quantity . ' WHEN ' . $value;
                $goo_quantity = $goo_quantity . ' THEN orgo_goo_quantity - ' . $del_goo_amount[$value];

                // 如果回收 减去商品回收数量
                if ($del_is_recycle[$key] == 1) {
                    $recycle_quantity = $recycle_quantity . ' WHEN ' . $value;
                    $recycle_quantity = $recycle_quantity . ' THEN orgo_recycle_quantity - ' . $del_goo_amount[$value];
                }

                // 更新时间
                $update_time = $update_time . ' WHEN ' . $value;
                $update_time = $update_time . ' THEN "' . date('Y-m-d H:i:s') . '"';

                //要更改的商品id
                $goo_id = $goo_id . $value . ',';
            }
            $del_sql = $del_sql . ' `orgo_goo_quantity`=  CASE `orgo_goo_id` ' . $goo_quantity . ' END,';
            if (!empty($recycle_quantity)) {
                $del_sql = $del_sql . ' `orgo_recycle_quantity`=  CASE `orgo_goo_id` ' . $recycle_quantity . ' END,';
            }
            $del_sql = $del_sql . ' `orgo_update_time`=  CASE `orgo_goo_id` ' . $update_time . ' END';
            $del_sql = $del_sql . ' WHERE `orgo_ord_id` = ' . $wor_data->wor_order_id . ' AND `orgo_state` = 1 AND `orgo_goo_id` IN (' . trim($goo_id, ',') . ')';
            $orgo_res = DB::update($del_sql);
        } else {
            $orgo_res = true;
        }
        // 3.2 订单商品表中减去删除的商品数量后如果为0,商品状态改为删除状态
        // 查询订单商品表中商品数量为0的数据
        $find_orgo_data = DB::table('order_goods')
            ->where('orgo_ord_id', $wor_data->wor_order_id)
            ->where('orgo_state', 1)
            ->get(['orgo_id', 'orgo_goo_quantity', 'orgo_goo_id'])->toArray();
        $ord_goo_id = []; //订单商品表原有的商品id
        $del_orgo_id = []; //订单商品表商品数量为0的
        foreach ($find_orgo_data as $key => $value) {
            if ($value->orgo_goo_quantity == 0) {
                $del_orgo_id[] = $value->orgo_id;
            } else {
                $ord_goo_id[] = $value->orgo_goo_id;
            }
        }

        if (!empty($del_orgo_id)) {
            // 将订单商品中商品数量为0的，删除订单商品数据
            $del_orgo_res = DB::table('order_goods')
                ->whereIn('orgo_id', $del_orgo_id)
                ->delete();
        } else {
            $del_orgo_res = true;
        }
        // 3.3 改单有新添加的商品，订单商品表中加上新增的商品数量(如果没有,添加新的商品数据)
        if (!empty($add_goo_id)) {
            // 有新添加的商品，求出订单商品表中没有的商品
            $diff_goo_id = array_diff($add_goo_id, $ord_goo_id);
            $add_sql = 'UPDATE `faster_order_goods` SET ';
            $add_goo_quantity = '';
            $add_recycle_quantity = '';
            $add_update_time = '';
            $update_goo_id = '';
            foreach ($add_goo_id as $key => $value) {
                if (in_array($value, $diff_goo_id)) {
                    // 订单商品表中 没有的商品(新增)
                    $orgo_data[$key]['orgo_ware_id'] = $wor_data->wor_ware_id; //仓库id
                    $orgo_data[$key]['orgo_waon_class'] = $add_goo_data['waon_class'][$value]; //仓库类别
                    $orgo_data[$key]['orgo_ord_id'] = $wor_data->wor_order_id; //订单id
                    $orgo_data[$key]['orgo_order_number'] = $wor_data->wor_order_number; //订单编号
                    $orgo_data[$key]['orgo_goo_id'] = $value; //商品id
                    $orgo_data[$key]['orgo_goo_price'] = $add_goo_data['goo_price'][$value] * 100; //商品售价
                    $orgo_data[$key]['orgo_goo_quantity'] = $add_goo_data['goo_amount'][$value]; //商品数量
                    $orgo_data[$key]['orgo_is_recycle'] = $add_goo_data['goo_is_recycle'][$value]; //是否回收：1回收2不回收
                    $orgo_data[$key]['orgo_recycle_price'] = $add_goo_data['recycle_price'][$value] * 100; //回收金额
                    $orgo_data[$key]['orgo_recycle_quantity'] = $add_goo_data['recycle_quantity'][$value]; //回收数量
                    $orgo_data[$key]['orgo_collection_price'] = $add_goo_data['goo_collection_price'][$value] * 100; //商品代收金额
                    $orgo_data[$key]['orgo_can_assign_quantity'] = 0; //剩余可以派工单的商品数量
                    $orgo_data[$key]['orgo_update_time'] = date('Y-m-d H:i:s');
                    $orgo_data[$key]['orgo_goo_name'] = $add_goo_data['goo_name'][$value]; //商品名称
                    $orgo_data[$key]['orgo_goo_goods_encode'] = $add_goo_data['goo_goods_encode'][$value]; //检索编码
                    $orgo_data[$key]['orgo_goo_type'] = $add_goo_data['goo_type'][$value]; //商品类型
                    $orgo_data[$key]['orgo_goo_ampere_hour'] = $add_goo_data['goo_ampere_hour'][$value]; //商品安时数
                    if (!empty($add_goo_data['tem_goo_name'][$value])) {
                        $tem_goo_name = $add_goo_data['tem_goo_name'][$value];
                    } else {
                        $tem_goo_name = '';
                    }
                    $orgo_data[$key]['orgo_tem_goo_name'] = $tem_goo_name;
                } else {
                    // 订单商品表中 存在的商品(加数量)
                    $add_goo_quantity = $add_goo_quantity . ' WHEN ' . $value;
                    $add_goo_quantity = $add_goo_quantity . ' THEN orgo_goo_quantity + ' . $add_goo_amount[$key];

                    // 如果回收 增加商品回收数量
                    if ($add_goo_is_recycle[$key] == 1) {
                        $add_recycle_quantity = $add_recycle_quantity . ' WHEN ' . $value;
                        $add_recycle_quantity = $add_recycle_quantity . ' THEN orgo_recycle_quantity + ' . $add_goo_amount[$key];
                    }

                    // 更新时间
                    $add_update_time = $add_update_time . ' WHEN ' . $value;
                    $add_update_time = $add_update_time . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    //要更改的商品id
                    $update_goo_id = $update_goo_id . $value . ',';
                }
            }

            // 商品添加数量
            if (empty($update_goo_id)) {
                $add_orgo_num = true;
            } else {
                $add_sql = $add_sql . ' `orgo_goo_quantity`=  CASE `orgo_goo_id` ' . $add_goo_quantity . ' END,';
                $add_sql = $add_sql . ' `orgo_recycle_quantity`=  CASE `orgo_goo_id` ' . $add_recycle_quantity . ' END,';
                $add_sql = $add_sql . ' `orgo_update_time`=  CASE `orgo_goo_id` ' . $add_update_time . ' END';
                $add_sql = $add_sql . ' WHERE `orgo_ord_id` = ' . $wor_data->wor_order_id .
                    ' AND `orgo_goo_id` IN (' . trim($update_goo_id, ',') . ')';
                $add_orgo_num = DB::update($add_sql);
            }
        } else {
            $add_orgo_num = true;
        }
        // 商品新增
        if (empty($orgo_data)) {
            $add_orgo_res = true;
        } else {
            $add_orgo_res = DB::table('order_goods')->insert($orgo_data);
        }

        // 3.4 修改订单表数据(合计金额,商品总数量)
        // 查询出该订单下所有的商品
        $all_goods = DB::table('order_goods')
            ->where('orgo_ord_id', $wor_data->wor_order_id)
            ->where('orgo_state', 1)
            ->get(['orgo_goo_price', 'orgo_goo_quantity', 'orgo_collection_price']);
        $price_sum = 0;
        $quantity_sum = 0;
        $collection_sum = 0;
        foreach ($all_goods as $key => $value) {
            // 合计金额
            $price_sum += $value->orgo_goo_quantity * $value->orgo_goo_price;
            // 商品总数量
            $quantity_sum += $value->orgo_goo_quantity;
            // 代收金额
            $collection_sum += $value->orgo_collection_price;
        }

        $update_ord['ord_actual_price'] = $price_sum; // 结算金额（单位：分）
        $update_ord['ord_order_price'] = $price_sum; // 合计金额（单位：分）
        $update_ord['ord_goods_quantity'] = $quantity_sum; // 商品总数量
        $update_ord['ord_collection_price'] = $collection_sum; // 代收金额
        $update_ord['ord_update_time'] = date('Y-m-d H:i:s');
        $ord_res = DB::table('order')
            ->where('ord_id', $wor_data->wor_order_id)
            ->update($update_ord);
        if ($ord_res && $add_orgo_res && $add_orgo_num && $del_orgo_res && $orgo_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'订单数据更改成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'改单失败'];
        }
    }

    /**
     * [凭证表填写数据]
     * @param  [array] $user_info           [用户信息]
     * @param  [array] $shop_id             [门店id]
     * @param  [array] $order_type          [单号类型1.订单2.工单3.采购单4.销售单]
     * @param  [array] $wor_id              [工单id]
     * @param  [int]   $wor_number          [工单单号] 
     * @param  [int]   $wor_order_id        [订单/采购单/采购退货单/盘库单id] 
     * @param  [int]   $wor_order_number    [订单/采购单/采购退货单/盘库单单号] 
     * @param  [int]   $wor_price           [结算金额] 
     * @param  [int]   $recycle_price       [回收金额]
     * @param  [int]   $collection_price    [代收金额]
     * @param  [int]   $cost_price          [成本]
     * @param  [int]   $wor_service_type    [订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单]
     * @param  [int]   $wor_type            [单位类型1会员零售2客户单位3速电网单]
     * @param  [int]   $wocl_client_id      [客户单位/客户id]
     * @param  [int]   $wocl_channel_unit   [客户单位]
     * @return [type]             [description]
     */
    public static function voucherReceipts(
        $user_info,
        $shop_id,
        $order_type,
        $wor_id,
        $wor_number,
        $wor_order_id,
        $wor_order_number,
        $wor_price,
        $recycle_price,
        $collection_price,
        $cost_price,
        $wor_service_type,
        $wor_type,
        $wocl_client_id,
        $wocl_channel_unit
    ) {
        // 在凭证列表插入数据
        $vore_data['vore_cid'] = $user_info->adm_cid;//所属企业
        $vore_data['vore_superior_shop_id'] = $shop_id;//所属总店id
        $vore_data['vore_shop_id'] = $user_info->adm_shop_id;//所属门店id
        $vore_data['vore_create_id'] = $user_info->adm_id;//添加人
        $vore_data['vore_order_type'] = $order_type;//单号类型1.订单2.工单3.采购单4.销售单
        $vore_data['vore_wor_id'] = $wor_id;//工单id
        $vore_data['vore_wor_number'] = $wor_number;//工单号
        $vore_data['vore_ord_id'] = $wor_order_id;//订单id
        $vore_data['vore_ord_number'] = $wor_order_number;//订单号
        $vore_data['vore_actual_price'] = $wor_price / 100;//结算金额
        $vore_data['vore_recycle_price'] = $recycle_price / 100;//回收金额
        $vore_data['vore_collection_price'] = $collection_price / 100;//代收金额
        $vore_data['vore_early_costing'] = $cost_price;//成本
        $vore_data['vore_service_type'] = $wor_service_type;//订单类型：1服务单 2销售单 3换货单 4退货单 5发货单 6结清单 7救援单
        $vore_data['vore_type'] = $wor_type;//单位类型1会员零售2客户单位3速电网单
        $vore_data['vore_client_id'] = $wocl_client_id;//客户单位/客户id
        $vore_data['vore_channel_unit'] = $wocl_channel_unit;//客户单位
        if ($order_type == 1) {//订单
            // 根据订单id,查询时间
            $ord_create_time = DB::table('order')
                ->where('ord_id', $wor_order_id)
                ->value('ord_create_time');
            $vore_data['vore_create_time'] = $ord_create_time;
        } elseif ($order_type == 2) {//工单
            // 根据工单id,查询时间
            $wor_create_time = DB::table('work_order')
                ->where('wor_id', $wor_id)
                ->value('wor_create_time');
            $vore_data['vore_create_time'] = $wor_create_time;
        } elseif ($order_type == 3) {
            // 根据采购单id,查询时间
            $create_time = DB::table('purchase_order')
                ->where('cg_id', $wor_order_id)
                ->value('create_time');
            $vore_data['vore_create_time'] = $create_time;
        } elseif ($order_type == 4) {
            // 根据采购单id,查询时间
            $create_time = DB::table('purchase_order')
                ->where('cg_id', $wor_order_id)
                ->value('create_time');
            $vore_data['vore_create_time'] = $create_time;
        } elseif ($order_type == 5) {
            // 根据采购单id,查询时间
            $create_time = DB::table('purchase_order')
                ->where('cg_id', $wor_order_id)
                ->value('create_time');
            $vore_data['vore_create_time'] = $create_time;
        }
        $vore_id = DB::table('voucher_receipts')->insertGetId($vore_data);
        // 在凭证借贷表插入数据(结算金额)
        $volo_data[0]['volo_shop_id'] = $user_info->adm_shop_id;//所属门店id
        $volo_data[0]['volo_vore_id'] = $vore_id;//凭证id
        $volo_data[0]['volo_type'] = 1;//类型1借方2贷方
        // 单号类型1.订单
        if ($order_type == 1) {
            // 根据订单id,判断是不是虚拟加盟店
            $orcl_shipment_party = DB::table('order_client')
                ->where('orcl_ord_id', $wor_order_id)
                ->value('orcl_shipment_party');
            if ($orcl_shipment_party == 4) {//出库方1仓库2直营店3加盟店4虚拟加盟店
                $volo_data[0]['volo_borrow_subject'] = '1122';//借方科目
                $volo_data[0]['volo_borrow_subject_name'] = '应收账款';//借方科目名称
                $volo_data[0]['volo_loan_subject'] = '600101';//贷方科目
                $volo_data[0]['volo_loan_subject_name'] = '主营业务收入';//贷方科目名称
    
                $volo_data[0]['volo_borrow_costing_subject'] = '';//借方成本科目
                $volo_data[0]['volo_borrow_costing_name'] = '';//借方成本名称
                $volo_data[0]['volo_borrow_costing'] = '';//借方成本
                $volo_data[0]['volo_loan_costing_subject'] = '';//贷方成本科目
                $volo_data[0]['volo_loan_costing_name'] = '';//贷方成本名称
                $volo_data[0]['volo_loan_costing'] = '';//贷方成本
                $volo_data[0]['volo_update_time'] = $ord_create_time;//更新时间
    
                $volo_data[1]['volo_borrow_subject'] = '140501';//借方科目
                $volo_data[1]['volo_borrow_subject_name'] = '库存商品';//借方科目名称
                $volo_data[1]['volo_loan_subject'] = '';//贷方科目
                $volo_data[1]['volo_loan_subject_name'] = '';//贷方科目名称
    
                $volo_data[1]['volo_borrow_costing_subject'] = '';//借方成本科目
                $volo_data[1]['volo_borrow_costing_name'] = '';//借方成本名称
                $volo_data[1]['volo_borrow_costing'] = '';//借方成本
                $volo_data[1]['volo_loan_costing_subject'] = '';//贷方成本科目
                $volo_data[1]['volo_loan_costing_name'] = '';//贷方成本名称
                $volo_data[1]['volo_loan_costing'] = '';//贷方成本
                $volo_data[1]['volo_update_time'] = $ord_create_time;//更新时间
            } else {
                $volo_data[0]['volo_borrow_subject'] = '1122';//借方科目
                $volo_data[0]['volo_borrow_subject_name'] = '应收账款';//借方科目名称
                $volo_data[0]['volo_loan_subject'] = '600101';//贷方科目
                $volo_data[0]['volo_loan_subject_name'] = '主营业务收入';//贷方科目名称
    
                $volo_data[0]['volo_borrow_costing_subject'] = '640101';//借方成本科目
                $volo_data[0]['volo_borrow_costing_name'] = '主营业务成本';//借方成本名称
                $volo_data[0]['volo_borrow_costing'] = $cost_price;//借方成本
                $volo_data[0]['volo_loan_costing_subject'] = '140501';//贷方成本科目
                $volo_data[0]['volo_loan_costing_name'] = '库存商品';//贷方成本名称
                $volo_data[0]['volo_loan_costing'] = $cost_price;//贷方成本
                $volo_data[0]['volo_update_time'] = $ord_create_time;//更新时间
    
                $volo_data[1]['volo_borrow_subject'] = '140501';//借方科目
                $volo_data[1]['volo_borrow_subject_name'] = '库存商品';//借方科目名称
                $volo_data[1]['volo_loan_subject'] = '';//贷方科目
                $volo_data[1]['volo_loan_subject_name'] = '';//贷方科目名称
    
                $volo_data[1]['volo_borrow_costing_subject'] = '';//借方成本科目
                $volo_data[1]['volo_borrow_costing_name'] = '';//借方成本名称
                $volo_data[1]['volo_borrow_costing'] = 0;//借方成本
                $volo_data[1]['volo_loan_costing_subject'] = '';//贷方成本科目
                $volo_data[1]['volo_loan_costing_name'] = '';//贷方成本名称
                $volo_data[1]['volo_loan_costing'] = 0;//贷方成本
                $volo_data[1]['volo_update_time'] = $ord_create_time;//更新时间
            }
        } elseif ($order_type == 2) {// 单号类型2.工单
            // 根据工单id,判断是不是虚拟加盟店
            $wocl_wor_type = DB::table('work_client')
                ->where('wocl_wor_id', $wor_id)
                ->value('wocl_wor_type');
            if ($wocl_wor_type == '4') {//1系统工单 2外派工单 3速电派单 4 虚拟加盟店
                $volo_data[0]['volo_borrow_subject'] = '1122';//借方科目
                $volo_data[0]['volo_borrow_subject_name'] = '应收账款';//借方科目名称
                $volo_data[0]['volo_loan_subject'] = '600101';//贷方科目
                $volo_data[0]['volo_loan_subject_name'] = '主营业务收入';//贷方科目名称
                $volo_data[0]['volo_borrow_costing_subject'] = '';//借方成本科目
                $volo_data[0]['volo_borrow_costing_name'] = '';//借方成本名称
                $volo_data[0]['volo_borrow_costing'] = '';//借方成本
                $volo_data[0]['volo_loan_costing_subject'] = '';//贷方成本科目
                $volo_data[0]['volo_loan_costing_name'] = '';//贷方成本名称
                $volo_data[0]['volo_loan_costing'] = '';//贷方成本
                $volo_data[0]['volo_update_time'] = $wor_create_time;//更新时间
                $volo_data[1]['volo_borrow_subject'] = '140501';//借方科目
                $volo_data[1]['volo_borrow_subject_name'] = '库存商品';//借方科目名称
                $volo_data[1]['volo_loan_subject'] = '';//贷方科目
                $volo_data[1]['volo_loan_subject_name'] = '';//贷方科目名称
                $volo_data[1]['volo_borrow_costing_subject'] = '';//借方成本科目
                $volo_data[1]['volo_borrow_costing_name'] = '';//借方成本名称
                $volo_data[1]['volo_borrow_costing'] = '';//借方成本
                $volo_data[1]['volo_loan_costing_subject'] = '';//贷方成本科目
                $volo_data[1]['volo_loan_costing_name'] = '';//贷方成本名称
                $volo_data[1]['volo_loan_costing'] = '';//贷方成本
                $volo_data[1]['volo_update_time'] = $wor_create_time;//更新时间
            } else {
                // 判断是否有商品
                $find_wogo_data = DB::table('work_good')
                    ->where('wogo_wor_id', $wor_id)
                    ->whereNotIn('wogo_state', [2, 7])
                    ->select('wogo_id', 'wogo_goo_price')
                    ->get()->toArray();
                $count_array = count($find_wogo_data);
                //查询出售商品计算总金额
                $find_sell_wogo_data = DB::table('work_good')
                    ->where('wogo_wor_id', $wor_id)
                    ->whereNotIn('wogo_state', [2, 3, 7])
                    ->select('wogo_id', 'wogo_goo_price')
                    ->get()->toArray();
                $count_price_array = array_sum(array_column($find_sell_wogo_data,'wogo_goo_price'));
                if (empty($find_wogo_data)) {
                    $volo_data[0]['volo_borrow_subject'] = '1122';//借方科目
                    $volo_data[0]['volo_borrow_subject_name'] = '应收账款';//借方科目名称
                    $volo_data[0]['volo_loan_subject'] = '600101';//贷方科目
                    $volo_data[0]['volo_loan_subject_name'] = '主营业务收入';//贷方科目名称
                    $volo_data[0]['volo_borrow_costing_subject'] = '';//借方成本科目
                    $volo_data[0]['volo_borrow_costing_name'] = '';//借方成本名称
                    $volo_data[0]['volo_borrow_costing'] = 0;//借方成本
                    $volo_data[0]['volo_loan_costing_subject'] = '';//贷方成本科目
                    $volo_data[0]['volo_loan_costing_name'] = '';//贷方成本名称
                    $volo_data[0]['volo_loan_costing'] = 0;//贷方成本
                    $volo_data[0]['volo_update_time'] = $wor_create_time;//更新时间
                    $volo_data[1]['volo_borrow_subject'] = '140501';//借方科目
                    $volo_data[1]['volo_borrow_subject_name'] = '库存商品';//借方科目名称
                    $volo_data[1]['volo_loan_subject'] = '';//贷方科目
                    $volo_data[1]['volo_loan_subject_name'] = '';//贷方科目名称
                    $volo_data[1]['volo_borrow_costing_subject'] = '';//借方成本科目
                    $volo_data[1]['volo_borrow_costing_name'] = '';//借方成本名称
                    $volo_data[1]['volo_borrow_costing'] = 0;//借方成本
                    $volo_data[1]['volo_loan_costing_subject'] = '';//贷方成本科目
                    $volo_data[1]['volo_loan_costing_name'] = '';//贷方成本名称
                    $volo_data[1]['volo_loan_costing'] = 0;//贷方成本
                    $volo_data[1]['volo_update_time'] = $wor_create_time;//更新时间
                } else {
                    // 查询回收商品数据
                    $find_jugo_data = DB::table('work_good')
                        ->where('wogo_wor_id', $wor_id)
                        ->where('wogo_state', 3)
                        ->select('wogo_id', 'wogo_goo_price')
                        ->get()->toArray();
                    $count_junk_array = count($find_jugo_data);
                    $count_junk_price_array = array_sum(array_column($find_jugo_data,'wogo_goo_price'));
                    if ($count_array == $count_junk_array) {
                        $volo_data[0]['volo_borrow_subject'] = '140501';//借方科目
                        $volo_data[0]['volo_borrow_subject_name'] = '库存商品';//借方科目名称
                        $volo_data[0]['volo_loan_subject'] = '1122';//贷方科目
                        $volo_data[0]['volo_loan_subject_name'] = '应收账款';//贷方科目名称
            
                        $volo_data[0]['volo_borrow_costing_subject'] = '640101';//借方成本科目
                        $volo_data[0]['volo_borrow_costing_name'] = '主营业务成本';//借方成本名称
                        $volo_data[0]['volo_borrow_costing'] = $cost_price;//借方成本
                        $volo_data[0]['volo_loan_costing_subject'] = '140501';//贷方成本科目
                        $volo_data[0]['volo_loan_costing_name'] = '库存商品';//贷方成本名称
                        $volo_data[0]['volo_loan_costing'] = $cost_price;//贷方成本
                        $volo_data[0]['volo_update_time'] = $wor_create_time;//更新时间
    
                        $volo_data[1]['volo_borrow_subject'] = '';//借方科目
                        $volo_data[1]['volo_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['volo_loan_subject'] = '';//贷方科目
                        $volo_data[1]['volo_loan_subject_name'] = '';//贷方科目名称
            
                        $volo_data[1]['volo_borrow_costing_subject'] = '';//借方成本科目
                        $volo_data[1]['volo_borrow_costing_name'] = '';//借方成本名称
                        $volo_data[1]['volo_borrow_costing'] = 0;//借方成本
                        $volo_data[1]['volo_loan_costing_subject'] = '';//贷方成本科目
                        $volo_data[1]['volo_loan_costing_name'] = '';//贷方成本名称
                        $volo_data[1]['volo_loan_costing'] = 0;//贷方成本
                        $volo_data[1]['volo_update_time'] = $wor_create_time;//更新时间
                    } else {
                        $volo_data[0]['volo_borrow_subject'] = '1122';//借方科目
                        $volo_data[0]['volo_borrow_subject_name'] = '应收账款';//借方科目名称
                        $volo_data[0]['volo_loan_subject'] = '600101';//贷方科目
                        $volo_data[0]['volo_loan_subject_name'] = '主营业务收入';//贷方科目名称
            
                        $volo_data[0]['volo_borrow_costing_subject'] = '640101';//借方成本科目
                        $volo_data[0]['volo_borrow_costing_name'] = '主营业务成本';//借方成本名称
                        $volo_data[0]['volo_borrow_costing'] = $cost_price;//借方成本
                        $volo_data[0]['volo_loan_costing_subject'] = '140501';//贷方成本科目
                        $volo_data[0]['volo_loan_costing_name'] = '库存商品';//贷方成本名称
                        $volo_data[0]['volo_loan_costing'] = $cost_price;//贷方成本
                        $volo_data[0]['volo_update_time'] = $wor_create_time;//更新时间
    
                        $volo_data[1]['volo_borrow_subject'] = '140501';//借方科目
                        $volo_data[1]['volo_borrow_subject_name'] = '库存商品';//借方科目名称
                        $volo_data[1]['volo_loan_subject'] = '';//贷方科目
                        $volo_data[1]['volo_loan_subject_name'] = '';//贷方科目名称
            
                        $volo_data[1]['volo_borrow_costing_subject'] = '';//借方成本科目
                        $volo_data[1]['volo_borrow_costing_name'] = '';//借方成本名称
                        $volo_data[1]['volo_borrow_costing'] = 0;//借方成本
                        $volo_data[1]['volo_loan_costing_subject'] = '';//贷方成本科目
                        $volo_data[1]['volo_loan_costing_name'] = '';//贷方成本名称
                        $volo_data[1]['volo_loan_costing'] = 0;//贷方成本
                        $volo_data[1]['volo_update_time'] = $wor_create_time;//更新时间
                    }
                }
            }
        } elseif ($order_type == 3) {// 单号类型3.采购入库单
            $volo_data[0]['volo_borrow_subject'] = '140501';//借方科目
            $volo_data[0]['volo_borrow_subject_name'] = '库存商品';//借方科目名称
            $volo_data[0]['volo_loan_subject'] = '220201';//贷方科目
            $volo_data[0]['volo_loan_subject_name'] = '应付账款';//贷方科目名称
            $volo_data[0]['volo_update_time'] = $create_time;//更新时间
        } elseif ($order_type == 4) {// 单号类型3.采购退货单
            $volo_data[0]['volo_borrow_subject'] = '220201';//借方科目
            $volo_data[0]['volo_borrow_subject_name'] = '应付账款';//借方科目名称
            $volo_data[0]['volo_loan_subject'] = '140501';//贷方科目
            $volo_data[0]['volo_loan_subject_name'] = '库存商品';//贷方科目名称
            $volo_data[0]['volo_update_time'] = $create_time;//更新时间
        } elseif ($order_type == 5) {// 单号类型5.预付退货单
            $volo_data[0]['volo_borrow_subject'] = '220201';//借方科目
            $volo_data[0]['volo_borrow_subject_name'] = '应付账款';//借方科目名称
            $volo_data[0]['volo_loan_subject'] = '140501';//贷方科目
            $volo_data[0]['volo_loan_subject_name'] = '库存商品';//贷方科目名称
            $volo_data[0]['volo_update_time'] = $create_time;//更新时间
        }
        // 在凭证借贷表插入数据(回收金额)
        $volo_data[1]['volo_shop_id'] = $user_info->adm_shop_id;//所属门店id
        $volo_data[1]['volo_vore_id'] = $vore_id;//凭证id
        $volo_data[1]['volo_type'] = 1;//类型1借方2贷方
        if ($wor_price < '0') {
            // 根据订单id,判断是不是虚拟加盟店
            $orcl_shipment_party = DB::table('order_client')
                ->where('orcl_ord_id', $wor_order_id)
                ->value('orcl_shipment_party');
            // 根据工单id,判断是不是虚拟加盟店
            $wocl_wor_type = DB::table('work_client')
                ->where('wocl_wor_id', $wor_id)
                ->value('wocl_wor_type');
            
            if ($orcl_shipment_party == 4 || $wocl_wor_type == 4) {
                $volo_data[0]['volo_borrow_price'] = '-' . abs($wor_price) / 100;//借方金额
                $volo_data[0]['volo_loan_price'] = '-' . abs($wor_price) / 100;//贷方金额
                $volo_data[1]['volo_borrow_price'] = '-' . abs($recycle_price) / 100;//借方金额
                $volo_data[1]['volo_loan_price'] = 0;//贷方金额
            } else {
                if ($count_array == $count_junk_array) {
                    $volo_data[0]['volo_borrow_price'] = abs($wor_price) / 100;//借方金额
                    $volo_data[0]['volo_loan_price'] = abs($wor_price) / 100;//贷方金额
                    $volo_data[1]['volo_borrow_price'] = 0;//借方金额
                    $volo_data[1]['volo_loan_price'] = 0;//贷方金额
                } else {
                    $volo_data[0]['volo_borrow_price'] = '-' . abs($wor_price) / 100;//借方金额
                    $volo_data[0]['volo_loan_price'] = '-' . abs($wor_price) / 100 + abs($recycle_price) / 100;//贷方金额
                    if ($count_junk_price_array > $count_price_array) {
                        $volo_data[1]['volo_borrow_price'] = abs($recycle_price) / 100;//借方金额
                    } else {
                        $volo_data[1]['volo_borrow_price'] = '-' . abs($recycle_price) / 100;//借方金额
                    }
                    $volo_data[1]['volo_loan_price'] = 0;//贷方金额
                }
            }
        } else {
            // 根据订单id,判断是不是虚拟加盟店
            $orcl_shipment_party = DB::table('order_client')
                ->where('orcl_ord_id', $wor_order_id)
                ->value('orcl_shipment_party');
            // 根据工单id,判断是不是虚拟加盟店
            $wocl_wor_type = DB::table('work_client')
                ->where('wocl_wor_id', $wor_id)
                ->value('wocl_wor_type');
            if ($orcl_shipment_party == 4 || $wocl_wor_type == 4) {
                $volo_data[0]['volo_borrow_price'] = abs($wor_price) / 100;//借方金额
                $volo_data[0]['volo_loan_price'] = abs($wor_price) / 100;//贷方金额
                $volo_data[1]['volo_borrow_price'] = abs($recycle_price) / 100;//借方金额
                $volo_data[1]['volo_loan_price'] = 0;//贷方金额
            } else {
                $volo_data[0]['volo_borrow_price'] = abs($wor_price) / 100;//借方金额
                $volo_data[0]['volo_loan_price'] = abs($wor_price) / 100 + abs($recycle_price) / 100;//贷方金额
                $volo_data[1]['volo_borrow_price'] = abs($recycle_price) / 100;//借方金额
                $volo_data[1]['volo_loan_price'] = 0;//贷方金额
            }
        }
        // 单号类型1.订单
        if ($order_type == 1) {
            // 判断是订单是否存在
            $find_ord_id = DB::table('order')
                ->where('ord_id', $wor_order_id)
                ->value('ord_id');
            // 判断该订单是否有回收商品
            $find_orgo_data = DB::table('order_goods')
                ->where('orgo_ord_id', $wor_order_id)
                ->where('orgo_state', 3)
                ->select('orgo_id')
                ->get()->toArray();
            // 根据订单id,判断是不是虚拟加盟店
            $orcl_shipment_party = DB::table('order_client')
                ->where('orcl_ord_id', $wor_order_id)
                ->value('orcl_shipment_party');
            if (!empty($find_ord_id)) {
                if (empty($find_orgo_data) || $orcl_shipment_party == 4) {
                    $volo_id = DB::table('voucher_loan')->insert($volo_data[0]);
                } elseif ($order_type == 1) {
                    $volo_id = DB::table('voucher_loan')->insert($volo_data);
                }
            } else {
                if (empty($find_orgo_data) || $orcl_shipment_party == 4) {
                    $volo_id = DB::table('voucher_loan')->insert($volo_data[0]);
                } elseif ($order_type == 1) {
                    $volo_id = DB::table('voucher_loan')->insert($volo_data);
                }
            }
        }
        // 单号类型2.工单
        if ($order_type == 2) {
            // 判断该工单是否存在
            $find_wor_id = DB::table('work_order')
                ->where('wor_id', $wor_id)
                ->value('wor_id');
            // 判断该工单是否有回收商品
            $find_recycle_data = DB::table('work_good')
                ->where('wogo_wor_id', $wor_id)
                ->where('wogo_state', 3)
                ->select('wogo_id')
                ->get()->toArray();
            $wocl_wor_type = DB::table('work_client')
                ->where('wocl_wor_id', $wor_id)
                ->value('wocl_wor_type');
            if (!empty($find_wor_id)) {
                if (empty($find_recycle_data) || $wocl_wor_type == 4) {
                    $volo_id = DB::table('voucher_loan')->insert($volo_data[0]);
                } else {
                    $volo_id = DB::table('voucher_loan')->insert($volo_data);
                }
            }
        }
        // 单号类型3.采购单
        if ($order_type == 3 || $order_type == 4 || $order_type == 5) {
            $volo_id = DB::table('voucher_loan')->insert($volo_data[0]);
        }
        if ($vore_id && $volo_id) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'生成凭证单成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'生成凭证单失败'];
        }
    }
}
