<?php
namespace App\Http\Models\Api\WarehouseManage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Models\Api\OutinRecord;
use App\Http\Models\Api\WarehouseManage\Dispatch;

class TransferringOrders extends Model
{
    /**
     * [warehouseAddition 调拨单新增锁定库存]
     * @param  [type]  $user_info           [用户信息]
     * @param  [type]  $request             [提交数据]
     * @param  [type]  $goo_waon_class      [仓库类别]
     * @param  [type]  $goo_id              [商品id]
     * @param  [type]  $goods_data          [商品数据]
     * @param  [type]  $tror_out_waon_id    [调出仓库的类别id]
     * @return [type]                       [description]
     */
    public static function add(
        $user_info,
        $request,
        $goo_waon_class,
        $goo_id,
        $goods_data,
        $tror_out_waon_id
    ) {
        // 查询仓库商品数量是否够减
        $goo_waon_class = array_unique($goo_waon_class);
        // 判断仓位是否存在
        $find_wafr_id = DB::table('warehouse_freight')
            ->where('wafr_id', $request['tror_out_wafr_id'])
            ->where('wafr_delete', 1)
            ->value('wafr_id');
        if (empty($find_wafr_id)) {
            return ['code'=>'500', 'msg'=>'error', 'data'=>'当前仓位不存在！！！'];
        }
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $request['tror_out_ware_id'])
            ->whereIn('wago_class', $goo_waon_class)
            ->whereIn('wago_goo_id', $goo_id)
            ->select('wago_id', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_freight_stock_number', 'wago_freight_priority_stock_number', 'wago_stock_amount', 'wago_priority_stock_amount')
            ->get()->toArray();
        //  处理要调拨的商品库存数量
        if (empty($warehouse_goods)) {
            return ['code'=>500, 'msg'=>'error', 'data'=>'当前仓库未找到该商品，无法调拨'];
        }
        $warehouse_class_goods = array_column($warehouse_goods, null, 'wago_id');

        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_fine_sql = '';//仓位良品库存数量
        $stock_priority_sql = '';//仓位优先库存数量
        $lock_fine_sql = '';//仓位良品锁定库存数量
        $lock_priority_sql = '';//仓位优先锁定数量
        $stock_amount_sql = '';//仓库良品库存总数量（仓库+仓位）
        $priority_stock_amount_sql = '';//仓库优先库存总数量（仓库+仓位）
        $lock_amount_sql = '';//仓库良品锁定库存总数量（仓库+仓位）
        $priority_lock_amount_sql = '';//仓库优先锁定总数量（仓库+仓位）
        $time_sql = '';
        $ids = '';

        $waon_class_fine_quantity = 0;//仓库类别对应良品库存总数量
        $waon_class_priority_quantity = 0;//仓库类别对应优先库存总数量
        // 调拨单要出库的商品
        foreach ($goods_data as $key => $value) {
            // 根据仓位id,仓库商品id,仓库id,仓库类别和商品id查询对应的仓位商品主键id
            $wafg_id = DB::table('warehouse_freight_goods')
                ->where('wafg_wafr_id', $request['tror_out_wafr_id'])
                ->where('wafg_wago_id', $value['goo_wago_id'])
                ->where('wafg_ware_id', $request['tror_out_ware_id'])
                ->where('wafg_class', $value['goo_waon_class'])
                ->where('wafg_goo_id', $value['goo_id'])
                ->value('wafg_id');
            if ($value['goo_stock_number'] > 0) {
                // 良品剩余库存数量
                $surplus_quantity = $warehouse_class_goods[$value['goo_wago_id']]->wago_freight_stock_number - $value['goo_stock_number'];
                if ($surplus_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓位商品数量不足'];
                }
                // 更改库存数量
                $stock_fine_sql = $stock_fine_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_freight_stock_number` - '.$value['goo_stock_number'];
                // 更改锁定数量
                $lock_fine_sql = $lock_fine_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_freight_lock_quantity` + '.$value['goo_stock_number'];

                // 更改库存数量
                $stock_priority_sql = $stock_priority_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_freight_priority_stock_number` - 0';
                // 更改锁定数量
                $lock_priority_sql = $lock_priority_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_freight_priority_lock_quantity` + 0';

                // 更改仓库良品库存总数量（仓库+仓位）
                $stock_amount_sql = $stock_amount_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_stock_number` - '.$value['goo_stock_number'];
                // 更改仓库良品锁定库存总数量（仓库+仓位）
                $lock_amount_sql = $lock_amount_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_lock_quantity` + '.$value['goo_stock_number'];

                // 更改仓库优先库存总数量（仓库+仓位）
                $priority_stock_amount_sql = $priority_stock_amount_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_priority_stock_number` - 0';
                // 更改仓库优先锁定总数量（仓库+仓位）
                $priority_lock_amount_sql = $priority_lock_amount_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_priority_lock_quantity` + 0';

                $waon_class_fine_quantity += $value['goo_stock_number'];//仓库类别对应良品库存总数量
                // 仓位商品表良品库存数量减少,锁定库存增加
                $stock_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $wafg_id)
                    ->decrement('wafg_stock_number', $value['goo_stock_number']);
                $lock_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $wafg_id)
                    ->increment('wafg_lock_quantity', $value['goo_stock_number']);
                // 仓位表良品库存数量减少,锁定库存增加
                $stock_all_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $request['tror_out_wafr_id'])
                    ->where('wafr_shop_id', $user_info->adm_shop_id)
                    ->decrement('wafr_all_stock', $value['goo_stock_number']);
                $lock_all_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $request['tror_out_wafr_id'])
                    ->where('wafr_shop_id', $user_info->adm_shop_id)
                    ->increment('wafr_lock_quantity', $value['goo_stock_number']);
                if (!$stock_res || !$lock_res || !$stock_all_res || !$lock_all_res) {
                    return ['code'=> 500, 'msg'=>'error', 'data'=>'新增失败！'];
                }
            }
            if ($value['goo_priority_stock_number'] > 0) {
                // 优先剩余库存数量
                $surplus_quantity = $warehouse_class_goods[$value['goo_wago_id']]->wago_freight_priority_stock_number - $value['goo_priority_stock_number'];
                if ($surplus_quantity < 0) {
                    return ['code'=> 500, 'msg'=>'error', 'data'=>'仓位商品数量不足'];
                }
                $trog_data[$key]['trog_priority_stock_number'] = $value['goo_priority_stock_number'];//优先库存数量
                // 更改库存数量
                $stock_priority_sql = $stock_priority_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_freight_priority_stock_number` - '.$value['goo_priority_stock_number'];
                // 更改锁定数量
                $lock_priority_sql = $lock_priority_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_freight_priority_lock_quantity` + '.$value['goo_priority_stock_number'];

                // 更改库存数量
                $stock_fine_sql = $stock_fine_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_freight_stock_number` - 0';
                // 更改锁定数量
                $lock_fine_sql = $lock_fine_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_freight_lock_quantity`  + 0';

                // 更改仓库良品库存总数量（仓库+仓位）
                $stock_amount_sql = $stock_amount_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_stock_number` - 0';
                // 更改仓库良品锁定库存总数量（仓库+仓位）
                $lock_amount_sql = $lock_amount_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_lock_quantity` + 0';

                // 更改仓库优先库存总数量（仓库+仓位）
                $priority_stock_amount_sql = $priority_stock_amount_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_priority_stock_number` - ' . $value['goo_priority_stock_number'];
                // 更改仓库优先锁定总数量（仓库+仓位）
                $priority_lock_amount_sql = $priority_lock_amount_sql.' WHEN '.$value['goo_wago_id'].' THEN `wago_priority_lock_quantity` + ' . $value['goo_priority_stock_number'];

                $waon_class_priority_quantity += $value['goo_priority_stock_number'];//仓库类别对应优先库存总数量
                // 仓位商品表良品库存数量减少,锁定库存增加
                $stock_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $wafg_id)
                    ->decrement('wafg_stock_number', $value['goo_priority_stock_number']);
                $lock_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $wafg_id)
                    ->increment('wafg_lock_quantity', $value['goo_priority_stock_number']);
                // 仓位表良品库存数量减少,锁定库存增加
                $stock_all_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $request['tror_out_wafr_id'])
                    ->where('wafr_shop_id', $user_info->adm_shop_id)
                    ->decrement('wafr_all_stock', $value['goo_priority_stock_number']);
                $lock_all_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $request['tror_out_wafr_id'])
                    ->where('wafr_shop_id', $user_info->adm_shop_id)
                    ->increment('wafr_lock_quantity', $value['goo_priority_stock_number']);
                if (!$stock_res || !$lock_res || !$stock_all_res || !$lock_all_res) {
                    return ['code'=> 500, 'msg'=>'error', 'data'=>'新增失败！'];
                }
            }
            $time_sql = $time_sql.' WHEN '.$value['goo_wago_id'].' THEN "'.date('Y-m-d H:i:s').'"'; // 更改时间
            $ids = $ids . $value['goo_wago_id'].',';
        }

        // 2.1 固定仓商品表减锁定库存
        $sql = $sql .' `wago_freight_stock_number`=  CASE `wago_id` '. $stock_fine_sql .' END,'; //修改良品库存数量
        $sql = $sql .' `wago_freight_lock_quantity`=  CASE `wago_id` '. $lock_fine_sql .' END,'; //修改良品锁定数量
        $sql = $sql .' `wago_freight_priority_stock_number`=  CASE `wago_id` '. $stock_priority_sql .' END,'; //修改优先库存数量
        $sql = $sql .' `wago_freight_priority_lock_quantity`=  CASE `wago_id` '. $lock_priority_sql .' END,'; //修改优先锁定数量
        $sql = $sql .' `wago_stock_number`=  CASE `wago_id` '. $stock_amount_sql .' END,'; //修改良品库存数量
        $sql = $sql .' `wago_lock_quantity`=  CASE `wago_id` '. $lock_amount_sql .' END,'; //修改良品锁定数量
        $sql = $sql .' `wago_priority_stock_number`=  CASE `wago_id` '. $priority_stock_amount_sql .' END,'; //修改优先库存数量
        $sql = $sql .' `wago_priority_lock_quantity`=  CASE `wago_id` '. $priority_lock_amount_sql .' END,'; //修改优先锁定数量
        $sql = $sql .' `wago_update_time`=  CASE `wago_id` '. $time_sql .' END'; //修改时间
        $sql = $sql . ' WHERE `wago_id` IN ('.trim($ids, ',').')';
        $wago_edit_res = DB::update($sql);
        
        // 修改仓库类别表库存数据
        $sql = 'UPDATE `faster_warehouse_onhand` SET ';
        $stock_fine_sql = '';
        $lock_fine_sql = '';
        $time_sql = '';
        $ids = '';
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $stock_fine_sql = $stock_fine_sql.' WHEN '.$tror_out_waon_id.' THEN `waon_stock_fine_amount` - '.$waon_class_fine_quantity;
            $lock_fine_sql = $lock_fine_sql.' WHEN '.$tror_out_waon_id.' THEN `waon_lock_fine_amount` + '.$waon_class_fine_quantity;
            $time_sql = $time_sql.' WHEN '.$tror_out_waon_id.' THEN "'.date('Y-m-d H:i:s').'"';
    
            $ids = $ids . $tror_out_waon_id.',';
            $sql = $sql .' `waon_stock_fine_amount`=  CASE `waon_id` '.$stock_fine_sql.' END,';
            $sql = $sql .' `waon_lock_fine_amount`=  CASE `waon_id` '.$lock_fine_sql.' END,';
        }
        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $stock_fine_sql = $stock_fine_sql.' WHEN '.$tror_out_waon_id.' THEN `waon_stock_priority_amount` - '.$waon_class_priority_quantity;
            $lock_fine_sql = $lock_fine_sql.' WHEN '.$tror_out_waon_id.' THEN `waon_lock_priority_amount` + '.$waon_class_priority_quantity;
            $time_sql = $time_sql.' WHEN '.$tror_out_waon_id.' THEN "'.date('Y-m-d H:i:s').'"';
    
            $ids = $ids . $tror_out_waon_id.',';
            $sql = $sql .' `waon_stock_priority_amount`=  CASE `waon_id` '.$stock_fine_sql.' END,';
            $sql = $sql .' `waon_lock_priority_amount`=  CASE `waon_id` '.$lock_fine_sql.' END,';
        }
        $sql = $sql .' `waon_update_time`=  CASE `waon_id` '.$time_sql.' END';
        $sql = $sql . ' WHERE `waon_id` = ('.trim($ids, ',').')';
        $waon_priority_res = DB::update($sql);
        if ($wago_edit_res && $waon_priority_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'新增成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'新增失败'];
        }
    }

    /**
     * [repealAllocate 调拨单撤销]
     * @param  [type] $user_info      [用户信息]
     * @param  [type] $ware_id        [仓库id]
     * @param  [type] $wafr_id        [仓位id]
     * @param  [type] $find_trog_data [数组，调拨单商品数据]
     * @param  [type] $waon_id        [仓库类别表id]
     * @param  [type] $tror_state     [调拨单状态：2已通过/待出库3.已出库/待入库]
     * @return [type]                 [description]
     */
    public static function repealAllocate(
        $user_info,
        $ware_id,
        $wafr_id,
        $find_trog_data,
        $waon_id,
        $tror_state
    ) {
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_fine_sql = '';//仓位良品库存数量
        $stock_priority_sql = '';//仓位优先库存数量
        $lock_fine_sql = '';//仓位良品锁定库存数量
        $lock_priority_sql = '';//仓位优先锁定数量
        $stock_number_sql = '';//良品库存数量(仓库+仓位)
        $priority_stock_number_sql = '';//优先库存数量(仓库+仓位)
        $lock_quantity_sqls = '';//良品锁定数量(仓库+仓位)
        $priority_lock_quantity_sql = '';//优先锁定数量(仓库+仓位)
        $time_sql = '';
        $ids = '';

        $waon_class_fine_quantity = 0;//仓库类别对应良品库存总数量
        $waon_class_priority_quantity = 0;//仓库类别对应优先库存总数量
        // 调拨单要出库的商品
        // 调出仓库商品表【良品/优先】锁定数量转正常数量，【良品/优先】库存数量增加，锁定数量减少，
        $find_trog_datas = json_decode(json_encode($find_trog_data), true);
        $trog_wago_id = array_column($find_trog_datas, 'trog_wago_id');
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $ware_id)
            ->whereIn('wago_id', $trog_wago_id)
            ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number','wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_stock_amount', 'wago_lock_amount', 'wago_priority_stock_amount', 'wago_priority_lock_amount', 'wago_freight_lock_quantity', 'wago_freight_priority_lock_quantity')
            ->get()->toArray();
        $warehouse_goods = array_column($warehouse_goods, null, 'wago_id');
        foreach ($find_trog_data as $key => $value) {
            // 根据仓位id,仓库商品id,仓库id,仓库类别和商品id查询对应的仓位商品主键id
            $wafg_id = DB::table('warehouse_freight_goods')
                ->where('wafg_wafr_id', $wafr_id)
                ->where('wafg_wago_id', $value->trog_wago_id)
                ->where('wafg_ware_id', $ware_id)
                ->where('wafg_class', $value->trog_waon_class)
                ->where('wafg_goo_id', $value->trog_goo_id)
                ->select('wafg_id', 'wafg_lock_quantity', 'wafg_priority_lock_quantity')
                ->first();
            // 查询仓位的库存数量
            $find_wafr_data = DB::table('warehouse_freight')
                ->where('wafr_id', $wafr_id)
                ->where('wafr_shop_id', $user_info->adm_shop_id)
                ->select('wafr_id', 'wafr_lock_quantity', 'wafr_priority_lock_quantity')
                ->first();
            if ($value->trog_stock_number > 0) {// 良品
                $surplus_quantity = $warehouse_goods[$value->trog_wago_id]->wago_lock_quantity - $value->trog_stock_number;//总的库存(仓库+仓位)
                $wago_quantity = $warehouse_goods[$value->trog_wago_id]->wago_freight_lock_quantity - $value->trog_stock_number;//仓库库存
                $wafg_lock_quantity = $wafg_id->wafg_lock_quantity - $value->trog_stock_number;
                $wafr_lock_quantity = $find_wafr_data->wafr_lock_quantity - $value->trog_stock_number;
                if ($surplus_quantity < 0 || $wago_quantity < 0 || $wafg_lock_quantity < 0 || $wafr_lock_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'锁定数量不足1'];
                }
                // 更改库存数量
                $stock_fine_sql = $stock_fine_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_stock_number` + '.$value->trog_stock_number;
                if ($tror_state == 2) {// 待出库状态的撤销，更改锁定数量
                    $wago_freight_lock_quantity = $value->trog_stock_number;
                } else {// 已出库状态的撤销，更改锁定数量
                    $wago_freight_lock_quantity = $value->trog_stock_number;
                }
                // 更改锁定数量
                $lock_fine_sql = $lock_fine_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_lock_quantity` - '.$wago_freight_lock_quantity;
                // 更改库存数量
                $stock_priority_sql = $stock_priority_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_priority_stock_number` - 0';
                // 更改锁定数量
                $lock_priority_sql = $lock_priority_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_priority_lock_quantity` + 0';

                // 良品库存数量(仓库+仓位)
                $stock_number_sql = $stock_number_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_stock_number` + '.$value->trog_stock_number;
                // 良品锁定数量(仓库+仓位)
                $lock_quantity_sqls = $lock_quantity_sqls.' WHEN '.$value->trog_wago_id.' THEN `wago_lock_quantity` - '.$wago_freight_lock_quantity;
                // 优先库存数量(仓库+仓位)
                $priority_stock_number_sql = $priority_stock_number_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_priority_stock_number` + 0';
                // 优先锁定数量(仓库+仓位)
                $priority_lock_quantity_sql = $priority_lock_quantity_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_priority_lock_quantity` - 0';
                
                $waon_class_fine_quantity += $value->trog_stock_number;//仓库类别对应良品库存总数量
                // 仓位商品表良品库存数量减少,锁定库存增加
                $stock_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $wafg_id->wafg_id)
                    ->increment('wafg_stock_number', $value->trog_stock_number);
                $lock_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $wafg_id->wafg_id)
                    ->decrement('wafg_lock_quantity', $wago_freight_lock_quantity);
                // 仓位表良品库存数量减少,锁定库存增加
                $stock_all_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $wafr_id)
                    ->where('wafr_shop_id', $user_info->adm_shop_id)
                    ->increment('wafr_all_stock', $value->trog_stock_number);
                $lock_all_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $wafr_id)
                    ->where('wafr_shop_id', $user_info->adm_shop_id)
                    ->decrement('wafr_lock_quantity', $wago_freight_lock_quantity);
                if (!$stock_res || !$lock_res || !$stock_all_res || !$lock_all_res) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'撤销失败！'];
                }
            }
            
            if ($value->trog_priority_stock_number > 0) {// 优先
                $surplus_quantity = $warehouse_goods[$value->trog_wago_id]->wago_lock_quantity - $value->trog_priority_stock_number;//总的库存(仓库+仓位)
                $wago_quantity = $warehouse_goods[$value->trog_wago_id]->wago_freight_lock_quantity - $value->trog_priority_stock_number;//仓库库存
                $wafg_lock_quantity = $wafg_id->wafg_lock_quantity - $value->trog_priority_stock_number;
                $wafr_lock_quantity = $find_wafr_data->wafr_lock_quantity - $value->trog_priority_stock_number;
                if ($surplus_quantity < 0 || $wago_quantity < 0 || $wafg_lock_quantity < 0 || $wafr_lock_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'锁定数量不足1'];
                }
                // 更改库存数量
                $stock_priority_sql = $stock_priority_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_priority_stock_number` + '.$value->trog_priority_stock_number;
                if ($tror_state == 2) {// 待出库状态的撤销，更改锁定数量
                    $wago_freight_priority_lock_quantity = $value->trog_priority_stock_number;
                } else {// 已出库状态的撤销，不更改锁定数量
                    $wago_freight_priority_lock_quantity = $value->trog_priority_stock_number;
                }
                // 更改锁定数量
                $lock_priority_sql = $lock_priority_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_priority_lock_quantity` - '.$wago_freight_priority_lock_quantity;

                // 更改库存数量
                $stock_fine_sql = $stock_fine_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_stock_number` - 0';
                // 更改锁定数量
                $lock_fine_sql = $lock_fine_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_lock_quantity`  + 0';

                // 良品库存数量(仓库+仓位)
                $stock_number_sql = $stock_number_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_stock_number` + 0';
                // 良品锁定数量(仓库+仓位)
                $lock_quantity_sqls = $lock_quantity_sqls.' WHEN '.$value->trog_wago_id.' THEN `wago_lock_quantity` - 0';
                // 优先库存数量(仓库+仓位)
                $priority_stock_number_sql = $priority_stock_number_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_priority_stock_number` + ' . $value->trog_priority_stock_number;
                // 优先锁定数量(仓库+仓位)
                $priority_lock_quantity_sql = $priority_lock_quantity_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_priority_lock_quantity` - ' . $wago_freight_priority_lock_quantity;

                $waon_class_priority_quantity += $value->trog_priority_stock_number;//仓库类别对应优先库存总数量
                // 仓位商品表良品库存数量减少,锁定库存增加
                $stock_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $wafg_id->wafg_id)
                    ->increment('wafg_stock_number', $value->trog_priority_stock_number);
                $lock_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $wafg_id->wafg_id)
                    ->decrement('wafg_lock_quantity', $wago_freight_priority_lock_quantity);
                // 仓位表良品库存数量减少,锁定库存增加
                $stock_all_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $wafr_id)
                    ->where('wafr_shop_id', $user_info->adm_shop_id)
                    ->increment('wafr_all_stock', $value->trog_priority_stock_number);
                $lock_all_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $wafr_id)
                    ->where('wafr_shop_id', $user_info->adm_shop_id)
                    ->decrement('wafr_lock_quantity', $wago_freight_priority_lock_quantity);
                if (!$stock_res || !$lock_res || !$stock_all_res || !$lock_all_res) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'撤销失败！'];
                }
            }
            $time_sql = $time_sql.' WHEN '.$value->trog_wago_id.' THEN "'.date('Y-m-d H:i:s').'"'; // 更改时间
            $ids = $ids . $value->trog_wago_id.',';
        }
        // 2.1 固定仓商品表减锁定库存
        $sql = $sql .' `wago_freight_stock_number`=  CASE `wago_id` '.$stock_fine_sql.' END,'; //修改良品库存数量
        $sql = $sql .' `wago_freight_lock_quantity`=  CASE `wago_id` '.$lock_fine_sql.' END,'; //修改良品锁定数量
        $sql = $sql .' `wago_freight_priority_stock_number`=  CASE `wago_id` '.$stock_priority_sql.' END,'; //修改优先库存数量
        $sql = $sql .' `wago_freight_priority_lock_quantity`=  CASE `wago_id` '.$lock_priority_sql.' END,'; //修改优先锁定数量
        $sql = $sql .' `wago_stock_number`=  CASE `wago_id` '.$stock_number_sql.' END,'; //修改良品库存数量
        $sql = $sql .' `wago_lock_quantity`=  CASE `wago_id` '.$lock_quantity_sqls.' END,'; //修改良品锁定数量
        $sql = $sql .' `wago_priority_stock_number`=  CASE `wago_id` '.$priority_stock_number_sql.' END,'; //修改优先库存数量
        $sql = $sql .' `wago_priority_lock_quantity`=  CASE `wago_id` '.$priority_lock_quantity_sql.' END,'; //修改优先锁定数量
        $sql = $sql .' `wago_update_time`=  CASE `wago_id` '.$time_sql.' END'; //修改时间
        $sql = $sql . ' WHERE `wago_id` IN ('.trim($ids, ',').')';
        $wago_edit_res = DB::update($sql);
        
        // 修改仓库类别表库存数据
        $sql = 'UPDATE `faster_warehouse_onhand` SET ';
        $stock_fine_sql = '';
        $lock_fine_sql = '';
        $time_sql = '';
        $ids = '';
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $stock_fine_sql = $stock_fine_sql.' WHEN '.$waon_id.' THEN `waon_stock_fine_amount` + '.$waon_class_fine_quantity;
            if ($tror_state == 2) {// 待出库状态的撤销，更改锁定数量
                $waon_lock_fine_amount = $waon_class_fine_quantity;
            } else {// 已出库状态的撤销，更改锁定数量
                $waon_lock_fine_amount = $waon_class_fine_quantity;
            }
            $lock_fine_sql = $lock_fine_sql.' WHEN '.$waon_id.' THEN `waon_lock_fine_amount` - '.$waon_lock_fine_amount;
            $time_sql = $time_sql.' WHEN '.$waon_id.' THEN "'.date('Y-m-d H:i:s').'"';
    
            $ids = $ids . $waon_id.',';
            $sql = $sql .' `waon_stock_fine_amount`=  CASE `waon_id` '.$stock_fine_sql.' END,';
            $sql = $sql .' `waon_lock_fine_amount`=  CASE `waon_id` '.$lock_fine_sql.' END,';
        }
        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $stock_fine_sql = $stock_fine_sql.' WHEN '.$waon_id.' THEN `waon_stock_priority_amount` + '.$waon_class_priority_quantity;
            if ($tror_state == 2) {// 待出库状态的撤销，更改锁定数量
                $waon_lock_priority_amount = $waon_class_priority_quantity;
            } else {// 已出库状态的撤销，更改锁定数量
                $waon_lock_priority_amount = $waon_class_priority_quantity;
            }
            $lock_fine_sql = $lock_fine_sql.' WHEN '.$waon_id.' THEN `waon_lock_priority_amount` - '.$waon_lock_priority_amount;
            $time_sql = $time_sql.' WHEN '.$waon_id.' THEN "'.date('Y-m-d H:i:s').'"';
    
            $ids = $ids . $waon_id.',';
            $sql = $sql .' `waon_stock_priority_amount`=  CASE `waon_id` '.$stock_fine_sql.' END,';
            $sql = $sql .' `waon_lock_priority_amount`=  CASE `waon_id` '.$lock_fine_sql.' END,';
        }
        $sql = $sql .' `waon_update_time`=  CASE `waon_id` '.$time_sql.' END';
        $sql = $sql . ' WHERE `waon_id` = ('.trim($ids, ',').')';
        $waon_priority_res = DB::update($sql);
        if ($waon_priority_res && $wago_edit_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'撤销成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'撤销失败'];
        }
    }

    /**
     * [putInStorages 调拨单入库]
     * @param  [type]  $user_info           [用户信息]
     * @param  [type]  $request             [提交数据]
     * @param  [type]  $find_tror           [调拨单数据]
     * @param  [type]  $find_trog_data      [调拨单商品数据]
     * @param  [type]  $tror_out_waon_id    [调出仓库的类别id]
     * @return [type]                       [description]
     */
    public static function putInStorages(
        $user_info,
        $request,
        $find_tror,
        $find_trog_data,
        $tror_out_waon_id,
        $goods_data
    ) {
        // 根据调拨单id，查询调拨单商品信息
        $trog_id = DB::table('transferring_order_goods')
            ->where('trog_tror_id', $request['tror_id'])
            ->select('trog_id', 'trog_wago_id', 'trog_goo_id', 'trog_waon_class', 'trog_stock_number', 'trog_priority_stock_number')
            ->get()->toArray();
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $lock_fine_sql = '';//仓位良品锁定库存数量
        $lock_priority_sql = '';//仓位优先锁定数量
        $lock_fines_sql = '';//良品锁定数量(仓库+仓位)
        $priority_lock_sql = '';//优先锁定数量(仓库+仓位)
        $time_sql = '';
        $ids = '';
        
        $waon_class_fine_quantity = 0;//仓库类别对应良品库存总数量
        $waon_class_priority_quantity = 0;//仓库类别对应优先库存总数量
        $goo_key = 0;
        // 调拨单要出库的商品
        $find_trog_datas = json_decode(json_encode($find_trog_data), true);
        $trog_wago_id = array_column($find_trog_datas, 'trog_wago_id');
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $find_tror->tror_out_ware_id)
            ->whereIn('wago_id', $trog_wago_id)
            ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_lock_quantity', 'wago_priority_lock_quantity', 'wago_lock_amount', 'wago_priority_lock_amount', 'wago_freight_lock_quantity', 'wago_freight_priority_lock_quantity')
            ->get()->toArray();
        $warehouse_goods = array_column($warehouse_goods, null, 'wago_id');
        foreach ($trog_id as $key => $value) {
            // 根据仓位id,仓库商品id,仓库id,仓库类别和商品id查询对应的仓位id
            $wafg_id = DB::table('warehouse_freight_goods')
                ->where('wafg_wafr_id', $find_tror->tror_out_wafr_id)
                ->where('wafg_wago_id', $value->trog_wago_id)
                ->where('wafg_ware_id', $find_tror->tror_out_ware_id)
                ->where('wafg_class', $value->trog_waon_class)
                ->where('wafg_goo_id', $value->trog_goo_id)
                ->value('wafg_id');
            // 根据仓位商品id查询库存
            $find_wafg_data = DB::table('warehouse_freight_goods')
                ->where('wafg_wafr_id', $find_tror->tror_out_wafr_id)
                ->where('wafg_wago_id', $value->trog_wago_id)
                ->where('wafg_ware_id', $find_tror->tror_out_ware_id)
                ->where('wafg_class', $value->trog_waon_class)
                ->where('wafg_goo_id', $value->trog_goo_id)
                ->select('wafg_lock_quantity', 'wafg_priority_lock_quantity')
                ->first();
            // 根据仓位id查询库存
            $find_wafr_data = DB::table('warehouse_freight')
                ->where('wafr_id', $find_tror->tror_out_wafr_id)
                ->where('wafr_shop_id', $user_info->adm_shop_id)
                ->where('wafr_ware_id', $find_tror->tror_out_ware_id)
                ->select('wafr_lock_quantity', 'wafr_priority_lock_quantity')
                ->first();
            // 良品
            if ($value->trog_stock_number > 0) {
                $surplus_quantity = $warehouse_goods[$value->trog_wago_id]->wago_lock_quantity - $value->trog_stock_number;//总的库存(仓库+仓位)
                $wago_quantity = $warehouse_goods[$value->trog_wago_id]->wago_freight_lock_quantity - $value->trog_stock_number;//仓库库存
                $wafg_lock_quantity = $find_wafg_data->wafg_lock_quantity - $value->trog_stock_number;
                $wafr_lock_quantity = $find_wafr_data->wafr_lock_quantity - $value->trog_stock_number;
                if ($surplus_quantity < 0 || $wago_quantity < 0 || $wafg_lock_quantity < 0 || $wafr_lock_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'锁定数量不足1'];
                }
                $goo_id[$goo_key] = $value->trog_goo_id;//商品id
                $goo_quantity[$goo_key] = $value->trog_stock_number;//商品数量
                $goo_price[$goo_key] = $value->trog_stock_number;//价格
                $goo_inventory[$goo_key] = 1;//出库类型1良品2优先
                $wfog_wago_id[$goo_key] = $value->trog_wago_id;//仓库商品主键id
                $wfog_wafg_id[$goo_key] = $wafg_id;//仓位商品主键id
                $wfog_primary_id[$goo_key] = $value->trog_id;//关联商品表主键id
                $goo_key++;
                // 更改仓位良品锁定数量
                $lock_fine_sql = $lock_fine_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_lock_quantity` - '.$value->trog_stock_number;
                // 更改锁定数量
                $lock_priority_sql = $lock_priority_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_priority_lock_quantity` + 0';
                // 更改良品锁定数量(仓库+仓位)
                $lock_fines_sql = $lock_fines_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_lock_quantity` - '.$value->trog_stock_number;
                // 更改优先锁定数量(仓库+仓位)
                $priority_lock_sql = $priority_lock_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_priority_lock_quantity` + 0';
                
                $waon_class_fine_quantity += $value->trog_stock_number;//仓库类别对应良品库存总数量
                // 仓位商品表良品锁定库存数量减少
                $lock_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $wafg_id)
                    ->decrement('wafg_lock_quantity', $value->trog_stock_number);
                // 仓位表良品锁定库存数量减少
                $lock_all_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $find_tror->tror_out_wafr_id)
                    ->where('wafr_shop_id', $user_info->adm_shop_id)
                    ->decrement('wafr_lock_quantity', $value->trog_stock_number);
            }
            
            // 优先
            if ($value->trog_priority_stock_number > 0) {
                $surplus_quantity = $warehouse_goods[$value->trog_wago_id]->wago_lock_quantity - $value->trog_priority_stock_number;//总的库存(仓库+仓位)
                $wago_quantity = $warehouse_goods[$value->trog_wago_id]->wago_freight_lock_quantity - $value->trog_priority_stock_number;//仓库库存
                $wafg_lock_quantity = $find_wafg_data->wafg_lock_quantity - $value->trog_priority_stock_number;
                $wafr_lock_quantity = $find_wafr_data->wafr_lock_quantity - $value->trog_priority_stock_number;
                if ($surplus_quantity < 0 || $wago_quantity < 0 || $wafg_lock_quantity < 0 || $wafr_lock_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'锁定数量不足1'];
                }
                $goo_id[$goo_key] = $value->trog_goo_id;//商品id
                $goo_quantity[$goo_key] = $value->trog_priority_stock_number;//商品数量
                $goo_price[$goo_key] = $value->trog_priority_stock_number;//价格
                $goo_inventory[$goo_key] = 2;//出库类型1良品2优先
                $wfog_wago_id[$goo_key] = $value->trog_wago_id;//仓库商品主键id
                $wfog_wafg_id[$goo_key] = $wafg_id;//仓位商品主键id
                $wfog_primary_id[$goo_key] = $value->trog_id;//关联商品表主键id

                $goo_key++;
                // 更改优先锁定数量
                $lock_priority_sql = $lock_priority_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_priority_lock_quantity` - '.$value->trog_priority_stock_number;
                // 更改锁定数量
                $lock_fine_sql = $lock_fine_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_lock_quantity`  + 0';
                // 更改优先锁定数量(仓库+仓位)
                $priority_lock_sql = $priority_lock_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_priority_lock_quantity` - '.$value->trog_priority_stock_number;
                // 更改良品锁定数量(仓库+仓位)
                $lock_fines_sql = $lock_fines_sql.' WHEN '.$value->trog_wago_id.' THEN `wago_freight_lock_quantity`  + 0';
                
                $waon_class_priority_quantity += $value->trog_priority_stock_number;//仓库类别对应优先库存总数量
                // 仓位商品表良品锁定库存数量减少
                $lock_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $wafg_id)
                    ->decrement('wafg_lock_quantity', $value->trog_priority_stock_number);
                // 仓位表良品锁定库存数量减少
                $lock_all_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $find_tror->tror_out_wafr_id)
                    ->where('wafr_shop_id', $user_info->adm_shop_id)
                    ->decrement('wafr_lock_quantity', $value->trog_priority_stock_number);
            }
            $time_sql = $time_sql.' WHEN '.$value->trog_wago_id.' THEN "'.date('Y-m-d H:i:s').'"'; // 更改时间
            $ids = $ids . $value->trog_wago_id.',';
        }
        // 2.1 固定仓商品表减锁定库存
        $sql = $sql .' `wago_freight_lock_quantity`=  CASE `wago_id` '.$lock_fine_sql.' END,'; //修改良品锁定数量
        $sql = $sql .' `wago_freight_priority_lock_quantity`=  CASE `wago_id` '.$lock_priority_sql.' END,'; //修改优先锁定数量
        $sql = $sql .' `wago_lock_quantity`=  CASE `wago_id` '.$lock_fines_sql.' END,'; //修改良品锁定数量
        $sql = $sql .' `wago_priority_lock_quantity`=  CASE `wago_id` '.$priority_lock_sql.' END,'; //修改优先锁定数量
        $sql = $sql .' `wago_update_time`=  CASE `wago_id` '.$time_sql.' END'; //修改时间
        $sql = $sql . ' WHERE `wago_id` IN ('.trim($ids, ',').')';
        // 查询仓库类型1固定仓2移动仓
        $ware_type = DB::table('warehouse')
            ->where('ware_id', $find_tror->tror_out_ware_id)
            ->value('ware_type');
        if ($ware_type == 2) {
            DB::rollBack();
            return ['code'=>500, 'msg'=>'error', 'data'=>'技师库无法调拨！'];
        }
        $wago_edit_res = DB::update($sql);

        // 修改仓库类别表库存数据
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $warehouse_onhand_sql = 'UPDATE `faster_warehouse_onhand` SET  `waon_all_amount`= `waon_all_amount` - ' . $waon_class_fine_quantity.', `waon_lock_fine_amount`= `waon_lock_fine_amount` - ' . $waon_class_fine_quantity .' ,`waon_update_time`= "'.date('Y-m-d H:i:s').'"  WHERE  `waon_id` ='.$tror_out_waon_id;
            $all_fine_res = DB::update($warehouse_onhand_sql);
        } else {
            $all_fine_res = true;
        }
        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $warehouse_onhand_sql = 'UPDATE `faster_warehouse_onhand` SET  `waon_all_amount`= `waon_all_amount` - ' . $waon_class_priority_quantity.', `waon_lock_priority_amount`= `waon_lock_priority_amount` - ' . $waon_class_priority_quantity .' ,`waon_update_time`= "'.date('Y-m-d H:i:s').'"  WHERE  `waon_id` ='.$tror_out_waon_id;
            $all_priority_res = DB::update($warehouse_onhand_sql);
        } else {
            $all_priority_res = true;
        }
        // 查询要入库的仓库商品表的商品数据
        $trog_goo_id = array_column($find_trog_data, 'trog_goo_id');//调货单要调货的商品id
        $find_wago_data = DB::table('warehouse_goods')
            ->where('wago_ware_id', $find_tror->tror_in_ware_id)
            ->where('wago_class', $find_tror->tror_out_waon_class)
            ->whereIn('wago_goo_id', $trog_goo_id)
            ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_freight_stock_number', 'wago_freight_priority_stock_number', 'wago_stock_number', 'wago_priority_stock_number')
            ->get()->toArray();
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_fine_sql = '';//仓位良品库存数量
        $stock_priority_sql = '';//仓位优先库存数量
        $stock_number_sql = '';//良品库存数量(仓库+仓位)
        $priority_stock_number_sql = '';//优先库存数量(仓库+仓位)
        $lock_fine_sql = '';
        $lock_priority_sql = '';
        $time_sql = '';
        $ids = '';
        
        $add_wago_data = [];//新增商品数据数组
        $add_key = 0;
        $waon_class_fine_quantity = 0;//仓库类别对应良品库存总数量
        $waon_class_priority_quantity = 0;//仓库类别对应优先库存总数量
        $goo_key = 0;
        $goo_amount = 0;//入库商品总数量
        $wago_goo_id_data = array_column($find_wago_data, null, 'wago_goo_id');
        foreach ($goods_data as $key => $value) {
            // 判断移动仓库内是否有入库商品id，有商品id就更改库存数量
            if (isset($wago_goo_id_data[$value['goo_id']])) {
                // 良品库存
                if ($value['goo_stock_number'] > 0) {
                    // 出入库记录用到的数组
                    $goo_id[$goo_key] = $value['goo_id'];//商品id
                    $goo_quantity[$goo_key] = $value['goo_stock_number'];//商品数量
                    $goo_price[$goo_key] = $value['goo_stock_number'];//价格
                    $goo_inventory[$goo_key] = 1;//出库类型1良品2优先
                    $goo_key++;

                    // 更改仓位良品库存数量
                    $stock_fine_sql = $stock_fine_sql.' WHEN '.$wago_goo_id_data[$value['goo_id']]->wago_id.' THEN `wago_freight_stock_number` + '.$value['goo_stock_number'];
                    // 更改仓位优先库存数量
                    $stock_priority_sql = $stock_priority_sql.' WHEN '.$wago_goo_id_data[$value['goo_id']]->wago_id.' THEN `wago_freight_priority_stock_number` - 0';
                    // 良品库存数量(仓库+仓位)
                    $stock_number_sql = $stock_number_sql.' WHEN '.$wago_goo_id_data[$value['goo_id']]->wago_id.' THEN `wago_stock_number` + '.$value['goo_stock_number'];
                    // 优先库存数量(仓库+仓位)
                    $priority_stock_number_sql = $priority_stock_number_sql.' WHEN '.$wago_goo_id_data[$value['goo_id']]->wago_id.' THEN `wago_priority_stock_number` - 0';
                    $waon_class_fine_quantity += $value['goo_stock_number'];//仓库类别对应良品库存总数量
                }

                // 优先
                if ($value['goo_priority_stock_number'] > 0) {
                    // 出入库记录用到的数组
                    $goo_id[$goo_key] = $value['goo_id'];//商品id
                    $goo_quantity[$goo_key] = $value['goo_priority_stock_number'];//商品数量
                    $goo_price[$goo_key] = $value['goo_stock_number'];//价格
                    $goo_inventory[$goo_key] = 2;//出库类型1良品2优先
                    $goo_key++;

                    // 更改仓位良品库存数量
                    $stock_priority_sql = $stock_priority_sql.' WHEN '.$wago_goo_id_data[$value['goo_id']]->wago_id.' THEN `wago_freight_priority_stock_number` + '.$value['goo_priority_stock_number'];
                    // 更改仓位优先库存数量
                    $stock_fine_sql = $stock_fine_sql.' WHEN '.$wago_goo_id_data[$value['goo_id']]->wago_id.' THEN `wago_freight_stock_number` - 0';
                    // 优先库存数量(仓库+仓位)
                    $priority_stock_number_sql = $priority_stock_number_sql.' WHEN '.$wago_goo_id_data[$value['goo_id']]->wago_id.' THEN `wago_priority_stock_number` + '.$value['goo_priority_stock_number'];
                    // 良品库存数量(仓库+仓位)
                    $stock_number_sql = $stock_number_sql.' WHEN '.$wago_goo_id_data[$value['goo_id']]->wago_id.' THEN `wago_stock_number` - 0';
                    $waon_class_priority_quantity += $value['goo_priority_stock_number'];//仓库类别对应优先库存总数量
                }
                $time_sql = $time_sql.' WHEN '.$wago_goo_id_data[$value['goo_id']]->wago_id.' THEN "'.date('Y-m-d H:i:s').'"'; // 更改时间
                $ids = $ids . $wago_goo_id_data[$value['goo_id']]->wago_id.',';

                $wago_id[] = $wago_goo_id_data[$value['goo_id']]->wago_id;//仓库商品主键id
            } else {// 没有入库商品id，就在仓库中新增商品数据
                $add_wago_data['wago_ware_id'] = $find_tror->tror_in_ware_id;//仓库id
                $add_wago_data['wago_class'] = $find_tror->tror_out_waon_class;//仓库类别：1货物仓2非货物仓3旧货仓4临时仓
                $add_wago_data['wago_goo_id'] = $value['goo_id'];//商品id
                $add_wago_data['wago_freight_stock_number'] = $value['goo_stock_number'];//良品库存数量
                $add_wago_data['wago_freight_priority_stock_number'] = $value['goo_priority_stock_number'];//优先库存数量
                $add_wago_data['wago_stock_number'] = $value['goo_stock_number'];//良品库存数量(仓库+仓位)
                $add_wago_data['wago_priority_stock_number'] = $value['goo_priority_stock_number'];//优先库存数量(仓库+仓位)
                $add_key++;
                $add_wago_id = DB::table('warehouse_goods')->insertGetId($add_wago_data);
                // 良品库存
                if ($value['goo_stock_number'] > 0) {
                    // 出入库记录用到的数组
                    $goo_id[$goo_key] = $value['goo_id'];//商品id
                    $goo_quantity[$goo_key] = $value['goo_stock_number'];//商品数量
                    $goo_price[$goo_key] = $value['goo_stock_number'];//价格
                    $goo_inventory[$goo_key] = 1;//出库类型1良品2优先
                    $goo_key++;

                    $waon_class_fine_quantity += $value['goo_stock_number'];//仓库类别对应良品库存总数量
                }
                // 优先
                if ($value['goo_priority_stock_number'] > 0) {
                    // 出入库记录用到的数组
                    $goo_id[$goo_key] = $value['goo_id'];//商品id
                    $goo_quantity[$goo_key] = $value['goo_priority_stock_number'];//商品数量
                    $goo_price[$goo_key] = $value['goo_stock_number'];//价格
                    $goo_inventory[$goo_key] = 2;//出库类型1良品2优先
                    $goo_key++;

                    $waon_class_priority_quantity += $value['goo_priority_stock_number'];//仓库类别对应优先库存总数量
                }
                $wago_id[] = $add_wago_id;
            }
            $goo_amount = $goo_amount + $value['goo_stock_number'];
            $goo_amount = $goo_amount + $value['goo_priority_stock_number'];
            $wafr_id[] = $value['goo_wafr_id'];
        }
        if (empty($ids)) {
            $wago_edit_res = true;
        } else {
            // 2.1 固定仓商品表减锁定库存
            $sql = $sql .' `wago_freight_stock_number`=  CASE `wago_id` '.$stock_fine_sql.' END,'; //修改良品库存数量
            $sql = $sql .' `wago_freight_priority_stock_number`=  CASE `wago_id` '.$stock_priority_sql.' END,'; //修改优先库存数量
            $sql = $sql .' `wago_stock_number`=  CASE `wago_id` '.$stock_number_sql.' END,'; //修改良品库存数量(仓库+仓位)
            $sql = $sql .' `wago_priority_stock_number`=  CASE `wago_id` '.$priority_stock_number_sql.' END,'; //修改优先库存数量(仓库+仓位)
            $sql = $sql .' `wago_update_time`=  CASE `wago_id` '.$time_sql.' END'; //修改时间
            $sql = $sql . ' WHERE `wago_id` IN ('.trim($ids, ',').')';
            $wago_edit_res = DB::update($sql);
        }
        // 判断仓位是否存在
        $find_wafr_data = DB::table('warehouse_freight')
            ->whereIn('wafr_id', $wafr_id)
            ->where('wafr_delete', 1)
            ->select('wafr_id', 'wafr_name')
            ->get()->toArray();
        foreach ($find_wafr_data as $key => $value) {
            if (empty($value->wafr_id)) {
                return ['code'=>'500', 'msg'=>'error', 'data'=>'当前仓位不存在！！！'];
            }
        }
        // 仓位商品表
        $find_wafg_data = DB::table('warehouse_freight_goods')
            ->whereIn('wafg_wafr_id', $wafr_id)
            ->whereIn('wafg_wago_id', $wago_id)
            ->where('wafg_ware_id', $find_tror->tror_in_ware_id)
            ->where('wafg_class', $find_tror->tror_out_waon_class)
            ->whereIn('wafg_goo_id', $trog_goo_id)
            ->select('wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_ware_id', 'wafg_class', 'wafg_goo_id', 'wafg_stock_number', 'wafg_priority_stock_number')
            ->get()->toArray();
        $sql = 'UPDATE `faster_warehouse_freight_goods` SET ';
        $freight_stock_fine_sql = '';
        $freight_stock_priority_sql = '';
        $freight_time_sql = '';
        $freight_ids = '';
        
        $add_wafg_data = [];//新增商品数据数组
        $add_key = 0;
        $goo_key = 0;
        $goo_amount = 0;//入库商品总数量
        $wafg_goo_id_data = array_column($find_wafg_data, null, 'wafg_goo_id');
        foreach ($goods_data as $key => $value) {
            if (isset($wafg_goo_id_data[$value['goo_id']])) {//判断仓库内是否有入库商品id，有商品id就更改库存数量
                if ($value['goo_stock_number'] > 0) {// 良品库存
                    // 更改库存数量
                    $freight_stock_fine_sql = $freight_stock_fine_sql.' WHEN '.$wafg_goo_id_data[$value['goo_id']]->wafg_id.' THEN `wafg_stock_number` + '.$value['goo_stock_number'];
                    // 更改库存数量
                    $freight_stock_priority_sql = $freight_stock_priority_sql.' WHEN '.$wafg_goo_id_data[$value['goo_id']]->wafg_id.' THEN `wafg_priority_stock_number` - 0';
                }
                
                if ($value['goo_priority_stock_number'] > 0) {// 优先
                    // 更改库存数量
                    $freight_stock_priority_sql = $freight_stock_priority_sql.' WHEN '.$wafg_goo_id_data[$value['goo_id']]->wafg_id.' THEN `wafg_priority_stock_number` + '.$value['goo_priority_stock_number'];
                    // 更改库存数量
                    $freight_stock_fine_sql = $freight_stock_fine_sql.' WHEN '.$wafg_goo_id_data[$value['goo_id']]->wafg_id.' THEN `wafg_stock_number` - 0';
                }
                $freight_time_sql = $freight_time_sql.' WHEN '.$wafg_goo_id_data[$value['goo_id']]->wafg_id.' THEN "'.date('Y-m-d H:i:s').'"'; // 更改时间
                $freight_ids = $freight_ids . $wafg_goo_id_data[$value['goo_id']]->wafg_id.',';
                // 良品库存
                if ($value['goo_stock_number'] > 0) {
                    // 更改仓位表库存数量
                    $stock_res = DB::table('warehouse_freight')
                        ->where('wafr_shop_id', $user_info->adm_shop_id)
                        ->where('wafr_id', $value['goo_wafr_id'])
                        ->increment('wafr_all_stock', $value['goo_stock_number']);
                    // 仓位出入库记录用到的数组
                    $wfog_goo_id[$goo_key] = $value['goo_id'];//商品id
                    $wfog_stock_amount[$goo_key] = $value['goo_stock_number'];//商品数量
                    $wfog_stock_type[$goo_key] = 1;//出库类型1良品2优先
                    $wfog_wago_id[$goo_key] = $wafg_goo_id_data[$value['goo_id']]->wafg_wago_id;//仓库商品主键id
                    $wfog_wafr_id[$goo_key] = $value['goo_wafr_id'];//仓位id
                    $wfog_wafg_id[$goo_key] = $wafg_goo_id_data[$value['goo_id']]->wafg_id;//仓位商品主键id
                    $wfog_primary_id[$goo_key] = $value['trog_id'];//仓位商品主键id
                    $goo_key++;
                }

                // 优先
                if ($value['goo_priority_stock_number'] > 0) {
                    // 更改仓位表库存数量
                    $stock_res = DB::table('warehouse_freight')
                        ->where('wafr_shop_id', $user_info->adm_shop_id)
                        ->where('wafr_id', $value['goo_wafr_id'])
                        ->increment('wafr_all_stock', $value['goo_priority_stock_number']);
                    // 仓位出入库记录用到的数组
                    $wfog_goo_id[$goo_key] = $value['goo_id'];//商品id
                    $wfog_stock_amount[$goo_key] = $value['goo_priority_stock_number'];//商品数量
                    $wfog_stock_type[$goo_key] = 2;//出库类型1良品2优先
                    $wfog_wago_id[$goo_key] = $wafg_goo_id_data[$value['goo_id']]->wafg_wago_id;//仓库商品主键id
                    $wfog_wafr_id[$goo_key] = $value['goo_wafr_id'];//仓位id
                    $wfog_wafg_id[$goo_key] = $wafg_goo_id_data[$value['goo_id']]->wafg_id;//仓位商品主键id
                    $wfog_primary_id[$goo_key] = $value['trog_id'];//仓位商品主键id
                    $goo_key++;
                }
            } else {// 没有入库商品id，就在仓位商品表中新增商品数据
                $add_wafg_data['wafg_wafr_id'] = $value['goo_wafr_id'];//仓位id
                $wafg_wago_id = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $find_tror->tror_in_ware_id)
                    ->where('wago_class', $find_tror->tror_out_waon_class)
                    ->whereIn('wago_goo_id', $trog_goo_id)
                    ->value('wago_id');
                $add_wafg_data['wafg_wago_id'] = $wafg_wago_id;//仓库商品id
                $add_wafg_data['wafg_ware_id'] = $find_tror->tror_in_ware_id;//仓库id
                $add_wafg_data['wafg_class'] = $find_tror->tror_out_waon_class;//仓库类别：1货物仓2非货物仓3旧货仓4临时仓
                $add_wafg_data['wafg_goo_id'] = $value['goo_id'];//商品id
                $add_wafg_data['wafg_stock_number'] = $value['goo_stock_number'];//良品库存数量
                $add_wafg_data['wafg_priority_stock_number'] = $value['goo_priority_stock_number'];//优先库存数量
                $add_key++;
                $wafg_id = DB::table('warehouse_freight_goods')->insertGetId($add_wafg_data);
                // 良品库存
                if ($value['goo_stock_number'] > 0) {
                    // 更改仓位表库存数量
                    $stock_res = DB::table('warehouse_freight')
                        ->where('wafr_shop_id', $user_info->adm_shop_id)
                        ->where('wafr_id', $value['goo_wafr_id'])
                        ->increment('wafr_all_stock', $value['goo_stock_number']);
                    // 仓位出入库记录用到的数组
                    $wfog_goo_id[$goo_key] = $value['goo_id'];//商品id
                    $wfog_stock_amount[$goo_key] = $value['goo_stock_number'];//商品数量
                    $wfog_stock_type[$goo_key] = 1;//出库类型1良品2优先
                    $wfog_wago_id[$goo_key] = $wafg_wago_id;//仓库商品主键id
                    $wfog_wafr_id[$goo_key] = $value['goo_wafr_id'];//仓位id
                    $wfog_wafg_id[$goo_key] = $wafg_id;//仓位商品主键id
                    $wfog_primary_id[$goo_key] = $value['trog_id'];//仓位商品主键id
                    $goo_key++;
                }

                // 优先
                if ($value['goo_priority_stock_number'] > 0) {
                    // 更改仓位表库存数量
                    $stock_res = DB::table('warehouse_freight')
                        ->where('wafr_shop_id', $user_info->adm_shop_id)
                        ->where('wafr_id', $value['goo_wafr_id'])
                        ->increment('wafr_all_stock', $value['goo_priority_stock_number']);
                    // 仓位出入库记录用到的数组
                    $wfog_goo_id[$goo_key] = $value['goo_id'];//商品id
                    $wfog_stock_amount[$goo_key] = $value['goo_priority_stock_number'];//商品数量
                    $wfog_stock_type[$goo_key] = 2;//出库类型1良品2优先
                    $wfog_wago_id[$goo_key] = $wafg_wago_id;//仓库商品主键id
                    $wfog_wafr_id[$goo_key] = $value['goo_wafr_id'];//仓位id
                    $wfog_wafg_id[$goo_key] = $wafg_id;//仓位商品主键id
                    $wfog_primary_id[$goo_key] = $value['trog_id'];//仓位商品主键id
                    $goo_key++;
                }
            }
            $goo_amount = $goo_amount + $value['goo_stock_number'];
            $goo_amount = $goo_amount + $value['goo_priority_stock_number'];
        }
        if (empty($freight_ids)) {
            $wago_edit_res = true;
        } else {
            // 2.1 固定仓商品表减锁定库存
            $sql = $sql .' `wafg_stock_number`=  CASE `wafg_id` '.$freight_stock_fine_sql.' END,'; //修改良品库存数量
            $sql = $sql .' `wafg_priority_stock_number`=  CASE `wafg_id` '.$freight_stock_priority_sql.' END,'; //修改优先库存数量
            $sql = $sql .' `wafg_update_time`=  CASE `wafg_id` '.$freight_time_sql.' END'; //修改时间
            $sql = $sql . ' WHERE `wafg_id` IN ('.trim($freight_ids, ',').')';
            $wago_edit_res = DB::update($sql);
        }

        // 修改仓库类别表库存数据
        $sql = 'UPDATE `faster_warehouse_onhand` SET ';
        $stock_fine_sql = '';
        $lock_fine_sql = '';
        $priority_stock_fine_sql = '';
        $all_amount_sql = '';
        $time_sql = '';
        $ids = '';
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $stock_fine_sql = $stock_fine_sql.' WHEN '.$find_tror->tror_in_waon_id.' THEN `waon_stock_fine_amount` + '.$waon_class_fine_quantity;
            $all_amount_sql = $all_amount_sql.' WHEN '.$find_tror->tror_in_waon_id.' THEN `waon_all_amount` + '.$waon_class_fine_quantity;
            $time_sql = $time_sql.' WHEN '.$find_tror->tror_in_waon_id.' THEN "'.date('Y-m-d H:i:s').'"';
        
            $ids = $ids . $find_tror->tror_in_waon_id.',';
            $sql = $sql .' `waon_stock_fine_amount`=  CASE `waon_id` '.$stock_fine_sql.' END,';
            $sql = $sql .' `waon_all_amount`=  CASE `waon_id` '.$all_amount_sql.' END,';
        }
        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $priority_stock_fine_sql = $priority_stock_fine_sql.' WHEN '.$find_tror->tror_in_waon_id.' THEN `waon_stock_priority_amount` + '.$waon_class_priority_quantity;
            $all_amount_sql = $all_amount_sql.' WHEN '.$find_tror->tror_in_waon_id.' THEN `waon_all_amount` + '.$waon_class_priority_quantity;
            $time_sql = $time_sql.' WHEN '.$find_tror->tror_in_waon_id.' THEN "'.date('Y-m-d H:i:s').'"';
        
            $ids = $ids . $find_tror->tror_in_waon_id.',';
            $sql = $sql .' `waon_stock_priority_amount`=  CASE `waon_id` '.$priority_stock_fine_sql.' END,';
            $sql = $sql .' `waon_all_amount`=  CASE `waon_id` '.$all_amount_sql.' END,';
        }
        $sql = $sql .' `waon_update_time`=  CASE `waon_id` '.$time_sql.' END';
        $sql = $sql . ' WHERE `waon_id` IN ('.trim($ids, ',').')';
        $waon_priority_res = DB::update($sql);

        // 查询库存数量
        $amounts = DB::table('warehouse_onhand')
            ->where('waon_id', $tror_out_waon_id)
            ->select('waon_all_amount', 'waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount', 'waon_stock_unchecked_amount')
            ->first();
        
        // 3.生成出库记录
        $out_res = OutinRecord::addition(
            $user_info,//用户信息
            $find_tror->tror_id,//原始单的关联id
            $find_tror->tror_number,//原始单的关联单号
            2,//原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
            0,//买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
            0,//选择的客户id,会员id/单位id
            $find_tror->tror_number,//调拨单号
            0,//入库仓库id
            $find_tror->tror_out_ware_id,//出库仓库id
            $waon_class_fine_quantity,//出库商品总量
            2,//类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
            2,//操作类型：1锁定库存2出库3入库4调货5发货
            $amounts->waon_stock_fine_amount,//良品总库存
            $amounts->waon_lock_fine_amount,//良品锁定数量
            $amounts->waon_stock_priority_amount,//优先总库存
            $amounts->waon_lock_priority_amount,//优先锁定数量
            $amounts->waon_stock_unchecked_amount,//待检测总库存
            1,//出入库类型：1出库，2入库
            $find_tror->tror_out_waon_class,//仓库类别
            $goo_id,//商品id
            $goo_quantity,//商品数量
            $goo_inventory //出库类型1良品2优先
        );
        $out_wfog_res = Dispatch::shipmentAddition(
            $user_info,//用户信息
            0,//入库仓库id
            $find_tror->tror_out_ware_id,//出库仓库id
            $wfog_wago_id,//仓库商品主键id
            $wfog_wafr_id,//仓位id
            $wfog_wafg_id,//仓位商品主键id
            4,//关联类型：4调拨出库
            $request['tror_id'],//原始单id
            $find_tror->tror_number,//原始单号
            $wfog_primary_id,//关联商品表主键id
            $wfog_goo_id,//商品id
            1,//出入库类型：1出库2入库
            $wfog_stock_amount,//商品数量
            $wfog_stock_type//库存类型1良品2优先
        );
        // 查询库存数量
        $amount = DB::table('warehouse_onhand')
            ->where('waon_id', $find_tror->tror_in_waon_id)
            ->select('waon_all_amount', 'waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount', 'waon_stock_unchecked_amount')
            ->first();
        // 4.生成入库记录
        $oure_res = OutinRecord::addition(
            $user_info,//用户信息
            $find_tror->tror_id,//原始单的关联id
            $find_tror->tror_number,//原始单的关联单号
            2,//原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
            0,//买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
            0,//选择的客户id,会员id/单位id
            $find_tror->tror_number,//调拨单号
            $find_tror->tror_in_ware_id,//入库仓库id
            0,//出库仓库id
            $waon_class_fine_quantity,//入库商品总量
            1,//类型1.入库单 2.出库单 3.调货单 4.旧货回收单 5.退换回收单 6.订单出库 7.部分入库 8.部分出库 9.发货单
            3,//操作类型：1锁定库存2出库3入库4调货5发货
            $amount->waon_stock_fine_amount,//良品总库存
            $amount->waon_lock_fine_amount,//良品锁定数量
            $amount->waon_stock_priority_amount,//优先总库存
            $amount->waon_lock_priority_amount,//优先锁定数量
            $amount->waon_stock_unchecked_amount,//待检测总库存
            2,//出入库类型：1出库，2入库
            $find_tror->tror_out_waon_class,//仓库类别
            $goo_id,//商品id
            $goo_quantity,//商品数量
            $goo_inventory //出库类型1良品2优先
        );
        $in_wfog_res = Dispatch::shipmentAddition(
            $user_info,//用户信息
            $find_tror->tror_in_ware_id,//入库仓库id
            0,//出库仓库id
            $wfog_wago_id,//仓库商品主键id
            $wfog_wafr_id,//仓位id
            $wfog_wafg_id,//仓位商品主键id
            3,//关联类型：4调拨入库
            $request['tror_id'],//原始单id
            $find_tror->tror_number,//原始单号
            $wfog_primary_id,//关联商品表主键id
            $wfog_goo_id,//商品id
            2,//出入库类型：1出库2入库
            $wfog_stock_amount,//商品数量
            $wfog_stock_type//库存类型1良品2优先
        );
        if ($wago_edit_res && $waon_priority_res && $all_fine_res && $all_priority_res && $wago_id && $out_res && $oure_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'入库成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'入库失败'];
        }
    }
}
