<?php
namespace App\Http\Models\Api\WarehouseManage;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Models\Api\OutinRecord;
use App\Http\Models\Api\WorkOrder;
use App\Http\Models\Api\ReceivableBill;

class Dispatch extends Model
{
    /**
     * [shipments 发货单发货]
     * @param  [type]  $user_info           [用户信息]
     * @param  [type]  $request             [提交数据]
     * @param  [type]  $goo_waon_class      [仓库类别]
     * @param  [type]  $goo_id              [商品id]
     * @param  [type]  $goods_data          [商品数据]
     * @param  [type]  $tror_out_waon_id    [调出仓库的类别id]
     * @return [type]                       [description]
     */
    public static function shipments(
        $user_info,
        $goods_data,
        $dis_data,
        $service_ware_id,
        $digo_data
    ) {
        $digo_lock_return = self::shipmentsLock(
            $user_info,
            $goods_data, //数组，仓库商品id=>仓库id
            $dis_data, //数组，仓库商品id=>商品id
            $digo_data
        );
        if ($digo_lock_return['code'] == 500) {
            return $digo_lock_return;
        }
        $neaten_goods_data = [];//仓库商品数据
        $freight_goods_data = [];//仓位商品数据
        $neaten_wago_id = [];//仓库商品id
        $freight_wafr_id = [];//仓位id
        $goo_all_fine = 0;//良品总数量
        $goo_all_priority = 0;//优先总数量
        foreach ($goods_data as $key => $value) {
            // 仓位id不为空的情况下
            if (!empty($value['digo_wafr_id'])) {
                // [仓位id][出库类型：良品/优先]，用于判断仓位是否有库存
                if (isset($freight_goods_data[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_inventory']])) {
                    $freight_goods_data[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_inventory']]['digo_goo_quantity'] += $value['digo_goo_quantity'];
                } else {
                    $freight_goods_data[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_inventory']] = (array)$value;
                }
            } else {
                // [仓库商品id][出库类型：良品/优先]，用于判断仓库是否有库存
                if (isset($neaten_goods_data[$value['digo_wago_id']][$value['digo_goo_inventory']])) {
                    $neaten_goods_data[$value['digo_wago_id']][$value['digo_goo_inventory']]['digo_goo_quantity'] += $value['digo_goo_quantity'];
                } else {
                    $neaten_goods_data[$value['digo_wago_id']][$value['digo_goo_inventory']] = (array)$value;
                }
            }
            $neaten_wago_id[] = $value['digo_wago_id'];//仓库商品id
            $freight_wafr_id[] = $value['digo_wafr_id'];//仓位商品id
            // digo_goo_inventory 库存扣除方式1.良品 2.优先
            if ($value['digo_goo_inventory'] == 1) {
                $goo_all_fine += $value['digo_goo_quantity'];
            } else {
                $goo_all_priority += $value['digo_goo_quantity'];
            }
            $digo_goo_id[] = $value['digo_goo_id'];
            $digo_wago_class[] = $value['digo_wago_class'];

            if (isset($wago_class_goods[$value['digo_wago_class']][$value['digo_goo_id']])) {
                $wago_class_goods[$value['digo_wago_class']][$value['digo_goo_id']]['digo_goo_quantity'] = $wago_class_goods[$value['digo_wago_class']][$value['digo_goo_id']]['digo_goo_quantity']+$value['digo_goo_quantity'];//仓库类型对应的商品，出入库记录
            } else {
                $wago_class_goods[$value['digo_wago_class']][$value['digo_goo_id']] = (array)$value;//仓库类型对应的商品，出入库记录
            }
        }
        $neaten_wago_id = array_unique($neaten_wago_id);//仓库商品id
        $freight_wafr_id = array_unique($freight_wafr_id);//仓位id
        if ($dis_data->dego_order_type == '1') {//类型1订单发货
            $find_ord_id = $dis_data->dego_wor_id;//订单id
            $find_order_number = $dis_data->dego_original_number;//订单编号

            $find_order_data = DB::table('order')
                ->where('ord_id', $dis_data->dego_wor_id)
                ->select('ord_type', 'ord_client_id')
                ->first();
            $oure_original_correlation_id = $dis_data->dego_wor_id;
            $oure_original_correlation_number = $dis_data->dego_original_number;
            $oure_original_correlation_type = 1;
            $oure_client_type = $find_order_data->ord_type;
            $oure_client_id = $find_order_data->ord_client_id;
        } elseif ($dis_data->dego_order_type == '2') {//2工单发货
            $find_order_data = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $dis_data->dego_wor_id)
                ->select('wor_type', 'wocl_client_id', 'wor_order_id', 'wor_order_number')
                ->first();
            $oure_original_correlation_id = $find_order_data->wor_order_id;
            $oure_original_correlation_number = $find_order_data->wor_order_number;
            $oure_client_type = $find_order_data->wor_type;
            $oure_client_id = $find_order_data->wocl_client_id;

            $find_ord_id = $find_order_data->wor_order_id;//订单id
            $find_order_number = $find_order_data->wor_order_number;//订单编号
        }

        // 更新订单商品表的商品成本，根据订单id,查询商品
        $find_orgo_data = DB::table('order_goods')
            ->where('orgo_ord_id', $find_ord_id)
            ->where('orgo_state', '!=', 2)
            ->select('orgo_id', 'orgo_state', 'orgo_ord_id', 'orgo_ware_id', 'orgo_waon_class', 'orgo_goo_id', 'orgo_goo_price', 'orgo_goo_quantity')
            ->get()->toArray();
        $cost_price = 0;//总成本金额
        $recycle_amount = 0;//回收商品总成本
        $now_date = date('Y-m-d H:i:s');//当前时间
        foreach ($find_orgo_data as $kkkk => $vvvv) {
            // 获取当前月份商品成本价
            if (in_array($vvvv->orgo_state, [1,5,8])) {
                $find_ense_end_price = DB::table('enters_sells_saves')
                    ->where('ense_goo_id', $vvvv->orgo_goo_id)
                    ->where('ense_goo_warehouse', $vvvv->orgo_ware_id)
                    ->where('ense_goo_waretype', $vvvv->orgo_waon_class)
                    ->where('ense_order_number', $find_order_number)
                    ->orderBy('ense_id', 'desc')
                    ->value('ense_end_price');
                $find_ense_end_price = sprintf('%.2f', $find_ense_end_price);
            } else {
                $find_ense_end_price = 0;
            }
            $cost_price += $find_ense_end_price * $vvvv->orgo_goo_quantity;//总成本金额

            if ($vvvv->orgo_state == 3) {
                $recycle_amount += $vvvv->orgo_goo_price * $vvvv->orgo_goo_quantity;//回收商品成本金额
            }
            // 修改订单商品成本
            $orgo_edit_data['orgo_goo_cost'] = $find_ense_end_price * 100;
            $orgo_edit_data['orgo_update_time'] = $now_date;
            // 修改订单表的更新时间
            $orgo_edit_res = DB::table('order_goods')
                ->where('orgo_id', $vvvv->orgo_id)
                ->where('orgo_ord_id', $find_ord_id)
                ->where('orgo_order_number', $find_order_number)
                ->update($orgo_edit_data);
            unset($orgo_edit_data);
        }
        $ord_edit_data['ord_update_time'] = $now_date;
        $ord_edit_res = DB::table('order')->where('ord_id', $find_ord_id)->update($ord_edit_data);
        
        if (!empty($neaten_goods_data)) {//仓库库存数量调整
            // 2.选中的固定仓减锁定库存
            $warehouse_goods = DB::table('warehouse_goods')
                ->where('wago_ware_id', $dis_data->dego_out_ware_id)
                ->whereIn('wago_id', $neaten_wago_id)
                ->get(['wago_id', 'wago_class', 'wago_goo_id', 'wago_lock_quantity', 'wago_priority_lock_quantity'])
                ->toArray();
            $warehouse_goods = array_column($warehouse_goods, null, 'wago_id');
            foreach ($neaten_goods_data as $wago_id => $wago_value) {
                foreach ($wago_value as $goo_inventory => $goo_value) {
                    if (isset($warehouse_goods[$wago_id])) {
                        // 良品库存
                        if ($goo_inventory == 1) {
                            $surplus_quantity = $warehouse_goods[$wago_id]->wago_lock_quantity - $goo_value['digo_goo_quantity'];
                            if ($surplus_quantity < 0) {
                                DB::rollBack();
                                return ['code'=>500, 'msg'=>'error', 'data'=>'商品库存锁定数量不足！'];
                            }
                            $wago_edit_res = DB::table('warehouse_goods')
                                ->where('wago_id', $wago_id)
                                ->update(['wago_lock_quantity'=>$surplus_quantity]);
                            $waon_stock_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_lock_fine_amount', $goo_value['digo_goo_quantity']);
                            $waon_all_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_all_amount', $goo_value['digo_goo_quantity']);
                            if (!$wago_edit_res || !$waon_stock_res || !$waon_all_res) {
                                DB::rollBack();
                                return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败1！'];
                            }
                        } else {
                            // 优先库存
                            $surplus_quantity = $warehouse_goods[$wago_id]->wago_priority_lock_quantity - $goo_value['digo_goo_quantity'];
                            if ($surplus_quantity < 0) {
                                DB::rollBack();
                                return ['code'=>500, 'msg'=>'error', 'data'=>'商品库存锁定数量不足！'];
                            }
                            // 更改商品库存数量
                            $wago_edit_res = DB::table('warehouse_goods')
                                ->where('wago_id', $wago_id)
                                ->update(['wago_priority_lock_quantity'=>$surplus_quantity]);
                            // 更改库存总数量
                            $waon_stock_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_lock_priority_amount', $goo_value['digo_goo_quantity']);
                            $waon_all_res = DB::table('warehouse_onhand')
                                ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                ->where('waon_class', $goo_value['digo_wago_class'])
                                ->decrement('waon_all_amount', $goo_value['digo_goo_quantity']);
                            if (!$wago_edit_res || !$waon_stock_res || !$waon_all_res) {
                                DB::rollBack();
                                return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败2！'];
                            }
                        }
                    } else {
                        DB::rollBack();
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓库商品锁定数量不足！'];
                    }
                }
            }
    
            // 工单生成的发货单，技师库库存增加
            if ($dis_data->dego_order_type == 2) {
                // 技师库商品表中已经存在的商品 直接增加数量
                $move_wago_goods = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $service_ware_id)
                    ->whereIn('wago_class', $digo_wago_class)
                    ->whereIn('wago_goo_id', $digo_goo_id)
                    ->get(['wago_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number'])
                    ->toArray();
                if (empty($move_wago_goods)) {
                    $move_wago_res = true;
                    $add_wago_class_goods = $neaten_goods_data;
                } else {
                    // 技师库中已经存在的商品数据，
                    foreach ($move_wago_goods as $key => $value) {
                        $move_warehouse_class_goods[$value->wago_class][$value->wago_goo_id] = (array)$value;
                    }
                    $goo_all_amounts = 0;
                    foreach ($neaten_goods_data as $wago_id => $wago_value) {
                        foreach ($wago_value as $goo_inventory => $goo_value) {
                            if (isset($move_warehouse_class_goods[$goo_value['digo_wago_class']][$goo_value['digo_goo_id']]['wago_id'])) {
                                // 良品库存
                                if ($goo_inventory == 1) {
                                    $surplus_quantity = $move_warehouse_class_goods[$goo_value['digo_wago_class']][$goo_value['digo_goo_id']]['wago_stock_number'] + $goo_value['digo_goo_quantity'];
                                    $wago_edit_res = DB::table('warehouse_goods')
                                        ->where('wago_id', $move_warehouse_class_goods[$goo_value['digo_wago_class']][$goo_value['digo_goo_id']]['wago_id'])
                                        ->update(['wago_stock_number'=>$surplus_quantity]);
                                    $waon_edit_res = DB::table('warehouse_onhand')
                                        ->where('waon_ware_id', $service_ware_id)
                                        ->where('waon_class', $goo_value['digo_wago_class'])
                                        ->increment('waon_stock_fine_amount', $goo_value['digo_goo_quantity']);
                                    DB::table('warehouse_onhand')
                                        ->where('waon_ware_id', $service_ware_id)
                                        ->where('waon_class', $goo_value['digo_wago_class'])
                                        ->increment('waon_all_amount', $goo_value['digo_goo_quantity']);
                                    if (!$wago_edit_res || !$waon_edit_res) {
                                        DB::rollBack();
                                        return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败3！'];
                                    }
                                } else {
                                    // 优先库存
                                    $surplus_quantity = $move_warehouse_class_goods[$goo_value['digo_wago_class']][$goo_value['digo_goo_id']]['wago_priority_stock_number'] + $goo_value['digo_goo_quantity'];
                                    // 更改商品库存数量
                                    $wago_edit_res = DB::table('warehouse_goods')
                                        ->where('wago_id', $move_warehouse_class_goods[$goo_value['digo_wago_class']][$goo_value['digo_goo_id']]['wago_id'])
                                        ->update(['wago_priority_stock_number'=>$surplus_quantity]);
                                    // 更改库存总数量
                                    $waon_edit_res = DB::table('warehouse_onhand')
                                        ->where('waon_ware_id', $service_ware_id)
                                        ->where('waon_class', $goo_value['digo_wago_class'])
                                        ->increment('waon_stock_priority_amount', $goo_value['digo_goo_quantity']);
                                    DB::table('warehouse_onhand')
                                        ->where('waon_ware_id', $service_ware_id)
                                        ->where('waon_class', $goo_value['digo_wago_class'])
                                        ->increment('waon_all_amount', $goo_value['digo_goo_quantity']);
                                    if (!$wago_edit_res || !$waon_edit_res) {
                                        DB::rollBack();
                                        return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败4！'];
                                    }
                                }
                            } else {
                                // 技师库内没有的商品
                                $add_wago_class_goods[$goo_value['digo_wago_id']][$goo_value['digo_goo_inventory']] = $goo_value;
                            }
                        }
                    }
                }
    
                // 技师库商品表中不存在的商品 新增
                if (empty($add_wago_class_goods)) {
                    $move_add_goods = true;
                } else {
                    $num = 0;
                    $add_goo_amount = 0;
                    foreach ($add_wago_class_goods as $wago_id => $wago_value) {
                        foreach ($wago_value as $goo_inventory => $goo_value) {
                            $ware_add_data[$num]['wago_ware_id'] = $service_ware_id;
                            $ware_add_data[$num]['wago_class'] = $goo_value['digo_wago_class'];
                            $ware_add_data[$num]['wago_goo_id'] = $goo_value['digo_goo_id'];
                            // 良品库存
                            if ($goo_inventory == 1) {
                                $ware_add_data[$num]['wago_stock_number'] = $goo_value['digo_goo_quantity'];
                                $waon_edit_res = DB::table('warehouse_onhand')
                                    ->where('waon_ware_id', $service_ware_id)
                                    ->where('waon_class', $goo_value['digo_wago_class'])
                                    ->increment('waon_stock_fine_amount', $goo_value['digo_goo_quantity']);
                                $waon_edit_res2 = DB::table('warehouse_onhand')
                                    ->where('waon_ware_id', $service_ware_id)
                                    ->where('waon_class', $goo_value['digo_wago_class'])
                                    ->increment('waon_all_amount', $goo_value['digo_goo_quantity']);
                                if (!$waon_edit_res || !$waon_edit_res2) {
                                    DB::rollBack();
                                    return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败5！'];
                                }
                            } else {
                                // 优先库存
                                $ware_add_data[$num]['wago_priority_stock_number'] = $goo_value['digo_goo_quantity'];
                                // 更改库存总数量
                                $waon_edit_res = DB::table('warehouse_onhand')
                                    ->where('waon_ware_id', $service_ware_id)
                                    ->where('waon_class', $goo_value['digo_wago_class'])
                                    ->increment('waon_stock_priority_amount', $goo_value['digo_goo_quantity']);
                                $waon_edit_res2 = DB::table('warehouse_onhand')
                                    ->where('waon_ware_id', $service_ware_id)
                                    ->where('waon_class', $goo_value['digo_wago_class'])
                                    ->increment('waon_all_amount', $goo_value['digo_goo_quantity']);
                                if (!$waon_edit_res || !$waon_edit_res2) {
                                    DB::rollBack();
                                    return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败6！'];
                                }
                            }
                            $num++;
                        }
                    }
                    $move_add_goods = DB::table('warehouse_goods')->insert($ware_add_data);
                }
                $update_state = true;
                $ord_bill = true;
            }
        }
        if (!empty($freight_goods_data)) {//仓位库存数量调整
            // 2.选中的固定仓减锁定库存
            $warehouse_freight_goods = DB::table('warehouse_freight_goods')
                ->where('wafg_ware_id', $dis_data->dego_out_ware_id)
                ->whereIn('wafg_wafr_id', $freight_wafr_id)
                ->whereIn('wafg_wago_id', $neaten_wago_id)
                ->select('wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_class', 'wafg_goo_id', 'wafg_lock_quantity', 'wafg_priority_lock_quantity')
                ->get()->toArray();
            foreach ($warehouse_freight_goods as $key => $value) {
                $warehouse_class_goods[$value->wafg_wafr_id][$value->wafg_wago_id][$value->wafg_goo_id] = (array)$value;
            }
            foreach ($freight_goods_data as $wafg_id => $wafg_value) {
                foreach ($wafg_value as $wago_id => $wago_value) {
                    foreach ($wago_value as $goo_inventory => $goo_value) {
                        if (isset($warehouse_class_goods[$goo_value['digo_wafr_id']][$goo_value['digo_wago_id']][$goo_value['digo_goo_id']])) {
                            if ($goo_inventory == 1) {// 良品库存
                                $surplus_quantity = $warehouse_class_goods[$goo_value['digo_wafr_id']][$goo_value['digo_wago_id']][$goo_value['digo_goo_id']]['wafg_lock_quantity'] - $goo_value['digo_goo_quantity'];
                                // 仓位商品表锁定库存调整
                                $wafg_edit_res = DB::table('warehouse_freight_goods')
                                    ->where('wafg_id', $warehouse_class_goods[$goo_value['digo_wafr_id']][$goo_value['digo_wago_id']][$goo_value['digo_goo_id']]['wafg_id'])
                                    ->update(['wafg_lock_quantity'=>$surplus_quantity]);
                                // 仓库商品表仓位锁定库存调整
                                $wago_freight_lock_res = DB::table('warehouse_goods')
                                    ->where('wago_id', $goo_value['digo_wago_id'])
                                    ->where('wago_ware_id', $dis_data->dego_out_ware_id)
                                    ->where('wago_class', $goo_value['digo_wago_class'])
                                    ->decrement('wago_freight_lock_quantity', $goo_value['digo_goo_quantity']);
                                // 仓库良品锁定库存调整
                                $waon_stock_res = DB::table('warehouse_onhand')
                                    ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                    ->where('waon_class', $goo_value['digo_wago_class'])
                                    ->decrement('waon_lock_fine_amount', $goo_value['digo_goo_quantity']);
                                // 仓库总库存数量调整
                                $waon_all_res = DB::table('warehouse_onhand')
                                    ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                    ->where('waon_class', $goo_value['digo_wago_class'])
                                    ->decrement('waon_all_amount', $goo_value['digo_goo_quantity']);
                                // 仓位良品锁定库存调整
                                $wafr_lock_res = DB::table('warehouse_freight')
                                    ->where('wafr_id', $warehouse_class_goods[$goo_value['digo_wafr_id']][$goo_value['digo_wago_id']][$goo_value['digo_goo_id']]['wafg_wafr_id'])
                                    ->where('wafr_ware_id', $dis_data->dego_out_ware_id)
                                    ->decrement('wafr_lock_quantity', $goo_value['digo_goo_quantity']);
                                if (!$wafg_edit_res || !$wago_freight_lock_res || !$waon_stock_res || !$waon_all_res || !$wafr_lock_res) {
                                    DB::rollBack();
                                    return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败7！'];
                                }
                            } else {
                                // 优先库存
                                $surplus_quantity = $warehouse_class_goods[$goo_value['digo_wafr_id']][$goo_value['digo_wago_id']][$goo_value['digo_goo_id']]['wafg_priority_lock_quantity'] - $goo_value['digo_goo_quantity'];
                                // 更改仓位商品表商品库存数量
                                $wafg_edit_res = DB::table('warehouse_freight_goods')
                                    ->where('wafg_id', $warehouse_class_goods[$goo_value['digo_wafr_id']][$goo_value['digo_wago_id']][$goo_value['digo_goo_id']]['wafg_id'])
                                    ->update(['wafg_priority_lock_quantity'=>$surplus_quantity]);
                                // 仓库商品表仓位优先锁定库存调整
                                $wago_freight_lock_res = DB::table('warehouse_goods')
                                    ->where('wago_id', $goo_value['digo_wago_id'])
                                    ->where('wago_ware_id', $dis_data->dego_out_ware_id)
                                    ->where('wago_class', $goo_value['digo_wago_class'])
                                    ->decrement('wago_freight_priority_lock_quantity', $goo_value['digo_goo_quantity']);
                                // 仓库优先锁定库存调整
                                $waon_stock_res = DB::table('warehouse_onhand')
                                    ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                    ->where('waon_class', $goo_value['digo_wago_class'])
                                    ->decrement('waon_lock_priority_amount', $goo_value['digo_goo_quantity']);
                                // 仓库总库存数量调整
                                $waon_all_res = DB::table('warehouse_onhand')
                                    ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                                    ->where('waon_class', $goo_value['digo_wago_class'])
                                    ->decrement('waon_all_amount', $goo_value['digo_goo_quantity']);
                                // 仓位良品锁定库存调整
                                $wafr_lock_res = DB::table('warehouse_freight')
                                    ->where('wafr_id', $warehouse_class_goods[$goo_value['digo_wafr_id']][$goo_value['digo_wago_id']][$goo_value['digo_goo_id']]['wafg_wafr_id'])
                                    ->where('wafr_ware_id', $dis_data->dego_out_ware_id)
                                    ->decrement('wafg_priority_lock_quantity', $goo_value['digo_goo_quantity']);
                                if (!$wafg_edit_res || !$wago_freight_lock_res || !$waon_stock_res || !$waon_all_res || !$wafr_lock_res) {
                                    DB::rollBack();
                                    return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败8！'];
                                }
                            }
                        } else {
                            DB::rollBack();
                            return ['code'=>500, 'msg'=>'error', 'data'=>'仓位商品锁定数量不足1！'];
                        }
                    }
                }
            }
            // 工单生成的发货单，技师库库存增加
            if ($dis_data->dego_order_type == 2) {
                // 技师库商品表中已经存在的商品 直接增加数量
                $move_wago_goods = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $service_ware_id)
                    ->whereIn('wago_class', $digo_wago_class)
                    ->whereIn('wago_goo_id', $digo_goo_id)
                    ->select('wago_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number')
                    ->get()->toArray();
                if (empty($move_wago_goods)) {
                    $move_wago_res = true;
                    $add_wago_class_goods = $freight_goods_data;
                } else {
                    // 技师库中已经存在的商品数据，
                    foreach ($move_wago_goods as $key => $value) {
                        $move_warehouse_class_goods[$value->wago_class][$value->wago_goo_id] = (array)$value;
                    }
                    foreach ($freight_goods_data as $wago_id => $wago_value) {
                        foreach ($wafg_value as $wago_id => $wago_value) {
                            foreach ($wago_value as $goo_inventory => $goo_value) {
                                if (isset($move_warehouse_class_goods[$goo_value['digo_wago_class']][$goo_value['digo_goo_id']]['wago_id'])) {
                                    // 良品库存
                                    if ($goo_inventory == 1) {
                                        $wago_edit_res = DB::table('warehouse_goods')
                                            ->where('wago_id', $move_warehouse_class_goods[$goo_value['digo_wago_class']][$goo_value['digo_goo_id']]['wago_id'])
                                            ->increment('wago_stock_number', $goo_value['digo_goo_quantity']);
                                        // 技师库良品库存数量调整
                                        $waon_stock_edit_res = DB::table('warehouse_onhand')
                                            ->where('waon_ware_id', $service_ware_id)
                                            ->where('waon_class', $goo_value['digo_wago_class'])
                                            ->increment('waon_stock_fine_amount', $goo_value['digo_goo_quantity']);
                                        // 技师库总库存数量调整
                                        $waon_edit_res = DB::table('warehouse_onhand')
                                            ->where('waon_ware_id', $service_ware_id)
                                            ->where('waon_class', $goo_value['digo_wago_class'])
                                            ->increment('waon_all_amount', $goo_value['digo_goo_quantity']);
                                        if (!$wago_edit_res || !$waon_stock_edit_res || !$waon_edit_res) {
                                            DB::rollBack();
                                            return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败9！'];
                                        }
                                    } else {
                                        // 优先库存
                                        // 更改商品库存数量
                                        $wago_edit_res = DB::table('warehouse_goods')
                                            ->where('wago_id', $move_warehouse_class_goods[$goo_value['digo_wago_class']][$goo_value['digo_goo_id']]['wago_id'])
                                            ->increment('wago_priority_stock_number', $goo_value['digo_goo_quantity']);
                                        // 技师库优先库存数量调整
                                        $waon_priority_edit_res = DB::table('warehouse_onhand')
                                            ->where('waon_ware_id', $service_ware_id)
                                            ->where('waon_class', $goo_value['digo_wago_class'])
                                            ->increment('waon_stock_priority_amount', $goo_value['digo_goo_quantity']);
                                        // 技师库总库存数量调整
                                        $waon_edit_res = DB::table('warehouse_onhand')
                                            ->where('waon_ware_id', $service_ware_id)
                                            ->where('waon_class', $goo_value['digo_wago_class'])
                                            ->increment('waon_all_amount', $goo_value['digo_goo_quantity']);
                                        if (!$wago_edit_res || !$waon_priority_edit_res || !$waon_edit_res) {
                                            DB::rollBack();
                                            return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败10！'];
                                        }
                                    }
                                } else {
                                    // 技师库内没有的商品
                                    $add_wago_class_goods[$goo_value['digo_wago_id']][$goo_value['digo_goo_inventory']] = $goo_value;
                                }
                            }
                        }
                    }
                }
                // 技师库商品表中不存在的商品 新增
                if (empty($add_wago_class_goods)) {
                    $move_add_goods = true;
                } else {
                    $num = 0;
                    $add_goo_amount = 0;
                    foreach ($add_wago_class_goods as $wafg_id => $wago_value) {
                        foreach ($wafg_value as $wago_id => $wago_value) {
                            foreach ($wago_value as $goo_inventory => $goo_value) {
                                // 仓库商品表添加数据
                                $ware_add_datas['wago_ware_id'] = $service_ware_id;
                                $ware_add_datas['wago_class'] = $goo_value['digo_wago_class'];
                                $ware_add_datas['wago_goo_id'] = $goo_value['digo_goo_id'];
                                $find_wago_id = DB::table('warehouse_goods')
                                    ->where('wago_ware_id', $service_ware_id)
                                    ->where('wago_class', $goo_value['digo_wago_class'])
                                    ->where('wago_goo_id', $goo_value['digo_goo_id'])
                                    ->value('wago_id');
                                if (!empty($find_wago_id)) {
                                    $move_add_goods = $find_wago_id;
                                } else {
                                    if (isset($goo_value['digo_goo_id'])) {
                                        $goo_value['digo_goo_quantity'] += $goo_value['digo_goo_quantity'];
                                    } else {
                                        $goo_value['digo_goo_quantity'] = $goo_value['digo_goo_quantity'];
                                    }
                                    if ($goo_inventory == 1) {// 良品库存
                                        $ware_add_datas['wago_stock_number'] = $goo_value['digo_goo_quantity'];
                                        $waon_edit_res = DB::table('warehouse_onhand')
                                            ->where('waon_ware_id', $service_ware_id)
                                            ->where('waon_class', $goo_value['digo_wago_class'])
                                            ->increment('waon_stock_fine_amount', $goo_value['digo_goo_quantity']);
                                        $waon_edit_res2 = DB::table('warehouse_onhand')
                                            ->where('waon_ware_id', $service_ware_id)
                                            ->where('waon_class', $goo_value['digo_wago_class'])
                                            ->increment('waon_all_amount', $goo_value['digo_goo_quantity']);
                                        if (!$waon_edit_res || !$waon_edit_res2) {
                                            DB::rollBack();
                                            return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败11！'];
                                        }
                                    } else {// 优先库存
                                        $ware_add_datas['wago_priority_stock_number'] = $goo_value['digo_goo_quantity'];
                                        // 更改库存总数量
                                        $waon_edit_res = DB::table('warehouse_onhand')
                                            ->where('waon_ware_id', $service_ware_id)
                                            ->where('waon_class', $goo_value['digo_wago_class'])
                                            ->increment('waon_stock_priority_amount', $goo_value['digo_goo_quantity']);
                                        $waon_edit_res2 = DB::table('warehouse_onhand')
                                            ->where('waon_ware_id', $service_ware_id)
                                            ->where('waon_class', $goo_value['digo_wago_class'])
                                            ->increment('waon_all_amount', $goo_value['digo_goo_quantity']);
                                        if (!$waon_edit_res || !$waon_edit_res2) {
                                            DB::rollBack();
                                            return ['code'=> 500, 'msg'=>'error', 'data'=>'发货失败12！'];
                                        }
                                    }
                                    $move_add_goods = DB::table('warehouse_goods')->insertGetId($ware_add_datas);
                                }
                                $num++;
                            }
                        }
                    }
                }
                $update_state = true;
                $ord_bill = true;
            }
        }
        // 遍历仓库类型数据，处理固定仓库对应仓库类型的出入库记录
        foreach ($wago_class_goods as $waon_class_key => $class_goods_data) {
            // 查询仓库类别的进销存计算方式
            $goo_all_amount = 0;
            foreach ($class_goods_data as $goo_id_key => $value) {
                // 出入库记录需要的的商品数组
                $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['digo_goo_quantity'];//出入库商品数量
                $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_inventory'] = $value['digo_goo_inventory'];//出入库商品类型，类型1良品2优先
                $goo_all_amount += $value['digo_goo_quantity'];

                // 出入库记录需要
                $oure_goods_id[$goo_id_key] = $value['digo_goo_id'];//出入库商品id
                $oure_goods_quantity[$goo_id_key] = $value['digo_goo_quantity'];//出入库商品数量
                $oure_goods_inventory[$goo_id_key] = $value['digo_goo_inventory'];//出入库商品类型，类型1良品2优先
                $oure_wafr_id[$goo_id_key] = $value['digo_wafr_id'];//仓位id
                $digo_wafg_id = DB::table('warehouse_freight_goods')
                    ->where('wafg_wafr_id', $value['digo_wafr_id'])
                    ->where('wafg_wago_id', $value['digo_wago_id'])
                    ->where('wafg_ware_id', $dis_data->dego_out_ware_id)
                    ->value('wafg_id');
                $oure_wafg_id[$goo_id_key] = $digo_wafg_id;//仓位商品id
                $oure_digo_id[$goo_id_key] = $value['digo_id'];//发货商品主键id
                $oure_wago_id[$goo_id_key] = $value['digo_wago_id'];//仓库商品主键id
            }

            $wfog_res = self::shipmentAddition(
                $user_info,//用户信息
                0,//入库仓库id
                $dis_data->dego_out_ware_id,//出库仓库id
                $oure_wago_id,//仓库商品主键id
                $oure_wafr_id,//仓位id
                $oure_wafg_id,//仓位商品主键id
                8,//关联类型：8发货
                $oure_digo_id,//关联商品表主键id
                $oure_goods_id,//商品id
                1,//出入库类型：1出库2入库
                $oure_goods_quantity,//商品数量
                $oure_goods_inventory//库存类型1良品2优先
            );

            $find_ware = DB::table('warehouse_onhand')
                ->where('waon_ware_id', '=', $dis_data->dego_out_ware_id)
                ->where('waon_class', $waon_class_key)
                ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                ->first();
            $oure_goods_data=$oure_goods_dataarray[$waon_class_key];
            $oure_class_goo_id = array_keys($oure_goods_data);
            $oure_res = OutinRecord::addition(
                $user_info,//用户信息
                $oure_original_correlation_id,//原始单的关联id
                $oure_original_correlation_number,//原始单的关联单号
                1,//原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                $oure_client_type,//买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                $oure_client_id,//选择的客户id,会员id/单位id
                $dis_data->dego_number,//原始单号，旧货回收单单号
                0,//入库仓库id
                $dis_data->dego_out_ware_id,//出库仓库id
                $goo_all_amount,//出库的商品总数量
                9,//类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
                2,//操作类型：1锁定库存2出库3入库4调货5发货
                $find_ware->waon_stock_fine_amount,//良品总库存
                $find_ware->waon_lock_fine_amount,//良品锁定数量
                $find_ware->waon_stock_priority_amount,//优先总库存
                $find_ware->waon_lock_priority_amount,//优先锁定数量
                $find_ware->waon_stock_unchecked_amount,//待检测总库存
                1, //出入库类型：1出库，2入库
                $waon_class_key,//仓库类别
                $oure_goods_id, //商品id
                $oure_goods_quantity, //商品数量
                $oure_goods_inventory, //出库类型1良品2优先
                $oure_wafr_id, //仓位id
                $oure_class_goo_id //仓库类别下的商品id
            );
        }
        // 工单生成的发货单，技师库库存增加
        if ($dis_data->dego_order_type == 2) {
            // 遍历仓库类型数据，处理固定仓库对应仓库类型的出入库记录
            foreach ($wago_class_goods as $waon_class_key => $class_goods_data) {
                // 查询仓库类别的进销存计算方式
                $goo_all_amount = 0;
                foreach ($class_goods_data as $goo_id_key => $value) {
                    // 出入库记录需要的的商品数组
                    $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_quantity'] = $value['digo_goo_quantity'];//出入库商品数量
                    $oure_goods_dataarray[$waon_class_key][$goo_id_key]['goo_inventory'] = $value['digo_goo_inventory'];//出入库商品类型，类型1良品2优先
                    $goo_all_amount += $value['digo_goo_quantity'];

                    // 出入库记录需要
                    $oure_goods_id[$goo_id_key] = $value['digo_goo_id'];//出入库商品id
                    $oure_goods_quantity[$goo_id_key] = $value['digo_goo_quantity'];//出入库商品数量
                    $oure_goods_inventory[$goo_id_key] = $value['digo_goo_inventory'];//出入库商品类型，类型1良品2优先，页面没有用到这个，暂定1

                    $oure_wafr_id[$goo_id_key] = $value['digo_wafr_id'];//仓位id
                    $digo_wafg_id = DB::table('warehouse_freight_goods')
                        ->where('wafg_wafr_id', $value['digo_wafr_id'])
                        ->where('wafg_wago_id', $value['digo_wago_id'])
                        ->where('wafg_ware_id', $dis_data->dego_out_ware_id)
                        ->value('wafg_id');
                    $oure_wafg_id[$goo_id_key] = $digo_wafg_id;//仓位商品id
                    $oure_digo_id[$goo_id_key] = $value['digo_id'];//发货商品主键id
                    $oure_wago_id[$goo_id_key] = $value['digo_wago_id'];//仓库商品主键id
                }

                $wfog_res = self::shipmentAddition(
                    $user_info,//用户信息
                    $service_ware_id,//入库仓库id
                    0,//出库仓库id
                    $oure_wago_id,//仓库商品主键id
                    $oure_wafr_id,//仓位id
                    $oure_wafg_id,//仓位商品主键id
                    8,//关联类型：8发货
                    $oure_digo_id,//关联商品表主键id
                    $oure_goods_id,//商品id
                    2,//出入库类型：1出库2入库
                    $oure_goods_quantity,//商品数量
                    $oure_goods_inventory//库存类型1良品2优先
                );

                $find_ware = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', '=', $service_ware_id)
                    ->where('waon_class', $waon_class_key)
                    ->select('waon_stock_fine_amount', 'waon_lock_fine_amount', 'waon_stock_unchecked_amount', 'waon_stock_priority_amount', 'waon_lock_priority_amount')
                    ->first();
                $oure_goods_data=$oure_goods_dataarray[$waon_class_key];
                $oure_class_goo_id = array_keys($oure_goods_data);
                $oure_res = OutinRecord::addition(
                    $user_info,//用户信息
                    $oure_original_correlation_id,//原始单的关联id
                    $oure_original_correlation_number,//原始单的关联单号
                    1,//原始单的关联类型1.订单2.调拨单3.采购单4.销售单5.旧货回收6.退货入库7.售后
                    $oure_client_type,//买家类型：1.会员零售2.客户单位3.速电派单4.第三方派单
                    $oure_client_id,//选择的客户id,会员id/单位id
                    $dis_data->dego_number,//原始单号，旧货回收单单号
                    $service_ware_id,//入库仓库id
                    0,//出库仓库id
                    $goo_all_amount,//出库的商品总数量
                    9,//类型 5.退换回收单 9发货单 11换货出库12换货入库13退货入库14退货出库
                    3,//操作类型：1锁定库存2出库3入库4调货5发货
                    $find_ware->waon_stock_fine_amount,//良品总库存
                    $find_ware->waon_lock_fine_amount,//良品锁定数量
                    $find_ware->waon_stock_priority_amount,//优先总库存
                    $find_ware->waon_lock_priority_amount,//优先锁定数量
                    $find_ware->waon_stock_unchecked_amount,//待检测总库存
                    2, //出入库类型：1出库，2入库
                    $waon_class_key,//仓库类别
                    $oure_goods_id, //商品id
                    $oure_goods_quantity, //商品数量
                    $oure_goods_inventory, //出库类型1良品2优先
                    $oure_class_goo_id //仓库类别下的商品id
                );
            }
            $update_state = true;
            $ord_bill = true;
        } elseif ($dis_data->dego_order_type == 1) {
            // 订单发货单 将订单状态改为完成
            $update_date['ord_wor_state'] = 4;
            $update_date['ord_update_time'] = date('Y-m-d H:i:s');
            $update_state = DB::table('order')
                    ->where('ord_id', $dis_data->dego_wor_id)
                    ->update($update_date);
            $move_add_goods = true;

            $order_client = DB::table('order_client')
                ->where('orcl_ord_id', $dis_data->dego_wor_id)
                ->first(['orcl_channel_unit','orcl_client_id','orcl_acc_subject_id','orcl_collect_state', 'orcl_name']);
            $ord_data = DB::table('order')
                ->where('ord_id', $dis_data->dego_wor_id)
                ->first(['ord_type', 'ord_actual_price', 'ord_remark', 'ord_order_number', 'ord_create_time', 'ord_service_type']);
            $ord_plus_minus = 1;
            if ($ord_data->ord_actual_price < 0) {
                $ord_plus_minus = 2;
            }
            // 生成订单应收账单
            $ord_bill = ReceivableBill::create(
                $user_info, //用户信息
                3, //类型：1.销售订单 2.预收款 3.订单账单 4.工单账单 5.采购账单 6.销售账单
                0, //应收账款id
                $dis_data->dego_wor_id, //原始id(订单id)
                $dis_data->dego_original_number, //应收账款单号/原始号(订单编号)
                $ord_data->ord_type, //客户类型：1.门店零售 2.来往单位
                $order_client->orcl_client_id, //会员id/来往单位id
                $order_client->orcl_channel_unit, //来往单位名称
                abs($ord_data->ord_actual_price), //结算金额
                date('Y-m-d H:i:s'), //结款时间
                $order_client->orcl_acc_subject_id, //会计科目id
                abs($ord_data->ord_actual_price), //实际金额
                0, //抹零金额
                1,  //状态：1.未核销 2.已核销
                1,  //应收账单id是否是自己 1.不是 2.是
                $ord_data->ord_remark,  //备注
                0, //已收金额
                '',//截止时间
                $ord_plus_minus,//金额正负1正2负值
                1,//显示类型：1订单收款 10订单退款
                2,//是否合并代收：1是2否
                $ord_data->ord_create_time,
                $order_client->orcl_collect_state //技师是否收钱：0未选择1是2否
            );

            // 判断门店是否使用用友u8财务系统
            if (config('apiu8cloud.CODE_STARTS') && in_array($user_info->adm_shop_id, config('apiu8cloud.u8cloud_shop'))) {
                // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
                $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
                // 生成凭证单据
                if ($ord_data->ord_type == '1') {
                    $order_client->orcl_channel_unit = $order_client->orcl_name;
                } elseif ($ord_data->ord_type == '2') {
                    $order_client->orcl_channel_unit = $order_client->orcl_channel_unit;
                } elseif ($ord_data->ord_type == '3') {
                    $order_client->orcl_channel_unit = $order_client->orcl_channel_unit;
                }
                $vore_data = WorkOrder::voucherReceipts($user_info, $shop_id, 1, 0, '', $dis_data->dego_wor_id, $ord_data->ord_order_number, $ord_data->ord_actual_price, $recycle_amount, 0, $cost_price, $ord_data->ord_service_type, $ord_data->ord_type, $order_client->orcl_client_id, $order_client->orcl_channel_unit);
                if (!$vore_data) {
                    DB::rollBack();
                    return ['code'=>500,'msg'=>'error','data'=>'凭证单生成失败'];
                }
            }
        }
        if ($update_state && $ord_bill && $move_add_goods) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'发货成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'发货失败13'];
        }
    }

    /**
     * [shipmentsLock 发货单更换仓位锁定库存]
     * @param  [type]  $user_info     [用户信息]
     * @param  [type]  $goods_data    [提交的商品数据]
     * @param  [type]  $dis_data      [发货单数据]
     * @param  [type]  $digo_data     [发货单商品表数据]
     * @return [type]                 [description]
     */
    public static function shipmentsLock(
        $user_info,
        $goods_data,
        $dis_data,
        $digo_data
    ) {
        $digo_data = json_decode(json_encode($digo_data), true);
        foreach ($digo_data as $key => $value) {
            $digo_wafr_id[] = $value['wfgl_wafr_id'];
        }
        foreach ($goods_data as $key => $value) {
            $now_wafr_id[] = $value['digo_wafr_id'];
        }
        if (!array_diff($digo_wafr_id, $now_wafr_id)) {
            // 两个数组互相不存在差集，那这两个数组的值是相同的
            return ['code'=>200, 'msg'=>'success', 'return_data'=>[]];
        }
        $return_data = [];
        foreach ($digo_data as $key => $value) {//原来的锁定数量还回去
            if (!empty($value['wfgl_wafr_id'])) {//仓位
                // 查询固定仓仓位库存商品信息
                $find_warehouse_goods = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $value['wfgl_wafg_id'])
                    ->where('wafg_wafr_id', $value['wfgl_wafr_id'])
                    ->where('wafg_wago_id', $value['wfgl_wago_id'])
                    ->where('wafg_ware_id', $dis_data->dego_out_ware_id)
                    ->select('wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_class', 'wafg_goo_id', 'wafg_stock_number', 'wafg_lock_quantity', 'wafg_priority_stock_number', 'wafg_priority_lock_quantity')
                    ->first();
                // 查询仓库的商品信息
                $find_wago_data = DB::table('warehouse_goods')
                    ->where('wago_id', $value['wfgl_wago_id'])
                    ->where('wago_ware_id', $value['wfgl_ware_id'])
                    ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity')
                    ->first();
                // 良品库存
                if ($value['wfgl_lock_type'] == 1) {
                    // 仓位商品锁定数量减少，正常库存数量增加
                    $surplus_quantity = $find_warehouse_goods->wafg_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($surplus_quantity < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓位商品锁定库存数量不足1'];
                    }
                    // 仓位商品锁定数量减少，正常库存数量增加
                    $lock_wafg_edit['wafg_lock_quantity'] = $surplus_quantity;
                    $lock_wafg_edit['wafg_stock_number'] = $find_warehouse_goods->wafg_stock_number + $value['wfgl_lock_quantity'];
    
                    // 仓库商品锁定库存数量减少,正常库存数量增加
                    $edit_wago_data['wago_lock_quantity'] = $find_wago_data->wago_lock_quantity - $value['wfgl_lock_quantity'];//良品锁定数量(仓库+仓位)
                    $edit_wago_data['wago_stock_number'] = $find_wago_data->wago_stock_number + $value['wfgl_lock_quantity'];//良品库存数量(仓库+仓位)
                    $edit_wago_data['wago_freight_lock_quantity'] = $find_wago_data->wago_freight_lock_quantity + $value['wfgl_lock_quantity'];//仓位良品锁定库存数量
                    $edit_wago_data['wago_freight_stock_number'] = $find_wago_data->wago_freight_stock_number + $value['wfgl_lock_quantity'];//仓位良品库存数量
                    $edit_wago_data['wago_update_time'] = date('Y-m-d H:i:s');
                    // 仓位表良品库存数量增加
                    $wafr_stock_res = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfgl_wafr_id'])
                        ->increment('wafr_all_stock', $value['wfgl_lock_quantity']);
                    // 仓位表良品锁定库存数量减少
                    $wafr_lock_res = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfgl_wafr_id'])
                        ->decrement('wafr_lock_quantity', $value['wfgl_lock_quantity']);
                    // 良品总库存数量增加
                    $stock_res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                        ->where('waon_class', $find_warehouse_goods->wafg_class)
                        ->increment('waon_stock_fine_amount', $value['wfgl_lock_quantity']);
                    // 良品锁定总数量减少
                    $lock_res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                        ->where('waon_class', $find_warehouse_goods->wafg_class)
                        ->decrement('waon_lock_fine_amount', $value['wfgl_lock_quantity']);
                } else {
                    // 优先库存
                    // 仓位商品锁定数量减少，正常库存数量增加
                    $surplus_quantity = $find_warehouse_goods->wafg_priority_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($surplus_quantity < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'仓位商品锁定库存数量不足'];
                    }
                    // 仓库商品良品锁定数量减少，正常库存数量增加
                    $lock_wafg_edit['wafr_priority_lock_quantity'] = $surplus_quantity;
                    $lock_wafg_edit['wafr_priority_all_stock'] = $find_warehouse_goods->wago_stock_number + $value['wfgl_lock_quantity'];
    
                    // 仓库商品锁定库存数量减少,正常库存数量增加
                    $edit_wago_data['wago_lock_quantity'] = $find_wago_data->wago_lock_quantity - $value['wfgl_lock_quantity'];//良品锁定数量(仓库+仓位)
                    $edit_wago_data['wago_stock_number'] = $find_wago_data->wago_stock_number + $value['wfgl_lock_quantity'];//良品库存数量(仓库+仓位)
                    $edit_wago_data['wago_freight_lock_quantity'] = $find_wago_data->wago_freight_lock_quantity + $value['wfgl_lock_quantity'];//仓位良品锁定库存数量
                    $edit_wago_data['wago_freight_stock_number'] = $find_wago_data->wago_freight_stock_number + $value['wfgl_lock_quantity'];//仓位良品库存数量
                    $edit_wago_data['wago_update_time'] = date('Y-m-d H:i:s');
                    // 仓位表良品库存数量增加
                    $wafr_stock_res = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfgl_wafr_id'])
                        ->increment('wafr_all_stock', $value['wfgl_lock_quantity']);
                    // 仓位表良品锁定库存数量减少
                    $wafr_lock_res = DB::table('warehouse_freight')
                        ->where('wafr_id', $value['wfgl_wafr_id'])
                        ->decrement('wafr_lock_quantity', $value['wfgl_lock_quantity']);
                    // 良品总库存数量增加
                    $stock_res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                        ->where('waon_class', $find_warehouse_goods->wafg_class)
                        ->increment('waon_stock_fine_amount', $value['wfgl_lock_quantity']);
                    // 良品锁定总数量减少
                    $lock_res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                        ->where('waon_class', $find_warehouse_goods->wafg_class)
                        ->decrement('waon_lock_fine_amount', $value['wfgl_lock_quantity']);
                }
                $lock_wafg_edit['wafg_update_time'] = date('Y-m-d H:i:s');
                // 修改仓位商品表
                $lock_edit_res = DB::table('warehouse_freight_goods')
                    ->where('wafg_id', $value['wfgl_wafg_id'])
                    ->update($lock_wafg_edit);
                // 修改仓库商品表
                $edit_wago_res = DB::table('warehouse_goods')
                    ->where('wago_id', $value['wfgl_wago_id'])
                    ->update($edit_wago_data);
                unset($lock_wafg_edit);
                unset($edit_wago_data);
                if (!$lock_edit_res || !$wafr_stock_res || !$wafr_lock_res || !$stock_res || !$lock_res ||!$edit_wago_res) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'发货失败001'];
                }
            } else {//仓库库存锁定还回去
                // 查询固定仓库库存商品信息
                $find_warehouse_goods = DB::table('warehouse_goods')
                    ->where('wago_ware_id', $dis_data->dego_out_ware_id)
                    ->where('wago_id', $value['wfgl_wago_id'])
                    ->select('wago_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_lock_quantity', 'wago_priority_lock_quantity')
                    ->first();
                if ($value['wfgl_lock_type'] == 1) {// 良品库存
                    // 仓库商品锁定数量减少，正常库存数量增加
                    $surplus_quantity = $find_warehouse_goods->wago_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($surplus_quantity < 0) {
                        return ['code'=>500, 'msg'=>'error', 'data'=>'商品锁定库存数量不足1'];
                    }
                    // 仓库商品良品锁定数量减少，正常库存数量增加
                    $lock_wago_edit['wago_lock_quantity'] = $surplus_quantity;
                    $lock_wago_edit['wago_stock_number'] = $find_warehouse_goods->wago_stock_number + $value['wfgl_lock_quantity'];

                    // 良品总库存数量增加
                    $stock_res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                        ->where('waon_class', $find_warehouse_goods->wago_class)
                        ->increment('waon_stock_fine_amount', $value['wfgl_lock_quantity']);
                    // 良品锁定总数量减少
                    $lock_res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                        ->where('waon_class', $find_warehouse_goods->wago_class)
                        ->decrement('waon_lock_fine_amount', $value['wfgl_lock_quantity']);
                } else {// 优先库存
                    $surplus_quantity = $find_warehouse_goods->wago_priority_lock_quantity - $value['wfgl_lock_quantity'];
                    if ($surplus_quantity < 0) {
                        return ['code' => 500, 'msg' => 'error', 'data' => '商品锁定库存数量不足6'];
                    }
    
                    // 固定仓库商品优先锁定数量减少
                    $lock_wago_edit['wago_priority_lock_quantity'] = $surplus_quantity;
                    $lock_wago_edit['wago_priority_stock_number'] = $find_warehouse_goods->wago_priority_stock_number + $value['wfgl_lock_quantity'];
                    // 总库存数量增加
                    $stock_res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                        ->where('waon_class', $find_warehouse_goods->wago_class)
                        ->increment('waon_stock_priority_amount', $value['wfgl_lock_quantity']);
                    // 锁定总数量减少
                    $lock_res = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                        ->where('waon_class', $find_warehouse_goods->wago_class)
                        ->decrement('waon_lock_priority_amount', $value['wfgl_lock_quantity']);
                }
                $lock_wago_edit['wago_update_time'] = date('Y-m-d H:i:s');
    
                $lock_edit_res = DB::table('warehouse_goods')
                    ->where('wago_id', $value['wfgl_wago_id'])
                    ->update($lock_wago_edit);
                unset($lock_wago_edit);
                // 删除对应的锁定
                $wagl_id = DB::table('warehouse_goods_lock')
                    ->where('wagl_original_correlation_id', $dis_data->dego_id)
                    ->where('wagl_correlation_type', 2)
                    ->value('wagl_id');
                if (!empty($wagl_id)) {
                    $wagl_res = DB::table('warehouse_goods_lock')
                        ->where('wagl_original_correlation_id', $dis_data->dego_id)
                        ->where('wagl_correlation_type', 2)
                        ->delete();
                } else {
                    $wagl_res =  true;
                }
                if (!$lock_edit_res || !$stock_res || !$lock_res || !$wagl_res) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'发货失败001'];
                }
            }
        }
        // 删除对应的锁定
        if ($dis_data->dego_order_type == '1') {//类型1订单发货
            $find_ord_id = $dis_data->dego_wor_id;//订单id
            $find_order_number = $dis_data->dego_original_number;//订单编号
        } elseif ($dis_data->dego_order_type == '2') {//2工单发货
            $find_order_data = DB::table('work_order as wor')
                ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                ->where('wor_id', $dis_data->dego_wor_id)
                ->select('wor_type', 'wocl_client_id', 'wor_order_id', 'wor_order_number')
                ->first();
            $find_ord_id = $find_order_data->wor_order_id;//订单id
            $find_order_number = $find_order_data->wor_order_number;//订单编号
        }
        // 仓库商品锁定表
        $del_wagl_res = DB::table('warehouse_goods_lock')
            ->where('wagl_shop_id', $user_info->adm_shop_id)
            ->where('wagl_original_correlation_id', $dis_data->dego_id)
            ->where('wagl_correlation_type', 2)
            ->delete();
        // 仓位商品锁定表
        $del_wfgl_id = DB::table('warehouse_freight_goods_lock')
            ->where('wfgl_shop_id', $user_info->adm_shop_id)
            ->where('wfgl_original_id', $find_ord_id)
            ->where('wfgl_original_number', $find_order_number)
            ->where('wfgl_type', 1)
            ->delete();
        $wagl_data = [];
        $wagl_key = 0;
        $wagl_lock_quantity = [];//仓库锁定表的商品锁定数量
        foreach ($goods_data as $key => $value) {//仓位商品正常库存减少,锁定库存增加
            // 仓库锁定表的商品锁定数量：良品+优先 总的锁定数量
            if (isset($wagl_lock_quantity[$value['digo_wago_id']])) {
                $wagl_lock_quantity[$value['digo_wago_id']] += $value['digo_goo_quantity'];
            } else {
                $wagl_lock_quantity[$value['digo_wago_id']] = $value['digo_goo_quantity'];
            }
            // 查询固定仓库库存商品信息
            $find_warehouse_freight_goods = DB::table('warehouse_freight_goods')
                ->where('wafg_wafr_id', $value['digo_wafr_id'])
                ->where('wafg_wago_id', $value['digo_wago_id'])
                ->where('wafg_ware_id', $dis_data->dego_out_ware_id)
                ->select('wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_goo_id', 'wafg_stock_number', 'wafg_lock_quantity', 'wafg_priority_stock_number', 'wafg_priority_lock_quantity')
                ->get()->toArray();
            foreach ($find_warehouse_freight_goods as $key => $values) {
                $warehouse_fclass_goods[$values->wafg_wafr_id][$values->wafg_wago_id][$values->wafg_goo_id] = (array)$values;
            }
            // 查询仓库商品表仓位的库存数量
            $find_wogo_data = DB::table('warehouse_goods')
                ->where('wago_id', $value['digo_wago_id'])
                ->select('wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity')
                ->first();
            // 仓位商品锁定
            $wfgl_data['wfgl_shop_id'] = $user_info->adm_shop_id;//门店id
            $wfgl_data['wfgl_ware_id'] = $dis_data->dego_out_ware_id;//仓库id
            $wfgl_data['wfgl_wago_id'] = $value['digo_wago_id'];//仓库商品主键id
            $wfgl_data['wfgl_wafr_id'] = $value['digo_wafr_id'];//仓位id
            $wfgl_data['wfgl_wafg_id'] = $warehouse_fclass_goods[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_id']]['wafg_id'];//仓位商品主键id
            $wfgl_data['wfgl_original_correlation_id'] = $find_ord_id;//关联id：订单id/发货单id/调拨单id
            $wfgl_data['wfgl_correlation_type'] = 1;//关联类型：1订单2发货单3调拨单
            $wfgl_data['wfgl_original_id'] = $find_ord_id;//原始id：订单id/调拨单id
            $wfgl_data['wfgl_original_number'] = $find_order_number;//原始单号：订单号/调拨单号
            $wfgl_data['wfgl_type'] = 1;//原始单类型：1订单2调拨单
            $wfgl_data['wfgl_state'] = 1;//锁定状态：1下单锁定2出库解锁
            // 库存扣除方式1.良品 2.优先
            if ($value['digo_goo_inventory'] == 1) {
                $wfgl_data['wfgl_lock_quantity'] = $value['digo_goo_quantity'];//商品锁定数量
                $wfgl_data['wfgl_lock_type'] = 1;//商品锁定类型：1良品2优先
                // 仓位商品锁定数量增加，正常库存数量减少
                $surplus_quantity = $warehouse_fclass_goods[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_id']]['wafg_stock_number'] - $value['digo_goo_quantity'];
                if ($surplus_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓位商品库存数量不足002'];
                }
                $lock_wafg_edit['wafg_stock_number'] = $surplus_quantity;
                $lock_wafg_edit['wafg_lock_quantity'] = $warehouse_fclass_goods[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_id']]['wafg_lock_quantity'] + $value['digo_goo_quantity'];

                // 仓库仓位库存数量减少,锁定数量增加
                $edit_data['wago_freight_stock_number'] = $find_wogo_data->wago_freight_stock_number - $value['digo_goo_quantity'];
                // 仓库的仓位良品锁定库存数量增加
                $edit_data['wago_freight_lock_quantity'] = $find_wogo_data->wago_freight_lock_quantity + $value['digo_goo_quantity'];
                $edit_data['wago_update_time'] = date('Y-m-d H:i:s');
                // 仓位表良品库存数量减少
                $wafr_stocks_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value['digo_wafr_id'])
                    ->decrement('wafr_all_stock', $value['digo_goo_quantity']);
                // 仓位表良品锁定库存数量增加
                $wafr_locks_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value['digo_wafr_id'])
                    ->increment('wafr_lock_quantity', $value['digo_goo_quantity']);
                // 良品总库存数量减少
                $stock_res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                    ->where('waon_class', $value['digo_wago_class'])
                    ->decrement('waon_stock_fine_amount', $value['digo_goo_quantity']);
                // 良品锁定总数量增加
                $lock_res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                    ->where('waon_class', $value['digo_wago_class'])
                    ->increment('waon_lock_fine_amount', $value['digo_goo_quantity']);
            } else {
                $wfgl_data['wfgl_lock_quantity'] = $value['digo_goo_quantity'];//商品锁定数量
                $wfgl_data['wfgl_lock_type'] = 2;//商品锁定类型：1良品2优先
                // 固定仓商品锁定数量增加，正常库存数量减少
                $surplus_quantity = $warehouse_fclass_goods[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_id']]['wafg_priority_stock_number'] - $value['digo_goo_quantity'];
                if ($surplus_quantity < 0) {
                    return ['code' => 500, 'msg' => 'error', 'data' => '商品库存数量不足4'];
                }
                // 固定仓库商品优先锁定数量增加
                $lock_wafg_edit['wafg_priority_stock_number'] = $surplus_quantity;
                $lock_wafg_edit['wafg_priority_lock_quantity'] = $warehouse_fclass_goods[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_id']]['wafg_priority_lock_quantity'] + $value['digo_goo_quantity'];
                
                // 仓库仓位库存数量减少,锁定数量增加
                $edit_data['wago_freight_priority_stock_number'] = $find_wogo_data->wago_freight_priority_stock_number - $value['digo_goo_quantity'];
                // 仓库的仓位良品锁定库存数量增加
                $edit_data['wago_freight_priority_lock_quantity'] = $find_wogo_data->wago_freight_priority_lock_quantity + $value['digo_goo_quantity'];
                $edit_data['wago_update_time'] = date('Y-m-d H:i:s');
                // 仓位表良品库存数量减少
                $wafr_stocks_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value['digo_wafr_id'])
                    ->decrement('wafr_priority_all_stock', $value['digo_goo_quantity']);
                // 仓位表良品锁定库存数量增加
                $wafr_locks_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value['digo_wafr_id'])
                    ->increment('wafr_priority_lock_quantity', $value['digo_goo_quantity']);
                // 良品总库存数量减少
                $stock_res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                    ->where('waon_class', $value['digo_wago_class'])
                    ->decrement('waon_stock_priority_amount', $value['digo_goo_quantity']);
                // 良品锁定总数量增加
                $lock_res = DB::table('warehouse_onhand')
                    ->where('waon_ware_id', $dis_data->dego_out_ware_id)
                    ->where('waon_class', $value['digo_wago_class'])
                    ->increment('waon_lock_priority_amount', $value['digo_goo_quantity']);
            }
            // 新增仓位商品锁定
            $wfgl_add_res = DB::table('warehouse_freight_goods_lock')->insert($wfgl_data);
            $lock_wafg_edit['wafg_update_time'] = date('Y-m-d H:i:s');

            $lock_edit_res = DB::table('warehouse_freight_goods')
                ->where('wafg_id', $warehouse_fclass_goods[$value['digo_wafr_id']][$value['digo_wago_id']][$value['digo_goo_id']]['wafg_id'])
                ->update($lock_wafg_edit);

            $lock_wogo_res = DB::table('warehouse_goods')
                ->where('wago_id', $value['digo_wago_id'])
                ->update($edit_data);

            unset($lock_wafg_edit);
            unset($edit_data);
            // 仓库商品锁定表
            if ($dis_data->dego_order_type == '1') {//类型1订单发货
                $find_ord_id = $dis_data->dego_wor_id;//订单id
                $find_order_number = $dis_data->dego_original_number;//订单编号
            } elseif ($dis_data->dego_order_type == '2') {//2工单发货
                $find_order_data = DB::table('work_order as wor')
                    ->leftjoin('work_client as wocl', 'wocl.wocl_wor_id', '=', 'wor.wor_id')
                    ->where('wor_id', $dis_data->dego_wor_id)
                    ->select('wor_type', 'wocl_client_id', 'wor_order_id', 'wor_order_number')
                    ->first();
                $find_ord_id = $find_order_data->wor_order_id;//订单id
                $find_order_number = $find_order_data->wor_order_number;//订单编号
            }
            $wagl_data[$wagl_key]['wagl_shop_id'] = $user_info->adm_shop_id;
            $wagl_data[$wagl_key]['wagl_ware_id'] = $dis_data->dego_out_ware_id;
            $wagl_data[$wagl_key]['wagl_wago_id'] = $value['digo_wago_id'];
            $wagl_data[$wagl_key]['wagl_original_id'] = $find_ord_id;
            $wagl_data[$wagl_key]['wagl_original_number'] = $find_order_number;
            $wagl_data[$wagl_key]['wagl_original_correlation_id'] = $dis_data->dego_id; //关联id：订单id/发货单id/调拨单id
            $wagl_data[$wagl_key]['wagl_correlation_type'] = 2; //关联类型：1订单2发货单3调拨单
            $wagl_data[$wagl_key]['wagl_type'] = 1; //  原始单类型：1订单2调拨单
            $wagl_data[$wagl_key]['wagl_state'] = 1; //锁定状态：1下单锁定2出库解锁
            $wagl_data[$wagl_key]['wagl_lock_quantity'] = $wagl_lock_quantity[$value['digo_wago_id']];//商品锁定库存数量
            $wagl_key++;

            if (!$lock_edit_res || !$stock_res || !$lock_res || !$wfgl_add_res || !$lock_wogo_res || !$wafr_stocks_res || !$wafr_locks_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'发货失败惹'];
            }
        }
        // 锁定数量
        if (!empty($wagl_data)) {
            $wagl_res = DB::table('warehouse_goods_lock')->insert($wagl_data);
            if (!$wagl_res) {
                return ['code'=>500, 'msg'=>'error', 'data'=>'发货失败惹2'];
            }
        }
        
        return ['code'=>200, 'msg'=>'success', 'return_data'=>$return_data];
    }

    /**
     * [shipmentAddition 添加仓位出入库记录]
     * @param  [type] $user_info            [用户信息]
     * @param  [type] $wfog_in_ware_id      [入库仓库id]
     * @param  [type] $wfog_out_ware_id     [出库仓库id]
     * @param  [type] $wfog_wago_id         [仓库商品主键id]
     * @param  [type] $wfog_wafr_id         [仓位id]
     * @param  [type] $wfog_wafg_id         [仓位商品主键id]
     * @param  [type] $wfog_type            [关联类型：1采购入库2采购退货出库3调拨入库4调拨出库5旧货回收6退货入库7盘库8发货]
     * @param  [type] $original_id          [原始单id]
     * @param  [type] $original_number      [原始单号]
     * @param  [type] $wfog_primary_id      [关联商品表主键id]
     * @param  [type] $wfog_goods_id        [商品id]
     * @param  [type] $wfog_outin_type      [出入库类型：1出库2入库]
     * @param  [type] $wfog_stock_amount    [商品数量]
     * @param  [type] $wfog_stock_type      [库存类型1良品2优先]
     * @return [type]                       [description]
     */
    public static function shipmentAddition(
        $user_info,
        $wfog_in_ware_id,
        $wfog_out_ware_id,
        $wfog_wago_id,
        $wfog_wafr_id,
        $wfog_wafg_id,
        $wfog_type,
        $original_id,
        $original_number,
        $wfog_primary_id,
        $wfog_goods_id,
        $wfog_outin_type,
        $wfog_stock_amount,
        $wfog_stock_type
    ) {
        $n = 0;
        foreach ($wfog_goods_id as $key => $value) {
            $wfog_add_data[$n]['wfog_shop_id'] = $user_info->adm_shop_id;//门店id
            if ($wfog_outin_type == 1) {//出库
                $wfog_add_data[$n]['wfog_ware_id'] = $wfog_out_ware_id;//仓库id
            } else {
                $wfog_add_data[$n]['wfog_ware_id'] = $wfog_in_ware_id;//仓库id
            }
            $wfog_add_data[$n]['wfog_wago_id'] = $wfog_wago_id[$key];//仓库商品主键id
            $wfog_add_data[$n]['wfog_wafr_id'] = $wfog_wafr_id[$key];//仓位id
            $wfog_add_data[$n]['wfog_wafg_id'] = $wfog_wafg_id[$key];//仓位商品主键id
            $wfog_add_data[$n]['wfog_type'] = $wfog_type;//关联类型：1采购入库
            $wfog_add_data[$n]['wfog_original_id'] = $original_id;//原始单id
            $wfog_add_data[$n]['wfog_original_number'] = $original_number;//原始单号
            $wfog_add_data[$n]['wfog_primary_id'] = $wfog_primary_id[$key];//关联商品表主键id
            $wfog_add_data[$n]['wfog_goo_id'] = $value;//商品id
            $wfog_add_data[$n]['wfog_outin_type'] = $wfog_outin_type;//出入库类型：1出库2入库
            $wfog_add_data[$n]['wfog_stock_amount'] = $wfog_stock_amount[$key];//商品数量
            $wfog_add_data[$n]['wfog_stock_type'] = $wfog_stock_type[$key];//库存类型1良品2优先
            $wfog_add_data[$n]['wfog_adm_id'] = $user_info->adm_id;//操作人id
            $n++;
        }
        $wfog_id = DB::table('warehouse_freight_outin_goods')->insert($wfog_add_data);

        if ($wfog_id) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'操作成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'操作失败'];
        }
    }
}
