<?php
namespace App\Http\Models\Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Http\Models\Api\RecedeRecycle;

class Warehouse extends Model
{
    /**
     * [appExchangeGoods 工单驳回换货单商品存库处理]
     * @param  [type] $user_info           [用户信息]
     * @param  [type] $ware_id             [移动仓库id]
     * @param  [type] $wor_id              [工单id]
     * @param  [type] $wor_number          [工单号]
     * @param  [type] $rego_recycle_number [换货商品数量，数组['商品id'=>回收商品数量]]
     * @return [type]                      [description]
     */
    public static function rejectExchangeGoods(
        $user_info,
        $ware_id,
        $wor_id,
        $wor_number,
        $rego_recycle_number
    ) {
        // 换货单，完成提交，订单商品应该出库，换货商品应该回库
        // 查询出工单商品
        $work_good = DB::table('work_good')
            ->where('wogo_wor_id', $wor_id)
            ->select('wogo_id', 'wogo_goo_id', 'wogo_goo_amount', 'wogo_goo_inventory', 'wogo_goo_exchange', 'wogo_goo_price')
            ->get()->toArray();
        if (empty($work_good)) {
            return ["code"=>500, 'msg'=>'error', 'data'=>'提交失败'];
        }

        $goo_all_fine = 0; //良品总数量
        $goo_all_priority = 0; //优先总数量
        $goo_all_quantity = 0; //商品总数量

        // 换货商品
        $goo_exchange_all_fine = 0; //良品总数量
        $goo_exchange_all_priority = 0; //优先总数量
        $goo_exchange_all_quantity = 0; //商品总数量
        $exchange_key = 0;
        foreach ($work_good as $key => $value) {
            if ($value->wogo_goo_exchange == 1) {
                // 订单商品
                // 商品id
                $goo_id[$key] = $value->wogo_goo_id;
                $goo_number[$key] = $value->wogo_goo_amount;
                $goo_inventory[$key] = $value->wogo_goo_inventory;

                // 商品id所对应的商品数量
                $subtract[$value->wogo_goo_id] = $value->wogo_goo_amount;
                // 商品id所对应的出库方式
                $wogo_goo_inventory[$value->wogo_goo_id] = $value->wogo_goo_inventory;
                // 商品总量
                $goo_all_quantity += $value->wogo_goo_amount;

                if ($value->wogo_goo_inventory == 1) {
                    $goo_all_fine += $value->wogo_goo_amount; //1.良品
                } else {
                    $goo_all_priority += $value->wogo_goo_amount; //2.优先
                }
            } elseif ($value->wogo_goo_exchange == 2) {
                // 换货商品
                $goo_exchange_id[$exchange_key] = $value->wogo_goo_id;
                $goo_exchange_number[$exchange_key] = $value->wogo_goo_amount;
                $goo_exchange_inventory[$exchange_key] = $value->wogo_goo_inventory;

                // 生成退换回收单使用，后面需要改下退换回收
                $rec_goo_exchange_id[$exchange_key] = $value->wogo_goo_id;
                $rec_goo_exchange_number[$value->wogo_goo_id] = $rego_recycle_number[$value->wogo_goo_id];
                $rec_goo_exchange_price[$value->wogo_goo_id] = $value->wogo_goo_price / 100;

                // 商品id所对应的商品数量
                $exchange_subtract[$value->wogo_goo_id] = $value->wogo_goo_amount;
                // 商品id所对应的出库方式
                $wogo_goo_exchange_inventory[$value->wogo_goo_id] = $value->wogo_goo_inventory;
                // $goo_exchange_repertory[$value->wogo_goo_id]=$value->wogo_goo_inventory;
                // 商品总量
                $goo_exchange_all_quantity += $value->wogo_goo_amount;

                if ($value->wogo_goo_inventory == 1) {
                    $goo_exchange_all_fine += $value->wogo_goo_amount; //1.良品
                } else {
                    $goo_exchange_all_priority += $value->wogo_goo_amount; //2.优先
                }
                $exchange_key++;
            }

            $goo_all_id[$key] = $value->wogo_goo_id; //所有的商品id
        }

        // 查询仓库商品数量
        $warehouse_goods = DB::table('warehouse_goods')
            ->whereIn('wago_goo_id', $goo_all_id)
            ->where('wago_ware_id', $ware_id)
            ->get(['wago_id', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number'])
            ->toArray();

        // 先减去订单商品的库存，减技师移动仓的库存
        // 先加上订单商品的库存，加上师移动仓的库存
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_fine_sql = '';
        $stock_priority_sql = '';
        $time_sql = '';
        $ids = '';
        foreach ($warehouse_goods as $key => $value) {
            if (in_array($value->wago_goo_id, $goo_id)) {
                // 订单商品，要出库的商品，减去仓库的库存数量，要更改的商品库存数量
                if ($wogo_goo_inventory[$value->wago_goo_id] == 1) {
                    // 良品
                    $subtract_data = $value->wago_stock_number + $subtract[$value->wago_goo_id];
                    // if($subtract_data < 0){
                    //     return ['code'=> 500, 'msg'=>'仓库内商品数量不足', 'data'=>'{}'];
                    // }
                    $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $value->wago_id . ' THEN ' . $subtract_data;
                    $stock_priority_sql = $stock_priority_sql . ' WHEN ' . $value->wago_id . ' THEN `wago_priority_stock_number` + 0';
                } else {
                    $subtract_data = $value->wago_priority_stock_number + $subtract[$value->wago_goo_id];
                    // if($subtract_data < 0){
                    //     return ['code'=> 500, 'msg'=>'仓库内商品数量不足', 'data'=>'{}'];
                    // }
                    // 优先
                    $stock_priority_sql = $stock_priority_sql . ' WHEN ' . $value->wago_id . ' THEN ' . $subtract_data;
                    $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $value->wago_id . ' THEN `wago_stock_number` + 0';
                }
                // 更改时间
                $time_sql = $time_sql . ' WHEN ' . $value->wago_id . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->wago_id . ',';

                // 删除已更改的商品数据
                unset($subtract[$value->wago_goo_id]);
            }
        }
        $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_fine_sql . ' END,';
        $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $stock_priority_sql . ' END,';
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END'; //修改时间
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
        $out_save_warehouse = DB::update($sql);
        // 减库存总数量
        $out_subtract_all = DB::update('UPDATE `faster_warehouse` SET `ware_all_stock`=`ware_all_stock` + ' . $goo_all_fine . ' ,`ware_priority_all_stock`=`ware_priority_all_stock` + ' . $goo_all_priority . ' WHERE `ware_id`=?', [$ware_id]);


        // 换货商品，仓库应该增加商品数量
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_fine_sql = '';
        $stock_priority_sql = '';
        $time_sql = '';
        $ids = '';
        $wago_goo_exchange_id = [];
        foreach ($warehouse_goods as $key => $value) {
            if (in_array($value->wago_goo_id, $goo_exchange_id)) {
                // 要更改的商品库存数量
                if ($wogo_goo_exchange_inventory[$value->wago_goo_id] == 1) {
                    // 良品
                    $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $value->wago_id . ' THEN `wago_stock_number` - ' . $exchange_subtract[$value->wago_goo_id];
                    $stock_priority_sql = $stock_priority_sql . ' WHEN ' . $value->wago_id . ' THEN `wago_priority_stock_number` - 0';
                } else {
                    // 优先
                    $stock_priority_sql = $stock_priority_sql . ' WHEN ' . $value->wago_id . ' THEN `wago_priority_stock_number` - ' . $exchange_subtract[$value->wago_goo_id];
                    $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $value->wago_id . ' THEN `wago_stock_number` - 0';
                }
                // 更改时间
                $time_sql = $time_sql . ' WHEN ' . $value->wago_id . ' THEN "' . date('Y-m-d H:i:s') . '"';
                $ids = $ids . $value->wago_id . ',';

                // 删除已更改的商品数据
                unset($exchange_subtract[$value->wago_goo_id]);
                $wago_goo_exchange_id[] = $value->wago_goo_id; //仓库商品表的换货商品
            }
        }
        $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_fine_sql . ' END,';
        $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $stock_priority_sql . ' END,';
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END'; //修改时间
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';

        if ($wago_goo_exchange_id) {
            // 移动仓库内有换货的商品，直接更改商品数量
            $save_warehouse = DB::update($sql);
        } else {
            // 移动仓库内没有换货商品
            $save_warehouse = true;
        }

        // 比较移动仓库内的商品id，与工单的换货商品id个数是否一样，
        // if (count($goo_exchange_id) == count($wago_goo_exchange_id)) {
        //     // 商品id个数一样说明，移动仓库内都有工单的换货商品id
        //     $ware_add_res = true;
        // }else{
        //     // 不一样说明移动仓库内没有工单的换货商品id，需要在移动仓库内添加换货的商品
        //     $num = 0;
        //     foreach ($exchange_subtract as $key => $value) {
        //         $ware_add_data[$num]['wago_ware_id'] = $ware_id;
        //         $ware_add_data[$num]['wago_goo_id'] = $key;
        //         if($wogo_goo_exchange_inventory[$key] == 1){
        //             // 良品库存
        //             $ware_add_data[$num]['wago_stock_number'] = $value;
        //         }else{
        //             // 优先库存
        //             $ware_add_data[$num]['wago_priority_stock_number'] = $value;
        //         }
        //         $num++;
        //     }
        //     $ware_add_res = DB::table('warehouse_goods')->insert($ware_add_data);
        // }

        // 加库存总数量
        $subtract_all = DB::update('UPDATE `faster_warehouse` SET `ware_all_stock`=`ware_all_stock`-' . $goo_exchange_all_fine . ' ,`ware_priority_all_stock`=`ware_priority_all_stock` - ' . $goo_exchange_all_priority . ' WHERE `ware_id`=?', [$ware_id]);


        $sell_detail_res = DB::table('recede_recycle as rr')
            ->join('recede_goods as rg', 'rr.rec_id', '=', 'rg.rego_rec_id')
            ->where('rec_ord_id', $wor_id)
            ->where('rec_ord_order_number', $wor_number)
            ->delete();

        if ($save_warehouse && $subtract_all && $out_save_warehouse && $out_subtract_all && $sell_detail_res) {
            return ["code"=>200, 'msg'=>'success', 'data'=>'提交成功'];
        } else {
            return ["code"=>500, 'msg'=>'error', 'data'=>'提交失败'];
        }
    }

    /**
     * [lockTurnNormal 锁定库存转正常库存]
     * @param  [type] $user_info      [用户信息]
     * @param  [type] $ware_id        [仓库id]
     * @param  [type] $goo_id         [数组，商品id,数组]
     * @param  [type] $goo_quantity   [数组，商品id=>商品数量]
     * @param  [type] $goo_inventory  [数组，商品id=>出库类型 1.良品 2.优先]
     * @param  [type] $goo_wago_class [数组，商品id=>仓库类别]
     * @return [type]                 [description]
     */
    public static function lockTurnNormal(
        $user_info,
        $ware_id,
        $goo_id,
        $goo_quantity,
        $goo_inventory,
        $goo_wago_class
    ) {
        // 2.选中的固定仓减锁定库存
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $ware_id)
            ->whereIn('wago_class', $goo_wago_class)
            ->whereIn('wago_goo_id', $goo_id)
            ->get(['wago_id', 'wago_class', 'wago_goo_id', 'wago_lock_quantity', 'wago_priority_lock_quantity'])
            ->toArray();
        foreach ($warehouse_goods as $key => $value) {
            $warehouse_class_goods[$value->wago_class][$value->wago_goo_id] = (array)$value;
        }
        foreach ($goo_id as $key => $value) {
            $new_goo_arr['goo_id'] = $value;
            $new_goo_arr['goo_inventory'] = $goo_inventory[$value];
            $new_goo_arr['goo_quantity'] = $goo_quantity[$value];
            $wago_class_goods[$goo_wago_class[$value]][$value] = $new_goo_arr; //仓库类型对应的商品，进销存计算
            unset($new_goo_arr);
        }

        // 仓库商品表 减锁定库存数量 加原来的库存数量
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_number_sql = '';
        $lock_quantity_sql = '';
        $priority_stock_number_sql = '';
        $priority_lock_quantity_sql = '';
        $time_sql = '';
        $ids = '';
        $fine_total_quantity = 0; //良品总数量
        $priority_total_quantity = 0; //优先总数量
        $waon_class_fine_quantity = []; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = []; //仓库类别对应优先库存总数量

        foreach ($wago_class_goods as $waon_class => $class_goods_data) {
            foreach ($class_goods_data as $goo_id => $value) {
                // 商品出库类型，良品出库
                if ($value['goo_inventory'] == 1) {
                    // 良品剩余库存数量
                    $surplus_quantity = $warehouse_class_goods[$waon_class][$goo_id]['wago_lock_quantity'] - $value['goo_quantity'];
                    if ($surplus_quantity < 0) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库内锁定商品数量不足']);
                    }
                    // 库存数量增加
                    $stock_number_sql = $stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_stock_number` + ' . $value['goo_quantity'];
                    // 锁定数量减少
                    $lock_quantity_sql = $lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_lock_quantity` - ' . $value['goo_quantity'];

                    // 优先数量
                    $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_stock_number` + 0';
                    $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_lock_quantity` - 0';

                    $fine_total_quantity = $fine_total_quantity + $value['goo_quantity'];
                    if (isset($waon_class_fine_quantity[$waon_class])) {
                        $waon_class_fine_quantity[$waon_class] += $value['goo_quantity']; //仓库类别对应良品库存总数量
                    } else {
                        $waon_class_fine_quantity[$waon_class] = $value['goo_quantity']; //仓库类别对应良品库存总数量
                    }
                    // 商品出库类型，优先出库
                } else {
                    // 优先剩余库存数量
                    $surplus_quantity = $warehouse_class_goods[$waon_class][$goo_id]['wago_priority_lock_quantity'] - $value['goo_quantity'];
                    if ($surplus_quantity < 0) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库内锁定商品数量不足']);
                    }

                    // 库存数量增加
                    $stock_number_sql = $stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_stock_number` + 0';
                    // 锁定数量减少
                    $lock_quantity_sql = $lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_lock_quantity` - 0';

                    // 优先数量
                    $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_stock_number` + ' . $value['goo_quantity'];
                    $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_lock_quantity` - ' . $value['goo_quantity'];

                    $priority_total_quantity = $priority_total_quantity + $value['goo_quantity'];
                    if (isset($waon_class_priority_quantity[$waon_class])) {
                        $waon_class_priority_quantity[$waon_class] += $value['goo_quantity']; //仓库类别对应优先库存总数量
                    } else {
                        $waon_class_priority_quantity[$waon_class] = $value['goo_quantity']; //仓库类别对应优先库存总数量
                    }
                }

                $time_sql = $time_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"'; // 更改时间
                $ids = $ids . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ',';
            }
        }
        $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_number_sql . ' END,';
        $sql = $sql . ' `wago_lock_quantity`=  CASE `wago_id` ' . $lock_quantity_sql . ' END,';
        $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $priority_stock_number_sql . ' END,';
        $sql = $sql . ' `wago_priority_lock_quantity`=  CASE `wago_id` ' . $priority_lock_quantity_sql . ' END,';
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END';
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
        $update_wago_res = DB::update($sql);

        // 查询仓库总数量仓库的类别对应的id
        $goo_wago_class = array_unique($goo_wago_class);
        $find_waon_data = DB::table('warehouse_onhand')
            ->where('waon_ware_id', '=', $ware_id)
            ->whereIn('waon_class', $goo_wago_class)
            ->pluck('waon_id', 'waon_class')->toArray();

        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_fine_quantity as $key => $value) {
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_stock_fine_amount` + ' . $value;
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_lock_fine_amount` - ' . $value;
                $time_sql = $time_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $find_waon_data[$key] . ',';
            }
            $sql = $sql . ' `waon_stock_fine_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_fine_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_fine_res = DB::update($sql);
        } else {
            $waon_fine_res = true;
        }

        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_priority_quantity as $key => $value) {
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_stock_priority_amount` + ' . $value;
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_lock_priority_amount` - ' . $value;
                $time_sql = $time_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $find_waon_data[$key] . ',';
            }
            $sql = $sql . ' `waon_stock_priority_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_priority_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_priority_res = DB::update($sql);
        } else {
            $waon_priority_res = true;
        }

        if ($update_wago_res && $waon_fine_res && $waon_priority_res) {
            return true;
        } else {
            return false;
        }
    }

    /**
     * [normalTurnLock 正常库存转锁定库存]
     * @param  [type] $user_info      [用户信息]
     * @param  [type] $ware_id        [仓库id]
     * @param  [type] $goo_id         [数组，商品id,数组]
     * @param  [type] $goo_quantity   [数组，商品id=>商品数量]
     * @param  [type] $goo_inventory  [数组，商品id=>库存扣除方式 1.良品 2.优先]
     * @param  [type] $goo_wago_class [数组，商品id=>仓库类别]
     * @return [type]                 [description]
     */
    public static function normalTurnLock(
        $user_info,
        $ware_id,
        $goo_id,
        $goo_quantity,
        $goo_inventory,
        $goo_wago_class
    ) {
        // 2.选中的固定仓减锁定库存
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $ware_id)
            ->whereIn('wago_class', $goo_wago_class)
            ->whereIn('wago_goo_id', $goo_id)
            ->get(['wago_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number'])
            ->toArray();
        foreach ($warehouse_goods as $key => $value) {
            $warehouse_class_goods[$value->wago_class][$value->wago_goo_id] = (array)$value;
        }
        foreach ($goo_id as $key => $value) {
            $new_goo_arr['goo_id'] = $value;
            $new_goo_arr['goo_inventory'] = $goo_inventory[$value];
            $new_goo_arr['goo_quantity'] = $goo_quantity[$value];
            $wago_class_goods[$goo_wago_class[$value]][$value] = $new_goo_arr; //仓库类型对应的商品，进销存计算
            unset($new_goo_arr);
        }

        // 仓库商品表 减锁定库存数量 加原来的库存数量
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_number_sql = '';
        $lock_quantity_sql = '';
        $priority_stock_number_sql = '';
        $priority_lock_quantity_sql = '';
        $time_sql = '';
        $ids = '';
        $fine_total_quantity = 0; //良品总数量
        $priority_total_quantity = 0; //优先总数量
        $waon_class_fine_quantity = []; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = []; //仓库类别对应优先库存总数量

        foreach ($wago_class_goods as $waon_class => $class_goods_data) {
            foreach ($class_goods_data as $goo_id => $value) {
                // 商品出库类型，良品出库
                if ($value['goo_inventory'] == 1) {
                    // 良品剩余库存数量
                    $surplus_quantity = $warehouse_class_goods[$waon_class][$goo_id]['wago_stock_number'] - $value['goo_quantity'];
                    if ($surplus_quantity < 0) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品数量不足']);
                    }
                    // 库存数量增加
                    $stock_number_sql = $stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_stock_number` - ' . $value['goo_quantity'];
                    // 锁定数量减少
                    $lock_quantity_sql = $lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_lock_quantity` + ' . $value['goo_quantity'];

                    // 优先数量
                    $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_stock_number` - 0';
                    $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_lock_quantity` + 0';

                    $fine_total_quantity = $fine_total_quantity + $value['goo_quantity'];
                    if (isset($waon_class_fine_quantity[$waon_class])) {
                        $waon_class_fine_quantity[$waon_class] += $value['goo_quantity']; //仓库类别对应良品库存总数量
                    } else {
                        $waon_class_fine_quantity[$waon_class] = $value['goo_quantity']; //仓库类别对应良品库存总数量
                    }
                    // 商品出库类型，优先出库
                } else {
                    // 优先剩余库存数量
                    $surplus_quantity = $warehouse_class_goods[$waon_class][$goo_id]['wago_priority_stock_number'] - $value['goo_quantity'];
                    if ($surplus_quantity < 0) {
                        return response()->json(['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品数量不足']);
                    }

                    // 库存数量增加
                    $stock_number_sql = $stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_stock_number` - 0';
                    // 锁定数量减少
                    $lock_quantity_sql = $lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_lock_quantity` + 0';

                    // 优先数量
                    $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_stock_number` - ' . $value['goo_quantity'];
                    $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN `wago_priority_lock_quantity` + ' . $value['goo_quantity'];

                    $priority_total_quantity = $priority_total_quantity + $value['goo_quantity'];
                    if (isset($waon_class_priority_quantity[$waon_class])) {
                        $waon_class_priority_quantity[$waon_class] += $value['goo_quantity']; //仓库类别对应优先库存总数量
                    } else {
                        $waon_class_priority_quantity[$waon_class] = $value['goo_quantity']; //仓库类别对应优先库存总数量
                    }
                }

                $time_sql = $time_sql . ' WHEN ' . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"'; // 更改时间
                $ids = $ids . $warehouse_class_goods[$waon_class][$goo_id]['wago_id'] . ',';
            }
        }
        $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_number_sql . ' END,';
        $sql = $sql . ' `wago_lock_quantity`=  CASE `wago_id` ' . $lock_quantity_sql . ' END,';
        $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $priority_stock_number_sql . ' END,';
        $sql = $sql . ' `wago_priority_lock_quantity`=  CASE `wago_id` ' . $priority_lock_quantity_sql . ' END,';
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END';
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
        $update_wago_res = DB::update($sql);

        // 查询仓库总数量仓库的类别对应的id
        $goo_wago_class = array_unique($goo_wago_class);
        $find_waon_data = DB::table('warehouse_onhand')
            ->where('waon_ware_id', '=', $ware_id)
            ->whereIn('waon_class', $goo_wago_class)
            ->pluck('waon_id', 'waon_class')->toArray();

        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_fine_quantity as $key => $value) {
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_stock_fine_amount` - ' . $value;
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_lock_fine_amount` + ' . $value;
                $time_sql = $time_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $find_waon_data[$key] . ',';
            }
            $sql = $sql . ' `waon_stock_fine_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_fine_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_fine_res = DB::update($sql);
        } else {
            $waon_fine_res = true;
        }

        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_priority_quantity as $key => $value) {
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_stock_priority_amount` - ' . $value;
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN `waon_lock_priority_amount` + ' . $value;
                $time_sql = $time_sql . ' WHEN ' . $find_waon_data[$key] . ' THEN "' . date('Y-m-d H:i:s') . '"';

                $ids = $ids . $find_waon_data[$key] . ',';
            }
            $sql = $sql . ' `waon_stock_priority_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_priority_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_priority_res = DB::update($sql);
        } else {
            $waon_priority_res = true;
        }

        if ($update_wago_res && $waon_fine_res && $waon_priority_res) {
            return true;
        } else {
            return false;
        }
    }

    // 查询技师是否存在移动仓库
    public static function existMoveWarehouse($adm_id)
    {
        return DB::table('warehouse')
            ->where('ware_type', 2)
            ->where('ware_leader_id', $adm_id)
            ->value('ware_id');
    }

    /**
     * [repealAllocate 调拨单撤销]
     * @param  [type] $user_info      [用户信息]
     * @param  [type] $ware_id        [仓库id]
     * @param  [type] $find_trog_data [数组，调拨单商品数据]
     * @param  [type] $waon_id        [仓库类别表id]
     * @param  [type] $tror_state     [调拨单状态：2已通过/待出库3.已出库/待入库]
     * @return [type]                 [description]
     */
    public static function repealAllocate(
        $user_info,
        $ware_id,
        $find_trog_data,
        $waon_id,
        $tror_state
    ) {
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_fine_sql = ''; //良品库存数量（仓库+仓位）
        $lock_fine_sql = ''; //良品锁定数量（仓库+仓位）
        $stock_priority_sql = ''; //优先库存数量（仓库+仓位）
        $lock_priority_sql = ''; //优先锁定数量（仓库+仓位）
        $stock_amount_sql = ''; //仓库良品库存数量
        $lock_amount_sql = ''; //仓库良品锁定库存数量
        $priority_stock_amount_sql = ''; //仓库优先库存数量
        $priority_lock_amount_sql = ''; //仓库优先锁定数量
        $time_sql = '';
        $ids = '';

        $waon_class_fine_quantity = 0; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = 0; //仓库类别对应优先库存总数量
        $goo_key = 0;
        // 调拨单要出库的商品
        // 调出仓库商品表【良品/优先】锁定数量转正常数量，【良品/优先】库存数量增加，锁定数量减少，
        // 查询调拨单商品表数据
        $find_trog_datas = json_decode(json_encode($find_trog_data), true);
        $trog_wago_id = array_column($find_trog_datas, 'trog_wago_id');
        $warehouse_goods = DB::table('warehouse_goods')
            ->where('wago_ware_id', $ware_id)
            ->whereIn('wago_id', $trog_wago_id)
            ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_lock_quantity', 'wago_priority_stock_number', 'wago_priority_lock_quantity', 'wago_stock_amount', 'wago_lock_amount', 'wago_priority_stock_amount', 'wago_priority_lock_amount')
            ->get()->toArray();
        $warehouse_goods = array_column($warehouse_goods, null, 'wago_id');
        foreach ($find_trog_data as $key => $value) {
            // 良品
            if ($value->trog_stock_number > 0) {
                $surplus_quantity = $warehouse_goods[$value->trog_wago_id]->wago_lock_quantity - $value->trog_stock_number; //总的库存(仓库+仓位)
                $wago_quantity = $warehouse_goods[$value->trog_wago_id]->wago_lock_amount - $value->trog_stock_number; //仓库库存
                if ($surplus_quantity < 0 || $wago_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'锁定数量不足1'];
                }
                $goo_id[$goo_key] = $value->trog_goo_id; //商品id
                $goo_quantity[$goo_key] = $value->trog_stock_number; //商品数量
                $goo_inventory[$goo_key] = 1; //出库类型1良品2优先
                $goo_key++;
                // 更改总库存数量(仓库+仓位)
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_stock_number` + ' . $value->trog_stock_number;
                // 更改仓库良品库存数量
                $stock_amount_sql = $stock_amount_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_stock_amount` + ' . $value->trog_stock_number;
                if ($tror_state == 2) { // 待出库状态的撤销，更改锁定数量
                    $wago_lock_quantity = $value->trog_stock_number;
                } else { // 已出库状态的撤销，不更改锁定数量
                    // $wago_lock_quantity = 0;
                    $wago_lock_quantity = $value->trog_stock_number;
                }
                // 更改总锁定数量(仓库+仓位)
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_lock_quantity` - ' . $wago_lock_quantity;
                // 更改仓库良品锁定数量
                $lock_amount_sql = $lock_amount_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_lock_amount` - ' . $wago_lock_quantity;
                // 更改优先库存数量(仓库+仓位)
                $stock_priority_sql = $stock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_stock_number` - 0';
                // 更改优先库存数量
                $priority_stock_amount_sql = $priority_stock_amount_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_stock_amount` - 0';
                // 更改优先锁定数量(仓库+仓位)
                $lock_priority_sql = $lock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_lock_quantity` + 0';
                // 更改优先锁定数量
                $priority_lock_amount_sql = $priority_lock_amount_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_lock_amount` + 0';

                $waon_class_fine_quantity += $value->trog_stock_number; //仓库类别对应良品库存总数量
            }

            // 优先
            if ($value->trog_priority_stock_number > 0) {
                $surplus_quantity = $warehouse_goods[$value->trog_wago_id]->wago_priority_lock_quantity - $value->trog_priority_stock_number; //总的库存(仓库+仓位)
                $wago_quantity = $warehouse_goods[$value->trog_wago_id]->wago_priority_lock_amount - $value->trog_priority_stock_number; //仓库库存
                if ($surplus_quantity < 0 || $wago_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'锁定数量不足2'];
                }
                $goo_id[$goo_key] = $value->trog_goo_id; //商品id
                $goo_quantity[$goo_key] = $value->trog_priority_stock_number; //商品数量
                $goo_inventory[$goo_key] = 2; //出库类型1良品2优先
                $goo_key++;
                // 更改优先库存数量(仓库+仓位)
                $stock_priority_sql = $stock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_stock_number` + ' . $value->trog_priority_stock_number;
                // 更改优先库存数量
                $priority_stock_amount_sql = $priority_stock_amount_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_stock_amount` + ' . $value->trog_priority_stock_number;
                if ($tror_state == 2) { // 待出库状态的撤销，更改锁定数量
                    $wago_priority_lock_quantity = $value->trog_priority_stock_number;
                } else { // 已出库状态的撤销，不更改锁定数量
                    // $wago_priority_lock_quantity = 0;
                    $wago_priority_lock_quantity = $value->trog_priority_stock_number;
                }
                // 更改优先锁定数量(仓库+仓位)
                $lock_priority_sql = $lock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_lock_quantity` - ' . $wago_priority_lock_quantity;
                // 更改优先锁定数量
                $priority_lock_amount_sql = $priority_lock_amount_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_lock_amount` - ' . $wago_priority_lock_quantity;

                // 更改良品库存数量(仓库+仓位)
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_stock_number` - 0';
                // 更改良品库存数量
                $stock_amount_sql = $stock_amount_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_stock_amount` - 0';
                // 更改良品锁定数量(仓库+仓位)
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_lock_quantity`  + 0';
                // 更改良品锁定数量
                $lock_amount_sql = $lock_amount_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_lock_amount`  + 0';

                $waon_class_priority_quantity += $value->trog_priority_stock_number; //仓库类别对应优先库存总数量
            }
            $time_sql = $time_sql . ' WHEN ' . $value->trog_wago_id . ' THEN "' . date('Y-m-d H:i:s') . '"'; // 更改时间
            $ids = $ids . $value->trog_wago_id . ',';
        }
        // 2.1 固定仓商品表减锁定库存
        $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_fine_sql . ' END,'; //修改良品库存数量(仓库+仓位)
        $sql = $sql . ' `wago_lock_quantity`=  CASE `wago_id` ' . $lock_fine_sql . ' END,'; //修改良品锁定数量(仓库+仓位)
        $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $stock_priority_sql . ' END,'; //修改优先库存数量(仓库+仓位)
        $sql = $sql . ' `wago_priority_lock_quantity`=  CASE `wago_id` ' . $lock_priority_sql . ' END,'; //修改优先锁定数量(仓库+仓位)
        $sql = $sql . ' `wago_stock_amount`=  CASE `wago_id` ' . $stock_amount_sql . ' END,'; //修改良品库存数量
        $sql = $sql . ' `wago_lock_amount`=  CASE `wago_id` ' . $lock_amount_sql . ' END,'; //修改良品锁定数量
        $sql = $sql . ' `wago_priority_stock_amount`=  CASE `wago_id` ' . $priority_stock_amount_sql . ' END,'; //修改优先库存数量
        $sql = $sql . ' `wago_priority_lock_amount`=  CASE `wago_id` ' . $priority_lock_amount_sql . ' END,'; //修改优先锁定数量
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END'; //修改时间
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
        $wago_edit_res = DB::update($sql);

        // 修改仓库类别表库存数据
        $sql = 'UPDATE `faster_warehouse_onhand` SET ';
        $stock_fine_sql = '';
        $lock_fine_sql = '';
        $time_sql = '';
        $ids = '';
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_stock_fine_amount` + ' . $waon_class_fine_quantity;
            if ($tror_state == 2) { // 待出库状态的撤销，更改锁定数量
                $waon_lock_fine_amount = $waon_class_fine_quantity;
            } else { // 已出库状态的撤销，不更改锁定数量
                // $waon_lock_fine_amount = 0;
                $waon_lock_fine_amount = $waon_class_fine_quantity;
            }
            $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_lock_fine_amount` - ' . $waon_lock_fine_amount;
            $time_sql = $time_sql . ' WHEN ' . $waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

            $ids = $ids . $waon_id . ',';
            $sql = $sql . ' `waon_stock_fine_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_fine_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
        }
        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_stock_priority_amount` + ' . $waon_class_priority_quantity;
            if ($tror_state == 2) { // 待出库状态的撤销，更改锁定数量
                $waon_lock_priority_amount = $waon_class_priority_quantity;
            } else { // 已出库状态的撤销，不更改锁定数量
                // $waon_lock_priority_amount = 0;
                $waon_lock_priority_amount = $waon_class_priority_quantity;
            }
            $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_lock_priority_amount` - ' . $waon_lock_priority_amount;
            $time_sql = $time_sql . ' WHEN ' . $waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

            $ids = $ids . $waon_id . ',';
            $sql = $sql . ' `waon_stock_priority_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_priority_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
        }
        $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
        $sql = $sql . ' WHERE `waon_id` = (' . trim($ids, ',') . ')';
        $waon_priority_res = DB::update($sql);
        if ($waon_priority_res && $wago_edit_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'撤销成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'撤销失败'];
        }
    }

    /**
     * [appRepealAllocate app端调拨单撤销]
     * @param  [type] $user_info      [用户信息]
     * @param  [type] $ware_id        [仓库id]
     * @param  [type] $find_trog_data [数组，调拨单商品数据]
     * @param  [type] $waon_id        [仓库类别表id]
     * @param  [type] $tror_state     [调拨单状态：2已通过/待出库3.已出库/待入库]
     * @return [type]                 [description]
     */
    public static function appRepealAllocate(
        $user_info,
        $ware_id,
        $find_trog_data,
        $waon_id,
        $tror_state
    ) {
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $stock_fine_sql = '';
        $stock_priority_sql = '';
        $lock_fine_sql = '';
        $lock_priority_sql = '';
        $time_sql = '';
        $ids = '';

        $waon_class_fine_quantity = 0; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = 0; //仓库类别对应优先库存总数量
        $goo_key = 0;
        // 调拨单要出库的商品
        // 调出仓库商品表【良品/优先】锁定数量转正常数量，【良品/优先】库存数量增加，锁定数量减少，
        foreach ($find_trog_data as $key => $value) {
            // 良品
            if ($value->trog_stock_number > 0) {
                $goo_id[$goo_key] = $value->trog_goo_id; //商品id
                $goo_quantity[$goo_key] = $value->trog_stock_number; //商品数量
                $goo_inventory[$goo_key] = 1; //出库类型1良品2优先
                $goo_key++;
                // 更改库存数量
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_stock_number` + ' . $value->trog_stock_number;
                // 待出库状态的撤销，更改锁定数量
                if ($tror_state == 2) {
                    $wago_lock_quantity = $value->trog_stock_number;
                // 已出库状态的撤销，不更改锁定数量
                } else {
                    $wago_lock_quantity = 0;
                }
                // 更改锁定数量
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_lock_quantity` - ' . $wago_lock_quantity;
                // 更改库存数量
                $stock_priority_sql = $stock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_stock_number` - 0';
                // 更改锁定数量
                $lock_priority_sql = $lock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_lock_quantity` + 0';

                $waon_class_fine_quantity += $value->trog_stock_number; //仓库类别对应良品库存总数量
            }

            // 优先
            if ($value->trog_priority_stock_number > 0) {
                $goo_id[$goo_key] = $value->trog_goo_id; //商品id
                $goo_quantity[$goo_key] = $value->trog_priority_stock_number; //商品数量
                $goo_inventory[$goo_key] = 2; //出库类型1良品2优先
                $goo_key++;
                // 更改库存数量
                $stock_priority_sql = $stock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_stock_number` + ' . $value->trog_priority_stock_number;
                // 待出库状态的撤销，更改锁定数量
                if ($tror_state == 2) {
                    $wago_priority_lock_quantity = $value->trog_priority_stock_number;
                // 已出库状态的撤销，不更改锁定数量
                } else {
                    $wago_priority_lock_quantity = 0;
                }
                // 更改锁定数量
                $lock_priority_sql = $lock_priority_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_priority_lock_quantity` - ' . $wago_priority_lock_quantity;

                // 更改库存数量
                $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_stock_number` - 0';
                // 更改锁定数量
                $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $value->trog_wago_id . ' THEN `wago_lock_quantity`  + 0';

                $waon_class_priority_quantity += $value->trog_priority_stock_number; //仓库类别对应优先库存总数量
            }
            $time_sql = $time_sql . ' WHEN ' . $value->trog_wago_id . ' THEN "' . date('Y-m-d H:i:s') . '"'; // 更改时间
            $ids = $ids . $value->trog_wago_id . ',';
        }
        // 2.1 固定仓商品表减锁定库存
        $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $stock_fine_sql . ' END,'; //修改良品库存数量
        $sql = $sql . ' `wago_lock_quantity`=  CASE `wago_id` ' . $lock_fine_sql . ' END,'; //修改良品锁定数量
        $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $stock_priority_sql . ' END,'; //修改优先库存数量
        $sql = $sql . ' `wago_priority_lock_quantity`=  CASE `wago_id` ' . $lock_priority_sql . ' END,'; //修改优先锁定数量
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END'; //修改时间
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
        $wago_edit_res = DB::update($sql);

        // 修改仓库类别表库存数据
        $sql = 'UPDATE `faster_warehouse_onhand` SET ';
        $stock_fine_sql = '';
        $lock_fine_sql = '';
        $time_sql = '';
        $ids = '';
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_stock_fine_amount` + ' . $waon_class_fine_quantity;
            // 待出库状态的撤销，更改锁定数量
            if ($tror_state == 2) {
                $waon_lock_fine_amount = $waon_class_fine_quantity;
            // 已出库状态的撤销，不更改锁定数量
            } else {
                $waon_lock_fine_amount = 0;
            }
            $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_lock_fine_amount` - ' . $waon_lock_fine_amount;
            $time_sql = $time_sql . ' WHEN ' . $waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

            $ids = $ids . $waon_id . ',';
            $sql = $sql . ' `waon_stock_fine_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_fine_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
        }
        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_stock_priority_amount` + ' . $waon_class_priority_quantity;
            // 待出库状态的撤销，更改锁定数量
            if ($tror_state == 2) {
                $waon_lock_priority_amount = $waon_class_priority_quantity;
            // 已出库状态的撤销，不更改锁定数量
            } else {
                $waon_lock_priority_amount = 0;
            }
            $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_lock_priority_amount` - ' . $waon_lock_priority_amount;
            $time_sql = $time_sql . ' WHEN ' . $waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

            $ids = $ids . $waon_id . ',';
            $sql = $sql . ' `waon_stock_priority_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_priority_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
        }
        $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
        $sql = $sql . ' WHERE `waon_id` = (' . trim($ids, ',') . ')';
        $waon_priority_res = DB::update($sql);
        if ($waon_priority_res && $wago_edit_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'撤销成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'撤销失败'];
        }
    }

    /**
     * [obtain 判断赠品是否需要从货物仓调取]
     * @param  [type] $goo_inventory    [1良品2优先]
     * @param  [type] $goo_waon_class   [仓库类别]
     * @param  [type] $goo_id           [商品id]
     * @param  [type] $goo_quantity     [出库数量]
     * @param  [type] $ware_id          [仓库id]
     * @return [type] [description]     false
     */
    public static function obtain(
        $goo_inventory,
        $goo_waon_class,
        $goo_id,
        $goo_quantity,
        $goo_fid,
        $ware_id
    ) {
        if ($goo_fid == '0') {
            return $goo_id;
        }
        $warehouse_goods = DB::table('warehouse_goods as wg')
            ->where('wago_ware_id', $ware_id)
            ->where('wago_goo_id', $goo_id)
            ->where('wago_class', $goo_waon_class)
            ->first(['wago_stock_number', 'wago_priority_stock_number']);
        if ($goo_inventory == 1) {
            $num = $warehouse_goods->wago_stock_number - $goo_quantity;
            if ($num < 0) {
                $give_warehouse_goods = DB::table('warehouse_goods as wg')
                    ->join('goods as g', 'g.goo_id', '=', 'wg.wago_goo_id')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_class', 1)
                    ->where('goo_id', $goo_fid)
                    ->first(['wago_stock_number', 'goo_id', 'goo_price', 'goo_type']);
                if (empty($give_warehouse_goods)) {
                    return false;
                }
                $num = $give_warehouse_goods->wago_stock_number - $goo_quantity;
                if ($num < 0) {
                    return false;
                }
                return $give_warehouse_goods->goo_id;
            } else {
                return $goo_id;
            }
        } elseif ($goo_inventory == 2) {
            $num = $warehouse_goods->wago_priority_stock_number - $goo_quantity;
            if ($num < 0) {
                $give_warehouse_goods = DB::table('warehouse_goods as wg')
                    ->join('goods as g', 'g.goo_id', '=', 'wg.wago_goo_id')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_class', 1)
                    ->where('goo_fid', $goo_id)
                    ->first(['wago_priority_stock_number', 'goo_price', 'goo_name', 'goo_goods_encode', 'goo_id', 'goo_type']);
                if (empty($give_warehouse_goods)) {
                    return false;
                }
                $num = $give_warehouse_goods->wago_priority_stock_number - $goo_quantity;
                if ($num < 0) {
                    return false;
                }
                return $give_warehouse_goods->goo_id;
            } else {
                return $goo_id;
            }
        }
    }

    /**
     * [getRealStockGoods 获取真实出库的库存商品信息]
     * @param  [type] $goo_inventory  [1良品2优先]
     * @param  [type] $goo_waon_class [仓库类别]
     * @param  [type] $goo_id         [商品id]
     * @param  [type] $goo_quantity   [出库数量]
     * @param  [type] $goo_fid        [商品的父id]
     * @param  [type] $goo_state      [商品状态1正常2删除3回收的商品4换货商品5赠品商品6备用电池7临时商品8旧货商品]
     * @param  [type] $ware_id        [仓库id]
     * @return [type]                 [description]
     */
    public static function getRealStockGoods(
        $goo_inventory,
        $goo_waon_class,
        $goo_id,
        $goo_quantity,
        $goo_fid,
        $goo_state,
        $ware_id
    ) {
        // 获取商品所在仓库的库存数量
        $warehouse_goods = DB::table('warehouse_goods as wg')
            ->where('wago_ware_id', $ware_id)
            ->where('wago_goo_id', $goo_id)
            ->where('wago_class', $goo_waon_class)
            ->first(['wago_id', 'wago_stock_number', 'wago_priority_stock_number']);
        $real_stock_goods['real_goo_id'] = $goo_id; //真实出库的商品id
        $real_stock_goods['wago_id'] = $warehouse_goods->wago_id; //仓库商品id
        $real_stock_goods['wago_class'] = $goo_waon_class; //仓库类别
        // 判断是良品或优先出库
        if ($goo_inventory == 1) {
            // 判断仓库商品库存数量是否足够
            $num = $warehouse_goods->wago_stock_number - $goo_quantity;
        } else {
            $num = $warehouse_goods->wago_priority_stock_number - $goo_quantity;
        }

        if ($num < 0) {
            // 如果是赠品出库，赠品库存数量不足，就判断赠品对应的正常商品的库存数量
            if ($goo_state == 5) {
                // 查询仓库货物仓，赠品对应的正常商品id的库存数量
                $give_warehouse_goods = DB::table('warehouse_goods as wg')
                    ->where('wago_ware_id', $ware_id)
                    ->where('wago_goo_id', $goo_fid)
                    ->where('wago_class', 1)
                    ->first(['wago_id', 'wago_stock_number', 'wago_priority_stock_number']);
                if (empty($give_warehouse_goods)) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品数量不足'];
                }

                // 判断是良品或优先出库
                if ($goo_inventory == 1) {
                    // 判断仓库商品库存数量是否足够
                    $num = $give_warehouse_goods->wago_stock_number - $goo_quantity;
                } else {
                    $num = $give_warehouse_goods->wago_priority_stock_number - $goo_quantity;
                }
                if ($num < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品数量不足'];
                }

                // 正常商品库存数量足够
                $real_stock_goods['real_goo_id'] = $goo_fid; //真实出库的商品id
                $real_stock_goods['wago_id'] = $give_warehouse_goods->wago_id; //仓库商品id
                $real_stock_goods['wago_class'] = 1; //仓库类别
                return ['code'=>200, 'real_stock_goods'=>$real_stock_goods];
            } else {
                return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品数量不足'];
            }
        } else {
            return ['code'=>200, 'real_stock_goods'=>$real_stock_goods];
        }
    }

    /**
     * [orderLockInventory 生成订单锁定库存数量]
     * @param  [type] $user_info          [用户信息]
     * @param  [type] $ware_id            [数组，仓库商品id=>仓库id]
     * @param  [type] $wago_goo_id        [数组，仓库商品id=>商品id]
     * @param  [type] $wago_goo_quantity  [数组，仓库商品id=>商品数量]
     * @param  [type] $wago_goo_inventory [数组，仓库商品id=>库存扣除方式 1.良品 2.优先]
     * @param  [type] $wago_goo_class     [数组，仓库商品id=>仓库类别]
     * @param  [type] $wago_id            [数组，仓库商品id]
     * @return [type]                     [description]
     */
    public static function orderLockInventory(
        $user_info,
        $ware_id,
        $wago_goo_id,
        $wago_goo_quantity,
        $wago_goo_inventory,
        $wago_goo_class,
        $wago_id
    ) {
        // 查询仓库商品表的数据
        $warehouse_goods = DB::table('warehouse_goods')
            ->whereIn('wago_id', $wago_id)
            ->select('wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_stock_number', 'wago_priority_stock_number', 'wago_stock_amount', 'wago_priority_stock_amount')
            ->get()->toArray();
        $warehouse_goods_wago = array_column($warehouse_goods, null, 'wago_id');
        $wago_id_quantity = [];
        $waon_class_fine_quantity = []; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = []; //仓库类别对应优先库存总数量
        foreach ($wago_id as $key => $value) {
            $data['goo_inventory'] = $wago_goo_inventory[$value]; //良品、优先
            $data['goo_quantity'] = $wago_goo_quantity[$value]; //商品数量
            $data['wago_class'] = $wago_goo_class[$value]; //仓库类别
            $data['ware_id'] = $ware_id[$value]; //仓库id
            $data['wago_id'] = $value; //仓库商品id
            $wago_id_quantity[] = $data;
            // 统计仓库总的库存数量
            if ($data['goo_inventory'] == 1) {
                // 良品总数量
                if (isset($waon_class_fine_quantity[$data['ware_id']][$data['wago_class']])) {
                    $waon_class_fine_quantity[$data['ware_id']][$data['wago_class']] += $data['goo_quantity']; //仓库类别对应良品库存总数量
                } else {
                    $waon_class_fine_quantity[$data['ware_id']][$data['wago_class']] = $data['goo_quantity']; //仓库类别对应良品库存总数量
                }
            } else {
                // 优先总数量
                if (isset($waon_class_priority_quantity[$data['ware_id']][$data['wago_class']])) {
                    $waon_class_priority_quantity[$data['ware_id']][$data['wago_class']] += $data['goo_quantity']; //仓库类别对应优先库存总数量
                } else {
                    $waon_class_priority_quantity[$data['ware_id']][$data['wago_class']] = $data['goo_quantity']; //仓库类别对应优先库存总数量
                }
            }
            unset($data);
        }

        // 仓库商品表 减锁定库存数量 加原来的库存数量
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $fine_stock_number_sql = ''; //良品库存数量(仓库+仓位)
        $fine_lock_quantity_sql = ''; //良品锁定数量(仓库+仓位)
        $priority_stock_number_sql = ''; //优先库存数量(仓库+仓位)
        $priority_lock_quantity_sql = ''; //优先锁定数量(仓库+仓位)
        $stock_amount_sql = ''; //仓库良品库存数量
        $lock_amount_sql = ''; //仓库良品锁定库存数量
        $priority_stock_amount_sql = ''; //仓库优先库存数量
        $priority_lock_amount_sql = ''; //仓库优先锁定数量
        $time_sql = '';
        $ids = '';
        // 仓库库存数量
        foreach ($wago_id_quantity as $goo_id => $value) {
            if ($value['goo_inventory'] == 1) { // 商品出库类型，良品出库
                // 良品剩余库存数量
                $surplus_quantity = $warehouse_goods_wago[$value['wago_id']]->wago_stock_number - $value['goo_quantity'];
                if ($surplus_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品数量不足'];
                }
                // 良品库存数量(仓库+仓位)减少
                $fine_stock_number_sql = $fine_stock_number_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_stock_number` - ' . $value['goo_quantity'];
                // 良品锁定数量(仓库+仓位)增加
                $fine_lock_quantity_sql = $fine_lock_quantity_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_lock_quantity` + ' . $value['goo_quantity'];

                // 优先库存数量(仓库+仓位)
                $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_stock_number` - 0';
                // 优先锁定数量(仓库+仓位)
                $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_lock_quantity` + 0';

                // 仓库良品库存数量减少
                $stock_amount_sql = $stock_amount_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_stock_amount` - ' . $value['goo_quantity'];
                // 仓库良品锁定库存数量增加
                $lock_amount_sql = $lock_amount_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_lock_amount` + ' . $value['goo_quantity'];

                // 仓库优先库存数量
                $priority_stock_amount_sql = $priority_stock_amount_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_stock_amount` - 0';
                // 仓库优先锁定数量
                $priority_lock_amount_sql = $priority_lock_amount_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_lock_amount` + 0';
            } else { // 商品出库类型，优先出库
                // 优先剩余库存数量
                $surplus_quantity = $warehouse_goods_wago[$value['wago_id']]->wago_priority_stock_number - $value['goo_quantity'];
                if ($surplus_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品数量不足'];
                }
                // 良品库存数量(仓库+仓位)减少
                $fine_stock_number_sql = $fine_stock_number_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_stock_number` - 0';
                // 良品锁定数量(仓库+仓位)增加
                $fine_lock_quantity_sql = $fine_lock_quantity_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_lock_quantity` + 0';

                // 优先库存数量(仓库+仓位)减少
                $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_stock_number` - ' . $value['goo_quantity'];
                // 优先锁定数量(仓库+仓位)增加
                $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_lock_quantity` + ' . $value['goo_quantity'];

                // 仓库良品库存数量减少
                $stock_amount_sql = $stock_amount_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_stock_amount` - 0';
                // 仓库良品锁定库存数量增加
                $lock_amount_sql = $lock_amount_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_lock_amount` + 0';

                // 优先库存数量(仓库+仓位)减少
                $priority_stock_amount_sql = $priority_stock_amount_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_stock_amount` - ' . $value['goo_quantity'];
                // 优先锁定数量(仓库+仓位)增加
                $priority_lock_amount_sql = $priority_lock_amount_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_lock_amount` + ' . $value['goo_quantity'];
            }
            $time_sql = $time_sql . ' WHEN ' . $value['wago_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"'; // 更改时间
            $ids = $ids . $value['wago_id'] . ',';
        }
        $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $fine_stock_number_sql . ' END,'; //良品库存数量(仓库+仓位)
        $sql = $sql . ' `wago_lock_quantity`=  CASE `wago_id` ' . $fine_lock_quantity_sql . ' END,'; //良品锁定数量(仓库+仓位)
        $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $priority_stock_number_sql . ' END,'; //优先库存数量(仓库+仓位)
        $sql = $sql . ' `wago_priority_lock_quantity`=  CASE `wago_id` ' . $priority_lock_quantity_sql . ' END,'; //优先锁定数量(仓库+仓位)
        $sql = $sql . ' `wago_stock_amount`=  CASE `wago_id` ' . $stock_amount_sql . ' END,'; //仓库良品库存数量
        $sql = $sql . ' `wago_lock_amount`=  CASE `wago_id` ' . $lock_amount_sql . ' END,'; //仓库良品锁定库存数量
        $sql = $sql . ' `wago_priority_stock_amount`=  CASE `wago_id` ' . $priority_stock_amount_sql . ' END,'; //仓库优先库存数量
        $sql = $sql . ' `wago_priority_lock_amount`=  CASE `wago_id` ' . $priority_lock_amount_sql . ' END,'; //仓库优先锁定数量
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END';
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
        $update_wago_res = DB::update($sql);
        // 更改仓库总库存数量
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_fine_quantity as $ware_id => $waon_class_value) {
                foreach ($waon_class_value as $waon_class => $value) {
                    $waon_id = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $waon_class)
                        ->value('waon_id');
                    $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_stock_fine_amount` - ' . $value;
                    $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_lock_fine_amount` + ' . $value;
                    $time_sql = $time_sql . ' WHEN ' . $waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    $ids = $ids . $waon_id . ',';
                    unset($waon_id);
                }
            }
            $sql = $sql . ' `waon_stock_fine_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_fine_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_fine_res = DB::update($sql);
        } else {
            $waon_fine_res = true;
        }

        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_priority_quantity as $ware_id => $waon_class_value) {
                foreach ($waon_class_value as $waon_class => $value) {
                    $waon_id = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $waon_class)
                        ->value('waon_id');
                    $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_stock_priority_amount` - ' . $value;
                    $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_lock_priority_amount` + ' . $value;
                    $time_sql = $time_sql . ' WHEN ' . $waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    $ids = $ids . $waon_id . ',';
                    unset($waon_id);
                }
            }
            $sql = $sql . ' `waon_stock_priority_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_priority_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_priority_res = DB::update($sql);
        } else {
            $waon_priority_res = true;
        }

        if ($update_wago_res && $waon_fine_res && $waon_priority_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'库存锁定成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'仓库库存锁定失败'];
        }
    }

    /**
     * [orderCancelLockInventory 生成订单取消锁定库存数量]
     * @param  [type] $user_info          [用户信息]
     * @param  [type] $ware_id            [数组，仓库商品id=>仓库id]
     * @param  [type] $wago_goo_id        [数组，仓库商品id=>商品id]
     * @param  [type] $wago_goo_quantity  [数组，仓库商品id=>商品数量]
     * @param  [type] $wago_goo_inventory [数组，仓库商品id=>库存扣除方式 1.良品 2.优先]
     * @param  [type] $wago_goo_class     [数组，仓库商品id=>仓库类别]
     * @param  [type] $wago_id            [数组，仓库商品id]
     * @return [type]                     [description]
     */
    public static function orderCancelLockInventory(
        $user_info,
        $ware_id,
        $wago_goo_id,
        $wago_goo_quantity,
        $wago_goo_inventory,
        $wago_goo_class,
        $wago_id
    ) {
        // 查询仓库商品表的数据
        $warehouse_goods = DB::table('warehouse_goods')
            ->whereIn('wago_id', $wago_id)
            ->get(['wago_id', 'wago_ware_id', 'wago_class', 'wago_goo_id', 'wago_lock_quantity', 'wago_priority_lock_quantity'])
            ->toArray();
        $warehouse_goods_wago = array_column($warehouse_goods, null, 'wago_id');
        $wago_id_quantity = [];
        $waon_class_fine_quantity = []; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = []; //仓库类别对应优先库存总数量
        foreach ($wago_id as $key => $value) {
            $data['goo_inventory'] = $wago_goo_inventory[$value]; //良品、优先
            $data['goo_quantity'] = $wago_goo_quantity[$value]; //商品数量
            $data['wago_class'] = $wago_goo_class[$value]; //仓库类别
            $data['ware_id'] = $ware_id[$value]; //仓库id
            $data['wago_id'] = $value; //仓库商品id
            $wago_id_quantity[] = $data;
            // 统计仓库总的库存数量
            if ($data['goo_inventory'] == 1) {
                // 良品总数量
                if (isset($waon_class_fine_quantity[$data['ware_id']][$data['wago_class']])) {
                    $waon_class_fine_quantity[$data['ware_id']][$data['wago_class']] += $data['goo_quantity']; //仓库类别对应良品库存总数量
                } else {
                    $waon_class_fine_quantity[$data['ware_id']][$data['wago_class']] = $data['goo_quantity']; //仓库类别对应良品库存总数量
                }
            } else {
                // 优先总数量
                if (isset($waon_class_priority_quantity[$data['ware_id']][$data['wago_class']])) {
                    $waon_class_priority_quantity[$data['ware_id']][$data['wago_class']] += $data['goo_quantity']; //仓库类别对应优先库存总数量
                } else {
                    $waon_class_priority_quantity[$data['ware_id']][$data['wago_class']] = $data['goo_quantity']; //仓库类别对应优先库存总数量
                }
            }
            unset($data);
        }

        // 仓库商品表 减锁定库存数量 加原来的库存数量
        $sql = 'UPDATE `faster_warehouse_goods` SET ';
        $fine_stock_number_sql = '';
        $fine_lock_quantity_sql = '';
        $priority_stock_number_sql = '';
        $priority_lock_quantity_sql = '';
        $time_sql = '';
        $ids = '';
        // 仓库库存数量
        foreach ($wago_id_quantity as $goo_id => $value) {
            // 商品出库类型，良品出库
            if ($value['goo_inventory'] == 1) {
                // 良品剩余库存数量
                $surplus_quantity = $warehouse_goods_wago[$value['wago_id']]->wago_lock_quantity - $value['goo_quantity'];
                if ($surplus_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品锁定数量不足'];
                }
                // 良品库存数量减少
                $fine_stock_number_sql = $fine_stock_number_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_stock_number` + ' . $value['goo_quantity'];
                // 良品锁定数量增加
                $fine_lock_quantity_sql = $fine_lock_quantity_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_lock_quantity` - ' . $value['goo_quantity'];

                // 优先数量
                $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_stock_number` + 0';
                $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_lock_quantity` - 0';

            // 商品出库类型，优先出库
            } else {
                // 优先剩余库存数量
                $surplus_quantity = $warehouse_goods_wago[$value['wago_id']]->wago_priority_lock_quantity - $value['goo_quantity'];
                if ($surplus_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品锁定数量不足'];
                }
                // 良品库存数量增加
                $fine_stock_number_sql = $fine_stock_number_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_stock_number` + 0';
                // 良品锁定数量减少
                $fine_lock_quantity_sql = $fine_lock_quantity_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_lock_quantity` - 0';

                // 优先数量
                $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_stock_number` + ' . $value['goo_quantity'];
                $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $value['wago_id'] . ' THEN `wago_priority_lock_quantity` - ' . $value['goo_quantity'];
            }
            $time_sql = $time_sql . ' WHEN ' . $value['wago_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"'; // 更改时间
            $ids = $ids . $value['wago_id'] . ',';
        }
        $sql = $sql . ' `wago_stock_number`=  CASE `wago_id` ' . $fine_stock_number_sql . ' END,';
        $sql = $sql . ' `wago_lock_quantity`=  CASE `wago_id` ' . $fine_lock_quantity_sql . ' END,';
        $sql = $sql . ' `wago_priority_stock_number`=  CASE `wago_id` ' . $priority_stock_number_sql . ' END,';
        $sql = $sql . ' `wago_priority_lock_quantity`=  CASE `wago_id` ' . $priority_lock_quantity_sql . ' END,';
        $sql = $sql . ' `wago_update_time`=  CASE `wago_id` ' . $time_sql . ' END';
        $sql = $sql . ' WHERE `wago_id` IN (' . trim($ids, ',') . ')';
        $update_wago_res = DB::update($sql);
        // 更改仓库总库存数量
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_fine_quantity as $ware_id => $waon_class_value) {
                foreach ($waon_class_value as $waon_class => $value) {
                    $waon_id = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $waon_class)
                        ->value('waon_id');
                    $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_stock_fine_amount` + ' . $value;
                    $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_lock_fine_amount` - ' . $value;
                    $time_sql = $time_sql . ' WHEN ' . $waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    $ids = $ids . $waon_id . ',';
                    unset($waon_id);
                }
            }
            $sql = $sql . ' `waon_stock_fine_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_fine_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_fine_res = DB::update($sql);
        } else {
            $waon_fine_res = true;
        }

        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_priority_quantity as $ware_id => $waon_class_value) {
                foreach ($waon_class_value as $waon_class => $value) {
                    $waon_id = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $waon_class)
                        ->value('waon_id');
                    $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_stock_priority_amount` + ' . $value;
                    $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_lock_priority_amount` - ' . $value;
                    $time_sql = $time_sql . ' WHEN ' . $waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    $ids = $ids . $waon_id . ',';
                    unset($waon_id);
                }
            }
            $sql = $sql . ' `waon_stock_priority_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_priority_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_priority_res = DB::update($sql);
        } else {
            $waon_priority_res = true;
        }

        if ($update_wago_res && $waon_fine_res && $waon_priority_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'库存商品取消锁定成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'库存商品取消锁定失败'];
        }
    }

    /**
     * [orderFreightLockInventory 生成订单锁定仓位库存数量]
     * @param  [type] $user_info          [用户信息]
     * @param  [type] $ware_id            [数组，仓位商品id=>仓库id]
     * @param  [type] $wafg_goo_id        [数组，仓位商品id=>商品id]
     * @param  [type] $wafg_goo_quantity  [数组，仓位商品id=>商品数量]
     * @param  [type] $wafg_goo_inventory [数组，仓位商品id=>库存扣除方式 1.良品 2.优先]
     * @param  [type] $wafg_goo_class     [数组，仓位商品id=>仓库类别]
     * @param  [type] $wafg_id            [数组，仓位商品id]
     * @param  [type] $wafg_wago_id       [数组，仓位商品id=>仓库商品id]
     * @param  [type] $wafg_wafr_id       [数组，仓位商品id=>仓位id]
     * @return [type]                     [description]
     */
    public static function orderFreightLockInventory(
        $user_info,
        $ware_id,
        $wafg_goo_id,
        $wafg_goo_quantity,
        $wafg_goo_inventory,
        $wafg_goo_class,
        $wafg_id,
        $wafg_wago_id,
        $wafg_wafr_id
    ) {
        // 查询仓位商品表的数据
        $warehouse_freight_goods = DB::table('warehouse_freight_goods')
            ->whereIn('wafg_id', $wafg_id)
            ->get(['wafg_id', 'wafg_wafr_id', 'wafg_wago_id', 'wafg_ware_id', 'wafg_class', 'wafg_goo_id', 'wafg_stock_number', 'wafg_priority_stock_number'])
            ->toArray();
        $warehouse_freight_goods_wago = array_column($warehouse_freight_goods, null, 'wafg_id');
        $wafg_id_quantity = [];
        $waon_class_fine_quantity = []; //仓库类别对应良品库存总数量
        $waon_class_priority_quantity = []; //仓库类别对应优先库存总数量
        foreach ($wafg_id as $key => $value) {
            $data['goo_inventory'] = $wafg_goo_inventory[$value]; //良品、优先
            $data['goo_quantity'] = $wafg_goo_quantity[$value]; //商品数量
            $data['wago_class'] = $wafg_goo_class[$value]; //仓库类别
            $data['ware_id'] = $ware_id[$value]; //仓库id
            $data['wafg_id'] = $value; //仓位商品id
            $data['wafg_wago_id'] = $wafg_wago_id[$value]; //仓库商品id
            $data['wafg_wafr_id'] = $wafg_wafr_id[$value]; //仓位id
            $wafg_id_quantity[] = $data;
            // 统计仓库总的库存数量
            if ($data['goo_inventory'] == 1) {
                // 良品总数量
                if (isset($waon_class_fine_quantity[$data['ware_id']][$data['wago_class']])) {
                    $waon_class_fine_quantity[$data['ware_id']][$data['wago_class']] += $data['goo_quantity']; //仓库类别对应良品库存总数量
                } else {
                    $waon_class_fine_quantity[$data['ware_id']][$data['wago_class']] = $data['goo_quantity']; //仓库类别对应良品库存总数量
                }
            } else {
                // 优先总数量
                if (isset($waon_class_priority_quantity[$data['ware_id']][$data['wago_class']])) {
                    $waon_class_priority_quantity[$data['ware_id']][$data['wago_class']] += $data['goo_quantity']; //仓库类别对应优先库存总数量
                } else {
                    $waon_class_priority_quantity[$data['ware_id']][$data['wago_class']] = $data['goo_quantity']; //仓库类别对应优先库存总数量
                }
            }
            unset($data);
        }

        // 仓位商品表 减锁定库存数量 加原来的库存数量
        $sql = 'UPDATE `faster_warehouse_freight_goods` SET ';
        $fine_stock_number_sql = '';
        $fine_lock_quantity_sql = '';
        $priority_stock_number_sql = '';
        $priority_lock_quantity_sql = '';
        $time_sql = '';
        $ids = '';
        // 仓位库存数量
        foreach ($wafg_id_quantity as $goo_id => $value) {
            // 查询仓库商品表仓位的库存数量
            $find_wogo_data = DB::table('warehouse_goods')
                ->where('wago_id', $value['wafg_wago_id'])
                ->select('wago_freight_stock_number', 'wago_freight_lock_quantity', 'wago_freight_priority_stock_number', 'wago_freight_priority_lock_quantity')
                ->first();
            if ($value['goo_inventory'] == 1) { // 商品出库类型，良品出库
                // 良品剩余库存数量
                $surplus_quantity = $warehouse_freight_goods_wago[$value['wafg_id']]->wafg_stock_number - $value['goo_quantity'];
                if ($surplus_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓位内商品数量不足'];
                }
                // 良品库存数量减少
                $fine_stock_number_sql = $fine_stock_number_sql . ' WHEN ' . $value['wafg_id'] . ' THEN `wafg_stock_number` - ' . $value['goo_quantity'];
                // 良品锁定数量增加
                $fine_lock_quantity_sql = $fine_lock_quantity_sql . ' WHEN ' . $value['wafg_id'] . ' THEN `wafg_lock_quantity` + ' . $value['goo_quantity'];

                // 优先数量
                $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $value['wafg_id'] . ' THEN `wafg_priority_stock_number` - 0';
                $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $value['wafg_id'] . ' THEN `wafg_priority_lock_quantity` + 0';

                // 更改仓库商品表的仓位良品库存数量及锁定库存数量
                // 仓位的良品库存数量减少
                $edit_data['wago_freight_stock_number'] = $find_wogo_data->wago_freight_stock_number - $value['goo_quantity'];
                // 仓库的仓位良品锁定库存数量增加
                $edit_data['wago_freight_lock_quantity'] = $find_wogo_data->wago_freight_lock_quantity + $value['goo_quantity'];
                $edit_data['wago_update_time'] = date('Y-m-d H:i:s');
                // 仓位表良品库存数量减少
                $wafr_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value['wafg_wafr_id'])
                    ->decrement('wafr_all_stock', $value['goo_quantity']);
                // 仓位表良品锁定库存数量增加
                $wafr_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value['wafg_wafr_id'])
                    ->increment('wafr_lock_quantity', $value['goo_quantity']);
            } else { // 商品出库类型，优先出库
                // 优先剩余库存数量
                $surplus_quantity = $warehouse_freight_goods_wago[$value['wafg_id']]->wafg_priority_stock_number - $value['goo_quantity'];
                if ($surplus_quantity < 0) {
                    return ['code'=>500, 'msg'=>'error', 'data'=>'仓库内商品数量不足'];
                }
                // 良品库存数量增加
                $fine_stock_number_sql = $fine_stock_number_sql . ' WHEN ' . $value['wafg_id'] . ' THEN `wafg_stock_number` - 0';
                // 良品锁定数量减少
                $fine_lock_quantity_sql = $fine_lock_quantity_sql . ' WHEN ' . $value['wafg_id'] . ' THEN `wafg_lock_quantity` + 0';
                // 优先数量
                $priority_stock_number_sql = $priority_stock_number_sql . ' WHEN ' . $value['wafg_id'] . ' THEN `wafg_priority_stock_number` - ' . $value['goo_quantity'];
                $priority_lock_quantity_sql = $priority_lock_quantity_sql . ' WHEN ' . $value['wafg_id'] . ' THEN `wafg_priority_lock_quantity` + ' . $value['goo_quantity'];
                // 更改仓库商品表的仓位优先库存数量及锁定库存数量
                // 仓位的优先库存数量减少
                $edit_data['wago_freight_priority_stock_number'] = $find_wogo_data->wago_freight_priority_stock_number - $value['goo_quantity'];
                // 仓库的仓位优先锁定库存数量增加
                $edit_data['wago_freight_priority_lock_quantity'] = $find_wogo_data->wago_freight_priority_lock_quantity + $value['goo_quantity'];
                $edit_data['wago_update_time'] = date('Y-m-d H:i:s');
                // 仓位表良品库存数量减少
                $wafr_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value['wafg_wafr_id'])
                    ->decrement('wafr_priority_all_stock', $value['goo_quantity']);
                // 仓位表良品锁定库存数量增加
                $wafr_res = DB::table('warehouse_freight')
                    ->where('wafr_id', $value['wafg_wafr_id'])
                    ->increment('wafr_priority_lock_quantity', $value['goo_quantity']);
            }
            // 更改仓库商品表的仓位数量
            $update_wago_res = DB::table('warehouse_goods')
                ->where('wago_id', $value['wafg_wago_id'])
                ->update($edit_data);
            $time_sql = $time_sql . ' WHEN ' . $value['wafg_id'] . ' THEN "' . date('Y-m-d H:i:s') . '"'; // 更改时间
            $ids = $ids . $value['wafg_id'] . ',';
        }
        $sql = $sql . ' `wafg_stock_number`=  CASE `wafg_id` ' . $fine_stock_number_sql . ' END,';
        $sql = $sql . ' `wafg_lock_quantity`=  CASE `wafg_id` ' . $fine_lock_quantity_sql . ' END,';
        $sql = $sql . ' `wafg_priority_stock_number`=  CASE `wafg_id` ' . $priority_stock_number_sql . ' END,';
        $sql = $sql . ' `wafg_priority_lock_quantity`=  CASE `wafg_id` ' . $priority_lock_quantity_sql . ' END,';
        $sql = $sql . ' `wafg_update_time`=  CASE `wafg_id` ' . $time_sql . ' END';
        $sql = $sql . ' WHERE `wafg_id` IN (' . trim($ids, ',') . ')';
        $update_wago_res = DB::update($sql);
        // 更改仓库总库存数量
        // 良品库存总数量更改
        if ($waon_class_fine_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_fine_quantity as $ware_id => $waon_class_value) {
                foreach ($waon_class_value as $waon_class => $value) {
                    $waon_id = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $waon_class)
                        ->value('waon_id');
                    $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_stock_fine_amount` - ' . $value;
                    $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_lock_fine_amount` + ' . $value;
                    $time_sql = $time_sql . ' WHEN ' . $waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    $ids = $ids . $waon_id . ',';
                    unset($waon_id);
                }
            }
            $sql = $sql . ' `waon_stock_fine_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_fine_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_fine_res = DB::update($sql);
        } else {
            $waon_fine_res = true;
        }

        // 优先库存总数量更改
        if ($waon_class_priority_quantity) {
            $sql = 'UPDATE `faster_warehouse_onhand` SET ';
            $stock_fine_sql = '';
            $lock_fine_sql = '';
            $time_sql = '';
            $ids = '';
            foreach ($waon_class_priority_quantity as $ware_id => $waon_class_value) {
                foreach ($waon_class_value as $waon_class => $value) {
                    $waon_id = DB::table('warehouse_onhand')
                        ->where('waon_ware_id', $ware_id)
                        ->where('waon_class', $waon_class)
                        ->value('waon_id');
                    $stock_fine_sql = $stock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_stock_priority_amount` - ' . $value;
                    $lock_fine_sql = $lock_fine_sql . ' WHEN ' . $waon_id . ' THEN `waon_lock_priority_amount` + ' . $value;
                    $time_sql = $time_sql . ' WHEN ' . $waon_id . ' THEN "' . date('Y-m-d H:i:s') . '"';

                    $ids = $ids . $waon_id . ',';
                    unset($waon_id);
                }
            }
            $sql = $sql . ' `waon_stock_priority_amount`=  CASE `waon_id` ' . $stock_fine_sql . ' END,';
            $sql = $sql . ' `waon_lock_priority_amount`=  CASE `waon_id` ' . $lock_fine_sql . ' END,';
            $sql = $sql . ' `waon_update_time`=  CASE `waon_id` ' . $time_sql . ' END';
            $sql = $sql . ' WHERE `waon_id` IN (' . trim($ids, ',') . ')';
            $waon_priority_res = DB::update($sql);
        } else {
            $waon_priority_res = true;
        }
        if ($update_wago_res && $waon_fine_res && $waon_priority_res) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'仓位库存锁定成功'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'仓位库存锁定失败'];
        }
    }
}
