<?php

namespace App\Http\Models\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
class Supply extends Model
{
    /**
     * 补货方法
     * @param  $user_info    array      用户数据
     * @param  $goods_id     array      商品id
     * @param  $quantity     array      补货数量
     * @param  $goo_name     array      商品名称
     * @param  $goo_encode   array      检索编号
     * @param  $cate_name    array      分类名称
     * @param  $bra_name     array      商品品牌

     * @return boolean
     */
    public static function inventory(
        $user_info,
        $goods_id,
        $quantity,
        $goo_name,
        $goo_encode,
        $cate_name,
        $bra_name
    ){
        if (count($goods_id) != count($quantity)) {
            return false;
        }
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;
        //获取待补商品数据
        $regw_data = collect(DB::table('replenishment_goods_bs')
            ->whereIn('regb_goo_id',$goods_id)
            ->where('regb_shop_id',$user_info->adm_shop_id)
            ->get(['regb_stock_type','regb_stock_quantity','regb_goo_id']))
            ->keyBy('regb_goo_id')
            ->toArray();

        $goods_id_str = implode(',',$goods_id);
        $sql = 'UPDATE `faster_replenishment_goods_bs` SET ';
        $stock_quantity = '';//待补数量
        $enroute_amount = '';//在途数量
        $update_time = '';//修改时间
        $stock_type = '';//库存正负
        $ids = '';
        $insert_goo_name = [];
        foreach ($goods_id as $key => $value) {
            //如果待补商品里有此数据
            if(isset($regw_data[$value])){
                $num = $quantity[$value];
                // 判断库存是为负数
                if($regw_data[$value]->regb_stock_type == 3){
                    if($regw_data[$value]->regb_stock_quantity > $num){
                        //待补数量
                        $stock_quantity .= ' WHEN '.$value.' THEN `regb_stock_quantity` - '.$num;
                        $stock_type .= ' WHEN '.$value.' THEN 3';
                    }
                    if($regw_data[$value]->regb_stock_quantity == $num){
                        //待补数量
                        $stock_quantity .= ' WHEN '.$value.' THEN `regb_stock_quantity` - '.$num;
                        $stock_type .= ' WHEN '.$value.' THEN 1';
                    }
                    if($regw_data[$value]->regb_stock_quantity < $num){
                        $num = $num - $regw_data[$value]->regb_stock_quantity - $regw_data[$value]->regb_stock_quantity;
                        //待补数量
                        $stock_quantity .= ' WHEN '.$value.' THEN `regb_stock_quantity` + '.$num;
                        $stock_type .= ' WHEN '.$value.' THEN 2';
                    }
                //库存数量为平
                }else if($regw_data[$value]->regb_stock_type == 1){
                    //待补数量
                    $stock_quantity .= ' WHEN '.$value.' THEN `regb_stock_quantity` + '.$num;
                    $stock_type .= ' WHEN '.$value.' THEN 2';
                //库存数量为正
                }else if($regw_data[$value]->regb_stock_type == 2){
                    $stock_quantity .= ' WHEN '.$value.' THEN `regb_stock_quantity` + '.$num;
                    $stock_type .= ' WHEN '.$value.' THEN 2';
                }
                //在途数量
                $enroute_amount .= ' WHEN '.$value.' THEN `regb_enroute_amount` - '.$num;
                // 更改时间
                $update_time .= ' WHEN '.$value.' THEN "'.date('Y-m-d H:i:s').'"';
            }else{
                $insert_goo_name[$key]['regb_goo_id'] = $value;
                $insert_goo_name[$key]['regb_goo_name'] = $goo_name[$key];
                $insert_goo_name[$key]['regb_goo_encode'] = $goo_encode[$key];
                $insert_goo_name[$key]['regb_cate_name'] = $cate_name[$key];
                $insert_goo_name[$key]['regb_bra_name'] = $bra_name[$key];
                $insert_goo_name[$key]['regb_stock_quantity'] = $quantity[$value];
                $insert_goo_name[$key]['regb_stock_type'] = 2;
                $insert_goo_name[$key]['regb_shop_superior_id'] = $shop_id;
                $insert_goo_name[$key]['regb_shop_id'] = $user_info->adm_shop_id;
                $insert_goo_name[$key]['regb_cid'] = $user_info->adm_cid;
            }
        }
        if(!empty($stock_quantity)){
            $sql .= ' `regb_stock_quantity`=  CASE `regb_goo_id` '.$stock_quantity.' END,';
            if(!empty($stock_type)){
                $sql .= ' `regb_stock_type`=  CASE `regb_goo_id` '.$stock_type.' END,';
            }
            $sql .= ' `regb_enroute_amount`=  CASE `regb_goo_id` '.$enroute_amount.' END,';
            $sql .= ' `regb_update_time`=  CASE `regb_goo_id` '.$update_time.' END';
            $sql .= ' WHERE  `regb_goo_id` IN ('.trim($goods_id_str,',').') AND  `regb_shop_id` = '.$user_info->adm_shop_id;
            $rrgb_update = DB::update($sql);
            if(empty($rrgb_update)){
                return false;
            }
        }
        //待补商品里没有此商品新增
        if(!empty($insert_goo_name)){
            $insert_res = DB::table('replenishment_goods_bs')->insert($insert_goo_name);
            if(empty($insert_res)){
                return false;
            }
        }
        return true;
    }

    /**
     * 撤销补货方法
     * @param  $user_info    array      用户数据
     * @param  $rerb_id      array      送货单id
     * @return boolean
     */
    public static function revocation(
        $user_info,
        $rerb_id
    ){

        $rrgb_data = DB::table('replenish_record_goods_bs')
            ->where('rrgb_rerb_id',$rerb_id)
            ->get(['rrgb_goo_id','rrgb_actual_send_quantity']);

        $goods_id = [];//商品id
        $quantity = [];//已补送量
        $total_quantity = 0;//已补总送量
        foreach ($rrgb_data as $key => $value) {
            $goods_id[] = $value->rrgb_goo_id;
            $quantity[] = $value->rrgb_actual_send_quantity;
            $total_quantity += $value->rrgb_actual_send_quantity;
        }

        //获取待补商品数据
        $regw_data = collect(DB::table('replenishment_goods_bs')
            ->whereIn('regb_goo_id',$goods_id)
            ->where('regb_shop_id',$user_info->adm_shop_id)
            ->get(['regb_stock_type','regb_stock_quantity','regb_goo_id']))
            ->keyBy('regb_goo_id')
            ->toArray();

        $goods_id_str = implode(',',$goods_id);
        $sql = 'UPDATE `faster_replenishment_goods_bs` SET ';
        $stock_quantity = '';//待补数量
        $enroute_amount = '';//在途数量
        $update_time = '';//修改时间
        $stock_type = '';//库存正负
        $ids = '';
        foreach ($goods_id as $key => $value) {
            //如果待补商品里有此数据
            if(isset($regw_data[$value])){
                $num = $quantity[$key];
                // 判断待补数量是否为负数
                if($regw_data[$value]->regb_stock_type == 3){
                    $stock_quantity .= ' WHEN '.$value.' THEN `regb_stock_quantity` + '.$num;
                    $stock_type .= ' WHEN '.$value.' THEN 3';
                //库存数量为平
                }else if($regw_data[$value]->regb_stock_type == 1){
                    //待补数量
                    $stock_quantity .= ' WHEN '.$value.' THEN `regb_stock_quantity` + '.$num;
                    $stock_type .= ' WHEN '.$value.' THEN 3';
                //库存数量为正
                }else if($regw_data[$value]->regb_stock_type == 2){
                    if($regw_data[$value]->regb_stock_quantity > $num){
                        //待补数量
                        $stock_quantity .= ' WHEN '.$value.' THEN `regb_stock_quantity` - '.$num;
                        $stock_type .= ' WHEN '.$value.' THEN 2';
                    }
                    if($regw_data[$value]->regb_stock_quantity == $num){
                        //待补数量
                        $stock_quantity .= ' WHEN '.$value.' THEN `regb_stock_quantity` - '.$num;
                        $stock_type .= ' WHEN '.$value.' THEN 1';
                    }
                    if($regw_data[$value]->regb_stock_quantity < $num){
                        $num = $num - $regw_data[$value]->regb_stock_quantity - $regw_data[$value]->regb_stock_quantity;
                        //待补数量
                        $stock_quantity .= ' WHEN '.$value.' THEN `regb_stock_quantity` + '.$num;
                        $stock_type .= ' WHEN '.$value.' THEN 3';
                    }
                }
                //在途数量
                // $enroute_amount .= ' WHEN '.$value.' THEN `regb_enroute_amount` + '.$num;
                // 更改时间
                $update_time .= ' WHEN '.$value.' THEN "'.date('Y-m-d H:i:s').'"';
            }else{
                return false;
            }
        }
        if(!empty($stock_quantity)){
            $sql .= ' `regb_stock_quantity`=  CASE `regb_goo_id` '.$stock_quantity.' END,';
            if(!empty($stock_type)){
                $sql .= ' `regb_stock_type`=  CASE `regb_goo_id` '.$stock_type.' END,';
            }
            // $sql .= ' `regb_enroute_amount`=  CASE `regb_goo_id` '.$enroute_amount.' END,';
            $sql .= ' `regb_update_time`=  CASE `regb_goo_id` '.$update_time.' END';
            $sql .= ' WHERE  `regb_goo_id` IN ('.trim($goods_id_str,',').') AND  `regb_shop_id` = '.$user_info->adm_shop_id;
            $rrgb_update = DB::update($sql);
            if(empty($rrgb_update)){
                return false;
            }
        }
        return true;
    }
}
