<?php

namespace App\Http\Models\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
class StockingSelling extends Model
{
    /**
     * 进销存查询
     * @param  $user        array   用户数据
     * @param  $goods_id    array   商品id
     * @param  $num         array   数量
     * @param  $costing     array   金额
     * @param  $ware_id     int     仓库id
     * @param  $type        int     1=采入   2=销出  
     * @return boolean
     */
    public static function purchase($user,$goods_id,$num,$costing,$ware_id,$type)
    {
        if(count($goods_id) != count($num) || count($goods_id) != count($costing)){
            return false;
        }
        //门店id
        $shop_id = $user->shop_superior_id ? $user->shop_superior_id : $user->adm_shop_id;
        $year = date('Y');
        $month = date('m');
        //判断此仓库的类型
        $ware_data = DB::table('warehouse')
                ->where('ware_id',$ware_id)
                ->first(['ware_type','ware_superior_id']);
        //如果为移动仓,找到此移动仓上级的固定仓
        if($ware_data->ware_type == 2){
            //如果没有上级,找到默认仓库
            if(empty($ware_data->ware_superior_id)){
                $ware_id_mobile = DB::table('warehouse')
                    ->where('ware_cid',$user->adm_cid)
                    ->where('ware_superior_shop_id',$shop_id)
                    ->where('ware_default',2)
                    ->value('ware_id');
                if(!empty($ware_id_mobile)){
                    $ware_id = $ware_id_mobile;
                }
            }else{
                $ware_id = $ware_data->ware_superior_id;
            }
        }
        //商品品牌
        $goods = DB::table('goods')
                ->whereIn('goo_id',$goods_id)
                ->get(['goo_id','goo_name','goo_goods_encode','goo_bra_id']);
                // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $stse_id = DB::table('stocking_selling')
                        ->where('stse_cid',$user->adm_cid)
                        ->where('stse_shop_id',$user->adm_shop_id)
                        ->where('stse_year',$year)
                        ->where('stse_month',$month)
                        ->where('stse_ware_id',$ware_id)
                        ->value('stse_id');
                        // ->first(['stse_id']);
        $last_month = $month -1;
        //如果上个月是一月份
        if($last_month == 0){
            $last_month = 12;
            $last_year = $year - 1;
        }else{
            $last_year = $year;
        }
        //采购入库
        if($type == 1)
        {
            if(empty($stse_id)){
                //获取上个月期末库存和数量
                $stock = DB::table('stocking_selling')
                    ->where('stse_cid',$user->adm_cid)
                    ->where('stse_superior_id',$shop_id)
                    ->where('stse_ware_id',$ware_id)
                    ->where('stse_year',$last_year)
                    ->where('stse_month',$last_month)
                    ->first(['stse_closing_stock','stse_closing_cost']);
                //门店名称
                $shop_store_name =DB::table('shop')->where('shop_id',$user->adm_shop_id)->value('shop_store_name');
                //仓库名称
                $ware_name =DB::table('warehouse')->where('ware_id',$ware_id)->value('ware_name');
                $data['stse_cid'] = $user->adm_cid;//公司id
                $data['stse_shop_id'] = $user->adm_shop_id;//公司id
                $data['stse_superior_id'] = $shop_id;//所属总店id
                $data['stse_shop_name'] = $shop_store_name;//所属名称
                $data['stse_year'] = $year;//年份
                $data['stse_month'] = $month;//月
                $data['stse_ware_id'] = $ware_id;//仓库id
                $data['stse_ware_name'] = $ware_name;//仓库名称
                $data['stse_ware_in'] = array_sum($num);//入库数量
                $data['stse_ware_out'] = 0;//出库数量
                $data['stse_initial_stock'] = (isset($stock->stse_closing_stock) ? $stock->stse_closing_stock : 0) + array_sum($num);//期初库存
                $data['stse_closing_stock'] = array_sum($num);//期末库存
                $data['stse_initial_cost'] = isset($stock->stse_closing_cost) ? $stock->stse_closing_cost:0;//期初成本
                $data['stse_closing_cost'] = array_sum($costing);//期末成本
                $stse_id = DB::table('stocking_selling')->insertGetid($data);
            }else{
                $answer = DB::table('stocking_selling')->where('stse_id',$stse_id)->update(['stse_ware_in'=>DB::raw('stse_ware_in + '.array_sum($num)),'stse_closing_stock'=>DB::raw('stse_closing_stock + '.array_sum($num)),'stse_closing_cost'=>DB::raw('stse_closing_cost + '.array_sum($costing))]);
                if(empty($answer)){
                    return false;
                }
            }
            foreach ($goods as $key => $value) {
                // $gather = [];
                $stse_info = DB::table('stocking_selling_goods')
                                ->where('sego_cid',$user->adm_cid)
                                ->where('sego_shop_id',$user->adm_shop_id)
                                ->where('sego_goo_id',$value->goo_id)
                                ->where('sego_stse_id',$stse_id)
                                ->where('sego_ware_id',$ware_id)
                                ->first(['sego_id','sego_costing','sego_in_num']);
                if(empty($stse_info)){
                    //获取上个月的期末成本
                   $lasts_month = DB::table('stocking_selling as ss')
                            ->join('stocking_selling_goods as ssg','ssg.sego_stse_id','=','ss.stse_id')
                            ->where('stse_cid',$user->adm_cid)
                            ->where('stse_shop_id',$user->adm_shop_id)
                            ->where('stse_year',$last_year)
                            ->where('stse_month',$last_month)
                            ->where('sego_goo_id',$value->goo_id)
                            ->where('sego_ware_id',$ware_id)
                            ->first(['sego_closing_inventory','sego_costing']);

                    $data_info['sego_cid'] = $user->adm_cid;//公司id
                    $data_info['sego_shop_id'] = $user->adm_shop_id;//当前账号门店id
                    $data_info['sego_superior_shop_id'] = $shop_id;//id
                    $data_info['sego_bra_id'] = $value->goo_bra_id;//商品品牌id
                    $data_info['sego_goo_id'] = $value->goo_id;//商品id
                    $data_info['sego_goo_name'] = $value->goo_name;//商品名称
                    $data_info['sego_goo_encode'] = $value->goo_goods_encode;//检索编号
                    $data_info['sego_initial_inventory'] = (isset($lasts_month->sego_closing_inventory) ? $lasts_month->sego_closing_inventory:0) + $num[$key];//初期库存
                    $data_info['sego_early_costing'] = isset($lasts_month->sego_costing) ? $lasts_month->sego_costing:0;//初期成本
                    $data_info['sego_costing'] = $costing[$key];//入库成本
                    $data_info['sego_in_num'] = $num[$key];//入库数量
                    $data_info['sego_out_num'] = 0;//出库数量
                    $data_info['sego_closing_inventory'] = $num[$key];//期末库存
                    $data_info['sego_stse_id'] = $stse_id;//关联id
                    $data_info['sego_ware_id'] = $ware_id;//仓库id
                    // array_push($gather,$data_info);
                     $res = DB::table('stocking_selling_goods')->insert($data_info);
                }else{
                    //本次收入前成本
                    $initial_charge =  ($stse_info->sego_costing * $stse_info->sego_in_num + $costing[$key] * $num[$key]) / ($stse_info->sego_in_num + $num[$key]);
                    // $initial_charge = $initial_charge * 100;
                    $res = DB::table('stocking_selling_goods')->where('sego_id',$stse_info->sego_id)->update(['sego_costing'=>$initial_charge,'sego_in_num'=>DB::raw('sego_in_num + '.$num[$key]),'sego_closing_inventory'=>DB::raw('sego_closing_inventory + '.$num[$key])]);
                    if(empty($res)){
                        return false;
                    }
                }
            }
        }
        //销售出库
        if($type == 2)
        {
            if(empty($stse_id)){
                //获取期末库存和数量
                $stock = DB::table('stocking_selling')->where('stse_ware_id',$ware_id)->where('stse_year',$last_year)->where('stse_month',$last_month)->first(['stse_closing_stock','stse_closing_cost']);
                //门店名称
                $shop_store_name =DB::table('shop')->where('shop_id',$user->adm_shop_id)->value('shop_store_name');
                //仓库名称
                $ware_name =DB::table('warehouse')->where('ware_id',$ware_id)->value('ware_name');
                $data['stse_cid'] = $user->adm_cid;//公司id
                $data['stse_shop_id'] = $user->adm_shop_id;//公司id
                $data['stse_superior_id'] = $shop_id;//所属总店id
                $data['stse_shop_name'] = $shop_store_name;//所属名称
                $data['stse_year'] = $year;//年份
                $data['stse_month'] = $month;//月
                $data['stse_ware_id'] = $ware_id;//仓库id
                $data['stse_ware_name'] = $ware_name;//仓库名称
                $data['stse_ware_in'] = 0;//入库数量
                $data['stse_ware_out'] = array_sum($num);//出库数量
                $data['stse_initial_stock'] = (isset($stock->stse_closing_stock) ? $stock->stse_closing_stock :0) + array_sum($num);//期初库存
                $data['stse_closing_stock'] = -(array_sum($num) + $stock->stse_closing_stock);//期末库存
                $data['stse_initial_cost'] = isset($stock->stse_closing_cost) ? $stock->stse_closing_cost:0;//期初成本
                $data['stse_closing_cost'] = array_sum($costing);//期末成本
                $stse_id = DB::table('stocking_selling')->insertGetid($data);
            }else{
                $answer = DB::table('stocking_selling')->where('stse_id',$stse_id)->update(['stse_ware_out'=>DB::raw('stse_ware_out + '.array_sum($num)),'stse_closing_stock'=>DB::raw('stse_closing_stock - '.array_sum($num)),'stse_closing_cost'=>DB::raw('stse_closing_cost - '.array_sum($costing))]);
                if(empty($answer)){
                    return false;
                }
            }
            foreach ($goods as $key => $value) {
                // $costing[$key] = $costing[$key] * 100;
                $gather = [];
                $stse_info = DB::table('stocking_selling_goods')
                                ->where('sego_cid',$user->adm_cid)
                                ->where('sego_shop_id',$user->adm_shop_id)
                                ->where('sego_goo_id',$value->goo_id)
                                ->where('sego_stse_id',$stse_id)
                                ->where('sego_ware_id',$ware_id)
                                ->first(['sego_id','sego_costing','sego_out_num']);
                if(empty($stse_info)){
                    //获取上个月的期末成本
                   $lasts_month = DB::table('stocking_selling as ss')
                            ->join('stocking_selling_goods as ssg','ssg.sego_stse_id','=','ss.stse_id')
                            ->where('stse_cid',$user->adm_cid)
                            ->where('stse_shop_id',$user->adm_shop_id)
                            ->where('stse_year',$last_year)
                            ->where('stse_month',$last_month)
                            ->where('sego_goo_id',$value->goo_id)
                            ->where('sego_ware_id',$ware_id) 
                            ->first(['sego_closing_inventory','sego_costing']);

                    $data_info['sego_cid'] = $user->adm_cid;//公司id
                    $data_info['sego_shop_id'] = $user->adm_shop_id;//当前账号门店id
                    $data_info['sego_superior_shop_id'] = $shop_id;//id
                    $data_info['sego_bra_id'] = $value->goo_bra_id;//商品品牌id
                    $data_info['sego_goo_id'] = $value->goo_id;//商品id
                    $data_info['sego_goo_name'] = $value->goo_name;//商品名称
                    $data_info['sego_goo_encode'] = $value->goo_goods_encode;//检索编号
                    $data_info['sego_initial_inventory'] = (isset($lasts_month->sego_closing_inventory) ? $lasts_month->sego_closing_inventory:0) + $num[$key];//初期库存
                    $data_info['sego_early_costing'] = isset($lasts_month->sego_costing) ? $lasts_month->sego_costing:0;//初期成本
                    $data_info['sego_costing'] = $costing[$key];//成本
                    $data_info['sego_in_num'] = 0;//入库数量
                    $data_info['sego_out_num'] = $num[$key];//出库数量
                    $data_info['sego_closing_inventory'] = $num[$key];//期末库存
                    $data_info['sego_stse_id'] = $stse_id;//关联id
                    $data_info['sego_ware_id'] = $ware_id;//仓库id
                    // array_push($gather,$data_info);
                     $res = DB::table('stocking_selling_goods')->insert($data_info);
                }else{ 
                    //本次收入前成本
                    // $initial_charge =  ($stse_info->sego_costing * $stse_info->sego_out_num - $costing[$key] * $num[$key]) / ($stse_info->sego_out_num - $num[$key]);
                    $res = DB::table('stocking_selling_goods')->where('sego_id',$stse_info->sego_id)->update(['sego_out_num'=>DB::raw('sego_out_num + '.$num[$key]),'sego_closing_inventory'=>DB::raw('sego_closing_inventory - '.$num[$key])]);
                    if(empty($res)){
                        return false;
                    }
                }
            }
        }
        return true;
    }
    /**
     * 获取当前月份商品成本价
     * @param  $ware_id    int   仓库id
     * @param  $good_id    int   商品id
     */
    public static function costPrice($ware_id,$good_id){
        $year = date('Y');
        $month = date('m');
        $res = DB::table('stocking_selling as a')
            ->leftjoin('stocking_selling_goods as b','b.sego_stse_id','=','a.stse_id')
            ->where('stse_year',$year)
            ->where('stse_month',$month)
            ->where('sego_ware_id',$ware_id)
            ->where('sego_goo_id',$good_id)
            ->value('sego_costing');
        if(empty($res)){
            return 0;
        }
        return $res;
    }

    public static function purchase2($user,$goods_id,$num,$costing,$ware_id,$type)
    {
        if(count($goods_id) != count($num) || count($goods_id) != count($costing)){
            return false;
        }
        //门店id
        $shop_id = $user->shop_superior_id ? $user->shop_superior_id : $user->adm_shop_id;
        $year = date('Y');
        $month = date('m');
        //判断此仓库的类型
        $ware_data = DB::table('warehouse')
                ->where('ware_id',$ware_id)
                ->first(['ware_type','ware_superior_id']);
        //如果为移动仓,找到此移动仓上级的固定仓
        if($ware_data->ware_type == 2){
            //如果没有上级,找到默认仓库
            if(empty($ware_data->ware_superior_id)){
                $ware_id_mobile = DB::table('warehouse')
                    ->where('ware_cid',$user->adm_cid)
                    ->where('ware_superior_shop_id',$shop_id)
                    ->where('ware_default',2)
                    ->value('ware_id');
                if(!empty($ware_id_mobile)){
                    $ware_id = $ware_id_mobile;
                }
            }else{
                $ware_id = $ware_data->ware_superior_id;
            }
        }
        //商品品牌
        $goods = DB::table('goods')
                ->whereIn('goo_id',$goods_id)
                ->get(['goo_id','goo_name','goo_goods_encode','goo_bra_id']);
                // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $stse_id = DB::table('stocking_selling')
                        ->where('stse_cid',$user->adm_cid)
                        ->where('stse_shop_id',$user->adm_shop_id)
                        ->where('stse_year',$year)
                        ->where('stse_month',$month)
                        ->where('stse_ware_id',$ware_id)
                        ->value('stse_id');
                        // ->first(['stse_id']);
        $last_month = $month -1;
        //如果上个月是一月份
        if($last_month == 0){
            $last_month = 12;
            $last_year = $year - 1;
        }else{
            $last_year = $year;
        }
        //采购入库
        if($type == 1)
        {
            if(empty($stse_id)){
                //获取上个月期末库存和数量
                // $stock = DB::table('stocking_selling')->where('stse_year',$last_year)->where('stse_month',$last_month)->first(['stse_closing_stock','stse_closing_cost']);
                $stock = DB::table('stocking_selling')
                    ->where('stse_cid',$user->adm_cid)
                    ->where('stse_superior_id',$shop_id)
                    ->where('stse_ware_id',$ware_id)
                    ->where('stse_year',$last_year)
                    ->where('stse_month',$last_month)
                    ->first(['stse_closing_stock','stse_closing_cost']);
                //门店名称
                $shop_store_name =DB::table('shop')->where('shop_id',$user->adm_shop_id)->value('shop_store_name');
                //仓库名称
                $ware_name =DB::table('warehouse')->where('ware_id',$ware_id)->value('ware_name');
                $data['stse_cid'] = $user->adm_cid;//公司id
                $data['stse_shop_id'] = $user->adm_shop_id;//公司id
                $data['stse_superior_id'] = $shop_id;//所属总店id
                $data['stse_shop_name'] = $shop_store_name;//所属名称
                $data['stse_year'] = $year;//年份
                $data['stse_month'] = $month;//月
                $data['stse_ware_id'] = $ware_id;//仓库id
                $data['stse_ware_name'] = $ware_name;//仓库名称
                $data['stse_ware_in'] = 0;//入库数量
                $data['stse_ware_out'] = 0;//出库数量
                $data['stse_initial_stock'] = array_sum($num);//期初库存
                $data['stse_closing_stock'] = array_sum($num);//期末库存
                $data['stse_initial_cost'] = isset($stock->stse_closing_cost) ? $stock->stse_closing_cost:0;//期初成本
                $data['stse_closing_cost'] = array_sum($costing);//期末成本
                $stse_id = DB::table('stocking_selling')->insertGetid($data);
            }else{
                $answer = DB::table('stocking_selling')->where('stse_id',$stse_id)->update(['stse_ware_in'=>DB::raw('stse_ware_in + '.array_sum($num)),'stse_closing_stock'=>DB::raw('stse_closing_stock + '.array_sum($num)),'stse_closing_cost'=>DB::raw('stse_closing_cost + '.array_sum($costing))]);
                if(empty($answer)){
                    return false;
                }
            }
            foreach ($goods as $key => $value) {
                // $gather = [];
                $stse_info = DB::table('stocking_selling_goods')
                                ->where('sego_cid',$user->adm_cid)
                                ->where('sego_shop_id',$user->adm_shop_id)
                                ->where('sego_goo_id',$value->goo_id)
                                ->where('sego_stse_id',$stse_id)
                                ->where('sego_ware_id',$ware_id)
                                ->first(['sego_id','sego_costing','sego_in_num']);
                if(empty($stse_info)){
                    //获取上个月的期末成本
                   $lasts_month = DB::table('stocking_selling as ss')
                            ->join('stocking_selling_goods as ssg','ssg.sego_stse_id','=','ss.stse_id')
                            ->where('stse_cid',$user->adm_cid)
                            ->where('stse_shop_id',$user->adm_shop_id)
                            ->where('stse_year',$last_year)
                            ->where('stse_month',$last_month)
                            ->where('sego_goo_id',$value->goo_id)
                            ->where('sego_ware_id',$ware_id)
                            ->first(['stse_closing_cost','stse_closing_stock']);

                    $data_info['sego_cid'] = $user->adm_cid;//公司id
                    $data_info['sego_shop_id'] = $user->adm_shop_id;//当前账号门店id
                    $data_info['sego_superior_shop_id'] = $shop_id;//id
                    $data_info['sego_bra_id'] = $value->goo_bra_id;//商品品牌id
                    $data_info['sego_goo_id'] = $value->goo_id;//商品id
                    $data_info['sego_goo_name'] = $value->goo_name;//商品名称
                    $data_info['sego_goo_encode'] = $value->goo_goods_encode;//检索编号
                    $data_info['sego_initial_inventory'] = $num[$key];//初期库存
                    $data_info['sego_early_costing'] = isset($lasts_month->stse_closing_cost) ? $lasts_month->stse_closing_cost:0;//初期成本
                    $data_info['sego_costing'] = $costing[$key];//入库成本
                    $data_info['sego_in_num'] = 0;//入库数量
                    $data_info['sego_out_num'] = 0;//出库数量
                    $data_info['sego_closing_inventory'] = $num[$key];//期末库存
                    $data_info['sego_stse_id'] = $stse_id;//关联id
                    $data_info['sego_ware_id'] = $ware_id;//仓库id
                    // array_push($gather,$data_info);
                     $res = DB::table('stocking_selling_goods')->insert($data_info);
                }else{
                    //本次收入前成本
                    $initial_charge =  ($stse_info->sego_costing * $stse_info->sego_in_num + $costing[$key] * $num[$key]) / ($stse_info->sego_in_num + $num[$key]);
                    // $initial_charge = $initial_charge * 100;
                    $res = DB::table('stocking_selling_goods')->where('sego_id',$stse_info->sego_id)->update(['sego_costing'=>$initial_charge,'sego_in_num'=>DB::raw('sego_in_num + '.$num[$key]),'sego_closing_inventory'=>DB::raw('sego_closing_inventory + '.$num[$key])]);
                    if(empty($res)){
                        return false;
                    }
                }
            }
        }
        //销售出库
        if($type == 2)
        {
            if(empty($stse_id)){
                //获取期末库存和数量
                $stock = DB::table('stocking_selling')->where('stse_year',$last_year)->where('stse_month',$last_month)->first(['stse_closing_stock','stse_closing_cost']);
                //门店名称
                $shop_store_name =DB::table('shop')->where('shop_id',$user->adm_shop_id)->value('shop_store_name');
                //仓库名称
                $ware_name =DB::table('warehouse')->where('ware_id',$ware_id)->value('ware_name');
                $data['stse_cid'] = $user->adm_cid;//公司id
                $data['stse_shop_id'] = $user->adm_shop_id;//公司id
                $data['stse_superior_id'] = $shop_id;//所属总店id
                $data['stse_shop_name'] = $shop_store_name;//所属名称
                $data['stse_year'] = $year;//年份
                $data['stse_month'] = $month;//月
                $data['stse_ware_id'] = $ware_id;//仓库id
                $data['stse_ware_name'] = $ware_name;//仓库名称
                $data['stse_ware_in'] = 0;//入库数量
                $data['stse_ware_out'] = array_sum($num);//出库数量
                $data['stse_initial_stock'] = isset($stock->stse_closing_stock) ? $stock->stse_closing_stock :0;//期初库存
                $data['stse_closing_stock'] = -array_sum($num);//期末库存
                $data['stse_initial_cost'] = isset($stock->stse_closing_cost) ? $stock->stse_closing_cost:0;//期初成本
                $data['stse_closing_cost'] = array_sum($costing);//期末成本
                $stse_id = DB::table('stocking_selling')->insertGetid($data);
            }else{
                $answer = DB::table('stocking_selling')->where('stse_id',$stse_id)->update(['stse_ware_out'=>DB::raw('stse_ware_out + '.array_sum($num)),'stse_closing_stock'=>DB::raw('stse_closing_stock - '.array_sum($num)),'stse_closing_cost'=>DB::raw('stse_closing_cost - '.array_sum($costing))]);
                if(empty($answer)){
                    return false;
                }
            }
            foreach ($goods as $key => $value) {
                // $costing[$key] = $costing[$key] * 100;
                $gather = [];
                $stse_info = DB::table('stocking_selling_goods')
                                ->where('sego_cid',$user->adm_cid)
                                ->where('sego_shop_id',$user->adm_shop_id)
                                ->where('sego_goo_id',$value->goo_id)
                                ->where('sego_stse_id',$stse_id)
                                ->where('sego_ware_id',$ware_id)
                                ->first(['sego_id','sego_costing','sego_out_num']);
                if(empty($stse_info)){
                    //获取上个月的期末成本
                   $lasts_month = DB::table('stocking_selling as ss')
                            ->join('stocking_selling_goods as ssg','ssg.sego_stse_id','=','ss.stse_id')
                            ->where('stse_cid',$user->adm_cid)
                            ->where('stse_shop_id',$user->adm_shop_id)
                            ->where('stse_year',$last_year)
                            ->where('stse_month',$last_month)
                            ->where('sego_goo_id',$value->goo_id)
                            ->where('sego_ware_id',$ware_id)
                            ->first(['stse_closing_cost','stse_closing_stock']);

                    $data_info['sego_cid'] = $user->adm_cid;//公司id
                    $data_info['sego_shop_id'] = $user->adm_shop_id;//当前账号门店id
                    $data_info['sego_superior_shop_id'] = $shop_id;//id
                    $data_info['sego_bra_id'] = $value->goo_bra_id;//商品品牌id
                    $data_info['sego_goo_id'] = $value->goo_id;//商品id
                    $data_info['sego_goo_name'] = $value->goo_name;//商品名称
                    $data_info['sego_goo_encode'] = $value->goo_goods_encode;//检索编号
                    $data_info['sego_initial_inventory'] = isset($lasts_month->stse_closing_stock) ? $lasts_month->stse_closing_stock:0;//初期库存
                    $data_info['sego_early_costing'] = isset($lasts_month->stse_closing_cost) ? $lasts_month->stse_closing_cost:0;//初期成本
                    // $data_info['sego_costing'] = $costing[$key];//成本
                    $data_info['sego_in_num'] = 0;//入库数量
                    $data_info['sego_out_num'] = $num[$key];//出库数量
                    $data_info['sego_closing_inventory'] = $num[$key];//期末库存
                    $data_info['sego_stse_id'] = $stse_id;//关联id
                    $data_info['sego_ware_id'] = $ware_id;//仓库id
                    // array_push($gather,$data_info);
                     $res = DB::table('stocking_selling_goods')->insert($data_info);
                }else{
                    //本次收入前成本
                    // $initial_charge =  ($stse_info->sego_costing * $stse_info->sego_out_num - $costing[$key] * $num[$key]) / ($stse_info->sego_out_num - $num[$key]);
                    $res = DB::table('stocking_selling_goods')->where('sego_id',$stse_info->sego_id)->update(['sego_out_num'=>DB::raw('sego_out_num + '.$num[$key]),'sego_closing_inventory'=>DB::raw('sego_closing_inventory - '.$num[$key])]);
                    if(empty($res)){
                        return false;
                    }
                }
            }
        }
        // DB::commit(); 
        return true;
    }
}
