<?php

namespace App\Http\Models\Api;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Model;
use PhpOffice\PhpSpreadsheet\Spreadsheet;

class export extends Model
{

    /**
     * 导出
     * @param [type] $path    [路径]
     * @param [type] $where   [where条件]
     * @param [type] $data    [导出数据]
     */
    public static  function publicExport($path,$where,$data)
    {
        $letter = [];
        $num=count($data[0]);

        for ($i=0; $i < $num; $i++) {
            if($i<26){
                $letter[]=chr(65 + $i);
            }else{
                $letter[]=chr(64 + ($i / 26)) . chr(65 + $i % 26);
            }
        }
        $highest_row = '';
        if (is_file($path)){
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($path);//如果文件存在则直接载入
            $sheet = $spreadsheet->getActiveSheet();//获取活动的工作sheet
            $highest_row = $sheet->getHighestRow(); // 取得总行数
        }else{
            $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();//文件不存在则实例化一个新的文件
            $sheet = $spreadsheet->getActiveSheet();//获取工作表
            $sheet->setTitle($where['action_name']);  //设置当前sheet的标题
            $title = $where['field_name'];
            foreach ($title as $key => $value) {
                $sheet->setCellValue($letter[$key].'1',$value."\t");
                //$spreadsheet->getActiveSheet()->getColumnDimension($letter[$key])->setAutoSize(true);
                $spreadsheet->getActiveSheet()->getColumnDimension($letter[$key])->setWidth(25);
            }
        }
        $i = $highest_row ? $highest_row : 1;//开始行数
        foreach ($data as $key => $value) {
            $j = 0;
            foreach ($value as $k => $v) {
                if( $v && strpos($v,'=') === 0 ){
                    $v = "'".$v;
                }
                $sheet->setCellValue($letter[$j].($i+1), $v."\t");
                $sheet->getStyle($letter[$j])->getAlignment()->setHorizontal('center');
                $sheet->getStyle($letter[$j])->getAlignment()->setWrapText(true);//设置文字自动换行，要用
                $j++;
            }
            $i++;
        }

        $obj_Writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet,'Xls');
        header("Content-type: application/vnd.ms-excel; charset=UTF-8");
        header("Content-Type: application/force-download");
        header("Content-Type: application/octet-stream");
        header("Content-Type: application/download");
        header('Content-Disposition:inline;filename="'.$path.'"');
        header("Content-Transfer-Encoding: binary");
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Pragma: no-cache");
        $obj_Writer->save($path);
    }

        /**
     * 导出
     * @param [type] $path    [路径]
     * @param [type] $where   [where条件]
     * @param [type] $data    [导出数据]
     */
    public static  function newpublicExport($path,$where,$where1,$data)
    {
        $letter = [];
        $num=count($data[0]);
        $num=65;

        for ($i=0; $i < $num; $i++) {
            if($i<26){
                $letter[]=chr(65 + $i);
            }else{
                $letter[]=chr(64 + ($i / 26)) . chr(65 + $i % 26);
            }
        }
        $highest_row = '';
        if (is_file($path)){
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($path);//如果文件存在则直接载入
            $sheet = $spreadsheet->getActiveSheet();//获取活动的工作sheet
            $highest_row = $sheet->getHighestRow(); // 取得总行数
        }else{
            $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();//文件不存在则实例化一个新的文件
            $sheet = $spreadsheet->getActiveSheet();//获取工作表
            $styleArray = [ 'alignment' => [ 'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, ], ]; 
            $sheet->getStyle('A1')->applyFromArray($styleArray);
            $sheet->getStyle('J1')->applyFromArray($styleArray);
            $sheet->getStyle('M1')->applyFromArray($styleArray);
            $sheet->getStyle('P1')->applyFromArray($styleArray);
            $sheet->getStyle('U1')->applyFromArray($styleArray);
            $sheet->getStyle('Z1')->applyFromArray($styleArray);
            $sheet->getStyle('AE1')->applyFromArray($styleArray);
            $sheet->getStyle('AJ1')->applyFromArray($styleArray);
            $sheet->getStyle('AO1')->applyFromArray($styleArray);
            $sheet->getStyle('AT1')->applyFromArray($styleArray);
            $sheet->getStyle('AV1')->applyFromArray($styleArray);
            $sheet->getStyle('AY1')->applyFromArray($styleArray);
            $sheet->getStyle('BB1')->applyFromArray($styleArray);
            $sheet->getStyle('BE1')->applyFromArray($styleArray);
            $sheet->getStyle('BH1')->applyFromArray($styleArray);
            $sheet->getStyle('BK1')->applyFromArray($styleArray);

            $spreadsheet->getActiveSheet()->mergeCells('A1:I1');
            $spreadsheet->getActiveSheet()->mergeCells('J1:L1');
            $spreadsheet->getActiveSheet()->mergeCells('M1:O1');
            $spreadsheet->getActiveSheet()->mergeCells('P1:T1');
            $spreadsheet->getActiveSheet()->mergeCells('U1:Y1');
            $spreadsheet->getActiveSheet()->mergeCells('Z1:AD1');
            $spreadsheet->getActiveSheet()->mergeCells('AE1:AI1');
            $spreadsheet->getActiveSheet()->mergeCells('AJ1:AN1');
            $spreadsheet->getActiveSheet()->mergeCells('AO1:AS1');
            $spreadsheet->getActiveSheet()->mergeCells('AT1:AU1');
            $spreadsheet->getActiveSheet()->mergeCells('AV1:AX1');
            $spreadsheet->getActiveSheet()->mergeCells('AY1:BA1');
            $spreadsheet->getActiveSheet()->mergeCells('BB1:BD1');
            $spreadsheet->getActiveSheet()->mergeCells('BE1:BG1');
            $spreadsheet->getActiveSheet()->mergeCells('BH1:BJ1');
            $spreadsheet->getActiveSheet()->mergeCells('BK1:BM1');
            $sheet->setCellValue('A1','基本信息'."\t");
            $sheet->setCellValue('J1','会员信息'."\t");
            $sheet->setCellValue('M1','车主信息'."\t");
            $sheet->setCellValue('P1','产品1'."\t");
            $sheet->setCellValue('U1','产品2'."\t");
            $sheet->setCellValue('Z1','产品3'."\t");
            $sheet->setCellValue('AE1','产品4'."\t");
            $sheet->setCellValue('AJ1','产品5'."\t");
            $sheet->setCellValue('AO1','服务信息'."\t");
            $sheet->setCellValue('AT1','施工信息'."\t");
            $sheet->setCellValue('AV1','组长'."\t");
            $sheet->setCellValue('AY1','组员1'."\t");
            $sheet->setCellValue('BB1','组员2'."\t");
            $sheet->setCellValue('BE1','组员3'."\t");
            $sheet->setCellValue('BH1','组员4'."\t");
            $sheet->setCellValue('BK1','组员5'."\t");
            $sheet->setTitle($where['action_name']);  //设置当前sheet的标题
            $title = $where1['field_name'];
            foreach ($title as $key => $value) {
                $sheet->setCellValue($letter[$key].'2',$value."\t");
                $spreadsheet->getActiveSheet()->getColumnDimension($letter[$key])->setWidth(25);
            }
        }
        $i = $highest_row ? $highest_row : 1;//开始行数
        foreach ($data as $key => $value) {
            $j = 0;
            foreach ($value as $k => $v) {
                if( $v && strpos($v,'=') === 0 ){
                    $v = "'".$v;
                }
                $sheet->setCellValue($letter[$j].($i+2), $v."\t");
                $j++;
            }
            $i++;
        }

        $obj_Writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet,'Xls');
        header("Content-type: application/vnd.ms-excel; charset=UTF-8");
        header("Content-Type: application/force-download");
        header("Content-Type: application/octet-stream");
        header("Content-Type: application/download");
        header('Content-Disposition:inline;filename="'.$path.'"');
        header("Content-Transfer-Encoding: binary");
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Pragma: no-cache");
        $obj_Writer->save($path);
    }

    public static  function createExport($path,$where,$data)
    {
        $letter = [];
        $num=count($where['field_name']);

        for ($i=0; $i < $num; $i++) {
            if($i<26){
                $letter[]=chr(65 + $i);
            }else{
                $letter[]=chr(64 + ($i / 26)) . chr(65 + $i % 26);
            }
        }
        $highest_row = '';
        if (is_file($path)){
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($path);//如果文件存在则直接载入
            $sheet = $spreadsheet->getActiveSheet();//获取活动的工作sheet
            $highest_row = $sheet->getHighestRow(); // 取得总行数
        }else{
            $spreadsheet = new \PhpOffice\PhpSpreadsheet\Spreadsheet();//文件不存在则实例化一个新的文件
            $sheet = $spreadsheet->getActiveSheet();//获取工作表
            $sheet->setTitle($where['action_name']);  //设置当前sheet的标题
            $title = $where['field_name'];
            foreach ($title as $key => $value) {
                $sheet->setCellValue($letter[$key].'1',$value."\t");
                $spreadsheet->getActiveSheet()->getColumnDimension($letter[$key])->setAutoSize(true);
            }
        }
        $i = $highest_row ? $highest_row : 1;//开始行数
        foreach ($data as $key => $value) {
            $j = 0;
            foreach ($value as $k => $v) {
                if( $v && strpos($v,'=') === 0 ){
                    $v = "'".$v;
                }
                $sheet->setCellValue($letter[$j].($i+1), $v."\t");
                $j++;
            }
            $i++;
        }

        $obj_Writer = \PhpOffice\PhpSpreadsheet\IOFactory::createWriter($spreadsheet,'Xls');
        header("Content-type: application/vnd.ms-excel; charset=UTF-8");
        header("Content-Type: application/force-download");
        header("Content-Type: application/octet-stream");
        header("Content-Type: application/download");
        header('Content-Disposition:inline;filename="'.$path.'"');
        header("Content-Transfer-Encoding: binary");
        header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
        header("Cache-Control: must-revalidate, post-check=0, pre-check=0");
        header("Pragma: no-cache");
        $obj_Writer->save($path);
    }
}
