<?php
namespace App\Http\Models\Api;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class AccountingSettlement extends Model
{

    /**
     * 添加结款明细记录
     * @param [type] $user_info                [用户信息]
     * @param [type] $acset_type               [单据类型1订单2订单账单3工单账单4采购账单5销售账单6预收款]
     * @param [type] $acset_original_id        [与单据类型对应的id]
     * @param [type] $acset_original_number    [与单据类型对应的单号]
     * @param [type] $acset_client_type        [买家类型1门店零售2来往单位]
     * @param [type] $acset_client_id          [会员/客户id]
     * @param [type] $acset_client_name        [来往单位名称]
     * @param [type] $acset_acti_id            [会计科目id]
     * @param [type] $acset_inex_type          [类型1收入2支出]
     * @param [type] $acset_actual_price       [实际金额]
     * @param [type] $acset_price              [合计金额]
     * @param [type] $acset_owe_price          [欠收金额]
     * @param [type] $acset_zero_price         [抹零金额]
     * @param [type] $acset_remark             [备注]
     * @param [type] $acset_payment_type       [结款类型1.抹零 2.分期结款 3.预收款抵账4正常]
     * @param [type] $acset_with_time          [结款时间]
     */
    public static function add(
        $user_info,
        $acset_type,
        $acset_original_id,
        $acset_original_number,
        $acset_client_type,
        $acset_client_id,
        $acset_client_name,
        $acset_acti_id,
        $acset_inex_type,
        $acset_actual_price,
        $acset_price,
        $acset_owe_price,
        $acset_zero_price,
        $acset_remark,
        $acset_payment_type=0,
        $acset_with_time='',
        $acset_merge_type = 1
    ) {
        // 判断是否为加盟店账号,shop_superior_id 为0 是总店，不为0，是总店id或加盟店id
        $shop_id = $user_info->shop_superior_id ? $user_info->shop_superior_id : $user_info->adm_shop_id;

        // 结款明细表新增数据
        $record['acset_adm_cid'] = $user_info->adm_cid; //公司id
        $record['acset_shop_id'] = $user_info->adm_shop_id; //门店id
        $record['acset_superior_shop_id'] = $shop_id; //所属总店id
        $record['acset_adm_id'] = $user_info->adm_id; //结款人
        $record['acset_number'] = 'JK'.rand(100, 999).time().rand(10000, 99999); //    结款明细单号
        $record['acset_type'] = $acset_type; //单据类型1订单2订单账单3工单账单4采购账单5销售账单6预收款
        $record['acset_payment_type'] = $acset_payment_type; //结款类型1.抹零 2.分期结款 3.预收款抵账4正常
        $record['acset_original_id'] = $acset_original_id; //与单据类型对应的id
        $record['acset_original_number'] = $acset_original_number; //与单据类型对应的单号
        $record['acset_client_type'] = $acset_client_type; //买家类型1门店零售2来往单位
        $record['acset_client_id'] = $acset_client_id; //会员id
        $record['acset_client_name'] = $acset_client_name; //来往单位名称
        $record['acset_with_time'] = $acset_with_time ? $acset_with_time : date('Y-m-d H:i:s'); //结款时间
        $record['acset_acti_id'] = $acset_acti_id; //会计科目id
        $record['acset_inex_type'] = $acset_inex_type; //类型1收入2支出
        $record['acset_actual_price'] = $acset_actual_price; //实际金额
        $record['acset_price'] = $acset_price; //合计金额
        $record['acset_owe_price'] = $acset_owe_price; //欠收金额
        $record['acset_zero_price'] = $acset_zero_price; //抹零金额
        $record['acset_remark'] = $acset_remark; //备注
        $record['acset_update_time'] = date('Y-m-d H:i:s'); //修改时间
        $record['acset_merge_type'] = $acset_merge_type; //修改时间
        $record_add = DB::table('accounting_settlement')->insertGetId($record);
        if ($record_add) {
            return $record_add;
        } else {
            return false;
        }
    }
    
    /**
     * [accountVoucher 结款明细确认上传凭证]
     * @param  [type]  $user_info       [用户信息]
     * @param  [type]  $search_data [查询的结款明细数据]
     * @param  [type]  $request_voucher [凭证需要的数据]
     * @return [type]                   [description]
     */
    public static function accountVoucher($user_info, $search_data, $request_voucher)
    {
        // 调用u8系统接口，将凭证数据传到用友系统上，需要传的凭证
        /*
            acset_type 单据类型1订单结算2订单账单3工单账单4采购账单5销售账单6预收款7采购入库单现金8预付款9订单代收10采购入库单预付款11订单退款12工单代收13订单完成后结算14非实物开单15.订单冲单16.加盟店订单收款17.加盟店订单代收18.工单结算19.旧货回收20售后单结算21销售出库单22采购单23采购退货单24采购款到发货(预付款)

            收款确认时  借：银行存款   贷：对应的科目
            付款确认时  借：对应科目   贷：银行存款
                货物入库时：
                    借：库存商品
                    贷：应付账款-货款
                付款时：
                    借：应付账款-货款
                    贷：银行存款
        */
        $voucher_price = $request_voucher['voucher_price'];//凭证金额
        $vou_voucher_id = $search_data['acset_id'];//凭证所对应的id：结款明细id
        $vou_voucher_number = $search_data['acset_number'];//凭证对应的单号：流水号

        $voucher_price = $request_voucher['voucher_price'];
        // dump($search_data);
        // dump($request_voucher);
        // dump($voucher_price);
        // die;
        // 根据银行账号id,查询对应的名称
        if (empty($request_voucher['recr_acti_id'])) {
            $request_voucher['recr_acti_id']=$search_data['acset_acti_id'];
        }
        $find_acti_data = DB::table('account_title')
            ->where('acti_id', $request_voucher['recr_acti_id'])
            ->where('acti_shop_id', $user_info->adm_shop_id)
            ->select('acti_subject_code', 'acti_course_title')
            ->first();
        switch ($search_data['acset_type']) {
            case '1'://1订单结算,收款；借：库存现金或银行存款 贷：应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($search_data['acset_zero_price'] == '0') {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    }
                } else {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                        }
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                        }
                    }
                }
                break;
            case '2'://2订单账单,收款；借：库存现金或银行存款 贷：应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if (!empty($find_acti_data)) {
                    if ($search_data['acset_zero_price'] == '0') {
                        if ($search_data['acset_inex_type'] == '2') {
                            $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                            $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                            $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                        }
                    } else {
                        if ($search_data['acset_inex_type'] == '2') {
                            $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                            $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                            if ($search_data['acset_zero_plus_minus'] == '1') {
                                $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                            }
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                            $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                            if ($search_data['acset_zero_plus_minus'] == '1') {
                                $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                            }
                        }
                    }
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = '';//借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = '';//借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = 0;//借方金额
                    $volo_data[0]['acsl_loan_subject'] = '';//贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '';//贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = '';//贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                    $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                }
                break;
            case '3'://3工单账单,收款；借：库存现金或银行存款 贷：应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if (!empty($find_acti_data)) {
                    if ($search_data['acset_zero_price'] == '0') {
                        if ($search_data['acset_inex_type'] == '2') {
                            $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                            $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                            $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                        }
                    } else {
                        if ($search_data['acset_inex_type'] == '2') {
                            $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                            $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                            if ($search_data['acset_zero_plus_minus'] == '1') {
                                $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                            }
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                            $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                            if ($search_data['acset_zero_plus_minus'] == '1') {
                                $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                            } else {
                                $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                            }
                        }
                    }
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = '';//借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = '';//借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = 0;//借方金额
                    $volo_data[0]['acsl_loan_subject'] = '';//贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '';//贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = '';//贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                    $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                }
                break;
            case '4'://4.采购账单
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：应付账款500，贷：银行存款505，贷：主营业务收入-5）
                if ($search_data['acset_zero_price'] == '0') {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '220201';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应付账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '220201';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应付账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    }
                } else {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '220201';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应付账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '640101';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '主营业务成本';//借方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_borrow_price'] = '-' . $search_data['acset_zero_price'] / 100;//借方金额
                        } else {
                            $volo_data[1]['acsl_borrow_price'] = $search_data['acset_zero_price'] / 100;//借方金额
                        }
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '220201';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应付账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '640101';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '主营业务成本';//借方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_borrow_price'] = $search_data['acset_zero_price'] / 100;//借方金额
                        } else {
                            $volo_data[1]['acsl_borrow_price'] = '-' . $search_data['acset_zero_price'] / 100;//借方金额
                        }
                        $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    }
                }
                break;
            case '6'://6预收款,收款；借：库存现金或银行存款 贷：应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($search_data['acset_zero_price'] == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                    $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                    $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                    if ($search_data['acset_zero_plus_minus'] == '1') {
                        $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                    } else {
                        $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                    }
                }
                break;
            case '9'://9订单代收,借：库存现金或银行存款 贷：应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($search_data['acset_zero_price'] == '0') {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    }
                } else {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                        }
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                        }
                    }
                }
                break;
            case '11'://11订单退款,借:应收账款 贷:库存现金或银行存款
                $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                break;
            case '12'://12工单代收,收款；借：库存现金或银行存款  贷：应收账款
                if ($search_data['acset_zero_price'] == '0') {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    }
                } else {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                        }
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                        }
                    }
                }
                break;
            case '13'://13订单完成后结算,收款；借：库存现金或银行退款 贷：应收账款
                if ($search_data['acset_zero_price'] == '0') {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    }
                } else {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                        }
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                        } else {
                            $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                        }
                    }
                }
                break;
            case '16'://16.加盟店订单收款,借:库存现金或银行存款,贷:应收账款(加盟店)
                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                break;
            case '17'://17.加盟店订单代收,借:应收账款（加盟店）,贷:应收账款（委托方）
                // 收到加盟店转来代收款时，借：库存现金或银行存款  贷：应收账款（加盟店）
                $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                break;
            case '18'://18工单结算-工单费用, 付款；借：库存现金或银行存款 贷：应收账款(加盟店)
                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                break;
            case '19'://19.旧货回收,借:库存商品,贷:应收账款
                $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                break;
            case '20'://20.售后单结算,借:库存现金或银行存款,贷:应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($search_data['acset_zero_price'] == '0') {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                    $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                    $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                    $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                    if ($search_data['acset_zero_plus_minus'] == '1') {
                        $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                    } else {
                        $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                    }
                }
                break;
            case '22'://22采购单,付款；借：应付账款-货款    贷：银行存款
                $volo_data[0]['acsl_borrow_subject'] = '220201';//借方科目
                $volo_data[0]['acsl_borrow_subject_name'] = '应付账款';//借方科目名称
                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                break;
            case '23'://23.采购退货单,借:应付账款,贷:库存商品
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if ($search_data['acset_zero_price'] == '0') {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '220201';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应付账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = '220201';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应付账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    }
                } else {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '220201';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应付账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '640101';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '主营业务成本';//借方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_borrow_price'] = $search_data['acset_zero_price'] / 100;//借方金额
                        } else {
                            $volo_data[1]['acsl_borrow_price'] = '-' . $search_data['acset_zero_price'] / 100;//借方金额
                        }
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = '220201';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应付账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '640101';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '主营业务成本';//借方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_borrow_price'] = $search_data['acset_zero_price'] / 100;//借方金额
                        } else {
                            $volo_data[1]['acsl_borrow_price'] = '-' . $search_data['acset_zero_price'] / 100;//借方金额
                        }
                        $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    }
                }
                break;
            case '24'://24.采购款到发货,借:应付账款,贷:库存商品
                if ($search_data['acset_zero_price'] == '0') {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '220201';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应付账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '220201';
                        ;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应付账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    }
                } else {
                    if ($search_data['acset_inex_type'] == '2') {
                        $volo_data[0]['acsl_borrow_subject'] = '220201';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '应付账款';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '640101';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '主营业务成本';//借方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_borrow_price'] = $search_data['acset_zero_price'] / 100;//借方金额
                        } else {
                            $volo_data[1]['acsl_borrow_price'] = '-' . $search_data['acset_zero_price'] / 100;//借方金额
                        }
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '220201';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '应付账款';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        if ($search_data['acset_zero_plus_minus'] == '1') {
                            $volo_data[1]['acsl_borrow_price'] = $search_data['acset_zero_price'] / 100;//借方金额
                        } else {
                            $volo_data[1]['acsl_borrow_price'] = '-' . $search_data['acset_zero_price'] / 100;//借方金额
                        }
                        $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    }
                }
                break;
            case '25'://25.批量结算借：库存现金或银行存款，贷：应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                if (!empty($find_acti_data)) {
                    $list_data = DB::table('money_record as mr')
                        ->leftjoin('order_bill as ob', 'ob.orbi_id', '=', 'mr.more_orbi_id')
                        ->leftjoin('admin as a', 'a.adm_id', '=', 'ob.orbi_create_adm_id')
                        ->where('more_acset_id', $search_data['acset_id'])
                        ->where(function ($query) use ($search_data) {
                            if (!empty($search_data['orbi_number'])) {
                                $query->where('orbi_number', 'like', '%'.$search_data['orbi_number'].'%');
                            }
                        })
                        ->select('orbi_number', 'adm_name', 'more_state', 'orbi_actual_price as orbi_bill_price', 'orbi_plus_minus', 'more_this_settle_price', 'orbi_remark')
                        ->orderBy('more_id', 'desc')
                        ->get()->toArray();
                    $money = 0;
                    $cz_type = false;
                    foreach ($list_data as $key => $value) {
                        // 账单编号前两位字母
                        $orbi_number_type = substr($value->orbi_number, 0, 2);
                        if ($orbi_number_type == 'DZ' && $value->orbi_plus_minus == 1) {//1订单账单  orbi_plus_minus 金额正负：1正值2负值 实收金额的正负
                            $orbi_plus_minus = 1;
                            $orbi_bill_price = abs($value->more_this_settle_price);
                        } elseif ($orbi_number_type == 'DZ' && $value->orbi_plus_minus == 2) {
                            $orbi_plus_minus = 2;
                            $orbi_bill_price = -abs($value->more_this_settle_price);
                        }
                        if ($orbi_number_type == 'QC') {//期初账单
                            if ($value->orbi_remark == '期初应收' || $value->orbi_remark == '期初铺货') {
                                $orbi_type = 1;
                                $orbi_bill_price = abs($value->more_this_settle_price);
                            } elseif ($value->orbi_remark == '期初应付') {
                                $orbi_type = 2;
                                $orbi_bill_price = -abs($value->more_this_settle_price);
                            }
                        }
                        if ($orbi_number_type == 'CZ') {
                            $orbi_bill_price = -abs($value->more_this_settle_price);
                            $cz_type = true;
                        }
                        if ($orbi_number_type == 'GZ') {
                            $orbi_bill_price = -abs($value->more_this_settle_price);
                            $cz_type = true;
                        }
                        $money += $orbi_bill_price;
                    }
                    if ($search_data['acset_inex_type'] == '1') {//类型1收入2支出
                        if ($search_data['acset_zero_price'] == '0') {
                            if ($search_data['acset_inex_type'] == '2' || $money < 0) {
                                $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                            } elseif ($money >= 0) {
                                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                            }
                        } else {
                            if ($search_data['acset_inex_type'] == '2' || $money < 0) {
                                $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                                $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                                if ($search_data['acset_zero_plus_minus'] == '1') {
                                    $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                                } else {
                                    $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                                }
                            } else {
                                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额

                                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                                $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                                if ($search_data['acset_zero_plus_minus'] == '1') {
                                    $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                                } else {
                                    $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                                }
                            }
                        }
                    } else {
                        if ($search_data['acset_zero_price'] == '0') {
                            if ($search_data['acset_inex_type'] == '2' && $cz_type) {
                                $volo_data[0]['acsl_borrow_subject'] = '220201';//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = '应付账款';//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                            } elseif ($search_data['acset_inex_type'] == '2' && $money < 0 && !$cz_type) {
                                $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                            } else {
                                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = '220201';//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = '应付账款';//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                            }
                        } else {
                            if ($search_data['acset_inex_type'] == '2' || $money < 0) {
                                $volo_data[0]['acsl_borrow_subject'] = '220201';//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = '应付账款';//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '640101';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '主营业务成本';//借方科目名称
                                if ($search_data['acset_zero_plus_minus'] == '1') {
                                    $volo_data[1]['acsl_borrow_price'] = $search_data['acset_zero_price'] / 100;//借方金额
                                } else {
                                    $volo_data[1]['acsl_borrow_price'] = '-' . $search_data['acset_zero_price'] / 100;//借方金额
                                }
                                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                            } else {
                                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = '220201';//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = '应付账款';//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '640101';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '主营业务成本';//借方科目名称
                                if ($search_data['acset_zero_plus_minus'] == '1') {
                                    $volo_data[1]['acsl_borrow_price'] = $search_data['acset_zero_price'] / 100;//借方金额
                                } else {
                                    $volo_data[1]['acsl_borrow_price'] = '-' . $search_data['acset_zero_price'] / 100;//借方金额
                                }
                                $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                            }
                        }
                    }
                } else {
                    $volo_data[0]['acsl_borrow_subject'] = '';//借方科目
                    $volo_data[0]['acsl_borrow_subject_name'] = '';//借方科目名称
                    $volo_data[0]['acsl_borrow_price'] = 0;//借方金额
                    $volo_data[0]['acsl_loan_subject'] = '';//贷方科目
                    $volo_data[0]['acsl_loan_subject_name'] = '';//贷方科目名称
                    $volo_data[0]['acsl_loan_price'] = '';//贷方金额
                    $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                    $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                    $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                    $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                    $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                    $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                }
                break;
            case '26'://期初账单,收款；借：库存现金或银行存款 贷：应收账款
                // 若有抹零头的情况，抹零金额做冲减营业收入（例如应收505元，实际收500元，抹零5元，借：库存现金或银行存款500，贷：应收账款505，贷：主营业务收入-5）
                // 根据备注判断是期初应收,期初铺货还是期初应付,期初应收和期初铺货跟订单账单凭证一样,期初应付参照采购账单
                $find_orbi_data = DB::table('order_bill')
                    ->where('orbi_cid', $user_info->adm_cid)
                    ->where('orbi_shop_id', $user_info->adm_shop_id)
                    ->where('orbi_create_type', 4)
                    ->where('orbi_id', $search_data['acset_original_id'])
                    ->where('orbi_number', $search_data['acset_original_number'])
                    ->select('orbi_remark')
                    ->first();
                if ($find_orbi_data->orbi_remark == '期初应收' || $find_orbi_data->orbi_remark == '期初铺货') {
                    if (!empty($find_acti_data)) {
                        if ($search_data['acset_zero_price'] == '0') {
                            if ($search_data['acset_inex_type'] == '2') {
                                $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                            } else {
                                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                                $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                                $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                            }
                        } else {
                            if ($search_data['acset_inex_type'] == '2') {
                                $volo_data[0]['acsl_borrow_subject'] = '1122';//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = '应收账款';//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                                $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                                if ($search_data['acset_zero_plus_minus'] == '1') {
                                    $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                                } else {
                                    $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                                }
                            } else {
                                $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                                $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                                $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                                $volo_data[0]['acsl_loan_subject'] = '1122';//贷方科目
                                $volo_data[0]['acsl_loan_subject_name'] = '应收账款';//贷方科目名称
                                $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                                $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                                $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                                $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                                $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                                $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                                if ($search_data['acset_zero_plus_minus'] == '1') {
                                    $volo_data[1]['acsl_loan_price'] = $search_data['acset_zero_price'] / 100;//贷方金额
                                } else {
                                    $volo_data[1]['acsl_loan_price'] = '-' . $search_data['acset_zero_price'] / 100;//贷方金额
                                }
                            }
                        }
                    } else {
                        $volo_data[0]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[0]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[0]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[0]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[0]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[0]['acsl_loan_price'] = '';//贷方金额
                        $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                        $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                        $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                        $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                        $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                        $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                    }
                } elseif ($find_orbi_data->orbi_remark == '期初应付') {
                    // 若有抹零头的情况，抹零金额做冲减主营业成本（例如应收505元，实际收500元，抹零5元，借：应付账款500，贷：银行存款505，贷：主营业务成本-5）
                    if ($search_data['acset_zero_price'] == '0') {
                        if ($search_data['acset_inex_type'] == '2') {
                            $volo_data[0]['acsl_borrow_subject'] = '220201';//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应付账款';//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                            $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = '220201';//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应付账款';//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '';//借方科目名称
                            $volo_data[1]['acsl_borrow_price'] = 0;//借方金额
                            $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                        }
                    } else {
                        if ($search_data['acset_inex_type'] == '2') {
                            $volo_data[0]['acsl_borrow_subject'] = '220201';//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = '应付账款';//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $search_data['acset_price'] / 100;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = $find_acti_data->acti_subject_code;//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = $find_acti_data->acti_course_title;//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $voucher_price;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '640101';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '主营业务成本';//借方科目名称
                            if ($search_data['acset_zero_plus_minus'] == '1') {
                                $volo_data[1]['acsl_borrow_price'] = $search_data['acset_zero_price'] / 100;//借方金额
                            } else {
                                $volo_data[1]['acsl_borrow_price'] = '-' . $search_data['acset_zero_price'] / 100;//借方金额
                            }
                            $volo_data[1]['acsl_loan_subject'] = '';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '';//贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                        } else {
                            $volo_data[0]['acsl_borrow_subject'] = $find_acti_data->acti_subject_code;//借方科目
                            $volo_data[0]['acsl_borrow_subject_name'] = $find_acti_data->acti_course_title;//借方科目名称
                            $volo_data[0]['acsl_borrow_price'] = $voucher_price;//借方金额
                            $volo_data[0]['acsl_loan_subject'] = '220201';//贷方科目
                            $volo_data[0]['acsl_loan_subject_name'] = '应付账款';//贷方科目名称
                            $volo_data[0]['acsl_loan_price'] = $search_data['acset_price'] / 100;//贷方金额
                            $volo_data[1]['acsl_borrow_subject'] = '640101';//借方科目
                            $volo_data[1]['acsl_borrow_subject_name'] = '主营业务成本';//借方科目名称
                            if ($search_data['acset_zero_plus_minus'] == '1') {
                                $volo_data[1]['acsl_borrow_price'] = $search_data['acset_zero_price'] / 100;//借方金额
                            } else {
                                $volo_data[1]['acsl_borrow_price'] = '-' . $search_data['acset_zero_price'] / 100;//借方金额
                            }
                            $volo_data[1]['acsl_loan_subject'] = '600101';//贷方科目
                            $volo_data[1]['acsl_loan_subject_name'] = '主营业务收入';//贷方科目名称
                            $volo_data[1]['acsl_loan_price'] = 0;//贷方金额
                        }
                    }
                }
                break;
            default:
                return ['code'=> 500, 'msg'=>'error', 'vou_data'=>'', 'data'=>'凭证上传失败！'];
                break;
        }

        // 添加结款凭证接单的记录
        $volo_data[0]['acsl_acset_id'] = $vou_voucher_id;//结款明细凭证id
        $volo_data[0]['acsl_shop_id'] = $user_info->adm_shop_id;//门店id
        $volo_data[0]['acsl_type'] = 1;//类型1借方2贷方
        $volo_data[1]['acsl_acset_id'] = $vou_voucher_id;//结款明细凭证id
        $volo_data[1]['acsl_shop_id'] = $user_info->adm_shop_id;//门店id
        $volo_data[1]['acsl_type'] = 1;//类型1借方2贷方
        // dump($volo_data);die;
        if ($search_data['acset_type'] == 24 || $search_data['acset_type'] == 25) {
            $volo_data[0]['acsl_update_time'] = date('Y-m-d H:i:s');
            $volo_data[1]['acsl_update_time'] = date('Y-m-d H:i:s');
            $volo_id = DB::table('accounting_settlement_loan')
                ->where('acsl_acset_id', $search_data['acset_id'])
                ->delete();
            $volo_id = DB::table('accounting_settlement_loan')->insert($volo_data);
        } else {
            $volo_id = DB::table('accounting_settlement_loan')->insert($volo_data);
        }
        if ($volo_id) {
            return ['code'=>200, 'msg'=>'success', 'data'=>'凭证上传成功！'];
        } else {
            return ['code'=>500, 'msg'=>'error', 'data'=>'凭证上传失败！'];
        }
    }
}
